/**
 * @Author: Rainer Imb <consentio>
 * @Date:   2019-04-11 03:21:59
 * @Email:  imb@consentio.at
 * @Project: consentio mccurdy
 * @Filename: jQwys4.js
 * @Last modified by:   consentio
 * @Last modified time: 2023-09-01T12:18:05+02:00
 * @License: GPL 2.0
 */

(function($){
$.fn.wysiwym=function(options){

	// begin with options
	var jQwys={
		sid: false,
		base_url: "",
		//css-classes
		menuclass: "ed_toolbar",
		areaclass: "editor",
		pathclass: "ed_path",
		objects: "objects.js",
		tableclass: "withBorder",
		lang: "en",
		toolbars:[
		["code",
		"separator","paragraph","formats",
		"separator","left","center","right","justify",
		"separator","ol","ul","indent","outdent",
		"separator","bold","italic","underline","strike","sup","sub"],
		["undo","redo",
		"separator","link","unlink",, "separator",  "image", "table",
		"separator", "specialchar", "wai_tool", "hr", "footnote", "insertObjects",
		"separator","pastetext", "removeformat","striptags",
		"separator","wordcount","help", "about"]
		],
		toolbars_min:[
		["paragraph",
		"separator","left","center","right","justify",
		"separator","ol","ul",
		"separator","bold","italic",
		"separator","undo","redo",
		"separator", "wai_tool",
		"separator","pastetext", "removeformat","striptags",
		"separator","wordcount","help", "about"]
		],
		toolbars_text:[
		["paragraph",
		"separator","bold","italic",
		"separator","undo","redo",
		"separator", "link","unlink", "separator", "specialchar", "wai_tool",
		"separator","pastetext", "removeformat","striptags",
		"separator","wordcount","help", "about"]
		],
		config: "normal",
		link_caller: "index.php?_id=assistant&type=link",
		img_caller: "index.php?_id=assistant&type=image",
		img_upload: "index.php?_id=images&todo=edit&parent=1&_u=1",
		path: "/js/",
		imgdir : "images/",
		css: ["/css/forkawesome-all.min.css", "/css/wym2.min.css"],
		font: {"ol": "list-ol","ul": "list-ul", "left": "align-left","center": "align-center",
		"right": "align-right","justify": "align-justify", "wai_tool": "universal-access", "specialchar": "euro-sign",
		"strike": "strikethrough","sup": "superscript","sub": "subscript",  "insertObjects": "cubes",
		"pastetext": "paste", "removeformat": "eraser","striptags": "magic", "wordcount": "tachometer-alt",
		"help": "question-circle", "about": "info-circle", "hr": "minus", "footnote": "paw"
		}
		};

	// overwrite user's options
	jQwys = $.extend(jQwys, options);
	jQwys.browser = navigator.userAgent.toLowerCase();
	if(/msie [1-6]./.test(jQwys.browser)) {jQwys.notEdidable = 1;} // no more mess
	if(/msie/.test(jQwys.browser)) {jQwys.browser = "ie";}
	else if(/trident/.test(jQwys.browser)) {jQwys.browser = "ie11";} // brush your teeth?
	else if(/safari/.test(jQwys.browser)) {jQwys.browser = "safari";} // the big five...

	else {jQwys.browser = "w3c"} // in a perfect world...

	this.each(function(){
		var ojQwys = $(this);
		if (!jQwys.notEdidable) {init_editor(ojQwys)}
		else {alert("JQwys is not supported by your browser.\n");}
		});

	function init_editor(ed) {
		jQwys.id = ed.attr("id")
		jQwys.i18n = translate();
		ed.css('width', '100%');
		jQwys.h = ed.css('height');
		ed.wrap("<div id='"+jQwys.id+"_area' class='"+jQwys.areaclass+"'><div id='"+jQwys.id+"_container' style='width:100%;height:"+jQwys.h+";'></div></div>");
		oArea = $("#"+jQwys.id+"_area");
		oArea.prepend(toolbar());
		oArea.append("<div id='"+jQwys.id+"path' class='"+jQwys.pathclass+"'>"+jQwys.i18n['path']+":</div>");
		oArea.css({margin:"0.5em 0px"})
		$("#"+jQwys.id+"path").css({padding:"4px 0.5em"})
		$("li.tb").css({"display":"inline","margin": "2px", "padding": "4px", "list-style": "none"});
		$("ul."+jQwys.menuclass).css({"text-align":"left","margin": 0,"padding": "8px"});
		$("."+jQwys.id+"_html_button").each(function(){
			$(this).mouseover(function(){$(this).css({"background":"#ffffff"});});
			$(this).mouseout(function(){$(this).css({"background":"transparent"});});
			});
		$("li.tb").each(function() {
			if ($(this).attr('data-cmd')) {
				$(this).css('cursor', 'pointer');
				$(this).click(function(){command($(this).attr('data-cmd'))});
				}
			});
		$("#"+jQwys.id+"_formats").change(
				function(){command('format', $(this).val()); return true;}
				);
		design_mode(ed);
		}

	function translate() {
		if(!this.i18n) {
			try {
				eval($.ajax({url:jQwys.path+'lang/'
				+ jQwys.lang + '.js', async:false}).responseText);
				}
			catch(e) {
				alert("Apreciated language "+jQwys.lang+" is not available! Try lang: en, de etc.");
				}
			}
		return i18n;
		};

	// make toolbar
	function toolbar() {
		if (jQwys.config == "small") {jQwys.toolbars = jQwys.toolbars_min;}
		if (jQwys.config == "text") {jQwys.toolbars = jQwys.toolbars_text;}
		var tb = "";
		for(var k=0;k<jQwys.toolbars.length;k++){
			var toolbar = jQwys.toolbars[k];
			tb += "<ul class='"+jQwys.menuclass+"'>";
			for(var i=0;i<(toolbar.length);i++){
				//var img = jQwys.path+jQwys.imgdir+toolbar[i]+".png";
				var img = jQwys.font[toolbar[i]] || toolbar[i];
				if(undefined===toolbar[i]){continue;}
				else if(toolbar[i]==="separator"){tb += "<li class=\"seperator tb\">|</li>";}
				else if(toolbar[i]==="formats"){
					tb += "<li class='tb'><select id='"+jQwys.id+"_formats' class='tiny'>"
					+"<option value=''>-"+jQwys.i18n['Format']+"-</option>"
					+"<option value='p'>"+jQwys.i18n['paragraph']+"</option>"
					+"<option value='p.lead'>"+jQwys.i18n['paragraph']+" "+jQwys.i18n['lead']+"</option>"
					+"<option value='p.capital'>"+jQwys.i18n['paragraph']+" "+jQwys.i18n['capital']+"</option>"
					+"<option value='p.picturetext'>"+jQwys.i18n['paragraph']+" "+jQwys.i18n['itext']+"</option>"
					+"<option value='p.copyright'>"+jQwys.i18n['paragraph']+" "+jQwys.i18n['copyright']+"</option>"
					+"<option value='h1'>"+jQwys.i18n['Heading_1']+"</option>"
					+"<option value='h2'>"+jQwys.i18n['Heading_2']+"</option>"
					+"<option value='h3'>"+jQwys.i18n['Heading_3']+"</option>"
					+"<option value='h4'>"+jQwys.i18n['Heading_4']+"</option>"
					+"<option value='h5'>"+jQwys.i18n['Heading_5']+"</option>"
					+"<option value='h6'>"+jQwys.i18n['Heading_6']+"</option>"
					+"</select></li>";
				}
				else{
					tb += "<li data-cmd='"+toolbar[i]+"' id='"+toolbar[i]+"' class='"+jQwys.id+"_html_button tb'><i class='fas fa-"+img+" fa-lg' title='"+jQwys.i18n[toolbar[i]]+"'></i></li>";
					}
			}
			tb += "</ul>";
		}
		return tb;
		};

	function design_mode(ed) {
		try {
			var oIframe = $('<iframe>');
			oIframe.css({'border': 0, 'margin': 0, 'padding': 0, 'box-shadow': 'none', 'width': '100%', 'height': jQwys.h});
			oIframe.attr('id', jQwys.id+"_html");
			ed.parent().prepend(oIframe);
			jQwys.iefix = false; // clean ie's memory
			jQwys.iframe = oIframe[0];
			jQwys.idoc = oIframe[0].contentWindow.document;
			jQwys.idoc.designMode = "on";
			var text = ($("#"+jQwys.id).val() === "") ? "" : $("#"+jQwys.id).val();
			if(text === ""){text="<p><br /></p>";}
			var css = "";
			for(var i=0;i<(jQwys.css.length);i++){ css += "<link type='text/css' rel='stylesheet' href='" + jQwys.css[i] + "' />";}
			var base = (jQwys.base_url) ? "<base href='" + jQwys.base_url + "' />" : '';
			var text = "<!DOCTYPE html>"
			+"<html>"
			+"<head>" + base + css + "</head><body>" + text + "</body></html>";

			if(jQwys.browser == "ie"){
				if(text !== "") {jQwys.idoc.write(text);}
				jQwys.idoc.body.contentEditable = true;
				}
			else {
				jQwys.idoc.open('text/html', 'replace');
				jQwys.idoc.write(text);
				jQwys.idoc.close();
				}
			// finally it solves more problems as it causes: bold, italic, justify (align)
			jQwys.idoc.execCommand('styleWithCSS', false, true);
			// paragraph is paragraph
			jQwys.idoc.execCommand("defaultParagraphSeparator", false, "p");
			// events
			ed.parents('form').submit(function(){
				var html = $("#"+jQwys.id).is(":visible") ? ed.val() : jQwys.idoc.body.innerHTML;
				// strip away base_url
				if (jQwys.base_url) {html = html.replace(new RegExp(jQwys.base_url,"g"), "");}
				ed.val(html);
				});
			$(jQwys.idoc).click(uptodate);
			$(jQwys.idoc).keydown(function(e) {
				if (e.ctrlKey) {
					if (e.key == 'l') {command('lc'); e.preventDefault();}
					if (e.key == 'u') {command('uc'); e.preventDefault();}
					if (e.key == 'b') {command('bold'); e.preventDefault();}
					if (e.key == 'i') {command('italic'); e.preventDefault();}
					}
				});
			$(jQwys.idoc).keyup(uptodate);
			$(jQwys.idoc).on('paste', function(e) {
				var paste = e.originalEvent.clipboardData.getData('text/html');
				if (!paste) {paste = e.originalEvent.clipboardData.getData('text/plain')}
				paste = make_clean(paste);
				check = $('<div>').html(paste); var i = 0;
				check.children().each(function(){if (this.nodeType == 1){i = 1;}});
				if (i){
					var sel = get_selected_element();
					var block = $(sel).closest("table,p,h1,h2,h3,h4,h5,h6");
					block.before(paste);
					}
				else {replace_text(paste);}
				e.preventDefault();
				});
			ed.hide();
			}
		catch(e){
			alert("JQwys is not supported by your browser.");
			$("#"+jQwys.id).show();
			}
		}

	function uptodate(e){
		var node = get_selected_element();
		var tmp_node = node;
		var path = "";
		// create path
		while (tmp_node) {
			if(tmp_node.nodeType == 1){
				var tag = tmp_node.nodeName.toLowerCase()
				var id = $(tmp_node).attr('id');
				if(id) {tag += "#"+id;}
				var css = $(tmp_node).attr('class');
				if(css) {tag += "."+css;}
				var aHref = $(tmp_node).attr('href');
				if (aHref) {tag += " [<a href='"+aHref+"' target='_blank'>"+aHref+"</a>]"}
				if (path) {path = " &raquo; "+path}
				path = tag+path;
				}
			tmp_node = tmp_node.parentNode;
			}
		path = jQwys.i18n['path']+": "+path;
		$('#'+jQwys.id+'path').html(path);

		// update formatblock/style-box
		while (node.nodeType != 1) {node = node.parentNode;}
		var tag = node.nodeName.toLowerCase();
		while ($.inArray(tag, ["p","h1","h2","h3","h4","h6"]) == -1) {
			node = node.parentNode;
			if (node) {tag = node.nodeName.toLowerCase();}
			else {break;}
			}
		var css = $(node).attr('class');
		if($.inArray(css, ["lead", "capital", "picturetext", "copyright"]) != -1) {tag = tag+"."+css;}
		if($.inArray(tag, ["p","h1","h2","h3","h4","h6"]) != -1) {$("#"+jQwys.id+"_formats").val(tag);}
		};

// base: selection, range node
	function get_selected_element() {
		var node;
		var range = get_selection_range();
		node = range.commonAncestorContainer ? range.commonAncestorContainer : range.parentElement ? range.parentElement() : range.item(0);
		return node;
		}

	function get_selection() {
		var html;
		var rng = get_selection_range();
		if(rng) {
			if (window.getSelection) {
				var e = $('<div>').append(rng.cloneContents());
				html = e.html();
				}
			else {html = rng.htmlText;}
			}
		return html;
		};



	function get_selection_range() {
		var rng, node;
		var selection = jQwys.idoc;

		// for webkit, mozilla, opera
		if(window.getSelection) {
			rng = selection.getSelection().getRangeAt(0);
			}
		// for ie
		if(!node && document.selection && document.selection.createRange && document.selection.type != "None") {
			var selection = jQwys.idoc;
			var range = selection.getRangeAt ? selection.getRangeAt(0) : selection.createRange();
			rng = range.commonAncestorContainer ? range.commonAncestorContainer : range.parentElement ? range.parentElement() : range.item(0);
			// ie loses focus (in all versions %P) we try to remember him
			// in occasional situations
			jQwys.iefix = rng;
			}
		return rng;
		}

	function replace_text(html) {
		// remember ie
		restoreRange();
		jQwys.iframe.contentWindow.focus();
		var rng = get_selection_range();
		if(!rng) {return;}
		if (window.getSelection) {
			rng.deleteContents();
			rng.insertNode(rng.createContextualFragment(html));
			}
		else {
			if(rng.pasteHTML !== undefined) {rng.pasteHTML(html);}
			}
		}

	// remember ie who loses his focus
	function restoreRange() {
		if(jQwys.browser == 'ie'){if (jQwys.iefix) {jQwys.iefix.select();}}
		else if(jQwys.browser == 'ie11'){if (jQwys.iefix) {jQwys.idoc.getSelection().addRange(jQwys.iefix);}}
		}

// commands and functions

	function command(cmd, arg1) {
		if($("#"+jQwys.id+"_html").is(":visible")){jQwys.iframe.contentWindow.focus();}
		if(cmd==="code"){
			if($("#"+jQwys.id).is(":visible")){
				$("#"+jQwys.id).hide();
				$("#"+jQwys.id+"_html").show();
				$("li.tb").css({"opacity":"1"}); // do no workarounds for fuck ie
				design_mode($("#"+jQwys.id));
				}
			else {
				$("#"+jQwys.id).show();
				var html_text = jQwys.idoc.body.innerHTML;
				html_text = beautify(html_text);
				$("#"+jQwys.id).val(html_text);
				$("#"+jQwys.id+"_html").hide();
				$("li.tb").css({"opacity":"0.2"}); // do no workarounds for fuck ie
				$("#code").css({"opacity":"1"});
				$("#help").css({"opacity":"1"});
				$("#about").css({"opacity":"1"});
				$(jQwys.idoc).remove(); // ie bug?
				$(jQwys.iframe).remove();
				// too quick for ie... -> timeout
				window.setTimeout(function(){$("#"+jQwys.id).focus();}, 50);
				}
			}

		var cmds = {"center":"justifycenter","hr":"inserthorizontalrule","justify":"justifyfull","left":"justifyleft","ol":"insertorderedlist","right":"justifyright","strike":"strikethrough","sub":"subscript","sup":"superscript","ul":"insertunorderedlist"};
		cmd = cmds[cmd] || cmd;
		if (cmd == "paragraph") {cmd="format"; arg1="p";}
		if (cmd == "format"){
			jQwys.iframe.contentWindow.focus();
			if(arg1 != ""){
				// format with class
				if(/\./.test(arg1)){var tmpar = arg1.split("."); arg1=tmpar[0]; var css=tmpar[1];
				}
				restoreRange()
				jQwys.idoc.execCommand('FormatBlock', false, "<"+arg1+">");
				uptodate();
				var node = get_selected_element();
				while (node.nodeName.toLowerCase() != arg1.toLowerCase()) {node = node.parentNode;}
				if(css) {$(node).attr("class", css);}
				else {$(node).removeAttr("class");}
				}
			}
		// insert/edit link
		else if(cmd==="link"){
			var sele = get_selected_element();
			var sel = get_selection();
			if(sel.length <= 0) {no_sel(); return false;}
			var tmp = $('<span></span>').append(sel);
			var anch = $('a', tmp);
			// selected images
			if (sele.nodeName.toLowerCase() == 'a') {anch = $('img', sele).parent('a');};
			var target = anch.attr('target') || "";
			var title = anch.attr('title') || "";
			var ref = anch.attr('href') || "http://";
			var check = "";
			if (target) {check = " selected='selected'"}
			var html = "<h2>"+jQwys.i18n['link']+"</h2>"
			+"<div class='dlgtext'>"
			+"<p><label for='"+jQwys.id+"_prm_link'>"+jQwys.i18n['URL']+" </label>"
			+"<input id='"+jQwys.id+"_prm_link' name='target' value='"+ref+"' size='40' class='text' />&nbsp;";

			if (jQwys.link_caller) {
				html += "<i id='call' title='edit' class='fas fa-link fa-lg'></i>";
				}
			html += "</p><p><label for='"+jQwys.id+"_prm_title'>"+jQwys.i18n['Title']+" </label>"
			+"<input id='"+jQwys.id+"_prm_title' value='"+title+"' size='40' class='text' /></p>"
			+"<p><label for='"+jQwys.id+"_prm_target'>"+jQwys.i18n['Target']+" </label>"
			+"<span class='selectwrap'><select id='"+jQwys.id+"_prm_target'><option value=''>"+jQwys.i18n['default']+"</option><option value='_blank'"+check+">"+jQwys.i18n['new_target']+"</option></select></span>"
			+"<p><button id='"+jQwys.id+"_cancel'>"+jQwys.i18n['cancel']+"</button>&nbsp;"
			+"<button id='"+jQwys.id+"_ok'>"+jQwys.i18n['ok']+"</button></p>"
			+"</div>";
			dialog(html,35,20);
			$("#"+jQwys.id+"_ok").click(function(){
				var url = $("#"+jQwys.id+"_prm_link").val();
				var title = $("#"+jQwys.id+"_prm_title").val();
				var target = $("#"+jQwys.id+"_prm_target").val();
				// remember ie
				restoreRange();
				jQwys.idoc.execCommand("unlink", false, null); // avoid double link
				var tmp = $('<a>').append(get_selection());
				//alert (tmp.html());
				tmp.attr('href', url);
				if(target.length > 0) {tmp.attr('target', target);}
				else {tmp.removeAttr('target');}
				if(title.length > 0) {tmp.attr('title', title);}
				else{tmp.removeAttr('title');}
				tmp = $('<span>').append(tmp);
				replace_text(tmp.html());
				$("#"+jQwys.id+"_dlg").fadeOut(200);
				})
			if ($("#call")) {
				$("#call").css('cursor', 'pointer');
				$("#call").click(function(){
					var oIframe = '<iframe width="800" height="500" src="'+jQwys.link_caller+'&sid='+jQwys.sid+'&target='+jQwys.id+'_prm_link">&nbsp;</iframe>';
					$('#site').popUp({'header': jQwys.i18n['link'], 'body': oIframe, 'top': '10%', 'left': '10%', 'id': 'pp'+jQwys.id+'_prm_link'});
					});
				}
			$("#"+jQwys.id+"_cancel").click(function(){$("#"+jQwys.id+"_dlg").fadeOut(200);})
			}

		// insert special character
		else if(cmd==="specialchar") {
			var html = "<h2>"+jQwys.i18n['specialchar']+"</h2>"
			+"<div class='dlgtext'>";
			var chars = ["&euro;","&lsquo;","&rsquo;","&rsquo;","&ldquo;","&rdquo;","&ndash;","&mdash;","&iexcl;","&cent;","&pound;","&curren;","&yen;","&brvbar;","&sect;","&uml;","&copy;","&ordf;","&laquo;","&not;","&reg;","&macr;","&deg;","&plusmn;","&sup2;","&sup3;","&acute;","&micro;","&para;","&middot;","&times;","&cedil;","&sup1;","&ordm;","&raquo;","&frac14;","&frac12;","&frac34;","&iquest;","&Agrave;","&Aacute;","&Acirc;","&Atilde;","&Auml;","&Aring;","&AElig;","&Ccedil;","&Egrave;","&Eacute;","&Ecirc;","&Euml;","&Igrave;","&Iacute;","&Icirc;","&Iuml;","&ETH;","&Ntilde;","&Ograve;","&Oacute;","&Ocirc;","&Otilde;","&Ouml;","&times;","&Oslash;","&Ugrave;","&Uacute;","&Ucirc;","&Uuml;","&Yacute;","&THORN;","&szlig;","&agrave;","&aacute;","&acirc;","&atilde;","&auml;","&aring;","&aelig;","&ccedil;","&egrave;","&eacute;","&ecirc;","&euml;","&igrave;","&iacute;","&icirc;","&iuml;","&eth;","&ntilde;","&ograve;","&oacute;","&ocirc;","&otilde;","&ouml;","&divide;","&oslash;","&ugrave;","&uacute;","&ucirc;","&uuml;","&uuml;","&yacute;","&thorn;","&yuml;","&OElig;","&oelig;","&#372;","&#374","&#373","&#375;","&sbquo;","&#8219;","&bdquo;", "&trade;","&#9658;","&bull;", "&diams;","&asymp;",
				"&Alpha;", "&alpha;", "&Beta;", "&beta;", "&Gamma;", "&gamma;", "&Delta;", "&delta;", "&Epsilon;", "&epsilon;", "&Zeta;", "&zeta;", "&Eta;", "&eta;", "&Theta;", "&theta;", "&Iota;", "&iota;", "&Kappa;", "&kappa;", "&Lambda;", "&lambda;", "&Mu;", "&mu;", "&Nu;", "&nu;", "&Xi;", "&xi;", "&Omicron;", "&omicron;", "&Pi;", "&pi;", "&Rho;", "&rho;", "&Sigma;", "&sigmaf;", "&sigma;", "&Tau;", "&tau;", "&Upsilon;", "&upsilon;", "&Phi;", "&phi;", "&Chi;", "&chi;", "&Psi;", "&psi;", "&Omega;", "&omega;", "&thetasym;", "&upsih;", "&piv;",
				"&forall;", "&part;", "&exist;", "&empty;", "&nabla;", "&isin;", "&notin;", "&ni;", "&prod;", "&sum;", "&minus;", "&lowast;", "&radic;", "&prop;", "&infin;", "&ang;", "&and;", "&or;", "&cap;", "&cup;", "&int;", "&there4;", "&sim;", "&cong;", "&asymp;", "&ne;", "&equiv;", "&le;", "&ge;", "&sub;", "&sup;", "&nsub;", "&sube;", "&supe;", "&oplus;", "&otimes;", "&empty;", "&perp;", "&sdot;", "&loz;",
				"&larr;", "&uarr;", "&rarr;", "&darr;", "&harr;", "&crarr;", "&lArr;", "&uArr;", "&rArr;", "&dArr;", "&hArr;", "&#8470;"];
			var i = 0 ;
			while (i < chars.length) {
				if (chars[i]) {var ent = chars[i].replace(/&/g, '&amp;'); html += "<div title='"+ent+"' class='char'>"+chars[i]+"</div>";}
				i++;
				}
			html += "<p class='clrfx'><br /><button id='"+jQwys.id+"_cancel'>"+jQwys.i18n['cancel']+"</button>&nbsp;"
			+"</div>";
			dialog(html,50,35);
			var bgc = $("div.char").css('background-color');
			$("div.char").css({"cursor": "pointer", "font-size": "1.2em", "text-align": 'center', "float": "left", "width": "2em", "height": "1.5em", "border": "1px solid #c0c0c0", "margin": "1px 1px 0 0"});
			$("div.char").hover(
				function(){$(this).css('background-color', 'highlight')},
				function(){$(this).css('background-color', bgc);}
				);
			$("div.char").click(function(){
				replace_text(this.title);
				$("#"+jQwys.id+"_dlg").fadeOut(200);
				})
			$("#"+jQwys.id+"_cancel").click(function(){$("#"+jQwys.id+"_dlg").fadeOut(1000);})
			}

		// insert a html-object
		else if(cmd==="insertObjects") {
			var sel = get_selected_element();
			var html = "<h2>"+jQwys.i18n['insertObjects']+"</h2>"
			+"<div class='dlgtext'>";
			oHTML = get_objects();
			html += '<ul class="img">';
			for (var oO in oHTML) {
				html += '<li class="objHtml" title="'+oO+'">'+oHTML[oO]['cap']+'</li>';
				}
			html += '</ul>';
			html += "<p><button id='"+jQwys.id+"_cancel'>"+jQwys.i18n['cancel']+"</button>&nbsp;"
			+"</div>";
			dialog(html,30,30);
			$("li.objHtml").click(function(){
				var oH = this.title;
				var block = $(sel).closest("table,p,h1,h2,h3,h4,h5,h6");
				block.before(oHTML[oH]['html']);
				$("#"+jQwys.id+"_dlg").fadeOut(200);
				})
			$("li.objHtml").css('cursor', 'pointer')
			$("#"+jQwys.id+"_cancel").click(function(){$("#"+jQwys.id+"_dlg").fadeOut(1000);})
			}

		else if(cmd==="pastetext"){
			var html = "<h2>"+jQwys.i18n['pastetext']+"</h2>"
			+"<div class='dlgtext'>"
			+"<p><label for='"+jQwys.id+"_tag'>"+jQwys.i18n['text']+"</label><br />"
			+"<textarea id='"+jQwys.id+"_input' cols='60' rows='12'></textarea>"
			+"<p><button id='"+jQwys.id+"_cancel'>"+jQwys.i18n['cancel']+"</button>&nbsp;"
			+"<button id='"+jQwys.id+"_ok'>"+jQwys.i18n['ok']+"</button></p>"
			+"</div>";
			dialog(html,40,30);
			$("#"+jQwys.id+"_ok").click(function(){
				var input = $("#"+jQwys.id+"_input").val();
				var obj = $('<span></span>');
				input = input.replace(/\&nbsp;/g, " ");
				input = input.replace( /\s{2,}/g, ' ');
				input = input.replace( /\n{2,}/g, '');
				input = input.replace( /\n$/g, '');
				input = input.replace( /^\n$/g, '');
				input = input.replace(/\n/g, "<br />");
				obj.append(input)
				replace_text(obj.html())
				$("#"+jQwys.id+"_dlg").fadeOut(400);
				})
			$("#"+jQwys.id+"_cancel").click(function(){$("#"+jQwys.id+"_dlg").fadeOut(1000);})
			}

		else if (cmd == "wai_tool"){
			var sel = get_selection()
			if(sel.length <= 0) {
				no_sel();
				return false;
				}
			var tmp = $('<span></span>').append(sel);
			var tag = "span";
			if ($(tmp).find('acronym').length > 0){tag = "acronym";}
			if ($(tmp).find('abbr').length > 0) {tag = "abbr";}
			var title = $(tag, tmp).attr('title') || "";
			var lang = $(tag, tmp).attr('lang') || "";
			var check = {'span':"", 'abbr':"", 'acronym':""};
			check[tag] = " selected='selected'";
			var langs = {" English ":"en"," French ":"fr"," Spanish ":"es"," German ":"de","-":"","Afrikaans ":"af","Albanian ":"sq","Arabic ":"ar","Basque ":"eu","Breton ":"br","Bulgarian ":"bg","Belarusian ":"be","Catalan ":"ca","Chinese ":"zh","Croatian ":"hr","Czech ":"cs","Danish ":"da","Dutch ":"nl","English ":"en","Estonian ":"et","Faeroese ":"fo","Farsi ":"fa","Finnish ":"fi","French ":"fr","Gaelic ":"gd","German ":"de","Greek ":"el","Hebrew ":"he","Hindi ":"hi","Hungarian ":"hu","Icelandic ":"is","Indonesian ":"id","Italian ":"it","Japanese ":"ja","Korean ":"ko","Latvian ":"lv","Lithuanian ":"lt","Macedonian ":"mk","Malaysian ":"ms","Maltese ":"mt","Norwegian ":"no","Polish ":"pl","Portuguese ":"pt","Rhaeto-Romanic ":"rm","Romanian ":"ro","Russian ":"ru","Sami ":"sz","Serbian ":"sr","Setswana ":"tn","Slovak ":"sk","Slovenian ":"sl","Spanish ":"es","Sutu ":"sx","Swedish ":"sv","Thai ":"th","Tsonga ":"ts","Turkish ":"tr","Ukrainian ":"uk","Urdu ":"ur","Vietnamese ":"vi","Xhosa ":"xh","Yiddish ":"yi","Zulu":"zu"}
			var html = "<h2>"+jQwys.i18n['wai_tool']+"</h2>"
			+"<div class='dlgtext'>"
			+"<p><label for='"+jQwys.id+"_tag'>"+jQwys.i18n['tag']+"</label><br />"
			+"<span class='selectwrap'><select id='"+jQwys.id+"_tag'>"
			html += "<option value='abbr'"+check['abbr']+">"+jQwys.i18n['abbr']+"</option>";
			html += "<option value='acronym'"+check['acronym']+">"+jQwys.i18n['acr']+"</option>"
			+"<option value='span'"+check['span']+">"+jQwys.i18n['language']+"</option>"
			+"</select></span></p>"
			+"<p id='"+jQwys.id+"skip'><label for='"+jQwys.id+"_title'>"+jQwys.i18n['text']+"</label><br />"
			+"<input id='"+jQwys.id+"_title' type='text' value='"+title+"'  class='text' /></p>"
			+"<p><label for='"+jQwys.id+"_lang'>"+jQwys.i18n['language']+"</label><br />"
			+"<span class='selectwrap'><select id='"+jQwys.id+"_lang'></select></span></p>"
			+"<p><button id='"+jQwys.id+"_cancel'>"+jQwys.i18n['cancel']+"</button>&nbsp;"
			+"<button id='"+jQwys.id+"_ok'>"+jQwys.i18n['ok']+"</button></p>"
			+"</div>";
			dialog(html,30,20);
			for(i in langs) {
				var selectme = "";
				if (langs[i] === lang) {selectme = " selected='selected'"}
				$("#"+jQwys.id+"_lang").append("<option value='"+langs[i]+"'"+selectme+">"+i+"</option>")
				}
			if (tag === "span") {$("#"+jQwys.id+"skip").hide();}
			$("#"+jQwys.id+"_tag").change(function(){
				var itag = $("#"+jQwys.id+"_tag").val();
				if (itag === "span") {$("#"+jQwys.id+"skip").slideUp(500);}
				else{$("#"+jQwys.id+"skip").slideDown(500);}
				});
			$("#"+jQwys.id+"_ok").click(function(){
				var tag = $("#"+jQwys.id+"_tag").val();
				var lang = $("#"+jQwys.id+"_lang").val();
				var title = $("#"+jQwys.id+"_title").val();
				var obj = $('<span></span>');
				var tmp = ($("<"+tag+">"+get_selection()+"</"+tag+">"));
				if (lang) {tmp.attr("lang", lang);tmp.attr("class", "langatt");}
				if (title) {tmp.attr("title", title);}
				obj.append(tmp)
				replace_text(obj.html())
				$("#"+jQwys.id+"_dlg").fadeOut(400);
				})
			$("#"+jQwys.id+"_cancel").click(function(){$("#"+jQwys.id+"_dlg").fadeOut(1000);})
			}

		else if(cmd==="striptags"){
			var sel = get_selection();
			if(sel.length <= 0) {
				jQwys.idoc.execCommand("selectAll", false, false);
				sel = get_selection();
				}

			sel = make_clean(sel);
			replace_text(sel);
			}

		else if(cmd==="removeformat"){
			var sel = get_selection();
			if(sel.length <= 0) {
				jQwys.idoc.execCommand("selectAll", false, false);
				sel = get_selection();
				}
			sel = sel.replace(/(<([^>]+)>)/ig,"");
			sel = sel.replace( /\s{2,}/g, ' ');
			//sel = "<p>"+sel+"</p>";
			replace_text(sel);
			}
		else if(cmd==="lc"){
			var sel = get_selection();
			sel = sel.toLowerCase();
			replace_text(sel);
			}
		else if(cmd==="uc"){
			var sel = get_selection();
			sel = sel.toUpperCase();
			replace_text(sel);
			}
		else if(cmd==="wordcount"){
			var sel = get_selection();
			if(sel.length <= 0) {
				// remember ie
				restoreRange();
				jQwys.idoc.execCommand("selectAll", false, false);
				sel = get_selection();
				}
			var chars = sel.length;
			sel =sel.replace(/<\/?\s*!--[^-->]*-->/gi,"");
			sel=sel.replace(/<(.+?)>/g," ");
			sel=sel.replace(/&nbsp;/gi," ");
			sel=sel.replace(/([\n\r\t])/g," ");
			sel=sel.replace(/(  +)/g," ");
			sel=sel.replace(/&(.*);/g," ");
			sel=sel.replace(/^\s*|\s*$/g,"");
			var chars2 = sel.length;
			var words = 1;
			for(var x=0;x<sel.length;x++){
				if(sel.charAt(x)==" "){words++;}
				}
			var html = '<h2>'+jQwys.i18n['wordcount']+'</h2>'
			+"<div class='dlgtext'>"
			+'<ul>'
			+'<li><strong>'+jQwys.i18n['chars']+'</strong>: '+chars2
			+'<li><strong>'+jQwys.i18n['words']+'</strong>: '+words
			+'<li><strong>'+jQwys.i18n['Source_Code']+'</strong>: '+chars
			+'</ul>'
			+'<button onclick="$(\'#'+jQwys.id+'_dlg\').fadeOut(400);">'+jQwys.i18n['ok']+'</button>'
			+"</div>";
			dialog(html,25,15);
			}

		else if(cmd==="about"){
			var html = '<h2>'+jQwys.i18n['about']+'</h2>'
			+"<div class='dlgtext'>"
			+"<p class='center'><img src='"+jQwys.path+jQwys.imgdir+"jqwys.gif' alt='JQwys'></p>"
			+"<p>Version 4.0</p>"
			+"<p>"+jQwys.i18n['jQwys']+"</p>"
			+"<p>IMB Webdevelopment</p>"
			+"<p>GPL 2.0</p>"
			+'<button onclick="$(\'#'+jQwys.id+'_dlg\').fadeOut(400);">'+jQwys.i18n['ok']+'</button>'
			+"</div>";
			dialog(html,25,30);
			}

		else if(cmd==="help"){
			var html = '<h2>'+jQwys.i18n['help']+'</h2>'
			+"<div class='dlgtext'>";
			html += '<button onclick="$(\'#'+jQwys.id+'_dlg\').fadeOut(400);">'+jQwys.i18n['ok']+'</button>';
			for(var k=0;k<jQwys.toolbars.length;k++){
				var toolbar = jQwys.toolbars[k];
				for(var i=0;i<(toolbar.length);i++){
					var img = jQwys.font[toolbar[i]] || toolbar[i];
					if(undefined===toolbar[i]){continue;}
					else if(toolbar[i]==="separator"){html += "<hr />";}
					else if(toolbar[i]==="formats"){html += "<p>"+jQwys.i18n['Format']+"</p>";}
					else {html += "<p><span class='grey'><i class='fas fa-"+img+" fa-lg'></i></span>&nbsp;"+jQwys.i18n[toolbar[i]]+"</p>";}
					}
				}
		html += '<button onclick="$(\'#'+jQwys.id+'_dlg\').fadeOut(400);">'+jQwys.i18n['ok']+'</button>'
		+"</div>";
		dialog(html,50,30);
		}

		else if(cmd==="footnote"){
			var obj = this;
			var html = '<h2>'+jQwys.i18n['footnote']+'</h2>'
			+"<div class='dlgtext'>"
			+"<p><label for='"+jQwys.id+"_prm_text'>"+jQwys.i18n['ftntext']+" </label><br />"
			+"<textarea id='"+jQwys.id+"_prm_text' cols='65' rows='5' class='text'></textarea></p>"
			+"<p><button id='"+jQwys.id+"_cancel'>"+jQwys.i18n['cancel']+"</button>&nbsp;"
			+"<button id='"+jQwys.id+"_ok'>"+jQwys.i18n['ok']+"</button></p>"
			+"</div>";
			dialog(html,20,20);

			$("#"+jQwys.id+"_ok").click(function(){
				var ftntext = $("#"+jQwys.id+"_prm_text").val();
				replace_text("<a href='#ftnx' id='aftnx' class='aftn'>x</a>");
				var notes = new Array;
				jQwys.idoc.execCommand("selectAll", false, false);
				var text = get_selected_element();
				var corr = 0;
				$.each($('a.aftn', text), function(i,n) {
					var ftn = parseInt(i+1);
					var val = $(this).html();
					var elem = $(this);
					elem.empty();
					elem.append("<sup>"+ftn+")</sup>");
					elem.attr('id', "aftn"+i);
					elem.attr('href', "#ftn"+i);
					if (val === "x") {notes.push(ftntext); corr= 1}
					else {notes.push($('#pftn'+parseInt(i-corr), text).html());}
					});
				$('div.footnote', text).remove();
				text = $(text).html();
				text += "<div class='footnote'><hr class='fnline' />";
				for (var i = 0; i < notes.length; i++) {
					text += "<p><a href='#aftn"+i+"' id='ftn"+i+"' class='ftn'>&uarr;</a> "+parseInt(i+1)+") <span id='pftn"+i+"'>"+notes[i]+"</span></p>";
					}
				text += "</div>";
				replace_text(text);
				$("#"+jQwys.id+"_dlg").fadeOut(400);
				});

			$("#"+jQwys.id+"_cancel").click(function(){$("#"+jQwys.id+"_dlg").fadeOut(400);})
			}

		else if(cmd ==="table") {
			var sel = get_selected_element();
			var html = "<h2>"+jQwys.i18n['table']+"</h2>"
			+"<div class='dlgtext'>"
			+"<p><label for='"+jQwys.id+"_prm_capt'>"+jQwys.i18n['Caption']+" </label><br />"
			+"<input id='"+jQwys.id+"_prm_capt' value='' size='40' class='text' /></p>"
			+"<p><label for='"+jQwys.id+"_prm_cols'>"+jQwys.i18n['cols']+" </label>"
			+"<input id='"+jQwys.id+"_prm_cols'value='4' size='2' class='text' /></p>"
			+"<p><label for='"+jQwys.id+"_prm_rows'>"+jQwys.i18n['rows']+" </label>"
			+"<input id='"+jQwys.id+"_prm_rows' value='8' size='2' class='text' /></p>"
			+"<p><label for='"+jQwys.id+"_prm_cols_head'>"+jQwys.i18n['Table_Header']+" </label>"
			+"<input type='checkbox' id='"+jQwys.id+"_prm_cols_head' checked='checked' /></p>"
			+"<p><label for='"+jQwys.id+"_prm_rows_head'>"+jQwys.i18n['Table_Rows']+" </label>"
			+"<input type='checkbox' id='"+jQwys.id+"_prm_rows_head' checked='checked' /></p>"
			+"<p><button id='"+jQwys.id+"_cancel'>"+jQwys.i18n['cancel']+"</button>&nbsp;"
			+"<button id='"+jQwys.id+"_ok'>"+jQwys.i18n['ok']+"</button></p>"
			+"</div>";
			dialog(html,35,30);
			$("#"+jQwys.id+"_ok").click(function(){
				var cols = $("#"+jQwys.id+"_prm_cols").val() || 2;
				var rows = $("#"+jQwys.id+"_prm_rows").val() || 4;
				var capt = $("#"+jQwys.id+"_prm_capt").val();
				var thr = $("#"+jQwys.id+"_prm_rows_head:checked").val() || "";
				var thc = $("#"+jQwys.id+"_prm_cols_head:checked").val() || "";
				var width = parseInt(100/cols);
				var table = $("<table />");
				if (jQwys.tableclass) {table.attr('class', jQwys.tableclass);}
				table.css('width', '98%');
				if (capt) {table.append("<caption>"+capt+"</caption>");}
				for(x=0; x<rows; x++) {
					var row = $("<tr></tr>");
					for(y=0; y<cols; y++) {
						if (x===0 && thc=='on'){row.append("<th style='width:"+width+"%' scope='col'><br /></th>\n")}
						else if (y===0 && thr=='on'){row.append("<th style='width:"+width+"%' scope='row'><br /></th>\n")}
						else {row.append("<td style='width:"+width+"%'><br /></td>\n")}
						}
					table.append(row)
					}
				var block = $(sel).closest("table,p,h1,h2,h3,h4,h5,h6");
				block.before(table);
				$("#"+jQwys.id+"_dlg").fadeOut(400);
				})
			$("#"+jQwys.id+"_cancel").click(function(){$("#"+jQwys.id+"_dlg").fadeOut(1000);})
			}

		// insert/edit image
		else if(cmd==="image"){
			var sel = get_selected_element();
			var src = $('img', sel).attr('src') || "http://";
			var prev = $('img', sel).attr('src') || jQwys.path+jQwys.imgdir+"noimg.png";
			var alt = $('img', sel).attr('alt') || "";
			var name = $('img', sel).attr('name') || false;
			var check = {'none':" checked='checked'", 'left':"", 'right':"", 'linked':"", 'normal':"", 'cinamescope':"", 'small':"", 'square':"", 'thumbs':"", 'clearfix':""};
			var orig = "normal";
			if (src.match(/\/small\//g)) {orig = "small"}
			else if (src.match(/\/thumbs\//g)) {orig = "thumbs"}
			else if (src.match(/\/cinemascope\//g)) {orig = "cinemascope"}
			else if (src.match(/\/square\//g)) {orig = "square"}
			check[orig] = " checked='checked'";
			var html = "<h2>"+jQwys.i18n['image']+"</h2>"
			+"<div class='dlgtext'>"
			+"<img id='"+jQwys.id+"_thumb' src='"+prev+"' align='right' alt=' ' width='48' height='48' />"
			+"<p><label for='"+jQwys.id+"_prm_src'>"+jQwys.i18n['URL']+" </label><br />"
			+"<input id='"+jQwys.id+"_prm_src' value='"+src+"' size='40' class='text' />&nbsp;";
			var addon = "";
			var wfo = $('img', sel).parent("div");
			if ($('img', sel).parent().is("a")) {
				wfo = $('img', sel).parent("a").parent("div")
				check['linked'] = " checked='checked'";
				};

			var picturetext = wfo.children(".picturetext").text();
			var copyright = wfo.children(".copyright").text();
			copyright = copyright.replace(/^\S*\s/, ''); // remove &copy;
			var align = $('img', sel).attr('class') || wfo.attr('class') || "none";
			align = align.replace(/float/, ''); // div class is different to img class
			if (align) {check[align] = " checked='checked'"}
			if ($('img', sel).parent('p,h1,h2,h3,h4,h5,h6').hasClass('clrfx')) {check['clearfix'] = " checked='checked'"}
			if (wfo.next('p,h1,h2,h3,h4,h5,h6').hasClass('clrfx')) {check['clearfix'] = " checked='checked'"}
			if (jQwys.img_caller) {
				html += "<i id='call' title='"+jQwys.i18n['image_select']+"' class='fas fa-image fa-lg'></i>&nbsp;&nbsp;";
				html += "<i id='upload' title='"+jQwys.i18n['image_upload']+"' class='fas fa-upload fa-lg'></i>";
				addon = "<fieldset id='img_addon'><legend>"+jQwys.i18n['size']+"</legend>"
			+"<input id='sisq' type='radio' name='size' value='square'"+check['square']+" />&nbsp;"
			+"<label for='sisq'>"+jQwys.i18n['square']+"</label>&nbsp;|&nbsp;"
			+"<input id='sith' type='radio' name='size' value='thumbs'"+check['thumbs']+" />&nbsp;"
			+"<label for='sith'>"+jQwys.i18n['small']+"</label>&nbsp;|&nbsp;"
			+"<input id='sism' type='radio' name='size' value='small'"+check['small']+" />&nbsp;"
			+"<label for='sism'>"+jQwys.i18n['medium']+"</label>&nbsp;|&nbsp;"
			+"<input id='sico' type='radio' name='size' value='cinemascope'"+check['cinemascope']+" />&nbsp;"
			+"<label for='sico'>"+jQwys.i18n['cinemascope']+"</label>&nbsp;|&nbsp;"
			+"<input id='sino' type='radio' name='size' value='normal'"+check['normal']+" />&nbsp;"
			+"<label for='sino'>"+jQwys.i18n['big']+"</label>&nbsp;"
			+"<br /><input type='checkbox' id='"+jQwys.id+"_prm_resize'"+check['linked']+" />"
			+"&nbsp;<label for='"+jQwys.id+"_prm_resize'>"+jQwys.i18n['resize']+" </label>"
			+"</fieldset>";
				}
			html += "</p><p><label for='"+jQwys.id+"_prm_alt'>"+jQwys.i18n['Alternative_Text']+" </label><br />"
			+"<input id='"+jQwys.id+"_prm_alt' value='"+alt+"' size='50' class='text' /></p>"
			+addon;

			html += "<fieldset id='fsImage'><legend>"+jQwys.i18n['float']+"</legend>"
			+"<input id='noal' type='radio' name='ratio' value='' "+check['none']+" /> <label for='noal'>"+jQwys.i18n['default']+"</label>"
			+"<input id='ileft' type='radio' name='ratio' value='left' "+check['left']+" /> <label for='ileft'>"+jQwys.i18n['left']+"</label>"
			+"<input id='iright' type='radio' name='ratio' value='right' "+check['right']+" /> <label for='iright'>"+jQwys.i18n['right']+"</label>"
			+" | <label for='"+jQwys.id+"_prm_clear'>"+jQwys.i18n['clearfix']+" </label>"
			+ "<input id='"+jQwys.id+"_prm_clear' type='checkbox' "+check['clearfix']+" />"
			+"</fieldset>"
			+"<p><label for='"+jQwys.id+"_prm_pt'>"+jQwys.i18n['itext']+" </label><br />"
			+"<textarea id='"+jQwys.id+"_prm_pt' cols='50' rows='2' class='text'>"+picturetext+"</textarea></p>"
			+"<p><label for='"+jQwys.id+"_prm_cop'>"+jQwys.i18n['copyright']+" </label><br />"
			+"<input id='"+jQwys.id+"_prm_cop' size='50' value='"+copyright+"' class='text' /></p>"

			html += "<p><button id='"+jQwys.id+"_cancel'>"+jQwys.i18n['cancel']+"</button>&nbsp;"
			+"<button id='"+jQwys.id+"_ok'>"+jQwys.i18n['ok']+"</button></p>"
			+"</div>";
			dialog(html,45,48);
			if ($("#call")) {
				$("#call").css('cursor', 'pointer');
				$("#call").click(function(){
				/* var link = window.open(jQwys.img_caller+"&target="+jQwys.id, "foo","width=800,height=550,resizable=yes,status=yes,scrollbars=yes,screenx=50,screeny=50" )
				link.focus() */
				var oIframe = '<iframe width="800" height="500" src="'+jQwys.img_caller+'&sid='+jQwys.sid+'&target='+jQwys.id+'_prm_src">&nbsp;</iframe>';
				$('#site').popUp({'header': jQwys.i18n['image_select'], 'body': oIframe, 'top': '10%', 'left': '10%', 'id': 'pp'+jQwys.id+'_prm_src'});
				$('#'+jQwys.id+'_prm_src').focus(function(){if ($('#'+jQwys.id+'_prm_src').val()) {$('#'+$('#'+jQwys.id+'_thumb').attr('id')).attr('src', $('#'+jQwys.id+'_prm_src').val());}});});
				}
			if ($("#upload")) {
				$("#upload").css('cursor', 'pointer');
				$("#upload").click(function(){
				var oIframe = '<iframe width="780" height="350" src="'+jQwys.img_upload+'&sid='+jQwys.sid+'&target='+jQwys.id+'_prm_src">&nbsp;</iframe>';
				$('#site').popUp({'header': jQwys.i18n['image_upload'], 'body': oIframe, 'top': '10%', 'left': '10%', 'id': 'pp'+jQwys.id+'_prm_src'});
				$('#'+jQwys.id+'_prm_src').focus(function(){if ($('#'+jQwys.id+'_prm_src').val()) {$('#'+$('#'+jQwys.id+'_thumb').attr('id')).attr('src', $('#'+jQwys.id+'_prm_src').val());}});});
				}
			$("#"+jQwys.id+"_ok").click(function(){
				var isObject = false;
				var src = $("#"+jQwys.id+"_prm_src").val();
				var orig = "normal";
				if (src.match(/\/small\//g)) {orig = "small"}
				else if (src.match(/\/thumbs\//g)) {orig = "thumbs"}
				else if (src.match(/\/cinemascope\//g)) {orig = "cinemascope"}
				else if (src.match(/\/square\//g)) {orig = "square"}
				var alt = $("#"+jQwys.id+"_prm_alt").val() || " "; //empty allowed, missing not'
				var align = $("input:radio[name='ratio']:checked").val();
				var clear = $("#"+jQwys.id+"_prm_clear:checked").val() || 0;
				var cop = $("#"+jQwys.id+"_prm_cop").val() || 0;
				var itext = $("#"+jQwys.id+"_prm_pt").val() || 0;
				var resize = $("#"+jQwys.id+"_prm_resize:checked").val() || 0;
				// adopt src according to size
				var size = $("input:radio[name='size']:checked").val();
				var rex= new RegExp(orig);
				if (size) {src = src.replace(rex, size);}
				if(jQwys.ie_fix){jQwys.ie_fix.select();} // remember ie
				// remember ie
				restoreRange();
				jQwys.idoc.execCommand("unlink", false, null); // remove link
				wfo.remove(); //remove parent div
				jQwys.idoc.execCommand("insertimage", false, src);
				var obj = $("img[src*='"+src+"']",jQwys.idoc.body);
				// go ahead when the image is loaded
				obj.on('load', function(){
					var w = obj.prop('naturalWidth'); //obj.width(); // image width
					var h = obj.prop('naturalHeight') //obj.height(); // image height
					obj.attr('alt', alt).attr('src', src)
					.attr('width', w).attr('height', h);
					// "CAPTION" and "COPYRIGHT"
					var addtext = "";
					if (itext) {addtext += "<p class='picturetext' style='max-width:"+w+"px'>"+itext+"</p>"; isObject = true;}
					if (cop) {addtext += "<p class='copyright' style='max-width:"+w+"px'>&copy; "+cop+"</p>"; isObject = true;}
					// make a box
					var pp = obj.closest("p,h1,h2,h3,h4,h5,h6"); // parent paragraph and headers

					if (isObject === true) {
						var classn = "";
						if (align) {classn = "class='"+align+"float' ";}
						obj.wrap("<div id='findme' "+classn+"></div>");
						obj.after(addtext);
						// div with p is not allowed in p and h{n}
						if (pp) {
							var div = ($("#findme",jQwys.idoc.body))
							pp.before(div); // set div before parent p
							pp = div.next("p,h1,h2,h3,h4,h5,h6");
							div.removeAttr("id"); // don't want to find him again
							}
						}
					else {
						if (align) {obj.addClass(align);}
						}
					if (clear) {pp.addClass('clrfx');}
					else {pp.removeClass('clrfx');}
					// add an a
					if (resize === 'on' && size !== 'normal') {
						var big = src.replace(size, "normal");
						obj = obj.wrap("<a href='"+big+"' data-app='lightbox' title='"+alt+"'>")
						}
					obj.off(); // avoid endless loop
					});
				$("#"+jQwys.id+"_dlg").fadeOut(400);
				})
			$("#"+jQwys.id+"_cancel").click(function(){$("#"+jQwys.id+"_dlg").fadeOut(400);})
			}

		// makes more problems as it solves
		// strong instead of bold => semantic instead of visual
		// else if(cmd==="bold"){toggleTag("strong");}

		// em instead of italic => semantic instead of visual
		// else if(cmd==="italic"){toggleTag("em");}

		else{
			restoreRange()
			jQwys.idoc.execCommand(cmd, false, null);
			}
		uptodate();
		return true;
		}

// subfunctions

	function toggleTag(mytag) {
		var sel = get_selection();
		var clean = sel.replace(/([ #;&,.+*~\':"!?^$[\]()=>|\/])/g,'\\$1');
		if ($(clean + ":has("+mytag+")").length) {sel = $(sel).text()}
		else {sel = "<"+mytag+">"+sel+"</"+mytag+">";}
		replace_text(sel)
		}

	function get_objects() {
		try {
				eval($.ajax({url:jQwys.path+jQwys.objects, async:false}).responseText);
				}
			catch(e) {
				var HTMLo = "nix";
				}
		return HTMLo;
		};

	function dialog(txt, w, h) {
		var top = (($("#"+jQwys.id+"_container").height())/4)+$(document).scrollTop()-(h/2);
		var left = (($("#"+jQwys.id+"_container").width())/2);
		if ($("#"+jQwys.id+"_dlg").length === 0){
			$("body").append("<div id='"+jQwys.id+"_dlg' style='display:none;position:absolute;width:"+w+"px;height:"+h+"px;top:"+top+"px;left:"+left+"px;' class='dlg'></div>");
			}
		var dlg = $("#"+jQwys.id+"_dlg");
		dlg.html(txt);
		dlg.css({"width":w+"em","height":h+"em","top":top+"px","left":left+"px","z-index":90});
		$('.dlgtext', dlg).css({"height":(h-6)+"em"})
		// q&d dragging
		$('h2', dlg).css('cursor', 'move');
		$('h2', dlg).mousedown(function(e){
			e.preventDefault()
			e.stopPropagation();
			var o = dlg.position()
			var a = e.pageY - o.top;
			var b = e.pageX - o.left;
			dlg.css('opacity', '0.8');
			$(document).on('mousemove', function(e){move(e, dlg, a, b);});
			});
		$(document).mouseup(function(){
			dlg.css('opacity', '1');
			$(document).off('mousemove');
			});
		var close = $('<i>').attr({'class': 'fas fa-times-circle fa-pull-right'}).css({'cursor': 'default', 'color': 'rgba(0,0,0,0.5)'}).on("click",function(){dlg.fadeOut('slow',function(){dlg.remove();});});
		$('h2', dlg).append(close);
		dlg.focus();
		dlg.fadeIn(400);
		}

	function no_sel() {
		var html = "<h2>"+jQwys.i18n['info']+"</h2>"
		+"<div class='dlgtext'>"
		+"<div class='leftfloat'><i class='fas fa-info-circle blue fa-3x'></i></div>"
		+"<p>"+jQwys.i18n['no_selection']+"</p>"
		+"<p style='text-align:right'><button id='"+jQwys.id+"_cancel'>"+jQwys.i18n['ok']+"</button>&nbsp;";
		+"</div>"
		dialog(html,20,12);
		$("#"+jQwys.id+"_cancel").click(function(){$("#"+jQwys.id+"_dlg").fadeOut(200);})
		}

	function move(e, bubble, a, b) {
		if (e) {
			var top = e.pageY - a;
			var left = e.pageX - b;
			bubble.css({'top': top + "px", 'left': left + "px"});
			}
		return false;
		}

	/* a simple beautifier
	 * ok, could be more beautyful
	 * but this appears to be sufficient
	 */
	function beautify(html) {
		html = html.replace(/\n|\r/g, ' ');
		html = html.replace(/\s{2,}/g, ' ');
		var oHTML = $.parseHTML(html);
		return get_node(oHTML, 0);

		function get_node(oHTML, indent) {
			var out = '';
			$.each(oHTML, function(i, elem){
				var tab = ''; var a = 0;
				while (a < indent) {tab += "\t"; a++;}
				// line after
				var line = new RegExp('H[1-6]|LI|TH|TD|HR');
				// line before and after
				var bi_line = new RegExp('P|BLOCKQUOTE|PRE');
				// step down and make indent
				var tab_line = new RegExp('DIV|UL|OL|DL|TABLE|TBODY|THEAD|TFOOT|TR|AREA|SECTION|ASIDE|HEADER|FOOTER');
				// inline
				if (elem.nodeName == '#text' && elem.outerHTML !== undefined) {out += elem.outerHTML;}
				// comments
				else if (elem.nodeType == 8) {out += "<!--"+elem.nodeValue+"-->\n";}
				// one line
				else if (elem.nodeName.match(line)){out += tab+elem.outerHTML+"\n";}
				// two
				else if (elem.nodeName.match(bi_line)){out += "\n"+tab+elem.outerHTML+"\n";}
				// step down and make indent
				else if (elem.nodeName.match(tab_line)){
					var oNext = $.parseHTML(elem.innerHTML);
					if (oNext) {
						elem.innerHTML = "\n"+get_node(oNext, indent+1)+tab;
						out += "\n"+tab+elem.outerHTML+"\n";
						}
					else {out += tab+elem.outerHTML+"\n";}
					}
				// don't want to loose anything
				else if (elem.outerHTML !== undefined) {out += tab+elem.outerHTML;}
				});
			return out;
			}
		}

	function make_clean(s) {
		//Remove script
		s = s.replace( /<script[^>]*>[\s\S]*?<\/script[^>]*>/gi, '' ) ;

		//Remove iframe
		s = s.replace( /<iframe[^>]*>[\s\S]*?<\/iframe[^>]*>/gi, '' ) ;

		//Remove DIV
		s = s.replace(/(<DIV([^>]+)>)/ig,"") ;

		//Remove SPAN (MS makes a lot of shit with SPAN)
		s = s.replace(/(<SPAN([^>]+)>)/ig,"") ;

		//Remove font
		s = s.replace(/(<FONT([^>]+)>)/ig,"") ;

		// Remove mso-trash.
		s = s.replace(/<o:p>\s*<\/o:p>/g, '') ;
		s = s.replace(/<o:p>[\s\S]*?<\/o:p>/g, '&nbsp;') ;

		// Remove mso-xxx styles.
		s = s.replace( /\s*mso-[^:]+:[^;"]+;?/gi, '' ) ;

		// Remove margin styles.
		s = s.replace( /\s*MARGIN: 0cm 0cm 0pt\s*;/gi, '' ) ;
		s = s.replace( /\s*MARGIN: 0cm 0cm 0pt\s*"/gi, "\"" ) ;

		s = s.replace( /\s*TEXT-INDENT: 0cm\s*;/gi, '' ) ;
		s = s.replace( /\s*TEXT-INDENT: 0cm\s*"/gi, "\"" ) ;

		s = s.replace( /\s*TEXT-ALIGN: [^\s;]+;?"/gi, "\"" ) ;

		s = s.replace( /\s*PAGE-BREAK-BEFORE: [^\s;]+;?"/gi, "\"" ) ;

		s = s.replace( /\s*FONT-VARIANT: [^\s;]+;?"/gi, "\"" ) ;

		s = s.replace( /\s*tab-stops:[^;"]*;?/gi, '' ) ;
		s = s.replace( /\s*tab-stops:[^"]*/gi, '' ) ;

		// Remove FONT face attributes.
		s = s.replace( /\s*face="[^"]*"/gi, '' ) ;
		s = s.replace( /\s*face=[^ >]*/gi, '' ) ;

		s = s.replace( /\s*FONT-FAMILY:[^;"]*;?/gi, '' ) ;

		// Remove Class attributes
		s = s.replace(/<(\w[^>]*) class=([^|>]*)([^>]*)/gi, "<$1$3") ;

		// Remove styles.
		s = s.replace( /<(\w[^>]*) style="([^\"]*)"([^>]*)/gi, "<$1$3" ) ;
		// Remove ids.
		s = s.replace( /<(\w[^>]*) id="([^\"]*)"([^>]*)/gi, "<$1$3" ) ;

		// Remove style, meta and link tags
		s = s.replace( /<STYLE[^>]*>[\s\S]*?<\/STYLE[^>]*>/gi, '' ) ;
		s = s.replace( /<(?:META|LINK)[^>]*>\s*/gi, '' ) ;

		// Remove empty styles.
		s =  s.replace( /\s*style="\s*"/gi, '' ) ;

		// Remove XML elements and declarations
		s = s.replace(/<\\?\?xml[^>]*>/gi, '' ) ;

		// Remove w: tags with contents.
		s = s.replace( /<w:[^>]*>[\s\S]*?<\/w:[^>]*>/gi, '' ) ;

		// Remove Tags with XML namespace declarations: <o:p><\/o:p>
		s = s.replace(/<\/?\w+:[^>]*>/gi, '' ) ;

		// Remove comments [SF BUG-1481861].
		s = s.replace(/<\!--[\s\S]*?-->/g, '' ) ;

		s = s.replace( /<(U|I|STRIKE)>&nbsp;<\/\1>/g, '&nbsp;' ) ;

		s = s.replace( /<H\d>\s*<\/H\d>/gi, '' ) ;

		// Remove "display:none" tags.
		s = s.replace( /<(\w+)[^>]*\sstyle="[^"]*DISPLAY\s?:\s?none[\s\S]*?<\/\1>/ig, '' ) ;

		// Remove language tags
		s = s.replace( /<(\w[^>]*) language=([^ |>]*)([^>]*)/gi, "<$1$3") ;

		// Remove onmouseover and onmouseout events (from MS Word comments effect)
		s = s.replace( /<(\w[^>]*) onmouseover="([^\"]*)"([^>]*)/gi, "<$1$3") ;
		s = s.replace( /<(\w[^>]*) onmouseout="([^\"]*)"([^>]*)/gi, "<$1$3") ;

		// Remove onclick events
		s = s.replace( /<(\w[^>]*) onclick="([^\"]*)"([^>]*)/gi, "<$1$3") ;

		// The original <Hn> tag send from Word is something like this: <Hn style="margin-top:0px;margin-bottom:0px">
		s = s.replace( /<H(\d)([^>]*)>/gi, '<h$1>' ) ;

		// Word likes to insert extra <font> tags, when using MSIE. (Wierd).
		s = s.replace( /<(H\d)><FONT[^>]*>([\s\S]*?)<\/FONT><\/\1>/gi, '<$1>$2<\/$1>' );
		s = s.replace( /<(H\d)><EM>([\s\S]*?)<\/EM><\/\1>/gi, '<$1>$2<\/$1>' );
		s = s.replace( /\s{2,}/g, ' ');

		// Remove zombies
		s = s.replace( /<SPAN\s*[^>]*>\s*&nbsp;\s*<\/SPAN>/gi, '&nbsp;' ) ;
		s = s.replace( /<SPAN\s*[^>]*><\/SPAN>/gi, '' ) ;
		s = s.replace( /<P[^>]*>\s*<\/P>/gi, '' ) ;
		s = s.replace( /<P[^>]*>\s*<br\s?\/>\s*<\/P>/gi, '' ) ;
		return s;
		}
	};
})(jQuery);
