(function($){
	$.fn.upload5 = function(options){
		var defaults = {
			max: 100000, // max size B
			max_files: 20, // max files upload
			max_post: 3000000,
			height: 70, // max height of thumbnail (px)
			width: 100, // max width of thumbnail (px)
			submit: 'upload', // name of submit-parameter
			destroy: false, // "true" removes form
			xcolor: '#99FF99', // color of drag event
			instruct: 'Drop files here', // text or html inside dropbox
			fallback: '<p>Your browser is not HTML5-compliant</p>', // text or html
			toobig: 'Size of file is too big.', // text or html
			toomuch: 'TOO MANY FILES', // text or html
			skipped: 'SKIPPED', // text or html
			queue: 'Queue', // text
			files: 'files', // text
			ready: 'Ready', // text
			wrapper: 'upload_box' //id of wrapper
		};
		options = $.extend(defaults, options);
		var oInput = $(this);

		var oWrapper = $("<div>");
		oWrapper.attr("id", options.wrapper);
		var oList = $('<ul id="uploader_list">');
		var oForm = oInput.parents('form');
		var url = oForm.attr('action');
		var formId = oForm.attr('id');
		var count = 0;
		var types = false;

		if (oInput.attr('accept')) {
			types = oInput.attr('accept').split(', ');
			}

		// File API?
		if (window.File && window.FileReader && window.FileList && window.Blob) {
			init_uploader();
			}
		else {
			if (options.destroy) {oForm.after(options.fallback);oForm.remove();}
			else {oInput.after(options.fallback);}
			}

		function init_uploader() {
			oInput.attr('multiple', 'multiple');
			$(':submit', oForm).remove();
			var oInst = $('<p>').addClass('center').append(options.instruct)
			var oStatus = $('<p id="upload5_stat">').css('font-weight', 'bold').append(options.queue + ": 0 " + options.files);
			oWrapper.prepend(oInst);
			oWrapper.prepend(oStatus);
			oInput.after(oWrapper);
			oWrapper.after(oList);

			// doesn't work as jQuery object
			var Input = document.getElementById(oInput.attr('id'));
			Input.addEventListener("change", function () {insertFiles(this.files);}, false);
			// doesn't work as jQuery object
			var Wrapper = document.getElementById(options.wrapper);

			// Drag events without JQ again
			Wrapper.addEventListener("dragleave", function (e) {
				var target = e.target;
				if (target && target === Wrapper) {$(this).css('background-color', 'inherit');}
				e.preventDefault();
				e.stopPropagation();
				}, false);

			Wrapper.addEventListener("dragenter", function (e) {
				$(this).css('background-color', options.xcolor);
				e.preventDefault();
				e.stopPropagation();
				}, false);

			Wrapper.addEventListener("dragover", function (e) {
				e.preventDefault();
				e.stopPropagation();
				}, false);

			Wrapper.addEventListener("drop", function (e) {
				insertFiles(e.dataTransfer.files);
				$(this).css('background-color', 'inherit');
				e.preventDefault();
				e.stopPropagation();
				}, false);
			}

		function insertFiles(files) {
			$('.feedback').remove();
			if (files.length > options.max_files) {
				$('#upload5_stat').after('<p class="feedback">'+options.toomuch+'</p>');
				}
			else {
				for (var i=0, l=files.length; i<l; i++) {
					if (files[i].size < options.max) {
						if (types) {
							parts = files[i].name.split(".");
							var ext = "." + parts[parts.length-1].toLowerCase();
							var check = true;
							for (var ii = 0; ii < types.length; ii++) {
								if (ext == types[ii]) {uploadFile(files[i], i); check = false;}
								}
							if (check) {$('#upload5_stat').after('<p class="feedback">'+files[i].name+' '+options.skipped+'</p>');}
							}
						else {uploadFile(files[i], i);}
						}
					else {$('#upload5_stat').after('<p class="feedback">'+files[i].name+' '+options.toobig+'</p>');}
					}
				}
			}

		function uploadFile(file, i) {
			var fileInfo = $('<li>');
			fileInfo.append("<strong>" + file.name + "</strong> ");
			var size = file.size.toFixed(2)+ " Bytes";
			if (file.size > 1024) {size = parseFloat(file.size / 1024).toFixed(2) + " KB";}
			if (file.size > 1024000) {size = parseFloat(file.size / 1024000).toFixed(2) + " MB";}
			fileInfo.append(size + "<br />");
			var oProgress = $('<progress>');
			oProgress.attr({'value': 0, 'max': 100});
			fileInfo.append(oProgress);
			oList.append(fileInfo);

			// Uploading

			var oData = new FormData(document.getElementById(formId));
			oData.append(options.submit, "silent");
			oData.append(oInput.attr('name'), file);
			count++;
			$('#upload5_stat').html(options.queue + ": "+ count + " " + options.files).css('color', 'red');
			var xhr = new XMLHttpRequest();
			// Update progress bar
			xhr.upload.addEventListener("progress", function (e) {
				if (e.lengthComputable) {oProgress.attr('value', (e.loaded / e.total) * 100);}
				}, false);
			// File uploaded
			xhr.addEventListener("load", function () {
				if (xhr.status === 200) {oProgress.attr('value', 100); fileInfo.append(" <strong>" + xhr.responseText + "</strong> ")}
				else {oProgress.attr('value', 0); fileInfo.append(" ERROR ");}
				count--;
				var stext = options.queue + ": "+ count + " " + options.files;
				if (count === 0) {stext = options.ready; $('#upload5_stat').css('color', 'green')}
				$('#upload5_stat').html(stext);
				}, false);
			xhr.open("post", url, true);
			xhr.send(oData);
			if ((/image\/jpeg/i).test(file.type) ||
				(/image\/png/i).test(file.type) ||
				(/image\/gif/i).test(file.type)) {
				img = document.createElement("img");
				$(img).css({'max-height': options.height+'px', 'max-width': options.width+'px', 'margin-right': '1em'});
				$(img).attr('id', 'fimg'+i);
				fileInfo.prepend(img);
				reader = new FileReader();
				reader.onload = (function (theImg) {
					return function (e) {theImg.src = e.target.result;};
					}(img));
				reader.readAsDataURL(file);
				}
			}

		}
})(jQuery);
