/**
 * calculates a sum of input values
 *
 **/

(function($){
  $(document).ready(function(){$("[data-app='sum']").sum_up()});
  
  $.fn.sum_up = function(opt){
	var defaults = {
	  decimals: 2,
	  comma: ',',
	  sum: '#totalsum'
	  };
	opt = $.extend(defaults, opt);
	
	this.each(function() {
	  var oField = $(this);
	  oField.change(function(){recalculate()});
	  recalculate();
	  });			

	function recalculate(){
	  var sum = 0;
	  $("[data-app='sum']").each(function() {
		if ($(this).attr('type') == 'radio' || $(this).attr('type') == 'checkbox') {
		  if ($(this).is(':checked')) {sum += parseFloat($(this).attr('data-val'));}
		  }
		else if ($(this).is('select')) {
		  var tmp = $('option', $(this)).filter(':selected').attr('data-val');
		  sum += parseFloat(tmp);
		  }
		else {sum += parseFloat($(this).attr('data-val'))}
		});
	  if (opt.decimals) {sum = sum.toFixed(opt.decimals);}
	  sum = sum.toString();
	  if (opt.comma) {sum = sum.replace(/\./, opt.comma);}
	  $(opt.sum).html(sum);
	  }
	}
  })(jQuery);