/**
 * jQuery Spin Field
 *
 **/

(function($){
  $.fn.spinme = function(opt){
	var defaults = {
	  interval: 1,
      max: null,
      min: null,
	  pad: "0",
      btnCss: {'margin-left': '8px', 'cursor': 'pointer'},
      btnmin: 'fas fa-minus-circle fa-lg red',
      btnmax: 'fas fa-plus-circle fa-lg green',
      };
	opt = $.extend(defaults, opt);

	this.each(function() {
	  var oField = $(this);
	  var oc = oField.css('color');
	  var oID = oField.attr('id');
	  var min = opt.min || oField.attr('data-min');
	  var max = opt.max || oField.attr('data-max');
	  var interval = oField.attr('data-interval') || opt.interval;
      var pad = opt.pad;

	  if (max == 0) {
		oField.attr('disabled','disabled');
		oField.addClass('grey');
		$("label[for='" + oField.attr('id') + "']").addClass('grey');
		oField.val(0);
	  	}

	  else {
		Minus = $('<i>').css(opt.btnCss).attr('id', oID+'_minus');
		Minus.addClass(opt.btnmin);
		Minus.click(function(e){spin(-1);})
		oField.after(Minus);
		Plus = $('<i>').css(opt.btnCss).attr('id', oID+'_plus');
		Plus.addClass(opt.btnmax);
		Plus.click(function(e){spin(1);})
		oField.after(Plus);
		oField.attr("autocomplete", "off");
		oField.keydown(function(e){
			switch (e.keyCode) {
		  case(38) : spin(1); break;
		  case(39) : spin(1); break;
		  case(37) : spin(-1); break;
		  case(40) : spin(-1); break;
		  return false;
		  }
		});

		oField.change(function(e){spin(0);});

		if(oField.attr('data-pad')) {pad = oField.attr('data-pad').toString();}
  	}

	  function spin(vector){
		var Minus = $('#'+oID+'_minus');
		var Plus = $('#'+oID+'_plus');
		if (vector == -1) {
		  Minus.css('filter', 'brightness(1.2)');
		  setTimeout(function(){Minus.css('filter', 'brightness(1)');}, 400);
		  }
		else {
		  Plus.css('filter', 'brightness(1.2)');
		  setTimeout(function(){Plus.css('filter', 'brightness(1)');}, 400);
		  }
		var val = parseInt(oField.val());
		if (!isNaN(val)){
		  val = parseInt((vector * parseInt(interval)) + val);
		  if (min !== null && val < min) {
			oField.css('color', 'red');
			setTimeout(function(){oField.css('color', oc);}, 1500);
			val = min;
			}
		  else if (max !== null && val > max) {
			oField.css('color', 'red');
			setTimeout(function(){oField.css('color', oc);}, 1500);
			val = max;
			}
		  if (val != oField.val()){
			if (String(val).length < pad.length){val = (pad + val).slice(-pad.length);}
			oField.val(val);
			oField.change();
			}
		  }
		}
	  });
	}
  })(jQuery);
