(function($){
	$.fn.pwdCheck = function(opt){
		var defaults = {
			'minchars': 6,
			'uppercase': 1,
			'digits': 1,
			'special' : 0,
			'field': 'ipassword',
			'cmp' : 'iccpassword',
			'icon_ok': '/co_icons/checked.png',
			'icon_false': '/co_icons/not.png',
			'ok': false
			};
		opt = $.extend(defaults, opt);
		var oForm = $(this);
		var oField = $('#'+opt.field);
		var oCmp = $('#'+opt.cmp);
		// encoded password doesn't apply criteria
		if (oField.val() && oField.val() == oCmp.val()) {opt.ok = true;}
		oField.one('focus', function(){
			oField.after($('<img>').attr({'src': opt.icon_false, 'id': opt.field+'pass'}).css({'margin-left': '5px'}));
			oField.val('');
			});
		oCmp.one('focus', function(){
			oCmp.after($('<img>').attr({'src': opt.icon_false, 'id': opt.field+'ver'}).css({'margin-left': '5px'}));
			oCmp.val('');
			});
		oField.keyup(function(){
			opt.ok = false;
			var pass = check(oField.val());
			if (pass) {
				$('#'+opt.field+'pass').attr({'src': opt.icon_ok});
				oField.removeClass('duty');
				}
			else {$('#'+opt.field+'pass').attr({'src': opt.icon_false});}
			});
		oCmp.keyup(function(){
			if (oField.val() == oCmp.val()) {$('#'+opt.field+'ver').attr({'src': opt.icon_ok});}
			else {$('#'+opt.field+'ver').attr({'src': opt.icon_false});}
			});
		oForm.submit(function(e) {
			var btn = $(this).find("input[type=submit]:focus" );
			if (btn.attr('name') != undefined) {
				var pass = check(oField.val());
				if (opt.ok) {pass = true;} // if password is given and has not been changed
				if (oField.val() != oCmp.val()) {pass = false;}
				if (!pass) {
					$('.dlg').fadeOut('fast');
					oField.addClass('duty');
					oField.focus();
					e.preventDefault();
					}
				}
			});
		
		function check(a) {
			var ok = true;
			if (a.length < opt.minchars){ok = false;}
			if (a.match(/[1-9]/g) < opt.digits) {ok = false;}
			if (a.match(/[A-Z]/g) < opt.uppercase) {ok = false;}
			if (a.match(/[;,\.\!@\#\$%:\&§\*]/g) < opt.special) {ok = false;}
			return ok;
			}
		}
	})(jQuery);