(function($) {
	$.fn.miniSheet = function(opt) {
		var defaults = {
			decimals: 2,
			comma: false
		};
		opt = $.extend(defaults, opt);
		var mS = [];
		var row = 0; var col = 0; var Tid;
		this.each(function(){
			var oTable = $(this);
			Tid = oTable.attr('id');
			$('tr', oTable).each(function(){
				oTr = $(this);
				col = 0;
				row++;
				$('td', oTr).each(function(){
					var oTd = $(this);
					col++;
					var mid = Tid+'_'+getColChar(col)+row
					oTd.attr('id', mid);
					if (oTd.attr('data-func')) {mS.push(mid)}
					});
				});
			$('input', oTable).change(function(){recalculate()});
			recalculate();
			});
		
		function recalculate(){
			for (var i=0; i < mS.length; i++) {
				var oTd = $('#'+mS[i]);
				var val = figureOut(oTd.attr('data-func'));
				if ($('.wSval', oTd).html()) {$('.wSval', oTd).html(val);}
				else {oTd.html(val);}
				oTd.addClass('green');
				setTimeout("$('td.green').removeClass('green')", 1000)
				}
			}
		
		function getColChar(n){
			n+=64;
			// TODO: AA, AB .. ZZZZZZ...
			var code = String.fromCharCode(n);
			return code;
			}
		
		// simple basics like A2*B2 or 3*B4
		// it also works with A2+B2*1.2 which means (A2+B2)*1.2
		// functions see below
		// calculations can only be done from
		// top to bottom, from left to right
		function figureOut(c){
			var num = [];
			var ops = [];
			var temp = '';
			var isfunc = false;
			var func = ['SUM', 'MAX', 'MIN', 'AVG', 'IF'];
			for (var i=0; i < func.length; i++) {
				var p = new RegExp(func[i], "g");
				if (c.match(p)) {isfunc = true; temp = makeFunction(func[i], c);}
				}
			if (isfunc === false) {
				for (var i=0; i < c.length; i++) {
					var f = c.substring(i,parseInt(i+1));
					if (f.match(/[\w\.]/)) {temp += f;}
					if (f.match(/[\/\*\+\-]/)) {ops.push(f); num.push(temp);temp = '';}
					}
				num.push(temp);
				for (var i=0; i < num.length; i++) {
					var n = num[i];
					// assume placeholder
					if (n.match(/[A-Z]/)) {n = getVal(n);}
					num[i] = parseFloat(n);
					}
				temp = num[0];
				for (var i=0; i < ops.length; i++) {
					// ugly, isn't
					var n = parseInt(i+1)
					switch (ops[i]) {
						case "+": temp = parseFloat(temp + num[n]); break;
						case "-": temp = parseFloat(temp - num[n]); break;
						case "*": temp = parseFloat(temp * num[n]); break;
						case "/": temp = parseFloat(temp / num[n]); break;
						}
					}
				// just something like A2
				if (ops.length === 0) {temp = num[0]};
				}
			if (opt.decimals) {temp = temp.toFixed(opt.decimals);}
			temp = temp.toString();
			if (opt.comma) {temp = temp.replace(/\./, opt.comma);}
			return temp;
			}
		
		function getVal(eId) {
			var el = $("#"+Tid+"_"+eId);
			var v = $('input', el).val() || $('.wSval', el).html() || el.html() || 0;
			// numbers only
			if (v) {
				v = v.replace(/,/g, ".");
				v = v.replace(/[^\d\.]/g, "");
				}
			return v;
			}
		
		function makeFunction(t, c) {
			var temp = 0;
			switch (t) {
				case "SUM": temp = getSum(c.replace(/SUM/, '')); break;
				case "MIN": temp = getMin(c.replace(/MIN/, '')); break;
				case "MAX": temp = getMax(c.replace(/MAX/, '')); break;
				case "AVG": temp = getAvg(c.replace(/AVG/, '')); break;
				}
			return temp;
			}
			
		function getSum(c) {
			var temp = parseFloat(0);
			var range = getRange(c);
			for (var i=0; i < range.length; i++) {
				if(range[i]) {temp += parseFloat(range[i]);}
				}
			return temp;
			}
			
		function getMin(c) {
			var range = getRange(c);
			return Math.min.apply(Math, range);
			}
			
		function getMax(c) {
			var range = getRange(c);
			return Math.max.apply(Math, range);
			}
			
		function getAvg(c) {
			var temp = parseFloat(0);
			var range = getRange(c);
			for (var i=0; i < range.length; i++) {
				temp += parseFloat(range[i]);
				}
			temp = temp/range.length;
			return temp;
			}
			
		function getRange(c) {
			var range = [];
			c = c.replace(/[\(\)]/g, '');
			var dim = c.split(":");
			var row = [dim[0].replace(/[A-Z]/g, ''), dim[1].replace(/[A-Z]/g, '')];
			var col = [dim[0].replace(/[1-9]/g, ''), dim[1].replace(/[1-9]/g, '')];
			if (row[0] == row[1]) {
				for (var i = col[0].charCodeAt(0); i <= col[1].charCodeAt(0); i++) {
					range.push(getVal(String.fromCharCode(i)+row[0]));
					}
				}
			if (col[0] == col[1]) {
				for (var i = row[0]; i <= row[1]; i++) {
					range.push(getVal(col[0]+i));
					}
				}
			return range;
			}
		}
})(jQuery);