// jQuery plugin for consentio cms
// date picker
(function($) {
$.fn.datepick = function(options){
	var defaults = {
		ln: 'de',
		icon: "calendar-alt",
		close: "windows-close",
		prev: "<i class='fas fa-arrow-alt-circle-left fa-lg green' title='<'></i>",
		next: "<i class='fas fa-arrow-alt-circle-right fa-lg green' title='>'></i>",
		today: "<i class='fas fa-calendar-plus fa-lg green' title='today'></i>",
		pad: "00",
		monthstr: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'], // For formatting
		daystr: ['Mo','Tu','We','Th','Fr','Sa','Su'],
		time: false
		};
	options = $.extend(defaults, options);
	i18n(options.ln);
	/* html for calendar */
	window.generateHTML = function (year, month, day, elid, time) {
		var dom = get_dom(year, month);
		var dow = get_dow(year, month);
		py = year; pm = month; pm--;
		ny = year; nm = month; nm++;
		var today = new Date();
		var ty = today.getFullYear();
		var tm = today.getMonth()+1;
		var td = today.getDate();
		if (pm == 0) {pm = 12; py--;}
		if (nm == 13) {nm = 1; ny++;}
		var prev = "<a href=\"javascript:\$('#cont_"+elid+"').html(generateHTML("+py+", "+pm+", '','"+elid+"', '"+time+"'));void(0);\">"+options.prev+"</a>";
		var next = "<a href=\"javascript:\$('#cont_"+elid+"').html(generateHTML("+ny+", "+nm+", '','"+elid+"', '"+time+"'));void(0);\">"+options.next+"</a>";
		var Ctoday = "<a href=\"javascript:\$('#cont_"+elid+"').html(generateHTML("+ty+", "+tm+", "+td+",'"+elid+"', '"+time+"'));void(0);\">"+options.today+"</a>";
		var html = "<p>"+Ctoday+" "+prev+" <span class='selectwrap'><select id='imonth' name='month' onChange=\"\$('#cont_"+elid+"').html(generateHTML($('#iyear').val(), $('#imonth').val(), '','"+elid+"', '"+time+"'));\">";
		for (i = 1; i <= 12; i++) {
			var sel = "";
			if (i == month) {sel = " selected='selected'";}
			html += "<option value='"+i+"'"+sel+">"+options.monthstr[i-1]+"</option>";
			}
		html += "</select></span> <input type='text' class='text' size='4' id='iyear' name='year' value='"+year+"' onChange=\"\$('#cont_"+elid+"').html(generateHTML($('#iyear').val(), $('#imonth').val(), '','"+elid+"', '"+time+"'));\"/> "+next+"</p>"
		var fieldTime = "";
		if (options.time) {
			var tArr = time.split(":");
			var limit = [24, 60, 60];
			for (ii = 0; ii < 3; ii++) {
				tArr[ii] = tArr[ii].replace(/\D/g, "")
				if (tArr[ii] >= limit[ii]) {tArr[ii] = limit[ii]-1}
				if (!tArr[ii]) {tArr[ii] = "00"}
				}
			time = tArr.join(":");
			fieldTime = "<p><input name='time' value='"+time+"' size='9' class='text' onChange=\"\$('#cont_"+elid+"').html(generateHTML($('#iyear').val(), $('#imonth').val(), '','"+elid+"', $(this).val()));\"/></p>";
			}
		html += "<table id='calendar'><tr>";
		for (var i = 1; i <= 7; i++) {
		html += "<th class='first'>"+options.daystr[i-1]+"</th>\n";
		}
		html += "</tr><tr>";
		if (dow > 0) {
			html += "<td colspan='"+dow+"'> </td>";
			}
		var wk = 0;
		for (var i = 1; i <= dom; i++) {
			wk = (i+dow)-(parseInt((i+dow)/7)*7);
			var css = "calendarbody";
			if (wk < 1) {wk = 7; css = "shade"}
			if (i == day) {css = "highlight"}
			var dstr = i;
			if (String(dstr).length < options.pad.length){dstr = (options.pad + dstr).slice(-options.pad.length);}
			if (String(month).length < options.pad.length){month = (options.pad + month).slice(-options.pad.length);}
			var str = year+"-"+month+"-"+dstr;
			if (options.time) {str += " "+time;}
			html += "<td class='"+css+"'><a href=\"javascript:\$('#"+elid+"').attr('value', '"+str+"');\$('#"+elid+"').focus();void(0);\">"+dstr+"</a></td>";
			if (wk == 7 && i != dom) {html += "</tr><tr>";}
			}
		if (wk < 7) {
			html += "<td colspan='"+parseInt(7 - wk)+"' class='calendarbody'> </td>";
			}
		html += "</tr></table>"+fieldTime;
		return html;
		}
	/* days in month */
	var get_dom = function(year, month) {
		return 32 - new Date(year, month-1, 32).getDate();
		}
	/* day of week of 1st day of month */
	var get_dow = function(year, month) {
		var val = new Date(year, month-1, 1).getDay()-1;
		if (val < 0) {val = 6;}
		return val;
		}

	this.each(function() {
		var elem = $(this);
		var span = elem.parent('span');
		var open = false;
		var elid = elem.attr("id");
		var open_picker = function(){
			// clear other calendars
			$('div[id^="cont_"]').hide();
			$('div[id^="cont_"]').html("");
			var date = elem.attr("value");
			if (!date) {
				var today = new Date();
				date = today.getFullYear()+'-'+today.getMonth()+1+'-'+today.getDate();
				}
			var timestamp = date.split(" ");
			date = timestamp[0];
			if (timestamp[1]){options.time = true;}
			var dArr = date.split("-");
			var pos = elem.position();
			pos.left = parseInt(pos.left + elem.width() + 50);
			$('#cont_'+elid).css({'left': pos.left + "px", 'top': pos.top + "px"});
			$('#cont_'+elid).html(generateHTML(dArr[0], dArr[1], dArr[2], elid, timestamp[1]));
			$('#cont_'+elid).slideDown();
			open = true;
			}
		var close_picker = function() {
			$('div[id^="cont_"]').slideUp('fast', function() {$(this).html("")});
			open = false;
			}
		var toggle_picker = function() {
			if (open == true) {close_picker()}
			else {open_picker()}
			}

		elem.attr("readonly", "readonly");
		elem.on("focus",toggle_picker);
		//$('input').on("focus",close_picker);
		var container = $("<div class='caldlg'></div>");
		container.attr("id", "cont_"+elid);
		container.css({'display':'none', 'position':'absolute'});
		var icon = $('<i>').attr({'id': 'icon_'+elid, 'class': 'fas fa-'+options.icon+' white'}).css({'padding': '6px', 'cursor': 'pointer'});
		icon.on("click",toggle_picker);
		span.after(container);
		elem.after(icon);
		});

	/* internationalalization, languages may be added here */
	function i18n(ln) {
		if (ln == "de") {
			options.monthstr = ['Jan','Feb','Mär','Apr','Mai','Jun','Jul','Aug','Sep','Okt','Nov','Dez'];
			options.daystr = ['Mo','Di','Mi','Do','Fr','Sa','So'];
			}
		if (ln == "fr") {
			options.monthstr = ['Jan','Fév','Mar','Avr','Mai','Jun','Jul','Aoû','Sep','Oct','Nov','Déc'];
			options.daystr = ['Lu','Ma','Me','Je','Ve','Sa','Di'];
			}
		if (ln == "es") {
			options.monthstr = ['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic'];
			options.daystr = ['Lu','Ma','Mi','Ju','Vi','Sá','Do'];
			}
		if (ln == "it") {
			options.monthstr = ['Gen','Feb','Mar','Apr','Mag','Giu','Lug','Ago','Set','Ott','Nov','Dic'];
			options.daystr = ['Lu','Ma','Me','Gi','Ve','Sa','Do'];
			}
		if (ln == "sv") {
			options.monthstr = ['Jan','Feb','Mar','Apr','Maj','Jun','Jul','Aug','Sep','Okt','Nov','Dec'];
			options.daystr = ['Må','Ti','On','To','Fr','Lö','Sö'];
			}
		}
	};
})(jQuery);
