// jQuery plugin for consentio cms
// color picker
(function($) {
$.fn.colorpick = function(options){
	var defaults = {
		icon: "paint-brush",
		};
	options = $.extend(defaults, options);

	this.each(function() {
		var elem = $(this);
		var elid = elem.attr("id");

		var open_picker = function(){
			// clear other pickers
			$('div[id^="col_"]').hide();
			var pos = elem.position();
			pos.left = parseInt(pos.left + elem.width());
			$('#col_'+elid).css({'left': pos.left + "px"});
			$('#col_'+elid).slideDown();
			open = true;
			}

		var close_picker = function() {
			$('div[id^="col_"]').slideUp('fast');
			open = false;
			}

		var toggle_picker = function() {
			if (open == true) {close_picker()}
			else {open_picker()}
			}

		elem.attr("readonly", "readonly");
		elem.on("focus",toggle_picker);
		$('#col_'+elid).css({'display':'none', 'position':'absolute', 'width':'200px'});
		var icon = $('<i>').attr({'id': 'icon_'+elid, 'class': 'fas fa-'+options.icon+' white'}).css({'padding': '6px', 'cursor': 'pointer'});
		icon.on("click",toggle_picker);
		elem.after(icon);
		$('.pal', $('#col_'+elid)).each(function(){
			var me = $(this);
			me.on('click', function() {
				var col = me.attr('data-val');
				elem.val(col);
				elem.css({'color': col, 'background-color': col})
				close_picker();
				})
			});
		});
	};
})(jQuery);
