(function($) {
	$.fn.table2chart = function(opt) {
		var defaults = {
			tableID: '',
			ratio: 'x', // read rows or col x || y
			type: 'line', // line, bars, pie || ...
			radius: 60, // radius of pie
			strokeColor: ['#FF0000', '#FF9900', '#009900'],
			gutterColor: '#EAEAEA',
			strokeOpacity: 0.7,
			strokeWidth: 1,
			fixedWidth: 0, // fixed width of a cell (bars, lines)
			control: 0, // [x,y,0]
			png: 0, // [1,0] exports png
			target: '', // form input to fill with value
			target2: '', // form input 2 to fill with value
			call: null, // function for click event
			min: 'zero', // zero || auto
			tooltip: 0
			};
		opt = $.extend(defaults, opt);
		var oTarget = $(this);
		var with_canvas = !!document.createElement('canvas').getContext('2d');
		var vals = [];
		var captv = [];
		var capth = [];
		var row = 0; var col = 0;
		var h_ratio = 1;
		var w_ratio = 1;
		var oTable = $('#'+opt.tableID);
		var areas = [];
				
		if (with_canvas == true) {
			oTarget.css({'position': 'relative', 'overflow': 'hidden'});
			$('tr', oTable).each(function(){
				oTr = $(this);
				col = 0;
				var tdVal = [];
				$('th', oTr).each(function(){
					var oTd = $(this);
					var val = oTd.text() || 0;
					if (row) {captv.push(val);}
					else {capth.push(val);}
					col++;
					});
				$('td', oTr).each(function(){
					var oTd = $(this);
					var val = oTd.text() || 0;
					tdVal.push(val);
					// colorize font for pie
					if (opt.type == "pie" && col == 1) {oTd.css({'color': opt.strokeColor[row-1], 'font-weight': 'bold'});}
					col++;
					});
				vals[row] = tdVal;
				row++;
				});
			vals.shift(); // remove first row
			if (opt.ratio == 'y') {
				var vals2 = []
				for(var i = 0 ; i < vals.length ; i++ ){
					for(var ii = 0 ; ii < vals[i].length ; ii++ ){
						if (!vals2[ii]) {vals2[ii] = [];}
						vals2[ii][i] = vals[i][ii] || 0;
						}
					}
				vals = vals2;
				}
			if (opt.type == 'pie') {oTarget.css('height', parseInt(opt.radius*2)+'px')}
			var canvas = $('<canvas>');
			canvas.attr({'id': opt.tableID+'Canvas', 'width': oTarget.width(), 'height': oTarget.height()})
			canvas.css({'z-index': 1, 'position': 'absolute', 'left': '0px', 'top': '0px'});
			oTarget.html(canvas);
			var oCanvas = document.getElementById(opt.tableID+'Canvas').getContext("2d");
			drawChart(oTarget.height(), oTarget.width());
			
			if (opt.control) {
				var canvas2 = $('<canvas>');
				canvas2.attr({'id': opt.tableID+'Canvas2', 'width': oTarget.width()-16, 'height': oTarget.height()})
				canvas2.css({'z-index': 2, 'position': 'absolute', 'left': '0px', 'top': '0px', 'cursor': 'pointer'});
				oTarget.append(canvas2);
				var oCanvas2 = document.getElementById(opt.tableID+'Canvas2').getContext("2d");
				var off = oTarget.offset();
				var xf = 0;
				var yf = 0;
				canvas2.mouseup(function(e) {
					if (opt.call) {opt.call()}}
					);
				canvas2.mousedown(function(e) {xf = parseInt(e.pageX-off.left); yf = parseInt(e.pageY-off.top)});
				canvas2.mouseout(function(e) {
					oCanvas2.clearRect(0,0,oTarget.width(),oTarget.height());
					if(opt.target) {$('#'+opt.target).val(0);}
					if(opt.target2) {$('#'+opt.target2).val(0);}
					});
				canvas2.mousemove(function(e) {
					var xo1 = 0; var yo1 = 0;
					var xo2 = 0; var yo2 = 0;
					if (opt.control == 'x') {
						xo1 = parseInt(e.pageX-off.left);
						xo2 = xo1;
						yo2 = oTarget.height()-20;
						if(opt.target) {$('#'+opt.target).val(parseFloat(xf/w_ratio));}
						if(opt.target2) {$('#'+opt.target2).val(parseFloat(xo1/w_ratio));}
						yf = 0;
						}
					if (opt.control == 'y') {
						yo1 = parseInt(e.pageY-off.top);
						yo2 = yo1;
						xo2 = oTarget.width();
						if(opt.target) {$('#'+opt.target).val(parseFloat(yo1/h_ratio));}
						if(opt.target2) {$('#'+opt.target2).val(parseFloat(yo1/h_ratio));}
						xf = 0;
						}
					if (xf || yf) {
						var a = xf; var b = yo1; var c = xo1-xf; var d = yo2;
						if (yf) {a = xo1; b = yf; c = xo2; d = yo1-yf;}
						oCanvas2.clearRect(0,0,oTarget.width(),oTarget.height());
						oCanvas2.beginPath();
						oCanvas2.rect(a, b, c, d);
						oCanvas2.fillStyle = html2rgba('#C0C0C0', 0.5);
						oCanvas2.fill();
						}
					else {
						oCanvas2.clearRect(0,0,oTarget.width(),oTarget.height());
						oCanvas2.beginPath();
						oCanvas2.moveTo(xo1, yo1);
						oCanvas2.lineTo(xo2, yo2);
						oCanvas2.strokeStyle = html2rgba('#666666', 1);
						oCanvas2.lineWidth = 1;
						oCanvas2.stroke();
						}
					});
				}
				
			if (opt.tooltip) {
				var off = oTarget.offset();
				var tooltip = $('<div>').attr({'id': opt.tableID+'tooltip'}).css({'display': 'none', 'position': 'absolute', 'z-index': 1000, 'background-color': 'rgba(255,255,255,0.7)', 'white-space': 'nowrap', 'padding': '5px', 'border': '1px solid '+opt.gutterColor});
				oTarget.append(tooltip);
				canvas.mousemove(function(e) {
					x = parseInt(e.pageX-off.left);
					y = parseInt(e.pageY-off.top);
					var o = opt.type == 'line' ? parseInt(((x+(w_ratio/2))/w_ratio)) : parseInt(x/w_ratio);
					tooltip.html(areas[o]);
					var tw = parseInt(tooltip.width())+20;
					var ox = x+15;
					if (x > oTarget.width()-tw) {ox = x-(tw+5);}
					tooltip.css({'display': 'block','top': y+'px', 'left': ox+'px'});
					});
				canvas.mouseout(function(e) {tooltip.css({'display': 'none'})});
				}
				
			if (opt.png) {
				var but = $("<a>").click(function() {exportPNG();});
				but.append("PNG");
				oTarget.after(but);
				}
			}
		else {
			oTarget.html("Please use a modern browser.");
			}
			
		function drawChart(h, w) {
			var total = [];
			for(var i = 0 ; i < vals.length ; i++ ){
				for(var ii = 0 ; ii < vals[i].length ; ii++ ){if (vals[i][ii]) {total.push(vals[i][ii])}}
				}
			var total_max = Math.max.apply(Math, total);
			var total_min = Math.min.apply(Math, total);
			if (opt.type == "line" || opt.type == "bars") {
				h = h-36;
				w = w-16;
				if(opt.fixedWidth) {
					w = (opt.fixedWidth*vals[0].length)-16;
					}
				var used_height = total_max;
				if (total_min > 0 && opt.min == "zero") {total_min = 0;}
				else if (total_min > 0) {used_height = total_max - Math.abs(total_min);}
				else if (total_min < 0) {used_height = total_max + Math.abs(total_min);}
				itp = 10; exp = 1;
				while (Math.pow(itp, exp) < used_height) {exp++;}
				var co = Math.pow(itp, exp)/10;
				if (used_height*5 < Math.pow(itp, exp)) {used_height = (Math.pow(itp, exp))/5;}
				else if (used_height*2 < Math.pow(itp, exp)) {used_height = (Math.pow(itp, exp))/2;}
				else {used_height = Math.pow(itp, exp);co = Math.pow(itp, exp)/5;}
				h_ratio = parseFloat(h/used_height);
				w_ratio = parseFloat(w/vals[0].length);
				
				var passed = 1;
				for (var i = 0 ; i < vals[0].length ; i++ ){
					oCanvas.beginPath();
					oCanvas.moveTo((i*w_ratio), 0);
					oCanvas.lineTo((i*w_ratio), h+5);
					oCanvas.strokeStyle = html2rgba(opt.gutterColor, 1);
					oCanvas.lineWidth = 1;
					oCanvas.stroke();
					oCanvas.font = "normal 8pt Verdana";
					oCanvas.fillStyle = html2rgba('#666666', 1);
					oCanvas.textAlign = "left";
					var text = capth[i+1];
					if (opt.ratio == 'y') {text = captv[i]}
					areas.push(capth[0]+' '+text+':');
					if ( i > 0 && oCanvas.measureText(text).width > w_ratio*passed) {passed++;}
					else {oCanvas.fillText(text, (i*w_ratio), h+20); passed = 1;}
					}
				for (var i = 0 ; i <= used_height ; i=i+co ){
					oCanvas.beginPath();
					oCanvas.moveTo(0, (i*h_ratio));
					oCanvas.lineTo(w, (i*h_ratio));
					oCanvas.strokeStyle = html2rgba(opt.gutterColor, 1);
					oCanvas.lineWidth = 1;
					oCanvas.stroke();
					if (i < used_height) {
						oCanvas.font = "normal 8pt Verdana";
						oCanvas.fillStyle = html2rgba('#666666', 1);
						oCanvas.textAlign = "right";
						oCanvas.fillText(used_height-i, w+16, (i*h_ratio)+10);
						}
					}
					
				for (var i = 0 ; i < vals.length ; i++ ){
					oCanvas.beginPath();
					oCanvas.rect(8, ((i+1)*16)-8, 10, 10);
					oCanvas.fillStyle = html2rgba(opt.strokeColor[i], opt.strokeOpacity);
					oCanvas.fill();
					oCanvas.font = "normal 8pt Verdana";
					oCanvas.fillStyle = html2rgba('#666666', 1);
					oCanvas.textAlign = "left";
					var ctext = captv[i];
					if (opt.ratio == 'y') {ctext = capth[i+1];}
					oCanvas.fillText(ctext, 24, (i+1)*16);
					}
					
				if (opt.type == 'line') {
					var lasty, lastx;
					for(var i = 0 ; i < vals.length ; i++ ){
						oCanvas.beginPath();
						oCanvas.moveTo(0, h-(h_ratio*(vals[i][0])));
						for(var ii = 0 ; ii < vals[i].length ; ii++ ){
							var y = h_ratio*(vals[i][ii]);
							if (y > 0 && y < 1) {y = 1;} // visible 1
							lasty = h-(y);  lastx = w_ratio*ii;
							oCanvas.lineTo( w_ratio*ii, h-(y));
							var ctext = captv[i];
							if (opt.ratio == 'y') {ctext = capth[i+1];}
							areas[ii] += '<br />'+ctext+' '+vals[i][ii];
							}
						oCanvas.lineTo( lastx+3, lasty); // another small dot
						oCanvas.strokeStyle = html2rgba(opt.strokeColor[i], opt.strokeOpacity);
						oCanvas.lineWidth = opt.strokeWidth;
						oCanvas.stroke();
						}
					}
				else if (opt.type == 'bars') {
					for(var i = 0 ; i < vals.length ; i++ ){
						oCanvas.fillStyle = html2rgba(opt.strokeColor[i], opt.strokeOpacity);
						var len = parseInt(w_ratio/vals.length)-1;
						if (vals.length == 1) {len -= 3;}
						var offset = parseInt(len/1.2)*(i);
						for(var ii = 0 ; ii < vals[i].length ; ii++ ){
							var breath = h_ratio*(vals[i][ii]);
							if (breath > 0 && breath < 1) {breath = 1;} // visible 1
							oCanvas.fillRect(parseInt((w_ratio*ii)+offset), h-(breath), len , breath);
							var ctext = captv[i];
							if (opt.ratio == 'y') {ctext = capth[i+1];}
							areas[ii] += '<br />'+ctext+' '+vals[i][ii];
							}
						}
					}
				oCanvas.font = "normal 8pt Verdana";
				oCanvas.fillStyle = html2rgba('#666666', 1);
				oCanvas.textAlign = "left";
				oCanvas.fillText($('caption', oTable).text(), 1, h+34);
				}
			else if (opt.type == "pie") {
				var total_sum = 0;
				for(var i = 0 ; i < vals.length ; i++ ){total_sum += parseFloat(vals[i][1]);}
				var dot = parseInt(oTarget.width()/2);
				var offset = Math.PI/2;
				var lastarc = 0;
				for (var i = 0 ; i < vals.length ; i++ ){
					var val = parseFloat(vals[i][1]/total_sum);
					var newarc = Math.PI*(2*val)+lastarc;
					if (val) {
						oCanvas.beginPath();
						oCanvas.fillStyle = html2rgba(opt.strokeColor[i], opt.strokeOpacity);
						oCanvas.lineWidth = 1;
						oCanvas.arc(dot, opt.radius, opt.radius, lastarc-offset, newarc-offset, false)
						oCanvas.lineTo(dot, opt.radius);
						oCanvas.fill();
						lastarc = newarc;
						}
					}
				}
			}
		function html2rgba(col, op) {
			return 'rgba('+hex2dec(col.substr(1,2))+','+hex2dec(col.substr(3,2))+','+hex2dec(col.substr(5,2))+','+op+')';
			}
		function hex2dec(hex) {
			return Math.max(0, Math.min(parseInt(hex, 16), 255));
			}
		function exportPNG() {
			var img = canvas.get(0).toDataURL("image/png;base64;");
			window.open(img,"Chart","width=500,height=250");
			}
		}
})(jQuery);