var geocoder;
var map;

(function($) {
	$.fn.doGoogleMap = function(opt) {
		var defaults = {
			address: 'Wien, AT',
			title: 'Wien',
			zoom: 17
		};
		opt = $.extend(defaults, opt);
		var map_canva = $(this);
		geocoder = new google.maps.Geocoder();
		geocoder.geocode( { 'address': opt.address}, function(results, status) {
			if (status == google.maps.GeocoderStatus.OK) {
				var mapOptions = {
				zoom: opt.zoom,
				center: results[0].geometry.location,
				disableDefaultUI: true,
				zoomControl: true,
				mapTypeId: google.maps.MapTypeId.ROADMAP
				}
				map = new google.maps.Map(document.getElementById(map_canva.attr('id')), mapOptions);
				var marker = new google.maps.Marker({map: map, position: results[0].geometry.location, title: opt.title});
				}
			else {
				map_canva.html('<p>F&uuml;r diese Veranstaltung ist keine Landkarte verf&uuml;gbar</p>');
				}
			});
	}
})(jQuery);