/**
 * @Author: consentio
 * @Date:   2018-08-18T16:58:21+02:00
 * @Last modified by:   consentio
 * @Last modified time: 2023-08-23T16:52:08+02:00
 */



/*
  CONSENTIO
  Frontend Utilities
*/

var eResize = false;
$(document).ready(function(){
	$().sokoban();
	$("[data-expand='1']").expanda();
	$('#ajax-basket').basket();
	$('#burger').burger();
	$("[data-scroll='toggle:withHeader']").hide();
	$("[data-app='popup']").popLink();
	$("[data-app='popme']").readPopup();
	$("[data-modal]").toggle_modal();
	$("[data-app='yo-submit']").on('click', function(){$(this).closest('form').submit();});
	});

// read sticky elements
var stickies = {};
$(document).ready(function(){$("[data-sticky='true']").each(function() {
	var top = $(this).offset().top;
	var width = $(this).width();
	var me = $(this).attr('id');
	stickies[me] = {'top': top, 'width': width};
	});});

// smooth scroll to target
$(document).ready(function(){$("[data-smroll]").click(function(e) {
	var target = $(this).attr('href');
	var speed = $(this).attr('data-smroll');
	e.preventDefault();
	$('html, body').animate({scrollTop:$(target).offset().top}, speed);
	});});

// resize events
$(window).resize(function() {
	if (eResize) {clearTimeout(eResize)}
	eResize = setTimeout(function() {
		if (!$('input:focus').attr('id')) {$().sokoban();}
		$('#sidebar').hide();
		}, 100);
	});

// scroll events
$(window).scroll(function() {
	if ($('header').amIhere('b')) {$("[data-scroll='toggle:withHeader']").hide('fast');}
	else {$("[data-scroll='toggle:withHeader']").show('fast');}
	$("[data-scroll^='inSight']").each(function(){
		var obj = $(this);
		if (obj.amIhere()) {
			var f = obj.attr('data-scroll').split(':');
			obj.removeAttr('data-scroll'); // one time
			eval(f[1]);
			}
		});
		var wTop = $(window).scrollTop();
		for (var key in stickies) {

			if (wTop > stickies[key].top) {
				if ($('#clone'+key).attr('class') === undefined) {
					var sticky = $('#'+key).clone();
					sticky.addClass('sticky').attr('id', 'clone'+key);
					// clone width
					sticky.css('width', stickies[key].width+'px')
					// clone th-width
					var thwidth = [];
					$('#'+key).find('th').each(function(i){thwidth[i] = $(this).width();})
					sticky.find('th').each(function(i){$(this).width(thwidth[i]);});
					$('#'+key).before(sticky);
					}
				}
			if (wTop <= stickies[key].top) {$('#clone'+key).remove();}
			}
	});


// play sokoban with elements for mobile devices
(function($) {
	$.fn.sokoban = function() {
		if ($('.grid').first().width() <= 767) {
			$('aside#left').insertAfter('main');
			$("[data-mobile='hide']").hide();
			$("[data-mobile='show']").show();
			}
		if ($('.grid').first().width() >= 767) {
			$('aside#left').insertBefore('main');
			$("[data-mobile='hide']").show();
			$("[data-mobile='show']").hide();
			}
		}
})(jQuery);

// expand click_area
(function($) {
	$.fn.expanda = function() {
	this.each(function() {
		var obj = $(this);
		var link = $('a', obj).attr('href');
		obj.css('cursor', 'pointer');
		obj.click(function(){window.location = link;});
		});
	}
})(jQuery);

// yo-box a lightbox

(function($) {
	$.fn.yoBox = function(opt) {
		var defaults = {
			'close': 'close',
			'previous': 'previous',
			'next': 'next',
			'id': 'lightbox'
			}
		var slides = this;

		function go(a, n) {
			$('.yo-mod').fadeOut();
			$(document).off('keypress');
			n = a+n;
			if (n >= slides.length) {n = 0;}
			if (n < 0) {n = slides.length-1;}
			show(n);
			}

		function show(n) {
			obj = $(slides[n]);
			var wraper = $('<div>').addClass('yo-mod yo-cont yo-an-fade');
			var pict = $('<img>').attr({'src': obj.attr('href')}).css('display', 'block');
			var title = obj.attr('title') == undefined || obj.attr('title') == ' ' ? false : $('<p>').text(obj.attr('title'));
			close = $('<a>').addClass('yo-tr yo-btn').attr({'href': '#', 'title': opt.close}).html('<i class="fas fa-times-circle fa-2x"></i>');
			next = $('<a>').addClass('yo-r yo-btn').attr({'href': '#', 'title': opt.next}).html('<i class="fas fa-chevron-right fa-2x"></i>');
			prev = $('<a>').addClass('yo-l yo-btn').attr({'href': '#', 'title': opt.previous}).html('<i class="fas fa-chevron-left fa-2x"></i>');
			wraper.click(function(e){$('.yo-mod').fadeOut(); $(document).off('keypress');});
			close.click(function(e){$('.yo-mod').fadeOut(); $(document).off('keypress');});
			next.click(function(e){go(n, 1); e.stopPropagation();});
			prev.click(function(e){go(n, -1); e.stopPropagation();});
			var vp = $('<div>').addClass('yo-mod-content yo-an-zoom').attr({'id': opt.id}).append(pict).append(close);
			if (n < slides.length-1) {vp.append(next);}
			if (n != 0) {vp.append(prev);}
			if (title) {
				title = $('<div>').addClass('yo-br').html(title);
				vp.append(title);
				}
			wraper.append(vp);
			$('body').append(wraper);
			wraper.show();
			$(document).on('keypress', function(e) {
				if(e.keyCode == 13 || e.keyCode == 27) {e.preventDefault(); $('.yo-mod').fadeOut(); $(document).off('keypress');}
		  		});
			}

		opt = $.extend(defaults, opt);
		this.each(function(i) {
			var obj = $(this);
			obj.click(function(e){e.preventDefault();show(i);});
		});
	}
})(jQuery);

// burger menue (yo)
(function($) {
	$.fn.burger = function() {
	var obj = $(this);
	var btnc = obj.css('color');
	var sidebar = $('<div>').attr('id', 'sidebar').addClass('yo-sidebar hide-desktop');
	var ul = $('#menue').clone(false);
	ul.removeAttr('id').removeClass(); $('ul,li,a', ul).removeClass();
	close = $('<a>').addClass('yo-right').attr({'href': '#'}).html('<i class="fas fa-times-circle fa-lg"></i>');
	close.click(function(e){e.preventDefault(); $('#sidebar').fadeOut();});
	sidebar.append(close).append(ul);
	if (obj.attr('data-incl')) {
		var incl = obj.attr('data-incl');
		sidebar.append($('#'+incl).clone(false));
		}
	//$('a[href^=#]', sidebar).click(function(e){$('#sidebar').fadeOut();});
	$('#site').prepend(sidebar);
	obj.click(function(e){
		e.preventDefault();
		if ($('#sidebar').css('display') == 'block') {$('#sidebar').fadeOut();}
		else {$('#sidebar').show();}
		});
	}
})(jQuery);

// collapse
(function($) {
	$.fn.collapse = function(options) {
	var defaults = {
		t: '+',
		t2: '-',
		s: 500,
		c: 'unfold',
		c2: 'fold'
		}
	options = $.extend(defaults, options);
	this.each(function() {
		var obj = $(this);
		var t = options.t;
		var t2 = options.t2;
		// fieldset
		var legend = obj.find("legend:first");
		// headers
		if (!legend.html()){legend = obj.find(":header:first");}
		if (!legend.html()){legend = obj.find(".leg");}
		if (legend.html()){
			t = legend.html();
			t2 = legend.html();
			};
		var inside = obj.children().not(legend);
		if (obj.attr('data-bind')) {inside = $('#'+obj.attr('data-bind'))}
		var anch = legend.attr('id') || "";
		var txt = $('<a>').attr('href', '#'+anch).append(t).css('outline', '0px');
		if (options.c) {txt.addClass(options.c);}
		txt.on("click",function(){
			if (inside.css('display') === "none"){
				inside.slideDown(options.s);
				$(this).html(t2)
				txt.addClass(options.c2);
				txt.removeClass(options.c);
				}
			else {
				inside.slideUp(options.s);
				$(this).html(t);
				txt.addClass(options.c);
				txt.removeClass(options.c2);
				}
				return false;
			});
		if (legend.html()) {legend.html(txt);}
		else {obj.prepend(txt);}
		if (!obj.attr('data-open')) {inside.hide();}
		if(obj.attr('data-close')) {ismir = setTimeout(function() {inside.slideUp(500);}, obj.attr('data-close'));}
		});
	}
})(jQuery);

// just  dummies do nothing
(function($) {$.fn.doLoading = function(options) {}})(jQuery);
(function($) {$.fn.dontleaveme = function(todo) {}})(jQuery);

// some one hides and displays someone else
(function($) {
	$.fn.toggle_modal = function() {
	this.each(function() {
		var a = $(this);
		var obj = $('#'+a.attr('data-modal'));
		var c1 = a.html();
		var c2 = c1.replace('down', 'up'); // chevron-up ig
		a.on("click",function(e){
			if (obj.css('display') === "none"){e.preventDefault();obj.slideDown(); a.html(c2);}
			else {e.preventDefault();obj.slideUp(); a.html(c1);}
			});
		});
	}
})(jQuery);

(function($) {
	$.fn.amIhere = function(where) {
	var wTop = $(window).scrollTop();
	var wBottom = wTop + $(window).height();
	var oTop = $(this).offset().top;
	var oBottom = oTop + $(this).height();
	if (where == 'b') {return (oBottom >=  wTop);}
	else {return (oTop <= wBottom);}
	}
})(jQuery);

(function($) {
	$.fn.easyAdmin = function(options) {
		var defaults = {
			'title': 'Easy Admin',
			'script': false
			};
		options = $.extend(defaults, options);
		var oBody = $(this);
		var bubble = $("<div>").attr('class', 'eAbub').css({'display': 'none', 'position': 'absolute', 'border-radius': '8px', 'box-shadow': '0px 0px 20px 0px #999999', 'z-index': 20000, 'padding': '8px', 'background-color': 'rgba(0, 0, 0, 0.75)', 'color': '#FFFFFF', 'font-size': '0.8em'}).append(options.title);
		oBody.append(bubble);
		var setC = check_coco();
		// avoid easy admin in preview
		if ($('#subform', window.parent.document.body).attr('id') == "subform") {setC = 0;}
		if (setC) {
			$(':not(iframe)').contents().filter(function(){return this.nodeType == 8; }).each(function(i, e){
				oComment = $(this);
				var pat = /A=.*/g;
				while (pat.exec(e.nodeValue)) {
					var ac; var id;
					var pat = /A=(\w*)/g;
					var mat = pat.exec(e.nodeValue)
					var oHref = $('<a>').attr({'href': options.script+'?_id='+mat[1], 'target': 'easyAdmin'});
					ac = mat[1] || '';
					pat = /A=(\w*) ID=(\d*)/g;
					mat = pat.exec(e.nodeValue)
					if (mat) {
						oHref = $('<a>').attr({'href': options.script+'?_id='+mat[1]+'&rid='+mat[2]+'&todo=edit', 'target': 'easyAdmin', 'data-app': 'easyad'});
						ac = mat[1]; id = mat[2];
						oHref.append('<i class="fas fa-edit"></i>');
						oHref.hover(function(e){
							tooltip(e, ac, id).fadeIn('fast');},function() {
							tooltip().fadeOut('fast');$(".eAbub").html(options.title);
							});
						$(this).mousemove(tooltip);
						oComment.before(oHref);
						}
					}
				});
			}
		function check_coco() {
			var cookies = document.cookie.split('; ');
			var setC = false;
			for (var i = 0, pair; pair = cookies[i] && cookies[i].split('='); i++) {
				if (pair[0] === "coco") {setC = pair[1] || 0;}
				}
			return setC;
			}

		function tooltip(event, action, id) {
			if (check_coco()) {
				if (action) {
				$.ajax({
				type: "POST",
				url: options.script,
				data: "_id=ajax&todo=eAd&ac="+action+"&rid="+id,
				dataType: "html",
				success: function(msg){$(".eAbub").html(msg);},
				error: function(x, msg, z){$(".eAbub").html(msg);}
				});
				}
				if (event) {
					var top = event.pageY - 20;
					var left = event.pageX + 20;
					bubble.css({
						'top': top + "px",
						'left': left + "px"
					});
					}
				}
			else {
				$("[data-app='easyad']").remove();
				bubble = false;
				}
			return bubble;
			}

		}
	})(jQuery);

// ajax call basket
(function($) {
	$.fn.basket = function() {
		var me = $(this);
		if(me.length){
			$.ajax({
			type: "GET",
			url: '/shop/',
			data: "_id=basket",
			dataType: "html",
			success: function(msg){me.replaceWith(msg);},
			error: function(x, msg, z){me.replaceWith(msg);}
			});
			}
		}
	})(jQuery);

// opens a div layer as popup
(function($) {
	$.fn.readPopup = function(options) {
		var defaults = {
			'header': "&nbsp;",
			'img': '/co_icons/close_window.png',
			'top': '35%',
			'left': '38%'
			};
		options = $.extend(defaults, options);
		this.each(function() {
			var me = $(this);
			var txt = $('#'+me.attr('data-layer')).html();
			if (me.attr('data-header')) {options.header = me.attr('data-header');}
			if (me.attr('data-img')) {options.img = me.attr('data-img');}
			$(this).click(function(){$('#site').popUp({'header': options.header, 'body':txt, 'img': options.img, 'top': options.top, 'left': options.left})});
			$(this).css({'cursor': 'pointer'});
			});
		}
	})(jQuery);
