/* backend standard javascript
   for consentio et alii*/

// read sticky elements
var stickies = {};
$(document).ready(function(){$("[data-sticky='true']").each(function() {
	var top = $(this).offset().top;
	var width = $(this).width();
	var me = $(this).attr('id');
	stickies[me] = {'top': top, 'width': width};
	});});

// toggle checkboxes
$(document).ready(function(){$("[data-app='checkBoxControll']").each(function() {
	oMe = $(this);
	oMe.css('cursor', 'pointer');
	oMe.click(function(){
		$('[data-app=check_all]').each(function(){
			$(this).prop('checked') == true ? $(this).prop('checked', false) : $(this).prop('checked', true);
			});
		});
	});});

$(window).scroll(function() {
	var wTop = $(window).scrollTop();
		for (var key in stickies) {
			if (wTop > stickies[key].top) {
				if ($('#clone'+key).attr('class') === undefined) {
					var sticky = $('#'+key).clone();
					sticky.addClass('sticky').attr('id', 'clone'+key);
					// clone width
					sticky.css('width', stickies[key].width+'px')
					// clone th-width
					var thwidth = [];
					$('#'+key).find('th').each(function(i){thwidth[i] = $(this).width();})
					sticky.find('th').each(function(i){$(this).width(thwidth[i]);});
					$('#'+key).before(sticky);
					}
				}
			if (wTop <= stickies[key].top) {$('#clone'+key).remove();}
			}
	});

// show icon of a selected element (like a flag)
// deprecated
(function($){
	$.fn.get_icon = function(options){
		var defaults = {
			'icon': "unknown",
			'path': "/co_icons/"
			};
		options = $.extend(defaults, options);
		var oSelect = $(this);
		var id = oSelect.attr('id');
		oSelect.before('<img id="icon_'+id+'" src="'+options.path+options.icon+'.png" class="icon" /> ');
		oSelect.change(function(){
			var val = $('#'+id+' :selected').val();
			$('#icon_'+id).attr('src', options.path+val+'.png');
			});
		return false;
		}
	})(jQuery);

// enhance selectbox
(function($){
	$.fn.enhanSel = function(opt){
		var defaults = {
			'height': '15em',
			'width': 300,
			'img_w': 16, // icons
			'img_h': 16,
			'selected': 'ac_over',
			'speed': 400
			};
		opt = $.extend(defaults, opt);
		this.each(function() {
			var oSelect = $(this);
			var id = oSelect.attr('id');
			var val = oSelect.val();
			var txt = $('option:selected', oSelect).text();
			var w = parseInt(opt.width+opt.img_width)
			var oDiv = $('<div>').attr({'id': 'display_'+id, 'class': 'enhanSel'});
			var oDiv2 = $('<div>').attr({'id': 'drop_'+id, 'class': 'enhanSelDropdown'});
			oDiv2.css({'display': 'none', 'max-height': opt.height, 'overflow-y': 'auto', 'position': 'absolute', 'z-index': 100, 'background-color': 'white'})
			var oVal = $('<a>').attr({'class': 'enhanSelAnchor', 'href': 'javascript:void(0)'}).css({'line-height': opt.img_h+'px'}).text(txt);
			oVal.click(function(){
				if ($('#drop_'+id).css('display') === "none"){$('#drop_'+id).slideDown(opt.speed);}
				else {$('#drop_'+id).slideUp(opt.speed);}
				});
			//oVal.blur(function(){$('#drop_'+id).slideUp(opt.speed);});
			var oUl = $('<ul>');
			var oImg = false;
			var lh = opt.img_h+3;
			$('option', oSelect).each(function() {
				oOpt = $(this);
				var value = oOpt.attr('value');
				if (!value) {value = oOpt.text();}
				var oLi = $("<a>").css({'line-height': lh+'px', 'white-space': 'nowrap', 'overflow': 'hidden', 'text-overflow': ''}).attr({'href': 'javascript:void(0)'}).html(oOpt.text());
				oLi.attr('data-val', value);
				if (oOpt.attr('data-img')) {
					var pad = parseInt(opt.img_w + 10)+'px';
					if (!oImg) {oImg = $('<div>').attr('class', 'enhanSelImg').css({'display': 'inline-block', 'float': 'left', 'width': opt.img_w+'px', 'height': opt.img_h+'px', 'margin': '4px 8px 0px 4px'}).text(' ');}
					if (val == value) {
						oImg.css({'background-image': 'url('+oOpt.attr('data-img')+')', 'background-position': 'top left', 'background-repeat': 'no-repeat'});
						if (oOpt.attr('data-img-offset')) {oImg.css({'background-position': '0px '+oOpt.attr('data-img-offset')+'px'})}
						}
					oLi.css({'background': 'url('+oOpt.attr('data-img')+') no-repeat', 'padding-left': pad})
					oLi.attr('data-img', oOpt.attr('data-img'));
					if (oOpt.attr('data-img-offset')) {
						oLi.css({'background-position': '0px '+oOpt.attr('data-img-offset')+'px'});
						oLi.attr('data-img-offset', oOpt.attr('data-img-offset'));
						}
					}
				oLi.click(function(){
					oMe = $(this);
					oMeImg = $('.enhanSelImg', $('#display_'+id));
					oSelect.val(oMe.attr('data-val'));
					if (oMe.attr('data-img')) {
						oMeImg.css({'background-image': 'url('+oMe.attr('data-img')+')', 'background-position': '0px 0px'});
						}
					if (oMe.attr('data-img-offset')) {oMeImg.css({'background-position': '0px '+oMe.attr('data-img-offset')+'px'})}
					$('a.enhanSelAnchor', $('#display_'+id)).text(oMe.text());
					$('#drop_'+id).slideUp(opt.speed);
					})
				oLi.mouseover(function(){$(this).addClass(opt.selected)});
				oLi.mouseout(function(){$(this).removeClass(opt.selected)});
				oLi.focus(function(){$(this).addClass(opt.selected)});
				oLi.blur(function(){$(this).removeClass(opt.selected)});
				oUl.append($('<li>').html(oLi));
				});
			if (oImg) {oDiv.append(oImg)}
			oDiv.append(oVal);
			oDiv2.append(oUl);
			oDiv.append(oDiv2);
			oSelect.after(oDiv);
			oSelect.hide();
			});

		}
	})(jQuery);

// add a loading message
(function($) {
	$.fn.doLoading = function(options) {
		var defaults = {
			'img': "sync",
			'loading': "Loading..."
			};
		var oDiv = $(this);
		options = $.extend(defaults, options);
		var oMessage = $('<div class="dlg"></div>');
		oMessage.css({'display': 'none', 'z-index': 10000, 'position': 'fixed', 'top': '25%', 'left': 0, 'right': 0, 'width': '200px', 'padding' : '3em 1em', 'text-align': 'center'});
		oMessage.append('<p><i class="fas fa-'+options.img+' fa-4x fa-spin green"></i></p><p>'+options.loading+'</p>')
		oDiv.prepend(oMessage);
		$('form').submit(function() {
			oMessage.show();
			});
		}
	})(jQuery);

// warning message after changed inputs without submit
(function($) {
	$.fn.dontleaveme = function(todo) {
		if (todo === true) {$(window).on('beforeunload', function(e) {e.returnValue = false; return false;});}
		else {$(window).off('beforeunload');}
		}
	})(jQuery);


// Tooltip with popup
(function($) {
	$.fn.foolTip = function(opt) {
		var defaults = {
			fadeIn: 200,
			fadeOut: 200,
			header: 'Help',
			top: '40px',
			left: '40px'
			};

		opt = $.extend(defaults, opt);
		var bubble;

		function tooltip(event) {
			if (!bubble) {bubble = $('<div class="bubble"></div>').appendTo(document.body).hide();}
			if (event) {
				var h = $(window).height();
				var w = $(window).width();
				var bw = $(".bubble").width();
				var top = event.pageY + 5;
				var left = event.pageX + 5;
				if (bw > w) { left = 0; bw = w-10;}
				else if (left+bw > w) {left -= bw/2;}
				else {if (top > (2*(h/3))) {top -= $(".bubble").height()/2;}}
				bubble.css({
					'top': top + "px",
					'left': left + "px",
					'width': bw + "px"
				});
			}
		return bubble;
		}

		this.each(function() {
			$(this).css('cursor', 'help')
			$(this).hover(function(e){this.t = $('#bubble'+this.id).html();tooltip(e).html(this.t).fadeIn(opt.fadeIn);},function() {tooltip().fadeOut(opt.fadeOut);});
			$(this).mousemove(tooltip);
			var ifrSrc = $(this).attr('href');
			// popUp comes from backend-utilities.js
			$(this).click(function(){
				var w = $(window).width();
				var iw = 780;
				if (iw >= w) {opt.left = '0px'; iw = w-20;}
				var ifr = '<iframe width="'+iw+'" height="460" src="'+ifrSrc+'">&nbsp;</iframe>';
				$('#site').popUp({'header': opt.header, 'body':ifr, 'top': opt.top, 'left': opt.left});
				});
			$(this).removeAttr("target").removeAttr("href");
		});
	}})(jQuery);

// instead popup
(function($) {
	$.fn.popUp = function(options) {
		var defaults = {
			'header': "H2",
			'body': "text",
			'top': '20%',
			'left': '25%',
			'id': 'popup'+parseInt(Math.random()*1000),
			'timeout': false // seconds, after that the window closes
			};
		options = $.extend(defaults, options);
		var oDiv = $(this);
		var zi = 2000;

		function next_z (z) {
			$('.dlg').each(function(){
				if (parseInt($(this).css('z-index')) > z) {z = parseInt($(this).css('z-index'));}
				});
			z++;
			return z;
			}

		zi = next_z(zi);
		var target = $(document);
		if (oDiv.attr('id') == 'site' && $('#site').attr('id') == undefined) {target = $(parent.document); zi += 100;}
		var oMessage = $('<div class="dlg"></div>').attr({'class': 'dlg', 'id': options.id});
		oMessage.css({'display': 'none', 'margin': 0, 'z-index': zi, 'position': 'fixed', 'top': options.top, 'left': options.left});
		oMessage.append('<h2>'+options.header+'</h2><div>'+options.body+'</div>')

		$('h2', oMessage).css('cursor', 'move');
		$('h2', oMessage).mousedown(function(e){
			e.preventDefault();
			e.stopPropagation();
			var o = oMessage.offset()
			var a = e.pageY - o.top;
			var b = e.pageX - o.left;
			zi = next_z(zi);
			oMessage.css({'opacity': '0.8', 'z-index': zi});
			target.on('mousemove', function(e){move(e, oMessage, a, b);});
			});
		target.mouseup(function(){
			oMessage.css('opacity', '1');
			target.off('mousemove');
			});
		var close = $('<img>').attr({'src': '/co_icons/close_window.png', 'align': 'right'}).css({'margin': '2px', 'cursor': 'pointer'}).on("click",function(){oMessage.fadeOut('slow',function(){oMessage.remove();});});
		$('h2', oMessage).append(close);
		oDiv.prepend(oMessage);
		oMessage.fadeIn('slow');

		if(options.timeout) {
			window.setTimeout(function(){oMessage.fadeOut('slow',function(){oMessage.remove();});}, options.timeout*1000);
			}

		function move(e, win, a, b) {
		if (e) {
			var top = e.clientY - a;
			var left = e.clientX - b;
			win.css({'top': top + "px", 'left': left + "px"});
			}

	return false;
	}
		}
	})(jQuery);

// opens a link as popup in an iframe
(function($) {
	$.fn.popLink = function(opt) {
		var defaults = {
			'header': "H2",
			'iframeId': "subform",
			'width': '850',
			'height': '460',
			'top': '20px',
			'left': '25px'
			};
		opt = $.extend(defaults, opt);
		var w = $(window).width();
		if (opt.width >= w) {opt.left = '0px'; opt.width = w-20;}

		this.each(function() {
			var ifr = '<iframe id="'+opt.iframeId+'"width="'+opt.width+'" height="'+opt.height+'" src="'+$(this).attr('href')+'">&nbsp;</iframe>';
			$(this).click(function(){$('#site').popUp({'header': opt.header, 'body':ifr, 'top': opt.top, 'left': opt.left})});
			$(this).css({'cursor': 'pointer'});
			$(this).removeAttr("target").removeAttr("href");
			});
		}
	})(jQuery);

// upload helper (single file)
(function($) {
	$.fn.fupl = function() {
		this.each(function() {
			var oFile = $(this);
			var id = oFile.attr('id').replace('ifile', 'ti');
			oFile.change(function(e){$(this).siblings('span').text(e.target.files[0].name);
			var mime = e.target.files[0].type;
			// update preview
			if (mime == 'image/gif' || mime == 'image/jpeg' || mime == 'image/png') {
				if (typeof (FileReader) != "undefined") {
					var oIMG = $("#"+id);
					var reader = new FileReader();
					reader.onload = function(e) {
						oIMG.attr('src', e.target.result);
						var dummy = new Image();
						//dummy.onload = function() {alert('hu'+dummy.width);}
						dummy.src = e.target.result;
						}
					reader.readAsDataURL($(this)[0].files[0]);
					}
			}
			});});
		}
	})(jQuery);


// opens assistant
(function($) {
	$.fn.assistant = function(opt) {
		var defaults = {
			'action': 'assistant',
			'type': 'pages',
			'title': 'foo',
			'sid': false,
			'thumbdir': '/pictures/thumbs/',
			'width': 800,
			'left':  '20px',
			'img': 'link'
			};
		opt = $.extend(defaults, opt);
		var w = $(window).width();
		if (opt.width >= w) {opt.left = '0px'; opt.width = w-20;}

		this.each(function() {
			var oInput = $(this);
			if (opt.type === 'image') {
				oInput.focus(function(){if (oInput.val()) {$('#t'+oInput.attr('id')).attr('src', opt.thumbdir+oInput.val());}});
				}
			// iframe and popup must target to parent
			var target = $('#site');
			if ($('body').attr('id') == 'single') {target = $('#site', parent.document);}
			var oIframe = '<iframe width="'+opt.width+'" height="500" src="index.php?_id='+opt.action+'&sid='+opt.sid+'&target='+oInput.attr('id')+'&type='+opt.type+'">&nbsp;</iframe>';
			var oImg = $('<i>').attr({'class': 'fas fa-'+opt.img+' white', 'title': opt.title,}).css({'padding': '6px', 'cursor': 'pointer'});
			oImg.click(function(){target.popUp({'header': opt.title, 'body': oIframe, 'top': '10%', 'left': opt.left, 'id': 'pp'+oInput.attr('id')});});
			oInput.after(oImg);
			});
		}
	})(jQuery);

// more input fields depending on value
(function($) {
	$.fn.moreInputs = function (opt) {
		var defaults = {
			'script': false,
			'id': false,
			'todo': false,
			'sid': false
			};
		opt = $.extend(defaults, opt);
		this.each(function() {
			var oMe = $(this);
			oMe.on('change', ask);

			function ask(){
				var deps = $("[data-app='"+oMe.attr('name')+"_dep_field']");
				deps.hide('slow',function(){deps.remove();});
				$.ajax({
					type: "POST",
					url: opt.script,
					data: "sid="+opt.sid+"&_id="+opt.id+"&todo="+opt.todo+"&_v="+oMe.val()+"&_ref="+oMe.attr('name'),
					dataType: "html",
					success: function(msg){
						if (msg) {
							var fields = $('<div>').attr({'data-app': oMe.attr('name')+"_dep_field"});
							fields.css('display', 'none');
							fields.html(msg)
							$("#row"+oMe.attr('name')).after(fields);
							fields.show('slow');
							}
						}
					});
				return false;
				}
			});
		}
	})(jQuery);


// collapse
(function($) {
	$.fn.collapse = function(options) {
	var defaults = {
		t: '<i class="fas fa-plus-circle fa-pull-right fa-lg" title="+"></i>',
		t2: '<i class="fas fa-minus-circle fa-pull-right fa-lg" title="-"></i>',
		s: 500,
		c: 'fold',
		c2: 'unfold'
		}
	options = $.extend(defaults, options);
	this.each(function() {
		var obj = $(this);
		var t = options.t;
		var t2 = options.t2;
		// fieldset
		var legend = obj.find("legend:first");
		// headers
		if (!legend.html()){legend = obj.find(":header:first");}
		var inside = obj.children().not(legend);
		var anch = legend.attr('id') || "";
		var txt = $('<a>').attr('href', '#'+anch).append(options.t).css('outline', '0px');
		txt.on("click",function(){
			if (inside.css('display') === "none"){
				inside.slideDown(options.s);
				$(this).html(t2)
				obj.addClass(options.c);
				obj.removeClass(options.c2);
				}
			else {
				inside.slideUp(options.s);
				$(this).html(t);
				obj.addClass(options.c2);
				obj.removeClass(options.c);
				}
				return false;
			});
		legend.append(txt);
		inside.hide();
		obj.addClass(options.c2);
		});
	}
})(jQuery);

// click and toggle flag
(function($) {
	$.fn.toggleFlag = function(options) {
	var defaults = {
		script: 'index.php',
		sid: 0,
		ok: 'OK',
		cancel: 'Abbrechen',
		title: 'Activate/Deactivate'
		}
	options = $.extend(defaults, options);
	this.each(function() {
		var obj = $(this);
		var td = obj.parent('td');
		var item = obj.attr('data-val').split('-');
		var body = $('<div>');
		body.append('<form id="toggle'+item[1]+'">'+
		'<p>'+options.t+'</p>'+
		'<input type="hidden" name="_id" value="ajax" />'+
		'<input type="hidden" name="todo" value="setAttr" />'+
		'<input type="hidden" name="t" value="'+options.action+'" />'+
		'<input type="hidden" name="f" value="'+options.f+'" />'+
		'<input type="hidden" name="id" value="'+item[1]+'" />'+
		'<input type="hidden" name="sid" value="'+options.sid+'" />'+
		'<input type="submit" value="'+options.ok+'" class="button" />&nbsp;'+
		'<input type="submit" id="btn_cancel" value="'+options.cancel+'" class="button" />'+
		'</form>'
		);
		obj.css('cursor', 'pointer');
		obj.on("click", function() {
			td.css('background-color', '#FFFFCC');
			var site = $('#site').html() ? $('#site') : $('#single');
			site.popUp({'header' : options.title, 'body': body.html(), 'left': '40%', 'top': '20%'});
			$('#btn_cancel').click(function() {
				$('.dlg').fadeOut('slow',function(){$('.dlg').remove();});
				td.css('background-color', 'inherit');
				return false;
				});
			$('#toggle'+item[1]).submit(function() {
				$('.dlgtext').html('<p>'+options.t+'</p>');
				var form = $(this);
				$.ajax({
					type: "POST",
					url: options.script,
					data: form.serialize(),
					dataType: "html",
					success: function(msg){
						if (msg === "OK") {
							if (obj.hasClass('green')) {obj.removeClass('green'); obj.addClass('ghost');}
							else {obj.removeClass('ghost'); obj.addClass('green');}
							obj.attr('title', ''); // better none than wrong
							$('.dlg').fadeOut('slow',function(){$('.dlg').remove();});
							}
						else {$('.dlgtext').html('<p class="red">'+msg+'<p>');}
						},
					error: function(x, msg, z){
						alert(msg);
						}
					});
				td.css('background-color', 'inherit');
				return false;
				});
			});
		});
	}
})(jQuery);

// set class for pending or not pending dates
(function($) {
	$.fn.pending = function(opt) {
		var defaults = {
			'css1': "pending",
			'css2': "not_pending",
			'mess1': "pending",
			'mess2': "not pending"
			};
		opt = $.extend(defaults, opt);
		this.each(function() {
			var obj = $(this);
			repaint(obj);
			obj.on("focus", function() {repaint($(this))})
			function repaint(obj) {
				var date = new Date(obj.val());
				if (date.valueOf() < new Date().valueOf()) {obj.removeClass(opt.css1).addClass(opt.css2).attr('title', opt.mess2);}
				else if (date.valueOf() == 16756675200000) {obj.removeClass(opt.css1).addClass(opt.css2).attr('title', opt.mess2);}
				else {obj.removeClass(opt.css2).addClass(opt.css1).attr('title', opt.mess1);}
				}
			});
		}
	})(jQuery);

// preview image
(function($) {
	$.fn.img_preview = function() {
		this.each(function() {
			var obj = $(this);
			var new_src = obj.attr('src');
			new_src = obj.attr('src').replace("\/square", "\/small")
			obj.on("mouseover", function() {
				$('#preview_img').attr('src', new_src);
				});
			});
		}
	})(jQuery);

// replace text with input
(function($) {
	$.fn.smartInput = function(options) {
	var defaults = {
		sid: 0,
		ok: 'OK',
		img: '/graphics/loading.gif',
		img2: '/graphics/checked.png',
		img3: '/graphics/smartInput.png'
		}
	options = $.extend(defaults, options);
	this.each(function() {
		var obj = $(this);
		var t = obj.attr('data-t');
		var f = obj.attr('data-f');
		var rid = obj.attr('data-rid');
		var input = $('<input>').addClass('smart').attr('value', obj.text());
		input.css({'background-image': 'url('+options.img3+')', 'background-position': 'right', 'background-repeat': 'no-repeat'});
		obj.replaceWith(input);
		input.on("click",function() {input.select()});
		input.on("change", function() {
			input.css({'background-image': 'url('+options.img+')'});
			$.ajax({
				type: "POST",
				url: "consentio.pl",
				data: "sid="+options.sid+"&t="+t+"&f="+f+"&rid="+rid+"&v="+input.attr('value')+"&action=smartInput",
				dataType: "html",
				success: function(msg){
					if (msg === "OK") {
						input.css({'background-image': 'url('+options.img2+')'});
						window.setTimeout(function(){input.css({'background-image': 'url('+options.img3+')'})}, 1500);
						}
					else {input.after("ERR")}
					},
				error: function(x, msg, z){
					alert(msg);
					}
				});

			});
		});
	}
})(jQuery);

(function($) {
	$.fn.addToSelect = function(opt) {
	var defaults = {
		alt: 'add',
		img: 'graphics/shift.png'
		}
	opt = $.extend(defaults, opt);
	var Oin = $(this);
	var Oimg = $('<img>').attr({'src': opt.img, 'alt': opt.alt});
	Oimg.on("click",function() {
		var val = $('#human'+opt.field).val();
		if (val) {
			var nval = new Option(val, $('#hidden'+opt.field).val(), false, true);
			$('#i'+opt.field).append(nval);
			$('#hidden'+opt.field).val("");
			$('#human'+opt.field).val("");
			}
		});
	Oin.before("<br />");
	Oin.before(Oimg);
	}
})(jQuery);
