/**
* backend standard javascript
   for consentio et alii
 * @Author: consentio
 * @Date:   2018-08-18T16:58:21+02:00
 * @Last modified by:   consentio
 * @Last modified time: 2022-12-29T18:46:37+01:00
 */

// read sticky elements
var stickies = {};

$(document).ready(
	function(){
		$("[data-sticky='true']").each(function() {
			var top = $(this).offset().top;
			var width = $(this).width();
			var me = $(this).attr('id');
			stickies[me] = {'top': top, 'width': width};
			});
		$("[data-preview='small']").img_preview();
		$("[data-app='toggleLeft']").toggle_left();
		$("[data-app='yo-opener']").each(function() {
			var me = $(this);
			var target = me.attr('data-more');
			me.click(function(){
				var dis = $('#'+target).css('display');
				if (dis == 'none') {$('#'+target).slideDown();}
				else {$('#'+target).slideUp();}
				});
			});
	});

$(window).scroll(function() {
	var wTop = $(window).scrollTop();
		for (var key in stickies) {
			if (wTop > stickies[key].top) {
				if ($('#clone'+key).attr('class') === undefined) {
					var sticky = $('#'+key).clone();
					sticky.addClass('sticky').attr('id', 'clone'+key);
					// clone width
					sticky.css('width', stickies[key].width+'px')
					// clone th-width
					var thwidth = [];
					$('#'+key).find('th').each(function(i){thwidth[i] = $(this).width();})
					sticky.find('th').each(function(i){$(this).width(thwidth[i]);});
					$('#'+key).before(sticky);
					}
				}
			if (wTop <= stickies[key].top) {$('#clone'+key).remove();}
			}
	});

// add a loading message
(function($) {
	$.fn.doLoading = function(options) {
		var defaults = {
			'img': "sync",
			'loading': "Loading..."
			};
		var oDiv = $(this);
		options = $.extend(defaults, options);
		var oMessage = $('<div class="dlg"></div>');
		oMessage.css({'display': 'none', 'z-index': 10000, 'position': 'fixed', 'top': '25%', 'left': 0, 'right': 0, 'width': '200px', 'padding' : '3em 1em', 'text-align': 'center'});
		oMessage.append('<p><i class="fas fa-'+options.img+' fa-4x fa-spin green"></i></p><p>'+options.loading+'</p>')
		oDiv.prepend(oMessage);
		$('form').submit(function(e) {
			var is_safari = navigator.userAgent.indexOf('Safari') != -1 && navigator.userAgent.indexOf('Chrome') == -1 &&  navigator.userAgent.indexOf('Android') == -1;
			var btn = $("button:focus");
			if (btn.attr('type') == 'submit'){oMessage.show();}
			else if (is_safari) {oMessage.show();} // what a piece of shit :P clicked doesn't mean focused... so we fire anyway
			else {return false;} // doesn't fire with return. this should avoid cancel by return
			});
		}
	})(jQuery);

// opens assistant
(function($) {
	$.fn.assistant = function(opt) {
		var defaults = {
			'action': 'assistant',
			'type': 'pages',
			'title': 'foo',
			'sid': false,
			'thumbdir': '/pictures/thumbs/',
			'width': 800,
			'left':  '20px',
			'img': 'link'
			};
		opt = $.extend(defaults, opt);
		var w = $(window).width();
		if (opt.width >= w) {opt.width = w-20;}

		this.each(function() {
			var oInput = $(this);
			if (opt.type === 'image') {
				oInput.focus(function(){if (oInput.val()) {$('#t'+oInput.attr('id')).attr('src', opt.thumbdir+oInput.val());}});
				}
			// iframe and popup must target to parent
			var target = $('#site');
			if ($('body').attr('id') == 'single') {target = $('#site', parent.document);}
			var oIframe = '<iframe width="'+opt.width+'" height="500" src="index.php?_id='+opt.action+'&sid='+opt.sid+'&target='+oInput.attr('id')+'&type='+opt.type+'">&nbsp;</iframe>';
			var oImg = $('<i>').attr({'class': 'fas fa-'+opt.img+' white', 'title': opt.title,}).css({'padding': '6px', 'cursor': 'pointer'});
			oImg.click(function(){target.popUp({'header': opt.title, 'body': oIframe, 'top': '20px', 'left': opt.left, 'id': 'pp'+oInput.attr('id')});});
			oInput.after(oImg);
			});
		}
	})(jQuery);

// toggle disable/enable depending on value
(function($) {
	$.fn.toggle_dis = function () {
		this.each(function() {
			var oMe = $(this);
			oMe.on("click", toggleDep);
			if (oMe.is(':checked')) {
				$("[data-dep='"+oMe.attr('id')).each(function() {
					$(this).removeAttr('disabled');
					var id = $(this).attr('id');
					$("label[for='"+id+"']").removeClass('grey');
					});
				}
			else {
				$("[data-dep='"+oMe.attr('id')).each(function() {
					$(this).prop('disabled', 'disabled');
					var id = $(this).attr('id');
					$("label[for='"+id+"']").addClass('grey');
					});
				}
			});

		function toggleDep() {
			oMe = $(this);
			if (oMe.is(':checked')) {
				$("[data-dep='"+oMe.attr('id')).each(function() {
					$(this).removeAttr('disabled');
					var id = $(this).attr('id');
					$("label[for='"+id+"']").removeClass('grey');
					});
				}
			else {
				$("[data-dep='"+oMe.attr('id')).each(function() {
					$(this).prop('disabled', 'disabled');
					$(this).prop('checked', false);
					var id = $(this).attr('id');
					$("label[for='"+id+"']").addClass('grey');
					});
				}
			}
		}
	})(jQuery);

// set value on click
(function($) {
	$.fn.checkNset = function () {
		this.each(function() {
			var oMe = $(this);
			oMe.on("click", setDep);
			});

		function setDep() {
			oMe = $(this);
			if (oMe.is(':checked')) {
				var oField = $("[data-dep='"+oMe.attr('id'));
				oField.attr('data-save', oField.val());
				oField.val(oMe.attr('data-set'));
				}
			else {
				var oField = $("[data-dep='"+oMe.attr('id'));
				oField.val(oField.attr('data-save'));
				}
			}
		}
	})(jQuery);

// more input fields depending on value
(function($) {
	$.fn.moreInputs = function (opt) {
		var defaults = {
			'script': false,
			'id': false,
			'todo': false,
			'sid': false
			};
		opt = $.extend(defaults, opt);
		this.each(function() {
			var oMe = $(this);
			oMe.on('change', ask);

			function ask(){
				var deps = $("[data-app='"+oMe.attr('name')+"_dep_field']");
				deps.hide('slow',function(){deps.remove();});
				$.ajax({
					type: "POST",
					url: opt.script,
					data: "sid="+opt.sid+"&_id="+opt.id+"&todo="+opt.todo+"&_v="+oMe.val()+"&_ref="+oMe.attr('name'),
					dataType: "html",
					success: function(msg){
						if (msg) {
							var fields = $('<div>').attr({'data-app': oMe.attr('name')+"_dep_field"});
							fields.css('display', 'none');
							fields.html(msg)
							$("#row"+oMe.attr('name')).after(fields);
							fields.show('slow');
							}
						}
					});
				return false;
				}
			});
		}
	})(jQuery);


// collapse
(function($) {
	$.fn.collapse = function(options) {
	var defaults = {
		t: '<i class="fas fa-plus-circle fa-pull-right fa-lg" title="+"></i>',
		t2: '<i class="fas fa-minus-circle fa-pull-right fa-lg" title="-"></i>',
		s: 500,
		c: 'fold',
		c2: 'unfold'
		}
	options = $.extend(defaults, options);
	this.each(function() {
		var obj = $(this);
		var t = options.t;
		var t2 = options.t2;
		// fieldset
		var legend = obj.find("legend:first");
		// headers
		if (!legend.html()){legend = obj.find(":header:first");}
		var inside = obj.children().not(legend);
		var anch = legend.attr('id') || "";
		var txt = $('<a>').attr('href', '#'+anch).append(options.t).css('outline', '0px');
		txt.on("click",function(){
			if (inside.css('display') === "none"){
				inside.slideDown(options.s);
				$(this).html(t2)
				obj.addClass(options.c);
				obj.removeClass(options.c2);
				}
			else {
				inside.slideUp(options.s);
				$(this).html(t);
				obj.addClass(options.c2);
				obj.removeClass(options.c);
				}
				return false;
			});
		legend.append(txt);
		inside.hide();
		obj.addClass(options.c2);
		});
	}
})(jQuery);

// click and toggle flag
(function($) {
	$.fn.toggleFlag = function(options) {
	var defaults = {
		script: 'index.php',
		sid: 0,
		ok: 'OK',
		cancel: 'Abbrechen',
		title: 'Activate/Deactivate'
		}
	options = $.extend(defaults, options);
	this.each(function() {
		var obj = $(this);
		var td = obj.parent('td');
		var item = obj.attr('data-val').split('-');
		var body = $('<div>');
		body.append('<form id="toggle'+item[1]+'">'+
		'<p>'+options.t+'</p>'+
		'<input type="hidden" name="_id" value="ajax" />'+
		'<input type="hidden" name="todo" value="setAttr" />'+
		'<input type="hidden" name="t" value="'+options.action+'" />'+
		'<input type="hidden" name="f" value="'+options.f+'" />'+
		'<input type="hidden" name="id" value="'+item[1]+'" />'+
		'<input type="hidden" name="sid" value="'+options.sid+'" />'+
		'<input type="submit" value="'+options.ok+'" class="button" />&nbsp;'+
		'<input type="submit" id="btn_cancel" value="'+options.cancel+'" class="button" />'+
		'</form>'
		);
		obj.css('cursor', 'pointer');
		obj.on("click", function() {
			td.css('background-color', '#FFFFCC');
			var site = $('#site').html() ? $('#site') : $('#single');
			site.popUp({'header' : options.title, 'body': body.html(), 'left': '40%', 'top': '20%'});
			$('#btn_cancel').click(function() {
				$('.dlg').fadeOut('slow',function(){$('.dlg').remove();});
				td.css('background-color', 'inherit');
				return false;
				});
			$('#toggle'+item[1]).submit(function() {
				$('.dlgtext').html('<p>'+options.t+'</p>');
				var form = $(this);
				$.ajax({
					type: "POST",
					url: options.script,
					data: form.serialize(),
					dataType: "html",
					success: function(msg){
						if (msg === "OK") {
							if (obj.hasClass('green')) {obj.removeClass('green'); obj.addClass('ghost');}
							else {obj.removeClass('ghost'); obj.addClass('green');}
							obj.attr('title', ''); // better none than wrong
							$('.dlg').fadeOut('slow',function(){
								$('.dlg').remove();
								if (options.r == 1) {location.reload(true);}
								});
							}
						else {$('.dlgtext').html('<p class="red">'+msg+'<p>');}
						},
					error: function(x, msg, z){
						alert(msg);
						}
					});
				td.css('background-color', 'inherit');
				return false;
				});
			});
		});
	}
})(jQuery);

// preview image
(function($) {
	$.fn.img_preview = function() {
		this.each(function() {
			var obj = $(this);
			var new_src = obj.attr('src');
			new_src = obj.attr('src').replace("\/thumbs", "\/small")
			obj.on("mousemove", function(e) {
				var w = $(window).width();
				var top = e.pageY - 100;
				var left = e.pageX + 15;
				if (left+400 > w) {left = left-415;}
				$('#preview_img').attr('src', new_src);
				$('#preview_img').css({'z-index': 100, 'position': 'absolute', 'top': top + 'px', 'left': left + 'px', 'max-width': '395px', 'box-shadow': '0 0 20px 0 rgba(0,0,0,0.5)', 'background-image': 'repeating-linear-gradient(45deg, #EAEAEA, #EAEAEA 10px, #DEDEDE 10px, #DEDEDE 20px'});
				});
			obj.on("mouseout", function() {$('#preview_img').attr('src', 'data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=');});
			});
		}
	})(jQuery);

// toggle aside
(function($) {
	$.fn.toggle_left = function() {
		var obj = $(this);
		obj.on("click", function() {
			var state = $('aside').css('display');
			if (state == 'none') {
				obj.removeClass('fa-chevron-right');
				obj.addClass('fa-chevron-left');
				$('aside').css('display', 'block');
				$('main').removeClass('w12');
				$('main').addClass('w9');
        obj.parent('div').removeClass('tact')
				}
			else {
				obj.removeClass('fa-chevron-left');
				obj.addClass('fa-chevron-right');
				$('aside').css('display', 'none');
				$('main').removeClass('w9');
				$('main').addClass('w12');
				obj.parent('div').addClass('tact')
				}
			});
		}
	})(jQuery);

// replace text with input
(function($) {
	$.fn.smartInput = function(opt) {
	var defaults = {
		sid: false,
		size: 15,
		ok: 'OK',
		img: '/co_icons/checked.png',
		script: false
		}
	opt = $.extend(defaults, opt);
	if (opt.script && opt.sid)
	this.each(function() {
		var obj = $(this);
		var code = obj.attr('data-smart');
		var input = $('<input>').addClass('text').attr({'value': obj.text(), 'size' : opt.size});
		obj.replaceWith(input);
		input.on("change", function(e) {
			e.preventDefault();
			e.stopPropagation();
			$.ajax({
				type: "POST",
				url: opt.script,
				data: "sid="+opt.sid+"&_c="+code+"&v="+input.val()+"&_id=ajax&todo=smart",
				dataType: "html",
				success: function(msg){
					var col = input.css('background');
					if (msg) {
						input.after(msg);
						input.css({'background-color': 'pink'});
						}
					else {
						input.css({'background': 'white 95% no-repeat url('+opt.img+')'});
						window.setTimeout(function(){input.css({'background': col})}, 1000);
						}
					},
				error: function(x, msg, z){
					alert(msg);
					}
				});
			});
		});
	}
})(jQuery);

(function($) {
	$.fn.addToSelect = function(opt) {
	var defaults = {
		alt: 'add',
		img: 'graphics/shift.png'
		}
	opt = $.extend(defaults, opt);
	var Oin = $(this);
	var Oimg = $('<img>').attr({'src': opt.img, 'alt': opt.alt});
	Oimg.on("click",function() {
		var val = $('#human'+opt.field).val();
		if (val) {
			var nval = new Option(val, $('#hidden'+opt.field).val(), false, true);
			$('#i'+opt.field).append(nval);
			$('#hidden'+opt.field).val("");
			$('#human'+opt.field).val("");
			}
		});
	Oin.before("<br />");
	Oin.before(Oimg);
	}
})(jQuery);

// title to short title
(function($) {
	$.fn.title2short = function() {
		var obj = $(this);
		var ref = obj.attr('data-ref');
		obj.focus(function() {
			if (!obj.val()){
				var word = $('#i'+ref).val();
				var max = obj.attr('size');
				if (word.length > max) {
					// AI for the poor: check best word in phrase
					var guess = [];
					var best = [];
					$.each(word.split(' '), function(i, v) {
						if (v.length > 3 && v.length <= max) {
							guess.push(v);
							if (v.charAt(0) == v.charAt(0).toUpperCase()) {best.push(v);}
							}
						});
					if (best[0]) {guess = best;}
					var l = 0;
					$.each(guess, function(i, v){if (v.length > l) {word = v; l = v.length;}});
					}
				obj.val(word);
				}
			});
		};
})(jQuery);
