<?php
# plugin webshop library
# @Author: Rainer Imb <imb>
# @Date:   2018-04-11 11:50:22
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-05-25T11:40:37+02:00
# @License: GPL 2.0


class webshop_lib {
	private $data;
	public $file = "test.pdf";
	public $image = "printlogo.png";
	private $cols = [15, 42, 55, 130, 150, 170, 190];
	private $rows = [10, 50, 85, 100, 260, 263];
	private $ftab = [15, 73, 131];
	private $ln = 5;
	public $total = 0;
	public $notes = '';
	public $plain = '';
	public $html = '';
	private $excl = false;
	private $add_vat = false;

	public function __construct(array$form){
		foreach($form as $k=>$v){$this->{$k}=$v;}
		}

	public function create_invoice_pdf() {
		require_once('other/FPDF/fpdf.php');

		foreach ($this->data['defs'] as $k=>$t) {$this->data['defs'][$k] = html_entity_decode($t);}

		$pdf = new FPDF('P','mm','A4');
		$pdf->AddPage();

		$pdf->SetLineWidth(0.1);
		$pdf->SetDrawColor(180, 180, 180);

		// write invoice address or delivery address
		$pdf->SetXY($this->cols[0], $this->rows[1]);
		$pdf->SetFont('Times','',12);
		$w = $this->cols[3] - $this->cols[0] - 5;
		$pdf->MultiCell($w, $this->ln, utf8_decode($this->data['inv_addr']));

		// logo

		list($x, $y) = getimagesize($this->image);
		if ($x > ($this->cols[3] - $this->cols[6])) {$w = $this->cols[6] - $this->cols[3]; $h = 0;}
		else {$w = 0; $h = $this->rows[1] - $this->rows[0];}

		$pdf->Image($this->image, $this->cols[3], $this->rows[0], $w, $h);

		// write own address
		$pdf->SetXY($this->cols[3], $this->rows[1]);
		$w = $this->cols[6] - $this->cols[3];
		$pdf->MultiCell($w, $this->ln, utf8_decode($this->data['defs']['address']));
		$pdf->SetFont('Arial','B',14);

		// write order number
		$pdf->SetXY($this->cols[0], $this->rows[2]);
		$pdf->Cell(80, 10, $this->data['Subject']);

		// write date
		$pdf->SetFont('Times','',12);
		$pdf->SetXY($this->cols[5], $this->rows[2]);
		$pdf->Cell(40, 10, date('d.m.Y', strtotime($this->data['date'])));

		// write table of articles
		$tx = $this->cols[0];
		$ty = $this->rows[3];
		$pdf->SetFont('Times','B', 10);
		$pdf->SetFillColor(230, 230, 230);

		// table header
		$pdf->SetXY($tx, $ty);
		$w = $this->cols[1] - $tx;
		$pdf->Cell($w, $this->ln, utf8_decode(i18n('product_no')), 1, 0, '', true);

		$pdf->SetXY($this->cols[1], $ty);
		$w = $this->cols[2] - $this->cols[1];
		$pdf->Cell($w, $this->ln, utf8_decode(i18n('pcs')), 1, 0, '', true);

		$pdf->SetXY($this->cols[2], $ty);
		$w = $this->cols[3] - $this->cols[2];
		$pdf->Cell($w, $this->ln, utf8_decode(i18n('name')), 1, 0, '', true);

		$pdf->SetXY($this->cols[3], $ty);
		$w = $this->cols[4] - $this->cols[3];
		$pdf->Cell($w, $this->ln, utf8_decode(i18n('price')), 1, 0, '', true);

		$pdf->SetXY($this->cols[4], $ty);
		$w = $this->cols[5] - $this->cols[4];
		$pdf->Cell($w, $this->ln, utf8_decode(i18n('total')), 1, 0, '', true);

		$pdf->SetXY($this->cols[5], $ty);
		$w = $this->cols[6] - $this->cols[5];
		$pdf->Cell($w, $this->ln, utf8_decode(i18n('tax')), 1, 0, '', true);

		$ty +=  $this->ln;
		$pdf->SetFont('Times','', 10);
		$total = 0;
		$total_vat = 0;

		foreach ($this->data['articles'] as $a) {
			// we have to print this first to achieve height
			$pdf->SetXY($this->cols[2], $ty);
			$w = $this->cols[3] - $this->cols[2];
			$pdf->MultiCell($w, $this->ln, utf8_decode($a['title']), 'LB', 'L');
			$tmp = $pdf->GetY(); // remember y-position on this point
			$heightCells = $tmp - $ty;

			$pdf->SetXY($tx, $ty);
			$w = $this->cols[1] - $tx;
			$pdf->Cell($w, $heightCells, $a['product_no'], 'LB');

			$pdf->SetXY($this->cols[1], $ty);
			$w = $this->cols[2] - $this->cols[1];
			$pdf->Cell($w, $heightCells, $a['amount'], 'LB');

			$pdf->SetXY($this->cols[3], $ty);
			$w = $this->cols[4] - $this->cols[3];
			if ($this->excl) {$p = sprintf('%0.2f', $a['excl']);}
			else {$p = sprintf('%0.2f', $a['incl']);}
			$pdf->Cell($w, $heightCells, $p, 'LB', 0, 'R');

			if ($this->excl) {$p = sprintf('%0.2f', $a['amount']*$a['excl']);}
			else {$p = sprintf('%0.2f', $a['amount']*$a['incl']);}
			$pdf->SetXY($this->cols[4], $ty);
			$w = $this->cols[5] - $this->cols[4];
			$pdf->Cell($w, $heightCells, $p, 'LB', 0, 'R');
			$total += $p;

			if ($this->add_vat) {$tax = sprintf('%0.2f', ($a['amount']*$a['excl'])*($a['vat']/100));}
			elseif ($this->excl) {$tax = "0.00"; $a['vat'] = 0;}
			else {$tax = sprintf('%0.2f', ($a['amount']*$a['excl'])*($a['vat']/100));}
			$pdf->SetXY($this->cols[5], $ty);
			$w = $this->cols[6] - $this->cols[5];
			$pdf->Cell($w, $heightCells, "$tax ({$a['vat']}%)", 'LBR', 0, 'R');
			$total_vat += $tax;

			$ty =  $tmp;
			}

		// freight
		if ($this->data['freight'] > 0) {
			$pdf->SetXY($tx, $ty);
			$w = $this->cols[1] - $tx;
			$pdf->Cell($w, $this->ln, 'P&C', 'LB');

			$pdf->SetXY($this->cols[1], $ty);
			$w = $this->cols[2] - $this->cols[1];
			$pdf->Cell($w, $this->ln, '1',  'LB');

			$pdf->SetXY($this->cols[2], $ty);
			$w = $this->cols[3] - $this->cols[2];
			$pdf->Cell($w, $this->ln, utf8_decode(i18n('delivery_charges')), 'LB');

			$pdf->SetXY($this->cols[3], $ty);
			$w = $this->cols[4] - $this->cols[3];
			if ($this->excl) {$freight = sprintf('%0.2f', $this->data['freight']/(1+($this->data['freight_tax']/100)));}
			else {$freight = $this->data['freight'];}
			$pdf->Cell($w, $this->ln, $freight,  'LB', 0, 'R');

			$pdf->SetXY($this->cols[4], $ty);
			$w = $this->cols[5] - $this->cols[4];
			$pdf->Cell($w, $this->ln, $freight,  'LB', 0, 'R');
			$total += $freight;

			$pdf->SetXY($this->cols[5], $ty);
			$w = $this->cols[6] - $this->cols[5];
			if ($this->excl) {$tax = "0.00"; $this->data['freight_tax'] = 0;}
			else {$tax = sprintf('%0.2f', $this->data['freight']-($this->data['freight']/(1+($this->data['freight_tax']/100))));}
			$total_vat += $tax;
			$pdf->Cell($w, $this->ln, "$tax ({$this->data['freight_tax']}%)",  'LBR', 0, 'R');
			$ty +=  $this->ln;
			}

		if ($this->add_vat) {
			$pdf->SetXY($tx, $ty);
			$w = $this->cols[3] - $tx;
			$pdf->Cell($w, $this->ln, utf8_decode(i18n('invoice_total').' '.i18n('excl_vat')), 'LB', 0, 'R');

			$pdf->SetXY($this->cols[3], $ty);
			$w = $this->cols[4] - $this->cols[3];
			$pdf->Cell($w, $this->ln, utf8_decode($this->data['defs']['currency']), 'LB');

			$pdf->SetXY($this->cols[4], $ty);
			$w = $this->cols[5] - $this->cols[4];
			$pdf->Cell($w, $this->ln, sprintf('%0.2f', $total), 'LRB', 0, 'R');

			$pdf->SetXY($this->cols[5], $ty);
			$w = $this->cols[6] - $this->cols[5];
			$pdf->Cell($w, $this->ln, sprintf('%0.2f', $total_vat),  'RB', 0, 'R');
			$ty +=  $this->ln;

			$pdf->SetXY($tx, $ty);
			$w = $this->cols[3] - $tx;
			$pdf->Cell($w, $this->ln, utf8_decode(i18n('tax')), 'LB', 0, 'R');

			$pdf->SetXY($this->cols[3], $ty);
			$w = $this->cols[4] - $this->cols[3];
			$pdf->Cell($w, $this->ln, utf8_decode($this->data['defs']['currency']), 'LB');

			$pdf->SetXY($this->cols[4], $ty);
			$w = $this->cols[5] - $this->cols[4];
			$pdf->Cell($w, $this->ln, sprintf('%0.2f', $total_vat), 'LRB', 0, 'R');
			$total += $total_vat;
			$ty +=  $this->ln;
			}
		// total
		$vatTxt = i18n('incl')." {$this->data['defs']['tax_name']}";
		if ($total_vat == 0) {$vatTxt = '';}
		$pdf->SetFont('Times','B', 10);
		$pdf->SetXY($tx, $ty);
		$w = $this->cols[3] - $tx;
		$pdf->Cell($w, $this->ln, utf8_decode(i18n('invoice_total').' '.$vatTxt), 'LB', 0, 'R');

		$pdf->SetXY($this->cols[3], $ty);
		$w = $this->cols[4] - $this->cols[3];
		$pdf->Cell($w, $this->ln, utf8_decode($this->data['defs']['currency']), 'LB');

		$pdf->SetXY($this->cols[4], $ty);
		$w = $this->cols[5] - $this->cols[4];
		$pdf->Cell($w, $this->ln, sprintf('%0.2f', $total), 'LRB', 0, 'R');

		if (!$this->add_vat) {
			$pdf->SetFont('Times','', 10);
			$pdf->SetXY($this->cols[5], $ty);
			$w = $this->cols[6] - $this->cols[5];
			$pdf->Cell($w, $this->ln, sprintf('%0.2f', $total_vat),  'RB', 0, 'R');
			}

		$this->total = sprintf('%0.2f', $total);

		// notes

		if ($this->notes) {
			$ty +=  2*($this->ln);
			$pdf->SetFont('Times','',12);
			$pdf->SetXY($this->cols[0], $ty);
			$w = $this->cols[5] - $this->cols[0];
			$pdf->MultiCell($w, $this->ln, utf8_decode($this->notes));
			}

		// footer
		$pdf->SetDrawColor(130, 130, 130);
		$pdf->SetTextColor(130, 130, 130);
		$pdf->SetFont('Arial', '', 8);
		$pdf->Line($this->cols[0], $this->rows[4], $this->cols[6], $this->rows[4]);
		$pdf->SetXY($this->ftab[0], $this->rows[5]);
		$pdf->MultiCell(58, 3, utf8_decode($this->data['defs']['address']));

		if (isset($this->data['defs']['account'])) {
			$pdf->SetXY($this->ftab[1], $this->rows[5]);
			$pdf->MultiCell(58, 3, utf8_decode($this->data['defs']['account']));
			}

		$sec = '';
		if ($this->data['defs']['phone_no']) {$sec .= i18n('phone').": {$this->data['defs']['phone_no']}\n";}
		if ($this->data['defs']['reg_no']) {$sec .= i18n('reg_no').": {$this->data['defs']['reg_no']}\n";}
		if ($this->data['defs']['vat_no']) {$sec .= i18n('vat_no').": {$this->data['defs']['vat_no']}\n";}

		if ($sec) {
			$pdf->SetXY($this->ftab[2], $this->rows[5]);
			$pdf->MultiCell(58, 3, utf8_decode($sec));
			}

		// save
		$pdf->Output('F', $this->data['defs']['pdf_dir'].$this->file, true);
		}

	public function create_mail() {
		$this->html = htmltag('h1', '', i18n('thank_you'));
		$this->html .= $this->data['message'];
		$this->html .= htmltag('h2', '', i18n('invoice_address'));
		$this->html .= htmltag('p', '', nl2br($this->data['inv_addr']));
		if ($this->data['del_addr']) {
			$this->html .= htmltag('h2', '', i18n('delivery_address'));
			$this->html .=  htmltag('p', '',nl2br($this->data['del_addr']));
			}
		$this->build_list();
		$this->build_footer();
		}

	public function build_footer() {
		$this->html .=  htmltag('h4', '', $this->data['defs']['company']);
		$this->html .=  htmltag('p', '', nl2br($this->data['defs']['address']));
		$this->plain .= $this->data['defs']['address']."\n\n";
		$ht = '';
		if ($this->data['defs']['phone_no']) {
			$tmp = i18n('phone').": {$this->data['defs']['phone_no']}\n";
			$ht .= $tmp;
			$this->plain .= $tmp;
			}
		if ($this->data['defs']['reg_no']) {
			$tmp = i18n('reg_no').": {$this->data['defs']['reg_no']}\n";
			$ht .= $tmp;
			$this->plain .= $tmp;
			}
		if ($this->data['defs']['vat_no']) {
			$tmp = i18n('vat_no').": {$this->data['defs']['vat_no']}\n";
			$ht .= $tmp;
			$this->plain .= $tmp;
			}
		if ($ht) {$this->html .=  htmltag('p', '', nl2br($ht));}
		}

	public function build_list() {
		$this->html .=  htmltag('h2', '',$this->data['Subject']);
		$this->plain = html2plain($this->html);
		$this->plain .= "\n===================================================\n";
		$li = '';
		$total = 0;
		foreach ($this->data['articles'] as $a) {
			$p = sprintf('%0.2f', $a['amount']*$a['incl']);
			$ht = "{$a['product_no']} {$a['amount']} ".i18n('pcs')." {$a['title']}<br />";
			$ht .= "{$a['incl']} {$this->data['defs']['currency']}<br />";
			$ht .= i18n('total').": $p {$this->data['defs']['currency']}";
			$li .=  htmltag('li', '', $ht);
			$this->plain .= "{$a['product_no']} {$a['amount']} ".i18n('pcs')." {$a['title']}\n";
			$this->plain .= "{$a['incl']} {$this->data['defs']['currency']}\n";
			$this->plain .= i18n('total').": $p {$this->data['defs']['currency']}\n";
			$this->plain .= "---------------------------------------------------\n";
			$total += $p;
			}
		$ht = "P&C 1 ".i18n('pcs')." ".i18n('delivery_charges')."<br />";
		$ht .= "{$this->data['freight']} {$this->data['defs']['currency']}<br />";
		$li .=  htmltag('li', '', $ht);
		$this->plain .= "P&C 1 ".i18n('pcs')." ".i18n('delivery_charges')."\n";
		$this->plain .= "{$this->data['freight']} {$this->data['defs']['currency']}\n";
		$this->plain .= "===================================================\n";
		$this->html .=  htmltag('ul', '', $li);
		$total += $this->data['freight'];
		$total = sprintf('%0.2f', $total);
		$this->html .=  htmltag('p', '', i18n('invoice_total').": $total {$this->data['defs']['currency']}");
		$this->plain .= i18n('invoice_total').": $total {$this->data['defs']['currency']}\n";
		$this->html .=  "<hr />";
		$this->plain .= "___________________________________________________\n\n";
		$this->total = sprintf('%0.2f', $total);
		}

	public function send($me) {
		require("other/PHPMailer/PHPMailerAutoload.php");
		$mcnf = read_settings(['group' => 'crm']);
		$m = ['html' => $this->html, 'Subject' => $this->data['Subject']];
		$html = parse_in('cms_newsletter', $m);
		$mail = new PHPMailer;
		$mail->SMTPOptions = array(
		'ssl' => array(
			'verify_peer' => false,
			'verify_peer_name' => false,
			'allow_self_signed' => true
			)
		);
		$mail->CharSet = "utf-8";
		//$mail->SMTPDebug = 4;
		$mail->isSMTP();
		//$mail->SMTPKeepAlive = true;
		$mail->Host = $mcnf['smtp_host'];
		$mail->Port = $mcnf['smtp_port'];
		$mail->SMTPAuth = true;
		if ($mcnf['smtp_sec']) {$mail->SMTPSecure = strtolower($mcnf['smtp_sec']);} // tls, ssl
		else {$mail->SMTPAutoTLS = false;}
		$mail->Username = $mcnf['smtp_user'];
		$mail->Password = $mcnf['smtp_pwd'];
		$mail->setFrom($mcnf['reply']);
		$mail->addAddress($me['email']);
		$mail->AddBCC($mcnf['reply']);
		//$mail->addReplyTo('', '');
		$mail->Subject = $m['Subject'];
		$mail->msgHTML($html);
		$mail->AltBody = $this->plain;
		if ($this->file) {$mail->addAttachment($this->data['defs']['pdf_dir'].$this->file);}
		$stat = 0;
		if (!$mail->send()) {$stat = $mail->ErrorInfo;}
		return $stat;
		}
	}

?>
