<?php

class vCard {
	private $file;
	private $vCard;
	private $lang = 'EN';
	private $data;
	private $prop = ["fullname", "first_name", "last_name", "additional_name",
	"name_prefix", "name_suffix", "nickname", "title", "role", "department", "company",
	"work_po_box", "work_extended_address", "work_address", "work_city", "work_state",
	"work_postal_code", "work_country", "home_po_box", "home_extended_address", "home_address",
	"home_city", "home_state", "home_postal_code", "home_country", "office_tel", "home_tel",
	"cell_tel", "fax_tel", "pager_tel", "email1", "email2", "url", "photo", "birthday",
	"timezone",	"sort_string","note"];
	
	public function __construct(array$form){
		foreach($form as $k=>$v){$this->{$k}=$v;}
		foreach ($this->prop as $p) {
			if (!isset($this->data[$p])) {$this->data[$p] = NULL;}
			else {$this->data[$p] = trim(strip_tags($this->data[$p]));}
			}
		$this->lang = strtoupper($this->lang);
		}
	
	private function make() {
		if (!$this->data['fullname']) {$this->data['fullname'] = trim($this->data['first_name']." ".$this->data['last_name']);}
		if (!$this->data['sort_string']) {$this->data['sort_string'] = $this->data['last_name'];}
		if (!$this->data['sort_string']) {$this->data['sort_string'] = $this->data['company'];}
		
		$this->vCard = "BEGIN:VCARD\r\n";
		$this->vCard .= "VERSION:3.0\r\n";
		$this->vCard .= "PROFILE:VCARD\r\n";
		$this->vCard .= "PRODID:-//Consentio WebCMS//NONSGML Version 1//$this->lang\r\n";
		$this->vCard .= "FN:".$this->data['fullname']."\r\n";
		$this->vCard .= "N:"
		  .$this->data['last_name'].";"
		  .$this->data['first_name'].";"
		  .$this->data['additional_name'].";"
		  .$this->data['name_prefix'].";"
		  .$this->data['name_suffix']."\r\n";
		if ($this->data['nickname']) {$this->vCard .= "NICKNAME:".$this->data['nickname']."\r\n";}
		if ($this->data['title']) {$this->vCard .= "TITLE:".$this->data['title']."\r\n";}
		if ($this->data['company']) {$this->vCard .= "ORG:".$this->data['company'];}
		if ($this->data['department']) {$this->vCard .= ";".$this->data['department'];}
		$this->vCard .= "\r\n";
		
		if ($this->data['work_po_box']
			|| $this->data['work_extended_address']
			|| $this->data['work_address']
			|| $this->data['work_city']
			|| $this->data['work_state']
			|| $this->data['work_postal_code']
			|| $this->data['work_country']) {
			  $this->vCard .= "ADR;TYPE=work:"
				.$this->data['work_po_box'].";"
				.$this->data['work_extended_address'].";"
				.$this->data['work_address'].";"
				.$this->data['work_city'].";"
				.$this->data['work_state'].";"
				.$this->data['work_postal_code'].";"
				.$this->data['work_country']."\r\n";
				}
		if ($this->data['home_po_box']
			|| $this->data['home_extended_address']
			|| $this->data['home_address']
			|| $this->data['home_city']
			|| $this->data['home_state']
			|| $this->data['home_postal_code']
			|| $this->data['home_country']) {
			  $this->vCard .= "ADR;TYPE=home:"
				.$this->data['home_po_box'].";"
				.$this->data['home_extended_address'].";"
				.$this->data['home_address'].";"
				.$this->data['home_city'].";"
				.$this->data['home_state'].";"
				.$this->data['home_postal_code'].";"
				.$this->data['home_country']."\r\n";
				}
		if ($this->data['email1']) {$this->vCard .= "EMAIL;TYPE=INTERNET,PREF:".$this->data['email1']."\r\n";}
		if ($this->data['email2']) {$this->vCard .= "EMAIL;TYPE=INTERNET:".$this->data['email2']."\r\n";}
		if ($this->data['office_tel']) {$this->vCard .= "TEL;TYPE=WORK,VOICE:".$this->data['office_tel']."\r\n";}
		if ($this->data['home_tel']) {$this->vCard .= "TEL;TYPE=HOME,VOICE:".$this->data['home_tel']."\r\n";}
		if ($this->data['cell_tel']) {$this->vCard .= "TEL;TYPE=CELL,VOICE:".$this->data['cell_tel']."\r\n";}
		if ($this->data['fax_tel']) {$this->vCard .= "TEL;TYPE=WORK,FAX:".$this->data['fax_tel']."\r\n";}
		if ($this->data['pager_tel']) {$this->vCard .= "TEL;TYPE=WORK,PAGER:".$this->data['pager_tel']."\r\n";}
		if ($this->data['url']) {$this->vCard .= "URL;TYPE=WORK:".$this->data['url']."\r\n";}
		if ($this->data['birthday']) {$this->vCard .= "BDAY:".$this->data['birthday']."\r\n";}
		if ($this->data['role']) {$this->vCard .= "ROLE:".$this->data['role']."\r\n";}
		if ($this->data['note']) {$this->vCard .= "NOTE:".$this->data['note']."\r\n";}
		$this->vCard .= "END:VCARD\r\n";
		}

	public function export() {
		$this->make();
		if (!$this->file) {$this->file = trim($this->data['fullname']);}
		$this->file = as_filename($this->file);
		header("Content-type: text/vcard");
		header("Content-Disposition: attachment; filename=".$this->file.".vcf");
		return $this->vCard;
		}  
  }

?>