<?php

/**
 * plugin vat
 * @package consentio
 */

class vat {

	public function plugin($html) {
		switch ($html['action']) {
			case ("SOMETHINGELSE"): $html = $this->SOMETHINGELSE_admin($html); break;
			default: $html = $this->vat_admin($html);
			}
		return $html;
		}

	private function vat_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('vat'),
			"table"			=> "eu_vat",
			"myconf"		=> "vat",
			"orderby"		=> "﻿iso",
			"defsort"		=> "ASC",
			"human"			=> "﻿iso",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['﻿iso', 'tax_name'],
			"table_fields"	=> ['﻿iso', 'tax1', 'tax2', 'tax3', 'tax_name']
			];

		$inputs = [
		'﻿iso'	=> [
			'type'	=> 'text',
			],
		'tax1'	=> [
			'type'	=> 'number',
			'smart'	=> 1
			],
		'tax2'	=> [
			'type'	=> 'number',
			'smart'	=> 1
			],
		'tax3'	=> [
			'type'	=> 'number',
			'smart'	=> 1
			],
		'tax_name'	=> [
			'type'	=> 'text',
			]
		];


		$obj = new access($form);
		// $obj->set_attribute($inputs);
		

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		// default tree shows plugins of group "plugins"
		$html['left'] = get_tab_tree($html, "plugins", $form['myconf'], "");;
		return $html;
		}
	}
?>