<?php
#update.php
# update consentio files, sql and css *
#
# @Author: Rainer Imb <consentio>
# @Date:   2018-08-29 02:45:31
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: update.php
# @Last modified by:   consentio
# @Last modified time: 2021-03-15 11:34:42
# @License: GPL 2.0

$durl = "https://www.consentio.at/central";

function plugin($html) {
	switch ($html['action']) {
		case ("xx"): $html = xx_admin($html); break;
		default: $html = update_center($html);
		}
	return $html;
	}

function update_center($html) {
	global $durl;
	$update_file = "update{$html['con']['version']}.json";
	$sub = tabs();
	if (!ini_get('allow_url_fopen')) {$html['content'] = say_mess(i18n('no_remote_allowed'), i18n('error'), 'warning');}
	elseif (param('todo') == 'p') {
		$txt = @fopen("$durl/{$html['con']['version']}_plugins.json", "r");
		if ($txt === false) {
			$html['content'] = say_mess(i18n('not_connected'), i18n('error'), 'warning');
			}
		else {
			$json = stream_get_contents($txt);
			fclose($txt);
			$data = json_decode($json, true);
			if (param('_i')) {
				$html['content'] = install_plugin($html, $data);
				}
			else {$html = list_plugins($html, $data);}
			}
		$html['formtitle'] = i18n('plugins');
		$sub = make_submenu(toggle_submen($sub, 1));
		}
	else {
		$txt = fopen("$durl/$update_file", "r");
		if ($txt === false) {
			$html['content'] = say_mess(i18n('not_connected')." $durl/$update_file", i18n('error'), 'warning');
			}
		else {
			$json = stream_get_contents($txt);
			fclose($txt);
			$data = json_decode($json, true);
			$html['content'] = check_update($html, $data);
			}
		$html['formtitle'] = i18n('update');
		$sub = make_submenu(toggle_submen($sub, 0));
		}
	$html['content'] = $sub.$html['content'];
	$html['title'] .= " &ndash; ".$html['formtitle'];
	$html['left'] = get_tab_tree($html, "settings", 'update', '');
	return $html;
	}

function list_plugins($html, $data) {
	global $db, $con;
	$plugins = get_plugins();
	$c = "<h2>".i18n('available_plugins')."</h2>";
	foreach ($data['plugins'] as $plugin) {
		$err = 0;
		$c .= "<div class='row block_item clrfx'><div class='col w66p first'>";
		$c .= "<h3>{$plugin['name'][$html['user']['language']]} ({$plugin['plugin']})</h3>";
		$c .= "<p>{$plugin['desc'][$html['user']['language']]}</p>";

		foreach ($plugin['requires'] as $k => $v) {
			if ($k == 0) {
				$fb = get_icon('check-green', i18n('ok'));
				if ($v > $con['version']) {$fb = get_icon('exclamation-triangle-red', i18n('error')); $err = 1;}
				$c .= "<p>Version $v $fb</p>";
				}
			else {
				$fb = get_icon('check-green', i18n('ok'));
				if (!in_array($v, $plugins)){$fb = get_icon('exclamation-triangle-red', i18n('error')); $err = 1;}
				$c .= "<p>Plugin $v $fb</p>";
				}
			}
		if (array_key_exists('link', $plugin)) {
			$c .= "<p><a class='as_button' href='{$plugin['link'][$html['user']['language']]}' target='_blank'>".i18n('more')."</a></p>";
			}
		$c .= "</div><div class='col w33p last'>";
		if (in_array($plugin['plugin'], $plugins)) {$c .= "<p class='green center'>".get_big_icon('check', '')."<br />".i18n('is_installed')."</p>";}
		elseif ($err) {$c .= "<p class='red center'>".get_big_icon('exclamation-triangle', '')."<br />".i18n('error')."</p>";}
		else {$c .= "<p><a class='as_button' href='{$html['myurl']}?_id=update&amp;_i={$plugin['plugin']}&amp;todo=p&amp;sid={$html['sid']}'>".i18n('install')."</a></p>";}
		$c .= "</div></div>";
		}
	$html['content'] = $c;
	return $html;
	}

function check_update($html, $data) {
	global $con, $durl;
	$mydir = $con['coco'];
	$plugins = get_plugins();
	$out = "";
	$wrong = 0;
	if ($data['ver'] == $con['version']) {
		$out = say_mess(i18n('no_updates'), i18n('info'), 'info');
		}
	else {
		// always update update file (this file)
		$out .= update_update();
		// new directories
		if (param('_u')) {
			if (array_key_exists('ndirs', $data)) {
				foreach($data['ndirs'] as $file) {
					$file['d'] = preg_replace('/\/BASE\//', "/$mydir/", $file['d']);
					if (mkdir("{$html['dir']}{$file['d']}{$file['f']}", 0774)) {$out .= "<p>".i18n('new_folder')."{$file['d']}{$file['f']}: <span class='green'>OK</span></p>";}
					else {$out .=  "<p>".i18n('new_folder')."{$html['dir']}{$file['d']}{$file['f']}: <span class='red'>FAILED</span></p>"; $wrong =1;}
					}
				}
			}
		// files
		$count = 0;
		foreach($data['files'] as $file) {
			if (in_array($file['p'], $plugins)) {
				$count++;
				if (param('_u')) {
					$remote = "{$file['d']}{$file['f']}";
					// download-files are txt not php
					$remote = preg_replace('/\.php$/', '.txt', $remote);
					$local = $html['dir'].preg_replace('/\/BASE\//', "$mydir/", $file['d'])."/{$file['f']}";
					$f = @fopen("$durl/$remote", "rb");
					if ($f === false) {$out .= "<p class='red'>{$file['f']}: ERROR</p>"; $wrong =1;}
					else {
						$code = stream_get_contents($f);
						fclose($f);
						$lf = @fopen($local, 'wb');
						if ($lf === false) {$out .= "<p class='red'>$local: ERROR</p>"; $wrong =1;}
						else {
							fwrite($lf, $code);
							$out .= "<p>{$file['f']}: OK</p>";
							}
						}
					}
				else {$out = "<p>".i18n('update')." {$data['ver']} ({$data['release']}): $count ".i18n('files')." <a class='as_button' href='{$html['myurl']}?_id=update&amp;_u=1&amp;sid={$html['sid']}'>".i18n('update_now')."</a></p>";}
				}
			}
		// update database
		if (param('_u')) {
			foreach($data['sql'] as $file) {
				if (in_array($file['p'], $plugins)) {
					$file_full = $html['dir']."/$mydir/lib/sql/{$file['f']}";
					$sqlfile = file_get_contents($file_full);
					$out .= update_db($sqlfile);
					}
				}

			}
		// update css
		if (param('_u')) {
			foreach($data['css'] as $ins) {
				if (in_array($ins['p'], $plugins)) {
					$c .= update_css($ins, $ins['p']);
					}
				}
			}
		}
	if (param('_u')) {
		if ($wrong) {$out .= "<p class='red'>Update FAILED.</p>";}
		else {
			$out .= "<p class='green'>Update SUCCEED.</p>";
			$local = $html['dir'].preg_replace('/\/BASE\//', "$mydir/", $file['d'])."/{$file['f']}";
			$lf = @fopen("{$html['dir']}$mydir/lib/version.txt", 'wb');
			fwrite($lf, $data['ver']);
			}
		}
	return $out;
	}

function install_plugin($html, $data) {
	global $con, $durl;
	$c = "";
	$mydir = $con['coco'];
	foreach($data['plugins'] as $plugin) {
		if ($plugin['plugin'] == param('_i')) {
			$c = "<h2>{$plugin['name'][$html['user']['language']]}</h2>";
			// new directories
			if (array_key_exists('ndirs', $plugin)) {
				foreach($plugin['ndirs'] as $file) {
					$file['d'] = preg_replace('/\/BASE\//', "/$mydir/", $file['d']);
					if (file_exists("{$html['dir']}{$file['d']}{$file['f']}")) {$c .= "<p>{$file['d']}{$file['f']}: <span class='green'>".i18n('is_installed')."</span></p>";}
					else {
						if (mkdir("{$html['dir']}{$file['d']}{$file['f']}", 0774)) {$c .= "<p>".i18n('new_folder')."{$file['d']}{$file['f']}: <span class='green'>OK</span></p>";}
						else {$c .=  "<p>".i18n('new_folder')."{$html['dir']}{$file['d']}{$file['f']}: <span class='red'>FAILED</span></p>";}
						}
					}
				}
			foreach($plugin['files'] as $file) {
				$remote = "{$file['d']}{$file['f']}";
				$remote = preg_replace('/\.php$/', '.txt', $remote);
				$local = $html['dir'].preg_replace('/\/BASE\//', "$mydir/", $file['d'])."/{$file['f']}";
				$f = @fopen("$durl/$remote", "rb");
				if ($f === false) {$c .= "<p class='red'>{$file['f']}: ERROR $durl/$remote</p>";}
				else {
					$code = stream_get_contents($f);
					fclose($f);
					$lf = fopen($local, 'wb');
					fwrite($lf, $code);
					$c .= "<p>{$file['f']}: OK</p>";
					}
				}
			foreach($plugin['sql'] as $file) {
				$file_full = $html['dir']."$mydir/lib/sql/{$file['f']}";
				$sqlfile = file_get_contents($file_full);
				$c .= update_db($sqlfile);
				}
			foreach($plugin['css'] as $ins) {
				$c .= update_css($ins, $plugin['name']['en']);
				}
			}
		}
	return $c;
	}

function get_plugins() {
	global $db, $con;
	$arg = $db->prepare("SELECT DISTINCT `plugin` FROM `register` WHERE `plugin` <> '';");
	$arg->execute();
	$plugins = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
	array_unshift($plugins, $con['profile']);
	if ($con['profile'] == 'cms') {array_unshift($plugins, 'mvc');}
	return $plugins;
	}

function update_db($sql) {
	global $db;
	$allow = ['INSERT', 'UPDATE', 'DELETE', 'CREATE', 'ALTER', 'TRUNCATE', 'DROP'];
	$lines = explode("\n", $sql);
    $query = "";
    $content = "";
    foreach($lines as $line){
		$line = trim($line);
		if($line == "" OR preg_match('/^\s*(#|--\s)/sU', $line)){}
		else {
            $query .= $line;
            if (substr(rtrim($query), -1) == ';'){
				preg_match('/^\s*(\w*)\s.*/', $query, $m);
				if (in_array(strtoupper($m[1]), $allow)) {
					$arg = $db->prepare($query);
					$check = $arg->execute();
					if ($check === false) {
						$err = $arg->errorInfo();
						$error = array_key_exists(2, $err) ? $err[2] : "";
						$content .= "<p class='red'>".i18n('error').": $error<br/>$query</p>";
						}
					else {
						$rows = $arg->rowCount();
						$content .= "<p>$m[1]: $rows ".i18n('entries')."</p>";
						}
					}
				else {$content .= "<p class='red'>".i18n('error').": $query</p>";}
				$query = "";
				}
			}
		}
	return $content;
	}

// deprecated
function update_css($ins, $p) {
	global $html, $website;
	$file = $html['dir']."/css/themes/".$website['def_css'];
	// old place of css
	if (!file_exists($file)) {$file = $html['dir']."/css/".$website['def_css'];}
	$css = file_get_contents($file);
	$bkp = preg_replace('/css$/', 'bkp', $file);
	// backup
	copy($file, $bkp);
	$info = ucfirst($p)." ".date('Y/m/d H:i.s');
	if (array_key_exists('common', $ins)) {
		$insert = "\n/* $info */\n{$ins['common']}";
		$plchldr = "/* Insert your styles here */";
		$css = str_replace($plchldr, "$plchldr\n$insert", $css);
		}
	if (array_key_exists('mq959', $ins)) {
		$insert = "\n/* $info */\n{$ins['mq959']}";
		$plchldr = "/* Insert 959 */";
		$css = str_replace($plchldr, "$plchldr\n$insert", $css);
		}
	if (array_key_exists('mq768', $ins)) {
		$insert = "\n/* $info */\n{$ins['mq768']}";
		$plchldr = "/* Insert 768 */";
		$css = str_replace($plchldr, "$plchldr\n$insert", $css);
		}
	if (array_key_exists('mq480', $ins)) {
		$insert = "\n/* $info */\n{$ins['mq480']}";
		$plchldr = "/* Insert 480 */";
		$css = str_replace($plchldr, "$plchldr\n$insert", $css);
		}
	if (array_key_exists('mq320', $ins)) {
		$insert = "\n/* $info */\n{$ins['mq320']}";
		$plchldr = "/* Insert 320 */";
		$css = str_replace($plchldr, "$plchldr\n$insert", $css);
		}
	$lf = fopen($file, 'wb');
	$check = fwrite($lf, $css);
	$feedback = i18n('update_css').": ";
	if ($check === false) {$feedback .= i18n('error');}
	else {$feedback .= i18n('ok');}
	return $feedback;
	}

function update_update() {
	global $html, $con, $durl;
	$mydir = $con['coco'];
	$fail = false;
	$f = @fopen("$durl/BASE/plugins/update.txt", "rb");
	if ($f === false) {$fail = true;}
	$code = stream_get_contents($f);
	fclose($f);
	$lf = @fopen("{$html['dir']}/{$con['coco']}/plugins/update.php", 'wb');
	fwrite($lf, $code);
	return $fail;
	}

function tabs() {
	global $html;
	$subs = [
		[i18n('update'), $html['myurl']."?sid={$html['sid']}&amp;_id=update", "inactive", "package-refresh"],
		[i18n('plugins'), $html['myurl']."?sid={$html['sid']}&amp;_id=update&amp;todo=p", "inactive", "plugin"]
		];
	return $subs;
	}
?>
