<?php
# @Author: consentio
# @Date:   2018-08-18T16:58:32+02:00
# @Project: Consentio CMS
# @Filename: tables.php
# @Last modified by:   consentio
# @Last modified time: 2023-09-23T14:41:34+02:00
# @License: GPL 2.0
# @Copyright: IMB Webdevelopment




function plugin($html) {
	if (param('todo') == "SQL") {$html = query_window($html);}
	elseif (param('todo') == "new_table") {$html = new_table($html);}
	elseif (param('todo') == "ops") {$html = operations($html);}
	elseif (!param('_table')) {$html = tables_ov($html);}
	else {$html = tables_admin($html);}
	return $html;
	}

function tables_ov($html) {
	global $db, $dba;
	$url = "{$html['myurl']}?sid={$html['sid']}&amp;_id=tables";
	$html['content'] = htmltag('h2', '', i18n('database')." \"".$dba['database']."\"");
	$q ="SELECT `TABLE_NAME` AS `".i18n('table')."`, `TABLE_TYPE` AS `".i18n('type')."`, `ENGINE` AS `Engine`, `TABLE_ROWS` AS `Rows`, (`DATA_LENGTH` + `INDEX_LENGTH`) AS `Size`, `AUTO_INCREMENT` AS `AI`, `CREATE_TIME` AS `Created`, `UPDATE_TIME` AS `Update`, `TABLE_COLLATION` AS `Collation` FROM information_schema.TABLES WHERE table_schema = '{$dba['database']}';";
	$arg = $db->prepare($q);
	$arg->execute();
	$t = ''; $row = 0;
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		$tr = ''; $th = '';
		if ($data['Size']) {$data['Rows'] .= " (".sizeme($data['Size']).")";}
		unset($data['Size']);
		foreach (array_keys($data) as $k) {
			if (!$row) {
				$th .= htmltag('th', '', $k);
				}
			$v = $data[$k];
			$icons = '';
			if ($k == i18n('table')) {
				if ($data[i18n('type')] != "VIEW") {
					$icons = htmltag('a', 'href="'.$url.'&amp;_table='.$v.'"', get_icon('edit', i18n('edit'))."&nbsp;");
					$icons .= htmltag('a', 'href="'.$url.'&amp;_table='.$v.'&amp;todo=props"', get_icon('properties', i18n('properties'))."&nbsp;");
					$icons .= htmltag('a', 'href="'.$url.'&amp;_table='.$v.'&amp;todo=SQL&amp;com=tru"', get_icon('cut', "TRUNCATE"))."&nbsp;";
					$icons .= htmltag('a', 'href="'.$url.'&amp;_table='.$v.'&amp;todo=SQL&amp;com=dro"', get_icon('delete', "DROP"));
					}
				else {
					$icons = htmltag('a', 'href="'.$url.'&amp;_table='.$v.'&amp;todo=SQL&amp;com=drov"', get_icon('delete', "DROP"));
					}
				$v = htmltag('strong', '', $v);
				}
			if ($icons) {$tr .= htmltag('td', '', $icons);}
			$tr .= htmltag('td', '', $v);
			}
		if ($th) {
			$th = htmltag('th', '', i18n('action')).$th;
			$t .= htmltag('tr', '', $th);
			}
		$t .= htmltag('tr', '', $tr);
		$row++;
		}
	$html['content'] .= htmltag('table', 'class="table"', $t);
	$queries =
	"SHOW VARIABLES LIKE 'ver%';
	SHOW TRIGGERS;
	SHOW VARIABLES LIKE 'character_set%';";
	$html['formtitle'] = i18n('database').bubble('tables');
	$html['content'] .= execute_query($queries, true);
	$sub = tabs(0);
	$sub = make_submenu(toggle_submen($sub, 1));
	$html['content'] = $sub.$html['content'];
	$html['left'] = tables_tree('');
	return $html;
	}

function tables_admin($html) {
	$table = clean_var(param('_table'), "w");
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$returned_query = false;
	$form = [
		"title"			=> i18n('database'),
		"table"			=> $table,
		"myconf"		=> "tables",
		"orderby"		=> "id",
		"human"			=> "id",
		"wrap_class"	=> "list",
		"before_form"	=> htmltag('h2', '', i18n('table')." $table"),
		"before_table"	=> htmltag('h2', '', i18n('table')." $table"),
		"html"			=> $html,
		"rid"			=> $rid
		];

	$obj = new access($form);
	$inputs = $obj->inputs_from_table();
	foreach ($inputs as $k=>$v) {$inputs[$k]['caption'] = $k;}
	$inputs['_table'] = ['type' => "free", 'default' => $table];

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		// force storage
		$id = $obj->store($inputs);
		$html['popup'] = $obj->feedback;
		$returned_query = $obj->query;
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	elseif ($todo == "alter") {
		$html = get_my_definitions($html);
		}
	elseif ($todo == "add") {
		$html = add_field($html);
		}
	elseif ($todo == "dumpdata") {
		$sub = tabs($table);
		$html['content'] = make_submenu(toggle_submen($sub, 5));
		$html['content'] .= dumpdata($table);
		$html['formtitle'] = i18n('database')." ".bubble('tables.dump');
		}
	elseif ($todo == 'props') {
		$sub = tabs($table);
		$html['content'] = make_submenu(toggle_submen($sub, 4));
		$html['content'] .= table_props($table);
		$html['formtitle'] = i18n('database');
		}
	else {
		if (param('_del')) {$obj->delete();}
		$sub = tabs($table);
		$obj->before_table = make_submenu(toggle_submen($sub, 3)).htmltag('h2', '', i18n('table')." $table")."&&&QUERY&&&";
		$obj->in_searchform = '<input id="iexportc" name="export" type="radio" value="csv" />&nbsp;<label for="iexportc">'.i18n('export_csv').'</label>';
		if (@include_once("other/SimpleExcel/xlsxWriter.php")) {
			$obj->in_searchform .= ' <input id="iexportx" name="export" type="radio" value="xls" />&nbsp;<label for="iexportx">'.i18n('export_xls').'</label>';
			}

		$html = $obj->table($inputs);
		if (!$returned_query) {$returned_query = $obj->query;}
		$html['content'] = str_replace('&&&QUERY&&&', htmltag('textarea', 'cols="80" rows="5"', $returned_query), $html['content']);
		if (param('export')) {
			if (param('export') == 'csv') {$html['content'] = export_csv($obj->export_q, $obj->taint, $table);}
			else {$html['content'] = export_xlsx($obj->export_q, $obj->taint, $table);}
			$html['gui'] = 6;
			}
		}
	$html['left'] = tables_tree($table);
	return $html;
	}

function new_table($html) {
	$success = false;
	$tab = 0; $table = '';
	$form = [
		"title"			=> "new_table",
		"myconf"		=> "tables",
		"no_cancel"		=> 1,
		"html"			=> $html,
		'button_text' => i18n('create_table'),
		'button_before' => htmltag('button', 'type="submit" name="_add_field" value="1"', get_icon('plus-circle', '+').i18n('add_field'))
		];

	$inputs = [
		'name' =>	[
			'type'	=> 'text',
			'duty'	=> 1
			],
		'char_set' =>	[
			'type'	=> 'array',
			'extra'	=> get_char_set(),
			'default'	=> 'utf8mb3_general_ci',
			'raw'	=> 1,
			'duty'	=> 1
			],
		'todo' =>	[
			'type'	=> 'hidden',
			'value'	=> 'new_table'
			],
		];

	if (!param('_store') && !param('_add_field')) {
		$more_inputs = get_one_field([
			'pre' => 'field1',
			'name' => 'id',
			'ftype' => 'BIGINT',
			'index' => 'PRIMARY',
			'flength' => '20',
			'null' => 0,
			'ai' => 'on',
			'default' => '',
			'attribute' => 'UNSIGNED',
			'collation' => ''
			]);
		$inputs = array_merge($inputs, $more_inputs);
		$more_inputs = get_one_field([
			'pre' => 'field2',
			'name' => '',
			'ftype' => 'VARCHAR',
			'index' => '',
			'flength' => '64',
			'null' => 'on',
			'ai' => 0,
			'default' => '',
			'attribute' => '',
			'collation' => 'utf8mb3__general_ci'
			]);
		$inputs = array_merge($inputs, $more_inputs);
		}

	$obj = new access($form);

	if (param('_store')) {
		$more_inputs = get_my_fields();
		$inputs = array_merge($inputs, $more_inputs);
		$inputs = $obj->get_params($inputs);
		if (!$obj->error) {
			$data = $obj->parsable_data($inputs);
			list($sql, $feedback) = create_new_table($data);
			if ($feedback) {$obj->before_form = "<p class='red'>$feedback</p><pre>$sql</pre>";}
			else {
				$table = $data['name'];
				$html['content'] .= table_props($data['name']);
				$success = true;
				$tab = 4; $bar = 1;
				}
			}
		}
	elseif (param('_add_field')) {
		$more_inputs = get_my_fields();
		$count = (count($more_inputs)/10)+1;
		$inputs = array_merge($inputs, $more_inputs);
		$inputs = $obj->get_params($inputs);
		$more_inputs = get_one_field([
			'pre' => "field$count",
			'name' => '',
			'ftype' => 'VARCHAR',
			'index' => '',
			'flength' => '',
			'null' => 'on',
			'ai' => 0,
			'default' => '',
			'attribute' => '',
			'collation' => 'utf8mb3__general_ci'
			]);
		$inputs = array_merge($inputs, $more_inputs);
		}
	if (!$success) {
		$obj->add_input($inputs);
		$html = $obj->form();
		$html['content'] .= parse_in('gui_sync_new_table_inputs', []);
		$html['left'] = tables_tree('');
		}
	$sub = tabs($table);
	$sub = make_submenu(toggle_submen($sub, $tab));
	$html['content'] = $sub.$html['content'];
	$html['formtitle'] = i18n('database')." &ndash; ".i18n('new_table').bubble('tables.new_table');
	$html['left'] = tables_tree($table);
	return $html;
	}

function get_my_definitions($html) {
	global $db;
	$table = clean_var(param('_table'), "w");
	$field = clean_var(param('fid'), "w");
	$indeces = ['PRI' => 'PRIMARY','UNI' => 'UNIQUE','MUL' => 'INDEX'];

	$form = [
		"title"			=> "alter_table",
		"myconf"		=> "tables",
		"no_cancel"		=> 1,
		"html"			=> $html,
		"submit"		=> "_alter",
		'button_text' => i18n('ok')
		];

	$inputs = [
		'name' =>	[
			'caption'	=> i18n('table'),
			'type'	=> 'readonly',
			'value'	=> $table
			],
		'fid' =>	[
			'type'	=> 'hidden',
			'value'	=> $field
			],
		'todo' =>	[
			'type'	=> 'hidden',
			'value'	=> 'alter'
			]
		];

	$q = "SHOW FULL COLUMNS FROM `$table` WHERE `Field` = '$field';";
	$arg = $db->prepare($q);
	$arg->execute();
	$info = $arg->fetch(PDO::FETCH_ASSOC);
	preg_match('/^(\w+)\((.+)\)\s?(\w*)/', $info['Type'], $m);
	$info['type'] = isset($m[1]) ? strtoupper($m[1]) : strtoupper($info['Type']);
	$info['length'] = isset($m[2]) ? $m[2] : '';
	$info['attr'] = isset($m[3]) ? strtoupper($m[3]) : '';
	$info['Null'] = $info['Null'] == 'YES' ? 'on' : '';
	$info['ai'] = $info['Extra'] == 'auto_increment' ? 'on' : '';
	$info['index'] = $info['Key'] ? $indeces[$info['Key']] : '';
	$q = "SHOW KEYS FROM `$table` WHERE `Column_name` = '$field';";

	$more_inputs = get_one_field([
		'no_index' => 1,
		'pre' => "field1",
		'name' => $field,
		'ftype' => $info['type'],
		'index' => $info['index'],
		'flength' => $info['length'],
		'null' => $info['Null'],
		'ai' => $info['ai'],
		'default' => $info['Default'],
		'attribute' => $info['attr'],
		'collation' => $info['Collation']
		]);

	$inputs = array_merge($inputs, $more_inputs);
	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['content'] .= parse_in('gui_sync_new_table_inputs', []);
	if (param('_alter')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		else {
			$data = $obj->parsable_data($inputs);
			list($sql, $feedback) = alter_table($data, 0);
			$html['content'] = $feedback ? $html['content'] = "<p class='red'>$feedback</p><pre class='variant'>$sql</pre>" : "<p class='green'>".i18n('ok')."</p><pre class='variant'>$sql</pre>";
			$html['content'] .= table_props($data['name']);
			}
		}
	$sub = tabs($table);
	$sub = make_submenu(toggle_submen($sub, 4));
	$html['content'] = $sub.$html['content'];
	return $html;
	}

function add_field($html) {
	global $db;
	$table = clean_var(param('_table'), "w");
	$form = [
		"title"			=> "add_field",
		"myconf"		=> "tables",
		"no_cancel"		=> 1,
		"html"			=> $html,
		"submit"		=> "_add",
		'button_text' => i18n('ok')
		];

	$inputs = [
		'name' =>	[
			'caption'	=> i18n('table'),
			'type'	=> 'readonly',
			'value'	=> $table
			],
		'after' =>	[
			'caption'	=> i18n('add_after'),
			'type'	=> 'array',
			'extra'	=> get_columns($table),
			'raw'	=> 1
			],
		'todo' =>	[
			'type'	=> 'hidden',
			'value'	=> 'add'
			]
		];

	$more_inputs = get_one_field([
			'pre' => 'field1',
			'no_index' => 1,
			'name' => '',
			'ftype' => 'VARCHAR',
			'index' => '',
			'flength' => '',
			'null' => 'on',
			'ai' => 0,
			'default' => '',
			'attribute' => '',
			'collation' => 'utf8_general_ci'
			]);

	$inputs = array_merge($inputs, $more_inputs);

	$obj = new access($form);
	if (param('_add')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		else {
			$data = $obj->parsable_data($inputs);
			list($sql, $feedback) = alter_table($data, 1);
			$html['content'] = $feedback ? $html['content'] = "<p class='red'>$feedback</p><pre>$sql</pre>" : "<p class='green'>".i18n('ok')."</p><pre class='variant'>$sql</pre>";
			$html['content'] .= table_props($data['name']);
			}
		}
	else {
		$obj->add_input($inputs);
		$html = $obj->form();
		}
	$html['content'] .= parse_in('gui_sync_new_table_inputs', []);
	$sub = tabs($table);
	$sub = make_submenu(toggle_submen($sub, 4));
	$html['content'] = $sub.$html['content'];
	return $html;
	}

function query_window($html) {
	$sql = param('code');
	$pre = '';
	$t = clean_var(param('_table'), 'w');

	if (param('com')) {
		$f = clean_var(param('fid'), 'w');
		if (param('com') == 'tru') {$sql = "TRUNCATE TABLE `$t`;";}
		elseif (param('com') == 'dro') {$sql = "DROP TABLE `$t`;";}
		elseif (param('com') == 'drov') {$sql = "DROP VIEW `$t`;";}
		elseif (param('com') == 'drof') {$sql = "ALTER TABLE `$t` DROP `$f`;";}
		elseif (param('com') == 'droip') {$sql = "ALTER TABLE `$t` DROP PRIMARY KEY;";}
		elseif (param('com') == 'droi') {$sql = "ALTER TABLE `$t` DROP INDEX `$f`;";}
		elseif (param('com') == 'apri') {$sql = "ALTER TABLE `$t` ADD PRIMARY KEY(`$f`);";}
		elseif (param('com') == 'aind') {$sql = "ALTER TABLE `$t` ADD INDEX (`$f`);";}
		elseif (param('com') == 'auni') {$sql = "ALTER TABLE `$t` ADD UNIQUE (`$f`);";}
		elseif (param('com') == 'aautoi') {$ai = get_ai($t); $sql = "ALTER TABLE `$t` AUTO_INCREMENT = $ai;";
			}
		elseif (param('com') == 'afull') {
			$fields = array();
			foreach ($_REQUEST as $param=>$v) {
				if (preg_match('/^full_/', $param)) {
					$val = preg_replace('/^full_/', '' ,$param);
					array_push($fields, "`$val`");
					}
				}
			$f = implode(',', $fields);
			$sql = "ALTER TABLE `$t` ADD FULLTEXT ($f);";
			}
		$pre = '<p class="red">'.i18n('really_execute').'</p>';
		}

	$form = [
		"title"			=> "SQL",
		"myconf"		=> "tables",
		"html"			=> $html,
		'before_form'	=> $pre,
		"button_text"	=> i18n('execute'),
		"button_fa"	=> 'bolt',
		"no_cancel"		=> 1
		];

	$inputs = [
			'code'		=> [
				"type"		=> "bigtext",
				"syntax"	=> "sql",
				"duty"		=> 1,
				'default'	=> $sql
				],
			'todo'		=>	[
				'type'		=> 'free',
				'default'	=> "SQL"
				]
			];
	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	if (param('_store')) {
		$html['content'] .= execute_query($sql, false);
		$html['popup'] = i18n('mess_executed');
		}
	$sub = tabs($t);
	$sub = make_submenu(toggle_submen($sub, 2));
	$html['content'] = $sub.$html['content'];
	$html['left'] = tables_tree($t);
	return $html;
	}

function operations($html) {
	global $dba;
	$op = clean_var(param('_op'), 'w');
	$html['formtitle'] = i18n('database');
	// just mysql
	if ($op == 'stan') {
		exec("mysqldump --user={$dba['db_user']} --password={$dba['db_pw']} --host={$dba['host']} {$dba['database']} --result-file=lib/sql/{$dba['database']}.sql 2>&1", $output);
		$err = '';
		foreach ($output as $out) {
			if (preg_match('/Got error/', $out)) {$err .= $out.'<br />';} // no warnings!!
			}
		if ($err) {$html['content'] .= say_mess("<p class='red'>$err</p>", '', 'error');}
		else {$html['content'] .= say_mess("<p class='green'>../lib/sql/{$dba['database']} has been created</p>", '', 'ok');}
		}
	elseif ($op == 'ollie') {
		exec("mysql --user={$dba['db_user']} --password={$dba['db_pw']} {$dba['database']} < {$html['dir']}{$html['con']['coco']}/lib/sql/{$dba['database']}.sql 2>&1", $output, $err);
		if ($err) {$html['content'] .= say_mess("<p class='red'>No success mysql --user={$dba['db_user']} --password={$dba['db_pw']} {$dba['database']} < {$html['dir']}{$html['con']['coco']}/lib/sql/{$dba['database']}.sql</p>", '', 'error');}
		else {$html['content'] .= say_mess("<p class='green'>../lib/sql/{$dba['database']} has been read (You may login once more)</p>", '', 'ok');}
		}
	else {
		$html['content'] = say_mess("<p class='alright'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=tables&amp;todo=ops&amp;_op=stan'>WRITE SQL DUMP</a></p>", '', 'edit');
		if (file_exists("{$html['dir']}{$html['con']['coco']}/lib/sql/{$dba['database']}.sql")) {$html['content'] .= say_mess("<p class='red'>Proceed with caution!</p><p class='alright'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=tables&amp;todo=ops&amp;_op=ollie'>IMPORT SQL DUMP</a></p>", '', 'warning');}
		else {$html['content'] .= say_mess("<p class='red'>There is no dump you can import<br> ({$html['dir']}{$html['con']['coco']}/lib/sql/{$dba['database']}.sql)</p>", '', 'bolt-gold');}
		}
	$html['left'] = tables_tree('');
	return $html;
	}

function tables_tree($open) {
	global $db, $dba, $html;
	$tree = "";
	$tables = "";
	$letter = "";
	$open_letter = "";
	$alphabet = array();
	$arg = $db->prepare("SHOW TABLES FROM `{$dba['database']}`;");
	$arg->execute();
	$error = $arg->errorInfo();
	$error = $error[2];
	while ($data = $arg->fetch(PDO::FETCH_NUM)) {
		$status = "closed";
		$name = $data[0];
		if ($letter != strtolower(substr($name,0,1))) {$letter = strtolower(substr($name,0,1)); $alphabet[$letter] = "";}
		if ($open == $name) {$status = "open"; $open_letter = $letter;}
		$item = [
			"caption"	=> $name,
			"link"		=> "{$html['myurl']}?_id=tables&amp;sid={$html['sid']}&amp;_table=$name",
			"state"		=> $status
			];
		$alphabet[$letter] .= list_item($item);
		}
	foreach (range('a', 'z') as $l) {
		$status = "closed";
		if ($open_letter == $l) {$status = "open";}
		if (array_key_exists($l, $alphabet)) {
			$item = [
				"caption"	=> strtoupper($l),
				"link"		=> "",
				"state"		=> $status,
				"sub"		=> "<ul>$alphabet[$l]</ul>"
				];
			$tables .= list_item($item);
			}
		}
	if ($tables) {$tables = "<ul>$tables</ul>";}
	$item = [
		"caption"	=> $dba['database'],
		"link"		=> "{$html['myurl']}?_id=tables&amp;sid={$html['sid']}",
		"state"		=> 'open',
		'reg_icon' => 'database',
		"sub"		=> $tables
		];
	$tree .= list_item($item);

	$item = [
		"caption"	=> i18n('operations'),
		"link"		=> "{$html['myurl']}?_id=tables&amp;sid={$html['sid']}&amp;todo=ops",
		"state"		=> 'caution'
		];
	$tree .= list_item($item);
	$tree = parse_in('gui_tree', ['treelist' => $tree]);
	return ($tree);
	}

function tabs($table) {
	global $html;
	$subs = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id=tables&amp;todo=edit&amp;_table=$table", "inactive", "add"],
			[i18n('database'), $html['myurl']."?sid={$html['sid']}&amp;_id=tables", "inactive", "database"],
			["SQL", $html['myurl']."?sid={$html['sid']}&amp;_id=tables&amp;todo=SQL", "inactive", "terminal"],
			[i18n('table'), $html['myurl']."?sid={$html['sid']}&amp;_id=tables&amp;_table=$table", "inactive", "table_edit"],
			[i18n('properties'), $html['myurl']."?sid={$html['sid']}&amp;_id=tables&amp;_table=$table&amp;todo=props", "inactive", "properties"],
			[i18n('dump_table'), $html['myurl']."?sid={$html['sid']}&amp;_id=tables&amp;_table=$table&amp;todo=dumpdata", "inactive", "database-go"]
			);
	if (!$table) {
		$subs[0] = [i18n('new_table'), $html['myurl']."?sid={$html['sid']}&amp;_id=tables&amp;todo=new_table", "inactive", "table-add"];
		unset($subs[3]); unset($subs[4]); unset($subs[5]);
		}
	return $subs;
	}

/**
 * makes a mysql dump of a table
 * @param string name of table
 * @return string dump
 */
function dumpdata($table) {
	global $db, $html;

	$arg = $db->prepare("SHOW CREATE TABLE `$table`;");
	$arg->execute();
	$create = $arg->fetch(PDO::FETCH_ASSOC);

	$form = [
		"table"			=> $table,
		"orderby"		=> "id",
		"human"			=> "id",
		"html"			=> $html
		];

	$obj = new access($form);
	$inputs = $obj->inputs_from_table();

	$dump = "INSERT INTO `$table` (";
	$query = "SELECT ";
	foreach ($inputs as $k=>$v) {
		if ($v['type'] != "free") {
			$dump .= " `$k`,";
			$query .= " `$k`,";
			}
		}
	$dump = preg_replace('/,$/', '', $dump);
	$query = preg_replace('/,$/', '', $query);
	$dump .= ")\nVALUES ";
	$query .= " FROM `$table`;";
	$arg = $db->prepare($query);
	$arg->execute();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		$dump .= "(";
		foreach ($data as $v) {
			if (is_null($v)) {$dump .= " NULL,";}
			else {
				$v = str_replace("\r\n", "\\r\\n", $v);
				$v = str_replace("\n", "\\n", $v);
				$v = str_replace("\r", "\\r", $v);
				$v = str_replace("\t", "\\t", $v);
				$v = str_replace("'", "\\'", $v);
				$v = htmlspecialchars($v);
				$dump .= " '$v',";
				}
			}
		$dump = preg_replace('/,$/', '', $dump);
		$dump .= "),\n";
		}
	$dump = preg_replace('/,$/', ';', $dump);
	$c = isset($create['Create Table']) ? $create['Create Table'] : '';
	$c .= isset($create['Create View']) ? $create['Create View'] : '';
	$c .= ";\n\n".$dump;
	return htmltag('h2', '', i18n('table')." $table")."<textarea cols='80' rows='30'>$c</textarea>";
	}

function table_props($table) {
	global $db, $html;
	$c = htmltag('h2', '', i18n('table')." $table");
	$url = "{$html['myurl']}?sid={$html['sid']}&amp;_id=tables&amp;_table=$table";
	list($indeces, $num, $text1, $text2, $text3, $misc, $date, $def) = some_defaults();
	$texttype = array_merge($text1, $text2);

	$q = "SHOW KEYS FROM `$table`;";
	$arg = $db->prepare($q);
	$arg->execute();
	$fulltext = array();
	$l = '';
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		if ($data['Index_type'] == "FULLTEXT") {
			if (!array_key_exists($data['Key_name'], $fulltext)) {
				$fulltext[$data['Key_name']] = [$data['Column_name']];
				}
			else {array_push($fulltext[$data['Key_name']], $data['Column_name']);}
			}
		else {
			$do = $data['Key_name'] == 'PRIMARY' ? 'droip' : 'droi';
			$l .= "<li>".htmltag('a', 'href="'.$url.'&amp;todo=SQL&amp;com='.$do.'&amp;fid='.$data['Key_name'].'"', get_icon('delete', i18n('delete')))."&nbsp;".htmltag('strong', '', $data['Column_name']);
			$kt = $data['Non_unique'] ? $data['Key_name'] : $data['Key_name']." UNIQUE";
			$kt = htmltag('li', '', $kt);
			$kt = htmltag('ul', '', $kt);
			$l .= $kt;
			}
		}
	foreach ($fulltext as $k=>$v) {
		$l .= "<li>".htmltag('a', 'href="'.$url.'&amp;todo=SQL&amp;com=droi&amp;fid='.$k.'"', get_icon('delete', i18n('delete')))."&nbsp;".htmltag('strong', '', $k);
		$l .= "<ul><li>FULLTEXT</li>";
		foreach($v as $col) {$l .= "<li>$col</li>";}
		$l .= "</ul></li>\n";
		}
	if ($l) {
		$l = htmltag('ul', '', $l);
		$l = htmltag('h3', '', i18n('indexes')).$l;
		}
	$l .= htmltag('a', 'href="'.$url.'&amp;todo=SQL&amp;com=aautoi"', get_icon('bolt-gold', i18n('Auto Increment')))."&nbsp; Set Auto Increment";

	$q = "SHOW TABLE STATUS WHERE `Name` = '$table';";
	$d = execute_query($q, true);
	$c .= htmltag('div', 'class="col w50p first"', $d);
	$c .= htmltag('div', 'class="col w50p last"', $l);
	$q = "SHOW FULL COLUMNS FROM `$table`;";
	$arg = $db->prepare($q);
	$arg->execute();
	$t = ''; $row = 0;
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		$tr = ''; $th = '';
		unset($data['Privileges']);
		unset($data['Comment']);
		$d = array();
		$d['action'] = "<a href='$url&amp;todo=alter&amp;fid={$data['Field']}'>".get_icon('edit', i18n('edit'))."</a>&nbsp;";
		$d['action'] .= "<a href='$url&amp;todo=SQL&amp;fid={$data['Field']}&amp;com=drof'>".get_icon('delete', i18n('delete'))."</a>&nbsp;";

		foreach ($fulltext as $kk=>$vv){
			if (in_array($data['Field'], $vv)) {$data['Key'] = "FULLTEXT ($kk)";}
			}
		if (!$data['Key']) {
			$d['action'] .= "<a href='$url&amp;todo=SQL&amp;fid={$data['Field']}&amp;com=apri'>".get_icon('key', 'PRIMARY')."</a>&nbsp;";
			$d['action'] .= "<a href='$url&amp;todo=SQL&amp;fid={$data['Field']}&amp;com=aind'>".get_icon('bolt', 'INDEX')."</a>&nbsp;";
			$d['action'] .= "<a href='$url&amp;todo=SQL&amp;fid={$data['Field']}&amp;com=auni'>".get_icon('star', 'UNIQUE')."</a>&nbsp;";
			preg_match('/^(\w+)\(.+\)\s?\w*/', $data['Type'], $m);
			$s = isset($m[1]) ? $m[1] : $data['Type'];
			if(in_array(strtoupper($s), $texttype)) {
				$d['action'] .= htmltag('input', 'type="checkbox" name="full_'.$data['Field'].'" id="ifull_'.$data['Field'].'" title="FULLTEXT"', '');
				$d['action'] .= htmltag('label', 'for="ifull_'.$data['Field'].'" title="FULLTEXT"', ' ');
				}
			}
		$data = array_merge($d, $data);

		foreach (array_keys($data) as $k) {
			if (!$row) {
				$tt = $k == 'action' ? i18n($k) : $k;
				$th .= htmltag('th', '', $tt);
				}
			$v = $data[$k];
			$icons = '';
			if ($k == 'Field') {
				$icons = "<a href='$url&amp;todo=alter&amp;fid=$v'>".get_icon('edit', i18n('edit'))."</a>&nbsp;";
				$icons .= "<a href='$url&amp;todo=SQL&amp;fid=$v&amp;com=drof'>".get_icon('delete', i18n('delete'))."</a>";
				$v = htmltag('strong', '', $v);
				}
			$tr .= htmltag('td', '', $v);
			}
		if ($th) {$t .= htmltag('tr', '', $th);}
		$t .= htmltag('tr', '', $tr);
		$row++;
		}
	$last = htmltag('td', 'class="alright"', htmltag('input', "type='submit' class='button' name='_full' value='FULLTEXT'",''));
	$last .= htmltag('td', 'colspan="7"', '');
	$t .= htmltag('tr', '', $last);
	$t = htmltag('table', 'class="table"', $t);
	$t .= htmltag('input', "type='hidden' name='sid' value='{$html['sid']}'",'');
	$t .= htmltag('input', "type='hidden' name='_id' value='tables'",'');
	$t .= htmltag('input', "type='hidden' name='_table' value='$table'",'');
	$t .= htmltag('input', "type='hidden' name='todo' value='SQL'",'');
	$t .= htmltag('input', "type='hidden' name='com' value='afull'",'');
	$t = htmltag('form', "action='{$html['myurl']}' id='itable' name='table' method='post' enctype='multipart/form-data'", $t);
	$c .= $t;
	$c .= htmltag('a', 'href="'.$url.'&amp;todo=add" class="as_button"', i18n('add_field'))."<br />";
	return $c;
	}

function execute_query($sql, $silent) {
	global $db;
	$allow = ['SELECT', 'SHOW', 'INSERT', 'UPDATE', 'DELETE', 'CREATE', 'ALTER', 'TRUNCATE', 'DROP'];
	$with_result = ['SELECT', 'SHOW'];
	$lines = explode("\n", $sql);
    $query = "";
    $content = "";
    foreach($lines as $line){
		$line = trim($line);
		if($line == "" OR preg_match('/^\s*(#|--\s)/sU', $line)){}
		else {
            $query .= $line;
            if (substr(rtrim($query), -1) == ';'){
				preg_match('/^\s*(\w*)\s.*/', $query, $m);
				if (in_array(strtoupper($m[1]), $allow)) {
					$start = microtime(true);
					$check = true;
					$arg = $db->prepare($query);
					try {$arg->execute();}
					catch (PDOException $e) {$check = false;}
					if ($check === false) {
						$err = $arg->errorInfo();
						$error = array_key_exists(2, $err) ? $err[2] : "";
						$content .= "<p class='red'>".i18n('error').": $error<br/>$query</p>";
						}
					else {
						$rows = $arg->rowCount();
						$end = microtime(true);
						$time = sprintf('%0.4f ms', 1000*($end-$start));
						if ($time > 1000) {$time = sprintf('%0.4f s', $end-$start);}
						if (in_array(strtoupper($m[1]), $with_result)) {
							if ($rows > 1) {
								$count = 0;
								if (!$silent) {$content .= "<p>$m[1]: $rows ".i18n('entries')." $time</p>\n";}
								$content .= "<table class='table'>\n";
								while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
									if (!$count) {
										$content .= "\t<tr>\n";
										foreach($data as $k=>$v) {
											$content .= "\t\t<th class='first' scope='col'>$k</th>\n";
											}
										$content .= "\t</tr>\n";
										}
									$content .= "\t<tr>\n";
										foreach($data as $k=>$v) {
											$content .= "\t\t<td>$v</td>\n";
											}
									$content .= "\t</tr>\n";
									$count++;
									}
								$content .= "</table>\n";
								}
							elseif ($rows == 1) {
								if (!$silent) {$content .= "<p>$m[1]: $rows ".i18n('entry')."</p>\n";}
								$content .= "<ul>\n";
								$data = $arg->fetch(PDO::FETCH_ASSOC);
								foreach($data as $k=>$v) {
									if ($v) {$content .= "\t\t<li><strong>$k</strong>: $v</li>\n";}
									}
								$content .= "</ul>";
								}
							else {$content .= "<p>$m[1]: ".i18n('mess_no_entry')."</p>";}
							}
						else {$content .= "<p><span class='green'>".i18n('ok')."</span> $m[1]: $rows ".i18n('entries')."</p>";}
						}
					}
				else {$content .= "<p class='red'>".i18n('error').": $query</p>";}
				$query = "";
				}
			}
		}
	if ($content && !$silent) {$content = htmltag('h2', '', i18n('results')).$content;}
	return $content;
	}

function get_ai($table) {
	global $db;
	$arg = $db->prepare("SHOW TABLE STATUS WHERE `Name` = '$table';");
	$arg->execute();
	$d = $arg->fetch(PDO::FETCH_ASSOC);
	return $d['Auto_increment'];
	}

function get_one_field($defs) {
	$pre = $defs['pre'];
	$ftypes = ["TINYINT", "SMALLINT", "MEDIUMINT", "INT", "BIGINT", "FLOAT", "DOUBLE",
	"DECIMAL", "BIT", "CHAR", "VARCHAR", "TINYTEXT", "TEXT", "MEDIUMTEXT",
	"LONGTEXT", "BINARY", "VARBINARY", "TINYBLOB", "BLOB", "MEDIUMBLOB", "LONGBLOB", "
	ENUM", "SET", "DATE", "DATETIME", "TIME", "TIMESTAMP", "YEAR"];
	$no = preg_replace("/\D/", '', $pre);
	$inputs = [
		$pre.'_fieldset' =>	[
			'caption' => i18n('datafield')." #$no",
			'type' => 'fieldset'
			],
		$pre.'_name' =>	[
			'caption' => i18n('fieldname'),
			'type'	=> 'text',
			'value' => $defs['name'],
			'duty'	=> 1
			],
		$pre.'_type' =>	[
			'caption' => i18n('fieldtype'),
			'type'	=> 'array',
			'extra'	=> $ftypes,
			'raw'	=> 1,
			'value' => $defs['ftype'],
			'duty'	=> 1,
			'data_attr' => ' data-app="switch_char_num"'
			],
		$pre.'_length' =>	[
			'caption' => i18n('fieldlength'),
			'type'	=> 'text',
			'size' => 16,
			'value' => $defs['flength']
			],
		$pre.'_index' =>	[
			'caption' => 'INDEX',
			'type'	=> 'array',
			'extra'	=> ['PRIMARY','UNIQUE','INDEX', 'FULLTEXT'],
			'raw'	=> 1,
			'value' => $defs['index'],
			'data_attr' => ' data-app="switch_index"'
			],
		$pre.'_ai' =>	[
			'caption' => 'AUTO INCREMENT',
			'type'	=> 'flag',
			'value' => $defs['ai'],
			'data_attr' => ' data-enable="index"'
			],
		$pre.'_null' =>	[
			'caption' => 'NULL',
			'type'	=> 'flag',
			'value' => $defs['null']
			],
		$pre.'_length' =>	[
			'caption' => i18n('fieldlength'),
			'type'	=> 'text',
			'size' => 16,
			'value' => $defs['flength']
			],
		$pre.'_default' =>	[
			'caption' => 'DEFAULT',
			'type'	=> 'text',
			'value' => $defs['default']
			],
		$pre.'_collation' =>	[
			'caption' => 'Collation',
			'type'	=> 'array',
			'extra'	=> get_Collation(),
			'raw'	=> 1,
			'value' => $defs['collation'],
			'data_attr' => ' data-enable="char"'
			],
		$pre.'_attribute' =>	[
			'caption' => i18n('attribute'),
			'type'	=> 'array',
			'extra'	=> ['BINARY', 'UNSIGNED', 'UNSIGNED ZEROFILL'],
			'raw'	=> 1,
			'value' => $defs['attribute'],
			'data_attr' => ' data-enable="num"'
			]
		];
	if (isset($defs['no_index'])) {$inputs[$pre.'_index']['type'] = 'readonly';}
	return $inputs;
	}

/**
 * analyse request and build inputs
 * @return array inputs
 */
function get_my_fields() {
	$inputs = array();
	foreach ($_REQUEST as $k=>$v) {
		if (preg_match('/field(\d+)_name/', $k, $m)) {
			$pre = 'field'.$m[1];
			$more_inputs = get_one_field([
				'pre' => $pre,
				'name' => param($pre.'_name'),
				'ftype' => param($pre.'_ftype'),
				'index' => param($pre.'_index'),
				'flength' => param($pre.'_flength'),
				'null' => param($pre.'_null'),
				'ai' => param($pre.'_ai'),
				'default' => param($pre.'_default'),
				'attribute' => param($pre.'_attribute'),
				'collation' => param($pre.'_collation')
				]);
			$inputs = array_merge($inputs, $more_inputs);
			}
		}
	return $inputs;
	}

function get_Collation() {
	global $db;
	$arg = $db->prepare("SHOW COLLATION;");
	$arg->execute();
	$coll = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
	return ($coll);
	}

function get_char_set() {
	global $db;
	$arg = $db->prepare("SHOW CHARACTER SET;");
	$arg->execute();
	$chr = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
	return ($chr);
	}

function get_columns($table) {
	global $db;
	$arg = $db->prepare("SHOW COLUMNS FROM `$table`;");
	$arg->execute();
	$col = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
	return ($col);
	}

function create_new_table($data) {
	global $db;
	list($indeces, $num, $text1, $text2, $text3, $misc, $date, $def) = some_defaults();
	$sql = "CREATE TABLE IF NOT EXISTS `{$data['name']}` (\n";
	foreach ($data as $k=>$v) {
		if (preg_match('/field(\d+)_name$/', $k, $m)) {
			$pre = 'field'.$m[1];
			$length = $data[$pre.'_length'];
			$type = $data[$pre.'_type'];
			if (!$length) {
				if (in_array($type, $num)) {$length = $def[$type];}
				elseif(in_array($type, $text1)) {$length = 64;}
				}
			$default = $data[$pre.'_default'];
			if (!$default) {
				if (in_array($type, $num)) {$default = '0';}
				else {$default = "''";}
				}
			else {$default = "'$default'";}
			$null = $data[$pre.'_null'] ? 'DEFAULT NULL' : "NOT NULL";
			$default = $data[$pre.'_null'] ? '' : "DEFAULT $default";
			if ($data[$pre.'_ai']) {$default = "AUTO_INCREMENT";}
			// TIMESTAMP should have default value
			if ($type == "TIMESTAMP") {$default = "DEFAULT CURRENT_TIMESTAMP";}
			if ($data[$pre.'_index']) {array_push($indeces[strtolower($data[$pre.'_index'])], "`$v`");}
			$length = $length ? "($length)" : '';
			$sql .= "`$v` $type$length {$data[$pre.'_attribute']} $null $default,\n";
			}
		}

	foreach($indeces as $key=>$f) {
		if ($f) {
			$fields = implode(",", $f);
			$key = $key == 'index' ? 'KEY' : strtoupper($key)." KEY";
			$sql .= "$key ($fields),\n";
			}
		}
	$sql = preg_replace("/\,\n$/", "\n", $sql);
	$sql .= ") ENGINE=MyISAM DEFAULT CHARSET={$data['char_set']};";
	$arg = $db->prepare($sql);
	$arg->execute();
	$err = $arg->errorInfo();
	$error = array_key_exists(2, $err) ? $err[2] : "";
	return array($sql, $error);
	}

function alter_table($data, $add) {
	global $db;
	$error = false;
	list($indeces, $num, $text1, $text2, $text3, $misc, $date, $def) = some_defaults();
	$sql = "ALTER TABLE `{$data['name']}` \n";
	foreach ($data as $k=>$v) {
		if (preg_match('/field(\d+)_name$/', $k, $m)) {
			$pre = 'field'.$m[1];
			$length = $data[$pre.'_length'];
			$type = $data[$pre.'_type'];
			if (!$length) {
				if (in_array($type, $num)) {$length = $def[$type];}
				elseif(in_array($type, $text1)) {$length = 64;}
				}
			$default = $data[$pre.'_default'];
			if (!$default) {
				if (in_array($type, $num)) {$default = '0';}
				else {$default = "''";}
				}
			else {$default = "'$default'";}
			$null = $data[$pre.'_null'] ? 'DEFAULT NULL' : "NOT NULL";
			$default = $data[$pre.'_null'] ? '' : "DEFAULT $default";
			if ($data[$pre.'_ai']) {$default = "AUTO_INCREMENT";}
			// TIMESTAMP should have default value
			if ($type == "TIMESTAMP") {$default = "DEFAULT CURRENT_TIMESTAMP";}
			if ($data[$pre.'_index']) {array_push($indeces[strtolower($data[$pre.'_index'])], "`$v`");}
			$length = $length ? "($length)" : '';
			$collation = in_array($type, $text3) ? " COLLATE {$data[$pre.'_collation']}" : '';
			if ($add) {
				$after = $data['after'] ? " AFTER `{$data['after']}`" : '';
				$sql .= "ADD `$v` $type$length {$data[$pre.'_attribute']}$collation $null $default$after,\n";
				}
			else {$sql .= "CHANGE `{$data['fid']}` `$v` $type$length$collation {$data[$pre.'_attribute']} $null $default,\n";}
			}
		}

	$sql = preg_replace("/\,\n$/", "", $sql);
	$sql .= ";";
	$arg = $db->prepare($sql);
	$check = true;
	try {$arg->execute();}
	catch (PDOException $e) {$check = false;}
	if ($check === false) {
		$err = $arg->errorInfo();
		$error = array_key_exists(2, $err) ? $err[2] : "";
		}
	return array($sql, $error);
	}

function some_defaults() {
	$indeces = ['primary' => [],'unique' => [],'index' => [], 'fulltext' => []];
	$num = ["TINYINT", "SMALLINT", "MEDIUMINT", "INT", "BIGINT", "FLOAT", "DOUBLE",	"DECIMAL", "BIT"];
	$text1 = ["CHAR", "VARCHAR", "BINARY", "VARBINARY"];
	$text2 = ["TINYTEXT", "TEXT", "MEDIUMTEXT",	"LONGTEXT", "TINYBLOB", "BLOB", "MEDIUMBLOB", "LONGBLOB"];
	$text3 = ["CHAR", "VARCHAR", "TINYTEXT", "TEXT", "MEDIUMTEXT",	"LONGTEXT"];
	$misc = ["ENUM", "SET"];
	$date = ["DATE", "DATETIME", "TIME", "TIMESTAMP", "YEAR"];
	$def = ["TINYINT" => 3, "SMALLINT" => 5, "MEDIUMINT" => 8, "INT" => 10, "BIGINT" => 20,
			"FLOAT" => '10,4', "DOUBLE" => '10,4', "DECIMAL" => '10,2', "BIT" => 1];
	return array($indeces, $num, $text1, $text2, $text3, $misc, $date, $def);
	}

?>
