<?php

function generate_slide_show($data, $id) {
	global $db, $html;
	$q = "SELECT * FROM `slider_images` WHERE `slider` = ? ORDER BY `sort`;";
	$arg = $db->prepare($q);
	$arg->execute(array($id));
	$data['list'] = '';
	while ($img = $arg->fetch(PDO::FETCH_ASSOC)) {
		$img['alt'] = '';		
		if ($img['title'] || $img['copyright']) {
			$img['alt'] = $img['title'];
			if ($img['copyright']) {$img['title'] .= " ".htmltag('span', 'class="small"', '&copy; '.$img['copyright']);}
			$img['title'] = parse_in('cms_slider_caption', $img);
			}	
		list($img['width'], $img['height']) = getimagesize("{$html['dir']}/pictures/normal/{$img['picture']}");
		$data['list'] .= parse_in('cms_slider_item', $img);
		}
	$data['list'] = htmltag('ul', 'class="rslides"', $data['list']);
	$data['auto'] = $data['auto'] == 'on' ? 'true' : 'false';
	$data['timestamp'] = date('Y-m-d H:i:s');
	$content = parse_in('cms_slider', $data);
	$script = parse_in('cms_slider_script', []);
	$q = "UPDATE `content` SET `body` = ?, `generate` = 1, `head` = ? WHERE `id` = ?;";
	$arg = $db->prepare($q);
	$arg->execute(array($content, $script, $id));
	}
	
function gen_all_sliders() {
	global $db;
	$q = "SELECT `content`.`title`, `content`.`short`, `content`.`folder`, `content`.`lang`,
	`gallery`.`preface`, `gallery`.`gal_template`, `gallery`.`pic_dim`, `content`.`published`,
	`content`.`parent`, `content`.`template`, `content`.`sort`, `content`.`file`,
	`content`.`update`, `content`.`c_start`, `content`.`c_end`, `content`.`type`
	FROM `content` LEFT JOIN `gallery` ON `content`.`id` = `gallery`.`pid`
	WHERE `published` >= 1 ORDER BY `sort`;";
	$arg = $db->prepare($q);
	$arg->execute();
	$rec = $arg->rowCount();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		generate_gallery($data, $data['id']);
		}
	}
?>