<?php
# @Author: Rainer Imb <consentio>
# @Date:   2018-08-31 12:49:58
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: slide_show.php
# @Last modified by:   consentio
# @Last modified time: 2023-08-21T11:13:57+02:00
# @License: GPL 2.0

class slide_show {

	public function plugin($html) {
		include_once('slide_show_generator.php');
		add_i18n('gallery');
		if (param('todo') == 'deps') {$html['action'] = 'deps';}
		switch ($html['action']) {
			case ("deps"): $html = $this->get_deps($html); break;
			case ("slide_images"): $html = $this->images_admin($html); break;
			default: $html = $this->slider_admin($html);
			}
		return $html;
		}

	private function slider_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$parent = clean_var(param('parent'), "n");
		$source = clean_var(param('make'), "n");
		list($mylang, $myparent, $ptype) = parents_def($parent);
		$form = form_by_type(1);
		$form['rid'] = $rid;
		$form['myconf'] = "slide_show";
		$form['title'] .= " &ndash; ".i18n("slide_show");
		$form['left'] = [['table' => 'slide_show', 'foreign' => 'pid']];
		$or_inputs = inputs_by_type('plugin');
		$or_inputs['type'] =	['type' => 'hidden', 'default' => 'slide_show'];
		$or_inputs['folder'] =	['type' => 'hidden', 'value' => 0];
		$or_inputs['parent']['default'] = $parent;

		$inputs2 = [
			'text' => [
				'type'		=> 'wysiwyg',
				'table'		=> 1,
				'rows'		=> 15,
				],
			'auto' => [
				'type'		=> 'flag',
				'table'		=> 1,
				'duty'		=> 'on'
				],
			'interval' => [
				'type'		=> 'spin',
				'size'		=> 2,
				'default'	=> 6,
				'min'		=> 2,
				'max'		=> 15,
				'interval'	=> 1,
				'duty'		=> 1,
				'table'		=> 1
				],
			'images' => [
				'type' => 'subform',
				'conf' => 'slide_images',
				'foreign' => 'slider',
				'height' => 650
				]
			];

		if (!$rid || $rid == "new") {
			$form['button_text'] = i18n('next');
			$inputs = [
				'title' 		=>	$or_inputs['title'],
				'short' 		=>	$or_inputs['short'],
				'folder' 		=> $or_inputs['folder'],
				'lang'			=>	$or_inputs['lang'],
				'parent' 		=> $or_inputs['parent'],
				'type' 			=> $or_inputs['type'],
				'file' 			=>	['type' => 'hidden'],
				'make' 			=>	[
					'caption' => i18n('img_source'),
					'type' => 'array',
					'extra' => [i18n('add_by_hand'), i18n('img_portfolio')], // , i18n('img_lightdesk')
					'css_class' => 'ask_for_more',
					'default' => 1,
					'duty'	=> 1
					]
				];
			}
		else {
			$in1 = array_slice($or_inputs, 0, 4);
			$in2 = array_slice($or_inputs, 4);
			$inputs = array_merge($in1, $inputs2, $in2);
			}


		$obj = new access($form);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				if ($obj->rid == "new") {
					unset($inputs['make']);
					$inputs['file']['value'] = "/".clean_filename($inputs['title']['value'].".html", $html['dir']);
					$rid = $obj->store($inputs);
					$obj->rid = $rid;
					$obj->feedback = '';
					if ($source >= 1) {$this->insert_img($rid, $source);}
					// next form
					$todo = "edit";
					$obj->button_text = i18n('save');
					$in1 = array_slice($or_inputs, 0, 4);
					$in2 = array_slice($or_inputs, 4);
					$inputs = array_merge($in1, $inputs2, $in2);
					}
				else {
					$inputs['update']['value'] = date('Y-m-d H:i:s');
					$id = $obj->store($inputs);
					$html['popup'] = $obj->feedback;
					generate_slide_show($obj->stored, $id);
					generate();
					}
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$inputs['parent']['lclause'] .= " AND `lang` = '$mylang'";
				$inputs['lang']['default'] = $mylang;
				$obj->add_input($inputs);
				$html = $obj->form();
				$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"#ishort\").title2short();});</script>\n";
				}
			}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			if (param('_del')) {
				$records = $obj->get_multiple_values($inputs); // before we delete we need some values
				foreach ($records as $row) {
					unlink("{$html['dir']}{$row['file']}");
					}
				$obj->delete();
				generate();
				}
			$obj->myconf = 'pages'; // return to pages...
			$obj->title = i18n("pages");
			$inputs = inputs_by_type('view');
			$submen = pages_tabs($parent);
			$obj->before_table = make_submenu($submen);
			$html = $obj->table($inputs);
			$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"[data-app='preview']\").popLink({header: '".i18n('preview')."', 'top': '5%', 'left': '1%', 'width': '1024', 'height': '600'});});</script>\n";
			}
		$html['left'] = content_tree($parent, "pages");
		$html['scripts'] .= <<< "EOL"
	<script type="text/javascript">
	\$(document).ready(function(){\$(".ask_for_more").moreInputs({'id':"gallery",'sid':"{$html['sid']}",'script':"{$html['con']['coco']}/",'todo':'deps'})});
	</script>
EOL;
		return $html;
		}

	private function images_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$slider = clean_var(param('slider'), "w");

		$form = [
			"title"			=> i18n('images'),
			"table"			=> "slider_images",
			"myconf"		=> "slide_images",
			"orderby"		=> "sort",
			"human"			=> "picture",
			"html"			=> $html,
			"rid"			=> $rid,
			"filters"		=> ["slider"],
			"searchform"	=> 0,
			"table_fields"	=> ['picture', 'title', 'sort']
			];

		$inputs = [
			'picture'	=> [
				'type'	=> 'image',
				'duty'	=> 1,
				],
			'title'	=> [
				'type'	=> 'text',
				],
			'copyright'	=> [
				'type'	=> 'text',
				],
			'slider'	=> [
				'type'	=> 'hidden',
				'default'	=> $slider
				],
			'sort'	=> [
				'type'	=> 'sort',
				'do'	=> 1,
				'type'	=> 'sort',
				'default'	=> 10,
				]
			];


		$obj = new access($form);
		// $obj->set_attribute($inputs);

		if (param('_sortlist')) {
			$obj->sort_list();
			reorder($form['table'], 'slider', $slider);
			}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;slider=$slider", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		return $html;
		}


	private function get_deps($html) {
		$val = param('_v');
		$prae = param('_ref');
		$html['content'] = "";
		if ($val == 2) {
			$form = ["html"	=> $html];
			$sel = [
				'portfolio' =>	[
					'type'	=> 'lookup',
					'duty'	=> 1,
					'lid'	=> "id",
					'lval'	=> "graduated",
					'tval'	=> "name",
					'lord'	=> "parentsort",
					'ltable'	=> "image_folder"
					],
				'import_text' => [
					'type'	=> 'flag',
					'default' => 'on'
					]
				];
			$obj = new access($form);
			$obj->add_input($sel);
			$html['content'] = $obj->inputs;
			}
		elseif ($val == 3) {
			$form = ["html"	=> $html];
			$sel = [
				'import_text' => [
					'type'	=> 'flag',
					'default' => 'on'
					]
				];
			$obj = new access($form);
			$obj->add_input($sel);
			$html['content'] = $obj->inputs;
			}
		$html['gui'] = 6;
		return $html;
		}

	private function insert_img($rid, $source) {
		global $db;
		if ($source == 2) {
			$pf = clean_var(param('portfolio'), 'n');
			$q = "SELECT * FROM `image_db` WHERE `parent` = ? ORDER BY `id` LIMIT 30;";
			$arg = $db->prepare($q);
			$arg->execute(array($pf));
			while ($img = $arg->fetch(PDO::FETCH_ASSOC)) {
				$img['description'] = preg_match('/^\[/', $img['description']) ? '' : htmltag('p', '', $img['description']);
				if (param('import_text') != 'on'){$img['title'] = ''; $img['description'] = '';}
				$q2 = "INSERT INTO `slider_images` SET `picture` = ?, `title` = ?, `copyright` = ?, `text` = ?, `slider` = ?;";
				$arg2 = $db->prepare($q2);
				$arg2->execute(array($img['filename'], $img['title'], $img['copyright'], $img['description'], $rid));
				}
			}
		}
	}
?>
