<?php

/**
 * plugin basic and shared functions of webshop
 * @package consentio
 */

class shop_basics {
	public $defs = [];
	public $taxes = [];

	public function __construct(){
		$this->defs = read_settings(['group' => 'webshop']);
		}

	public function get_price($d) {
		global $website;
		$tax = false;
		if (!isset($this->taxes[$website['country']])) {$this->get_taxes($website['country']);}
		if (!isset($this->taxes[$this->isoc])) {$this->get_taxes($this->isoc);}
		if (!array_key_exists('dicount', $d)) {$d['discount'] = 0;}
		$otax = $this->taxes[$website['country']]['tax'.$d['tax']];
		// step down if there is no entry
		if (!$otax) {
			if ($d['tax'] == 3) {$otax = $this->taxes[$website['country']]['tax2'];}
			if (!$otax) {$otax = $this->taxes[$website['country']]['tax1'];}
			}
		$d['price_info'] = '';
		// special price
		if (intval($d['special_price'])) {
			$fp = sprintf('%0.2f', $d['price']);
			$d['special'] = htmltag('p', 'class="green"', i18n('instead_of')." $fp ".$this->defs['currency']);
			$d['price'] = $d['special_price'];
			}
		// discount
		if (intval($d['discount'])) {
				$d['price'] = $d['price']*(1-($d['discount']/100));
				}
		// incl and excl depending on input
		if ($this->defs['input_price'] == 1) {
			$d['incl'] = $d['price'];
			$d['excl'] = $d['price']/(($otax/100)+1);
			//$d['price_info'] .= i18n('incl_vat');
			}
		elseif ($this->defs['input_price'] == 2) {
			$d['excl'] = $d['price'];
			$d['incl'] = $d['price'] + ($d['price']*($otax/100));
			//$d['price_info'] .= i18n('excl_vat');
			}
		if ($website['country'] != $this->isoc) {
			$tax = $this->taxes[$this->isoc]['tax'.$d['tax']];
			if (!$tax) {
				if ($d['tax'] == 3) {$tax = $this->taxes[$this->isoc]['tax2'];}
				if (!$tax) {$tax = $this->taxes[$this->isoc]['tax1'];}
				}
			// outside EU
			if (!$tax) {
				$d['price_info'] .= i18n('excl_vat').'<br />'.i18n('additional_vat');
				$d['price'] = $d['excl'];
				$d['incl'] = $d['excl'];
				$otax = 0; // supersmart ;-)
				}
			// EU VAT if activated
			elseif ($this->defs['eu_vat'] == 2) {
				// new tax for destination
				$d['incl'] = $d['excl'] + ($d['excl']*($tax/100));
				$d['price'] = $d['incl'];
				$d['price_info'] .= i18n('incl')." $tax% ".$this->taxes[$this->isoc]['tax_name'];
				}
			// default
			else {
				$d['price'] = $d['incl'];
				$d['price_info'] .= i18n('incl_vat');
				$tax = $otax;
				}
			}
		else {
			$d['price'] = $d['incl'];
			$d['price_info'] .= i18n('incl_vat');
			}
		$d['vat'] = $tax ? $tax : $otax;
		$d['price'] = sprintf('%0.2f', $d['price']);
		$d['incl'] = sprintf('%0.2f', $d['incl']);
		$d['excl'] = sprintf('%0.2f', $d['excl']);

		// TODO quantity discount
		return $d;
		}

	public function get_taxes($country) {
		global $db;
		$tax = array();
		$arg = $db->prepare("SELECT `tax1`, `tax2`, `tax3`, `tax_name` FROM `eu_vat` WHERE `﻿iso` = ?;");
		$arg->execute([strtoupper($country)]);
		$tax = $arg->fetch(PDO::FETCH_ASSOC);
		$tax['tax1'] = floatval($tax['tax1']);
		$tax['tax2'] = isset($tax['tax2']) ? floatval($tax['tax2']) : 0;
		$tax['tax3'] = isset($tax['tax3']) ? floatval($tax['tax3']) : 0;
		$this->taxes[$country] = $tax;
		}

	public function get_country_for_oid($oid, $type = 'cl') {
		global $db;
		$q = "SELECT `clients`.`country`  FROM `webshop_order`, `clients` WHERE `webshop_order`.`client` = `clients`.`id` AND `webshop_order`.`id` = ?;";
		if ($type == 'delivery'){ $q = "SELECT `clients_delivery`.`country`  FROM `webshop_order`, `clients_delivery` WHERE `webshop_order`.`client` = `clients_delivery`.`cid` AND `webshop_order`.`id` = 1;";}
		$arg = $db->prepare();
		$arg->execute([$oid]);
		$d = $arg->fetch(PDO::FETCH_ASSOC);
		return $d['country'];
		}

	public function generate_product($data, $id) {
		global $db, $html, $website;
		// printversion
		$data['print'] = i18n('print_version');
		$data['print'] = parse_in('cms_articles_print', $data);
		// share buttons
		$data['decURL'] = urlencode($website['website_url'].$data['file']);
		$data['share_buttons'] = parse_in('cms_share_buttons', $data);

		// picture
		if ($data['picture']) {
			$pic_size = "normal";
			$pic_orig = "big";
			$templ = 'cms_shop_picture';
			list($w, $h) = getimagesize("{$html['dir']}/pictures/$pic_size/{$data['picture']}");
			list($w2, $h2) = getimagesize("{$html['dir']}/pictures/$pic_orig/{$data['picture']}");
			$data['width'] = $w;
			$data['height'] = $h;
			$data['resize'] = '';
			$data['eziser'] = '';
			$data['alt'] = $data['title'];
			$used_pic = $pic_size;
			// small picture reziseable
			//if	(($w2*0.7 > $w)) {
				$data['resize'] = "<a href=\"/pictures/$pic_orig/{$data['picture']}\"  data-app=\"lightbox\">";
				$data['eziser'] = '</a>';
				//}
			$data['src'] = "/pictures/$used_pic/{$data['picture']}";
			if ($data['new']) {$data['new'] = htmltag('div', 'class="new_flag"', i18n('new'));}
			error_log($data['special_price'],0);
			if ($data['special_price'] != 0) {$data['new'] = htmltag('div', 'class="new_flag"', "%");}
			$data['picture'] = parse_in($templ, $data);
			}
		$data  = $this->get_manufacturer($data);
		$props = ['colour', 'weight', 'size', 'author', 'length', 'whatever'];
		foreach ($props as $k) {
			if ($data[$k]) {
				$capt = $k == 'whatever' ? '' : '<strong>'.i18n($k)."</strong>: ";
				$data[$k] = "$capt{$data[$k]}<br />";
				}
			}
		$data['more_img'] = $this->make_more_pictures($id);
		$i18n_words = ['product_no'];
		foreach ($i18n_words as $w) {
			$data['i18n_'.$w] = i18n($w);
			}
		$content = parse_in('cms_shop_full_product', $data);
		$q = "UPDATE `content` SET `body` = ?, `generate` = 0 WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($content, $id));

		// generate dummy html file
		if ($data['published'] > 1) {
			$data['id'] = $id;
			$c = parse_in('cms_shop_dynamic', $data);
			$f = fopen("{$html['dir']}{$data['file']}", 'w');
			fwrite($f, $c);
			fclose($f);
			}
		}

	public function generate_group($data, $id) {
		global $db, $html, $website;
		// generate dummy html file
		if ($data['published'] > 1) {
			$data['id'] = $id;
			$c = parse_in('cms_shop_dynamic', $data);
			$f = fopen("{$html['dir']}{$data['file']}", 'w');
			fwrite($f, $c);
			fclose($f);
			}
		}

	public function generate_promo_box() {
			global $db, $con, $website;
			$this->isoc = $website['country']; // prebuilt component with inland tax
			$defs = read_settings(['group' => 'webshop']);
			$limit = array_key_exists('promobox_limit', $defs) ? $defs['promobox_limit'] : 3;
			foreach (array_keys($con['langs']) as $ln) {
				$content = '';
				$q = "SELECT `content`.`picture`, `content`.`file`, `products`.`product_no`, `content`.`title`, `products`.`new`, `products`.`price`, `products`.`special_price`, `products`.`tax` FROM `products`, `content` WHERE  `products`.`pid` = `content`.`id` AND `products`.`promotion` = 'on' AND `products`.`stock` > 3  AND `content`.`lang` = '$ln'  ORDER BY `products`.`id` DESC limit $limit;";
				$arg = $db->prepare ($q);
				$arg->execute();
				while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
						$data['src'] = $data['picture'] ? $data['picture'] : '';
						$data['currency'] = $this->defs['currency'];
						$data = $this->get_price($data);
						$data['picture'] = $this->make_img($data['picture'], $data['title'], 'cinemascope', '');
						if ($data['new']) {$data['new'] = htmltag('div', 'class="new_flag"', i18n('new'));}
						if ($data['special_price'] != 0) {$data['new'] = htmltag('div', 'class="new_flag"', "%");}
						$data['picture'] = parse_in('cms_shop_group_picture', $data);
						$content .= parse_in('cms_shop_big_promo_li', $data);
						}
				$content = htmltag('ul', 'id="shop-listing" class="yo-tiles"', $content);
				// update WEBSHOP_PROMOTION
				$component = ['component' => "WEBSHOP_PROMOTION", 'title' => "Webshop Promotion", 'html' => $content, 'lang' => $ln, 'active' => 'on'];
				write_component($component);
				}
			}

	public function make_img($file, $alt, $dir, $class) {
			$image = '';
			if (file_exists("../pictures/$dir/$file")) {
					list($x, $y) = getimagesize("../pictures/$dir/$file");
					$image = "<img src='/pictures/$dir/$file' width='$x' height='$y' alt='$alt' class='$class' />";
					}
			return $image;
			}

	public function get_manufacturer($data) {
			global $db;
			if ($data['provider']) {
					$arg = $db->prepare("SELECT * FROM `shop_manufacturer` WHERE `id` = ?;");
					$arg->execute(array($data['provider']));
					if ($arg->rowCount()) {
							$man = $arg->fetch(PDO::FETCH_ASSOC);
							if ($man['logo']) {
									$man['logo'] = $this->make_img($man['logo'], $man['name'], 'thumbs', '');
									}
							$man['label'] = i18n('provider');
							$data['provider'] = parse_in('cms_shop_provider', $man);
							}
					else {$data['provider'] = '';}
					}
			else {$data['provider'] = '';}
			return $data;
			}

	public function make_more_pictures($id) {
			global $db, $html;
			$content = "";
			$arg = $db->prepare("SELECT * FROM `media` WHERE `group` = 'ws' AND `foreign` = '$id' ORDER BY `sort`;");
			$arg->execute();
			while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
					list($w, $h) = getimagesize("{$html['dir']}/pictures/square/{$data['media']}");
					$content .= "<a href=\"/pictures/big/{$data['media']}\"  data-app=\"lightbox\"><img src=\"/pictures/square/{$data['media']}\" height=\"$h\" width=\"$w\" alt=\"{$data['title']}\" /></a>&nbsp;";
					}
			if ($content) {$content = "<p>$content</p>";}
			return ($content);
			}

	public function gen_all_products() {
		global $db;
		$q = "SELECT `content`.`id`, `content`.`title`, `content`.`lang`, `content`.`show_title`, `content`.`type`, `content`.`generate`, `content`.`description`, `products`.`product_no`, `products`.`product_no_ext`, `products`.`unit`, `content`.`picture`, `content`.`published`, `content`.`parent`, `content`.`sort`, `products`.`promotion`, `products`.`stock`, `products`.`price`, `products`.`special_price`, `products`.`tax`, `products`.`provider`, `products`.`specification`, `products`.`colour`, `products`.`size`, `products`.`weight`, `products`.`author`, `products`.`length`, `products`.`whatever`, `products`.`new`, `products`.`delivery`, `products`.`advices`, `products`.`max_order_quant`, `products`.`low_stock`, `products`.`supplies`, `content`.`file`, `content`.`written`, `content`.`update`, `content`.`c_start`, `content`.`c_end` FROM `content` LEFT JOIN `products` ON `content`.`id` = `products`.`pid`
		WHERE `content`.`type` = 'products';"; #"
		$arg = $db->prepare($q);
		$arg->execute();
		$rec = $arg->rowCount();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$this->generate_product($data, $data['id']);
			}
		}

	// get products data from product id, not content id
	private function get_product($id) {
		global $db;
		$data = false;
		$q = "SELECT `content`.`id`, `content`.`title`, `content`.`lang`, `content`.`show_title`, `content`.`type`, `content`.`generate`, `content`.`description`, `products`.`product_no`, `products`.`product_no_ext`, `products`.`unit`, `content`.`picture`, `content`.`published`, `content`.`parent`, `content`.`sort`, `products`.`promotion`, `products`.`stock`, `products`.`price`, `products`.`special_price`, `products`.`tax`, `products`.`provider`, `products`.`specification`, `products`.`colour`, `products`.`size`, `products`.`weight`, `products`.`author`, `products`.`length`, `products`.`whatever`, `products`.`new`, `products`.`delivery`, `products`.`advices`, `products`.`max_order_quant`, `products`.`low_stock`, `products`.`supplies`, `content`.`file`, `content`.`written`, `content`.`update`, `content`.`c_start`, `content`.`c_end` FROM `content` LEFT JOIN `products` ON `content`.`id` = `products`.`pid`
		WHERE `products`.`id` = ?;"; #"
		$arg = $db->prepare($q);
		$arg->execute([$id]);
		if ($arg->rowCount()) {$data = $arg->fetch(PDO::FETCH_ASSOC);}
		return $data;
		}

	public function trigger_sales() {
		global $db;
		$today = date('Y-m-d');
		$arg = $db->prepare("SELECT `articles`, `percent` FROM `shop_sales` WHERE `start` = ?;");
		$arg->execute([$today]);
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$sales = explode(',', $data['articles']);
			foreach ($sales as $art) {
				$this->set_special_price($art, $data['percent']);
				$prod = $this->get_product($art);
				error_log($prod['special_price'].' '.$prod['id'], 0);
				$this->generate_product($prod, $prod['id']);
				}
			}
		$arg = $db->prepare("SELECT `articles` FROM `shop_sales` WHERE `end` = ?;");
		$arg->execute([$today]);
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$sales = explode(',', $data['articles']);
			foreach ($sales as $art) {
				$this->reset_special_price($art);
				$prod = $this->get_product($art);
				$this->generate_product($prod, $prod['id']);
				}
			}
		}

	private function set_special_price($id, $perc) {
		global $db;
		$arg = $db->prepare("SELECT `price` FROM `products` WHERE `id` = ?;");
		$arg->execute([$id]);
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		$special_price = round($data['price']*((100-$perc)/100),2);
		//error_log($id." ".$data['price'].' '.$special_price, 0);
		$arg = $db->prepare("UPDATE `products` SET `special_price` = ? WHERE `id` = ?;");
		$arg->execute([$special_price, $id]);
		}

	private function reset_special_price($id) {
		global $db;
		$arg = $db->prepare("UPDATE `products` SET `special_price` = 0.00 WHERE `id` = ?;");
		$arg->execute([$id]);
		}
	}
?>
