<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-05-02 14:36:29
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-08-30T18:35:37+02:00
# @License: GPL 2.0



function plugin($html) {
	switch ($html['action']) {
		case ("user"): $html = user_admin($html); break;
		case ("user_restrictions"): $html = user_restrictions($html); break;
		case ("options"): $html = user_settings($html); break;
		case ("languages"): $html = language($html); break;
		case ("register"): $html = register($html); break;
		case ("rgroups"): $html = register_group($html); break;
		case ("snippets"): $html = snippets($html); break;
		case ("html_group"): $html = html_group($html); break;
		case ("php_info"): $html = PHP_info($html); break;
		default: $html = my_settings($html);
		}
	return $html;
	}

function my_settings ($html) {
	$html['content'] = get_board($html, "settings");
	$html['formtitle'] = i18n('settings');
	$html['left'] = bubble_text('common.settings');
	if ($html['left']) {$html['left'] = "<div class='short_help'>{$html['left']}</div>";}
	return $html;
	}

function user_admin($html) {
	global $db, $con;
	$levels = array_slice($con['levels'], 0, $html['user']['level']);
	foreach ($levels as $k=>$a) {$levels[$k] = i18n($a);}
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$form = [
		"title"			=> i18n('settings')." &ndash; ".i18n('user'),
		"table"			=> "user",
		"myconf"		=> "user",
		"human"			=> "name",
		"html"			=> $html,
		"rid"			=> $rid,
		"search"		=> ["name"],
		"filters"		=> ["level"],
		"table_fields"	=> ["name", "short", "email", "level"],
		"autocomplete"	=> "off",
		//'allow_box'		=> false,
		"clause"		=> "`level` <= {$html['user']['level']}"
		];

	$inputs = [
		"name"		=> [
			"type"		=> "text",
			"duty"		=> 1
			],
		"short"		=> [
			'size'	=> 4,
			'max_size'	=> 3,
			"type"		=> "text",
			],
		"email"		=> [
			"type"		=> "text",
			],
		"level"		=> [
			"caption"	=> i18n('ulevel'),
			"extra"		=> $levels,
			"type"		=> "array",
			"duty"		=> 1
			],
		"pwd"		=> [
			"type"		=> "pwd",
			"duty"		=> 1,
			"repeat"	=> 1,
			"pwdCheck"	=> true,
			"in_label"	=> htmltag('p', '', i18n('mess_pwd'))
			],
		"scheme"		=> [
			"caption"	=> i18n("skin"),
			"extra"		=> get_gui_schemes(),
			"type"		=> "array",
			"duty"		=> 1
			],
		"helpme"		=> [
			"type"		=> "flag",
			"default"	=> "on"
			],
		"language"		=> [
			"type"		=> "lookup",
			"lid"		=> "iso639",
			"lval"		=> "language",
			"lord"		=> "iso639",
			"ltable"	=> "languages",
			"lclause"	=> "where `used` = 'on'",
			"duty"		=> 1
			]
		];

	$submen = array(
		[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "user-circle-add"],
		[i18n('user'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", 'user-circle']
		);

	$obj = new access($form);

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {
			$obj->delete();
			// trigger
			foreach ($obj->rid as $did) {
				$arg = $db->prepare("DELETE FROM `user_restrictions` WHERE `uid` = ?;");
				$arg->execute(array($did));
				}
			}
		$html = $obj->table($inputs);
		//$html['content'] .= $obj->query;
		}

	$html['left'] = get_tab_tree($html, "settings", "user", user_tree(clean_var(param('level'), "n"), "user"));
	return $html;
	}

function user_settings($html) {
	$form = [
		"title"			=> i18n('settings')." &ndash; ".i18n('options'),
		"table"			=> "user",
		"myconf"		=> "user",
		"human"			=> "name",
		"autocomplete"	=> 'off',
		"no_cancel"		=> 1,
		"html"			=> $html,
		"rid"			=> $html['user']['id']
		];

	$inputs = [
		"name"		=> [
			"type"		=> "readonly"
			],
		"pwd"		=> [
			"type"		=> "pwd",
			"duty"		=> 1,
			"repeat"	=> 1,
			"pwdCheck"	=> true,
			"in_label"	=> htmltag('p', '', i18n('mess_pwd'))
			],
		'picture'	=> [
			"type"		=> "image",
			"extra"		=> 'upload'
			],
		"scheme"		=> [
			"caption"	=> i18n("skin"),
			"extra"		=> get_gui_schemes(),
			"type"		=> "array",
			],
		"helpme"		=> [
			"type"		=> "flag",
			"default"	=> "on"
			],
		"language"		=> [
			"default"		=> "",
			"type"		=> "lookup",
			"lid"		=> "iso639",
			"lval"		=> "language",
			"lord"		=> "iso639",
			"ltable"	=> "languages",
			"lclause"	=> "where `used` = 'on'",
			"duty"		=> 1
			]
		];

	$obj = new access($form);

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['user']['scheme'] = $inputs['scheme']['value'];
			$html['popup'] = $obj->feedback.$inputs['scheme']['caption'];
			}
		}
	else {$inputs = $obj->get_value($inputs);}

	if ($obj->error) {$html['content'] = $obj->feedback;}
	else {
		$obj->add_input($inputs);
		$html = $obj->form();
		}

	$html['left'] = get_tab_tree($html, "settings", "", "");
	return $html;
	}

function user_restrictions($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$form = [
		"title"			=> i18n('user_restrictions'),
		"table"			=> "user_restrictions",
		"myconf"		=> "user_restrictions",
		"orderby"		=> "uid",
		"defsort"		=> "ASC",
		"human"			=> "uid",
		"html"			=> $html,
		"rid"			=> $rid,
		"searchform"	=> false,
		"table_fields"	=> ['uid', 'group', 'allowed']
		];

	$inputs = [
	'uid'	=> [
		'caption'	=> i18n('user'),
		'type'	=> 'readonly_lookup',
		'ltable'	=> 'user',
		'lid'	=> 'id',
		'lval'	=> 'name',
		'lord'	=> 'name',
		'lclause'	=> '`level` = 1',
		'duty'	=> 1,
		],
	'group'	=> [
		'type'	=> 'array',
		'raw'	=> 1,
		'extra'	=> ['content'],
		'default' => 'content',
		'duty'	=> 1,
		],
	/*
	'new'	=> [
		'caption'	=> i18n('new_entry'),
		'type'	=> 'flag'
		],
	'delete'	=> [
		'type'	=> 'flag'
		],
	'sort'	=> [
		'type'	=> 'flag'
		], */
	'allowed'	=> [
			'type'	=> 'multicheck',
			"lid"		=> "id",
			"lval"		=> "short",
			"lord"		=> "short",
			"ltable"	=> "content",
			"lclause"	=> "`folder` = 0"
		],
	];


	$obj = new access($form);
	// $obj->set_attribute($inputs);


	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			if ($obj->rid == "new") {$inputs['uid']['type'] = 'lookup';}
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"]
			);
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		}
	$html['left'] = get_tab_tree($html, "settings", $form['myconf'], "");;
	return $html;
	}

function language($html) {
	global $con;
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$all_langs = array_keys($con['langs']);

	// english should be in array
	if (!in_array('en', $all_langs)) {array_push($all_langs, 'en');}

	$form = [
		"title"			=> i18n('settings')." &ndash; ".i18n('languages'),
		"table"			=> "i18n",
		"myconf"		=> "languages",
		"primary"		=> "lid",
		"orderby"		=> "index",
		"human"			=> "index",
		"html"			=> $html,
		"rid"			=> $rid,
		"search"		=> ["index", "de", "en"],
		"filters"		=> ["group"],
		"allow_box"		=> "both",
		"attr_to_set"	=> ["group"],
		"table_fields"	=> array_merge(["index", "group"], $all_langs),
		"track_q"		=> 1
		];

	$inputs = [
		"index"	=> [
			"type"		=> "text",
			"duty"		=> 1
			],
		"group"		=> [
			"type"		=> "suggest",
			"lid"		=> "group",
			"lval"		=> "group",
			"lord"		=> "group",
			"ltable"	=> "i18n",
			"default"	=> "common",
			"duty"		=> 1
			]
		];

	foreach($all_langs as $ln) {$inputs[$ln] = ["type" => "text", "caption" => strtoupper($ln), "duty" => 1];}

	$obj = new access($form);
	$obj->set_attribute($inputs);

	$submen = array(
		[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
		[i18n('languages'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", 'comment-o'],
		[i18n('dictionary'), $html['myurl']."?sid={$html['sid']}&amp;_id=dictionary", "inactive", 'book']
		);

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {
			$obj->rid = "new";
			$inputs = $obj->get_params($inputs); // get params coming fromdictionary
			$obj->error = false; // there is no error in this case
			}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		}

	$html['left'] = get_tab_tree($html, "settings", "languages", "");
	return $html;
	}

function html_tree($open,$action) {
	global $html;
	$tree = "<ul>";
	$item = [
		"caption"	=> i18n('all'),
		"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}",
		"state"		=> "all",
		"sub"		=> "",
		"bubble"	=> ""
		];
	$tree .= list_item($item);
	$roots = [
		"parent"	=> 1,
		"pfield"	=> "group",
		"field"		=> "name",
		"table"		=> "html_groups",
		"sort"		=> "group",
		"index"		=> 0,
		"open"		=> $open,
		"action"	=> $action
		];
	$tree .= branch($roots);
	$tree .= "</ul>\n";
	return $tree;
	}

function user_tree($open,$action) {
	global $html, $con;
	$tree = "<ul>";
	$users = $con['levels'];
	array_unshift($users, "all");
	foreach ($users as $k => $v) {
		$state = $open == $k ? "open" : "closed";
		$item = [
			"caption"	=> i18n($v),
			"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}&amp;level=$k",
			"state"		=> $state
			];
		$tree .= list_item($item);
		}
	$tree .= "</ul>\n";
	return $tree;
	}

function register_tree($open, $action) {
	$roots = [
		"parent"	=> 0,
		"field"		=> "name",
		"pfield"	=> "tab",
		"table"		=> "register_groups",
		"sort"		=> "sort",
		"open"		=> $open,
		"action"	=> $action
		];
	$tree = solo_tree($roots);
	$tree = parse_in('gui_tree', ['treelist' => $tree]);
	return $tree;
	}

function register($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$group = clean_var(param('tab'), "w");
	$form = [
		"title"			=> i18n('settings')." &ndash; ".i18n('menue'),
		"table"			=> "register",
		"myconf"		=> "register",
		"human"			=> "name",
		"orderby"		=> "sort",
		"html"			=> $html,
		"rid"			=> $rid,
		"allow_box"		=> "both",
		"attr_to_set"	=> ["tab", "level", "group", "start", "top"],
		"search"		=> ["name", "call"],
		"filters"		=> ["level", "tab"],
		"track_q"		=> 1,
		"table_fields"	=> ["icon", "name", "plugin", "start", "top", "group", "tab", "level", "sort"]
		];

	$inputs = [
		"name"			=> [
			"type"		=> "text",
			"duty"		=> 1
			],
		"misc"		=> [
			"type"		=> "fieldset"
			],
		"call"			=> [
			"caption"		=> "Action",
			"type"		=> "text",
			"duty"		=> 1
			],
		"plugin"			=> [
			"caption"		=> "Plugin",
			"type"		=> "text"
			],
		"params"			=> [
			"caption"		=> "Param",
			"type"		=> "text"
			],
		"gui"			=> [
			"caption"		=> "GUI",
			"type"		=> "array",
			"extra"		=> ['default', 'no_aside', 'dashboard', 'no_header', 'popup/iframe', 'ajax'],
			"default"	=> 1
			],
		"level"			=> [
			"caption"		=> i18n('ulevel'),
			"type"		=> "array",
			"extra"		=> [i18n('user'), i18n('admin'), i18n('maintainer')],
			"duty"		=> 1,
			"default"	=> 1
			],
		"sort"			=> [
			"type"		=> "sort",
			"default"	=> 10,
			"do"		=> true
			],
		"icon"			=> [
			"caption"	=> "Icon",
			"type"		=> "text",
			"default"	=> "default"
			],
		"image"			=> [
			"caption"	=> "Source",
			"type"		=> "array",
			'raw'		=> true,
			"extra"	=> ['0','1'],
			"view"	=> ['font', 'png']
			],
		"menue"		=> [
			"type"		=> "fieldset"
			],
		"tab"			=> [
			"caption"		=> i18n('group'),
			"type"		=> "lookup",
			"lid" => "id",
			"lval" => "name",
			"lord" => "sort",
			"ltable" => "register_groups"
			],
		"start"		=> [
			"type"		=> "flag"
			],
		"top"			=> [
			"caption"		=> i18n('menue'),
			"type"		=> "flag"
			],
		"group"		=> [
			"type"		=> "flag"
			],
		"frontend"	=> [
			"caption"		=>  i18n('frontend'),
			"type"		=> "flag"
			]
		];

	$obj = new access($form);

	$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
			[i18n($form['myconf']), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", 0],
			[i18n('groups'), $html['myurl']."?sid={$html['sid']}&amp;_id=rgroups", "inactive", 0]
			);

	$obj->set_attribute($inputs);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], 0, 0);
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif (param('_set_att')) {
		$html = $obj->attr_form($inputs);
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		}

	$html['left'] = get_tab_tree($html, "settings", "register", register_tree($group, $form['myconf']));
	return $html;
	}

function register_group ($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$form = [
		"title"			=> i18n('settings')." &ndash; ".i18n('menue')." &ndash; ".i18n('groups'),
		"table"			=> "register_groups",
		"myconf"		=> "rgroups",
		"human"			=> "name",
		"orderby"		=> "sort",
		"html"			=> $html,
		"rid"			=> $rid,
		"search"		=> array("name"),
		"table_fields"	=> array("name", "sort")
		];

	$inputs = [
		"name"	=> [
			"type"		=> "text",
			"duty"		=> 1
			],
		"sort"		=> [
			"type"		=> "sort",
			"do"		=> 1
			]
		];

	$obj = new access($form);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], '', '');
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
			[i18n('register'), $html['myurl']."?sid={$html['sid']}&amp;_id=register", "inactive", 0],
			[i18n('groups'), $html['myurl']."?sid={$html['sid']}&amp;_id=rgroups", "active", 0]
			);

		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		$html['content'] .= $obj->query;
		}

	$html['left'] = get_tab_tree($html, "settings", "register", "");
	return $html;
	}

function snippets($html) {
	global $con;
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$group = clean_var(param('group'), "n");
	$components_catalogue = '';
	$form = [
		"title"			=> i18n('settings')." &ndash; ".i18n('HTML-Snippets'),
		"table"			=> "html_snippets",
		"myconf"		=> "snippets",
		"human"			=> "key",
		"orderby"		=> "key",
		"html"			=> $html,
		"rid"			=> $rid,
		"maxsize"		=> 100,
		"search"		=> ["key", "description", "code"],
		"filters"		=> ["group"],
		"allow_box"		=> "both",
		"attr_to_set"	=> ["group"],
		"table_fields"	=> ["key", "description", "group"],
		"track_q"		=> 1,
		"button_after"	=> htmltag('button', "name=\"_clone\" value=\"1\" class=\"button red yo-right\" type=\"submit\"", get_icon('clone', '').' '.i18n('duplicate'))
		];

	$inputs = [
		"key"			=> [
			"type"		=> "text",
			"duty"		=> 1
			],
		"description"			=> [
			"type"		=> "bigtext",
			"rows"		=> 3,
			"cols"		=> 50
			],
		"code"			=> [
			"caption"	=> "Code Snippet",
			"type"		=> "bigtext",
			"syntax"	=> "text/html",
			"duty"		=> 1,
			"rows"		=> 30,
			"cols"		=> 100
			],
		"group"			=> [
			"type"		=> "lookup",
			"lval" => "graduated",
			"tval" => "name",
			"lord" => "parentsort",
			"ltable" => "html_groups",
			"duty"		=> 1,
			"default"	=> $group
			]
		];

	$obj = new access($form);

	$obj->set_attribute($inputs);

	if (param('_clone')) {
		$inputs = $obj->get_value($inputs);
		$rid = 0;
		$inputs['key']['duty'] = 2;
		$obj->button_after = '';
		$obj->before_form = i18n('copy');
		$todo = 'edit';
		}

	if ($todo == "gen") {
		generate();
		$html['popup'] = i18n('ok');
		$obj->html_in($html);
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			$components_catalogue = get_catalogue();
			$components_catalogue .= parse_in('codemirror_fill', [0]);
			}
		}
	elseif (param('_set_att')) {
		$html = $obj->attr_form($inputs);
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;group=$group", "inactive", "add"],
			[i18n('group'), $html['myurl']."?sid={$html['sid']}&amp;_id=html_group&amp;group=$group", "inactive", 0],
			[i18n("HTML-Snippets"), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;group=$group", "active", 0]
			);
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		//$html['content'] .= $obj->query;
		}

	$html['left'] = get_tab_tree($html, "settings", $form['myconf'], html_tree(clean_var(param('group'), 'n'), $form['myconf']));
	if ($con['profile'] == 'cms') {
		$html['left'] .= "<h3>".i18n('action')."</h3><p class='center'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;group=$group&amp;todo=gen'>".i18n('regenerate')."</a>";
		$html['left'] .= $components_catalogue;
		}
	return $html;
	}

function html_group ($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$group = clean_var(param('group'), "n");
	$do = $group ? true : false;
	$form = [
		"title"			=> i18n('settings')." &ndash; "."HTML Groups",
		"table"			=> "html_groups",
		"myconf"		=> "html_group",
		"human"			=> "name",
		"orderby"		=> "sort",
		"filters"		=> ["group"],
		"html"			=> $html,
		"rid"			=> $rid,
		"no_edit"		=> range(1,3),
		"no_del"		=> range(1,3),
		"search"		=> array("name", "description"),
		"table_fields"	=> array("sort", "name", "group", "description")
		];

	$inputs = [
		"name"	=> [
			"type"		=> "text",
			"duty"		=> 1
			],
		"description"	=> [
			"type"		=> "bigtext",
			"duty"		=> 1
			],
		"group"		=> [
			"type"		=> "lookup",
			"lval" => "graduated",
			"tval" => "name",
			"lord" => "parentsort",
			"ltable" => "html_groups",
			"duty"		=> 1,
			"default"	=> $group
			],
		"sort"		=> [
			"type"		=> "sort",
			"do"		=> $do
			]
		];

	$obj = new access($form);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], "group", $group);
		reconf_parent("html_groups", "name", "group");
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			reconf_parent("html_groups", "name", "group");
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$notin = intval($rid) ? check_dependencies("html_groups", $rid, "group") : "";
			$inputs['group']['lclause'] = $notin;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;group=$group", "inactive", "add"],
			[i18n('group'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;group=$group", "active", 0],
			[i18n('snippets'), $html['myurl']."?sid={$html['sid']}&amp;_id=snippets&amp;group=$group", "inactive", 0],
			);
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		$html['content'] .= $obj->query;
		}

	$html['left'] = get_tab_tree($html, "settings", "snippets", html_tree($group, $form['myconf']));
	return $html;
	}

function get_gui_schemes() {
	global $html, $con;
	$schemes = array();
	$files = scandir($html['dir']."/css/gui/");
	$css_prefix = array_key_exists('css_prefix', $con) ? $con['css_prefix'] : "style";
	$i = 1;
	foreach ($files as $file) {
		if (preg_match("/^$css_prefix\d{1}\.css$/", $file)) {
			array_push($schemes, i18n("scheme$i"));
			$i++;
			}
		}
	return $schemes;
	}

function get_catalogue() {
	global $db;
	$arg = $db->prepare("SELECT `name`, `lang`, `title`, `description` FROM `components` ORDER BY `name`;");
	$arg->execute();
	$list = '';
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		$name = htmltag('strong', '', $data['name'])." ({$data['lang']})";
		$name .= $data['title'] ? ":<br />".$data['title'] : '';
		$list .= htmltag('li', 'class="arr" data-val="'.$data['name'].'"', $name);
		}
	if ($list) {
		$list = htmltag('ul', 'id="components_catalogue"', $list);
		$list = htmltag('div', 'class="block_item row h2"', $list);
		$list = "<h3>".i18n('components')."</h3>\n".$list;
		}
	return $list;
	}

function PHP_info ($html) {
	phpinfo();
	$html['gui'] = 6;
	return $html;
	}
?>
