<?php
# plugin serial page
# @Author: Rainer Imb <artbeeren>
# @Date:   2018-06-23 15:01:25
# @Project: consentio mccurdy
# @Last modified by:   artbeeren
# @Last modified time: 2018-08-02 14:58:22
# @License: GPL 2.0

class serial_page {
	private $rid;
	private $page;
	private $lang;
	private $folder = 1;
	private $breadcrumb;
	private $cript;
	private $gal_prev_dim = 'small';
	private $gal_cols = 4;
	private $extra = ['pages', 'galleries', 'documents', 'youtube', 'button'];
	private $view = ['text', 'gallery', 'documents', 'youtube', 'button'];
	private $icons = ['file-alt', 'file-image', 'file-pdf', 'fab-youtube', 'hand-point-right'];

	public function __construct(){
		$this->view = array_map('i18n', $this->view);
		}

	public function plugin($html) {
		if ($html['action'] == "serial_page") {
			if (param('rid') == "new" || param('_set') == 1) {$html = $this->serial_page_admin($html);}
			else {
				$this->page = param('rid');
				$html = $this->list_content($html);}
			}
		elseif ($html['action'] == "block_content") {
			$this->rid = param('rid');
			$this->page = clean_var(param('parent'), "n");
			$html = $this->list_content($html);
			}
		elseif ($html['action'] == "documents") {
			$html = $this->docs_admin($html);
			}
		elseif ($html['action'] == "youtube") {
			$html = $this->clips_admin($html);
			}
		elseif ($html['action'] == "block_gal") {
			$html = $this->block_gal_admin($html);
			}
		elseif ($html['action'] == "block_gal_images") {$html = $this->block_gal_images_admin($html);}
		return $html;
		}

	private function serial_page_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$parent = clean_var(param('parent'), "n");
		list($mylang, $myparent, $ptype) = parents_def($parent);
		$form = form_by_type(1);
		$form['rid'] = $rid;
		$form['myconf'] = "serial_page";
		$form['title'] .= " &ndash; ".i18n("serial_page");
		$inputs = inputs_by_type('plugin');

		$inputs['type'] =	['type' => 'hidden', 'default' => 'serial_page'];
		$inputs['folder'] =	['type' => 'hidden', 'value' => 0];
		$inputs['parent']['default'] = $parent;
		$inputs['_set']	= ['type' => 'free', 'default' => 1];

		$inputs = array_merge(array_slice($inputs, 0, 8), ['show_title' =>	['type' => 'flag', 'default' => 'on']], array_slice($inputs, 8));
		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				if ($obj->rid == "new") {
					$inputs['file']['value'] = "/".clean_filename($inputs['title']['value'].".html", $html['dir']);
					// try to keep sort-order if the user doesn't
					if ($inputs['sort']['value'] == 10) {
						raise_order($inputs['parent']['value'], 'pages');
						reconf_parent("content", "short", "parent");
						}
					}
				$inputs['update']['value'] = date('Y-m-d H:i:s');
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				$this->generate_page($id);
				generate();
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {
				$inputs = $obj->get_value($inputs);
				$parent = $inputs['parent']['value'];
				}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$inputs['parent']['lclause'] .= " AND `lang` = '$mylang'";
				$inputs['lang']['default'] = $mylang;
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			if (param('_del')) {
				$records = $obj->get_multiple_values($inputs); // before we delete we need some values
				foreach ($records as $row) {
					if ($row['type'] != 'node') {unlink("{$html['dir']}{$row['file']}");}
					}
				$obj->delete();
				generate();
				}
			$obj->myconf = 'pages'; // return to pages...
			$obj->title = i18n("pages");
			$inputs = inputs_by_type('view');
			$submen = pages_tabs($parent);
			$obj->before_table = make_submenu($submen);
			$html = $obj->table($inputs);
			$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"[data-app='preview']\").popLink({header: '".i18n('preview')."', 'top': '5%', 'left': '1%', 'width': '1024', 'height': '600'});});</script>\n";
			}
		$this->folder = $parent;
		$html['left'] = content_tree($this->folder, "pages");
		return $html;
		}

	private function list_content ($html) {
		global $con;
		$levels = array_slice($con['levels'], 0, $html['user']['level']);
		$rid = $this->rid;
		//coming from myself? different parent-detections
		$parent = $this->page ? $this->page : param('parent');
		if (!$parent) {$parent = $this->get_parent();} // if we should forget
		$todo = $html['action'] == "block_content" ? clean_var(param('todo'), "w") : '';
		if ($todo == 'delete') {$filters = ['parent']; $clause = '';}
		if ($html['action'] == "block_content") {$filters = ['parent']; $clause = '';}
		else {$filters = array(); $clause = "`parent` = '$parent'";}
		$this->get_title($parent);

		$not = array();
		if ($html['user']['level'] <= 2) {$not = $this->get_nos($parent, $html['user']['level']);}


		$form = [
			"title"			=> i18n('pages'). " &ndash; ".i18n("serial_page"),
			"table"			=> "block_content",
			"myconf"		=> "block_content",
			"orderby"		=> "sort",
			"defsort"		=> "ASC",
			"human"			=> "title",
			"html"			=> $html,
			"filters"		=> $filters,
			"rid"			=> $rid,
			"search"		=> [],
			"searchform"	=> 0,
			"allow_box"		=> false,
			"no_edit"		=> $not,
			"no_del"		=> $not,
			"in_sortform"	=> "<input type='hidden' name='parent' value='$parent' />",
			"table_fields"	=> ['type', 'active', 'sort', 'title', 'content'],
			"clause"		=> $clause
			];

		$inputs = [
		'title'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'content'	=> [
			'caption'	=> i18n('text'),
			'type'	=> 'wysiwyg',
			'duty'	=> 1,
			],
		'type'	=> [
			'type'		=> 'array',
			'raw'		=> 1,
			'readonly'	=> true,
			'extra'		=> $this->extra,
			'view'		=> $this->view,
			'fontawesome'		=> $this->icons
			],
		'template'	=> [
			'type'	=> 'array',
			'raw'	=> 1,
			'extra'	=> ['cms_serial_page_block1', 'cms_serial_page_block2', 'cms_serial_page_block3', 'cms_serial_page_block4'],
			'view'	=> ['Hintergrund weiß mit Überschrift', 'Hintergrund grau mit Überschrift', 'Hintergrund weiß', 'Hintergrund grau'],
			'default' => 'cms_serial_page_block1',
			'duty' => 1
			],
		'sort'	=> [
			'type'	=> 'sort',
			'do'	=> 1,
			'type'	=> 'sort',
			'default'	=> 10,
			'duty'	=> 1,
			],
		'active'	=> [
			'type'	=> 'flag',
			'extra'	=> 'noscript'
			],
		'parent'	=> [
			'type'	=> 'hidden',
			'default'	=> $parent
			]
		];

		if ($html['user']['level'] < 2) {
			$inputs['template']['type'] = 'hidden';
			}
		else {
			$inputs['allow'] = [
				"type"		=> "array",
				"caption"	=> i18n('ulevel'),
				"extra"		=> $levels,
				"default"	=> 1
				];
			}

		$obj = new access($form);

		if (param('_sortlist')) {
			$obj->sort_list();
			reorder($form['table'], 'parent', $parent);
			$this->generate_page($parent);
			generate();
			}

		if (param('_store')) {
			$inputs['type']['value'] = clean_var(param('type'), 'w');
			$inputs = $this->alter_inputs($inputs);
			$inputs = $obj->get_params($inputs);
			// back to list!!
			$inputs['content']['type'] = 'wysiwyg';
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$this->generate_page($parent);
				generate();
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {
				$inputs = $obj->get_value($inputs);
				$inputs = $this->alter_inputs($inputs);
				$this->get_title($inputs['parent']['value']);
				}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				if ($obj->rid == "new" && !param('type')) {
					$html = $this->pre_block($html);
					$html['content'] = $this->breadcrumb."\n".$html['content'];
					}

				else {
					if ($obj->rid == "new") {
						$inputs['type']['value'] = clean_var(param('type'), 'w');
						$inputs = $this->alter_inputs($inputs);
						}
					else {
						if ($inputs['type']['value'] == 'galleries') {
							$submen = array(
							[i18n('groups'), $html['myurl']."?sid={$html['sid']}&amp;_id=block_gal&amp;gallery=$rid", "inactive", "images"],
							[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=block_content&amp;todo=edit&amp;rid=$rid&amp;_set=1", "active", "wrench"],
							);
							$this->breadcrumb .= "\n".make_submenu($submen);
							}
						}
					$inputs['type']['type'] = 'hidden';
					$inputs['type']['default'] = clean_var(param('type'), 'w');
					$obj->add_input($inputs);
					$obj->before_form = $this->breadcrumb;
					$html = $obj->form();
					}
				}
			}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;parent=$parent", "inactive", "add"],
				[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=serial_page&amp;todo=edit&amp;rid=$parent&amp;_set=1", "inactive", "wrench"]
				);
			$obj->before_table = $this->breadcrumb."\n".make_submenu($submen);
			if (param('_del')) {
				$obj->delete();
				$this->generate_page($parent);
				generate();
				}
			$obj->allow_edit = 'ser_page_edit_by_type';
			$html = $obj->table($inputs);
			}
		$html['left'] = content_tree($this->folder, "pages");
		return $html;
		}

	private function block_gal_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$gallery = clean_var(param('gallery'), "n");
		$this->get_page($gallery, "block_gal", 'gallery');

		$form = [
			"title"			=> i18n('pages'). " &ndash; ".i18n("serial_page"). " &ndash; ".i18n("gallery"),
			"table"			=> "block_galleries",
			"myconf"		=> "block_gal",
			"orderby"		=> "sort",
			"defsort"		=> "ASC",
			"human"			=> "title",
			"filters"		=> ['gallery'],
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> [],
			"searchform"	=> 0,
			"table_fields"	=> ['title', 'active', 'sort']
			];

		$inputs = [
		'title'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'gallery'	=> [
			'type'	=> 'hidden',
			'default'	=> $gallery,
			'duty'	=> 1,
			],
		'active'	=> [
			'type'	=> 'flag',
			'extra'	=> 'noscript'
			],
		'sort'	=> [
			'type'	=> 'sort',
			'do'	=> 1,
			'type'	=> 'sort',
			'default'	=> 10,
			'duty'	=> 1,
			],
		'portfolio'	=> [
			'type'	=> 'hidden',
			'default' => 1
			]
		];

		if (!$rid || $rid == "new") {
			$form['button_text'] = i18n('next');
			}
		else {
			$inputs['images'] = [
			'type' => 'subform',
			'conf' => 'block_gal_images',
			'foreign' => 'gal_group',
			'height' => 650
			];
			}


		$obj = new access($form);
		// $obj->set_attribute($inputs);

		if (param('_sortlist')) {
			$obj->sort_list();
			reorder($form['table'], 'gallery', $gallery);
			$this->generate_page($this->page);
			generate();
			}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				if ($obj->rid == "new") {
					$inputs['portfolio']['value'] = $this->set_portfolio($id, $inputs['title']['value']);
					$todo = "edit";	$rid = $id; $obj->rid = $id;
					$obj->button_text = i18n('ok');
					$inputs['images'] = [
						'type' => 'subform',
						'conf' => 'block_gal_images',
						'foreign' => 'gal_group',
						'height' => 650
						];
					}
				else {$this->update_portfolio($inputs['portfolio']['value'], $inputs['title']['value']);}
				$this->generate_page($this->page);
				generate();
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$obj->before_form = $this->breadcrumb;
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;gallery=$gallery", "inactive", "add"],
				[i18n('groups'), $html['myurl']."?sid={$html['sid']}&amp;_id=block_gal&amp;gallery=$gallery", "active", "images"],
				[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=block_content&amp;todo=edit&amp;rid=$gallery", "inactive", "wrench"]
				);
			$obj->before_table = $this->breadcrumb."\n".make_submenu($submen);
			if (param('_del')) {
				$records = $obj->get_multiple_values($inputs); // before we delete we need some values
				foreach ($records as $row) {$this->delete_portfolio($row['portfolio']);}
				$obj->delete();
				}
			$html = $obj->table($inputs);
			}
		$html['left'] = content_tree($this->folder, "pages");
		return $html;
		}

	private function block_gal_images_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$group = clean_var(param('gal_group'), "w");
		$prtf = $this->get_portfolio($group);

		$form = [
			"title"			=> i18n('pictures'),
			"table"			=> "block_gal_images",
			"myconf"		=> "block_gal_images",
			"filters"		=> ['gal_group'],
			"orderby"		=> "sort",
			"defsort"		=> "ASC",
			"human"			=> "picture",
			"q_limit"		=> 100,
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> [],
			"searchform"	=> 0,
			"table_fields"	=> ['picture', 'caption', 'sort']
			];

		$inputs = [
		'picture'	=> [
			'type'	=> 'image',
			'prev_dir'	=> 'thumbs',
			'portfolio' => $prtf
			],
		'caption'	=> [
			'type'	=> 'text',
			'caption' => i18n('title')
			],
		/*
		'copyright'	=> [
			'type'	=> 'text',
			],
		*/
		'gal_group'	=> [
			'type'	=> 'hidden',
			'default'	=> $group
			],
		'sort'	=> [
			'type'	=> 'sort',
			'do'	=> 1,
			'type'	=> 'sort',
			'default'	=> 10,
			]
		];


		$obj = new access($form);
		// $obj->set_attribute($inputs);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], 'gal_group', $group);
		}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				reconf_parent("image_folder", "name", "parent");
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				if (param('mode') == "multi") {
					$inputs['picture']['extra'] = 'upload';
					$inputs['sort']['type'] = 'hidden';
					$inputs['caption']['type'] = 'hidden';
					}
				$obj->add_input($inputs);
				$html = $obj->form();
				if (param('mode') == "multi") {$html['scripts'] .= uploadscript('ifilepicture');}
				}
			}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;gal_group=$group&amp;portfolio=$prtf", "inactive", "picture-add"],
				[i18n('img_multi'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;mode=multi&amp;gal_group=$group&amp;portfolio=$prtf", "inactive", "add"],
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {
				$records = $obj->get_multiple_values($inputs);
				foreach ($records as $row) {$this->delete_img($prtf, $row['picture']);}
				$obj->delete();
				}
			$html = $obj->table($inputs);
			}
		if (param('_store') == "silent") {
			$html['gui'] = 6;
			$html['content'] = $html['popup'] ? $html['popup'] : $html['feedback'];
			}
		return $html;
		}

	private function docs_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$doc = clean_var(param('doc'), "n");
		$this->get_page($doc, "documents", 'doc');

		$form = [
			"title"			=> i18n('pages'). " &ndash; ".i18n("serial_page"). " &ndash; ".i18n("documents"),
			"table"			=> "block_docs",
			"myconf"		=> "documents",
			"orderby"		=> "sort",
			"defsort"		=> "ASC",
			"human"			=> "title",
			"filters"		=> ['doc'],
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> [],
			"searchform"	=> 0,
			"table_fields"	=> ['title', 'filedoc', 'active', 'sort']
			];

		$inputs = [
		'title'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'filedoc'	=> [
			'caption'	=> i18n('file'),
			'type'	=> 'file',
			'dir'	=> 'documents',
			'accept'	=> ".doc, .docx, .xls, .xlsx, .ppt, .pptx, .pdf",
			'duty'	=> 1
			],
		'doc'	=> [
			'type'	=> 'hidden',
			'default'	=> $doc,
			'duty'	=> 1,
			],
		'active'	=> [
			'type'	=> 'flag',
			'extra'	=> 'noscript'
			],
		'sort'	=> [
			'type'	=> 'sort',
			'do'	=> 1,
			'type'	=> 'sort',
			'default'	=> 10,
			'duty'	=> 1,
			]
		];

		$obj = new access($form);
		// $obj->set_attribute($inputs);

		if (param('_sortlist')) {
			$obj->sort_list();
			reorder($form['table'], 'doc', $doc);
			$this->generate_page($this->page);
			generate();
			}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$this->generate_page($this->page);
				generate();
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$obj->before_form = $this->breadcrumb;
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;doc=$doc", "inactive", "add"],
				[i18n('documents'), $html['myurl']."?sid={$html['sid']}&amp;_id=documents&amp;doc=$doc", "active", "report"],
				[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=block_content&amp;todo=edit&amp;rid=$doc", "inactive", "wrench"]
				);
			$obj->before_table = $this->breadcrumb."\n".make_submenu($submen);
			if (param('_del')) {
				$obj->delete();
				$this->generate_page($this->page);
				generate();
				}
			$html = $obj->table($inputs);
			}
		$html['left'] = content_tree($this->folder, "pages");
		return $html;
		}

	private function clips_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$clip = clean_var(param('clip'), "n");
		$this->get_page($clip, "youtube", 'clip');

		$form = [
			"title"			=> i18n('pages'). " &ndash; ".i18n("serial_page"). " &ndash; ".i18n("youtube"),
			"table"			=> "block_clips",
			"myconf"		=> "youtube",
			"orderby"		=> "sort",
			"defsort"		=> "ASC",
			"human"			=> "title",
			"filters"		=> ['clip'],
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> [],
			"searchform"	=> 0,
			"table_fields"	=> ['title', 'link', 'active', 'sort']
			];

		$inputs = [
		'title'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'link'	=> [
			'caption'	=> 'Youtube Link',
			'type'	=> 'text',
			'duty'	=> 1,
			'placeholder' => 'https://youtu.be/aBcDefG'
			],
		'clip'	=> [
			'type'	=> 'hidden',
			'default'	=> $clip,
			'duty'	=> 1,
			],
		'active'	=> [
			'type'	=> 'flag',
			'extra'	=> 'noscript'
			],
		'sort'	=> [
			'type'	=> 'sort',
			'do'	=> 1,
			'type'	=> 'sort',
			'default'	=> 10,
			'duty'	=> 1,
			]
		];

		$obj = new access($form);
		// $obj->set_attribute($inputs);

		if (param('_sortlist')) {
			$obj->sort_list();
			reorder($form['table'], 'clip', $clip);
			$this->generate_page($this->page);
			generate();
			}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$this->generate_page($this->page);
				generate();
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$obj->before_form = $this->breadcrumb;
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;clip=$clip", "inactive", "add"],
				[i18n('youtube'), $html['myurl']."?sid={$html['sid']}&amp;_id=youtube&amp;clip=$clip", "active", "film"],
				[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=block_content&amp;todo=edit&amp;rid=$clip", "inactive", "wrench"]
				);
			$obj->before_table = $this->breadcrumb."\n".make_submenu($submen);
			if (param('_del')) {
				$obj->delete();
				$this->generate_page($this->page);
				generate();
				}
			$html = $obj->table($inputs);
			}
		$html['left'] = content_tree($this->folder, "pages");
		return $html;
		}

	private function get_title ($id) {
		global $db, $html;
		$q = "SELECT `id`, `title`, `parent`, `lang` FROM `content` WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		$this->lang = $data['lang'];
		$this->folder = $data['parent'];
		$this->breadcrumb = '&rarr; '.htmltag('a', "href='{$html['myurl']}?sid={$html['sid']}&amp;_id=serial_page&amp;todo=edit&amp;rid={$data['id']}'", $data['title']);
		}

	private function get_parent() {
		global $db;
		$q = "SELECT `parent` FROM `block_content` WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($this->rid));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		return $data['parent'];
		}

	private function get_page ($id, $me, $ident) {
		global $db, $html;
		$q = "SELECT `id`, `title`, `parent` FROM `block_content` WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		$this->get_title($data['parent']);
		$this->page = $data['parent'];
		$this->breadcrumb .= ' &rarr; '.htmltag('a', "href='{$html['myurl']}?sid={$html['sid']}&amp;_id=$me&amp;$ident={$data['id']}'", $data['title']);
		}

	private function get_nos($p, $l) {
		global $db, $html;
		$q = "SELECT `id` FROM `block_content` WHERE `parent` = ? AND `allow` > ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($p, $l));
		return $arg->fetchAll(PDO::FETCH_COLUMN, 0);
		}

	private function get_portfolio ($id) {
		global $db, $html;
		$q = "SELECT `portfolio` FROM `block_galleries` WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		return $data['portfolio'];
		}

	private function pre_block ($html) {
		$parent = $this->page;
		$html['content'] = "<div class='menueset clrfx'>\n<h2>".i18n('new_entry')."</h2>\n<ul class='menue'>\n";
		foreach ($this->extra as $k=>$v) {
			$img = get_big_icon($this->icons[$k], "");
			$html['content'] .= "<li><a href='{$html['myurl']}?_id=block_content&amp;sid={$html['sid']}&amp;todo=edit&amp;parent=$parent&amp;type=$v&amp;rid=new'>$img<br />{$this->view[$k]}</a></li>";
			}
		$html['content'] .= "\n</ul>\n</div>";
		return $html;
		}

	private function alter_inputs($inputs) {
		$type = $inputs['type']['value'];
		switch ($type) {
			case 'galleries':
				$inputs['content']['type'] = 'void';
				$inputs['content']['duty'] = 0;
				break;
			case 'youtube':
				$inputs['content']['type'] = 'void';
				$inputs['content']['duty'] = 0;
				break;
			case 'documents':
				$inputs['content']['type'] = 'void';
				$inputs['content']['duty'] = 0;
				break;
			case 'button':
				$inputs['title']['type'] = 'readonly';
				$inputs['title']['default'] = 'Unsere Veranstaltungen';
				$inputs['template']['type']	= 'array';
				$inputs['template']['raw'] = 1;
				$inputs['template']['extra'] = ['cms_serial_page_block3', 'cms_serial_page_block4'];
				$inputs['template']['view']	= ['Hintergrund weiß', 'Hintergrund grau'];
				$inputs['template']['default'] = 'cms_serial_page_block1';
				$inputs['template']['duty'] = 1;
				$inputs['content']['type'] = 'lookup';
				$inputs['content']["lid"] = "id";
				$inputs['content']["lval"] = "name";
				$inputs['content']["lord"] = "name";
				$inputs['content']["ltable"] = "fspv_cat";
				$inputs['content']['duty']	= 1;
				break;
			default: break;
			}
		return $inputs;
		}

	private function set_portfolio($gid, $title) {
		global $db;
		$parport = 1;
		$set = read_settings(['group' => 'block_gal']);
		if (array_key_exists('bgl_portfolio', $set)) {$parport = $set['bgl_portfolio'];}
		$q = "INSERT INTO `image_folder` SET `name` = '$title', `parent` = '$parport';";
		$arg = $db->prepare($q);
		$arg->execute();
		$pid = $db->lastInsertId();
		$q = "UPDATE `block_galleries` SET `portfolio` = ? WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($pid, $gid));
		return $pid;
		}

	private function update_portfolio($pid, $title) {
		global $db;
		if ($pid != 1) {
			$q = "UPDATE `image_folder` SET `name` = '$title' WHERE `id` = ?;";
			$arg = $db->prepare($q);
			$arg->execute(array($pid));
			}
		}

	private function delete_portfolio($pid) {
		global $db;
		if ($pid != 1) {
			// portfolio
			$q = "DELETE FROM `image_folder` WHERE `id` = ?;";
			$arg = $db->prepare($q);
			$arg->execute(array($pid));
			// images
			$q = "DELETE FROM `image_db` WHERE `parent` = ?;";
			$arg = $db->prepare($q);
			$arg->execute(array($pid));
			}
		}

	private function delete_img($pid, $name) {
		global $db;
		if ($pid != 1) {
			$q = "DELETE FROM `image_db` WHERE `parent` = ? AND `filename` = ?;";
			$arg = $db->prepare($q);
			$arg->execute(array($pid, $name));
			}
		}
	private function generate_page ($id) {
		global $db, $html;
		$q = "SELECT * FROM `block_content` WHERE `parent` = ? AND `active` = 'on' ORDER BY `sort`;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		$blocks = $arg->rowCount();
		$content = ''; $i = 1;
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($data['type'] == "galleries") {
				$data['content'] = $this->generate_galleries($data['id']);
				$this->cript = parse_in('cms_serial_galleries_script', []);
				}
			elseif ($data['type'] == "documents") {
				$data['content'] = $this->generate_docs($data['id']);
				}
			elseif ($data['type'] == "youtube") {
				$data['content'] = $this->generate_clip($data['id']);
				}
			elseif ($data['type'] == "button") {
				$data['content'] = $this->generate_button($data);
				}

			$data['blockclass'] = '';
			if ($i == 1) {$data['blockclass'] = 'firstblock';}
			elseif ($i == $blocks) {$data['blockclass'] = 'lastblock';}
			$content .= parse_in($data['template'], $data);
			$i++;
			}
		$q = "UPDATE `content` SET `body` = ?, `head` = ?, `update` = ?, `last_editor` = ? WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($content, $this->cript, date('Y-m-d H:i:s'), $html['user']['id'], $id));
		}

	private function generate_galleries ($id) {
		global $db, $html;
		$q = "SELECT * FROM `block_galleries` WHERE `gallery` = ? AND `active` = 'on' ORDER BY `sort`;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		$content = '';
		$i = 1; $ii = 1;
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$data['list'] = '';
			$data['ggroup'] = "ggroup_$i";
			$q2 = "SELECT * FROM `block_gal_images` WHERE `gal_group` = ? ORDER BY `sort`;";
			$arg2 = $db->prepare($q2);
			$arg2->execute(array($data['id']));
			while ($data2 = $arg2->fetch(PDO::FETCH_ASSOC)) {
				$data2['ggroup'] = $data['ggroup'];
				list($data2['width'], $data2['height']) = getimagesize("{$html['dir']}/pictures/$this->gal_prev_dim/{$data2['picture']}");
				$t = $data['list'] ? 'cms_serial_gal_img' : 'cms_serial_gal_first_img';
				$data['list'] .= parse_in($t, $data2);
				}
			$data['colclass'] = '';
			if ($ii == 1) {$data['colclass'] = 'first';}
			if ($ii == $this->gal_cols) {$data['colclass'] = 'last'; $ii = 0;}
			$lang = $this->lang;
			$data3 = ['p' => sys_trans('previous', $lang), 'n' => sys_trans('next', $lang), 'c' => sys_trans('close', $lang), 'i' => sys_trans('picture', $lang)];
			$data = array_merge($data, $data3);
			$content .= parse_in('cms_serial_galleries', $data);
			$i++; $ii++;
			}
		return $content;
		}

	private function generate_docs ($id) {
		global $db, $html;
		$q = "SELECT * FROM `block_docs` WHERE `doc` = ? AND `active` = 'on' ORDER BY `sort`;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		$content = '';
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$fa = 'file';
			$f = pathinfo("{$html['dir']}/{$data['filedoc']}");
			switch (strtolower($f['extension'])) {
				case "doc":
				case "docx": $fa = 'file-word'; break;
				case "xls":
				case "xlsx": $fa = 'file-excel'; break;
				case "ppt":
				case "pptx": $fa = 'file-powerpoint'; break;
				case "pdf": $fa = 'file-pdf'; break;
				default: $fa = 'file';
				}
			$data['item'] = "<i class='fas fa-$fa fa-5x'></i>";
			$content .= parse_in('cms_serial_documents', $data);
			}
		return $content;
		}

	private function generate_clip ($id) {
		global $db, $html;
		$q = "SELECT * FROM `block_clips` WHERE `clip` = ? AND `active` = 'on' ORDER BY `sort`;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		$content = '';
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$f = explode('/', $data['link']);
			$data['code'] = end($f);
			$content .= parse_in('cms_serial_clips', $data);
			}
		return $content;
		}

	private function generate_button ($data) {
		$content = "<a href=\"/content/Programm.html?_t={$data['content']}\" class=\"as_button\">Unsere Veranstaltungen</a>";
		return $content;
		}
	}

function ser_page_edit_by_type ($url, $rec) {
	switch ($rec['type']) {
		case 'galleries':
			$url = str_replace('_id=block_content', "_id=block_gal", $url);
			$url = str_replace('rid=', "gallery=", $url);
			$url = str_replace('&amp;todo=edit', "", $url); break;
		case 'documents':
			$url = str_replace('_id=block_content', "_id=documents", $url);
			$url = str_replace('rid=', "doc=", $url);
			$url = str_replace('&amp;todo=edit', "", $url); break;
		case 'youtube':
			$url = str_replace('_id=block_content', "_id=youtube", $url);
			$url = str_replace('rid=', "clip=", $url);
			$url = str_replace('&amp;todo=edit', "", $url); break;
		case 'something':
			$url = str_replace('_id=block_content', "_id=someconf", $url);
			$url = str_replace('rid=', "somefilter=", $url);
			$url = str_replace('&amp;todo=edit', "", $url); break;
		default: break;
		}
	return $url;
	}
?>
