<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-05-28 18:44:30
# @Project: consentio mccurdy
# @Last modified by:   artbeeren
# @Last modified time: 2018-07-22 14:56:21
# @License: GPL 2.0


class scheduler {

	private $easter = false;
	private $types = false;
	private $entry_in_month = <<<EOL
	<div class="appointment" data-id="&&&&id&&&&" style="border-left: 5px solid &&&&color&&&&">
	<div class="&&&&drag&&&&">
		<i class="fas fa-&&&&icon&&&& fa-lg"></i> <span class="timestamp">&&&&fstart&&&&</span><a href="?_id=scheduler&amp;todo=delete&amp;rid=&&&&id&&&&&amp;sid=&&&&sid&&&&&amp;view=month"><i class="fas fa-times fa-pull-right red"></i></a>
	</div>
	<a href="?_id=scheduler&amp;todo=edit&amp;rid=&&&&id&&&&&amp;sid=&&&&sid&&&&&amp;view=month">&&&&text&&&&</a>
	</div>
EOL;
	private $entry_in_week = <<<EOL
	<div class="appointment" data-id="&&&&id&&&&" data-day="&&&&start_day&&&&" style="border-left: 5px solid &&&&color&&&&">
	<div class="&&&&drag&&&&">
		<i class="fas fa-&&&&icon&&&& fa-lg"></i> <span class="timestamp">&&&&fstart&&&& - &&&&fend&&&&</span>
		<a href="?_id=scheduler&amp;todo=delete&amp;rid=&&&&id&&&&&amp;sid=&&&&sid&&&&&amp;view=week"><i class="fas fa-times fa-pull-right red"></i></a>
	</div>
	<div class="inside">
	<b><a href="?_id=scheduler&amp;todo=edit&amp;rid=&&&&id&&&&&amp;sid=&&&&sid&&&&&amp;view=week">&&&&text&&&&</a></b>
	&&&&description&&&&</div>
	</div>
EOL;
	private $entry_in_day = <<<EOL
	<div class="appointment" data-id="&&&&id&&&&" data-day="&&&&start_day&&&&-&&&&hour&&&&" style="border-left: 5px solid &&&&color&&&&">
	<div class="&&&&drag&&&&">
		<i class="fas fa-&&&&icon&&&& fa-lg"></i> <span class="timestamp">&&&&fstart&&&& - &&&&fend&&&&</span> <a href="?_id=scheduler&amp;todo=delete&amp;rid=&&&&id&&&&&amp;sid=&&&&sid&&&&&amp;view=day"><i class="fas fa-times fa-pull-right red"></i></a>
	</div>
	<div class="inside">
	<b><a href="?_id=scheduler&amp;todo=edit&amp;rid=&&&&id&&&&&amp;sid=&&&&sid&&&&&amp;view=day">&&&&text&&&&</a></b>
	&&&&description&&&&</div>
	</div>
EOL;
	private $entry_in_list = <<<EOL
	<li><i class="fas fa-&&&&icon&&&& fa-lg"></i> <span class="green">&&&&start_day&&&& &&&&fstart&&&& - &&&&fend&&&&</span>
	<a href="?_id=scheduler&amp;todo=edit&amp;rid=&&&&id&&&&&amp;sid=&&&&sid&&&&&amp;view=day">&&&&text&&&&</a><br />
	<span class="small">&&&&description&&&&</span>
	</li>
EOL;
	private $formJS = <<<EOL
	<script type="text/javascript">

	</script>
EOL;
	public function plugin($html) {
		if (param('todo') == 'set') {$html['action'] = 'set';}
		switch ($html['action']) {
			case ("set"): $html = $this->set($html); break;
			default: $html = $this->calendar($html);
			}
		return $html;
		}

	public function get_dates($html) {
		$ul = htmltag('h3', '', i18n('appointments'));
		$today = date('Y-m-d');
		$types = $this->types ? $this->types : $this->types();
		$form = [
			"table"			=> "calendar",
			"orderby"		=> "start_day",
			"defsort"		=> "ASC",
			"human"			=> "text",
			"html"			=> $html,
			"table_fields"	=> ['id', 'start_day', 'start',  'end_day', 'end', 'text', 'description', 'type', 'user', 'group', 'private'],
			"clause" => "`start_day` >= '$today'"
			];

		$inputs = [
		'id'	=> [ 'type'	=> 'text', ],
		'text'	=> [ 'type'	=> 'text', ],
		'start_day'	=> [ 'type'	=> 'date', ],
		'start'	=> [ 'type'	=> 'text', ],
		'end_day'	=> [ 'type'	=> 'date', ],
		'end'	=> [ 'type'	=> 'text', ],
		'description'	=> [ 'type'	=> 'bigtext', ],
		'type'	=> ['type'	=> 'lookup', 'default' => 1, "lval" => "name", "ltable"	=> "appointment_types" ],
		'user'	=> ['type'	=> 'hidden', ], 'group'	=> [ 'type'	=> 'hidden', ], 'private'	=> [ 'type'	=> 'flag', ] ];

		$obj = new access($form);
		$html = $obj->table($inputs);
		$table_rows = $obj->table_rows;
		$li = '';
		foreach ($table_rows as $row) {
			$row['icon'] = $types[$row['type_orig_val']]['icon'];
			$row['fstart'] =  preg_replace('/:\d\d$/', '', $row['start']);
			$row['fend'] =  $row['start_day'] == $row['end_day'] ? preg_replace('/:\d\d$/', '', $row['end']) : $row['end_day'].' '.preg_replace('/:\d\d$/', '', $row['end']);
			$row['sid'] = $html['sid'];
			$li .= preg_replace_callback("/&&&&(\w+)&&&&/", function($m) use ($row){return $row[$m[1]];}, $this->entry_in_list);
			}
		if ($li) {$ul .= htmltag('ul', 'class="clean"', $li);}
		else {$ul .= i18n('mess_no_entry');}
		return $ul;
		}

	private function calendar($html) {
		require_once('callib.php');
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$view = clean_var(param('view'), "w");
		$group = clean_var(param('level'), "n");
		// detect correct view
		if (param('start_day')){
			$cdar = explode('-', param('start_day'));
			$yea = $cdar[0];
			if (param('view') == 'month'){$mon = $cdar[1];}
			if (param('view') == 'week'){$wee = date('W', strtotime(param('start_day')));}
			if (param('view') == 'day'){$mon = $cdar[1]; $day = $cdar[2];}
			}
		$day = isset($day) ? $day : clean_var(param('_d'), "n");
		$wee = isset($wee) ? $wee : clean_var(param('_w'), "n");
		$mon = isset($mon) ? $mon : clean_var(param('_m'), "n");
		$yea = isset($yea) ? $yea : clean_var(param('_y'), "n");
		$call = $day ? "$yea-$mon-$day" : date('Y-m-d');
		$today = $day ? $day : date('d');
		$tweek = $wee ? $wee : date('W');
		$h = param('start') ? clean_var(param('start'), "w") : date('H', strtotime('1 hour')).':00';
		$eh = (intval($h)+2) > 23 ? 23: intval($h)+2;
		$eh = sprintf('%02d', $eh).':00';
		$html['scripts'] = '<script src="/js/calendar.js"></script>
<link rel="stylesheet" type="text/css"  href="/css/calendar.css">';
		$form = [
			"title"			=> i18n('calendar'),
			"table"			=> "calendar",
			"myconf"		=> "scheduler",
			"orderby"		=> "start_day",
			"defsort"		=> "DESC",
			"human"			=> "text",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['text', 'description'],
			"table_fields"	=> ['start_day', 'start', 'text', 'description', 'type', 'user', 'group', 'private']
			];

		$inputs = [
		'text'	=> [
			'type'	=> 'text',
			],
		'start_day'	=> [
			'type'	=> 'date',
			'default' => $call
			],
		'start'	=> [
			'type'	=> 'text',
			'size'	=> 8,
			'default' => $h
			],
		'end_day'	=> [
			'type'	=> 'date',
			'default' => $call
			],
		'end'	=> [
			'type'	=> 'text',
			'size'	=> 8,
			'default' => $eh
			],
		'description'	=> [
			'type'	=> 'bigtext',
			],
		'type'	=> [
			'type'	=> 'lookup',
			'default'	=> 1,
			"lval"		=> "name",
			"ltable"	=> "appointment_types"
			],
		'user'	=> [
			'type'	=> 'hidden',
			],
		'group'	=> [
			'type'	=> 'hidden',
			'default'	=> 1,
			],
		'private'	=> [
			'type'	=> 'flag',
			],
		'view'	=> [
			'type'	=> 'free',
			'default'	=> $view
			],
		];


		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				$html['content'] .= $this->formJS;
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			if (param('_del')) {$obj->delete();}
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
				[i18n('month'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;_m=$mon", "active", "far-calendar"],
				[i18n('week'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;_m=$mon&amp;_w=$tweek", "inactive", "far-calendar-alt"],
				[i18n('day'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;_m=$mon&amp;_d=$today", "inactive", "far-calendar-check"],
				[i18n('events'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;view=t", "inactive", "far-list-alt"]
				);
			if ($view == 't') {
				$submen = toggle_submen($submen, 4);
				$obj->before_table = make_submenu($submen);
				$html = $obj->table($inputs);
				}
			else {
				$par = ['sid' => $html['sid'],'action' => 'scheduler', 'moon' => true];
				if ($mon) {$par['mon'] = $mon;}
				if ($yea) {$par['yea'] = $yea;}
				if ($day) {$par['day'] = $day;}
				if ($wee) {$par['wee'] = $wee;}
				$par['feasts'] = $this->feasts($yea, $mon, $day);
				$par['events'] = $this->events($yea, $mon, $day, $wee);
//var_dump($par['events']);
				$cal = new callib($par);
				if ($day) {
					$submen = toggle_submen($submen, 3);
					$c = $cal->day();
					$html['left'] = $cal->small_month();
					$html['scripts'] .= "
					<script type=\"text/javascript\">
						\$(document).ready(function () {\$('.appointment').dragthem({'type': 'day',
						'sid': '{$html['sid']}',
						'url': '{$html['myurl']}',
						'snapx': 500,
						'snapy': 1});});
					</script>";
					}
				elseif ($wee) {
					$submen = toggle_submen($submen, 2);
					$c = $cal->week();
					$html['scripts'] .= "
					<script type=\"text/javascript\">
						\$(document).ready(function () {\$('.appointment').dragthem({'type': 'week',
						'sid': '{$html['sid']}',
						'url': '{$html['myurl']}',
						'snapx': 120,
						'snapy': 1});});
					</script>";
					}
				else {
					$c = $cal->month();
					$html['scripts'] .= "
<script type=\"text/javascript\">
	\$(document).ready(function () {\$('.appointment').dragthem({'sid': '{$html['sid']}', 'url': '{$html['myurl']}'});});</script>";
					}
				$html['content'] = make_submenu($submen).$c;
				}
			}
		$html['formtitle'] = $form['title'];
		return $html;
		}

	private function feasts($y, $m, $d) {
		global $db;
		$m = $m ? $m : date('m');
		$y = $y ? $y :  date('Y');
		$q = "SELECT * FROM `feast`;";
		$feasts = array();
		$arg = $db->prepare($q);
		$arg->execute();
		while ($d = $arg->fetch(PDO::FETCH_ASSOC)) {
			if (!$d['fix_month']) {
				$eas = $this->easter ? $this->easter : $this->easter($y);
				$feast = date('Y-m-d', strtotime("+{$d['rel_easter_sun']} days", strtotime($eas)));
				}
			else {$feast = $y.'-'.sprintf('%02d', $d['fix_month']).'-'.sprintf('%02d', $d['fix_day']);}
			$far = explode('-', $feast);
			if ($far[1] == $m) {$feasts["$far[1]-$far[2]"] = $d['name'];}
			}
		return $feasts;
		}

	private function set($html){
		global $db;
		$rid = clean_var(param('rid'), "n");
		$start = clean_var(param('start'), "w");
		$date = clean_var(param('date'), "w");
		$end = clean_var(param('end'), "w");
		$message = "<span class='red'>error</span> ";

		if ($rid && $date != 'undefined') { // always strange javascript vs php rules
			$taint = array();
			$query = "UPDATE `calendar` SET ";
			if ($date) {$query .= "`start_day` = ?, `end_day` = ?,"; array_push($taint, $date, $date);}
			if ($start) {$query .= "`start` = ?, `end` = ?,"; array_push($taint, $start, $end);}
			$query = preg_replace('/,$/', '', $query);
			if ($rid != "new") {$query .= "WHERE `id` = ?"; array_push($taint, $rid);}
			$arg = $db->prepare($query);
			$arg->execute($taint);
			$message = "<span class='green'>OK</span>";
			}
		$html['content'] = $message;
		$html['gui'] = 6;
		return $html;
		}

	private function events($y, $m, $d, $w) {
		global $db, $html;
		$m = $m ? $m : date('m');
		$y = $y ? $y :  date('Y');
		$types = $this->types ? $this->types : $this->types();

		$q = "SELECT * FROM `calendar` WHERE (MONTH(`start_day`) = '$m' AND YEAR(`start_day`) = '$y') OR (MONTH(`end_day`) = '$m' AND YEAR(`end_day`) = '$y') ORDER BY `start_day`, `start`;";
		if ($d) {$q = "SELECT * FROM `calendar` WHERE `start_day` = '$y-$m-$d' OR (`start_day` < '$y-$m-$d' AND `end_day` >= '$y-$m-$d') ORDER BY `start_day`, `start`;";}
		if ($w) {$q = "SELECT * FROM `calendar` WHERE (WEEK(`start_day`,5) = '$w' AND YEAR(`start_day`) = '$y') OR (WEEK(`end_day`,5) = '$w' AND YEAR(`end_day`) = '$y') ORDER BY `start_day`, `start`;";}
		$events = array();
		$arg = $db->prepare($q);
		$arg->execute();

		while ($dt = $arg->fetch(PDO::FETCH_ASSOC)) {
			$templ = $this->entry_in_month;
			if ($d) {
				$templ = $this->entry_in_day;
				$dt['hour'] = preg_replace('/:\d\d:\d\d$/', '', $dt['start']);
				$t = intval($dt['hour']);
				$dt['fend'] =  $dt['start_day'] == $dt['end_day'] ? preg_replace('/:\d\d$/', '', $dt['end']) : preg_replace('/^\d{4}-/', '', $dt['end_day']);
				}
			if ($w) {
				$templ = $this->entry_in_week;
				$dt['hour'] = preg_replace('/:\d\d:\d\d$/', '', $dt['start']);
				$t = intval($dt['hour']);
				$dt['fend'] =  $dt['start_day'] == $dt['end_day'] ? preg_replace('/:\d\d$/', '', $dt['end']) : preg_replace('/^\d{4}-/', '', $dt['end_day']);
				}
			$ear = explode('-', $dt['start_day']);
			$dt['fstart'] =  $dt['start_day'] == $dt['end_day'] ? preg_replace('/:\d\d$/', '', $dt['start']) : preg_replace('/^\d{4}-/', '', $dt['start_day']);
			$dt['drag'] = $dt['start_day'] == $dt['end_day'] ? 'dragzone' : 'nodrag';
			$dt['color'] = $types[$dt['type']]['color'];
			$dt['icon'] = $types[$dt['type']]['icon'];
			$dt['sid'] = $html['sid'];
			$keys = array();
			if ($d) {$keys = ["$d-$t"];}
			else {
				$days = (strtotime($dt['end_day'])-strtotime($dt['start_day']))/86400;
				for ($i=0; $i <= $days; $i++) {
					$dte = $i ? date('Y-m-d', strtotime("+$i days", strtotime($dt['start_day']))) : $dt['start_day'];
					$dar = explode('-', $dte);
					if ($w) {array_push($keys, "$dar[2]-$t");}
					else {array_push($keys, "$dar[1]-$dar[2]");}
					}
				}
			$out = preg_replace_callback("/&&&&(\w+)&&&&/", function($m) use ($dt){return $dt[$m[1]];}, $templ);
			foreach ($keys as $n => $key) {
				if (array_key_exists($key, $events)) {$events[$key] .= $out;}
				else {$events[$key] = $out;}
				}
			}
		return $events;
		}

	private function types() {
			global $db;
			$q = "SELECT * FROM `appointment_types`;";
			$this->types = array();
			$arg = $db->prepare($q);
			$arg->execute();
			while ($d = $arg->fetch(PDO::FETCH_ASSOC)) {
				$this->types[$d['id']] = $d;
				}
			return $this->types;
			}

	private function easter($y) {
		$i = easter_days($y);
		$this->easter = date('Y-m-d', strtotime("+$i days", strtotime("$y-03-21")));
		return $this->easter;
		}
	}
?>
