<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-05-02 14:47:24
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2022-11-11T12:21:23+01:00
# @License: GPL 2.0



/**
 * plugin postit
 * @package consentio
 */

class postit {

	public function plugin($html) {
		switch ($html['action']) {
			case ("SOMETHINGELSE"): $html = $this->SOMETHINGELSE_admin($html); break;
			default: $html = $this->postit_admin($html);
			}
		return $html;
		}

	public function get_todos($html) {
		list($form, $inputs) = $this->model($html, 0, 0);
		$form['clause'] = "`todos` = 'on' AND (`user` = '{$html['user']['id']}' OR `private` <> 'on' OR `private` IS NULL)";
		$form['orderby'] = 'deadline';
		$form['defsort'] = 'ASC';
		$obj = new access($form);
		$html = $obj->table($inputs);
		$list = '';
		foreach ($obj->table_rows as $row) {
			$row['sid'] = $html['sid'];
			$list .= parse_in('gui_postit_item_clean', $row);
			}
		$list = htmltag('ul', 'class="clean"', $list);
		$list = htmltag('h3', '', i18n('todos')).$list;
		return $list;
		}

	private function model($html, $rid, $view) {

		$size = $view ? 60 : 1000;
		$box = $view ? 'both' : false;

		$form = [
			"title"			=> i18n('postit'),
			"table"			=> "postit",
			"myconf"		=> "postit",
			"orderby"		=> "date",
			'defsort'		=> 'DESC',
			"q_limit"		=> 20,
			"human"			=> "title",
			"html"			=> $html,
			"rid"			=> $rid,
			"allow_box"		=> $box,
			"attr_to_set"	=> ['priority', 'todos'],
			"maxsize"		=> $size,
			"filters"		=> ['priority', 'todos'],
			"search"		=> ['fulltext', 'title', 'text'],
			"table_fields"	=> ['title', 'text', 'priority', 'todos', 'deadline', 'date'],
			"clause"		=> "(`user` = '{$html['user']['id']}' OR `private` <> 'on' OR `private` IS NULL)"
			];

		$inputs = [
		'title'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'text'	=> [
			'type'		=> 'bigtext',
			'cols'		=> 50,
			'rows'		=> 25,
			'css_class' => 'postit'
			],
		'priority'	=> [
			'type'	=> 'array',
			'extra'	=> [i18n('low'), i18n('middle'), i18n('high'), i18n('highest')],
			'fontawesome'	=> ['tag-blue', 'tag-green', 'tag-orange', 'tag-red'],
			'default'	=> 1,
			],
		'user'	=> [
			'type'	=> 'hidden',
			'default'	=> $html['user']['id'],
			],
		'private'	=> [
			'type'	=> 'flag'
			],
		'todo'	=> [
			'type'	=> 'fieldset',
			'end'	=> 'date'
			],
		'todos'	=> [
			'type'	=> 'flag',
			],
		'deadline'	=> [
			'type'	=> 'date',
			'default'	=> '2500-12-31',
			'duty'	=> 1,
			],
		'date'	=> [
			'caption'	=> i18n('written'),
			'type'	=> 'readonly',
			'default'	=> date('Y-m-d H:i:s'),
			'duty'	=> 1,
			],
		'update'	=> [
			'caption'	=> i18n('last_update'),
			'type'	=> 'readonly',
			'default'	=> date('Y-m-d H:i:s'),
			'duty'	=> 1,
			],
		'_view'	=> [
			'type'	=> 'free',
			'value'	=> $view
			]
		];

		return array($form, $inputs);
		}

	private function postit_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$view = param('_view') ? clean_var(param('_view'), "d") : 0;
		list($form, $inputs) = $this->model($html, $rid, $view);

		$obj = new access($form);
		$obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;_view=$view", "inactive", "sticky-note-add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);

			if (!$view) {
				$list = '';
				foreach ($obj->table_rows as $row) {
					$list .= parse_in('gui_postit_item', $row);
					}
				$html['content'] = make_submenu($submen);
				$html['content'] .= $obj->searchform;
				if ($list) {
					$html['content'] .= $obj->offsetText;
					$html['content'] .= htmltag('ul', 'id="postit"', $list);
					//$html['content'] .= $obj->query;
					}
				else {$html['content'] .= i18n('mess_no_entry');}
				}

			}
		// default tree shows plugins of group "plugins"
		$html['left'] = get_tab_tree($html, "plugins", $form['myconf'], "");
		return $html;
		}
	}
?>
