<?php

function plugin($html) {
	switch ($html['action']) {
		case ("piwik_settings"): $html = piwik_settings($html); break;
		case ("piwik_embed"): $html = piwik_embed($html); break;
		default: $html = piwik($html);
		}
	return $html;
	}
	
function piwik($html) {
	$submen = piwik_tabs();
	$html['content'] = make_submenu(toggle_submen($submen, 0));
	$piwik = read_settings(['group' => 'piwik']);
	if (isset($piwik['piwik_site'])) {
		$html['content'] .= parse_in('piwik_dashboard', $piwik);
		$html['gui'] = 2;
		}
	else {$html = piwik_settings($html);}
	return $html;
	}
	
function piwik_settings($html) {
	global $con;
	$form = [
		"title"			=> "Piwik &ndash;".i18n('settings'),
		"table"			=> "cms_settings",
		"myconf"		=> "piwik_settings",
		"no_cancel" 	=> "1",
		"table_fields"	=> ["key", "value", "lang"],
		"html"			=> $html,
		];
	$inputs = [
		"group"			=> ['type' => "free", 'default' => "piwik"],
		"rule"			=> ['type' => "free", 'default' => $con['rule']],
		"lang"			=> ['type' => "free", 'default' => '*'],
		"piwik_url"		=> ['type' => "text", 'duty' => 1],
		"piwik_site"	=> ['type' => "spin", 'duty' => 1, 'default' => 1, 'interval' => 1],
		"piwik_token"	=> ['type' => "text"]
		];
	
	$obj = new access($form);
	$submen = piwik_tabs();
	$obj->before_form = make_submenu(toggle_submen($submen, 1));
	
	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {
			$obj->error = 0;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		else {
			$obj->store_settings($inputs);
			$feedback = "<p>".$obj->feedback."</p><p><a href='{$html['myurl']}?_id=piwik_settings&amp;sid={$html['sid']}' class='as_button'>".i18n('ok')."</a></p>";
			$html['content'] = say_mess($feedback, i18n('info'), 'info');
			}
		}
	else {
		$inputs = $obj->get_settings_value($inputs);
		$obj->add_input($inputs);
		$html = $obj->form();
		}
	return ($html);
	}
	
function piwik_embed($html) {
	$data = ['component' => 'PIWIK', 'lang' => '*'];
	$code = read_component($data);
	
	$form = [
		"title"			=> i18n('piwik_embed'),
		"myconf"		=> "piwik_embed",
		"no_cancel" 	=> "1",
		"html"			=> $html
		];
	$inputs = [
		'code'		=> [				
			"type"		=> "bigtext",
			"syntax"	=> 'text/html',
			"duty"		=> 1,
			"rows"		=> 30,
			"cols"		=> 100,
			'default'	=> $code
			],
		];
	$obj = new access($form); 
	
	if (param('_store')) {
		$data = ['component' => 'PIWIK', 'html' => param('code'), 'lang' => '*', 'active' => 'on'];
		write_component($data);
		generate();
		$html['popup'] = "ok"; $obj->html_in($html);	
		}
		
	$submen = piwik_tabs();
	$obj->before_form = make_submenu(toggle_submen($submen, 2));
	$obj->add_input($inputs);
	$html = $obj->form();	
	return ($html);
	}
	
function piwik_tabs() {
	global $html;
	$tabs = array(
		['Piwik', $html['myurl']."?sid={$html['sid']}&amp;_id=piwik", "active", "chart_curve"],
		['Piwik &ndash; '.i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=piwik_settings", "active", "wrench"],
		[i18n('embed_code'), $html['myurl']."?sid={$html['sid']}&amp;_id=piwik_embed", "active", "meta"]
		);
	if ($html['user']['level'] <= 2) {
		unset($tabs[1]); unset($tabs[2]);	
		}
	return $tabs;
	}
?>