<?php
# @Author: consentio
# @Date:   2018-08-18T16:58:32+02:00
# @Last modified by:   consentio
# @Last modified time: 2023-08-30T18:40:44+02:00




function plugin($html) {
	switch ($html['action']) {
		case ("folder"): $html = pages($html); break;
		case ("templates"): $html = templates_admin($html); break;
		case ("components"): $html = components_admin($html); break;
		case ("web_settings"): $html = make_web_settings($html); break;
		case ("lang_settings"): $html = lang_settings($html); break;
		case ("load_layout"): $html = load_layout($html); break;
		default: $html = pages($html);
		}
	return $html;
	}

function pages($html) {
	global $website;
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$parent = clean_var(param('parent'), "n");
	list($mylang, $myparent, $ptype) = parents_def($parent);
	$do = $parent ? true : false;
	if ($html['user']['level'] < 2) { $do = false;}
	$type = param('type') ? clean_var(param('type'), "w") : "view";
	$form = form_by_type(1);
	$form['rid'] = $rid;
	$inputs = inputs_by_type($type);
	$inputs['parent']['default'] = $parent;
	$inputs['sort']['do'] = $do;

	$obj = new access($form);

	if ($obj->set_attribute($inputs)) {generate();}

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], "parent", $parent);
		reconf_parent("content", "short", "parent");
		generate();
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			if ($obj->rid == "new") {
				switch ($inputs['type']['value']) {
					case "link": break;
					default:
					$inputs['generate']['value'] = 1;
					$inputs['file']['value'] = "/".clean_filename($inputs['title']['value'].".html", $html['dir']);
					}
				}
			else {
				switch ($inputs['type']['value']) {
					case "node":
						$inputs = set_first_page($obj->rid, $inputs);
						$inputs['generate']['value'] = 0;
						break;
					case "folder":
						$inputs['file']['value'] = reset_folder($obj->rid);
						$inputs['generate']['value'] = 1;
						break;
					}
				}
			$inputs['update']['value'] = date('Y-m-d H:i:s');
			$inputs['last_editor']['value'] = $html['user']['id'];
			if(param('force_new_title')) {
				unlink("{$html['dir']}{$inputs['file']['value']}");
				$inputs['file']['value'] = "/".clean_filename($inputs['title']['value'].".html", $html['dir']);
				}
			$id = $obj->store($inputs);
			reconf_parent("content", "short", "parent");
			$html['popup'] = $obj->feedback;
			generate();
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {
			// what is my type, my language
			$inputs = inputs_by_type('test');
			$inputs = $obj->get_value($inputs);
			$mylang = $inputs['lang']['value'];
			$inputs = inputs_by_type($inputs['type']['value']);
			$inputs = $obj->get_value($inputs);
			if (array_key_exists('file', $inputs)) {$inputs['file']['in_body'] = '<br /><input id="ifcnt" type="checkbox" name="force_new_title" /> <label for="ifcnt">'.i18n('update_now').'</label>';}
			}

		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			if ($obj->rid == "new" and !param('type')) {$html = pre_page($html);}
			else {
				$inputs['parent']['lclause'] .= " AND `lang` = '$mylang'";
				if (intval($rid)) {
					$notin = $inputs['folder']['value'] ? check_dependencies("folder_view", $rid, "parent") : "";
					if ($notin) {$inputs['parent']['lclause'] .= " AND $notin";}
					}
				$inputs['lang']['default'] = $mylang;
				$obj->add_input($inputs);
				$html = $obj->form();
				$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"#ishort\").title2short();});</script>\n";
				}
			}
		}
	elseif (param('_set_att')) {
		// take care of different content types
		$inputs['parent']['lclause'] = "`lang` = '$mylang'";
		if (param('c_filter')) {
			if (isset($website['content_types'][param('c_filter')])) {
				$in = explode(',', $website['content_types'][param('c_filter')]['new_in_type']);
				$inputs['parent']['caption'] = i18n($in[0]);
				$in = array_map(function($m){return "'".trim($m)."'";}, $in);
				$inputs['parent']['lclause'] .= ' AND `type` IN ('.implode(', ', $in).')';
				}
			else {$inputs['parent']['lclause'] .= " AND `type` IN ('root', 'folder', 'node')";}
			}
		$html = $obj->attr_form($inputs);
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		if ($type != 'view') {$inputs = inputs_by_type('view');}
		$submen = pages_tabs($parent);
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {
			$records = $obj->get_multiple_values($inputs); // before we delete we need some values
			foreach ($records as $row) {
				if ($row['type'] != 'node') {unlink("{$html['dir']}{$row['file']}");}
				}
			$obj->delete();
			reconf_parent("content", "short", "parent");
			generate();
			}
		$inputs['parent']['lclause'] = "`lang` = '$mylang'";
		$html = $obj->table($inputs);
		$html['scripts'] .= "<script>\$(document).ready(function () {\$(\"[data-app='preview']\").popLink({header: '".i18n('preview')."', 'top': '5%', 'left': '1%', 'width': '1024', 'height': '600'});});</script>\n";
		}
	$html['left'] = content_tree($parent, "pages");
	// $html['content'] .= $obj->query;
	return $html;
	}

function pre_page($html) {
	global $con;
	$parent = clean_var(param('parent'), "n");
	$submen = toggle_submen(pages_tabs($parent), 0);
	list($mylang, $myparent, $ptype) = parents_def($parent);
	list($extra, $view, $icons) = get_content_types($ptype, 'new');
	$list = "<div class='menueset clrfx'>\n<h2>".i18n('new_entry')." &ndash; {$con['langs'][$mylang]} &ndash; $myparent</h2>\n<ul class='menue'>\n";
	foreach ($extra as $k=>$v) {
		$img = get_big_icon($icons[$k], "");
		$bubble = bubble_text('common.'.$v);
		if ($bubble) {$bubble = "<div class='short_help'>$bubble</div>";}
		$myid = 'pages';
		$pages = ['homepage', 'pages', 'folder', 'node', 'link'];
		if(!in_array($v, $pages)) {$myid = $v;}
		$list .= "<li><a href='{$html['myurl']}?_id=$myid&amp;sid={$html['sid']}&amp;todo=edit&amp;parent=$parent&amp;type=$v&amp;rid=new'>$img<br />{$view[$k]}</a>$bubble</li>";
		}
	$list .= "\n</ul>\n</div>";
	$html['content'] = 	make_submenu($submen);
	$html['content'] .= $list;
	$html['title'] = i18n('pages');
	$html['formtitle'] = $html['title'];
	return $html;
	}

function make_web_settings($html) {
	global $con, $website;
	$lang = clean_var(param('lang'), "w");
	$lang = $lang ? $lang : "*";
	$lang = $con['ln'] == $lang ? "*" : $lang;
	//$styles = get_all_styles();
	$form = [
		"title"			=> "CMS-".i18n('settings')." $lang",
		"table"			=> "cms_settings",
		"myconf"		=> "web_settings",
		"human"			=> "name",
		"no_cancel" 	=> "1",
		"table_fields"	=> ["key", "value", "lang"],
		"html"			=> $html,
		];
	$inputs = [
		"group"			=> ['type' => "free", 'default' => "cms"],
		"rule"			=> ['type' => "free", 'default' => $con['rule']],
		"lang"			=> ['type' => "free", 'default' => $lang],
		"meta"			=> ['type' => "fieldset"],
		"website_title"	=> [
			'type' => "text",
			'duty'		=> 1
			],
		"website_url"	=> ['type' => "text", 'duty' => 1],
		"website_logo"	=> ['type' => "image", 'duty' => 1],
		"website_lead_img"	=> ['type' => "image"],
		"website_keywords"	=> [
			'rows'		=> 3,
			'type'		=> "bigtext",
			'duty'		=> 1
			],
		"website_author"	=> ['type' => "text", 'duty' => 1],
		"website_description"	=> [
			'rows'		=> 3,
			'type'		=> "bigtext",
			'duty'		=> 1
			],
		"country"		=> ['type' => "country", 'duty' => 1],
		"def_css"		=> ['type'	=> "hidden"],
		"misc"			=> ['type' => "fieldset"],
		"skip_home"		=> ['type' => "flag", 'extra' => 'outset'],
		"homepages"		=> ['type' => "hidden"],
		"last_update"	=> ['type' => "hidden"],
		"act_layout"	=> ['type' => "hidden"],
		"css_generation"	=> ['type' => "hidden"],
		"header_layout"	=> ['type' => "hidden"],
		"footer_layout"	=> ['type' => "hidden"],
		"breadcrumb"	=> ['type' => "flag", 'extra' => 'outset'],
		"sub_nav"		=> ['type' => "flag", 'extra' => 'outset']
		];

	if ($lang != '*') {
		$inputs = [
		"group"			=> ['type' => "free", 'default' => "cms"],
		"rule"			=> ['type' => "free", 'default' => $con['rule']],
		"lang"			=> ['type' => "free", 'default' => $lang],
		"meta"			=> ['type' => "fieldset", 'caption' => i18n('meta')." &ndash; ".$con['langs'][$lang]],
		"website_title"	=> [
			'type' => "text",
			'duty'		=> 1
			],
		"website_logo"	=> [
				'type' => "image",
				'default' => $website['website_logo'],
				'duty' => 1
				],
		"website_keywords"	=> [
			'rows'		=> 3,
			'type'		=> "bigtext",
			'duty'		=> 1
			],
		"website_author"	=> ['type' => "text", 'duty' => 1],
		"website_description"	=> [
			'rows'		=> 3,
			'type'		=> "bigtext",
			'duty'		=> 1
			]
		];
	}

	$obj = new access($form);
	$submen = pages_tabs(0);
	$obj->before_form = make_submenu(toggle_submen($submen, 2));

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		$html['content'] = var_export($inputs, true);
		if ($obj->error) {
			$obj->error = 0;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		else {
			$obj->store_settings($inputs);
			$website = read_settings(['group' => 'cms']);

			/* copy css from ressource/ to css/
			if (!file_exists("{$html['dir']}/css/{$website['def_css']}")){
				copy("{$html['dir']}/css/ressources/{$website['def_css']}","{$html['dir']}/css/{$website['def_css']}");
				} */

			$mywebsite = my_language($website, $lang);
			$img = getimagesize("{$html['dir']}/pictures/{$mywebsite['website_logo']}");
			list($mywebsite['width'], $mywebsite['height']) = $img;
			if (!$mywebsite['width']) {
					$svg = simplexml_load_file("{$html['dir']}/pictures/{$mywebsite['website_logo']}");
					$t = explode(' ', $svg['viewBox']);
		    	$mywebsite['width'] = intval($t[2]);
		    	$mywebsite['height'] = intval($t[3]);
					}
			$mywebsite['homeref'] =  $lang == '*' ? "/" : "index_$lang.html";
			$data = ['component' => 'LOGO', 'html' => parse_in('cms_logo', $mywebsite), 'lang' => $lang, 'active' => 'on'];
			write_component($data);

			generate();
			$feedback = "<p>".$obj->feedback."</p><p><a href='{$html['myurl']}?_id=web_settings&amp;sid={$html['sid']}' class='as_button'>".i18n('ok')."</a></p>";
			$html['content'] = say_mess($feedback, i18n('info'), 'info');
			}
		}
	else {
		$inputs = $obj->get_settings_value($inputs);
		$obj->add_input($inputs);
		$html = $obj->form();
		}
	$html['left'] = get_tab_tree($html, "pages", "web_settings", web_settings_tree('$lang'));
	return ($html);
	}

function lang_settings($html) {
	global $db, $con;
	$used_langs = param('languages');
	$form = [
		"title"			=> i18n('lang_settings'),
		"no_cancel"		=> 1,
		"myconf"		=> "lang_settings",
		"html"			=> $html,
		"button_text"	=> i18n('set')
		];
	$inputs = [
		"default"	=> [
			"caption"	=> i18n('default_lang'),
			"default"	=> $con['ln'],
			"type"		=> "readonly_lookup",
			"lid"		=> "iso639",
			"lval"		=> "language",
			"lord"		=> "language",
			"ltable"	=> "languages"
			],
		"languages"	=> [
			"caption"	=> i18n('used_langs'),
			"default"	=> array_keys($con['langs']),
			"type"		=> "multicheck",
			"lid"		=> "iso639",
			"lval"		=> "language",
			"lord"		=> "language",
			"ltable"	=> "languages",
			'row_class' => 'col w6'
			]
		];
	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();

	if ($used_langs) {
		set_multilingual($used_langs);
		unset($con['langs']);
		used_langs();
		add_new_lang_col();
		rebuild_roots();
		gen_components();
		generate();
		$html['content'] = say_mess(i18n('mess_lang_settings'), i18n('info'), "info");
		}
	$html['left'] = get_tab_tree($html, "pages", "lang_settings","");
	return ($html);
	}

function templates_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");

	$form = [
		"title"			=> i18n('page_templates'),
		"table"			=> "templates",
		"myconf"		=> "templates",
		"orderby"		=> "id",
		"human"			=> "name",
		"html"			=> $html,
		"rid"			=> $rid,
		"search"	=> ["name"],
		"table_fields"	=> ['name', 'head', 'body', 'title', 'header', 'footer']
		];

	$inputs = [
		'name' =>	[
			'caption' => i18n('title'),
			'type' => 'text',
			'duty' => 1
			],
		'index' =>	[
			'caption' => i18n('name'),
			'type' => 'text',
			'default' => 'cms_layout_custom...',
			'duty' => 1
			],
		'head' =>	[
			'type' => 'suggest',
			'default' => 'cms_head',
			'duty' => 1,
			"lid" => "key",
			"lval" => "key",
			"lord" => "key",
			"ltable" => "html_snippets"
			],
		'body' =>	[
			'caption' => "BODY",
			'type' => 'suggest',
			'default' => 'cms_pages_body1',
			'duty' => 1,
			"lid" => "key",
			"lval" => "key",
			"lord" => "key",
			"ltable" => "html_snippets"
			],
		'title' =>	[
			'type' => 'suggest',
			'default' => 'cms_pages_title',
			'duty' => 1,
			"lid" => "key",
			"lval" => "key",
			"lord" => "key",
			"ltable" => "html_snippets"
			],
		'header' =>	[
			'type' => 'suggest',
			'default' => 'cms_pages_header',
			'duty' => 1,
			"lid" => "key",
			"lval" => "key",
			"lord" => "key",
			"ltable" => "html_snippets"
			],
		'footer' =>	[
			'type' => 'suggest',
			'default' => 'cms_pages_footer',
			'duty' => 1,
			"lid" => "key",
			"lval" => "key",
			"lord" => "key",
			"ltable" => "html_snippets"
			],
		];

	$obj = new access($form);

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		if (param('_del')) {$obj->delete();}
		$submen = pages_tabs(0);
		$obj->before_table = make_submenu(toggle_submen($submen, 2));
		$html = $obj->table($inputs);
		}
	$html['left'] = get_tab_tree($html, "pages", "templates", '');
	return $html;
	}

function components_admin($html) {
	global $con;
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$type = clean_var(param('type'), "n");
	$type = $type ? $type : 1;

	$form = [
		"title"			=> i18n('components'),
		"table"			=> "components",
		"myconf"		=> "components",
		"orderby"		=> "name",
		"human"			=> "title",
		"html"			=> $html,
		"rid"			=> $rid,
		"filters"		=> ["type"],
		"search"		=> ["title", "description"],
		"table_fields"	=> ["type", "title", "name", "description", "lang", "active"],
		"attr_to_set"	=> ["lang", "active"],
		"allow_box"		=> 'both',
		'clause'		=> '',
		"button_after"	=> htmltag('button', "name=\"_clone\" value=\"1\" class=\"button red yo-right\" type=\"submit\"", get_icon('clone', '').' '.i18n('duplicate'))
		];

	if ($html['user']['level'] <= 2) {$form['clause'] = "`custom` = 'on'";}
	else {
		$form['filters'] = ["type", "custom"];
		array_push($form['table_fields'], 'custom');
		}

	$inputs = [
		'name' =>	[
			'type' => 'text',
			'duty' => 1,
			],
		'title' =>	[
			'type' => 'text',
			'duty' => 1,
			],
		'description' =>	[
			'type' => 'bigtext',
			"rows"		=> 3
			],
		'content' =>	[
			"type"		=> "bigtext",
			"syntax"	=> 'text/html',
			"duty"		=> 1,
			"rows"		=> 30,
			"cols"		=> 100
			],
		'custom' =>	[
			'type' => 'flag',
			'default' => 'on',
			],
		'active' =>	[
			'type' => 'flag',
			'default' => 'on'
			],
		'lang' =>	[
			'caption'	=> i18n('language'),
			'type'		=> 'array',
			'raw'		=> 1,
			'extra'		=> array_merge(['*'], array_keys($con['langs'])),
			'default' => $con['ln']
			],
		'type' =>	[
			'type' => 'array',
			"extra" => ["CODE", "WYSIWYG"],
			'duty' => 1,
			'default' => $type,
			]
		];

	if ($type == 2) {
		$inputs['content'] = ['type' => 'wysiwyg'];
		}

	$obj = new access($form);
	$obj->set_attribute($inputs);

	if (param('_clone')) {
		$inputs = $obj->get_value($inputs);
		$rid = 0;
		$inputs['name']['duty'] = 2;
		$obj->button_after = '';
		$obj->before_form = i18n('copy');
		$todo = 'edit';
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			generate();
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$type = isset($inputs['type']['value']) ? $inputs['type']['value'] : 1;
			if ($type == 2) {
				$inputs['content'] = ['type' => 'wysiwyg', 'value' => $inputs['content']['value']];
				}
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		if (param('_del')) {$obj->delete(); generate();}
		$submen = pages_tabs(0);
		$obj->before_table = make_submenu(toggle_submen($submen, 3));
		$html = $obj->table($inputs);
		}
	$html['left'] = get_tab_tree($html, "pages", "components","");
	return $html;
	}

function load_layout($html) {
	global $website;
	$gen_type = "hidden";
	if ($website['css_generation'] != 2) {
		$website['css_generation'] = 1;
		$website['footer_layout'] = 'big';
		$gen_type = 'radio';
		if ($website['act_layout'] == 3) {
			$website['act_layout'] = 2;
			$website['header_layout'] = 'line';
			}
		elseif ($website['act_layout'] == 2) {
			$website['act_layout'] = 1;
			$website['header_layout'] = 'stack';
		}
		else {
			$website['act_layout'] = 1;
			$website['header_layout'] = 'line';
			}
		}
	$my_gen = param('generation') ? clean_var(param('generation'), 'n') : $website['css_generation'];
	$my_layout = param('layout') ? clean_var(param('layout'), 'n') : $website['act_layout'];
	$my_header_layout = param('header_layout') ? clean_var(param('header_layout'), 'w') : $website['header_layout'];
	$my_footer_layout = param('footer_layout') ? clean_var(param('footer_layout'), 'w') : $website['footer_layout'];
	$my_css = param('css') ? clean_var(param('css'), 'w') : $website['def_css'];
	$styles = get_all_styles();
	$vstyles = array_map(function($v){$v = preg_replace("/^yo-/", '', $v); $v = preg_replace("/([A-Z])/", " $1", $v); $v = preg_replace("/\.css$/", '', $v); return ucfirst($v);}, $styles);

	$form = [
		"title"			=> i18n('designer'),
		"no_cancel"		=> 1,
		"myconf"		=> "load_layout",
		"html"			=> $html,
		"button_text"	=> i18n('set')
		];
	$inputs = [
		"generation"	=> [
			"caption"	=> "Generation",
			"default"	=> $my_gen,
			"type"		=> $gen_type,
			"extra"		=> ['Yololo 1', 'Yololo+'],
		],
		"layout"	=> [
			"caption"	=> i18n('load_layout'),
			"default"	=> $my_layout,
			"type"		=> "radio",
			"extra"		=> ['inside', 'outside'],
		],
		"header_layout"	=> [
			"caption"	=> i18n('header'),
			"default"	=> $my_header_layout,
			"type"		=> "radio",
			"raw"		=> 1,
			"extra"		=> ['line', 'stack', 'slim'],
		],
		"footer_layout"	=> [
			"caption"	=> i18n('footer'),
			"default"	=> $my_footer_layout,
			"type"		=> "radio",
			"raw"		=> 1,
			"extra"		=> ['big', 'small'],
		],
		"css"	=> [
			"caption"	=> i18n('css'),
			"default"	=> $my_css,
			"type"		=> "radio",
			"raw"		=> 1,
			"extra"		=> $styles,
			"view"		=> $vstyles
			]
		];

	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();

	if (param('_store')) {
		if ($my_css != $website['def_css']) {
			$website['def_css'] = $my_css;
			write_setting(['table' => 'cms_settings', 'key' => 'def_css', 'group' => 'cms', 'lang' => '*', 'value' => $my_css]);
			}
		if ($my_header_layout != $website['header_layout']) {
			$website['header_layout'] = $my_header_layout;
			write_setting(['table' => 'cms_settings', 'key' => 'header_layout', 'group' => 'cms', 'lang' => '*', 'value' => $my_header_layout]);
			toggle_layout($website['act_layout'], $my_layout);
			}
		if ($my_footer_layout != $website['footer_layout']) {
			$website['footer_layout'] = $my_footer_layout;
			write_setting(['table' => 'cms_settings', 'key' => 'footer_layout', 'group' => 'cms', 'lang' => '*', 'value' => $my_footer_layout]);
			toggle_layout($website['act_layout'], $my_layout);
			}
		if ($my_gen != $website['css_generation']) {
			toggle_generation($website['css_generation'], $my_gen);
			$website['css_generation'] = $my_gen;
			toggle_layout($website['act_layout'], $my_layout);
			}
		if ($my_layout != $website['act_layout']) {toggle_layout($website['act_layout'], $my_layout);}
		$html['popup'] = i18n('layout_changed');
		$obj->html_in($html);
		generate();
		}

	$html['content'] = say_mess(htmltag('p', 'class="red"', i18n('mess_overwrite_html')), i18n('warning'), 'warning').$html['content'];
	$html['left'] = get_tab_tree($html, "pages", "load_layout", '');
	return $html;
	}

function toggle_generation($old, $new) {
	global $db, $website;
	$snippets = ['cms_navbar', 'cms_navbar_item', 'cms_navbar2', 'cms_navbar_item2', 'cms_head', 'cms_pages_lightbox', 'cms_scripts', 'cms_pages_searchbox'];
	foreach ($snippets as $snip) {
		$q = "SELECT `key`, `code` FROM `html_presets` WHERE `key` = '$snip' AND `generation` = '$new' LIMIT 1;";
		$arg = $db->prepare($q);
		$arg->execute();
		$code = $arg->fetch(PDO::FETCH_ASSOC);
		$q2 = "UPDATE `html_snippets` SET `code` = ? WHERE `key` = ?";
		$arg2 = $db->prepare($q2);
		$arg2->execute([$code['code'], $snip]);
		}
	gen_components(); // set new searchbox as component
	write_setting(['table' => 'cms_settings', 'key' => 'css_generation', 'group' => 'cms', 'lang' => '*', 'value' => $new]);
	}

function toggle_layout($old, $new) {
	global $db, $website;
	$snippets = ['cms_pages_header', 'cms_pages_footer', 'cms_pages_body_start', 'cms_pages_body1', 'cms_pages_body2'];
	// webshop
	$test = get_one_register(['action' => 'webshop']);
	if (isset($test['reg'])) {array_push($snippets, 'cms_webshop_body');}
	$codes = [];
	foreach ($snippets as $snip) {
		if ($snip == 'cms_pages_header') {$snap = $snip."_{$website['header_layout']}";}
		elseif ($snip == 'cms_pages_footer') {$snap = $snip."_{$website['footer_layout']}";}
		else {$snap = $snip;}
		$q = "SELECT `key`, `code` FROM `html_presets` WHERE `key` = '$snap' AND `generation` = '{$website['css_generation']}' AND `main` = '$new' LIMIT 1;";
		$arg = $db->prepare($q);
		$arg->execute();
		$code = $arg->fetch(PDO::FETCH_ASSOC);
		$q2 = "UPDATE `html_snippets` SET `code` = ? WHERE `key` = ?";
		$arg2 = $db->prepare($q2);
		$arg2->execute([$code['code'], $snip]);
		}
	write_setting(['table' => 'cms_settings', 'key' => 'act_layout', 'group' => 'cms', 'lang' => '*', 'value' => $new]);
	}

function web_settings_tree($lang) {
	global $html;
	global $con;
	$tree = "<ul>";
	$langs = $con['langs'];
	$lang = $lang == '*' ? $con['ln'] : $lang;
	foreach ($langs as $k => $v) {
		$state = $lang == $k ? "open" : "closed";
		$item = [
			"caption"	=> $con['langs'][$k],
			"link"		=> "{$html['myurl']}?_id=web_settings&amp;sid={$html['sid']}&amp;lang=$k",
			"state"		=> $state
			];
		$tree .= list_item($item);
		}
	$tree .= "</ul>\n";
	return $tree;
	}

function get_all_styles() {
	global $html, $website;
	$styles = [];
	foreach(glob("{$html['dir']}/css/themes/*.css") as $file) {
		if ($website['css_generation'] == 2 and preg_match("/^yo\-/", basename($file))) {array_push($styles, basename($file));}
		elseif ($website['css_generation'] == 1) {array_push($styles, basename($file));}
		}
	//if (!in_array($website['def_css'], $styles)) {$styles = [$website['def_css']];}
	return $styles;
	}
?>
