<?php
# plugin newsletter
# @Author: Rainer Imb <artbeeren>
# @Date:   2018-04-23 15:51:59
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-05-25T11:40:05+02:00
# @License: GPL 2.0

/**
 * send_mail is public
 */

class newsletter {
	public $mcnf = array();
	public $interval = 5; // 5 minutes according to cron job
	public $max_recipients = 40;
	public $limit_per_day = 1500;

	public function __construct(){
		$this->mcnf = read_settings(['group' => 'crm']);
		}

	public function plugin($html) {
		add_i18n('news'); // add News
		switch ($html['action']) {
			case ("newsletter_templates"): $html = $this->templates_admin($html); break;
			default: $html = $this->newsletter_form($html);
			}
		return $html;
		}

	private function newsletter_form($html) {
		$todo = clean_var(param('todo'), "w");
		$templ = clean_var(param('template'), "n");
		$addons = '';
		$settings = read_settings(['group' => 'cms']);

		$test = get_one_register(['action' => 'article']);
		if (isset($test['reg'])) {
			$a = i18n('insert_content');
			$addons = htmltag('button', ['type' => 'submit', 'name' => 'insco', 'value' => 1], $a)."&nbsp;";
			$addons .= htmltag('input', ['type' => 'text', 'class' => 'text loose', 'name' => 'last_newsletter', 'value' => $settings['last_newsletter']], '');
			$addons .= $this->build_select();
			}
		$test = get_one_register(['action' => 'gastro']);
		if (isset($test['reg'])) {
			$a = i18n('insert_menue');
			$addons = htmltag('button', ['type' => 'submit', 'name' => 'insmen', 'value' => 1], $a);
			}
		if ($addons) {$addons = htmltag('p', '', $addons);}

		$form = [
			"title"			=> i18n('newsletter'),
			"myconf"		=> "newsletter",
			"button_text"	=> i18n('send'),
			"button_fa"		=> 'envelope',
			"button_text"	=> i18n('send'),
			"button_after"	=> htmltag('button', 'type="submit" name="_test" value="1"', i18n('send_as_test').': '.$html['user']['email']),
			"html"			=> $html
			];

		$inputs = [
		'subject'	=> [
			'type'	=> 'text',
			'duty'	=> 1
			],
		'level'	=> [
			'caption'	=> i18n('send_to'),
			'type'		=> 'multicheck',
			'ltable'	=> 'clients_groups',
			'lid'		=> 'id',
			'lval'		=> 'name',
			'lord'		=> 'id',
			'default'	=> 1,
			'duty'		=> 1,
			"in_field_by_array" => $this->get_rec_per_group()
			],
		'text'	=> [
			'type'		=> 'wysiwyg',
			'config'	=> 'newsletter',
			'duty'		=> 1,
			'in_label'	=> $addons
			]
		];

		if ($templ) {
			$data = $this->get_templ($templ);
			$inputs['text']['value'] = $data['body'];
			$inputs['subject']['value'] = $data['subject'];
			}

		$obj = new access($form);
		$sending = array();
		$return = true;

		if (param('insco')) {
			require_once('news_generator.php');
			$inputs = $obj->get_params($inputs);
			$content = generate_newsletter();
			if (preg_match("/\{content\}/", $inputs['text']['value'])) {
				$inputs['text']['value'] = preg_replace("/\{content\}/", $content, $inputs['text']['value']);
				}
			else {$inputs['text']['value'] .= $content;}
			}

		if (param('insnews')) {
			require_once('news_generator.php');
			$inputs = $obj->get_params($inputs);
			$data = $this->get_article(param('selArticle'));
			$content = generate_article_newsletter($data);
			if (preg_match("/\{content\}/", $inputs['text']['value'])) {
				$inputs['text']['value'] = preg_replace("/\{content\}/", $content, $inputs['text']['value']);
				}
			else {$inputs['text']['value'] .= $content;}
			}

		if (param('insmen')) {
			require_once('gastro_generator.php');
			$inputs = $obj->get_params($inputs);
			$gen = new gastro_generator();
			list($c, $t) = $gen->generate_newsletter();
			if (preg_match("/\{content\}/", $inputs['text']['value'])) {
				$inputs['text']['value'] = preg_replace("/\{content\}/", $c, $inputs['text']['value']);
				}
			else {$inputs['text']['value'] .= $c;}
			if (!$inputs['subject']['value']) {$inputs['subject']['value'] = $t;}
			}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$sending = $this->get_addressees();
				$return = false;
				}
			}
		elseif (param('_test')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				array_push($sending, $html['user']['email']);
				}
			}

		if (count($sending)) {
			$cnt = count($sending);
			$mail = [
				'Subject'	=> $inputs['subject']['value'],
				'html'		=> $inputs['text']['value'],
				'Tos'		=> $sending
				];
			// send imediately
			if ($cnt <= $this->max_recipients) {
				$error = $this->send_mail($mail);
				if ($error){$html['popup'] = $error;}
				else {$html['popup'] = i18n('send_newsletter')." ($cnt): ".implode(', ', $sending);}
				}
			// send with cron-job
			else {
				$this->save_mail($mail);
				$h = sprintf('%.2f', ($cnt/$this->max_recipients)/(60/$this->interval));
				if ($cnt >= $this->limit_per_day) {$h = sprintf('%.2f', ($cnt/$this->limit_per_day)*24);}
				$html['popup'] = $cnt.' '. i18n('sending_newsletter')." $h ".i18n('hours').': '.implode(', ', $sending);
				}
			}

		if ($return) {
			$obj->html_in($html);
			$obj->add_input($inputs);
			$submen = array(
					[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
					[i18n('newsletter'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", "far-envelope"],
					[i18n('templates'), $html['myurl']."?sid={$html['sid']}&amp;_id=newsletter_templates", "inactive", "far-file-text"]
					);
			$obj->before_form = make_submenu($submen);
			$html = $obj->form();
			}
		else {
			$html['content'] = say_mess($html['popup'], i18n('info'), 'checked');
			$html['popup'] = '';
			write_setting(['table' => 'cms_settings', 'key' => 'last_newsletter', 'group' => 'cms', 'lang' => '*', 'rule' => $con['rule'], 'value' => date('Y-m-d H:i:s')]);
			}

		$html['left'] = get_tab_tree($html, "clients", $form['myconf'], $this->get_tree());
		return $html;
		}

	private function templates_admin($html) {
			$rid = param('rid');
			$todo = clean_var(param('todo'), "w");

			$form = [
				"title"			=> i18n('templates'),
				"table"			=> "newsletter_templates",
				"myconf"		=> "newsletter_templates",
				"orderby"		=> "subject",
				"defsort"		=> "ASC",
				"human"			=> "subject",
				"html"			=> $html,
				"rid"			=> $rid,
				"search"		=> ['subject', 'body'],
				"table_fields"	=> ['subject', 'body', 'date']
				];

			$inputs = [
			'subject'	=> [
				'type'	=> 'text',
				'duty'	=> 1,
				],
			'body'	=> [
				'caption'	=> i18n('text'),
				'type'	=> 'wysiwyg',
				'duty'	=> 1,
				],
			'date'	=> [
				'caption'	=> i18n('updated'),
				'type'	=> 'readonly',
				'default' => date('Y-m-d')
				],
			];


			$obj = new access($form);

			if (param('_store')) {
				$inputs = $obj->get_params($inputs);
				if ($obj->error) {$todo = "edit"; $obj->error = 0;}
				else {
					$inputs['date']['value'] = date('Y-m-d');
					$id = $obj->store($inputs);
					$html['popup'] = $obj->feedback;
					}
				}

			if ($todo == "edit") {
				if (!$rid) {$obj->rid = "new";}
				elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
				if ($obj->error) {$html['content'] = $obj->feedback;}
				else {
					$obj->add_input($inputs);
					$html = $obj->form();
					}
				}
			// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
			elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
			else {
				$submen = array(
					[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
					[i18n('newsletter'), $html['myurl']."?sid={$html['sid']}&amp;_id=newsletter", "inactive", "far-envelope"],
					[i18n('templates'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", "far-file-text"]
					);
				$obj->before_table = make_submenu($submen);
				if (param('_del')) {$obj->delete();}
				$html = $obj->table($inputs);
				}
			$html['left'] = get_tab_tree($html, "clients", $form['myconf'], '');;
			return $html;
			}

	private function get_addressees() {
		global $db;
		$groups = param('level');
		foreach ($groups as $k=>$g) {$groups[$k] = clean_var($g, 'n');}
		$group = implode(',', $groups);
		$arg = $db->prepare("SELECT DISTINCT `email` FROM `clients` WHERE `promo` = ? AND `level` IN ($group);");
		$arg->execute(array('on'));
		$arr = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
		return $arr;
		}

	public function get_tree() {
		global $db, $html;
		$tree = '';
		$arg = $db->prepare("SELECT `id`, `subject` FROM `newsletter_templates` ORDER BY `subject`;");
		$arg->execute();
		while ($d = $arg->fetch(PDO::FETCH_ASSOC)) {
			$item = [
				"caption"	=> $d['subject'],
				"link"		=> "{$html['myurl']}?_id=newsletter&amp;sid={$html['sid']}&amp;template={$d['id']}",
				"state"		=> 'file-text-o'
				];
			$tree .= list_item($item);
			}
		return htmltag('ul', '', $tree);
		}

	public function get_templ($id) {
		global $db;
		$arg = $db->prepare("SELECT `body`, `subject` FROM `newsletter_templates` WHERE `id` = ?;");
		$arg->execute([$id]);
		$d = $arg->fetch(PDO::FETCH_ASSOC);
		return $d;
		}

	private function get_article($pid) {
		global $db;
		$q = "SELECT `content`.`id`, `pid`, `title`, `subtitle`, `lead`, `articlebody`, `picture`, `picturetext`, `copyright`,
`author`, `authorshort`, `file`, `articles`.`keywords`, `update`, `written`, `news_template`, `published`, `content`, `top` FROM `articles` LEFT JOIN `content` ON `articles`.`pid` = `content`.`id`
WHERE `content`.`id` = ?;"; // reset limit if necesarry
		$arg = $db->prepare($q);
		$arg->execute([$pid]);
		$rec = $arg->rowCount();
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		return $data;
		}

	private function build_select() {
		global $html;
		$form = [
				"table"			=> "content",
				"html"			=> $html
				];
		$obj = new access($form);
		$field = [
			'caption'	=> i18n('insert_news'),
			'me'		=> 'selArticle',
			'type'	=> 'lookup',
			"ltable"	=> "content",
			"lid"	=> 'id',
			"lval"	=> 'title',
			"lord"	=> 'written',
			"lsort"	=> 'DESC',
			"size"	=> 50,
			"limit"	=> 100,
			"absLimit"	=> 20,
			"lclause"	=> "`type` = 'article'",
			"value"		=> '',
			'in_body'	=> ' '.htmltag('button', ['type' => 'submit', 'name' => 'insnews', 'value' => 1], i18n('ok'))
			];

		$select = $obj->input_lookup($field);
		return $select;
		}

	private function save_mail($m) {
		global $db;
		$q = "INSERT INTO `newsletter_mailings` SET `date` = ?, `subject` = ?, `body` = ?;";
		$arg = $db->prepare($q);
		$arg->execute([date('Y-m-d'), $m['Subject'], $m['html']]);
		$mailing = $db->lastInsertId();
		foreach ($m['Tos'] as $email) {
			$q = "INSERT INTO `mailing_list` SET `email` = ?, `mailing` = ?;";
			$arg = $db->prepare($q);
			$arg->execute([$email, $mailing]);
			}
		}

	private function get_rec_per_group() {
		global $db;
		#SELECT `id` FROM `clients_groups`;
		#SELECT `level`, COUNT(`id`) FROM `clients` WHERE `promo` = 'on' AND `email` IS NOT NULL OR `email` != '' GROUP BY `level`;
		$q = "SELECT `id` FROM `clients_groups`;";
		$arg = $db->prepare($q);
		$arg->execute();
		$all = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
		foreach ($all as $v) {$recipients[$v] = '(0)';}
		$q = "SELECT `level`, COUNT(`id`) AS `count` FROM `clients` WHERE `promo` = 'on' AND (`email` IS NOT NULL OR `email` != '') GROUP BY `level`;";
		$arg = $db->prepare($q);
		$arg->execute();
		while ($v = $arg->fetch(PDO::FETCH_ASSOC)) {
			$recipients[$v['level']] = "({$v['count']})";
			}
		return $recipients;
		}

	public function send_mail($m) {
		require("other/PHPMailer/PHPMailerAutoload.php");
		if (!array_key_exists('From', $m)) {$m['From'] = $this->mcnf['reply'];}
		if (!array_key_exists('html', $m)) {$m['html'] = nl2br($m['text']);}
		// set absolute url for href and src
		$website = read_settings(['group' => 'cms']);
		$m['html'] = preg_replace('/(<a [^>]*href=")(\/[^"]+)("[^>]*>.*?<\/a>)/i', '${1}'.$website['website_url'].'${2}${3}' , $m['html']);
		$m['html'] = preg_replace('/(<img [^>]*src=")(\/[^"]+)("[^>]*\/?>)/i', '${1}'.$website['website_url'].'${2}${3}' , $m['html']);
		if (!array_key_exists('text', $m)) {$m['text'] = html2plain($m['html']);}
		$m['html'] = parse_in('cms_newsletter', $m);

		$mail = new PHPMailer;
		$mail->CharSet = "utf-8";
		// $mail->SMTPDebug = 4;
		$mail->isSMTP();
		$mail->SMTPKeepAlive = true;
		$mail->Host = $this->mcnf['smtp_host'];
		$mail->Port = $this->mcnf['smtp_port'];
		$mail->XMailer = "Consentio";
		$mail->SMTPAuth = true;

		// tls, ssl
		if ($this->mcnf['smtp_sec']) {
			$mail->SMTPSecure = strtolower($this->mcnf['smtp_sec']);
			$mail->SMTPOptions = [
			'ssl' => [
				'verify_peer' => false,
				'verify_peer_name' => false,
				'allow_self_signed' => true
				]];
			}
		else {$mail->SMTPAutoTLS = false;}
		$mail->Username = $this->mcnf['smtp_user'];
		$mail->Password = $this->mcnf['smtp_pwd'];
		$mail->setFrom($m['From']);
		//$mail->addReplyTo('', '');
		$mail->Subject = $m['Subject'];
		$mail->msgHTML($m['html']);
		$mail->AltBody = $m['text'];
		//$mail->addAttachment('file');
		$stat = 0;
		// send mail to each addressee (bcc is no option)
		foreach ($m['Tos'] as $email) {
			$mail->clearAddresses();
			$mail->addAddress($email);
			if (!$mail->send()) {$stat = $mail->ErrorInfo;}
			}
		// we have SMTPKeepAlive true
		$mail->smtpClose();
		return $stat;
		}
	}
?>
