<?php

/**
 * plugin news_pdf
 * @package consentio
 */

require_once('cocopdf.php');

class news_pdf {

	public $news;
	public $cols = [20, 105, 190];
	public $rows = [20, 140, 200, 285];
	public $ln = 4;
	public $fs = 10;
	public $or = 'P';
	public $mes = 'mm';
	public $size = 'A4';
	public $displMod = 'default';
	public $LineWidth = 0.1;
	public $black = '0,0,0';
	public $grey1 = '100,100,100';
	public $grey2 = '240,240,240';

	public function __construct(array$form){
		foreach($form as $k=>$v){$this->{$k}=$v;}
		}

	private function get_data() {
		global $db;
		$q = "SELECT `content`.`id`, `pid`, `title`, `subtitle`, `lead`, `articlebody`, `picture`, `picturetext`, `copyright`, `author`, `file`, `authorshort`, `update`, `written` FROM `articles` LEFT JOIN `content` ON `articles`.`pid` = `content`.`id` WHERE `content`.`id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute([$this->news]);
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		if ($data['picture']) {$data['picture'] = '../pictures/'.$data['picture'];}
		$data['file'] = preg_replace("/\.html$/", '', $data['file']);
		$data['file'] = preg_replace("/^\/content\//", '', $data['file']);
		list ($data['wdate'], $data['wtime']) = explode(' ', $data['written']);
		return $data;
		}

	public function make_pdf() {
		global $pdf, $website;
		$data = $this->get_data();
		$pdf = new cocoPDF($this->or,$this->mes,$this->size);
		$pdf->FooterLine = 70;
		$pdf->SetFooter('{pn}', 'R');
		$pdf->SetFooter('Modellbahn-Express - '.$data['wdate'], 'L');

		$pdf->AddPage();

		$pdf->SetDisplayMode($this->displMod);
		$pdf->SetCreator('Consentio CMS');
		$pdf->SetLineWidth($this->LineWidth);
		$pdf->SetDrawColor($this->grey1);
		$pdf->SetFillColor($this->grey2);
		$pdf->SetCellPadding(2);

		$ln = $this->ln;
		$fs = $this->fs;
		$rows = $this->rows;
		$cols = $this->cols;
		$y = $rows[0];
		$colwidth = $pdf->TextWidth;

		if ($data['picture']) {
			$b = $this->get_img($data['picture'], $colwidth);
			$pdf->Image($data['picture'], $cols[0], $y, $colwidth, false);
			$y += $b['height'];
			}
		if ($data['picturetext']) {
			$text = $pdf->hyphenation($data['picturetext']);
			$pdf->SetXY($cols[0], $y);
			$pdf->SetFont('Arial','', $fs-2);
			$pdf->MultiCell($colwidth, $ln+1, utf8_decode($text), '', 'L', 1);
			$y = $pdf->GetY();
			}

		if ($data['copyright']) {
			$pdf->SetXY($cols[0], $y);
			$pdf->SetFont('Arial','', $fs-2);
			$pdf->SetTextColor($this->grey1);
			$pdf->MultiCell($colwidth, $ln+1, utf8_decode('© '.$data['copyright']), '', 'R', 1);
			$pdf->SetTextColor(0,0,0);
			$y = $pdf->GetY() + $ln;
			}

		$pdf->SetCellPadding(0);

		// title
		$pdf->SetXY($cols[0], $y);
		$pdf->SetFont('Arial','B', $fs+8);
		$pdf->MultiCell($colwidth, $ln*2, utf8_decode($data['title']), '', 'L');
		$y = $pdf->GetY() + $ln;


		// subtitle
		if ($data['subtitle']) {
			$pdf->SetXY($cols[0], $y);
			$pdf->SetFont('Times','B', $fs+4);
			$pdf->MultiCell($colwidth, $ln*1.5, utf8_decode($data['subtitle']));
			$y = $pdf->GetY() + $ln;
			}

		$start = $y;
		$pdf->SetCols(['cols' => 2, 'starty' => $y, 'gap' => 7]);

		// lead
		$pdf->SetFont('Times','B', $fs);
		$colwidth = $pdf->ColWidth;
		$pdf->SetXY($cols[0], $y);
		$text = $pdf->hyphenation($data['lead']);
		$pdf->MultiCell($colwidth, $ln, utf8_decode($text));
		$y = $pdf->GetY() + $ln;
		$pdf->SetY($y);

		// text
    $parts = $this->parts($data['articlebody']);

	  // collect images for a better layout
	   $images = []; $lastIMG = -1;
		 $ftext = '';

	   foreach ($parts as $p) {
		   	$print = true; $makeLn = true; $al = 'J';
				if (array_key_exists('class', $p[2])) {
					if ($p[2]['class'] == 'copyright') {$p[0] .= 'co';}
					if ($p[2]['class'] == 'picturetext') {$p[0] .= 'pt';}
					}
				switch ($p[0]) {
					case 'p':
					case 'ul':
					case 'ol':
						$pdf->SetFont('Times','', $fs); break;
					case 'h1':
						$pdf->SetFont('Times','B', $fs+6); break;
					case 'h2':
						$pdf->SetFont('Times','B', $fs+4); break;
					case 'h3':
						$pdf->SetFont('Times','B', $fs+2); break;
					case 'h4':
						$pdf->SetFont('Times','', $fs+2); break;
					case 'h5':
						$pdf->SetFont('Times','', $fs); break;
					case 'pco':
						if (array_key_exists($lastIMG, $images)) {$images[$lastIMG]['copyright'] = $p[1]; $print = false;}
						else {$pdf->SetFont('Arial','', $fs-2); $al = 'R';}
						break;
					case 'ppt':
						if (array_key_exists($lastIMG, $images)) {$images[$lastIMG]['ptext'] = $p[1]; $print = false;}
						else {$pdf->SetFont('Arial','', $fs-2); $makeLn = false; $al = 'L';}
						break;
					case 'img':
						$lastIMG++;
						$images[$lastIMG] = ['src' => $p[2]['src']];
						$print = false; break;
					default:
						$pdf->SetFont('Times','', 10); break;
						break;
					}
				if ($print) {
					$ftext .= $pdf->hyphenation($p[1])."\n\n";
					}
			}

		if ($ftext) {
			$pdf->MultiCell($colwidth, $ln, utf8_decode($ftext), '', $al);
			$y = $pdf->GetY() + $ln;
			}

		$pdf->SetCellPadding(2);

		foreach ($images as $img) {
			$b = $this->get_img($img['src'], $colwidth);
			$c = $cols[0]+($pdf->CurCol - 1)*($colwidth+7);
			$y = $pdf->GetY() + $ln;

			if (($b['height'] + 3*$ln) + $y > $pdf->GetPageHeight()) {
				if ($pdf->CurCol < 2) {
					$c = $cols[0]+($pdf->CurCol)*($colwidth+7);
					$y = $pdf->ColsStart;
					$pdf->CurCol++;
					}
				else {
					$pdf->AddPage();
					$c = $cols[0];
					$y = $pdf->ColsStart;
					$pdf->CurCol = 1;
					}
				}
			$pdf->Image($b['file'], $c, $y, $colwidth, false);
			$y += $b['height'];

			if ($img['ptext']) {
				$pdf->SetXY($c, $y);
				$pdf->SetFont('Arial','', $fs-2);
				$pdf->MultiCell($colwidth, $ln+1, utf8_decode($img['ptext']), '', 'L', 1);
				$y = $pdf->GetY();
				}

			if ($img['copyright']) {
				$pdf->SetXY($c, $y);
				$pdf->SetFont('Arial','', $fs-2);
				$pdf->SetTextColor($this->grey1);
				$pdf->MultiCell($colwidth, $ln+1, utf8_decode($img['copyright']), '', 'R', 1);
				$pdf->SetTextColor(0,0,0);
				$y = $pdf->GetY() + $ln;
				}
			}
		ob_start(); // clean output
		$pdf->Output('I', $data['file'].'.pdf', true);
		ob_end_flush();
		}

	private function parts($text) {
		$text = strip_tags($text,"<img><p><h1><h2><h3><h4><h5><ul><ol><li><br>");
		$text = preg_replace('/[\n\r\t]/', ' ', $text);
		$text = preg_replace('/<br[^>]*>/i', "\n", $text); // break
		$text = preg_replace('/ {2,}/', ' ', $text); // only one space
		$text = str_replace('„', '"', $text);
		$text = str_replace('“', '"', $text);
		$text = str_replace('–', '-', $text);
		$text = html_entity_decode($text);
	  $dom = preg_split('/<(.*)>/U', $text, -1, PREG_SPLIT_DELIM_CAPTURE);
		$parts = [];
		$collect = false;
		foreach ($dom as $k => $elem) {
			$elem = trim($elem);
			if ($elem != '') {
				if ($k%2 == 0) {
					$text .= $elem; // can collect
				 	}
				else {
					if (substr($elem, 0, 1) == '/') {
						if (in_array($elem, ['/li'])) {$text .= "\n";} // collectors
						else {array_push($parts, [$tag, $text, $attr]);}
						}
					else {
						$a2 = explode(' ', $elem);
						$ntag = strtolower(array_shift($a2));
						$attr = [];
						foreach($a2 as $v) {
							if(preg_match('/([^=]*)=["\']?([^"\']*)/', $v, $a3))
							$attr[strtolower($a3[1])] = $a3[2];
							}
						if (in_array($ntag, ['p', 'ol', 'ul'])) {
							$tag = $ntag; $i = 1; $text = '';
							}
						elseif ($ntag == 'li') {
							if ($tag == 'ul') {$text .= chr(127).' ';} // bullet
							elseif($tag == 'ol')  {$text .= "$i "; $i++;}
							}
						elseif ($ntag == 'img') {array_push($parts, [$ntag, '', $attr]);} // has no end tag
						elseif ($ntag == 'br') {$text .= "\n";}
						else {$tag = $ntag; $text = '';}
						//echo " $ntag: $tag ";
						}
					}
				}
			}
		return $parts;
		}

	private function get_img($src, $width) {
		$a = pathinfo($src);
		$b['file'] = "../pictures/{$a['basename']}";
		list($w, $h) = getimagesize($b['file']);
		if ($w) {
			$qo = ($w*0.375)/$width;
			$b['height'] = ($h*0.375)/$qo;
			}
		return $b;
		}
	}

?>
