<?php

include_once('news_generator.php');

function plugin($html) {
	switch ($html['action']) {
		case ("rubric"): $html = rubrics($html); break;
		case ("news_settings"): $html = news_settings($html); break;
		default: $html = articles_admin($html);
		}
	return $html;
	}

function articles_admin($html) {
	$settings = read_settings(['group' => 'news']);
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$parent = clean_var(param('parent'), "n");
	list($mylang, $myparent, $ptype) = parents_def($parent);
	$form = form_by_type(1);
	$form['rid'] = $rid;
	$form['myconf'] = "article";
	$form['title'] .= " &ndash; ".i18n("articles");
	$form['left'] = [['table' => 'articles', 'foreign' => 'pid']];
	$orig_inputs = inputs_by_type('plugin');
	$inputs['type'] =	['type' => 'hidden', 'default' => ''];
	$inputs['folder'] =	['type' => 'hidden', 'value' => 0];

	$inputs = [
		'title' 	=> $orig_inputs['title'],
		'lang'		=> $orig_inputs['lang'],
		'show_title' =>	['type' => 'hidden', 'value' => ''],
		'type'		=>	['type' => 'hidden', 'default' => 'article'],
		'author'	=> [
			'type'	=> 'text',
			'default'	=> $html['user']['name']
			],
		'authorshort'	=> [
			'type'	=> 'text',
			'size'	=> 4,
			'max_size'	=> 3,
			'default'	=> $html['user']['short'],
			'table'	=> 1
			],
		'subtitle'	=> [
			'type'	=> 'text',
			'table'	=> 1
			],
		'lead'	=> [
			'type'	=> 'bigtext',
			'cols'	=>  70,
			'rows'	=>  7,
			'table'	=> 1,
			],
		'articlebody'	=> [
			'type'	=> 'wysiwyg',
			'caption'	=> i18n('text'),
			'duty'	=> 1,
			'table'	=> 1
			],
		'keywords' =>	[
			'caption'	=> i18n('add_tags'),
			'size'		=> 30,
			'type' => 'add_tags',
			"lid" => "id",
			"lval" => "keyword",
			"lord" => "keyword",
			"ltable" => "articles_keywords",
			'table'	=> 1
			],
		"label1"		=> [
			"caption"	=> i18n('picture'),
			"icon"		=> "image",
			"type"		=> "fieldset"
			],
		'picture'	=> [
			'type'	=> 'image',
			],
		'picturetext'	=> [
			'type'	=> 'text',
			'table'	=> 1,
			],
		'copyright'	=> [
			'type'	=> 'text',
			'table'	=> 1,
			],
		"label2"		=> $orig_inputs['label1'],
		"published"		=> [
			'type'		=> 'radio',
			'abbr'		=> get_icon('world', i18n('published')),
			'extra'		=> [i18n('offline'), i18n('published')],
			'icons'		=> ['offline', 'published'],
			'default'	=> 1
			],
		'top'	=> [
			'caption'	=> i18n('topnews'),
			'type'	=> 'flag',
			'table'	=> 1,
			],
		'parent' 		=> [
			'caption'	=> i18n('rubric'),
			'type' 		=> 'lookup',
			"lid"		=> "id",
			"lval"		=> "graduated",
			"lord"		=> "parentsort",
			"ltable"	=> "folder_view",
			"lclause"	=> "`type` IN('rubric')",
			'default' => $parent,
			'duty' => 1
			],
		'template' 		=> ['type'	=> 'hidden', 'value' => $settings['news_template']],
		'news_template' 	=> [
				'caption'	=> i18n('template'),
				'type'	=> 'array',
				'table'	=> 1,
				'duty'	=> 1,
				'default' => 1,
				'extra' =>  [i18n('article'), i18n('short_message'), i18n('no_img')]
				],
		'sort' 			=> $orig_inputs['sort'],
		'folder'		=> ['type'	=> 'hidden', 'value' => 0],
		'c_filter' 	=> $orig_inputs['c_filter'],
		'info' 	=> $orig_inputs['info'],
		'file' =>	[
			'type' => 'readonly'
			],
		'written' =>	[
			'type' => 'readonly',
			'default' => date('Y-m-d H:i:s'),
			],
		'update'		=> $orig_inputs['update'],
		'last_editor'		=> $orig_inputs['last_editor'],
		'cron'		=> [
			"icon"		=> "clock",
			"collapsed"	=> 1,
			"type"		=> "fieldset",
			"in_body"	=> "<p>".i18n('published').":</p>"
			],
		'c_start' =>	[
			'caption'	=> i18n('start'),
			'type' => 'date',
			'duty' => 1,
			'default' => '1970-01-01',
			],
		'c_end' =>	[
			'caption'	=> i18n('end'),
			'type' => 'date',
			'duty' => 1,
			'default' => '2500-12-31',
			]
		];

	$obj = new access($form);
	// $obj->set_attribute($inputs);


	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			if ($obj->rid == "new") {
				$inputs['file']['value'] = "/content/".clean_filename($inputs['title']['value'].".html", $html['dir']."/content");
				// try to keep sort-order if the user doesn't
				if ($inputs['sort']['value'] == 10) {
					raise_order($inputs['parent']['value'], 'article');
					reconf_parent("content", "short", "parent");
					}
				}
			$inputs['update']['value'] = date('Y-m-d H:i:s');
			$inputs['last_editor']['value'] = $html['user']['id'];
			if(param('force_new_title')) {
				unlink("{$html['dir']}{$inputs['file']['value']}");
				$inputs['file']['value'] = "/content/".clean_filename($inputs['title']['value'].".html", $html['dir']."/content");
				}
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			generate_article($obj->stored, $id);
			generate();
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {
			// what is my type, my language
			$test = inputs_by_type('test');
			$test = $obj->get_value($test);
			$mylang = $test['lang']['value'];
			$inputs = $obj->get_value($inputs);
			// could be set to 3 but it has no effect
			if ($inputs['published']['value'] > 2){$inputs['published']['value'] = 2;}
			$inputs['file']['in_body'] = '<br /><input id="ifcnt" type="checkbox" name="force_new_title" /> <label for="ifcnt">'.i18n('update_now').'</label>';
			}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$inputs['parent']['lclause'] .= " AND `lang` = '$mylang'";
			$inputs['lang']['default'] = $mylang;
			$obj->add_input($inputs);
			$html = $obj->form();
			/* short url?
			 echo strtolower(metaphone($inputs['title']['value'], 8)).strlen($inputs['title']['value']); */
			}
		}
	// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		if (param('_del')) {
			$records = $obj->get_multiple_values($inputs); // before we delete we need some values
			foreach ($records as $row) {
				if ($row['type'] != 'node') {unlink("{$html['dir']}{$row['file']}");}
				}
			$obj->delete();
			generate();
			}
		$obj->myconf = 'pages'; // return to pages...
		$obj->title = i18n("pages");
		$inputs = inputs_by_type('view');
		$submen = pages_tabs($parent);
		$obj->before_table = make_submenu($submen);
		$html = $obj->table($inputs);
		$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"[data-app='preview']\").popLink({header: '".i18n('preview')."', 'top': '5%', 'left': '1%', 'width': '1024', 'height': '600'});});</script>\n";
		}
	$html['left'] = content_tree($parent, "pages");
	return $html;
	}

function rubrics($html) {
	global $con;
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$parent = clean_var(param('parent'), "n");
	list($mylang, $myparent, $ptype) = parents_def($parent);
	$form = form_by_type(1);
	$form['rid'] = $rid;
	$form['myconf'] = "rubric";
	$form['left'] = [['table' => 'rubrics', 'foreign' => 'pid']];
	$inputs = inputs_by_type('plugin');
	$inputs['type'] =	['type' => 'hidden', 'default' => 'rubric'];
	$inputs['folder'] =	['type' => 'hidden', 'value' => 1];
	unset($inputs['cron']); unset($inputs['c_start']); unset($inputs['c_end']);
	$inputs['info']['end'] = 'art_limit';

	$inputs['parent'] = [
		'caption'	=> i18n('folder'),
		'type' 		=> 'lookup',
		"lid"		=> "id",
		"lval"		=> "graduated",
		"lord"		=> "parentsort",
		"ltable"	=> "folder_view",
		"lclause"	=> "`type` IN('root', 'rubric')",
		'default' => $parent,
		'duty' => 1
		];

	$inputs2 = [
		'art_limit'	=> [
			'type'	=> 'spin',
			'default'	=> 4,
			'size'	=> 3,
			'min'	=> 1,
			'max'	=> 20,
			],
		'top'	=> [
			'caption'	=> i18n('newsletter'),
			'type'	=> 'flag',
			'default'	=> 'on',
		],
		'rss'	=> [
			'type'	=> 'void',
			'default'	=> 'on',
			]
		];

	if ($con['ln'] != $mylang) {
		$inputs2['refer_to'] = [
		'type' 		=> 'lookup',
		"lid"		=> "id",
		"lval"		=> "graduated",
		"lord"		=> "parentsort",
		"ltable"	=> "folder_view",
		"lclause"	=> "`type` IN('rubric') AND `lang` = '{$con['ln']}'",
		'duty' => 1,
		'table' => 1
		];
		}

	if ($html['user']['level'] > 2) {
		$inputs3 = [
			"templates"		=> [
				"caption"		=> i18n('templates'),
				"icon"		=> "html",
				"type"		=> "fieldset"
				],
			'container' =>	[
				'caption'	=> i18n('r_container'),
				'type' => 'lookup',
				'default' => 'cms_articles_rubric',
				'duty' => 1,
				"lid" => "key",
				"lval" => "key",
				"lord" => "key",
				"lclause" => "`key` LIKE 'cms_articles_rubric%'",
				"ltable" => "html_snippets"
				],
			'teaser' =>	[
				'caption'	=> i18n('r_teaser'),
				'type' => 'lookup',
				'default' => 'cms_articles_teaser',
				'duty' => 1,
				"lid" => "key",
				"lval" => "key",
				"lord" => "key",
				"lclause" => "`key` LIKE 'cms_articles_teaser%'",
				"ltable" => "html_snippets"
				],
			'teaser_picture' =>	[
				'caption'	=> i18n('r_teaser')." ".i18n('picture'),
				'type' => 'lookup',
				'default' => 'cms_articles_teaser_picture_small',
				'duty' => 1,
				"lid" => "key",
				"lval" => "key",
				"lord" => "key",
				"lclause" => "`key` LIKE 'cms_articles_teaser_picture%'",
				"ltable" => "html_snippets"
				],
			'container_small' =>	[
				'caption'	=> i18n('r_container_small'),
				'type' => 'lookup',
				'default' => 'cms_articles_rubric_small',
				'duty' => 1,
				"lid" => "key",
				"lval" => "key",
				"lord" => "key",
				"lclause" => "`key` LIKE 'cms_articles_rubric%'",
				"ltable" => "html_snippets"
				],
			'teaser_small' =>	[
				'caption'	=> i18n('r_teaser_small'),
				'type' => 'lookup',
				'default' => 'cms_articles_teaser_small',
				'duty' => 1,
				"lid" => "key",
				"lval" => "key",
				"lord" => "key",
				"lclause" => "`key` LIKE 'cms_articles_teaser%'",
				"ltable" => "html_snippets"
				],

			];
		$inputs2 = array_merge($inputs2, $inputs3);
		}

	foreach ($inputs2 as $k=>$v) {$inputs2[$k]['table'] = 1;}
	$inputs = array_merge($inputs, $inputs2);

	$obj = new access($form);

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			if ($obj->rid == "new") {
				$inputs['file']['value'] = "/".clean_filename($inputs['title']['value'].".html", $html['dir']);
				}
			$inputs['update']['value'] = date('Y-m-d H:i:s');
			$id = $obj->store($inputs);
			reconf_parent("content", "short", "parent");
			$html['popup'] = $obj->feedback;
			generate();
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {
			$inputs = $obj->get_value($inputs);
			}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$inputs['parent']['lclause'] .= " AND `lang` = '$mylang'";
			if (intval($rid)) {
				$notin = check_dependencies("folder_view", $rid, "parent");
				if ($notin) {$inputs['parent']['lclause'] .= " AND $notin";}
				}
			$inputs['lang']['default'] = $mylang;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		if (param('_del')) {
			$records = $obj->get_multiple_values($inputs); // before we delete we need some values
			foreach ($records as $row) {
				if ($row['type'] != 'node') {unlink("{$html['dir']}{$row['file']}");}
				// delete components of this rubric
				$component = ['component' => "RUBRIC_{$row['id']}", 'lang' => $row['lang']];
				delete_component($component);
				$component['component'] = "RUBRIC_SMALL_{$row['id']}";
				delete_component($component);
				}
			$obj->delete();
			generate();
			}
		$obj->myconf = 'pages'; // return to pages...
		$obj->title = i18n("pages");
		$inputs = inputs_by_type('view');
		$submen = pages_tabs($parent);
		$obj->before_table = make_submenu($submen);
		$html = $obj->table($inputs);
		$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"[data-app='preview']\").popLink({header: '".i18n('preview')."', 'top': '5%', 'left': '1%', 'width': '1024', 'height': '600'});});</script>\n";
		}
	$html['left'] = content_tree($parent, "pages");
	return $html;
	}

function news_settings($html) {
	global $con;
	$form = [
		"title"			=> i18n('articles')." &ndash; ".i18n('settings'),
		"table"			=> "cms_settings",
		"myconf"		=> "news_settings",
		"human"			=> "name",
		"no_cancel" 	=> "1",
		"table_fields"	=> ["key", "value", "lang"],
		"html"			=> $html,
		];

	$inputs = [
		"group"			=> ['type' => "free", 'default' => "news"],
		"rule"			=> ['type' => "free", 'default' => $con['rule']],
		"lang"			=> ['type' => "free", 'default' => '*'],
		"top_news_limit"		=> [
			'type'		=> "spin",
			'size'		=> 2,
			'default'	=> 2,
			'min'		=> 1,
			'max'		=> 10,
			'interval'	=> 1
			],
		'news_template' =>	[
			'caption'	=> i18n('template'),
			'type'		=> 'lookup',
			'default'	=> 2,
			"lid"		=> "id",
			"lval"		=> "name",
			"lord"		=> "id",
			"ltable"	=> "templates",
			"lclause"	=> " where `id` > 1",
			'duty' => 1
			],
		'news_def_dim'	=> [
			'caption'	=> i18n('r_teaser')." ".i18n('picture'),
			'type'		=> 'array',
			'raw'		=> true,
			'extra'		=> ['small', 'cinemascope', 'thumbs', 'square']
			]
		];

	$obj = new access($form);

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {
			$obj->error = 0;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		else {
			$obj->store_settings($inputs);
			gen_all_articles();
			generate();
			$feedback = "<p>".$obj->feedback."</p><p><a href='{$html['myurl']}?_id=web_settings&amp;sid={$html['sid']}' class='as_button'>".i18n('ok')."</a></p>";
			$html['content'] = say_mess($feedback, i18n('info'), 'info');
			$html['formtitle'] =  i18n('articles')." &ndash; ".i18n('settings');
			}
		}
	else {
		$inputs = $obj->get_settings_value($inputs);
		$obj->add_input($inputs);
		$html = $obj->form();
		}
	$html['left'] = get_tab_tree($html, "pages", "news_settings", '');
	return ($html);
	}
?>
