<?php
# @Author: consentio
# @Date:   2023-06-23T14:39:02+02:00
# @Last modified by:   consentio
# @Last modified time: 2023-09-24T16:35:12+02:00

/**
 * plugin movielist
 * @package consentio
 */

class movielist {

	private $path = "movies";
	private $THpath = "mvthumbs";

	public function plugin($html) {
		switch ($html['action']) {
			case ("read_files"): $html = $this->read_files($html); break;
			default: $html = $this->movielist_admin($html);
			}
		return $html;
		}

	private function movielist_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$path = $html['dir'].'/'.$this->path.'/';

		$form = [
			"title"			=> i18n('movielist'),
			"table"			=> "movielist",
			"myconf"		=> "movielist",
			"orderby"		=> "title",
			"defsort"		=> "ASC",
			"human"			=> "title",
			"html"			=> $html,
			"rid"			=> $rid,
			"view"		=> 'tiles',
			"search"		=> ['title', 'ratio'],
			"table_fields"	=> ['thumbnail', 'title', 'duration']
			];

		$inputs = [
		'thumbnail'	=> [
			'type'	=> 'custom',
			'extra'	=> "<img src=\"/mvthumbs/++VALUE++\" width=\"500\"><input type=\"hidden\" name=\"thumbnail\"value=\"++VALUE++\">",
			'view'	=> "<img src=\"/mvthumbs/++VALUE++\" width=\"300\">",
			],
		'filename'	=> [
			'type'	=> 'custom',
			'extra'	=> "<video width=\"100%\" controls><source src=\"/$this->path/++VALUE++\" type=\"video/mp4\"></video><input type=\"hidden\" name=\"filename\"value=\"++VALUE++\">",
			'view'	=> "++VALUE++",
			],
		'title'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'tag'	=> [
			'caption'	=> i18n('tags', true),
			'size'		=> 30,
			'type' => 'add_tags',
			"lid" => "id",
			"lval" => "tag",
			"lord" => "tag",
			"ltable" => "movielist_tag"
			],
		'actors'	=> [
			'caption'	=> i18n('actors', true),
			'size'		=> 30,
			'type' => 'add_tags',
			"lid" => "id",
			"lval" => "actor",
			"lord" => "actor",
			"ltable" => "movielist_actor"
			],
		'ratio'	=> [
			'type'	=> 'text',
			],
		'duration'	=> [
			'type'	=> 'text',
			],
		'size'	=> [
			'type'	=> 'number',
			],
		];


		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
				[i18n('read'), $html['myurl']."?sid={$html['sid']}&amp;_id=read_files", "inactive", "refresh"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		// default tree shows plugins of group "plugins"
		$html['left'] = get_tab_tree($html, "plugins", $form['myconf'], "");;
		return $html;
		}

	private function read_files($html) {
		global $db;
		$arg = $db->prepare("SELECT MAX(`read`) AS `last` FROM `movielist`;");
		$arg->execute();
		if (!$arg->rowCount()) {$data['last'] = '1970-01-01 12:00:00';}
		else {$data = $arg->fetch(PDO::FETCH_ASSOC);}
		$path = $html['dir'].'/'.$this->path.'/';
		$thumb = $html['dir'].'/'.$this->THpath;
		$files = scandir($path);
		foreach ($files as $f) {
			$mime = mime_content_type($path.$f);
			$d = date("Y-m-d H:i:s.", filemtime($path.$f));
			if (strstr($mime, "video/") && $d > $data['last']){
				$json = json_decode(shell_exec('ffprobe -loglevel quiet -show_format -show_streams -print_format json -sexagesimal '.escapeshellarg($path.$f)), true);
				//echo $json->format->format_long_name;
				$codec = $json['streams'][0]['codec_name'];
				$ratio = isset($json['streams'][0]['display_aspect_ratio']) ? $json['streams'][0]['display_aspect_ratio'] : 'na';
				$duration = $json['format']['duration'];
				$durarr = explode(':', $duration);
				$half = floor($durarr[1]/3);
				$img = metaphone($f, 12).$half;
				exec("ffmpeg -ss 00:$half:01.00 -i '$path$f' -frames:v 1 $thumb/$img.jpg");
				if(!file_exists("$thumb/$img.jpg")) {exec("ffmpeg -ss 00:0:01.00 -i '$path$f' -frames:v 1 $thumb/$img.jpg");}
				$filesize = filesize($path.$f);
				$arg = $db->prepare('INSERT INTO `movielist` SET `title` = ?, `filename` = ?, `ratio` = ?, `duration` = ?, `size` = ?, `thumbnail` = ?;');
				$t = preg_replace('/\\.[^.\\s]{3,4}$/', '', $f);
				$arg->execute([$t, $f, $ratio, $duration, $filesize, $img.'.jpg']);
				}
			}
		$html = $this->movielist_admin($html);
		return $html;
		}
	}
?>
