<?php

/**
 * plugin monitor
 * @package consentio
 */

class monitor {
	private $services = ['80', '443', '25', '110', '995', '143', '993', '587', '21', '3306', '22'];

	public function plugin($html) {
		switch ($html['action']) {
			case ("SOMETHINGELSE"): $html = $this->SOMETHINGELSE_admin($html); break;
			default: $html = $this->sys_mon($html);
			}
		return $html;
		}

	private function sys_mon($html) {
		global $con;
		$c = '';
		$hostname = php_uname('n');
		$apache = apache_get_version();
		$cores = $this->getCpuCores();

		// OS
		if (!($os = shell_exec('/usr/bin/lsb_release -ds | cut -d= -f2 | tr -d \'"\''))) {
		    if(!($os = shell_exec('cat /etc/system-release | cut -d= -f2 | tr -d \'"\''))) {
		        if (!($os = shell_exec('find /etc/*-release -type f -exec cat {} \; | grep PRETTY_NAME | tail -n 1 | cut -d= -f2 | tr -d \'"\''))) {$os = 'N.A';}
		    	}
			}
		$os = trim($os, '"');
		$os = str_replace("\n", '', $os);

		// Kernel
		if (!($kernel = shell_exec('/bin/uname -r'))) {$kernel = 'N.A.';}

		// Uptime
		if (!($totalSeconds = shell_exec('/usr/bin/cut -d. -f1 /proc/uptime')))	{$uptime = 'N.A.';}
		else {$uptime = $this->sec2time($totalSeconds);}

		// Last boot
		if (!($upt_tmp = shell_exec('cat /proc/uptime'))) {$last_boot = 'N.A.';}
		else {
		    $upt = explode(' ', $upt_tmp);
		    $last_boot = date('Y-m-d H:i:s', time() - intval($upt[0]));
			}

		// Current users
		if (!($current_users = shell_exec('who -u | awk \'{ print $1 }\' | wc -l'))) {$current_users = 'N.A';}

		// Server datetime
		if (!($server_date = shell_exec('/bin/date'))) {$server_date = date('Y-m-d H:i:s');}

		$tasks = 'CPU MEM TIME USER COMM<br>';
		$a = shell_exec('ps -Ao %cpu,%mem,time,user,comm');
		$t = explode("\n", trim($a));
		foreach ($t as $k => $v) {
			$d = preg_split('/\s+/', trim($v));
			if (floatval($d[0]) > 0 || floatval($d[1]) > 0) {
				if (floatval($d[0]) >= 25) {$d[0] = htmltag('span', 'class="orange"', $d[0]);}
				elseif (floatval($d[0]) >= 50) {$d[0] = htmltag('span', 'class="red"', $d[0]);}
				else {$d[0] = htmltag('span', 'class="green"', $d[0]);}
				if (floatval($d[1]) >= 25) {$d[1] = htmltag('span', 'class="orange"', $d[1]);}
				elseif (floatval($d[1]) >= 50) {$d[1] = htmltag('span', 'class="red"', $d[1]);}
				else {$d[1] = htmltag('span', 'class="green"', $d[1]);}
				$tasks .= "{$d[0]}  {$d[1]}  {$d[2]} {$d[3]} {$d[4]}<br />";
				}
			}

		$vnstat = file_exists($html['dir'].'/graphics/vnstati1.png') ? htmltag('img', 'src="/graphics/vnstati1.png"', '').'<br />'.htmltag('img', 'src="/graphics/vnstati2.png"', '').'<br />'.htmltag('img', 'src="/graphics/vnstati3.png"', '').'<br />'.htmltag('img', 'src="/graphics/vnstati4.png"', '') : 'not available';

		$data = [
		    'hostname'      => $hostname,
			'apache'      	=> $apache,
			'cores'      	=> $cores,
		    'os'            => $os,
		    'kernel'        => $kernel,
		    'uptime'        => $uptime,
		    'last_boot'     => $last_boot,
		    'current_users' => $current_users,
		    'server_date'   => $server_date,
			'vnstat'   => $vnstat,
			'tasks'   => $tasks
			];

		if (($load_tmp = shell_exec('cat /proc/loadavg | awk \'{print $1","$2","$3}\''))) {
			$t = ['1min', '5min','15min',];
			foreach (explode(',', $load_tmp) as $k => $v) {
				$v = floatval($v);
				$val = intval(($v*100)/$cores);
				$val > 100 ? 100 : $val;
				$data[$t[$k]] = $this->progress(intval(($v*100)/$cores));
				}
			}

		foreach ($data as $k => $v) {$c .= htmltag('tr', '', "<th>$k</th><td>$v</td>");}
		$html['content'] = htmltag('table', 'class="table"', $c);
		$html['content'] .= htmltag('h2', '', 'last login');
		$html['content'] .= $this->last_login();
		$html['content'] .= htmltag('h2', '', 'disks');
		if ((exec('/bin/df -T | awk -v c=`/bin/df -T | grep -bo "Type" | awk -F: \'{print $2}\'` \'{print substr($0,c);}\' | tail -n +2 | awk \'{print $1","$2","$3","$4","$5","$6","$7}\'', $df))) {
			$mounted_points = [];
			$c = '';
		    foreach ($df as $mounted) {
				list($filesystem, $type, $total, $used, $free, $percent, $mount) = explode(',', $mounted);
				if ($type != 'tmpfs') {
					$total = sizeme($total * 1024);
					$used = sizeme($used * 1024);
					$free = sizeme($free * 1024);
					$bar = $this->progress(intval($percent));
					$c .= htmltag('li', '', "$filesystem ($type) mounted as $mount<br /> total: $total<br /> used: $used<br /> free: $free <br /> percent: $bar");
					}
		    	}
			$html['content'] .= htmltag('ul', '', $c);
			}

		$html['content'] .= htmltag('h2', '', 'memory');
		$free = 0;

		if (shell_exec('cat /proc/meminfo')) {
		    $free    = intval(shell_exec('grep MemFree /proc/meminfo | awk \'{print $2}\''));
		    $buffers = intval(shell_exec('grep Buffers /proc/meminfo | awk \'{print $2}\''));
		    $cached  = intval(shell_exec('grep Cached /proc/meminfo | awk \'{print $2}\''));
		    $free = intval($free + $buffers + $cached);
			}

		// Total
		if (!($total = intval(shell_exec('grep MemTotal /proc/meminfo | awk \'{print $2}\''))))	{$total = 0;}

		// Used
		$used = $total - $free;

		// Percent used
		$percent_used = 0;
		if ($total > 0) {$percent_used = 100 - (round($free / $total * 100));}

		$data = [
		    'used'          => sizeme($used * 1024),
		    'free'          => sizeme($free * 1024),
		    'total'         => sizeme($total * 1024),
		    'percent_used'  => $this->progress($percent_used),
			];
		$c = '';
		foreach ($data as $k => $v) {$c .= htmltag('tr', '', "<th>$k</th><td>$v</td>");}
		$html['content'] .= htmltag('table', 'class="table"', $c);
		$html['content'] .= htmltag('h2', '', 'swap');

		// Free
		if (!($free = intval(exec('grep SwapFree /proc/meminfo | awk \'{print $2}\'')))) {$free = 0;}

		// Total
		if (!($total = intval(exec('grep SwapTotal /proc/meminfo | awk \'{print $2}\'')))) {$total = 0;}

		// Used
		$used = $total - $free;

		// Percent used
		$percent_used = 0;
		if ($total > 0) {$percent_used = 100 - (round($free / $total * 100));}
		$data = [
		    'used'          => sizeme($used * 1024),
		    'free'          => sizeme($free * 1024),
		    'total'         => sizeme($total * 1024),
		    'percent_used'  => $this->progress($percent_used),
			];

		$c = '';
		foreach ($data as $k => $v) {$c .= htmltag('tr', '', "<th>$k</th><td>$v</td>");}
		$html['content'] .= htmltag('table', 'class="table"', $c);

		$html['content'] .= htmltag('h2', '', 'services');
		foreach ($this->services as $v) {
			$ser[$v] = $this->scanPort($v);
			}

		$c = '';
		foreach ($ser as $k => $v) {$c .= htmltag('tr', '', "<th>$k</th><td>$v</td>");}
		$html['content'] .= htmltag('table', 'class="table"', $c);

		$html['formtitle'] = i18n('monitor', true);
		$html['left'] = get_tab_tree($html, "settings", 'monitor', "");
		return $html;
		}

	private function sec2time($seconds) {
		$dt1 = new DateTime("@0");
  		$dt2 = new DateTime("@$seconds");
  		return $dt1->diff($dt2)->format('%a days, %h hours, %i minutes and %s seconds');
    	}

	private function progress($perc) {
		switch ($perc) {
			case $perc > 75: $col = '#FF6347'; break;
			case $perc > 50: $col = '#FFBE46'; break;
			default: $col = '#32CD32'; break;
		}
		$w = $perc*2;
		$bar = htmltag('div', "style=\"display:inline-block;text-align: center;background-color: $col;font-weight: bold; color: #fff;width:{$w}px;\"", " $perc%");
		$bar = htmltag('div', "style=\"display:inline-block;background-color: #eaeaea;width:200px;margin-bottom: 2px;\"", $bar);
		return $bar;
    	}

	private function getCpuCores() {
        if (!($num_cores = exec('/bin/grep -c ^processor /proc/cpuinfo'))) {
            if (!($num_cores = trim(shell_exec('/usr/bin/nproc')))) {$num_cores = 1;}
			$num_cores = intval($num_cores);
        	}
        if ($num_cores <= 0) {$num_cores = 1;}
        return $num_cores;
    	}

	private function scanPort($port, $protocol = 'tcp', $timeout = 3, $host = 'localhost') {
			$c = htmltag('span', 'class="red"', 'off');
			if ($protocol == 'tcp') {
				$handle = @fsockopen($host, $port, $errno, $errstr, $timeout);
				if ($handle) {$c = htmltag('span', 'class="green"', 'on');}
				else {$c .= " $errstr ($errno)";}
				}
			elseif ($protocol == 'udp') {
				$handle = @fsockopen('udp://'.$host, $port, $errno, $errstr, $timeout);
				socket_set_timeout($handle, $timeout);
				$write = fwrite($handle, 'x00');
				$startTime = time();
				$header = fread($handle, 1);
				$endTime = time();
				$timeDiff = $endTime - $startTime;
				fclose($handle);
				if ($timeDiff >= $timeout) {$c = htmltag('span', 'class="green"', 'on');}
				}
			return $c;
			}

	private function last_login () {
		$c = '';
		if ((exec('/usr/bin/lastlog --time 365 | /usr/bin/awk -F\' \' \'{ print $1";"$4, $6, $5, $7, $8, $3}\'', $users))) {
	        $max = 10;
        	for ($i = 1; $i < count($users) && $i <= $max; $i++) {
            	list($user, $date) = explode(';', $users[$i]);
				$c .= htmltag('li', '', "$user: $date");
				}
			if ($c) {$c = htmltag('ul', '', $c);}
        	}
		return $c;
    	}
	}
?>
