<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-06-16 13:36:16
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-05-25T11:33:52+02:00
# @License: GPL 2.0

/**
 * plugin inquiry
 * @package consentio
 */

class inquiry {

	public function plugin($html) {
		global $db, $website, $con;
		$rid = 'new';
		if (isset($html['user']['cid'])) {$rid = $html['user']['cid'];}
		$todo = 'edit';
		$type = param('type') ? clean_var(param('type'), 'ws') : 'inquiry';
		if (isset($con['formtype'])) {$type = $con['formtype'];}
		$html['myurl'] = $_SERVER['REQUEST_URI'];
		/* this mechanism should prevent
		bots from spoiling database */
		list($tan, $err) = get_before_post(7);

		$def = $this->get_def($type);
		$mess = $this->get_mess('forms', $html['user']['language']);
		$header = array_key_exists($def['header'], $mess) ? $mess[$def['header']] : "&mdash; No message found {$def['header']} ({$html['user']['language']}) &mdash;";
		$footer = array_key_exists($def['footer'], $mess) ? $mess[$def['footer']] : "&mdash; No message found {$def['footer']} ({$html['user']['language']}) &mdash;";
		$confirm = array_key_exists($def['confirmation'], $mess) ? $mess[$def['confirmation']] : "&mdash; No message found {$def['confirmation']} ({$html['user']['language']}) &mdash;";
		$focus = array_key_exists('no_af', $con) ? $con['no_af'] : 0;

		$form = [
			"title"			=> i18n($def['name']),
			"table"			=> "clients",
			"myconf"		=> "inquiry",
			"orderby"		=> "name",
			"human"			=> "name",
			"html"			=> $html,
			"rid"			=> $rid,
			"button_text"	=> i18n('ok'),
			"button_fa"		=> 'check',
			"no_cancel"		=> 1,
			"before_form"	=> $header,
			"after_form"	=> $footer,
			'no_af'			=> $focus,
			"skipTitle"			=> true
			];

		// get inputs from json
		if ($def['settings']) {
			$def['settings'] = preg_replace_callback("/i18n_(\w+)/", function($m) {return i18n($m[1]);}, $def['settings']);
			$inputs = json_decode($def['settings'], true);
			if (array_key_exists('salutation', $inputs)) {$inputs['salutation']['extra'] = [i18n('ms'), i18n('mr'), i18n('company')];}
			if (array_key_exists('salutation2', $inputs)) {$inputs['salutation2']['extra'] = [i18n('ms'), i18n('mr'), i18n('company')];}
			if (array_key_exists('company_line2', $inputs)) {$inputs['company_line2']['caption'] = i18n('nd_line');}
			if (array_key_exists('country', $inputs)) {$inputs['country']['default'] = $html['isoc'];}
			if (array_key_exists('notes', $inputs)) {
				if ($type == 'inquiry') {$inputs['notes']['caption'] = i18n('inquiry');}
				}
			}
		$inputs['tan']	= ['type'	=> 'hidden', 'value' => $tan];
		$inputs['type']	= ['type'	=> 'free', 'value' => $type];

		$obj = new access($form);

		if ($err) {
			if ($err == 1) {$obj->feedback .= i18n('incorrect_data');}
			if ($err == 2) {$obj->feedback .= i18n('mess_check');} # too fast
			$inputs = $obj->get_params($inputs);
			$todo = "edit";
			}
		elseif (param('_store')) {
			$inputs = $obj->get_params($inputs);

			// just some checks if a bot has passed get before post
			if ($this->check_inputs($inputs)) {$obj->error = 1; $obj->feedback = i18n('incorrect_data');}

			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$html['user']['cid'] = $obj->store($inputs);
				$html['is_stored'] = 1;
				remove_tan();
				$html['formtitle'] = i18n($def['name']);
				$html['content'] = $confirm;
				$todo = 'noop';
				$inputs = $obj->data_ref($inputs);
				// send mail to admin
				if ($rid == 'new') {
					$m['text'] = $obj->input2text($inputs);
					$m['text'] .= "\n---\n".$website['website_title']." - ".$website['website_url']."\nIP: ".$_SERVER['REMOTE_ADDR'];
					$m['Subject'] = i18n($def['name']);
					if ($inputs['email']['value']) {$m['From'] = $inputs['email']['value'];}
					$error = $this->send_mail($m);
					if ($error){$html['content'] = $error;}
					}
				}
			}

		if ($todo == "edit") {
			if ($rid != "new" && $err == 0) {$inputs = $obj->get_value($inputs);}
			else {$inputs = $obj->sanitize($inputs);}
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		return $html;
		}

	public function send_mail($m) {
		require("other/PHPMailer/PHPMailerAutoload.php");
		$mcnf = read_settings(['group' => 'crm']);
		if (!array_key_exists('From', $m)) {$m['From'] = $mcnf['reply'];}
		if (!array_key_exists('To', $m)) {$m['To'] = $mcnf['monitor'];}
		if (!array_key_exists('text', $m)) {$m['text'] = html2plain($m['html']);}
		if (!array_key_exists('html', $m)) {$m['html'] = nl2br($m['text']);}

		$mail = new PHPMailer;
		$mail->SMTPOptions = array(
		'ssl' => array(
			'verify_peer' => false,
			'verify_peer_name' => false,
			'allow_self_signed' => true
			)
		);
		$mail->CharSet = "utf-8";
		//$mail->SMTPDebug = 4;
		$mail->isSMTP();
		//$mail->SMTPKeepAlive = true;
		$mail->Host = $mcnf['smtp_host'];
		$mail->Port = $mcnf['smtp_port'];
		$mail->SMTPAuth = true;
		if ($mcnf['smtp_sec']) {$mail->SMTPSecure = strtolower($mcnf['smtp_sec']);} // tls, ssl
		else {$mail->SMTPAutoTLS = false;}
		$mail->Username = $mcnf['smtp_user'];
		$mail->Password = $mcnf['smtp_pwd'];
		$mail->setFrom($m['From']);
		$mail->addAddress($m['To']);
		if (array_key_exists('BCC', $m)) {$mail->addBCC($m['BCC']);}
		if (array_key_exists('ReplyTo', $m)) {$mail->addReplyTo($m['ReplyTo'], $m['ReplyToName']);}
		//$mail->Subject = '=?UTF-8?Q?'.quoted_printable_encode($m['Subject']).'?=';
		$mail->Subject = $m['Subject'];
		$mail->msgHTML($m['html']);
		$mail->AltBody = $m['text'];
		//$mail->addAttachment('file');
		$stat = 0;
		if (!$mail->send()) {$stat = $mail->ErrorInfo;}
		return $stat;
		}

	private function get_def($t) {
		global $db;
		$arg = $db->prepare("SELECT * FROM `crm_forms`;");
		$arg->execute();
		$def = array();
		while ($all = $arg->fetch(PDO::FETCH_ASSOC)) {
			$def[$all['name']] = $all;
			}
		if (isset($def[$t])) {$def = $def[$t];}
		else {$def = $def['inquiry'];}
		return $def;
		}

	private function get_mess($t, $l) {
		global $db, $con;
		$arg = $db->prepare("SELECT * FROM `crm_messages` where `group` = ? AND `lang` = ?;");
		$arg->execute([$t, $l]);
		$mess = array();
		while ($all = $arg->fetch(PDO::FETCH_ASSOC)) {
			if (preg_match("/<[^<]+>/",$all['value']) == 0) {
				$cl = 'class="lead"';
				if (preg_match("/_privacy$/", $all['key'])) {$cl = '';}
				$mess[$all['key']] = htmltag('p', $cl, nl2br($all['value'], true));
				}
			else {$mess[$all['key']] = $all['value'];}
			}
		return $mess;
		}

	private function check_inputs($in) {
		$c = false;
		// check double values
		if (array_key_exists('city', $in) && array_key_exists('street', $in)) {
			if ($in['city']['value'] && $in['city']['value'] == $in['street']['value']) {$c = true;}
			}
		if (array_key_exists('company', $in) && array_key_exists('company_line2', $in)) {
			if ($in['company']['value'] && $in['company']['value'] == $in['company_line2']['value']) {$c = true;}
			}
		if (array_key_exists('name', $in) && array_key_exists('prename', $in)) {
			if ($in['name']['value'] && $in['name']['value'] == $in['prename']['value']) {$c = true;}
			}
		// hrefs, tags in notes
		if (array_key_exists('notes', $in)) {
			if (preg_match("/<[^<]+>/", $in['notes']['value'])) {$c = true;}
			if (preg_match("/https?\:\/\//", $in['notes']['value'])) {$c = true;}
			}
		return $c;
		}

	}
?>
