<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-04-11 11:50:22
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2018-11-17 01:24:46
# @License: GPL 2.0



/**
 * qd image tools
 * @package consentio
 */

class img_tools {

	public function plugin($html) {
		$html = $this->tools($html);
		return $html;
		}

	private function tools($html) {
		$todo = clean_var(param('todo'), "w");

		$c = htmltag('li', '', htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=img_tools&amp;todo=rescale\"", 'Rescale all images'));
		$c .= htmltag('li', '', htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=img_tools&amp;todo=rescale&amp;_d=square\"", 'Rescale all images not in dir square'));
		$c .= htmltag('li', '', htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=img_tools&amp;todo=read\"", 'Read images form pictures which are not in image db'));
		$c .= htmltag('li', '', htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=img_tools&amp;todo=read_n\"", 'Read images form "normal" which are not in image db'));

		$html['content'] = htmltag('ul', '', $c);

		if ($todo == "read") {
			$a = param('a') ? param('a') : false;
			$text = $this->read_n_scale($a, '');
			$li = htmltag('li', '', htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=img_tools&amp;todo=read&amp;a=d\"", 'Delete them.'));
			$li .= htmltag('li', '', htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=img_tools&amp;todo=read&amp;a=s\"", 'Scale and insert them.'));
			$text .= htmltag('ul', '', $li);
			$html['content'] = say_mess($text, "Scale", 'info');
			}

		if ($todo == "read_n") {
			$a = param('a') ? param('a') : false;
			$text = $this->read_n_scale($a, 'normal/');
			$li = htmltag('li', '', htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=img_tools&amp;todo=read_n&amp;a=d\"", 'Delete them.'));
			$li .= htmltag('li', '', htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=img_tools&amp;todo=read_n&amp;a=s\"", 'Scale and insert them.'));
			$text .= htmltag('ul', '', $li);
			$html['content'] = say_mess($text, "Scale", 'info');
			}

		if ($todo == "scale") {
			$text = $this->read_n_scale(true);
			$html['content'] = say_mess($text, "Scale", 'info');
			}

		if ($todo == "rescale") {
			$text = $this->rescale();
			$html['content'] = say_mess($text, "Rescale", 'info');
			}

		$html['left'] = "Use at your own risk!";
		$html['formtitle'] = "Serious Strong Image Tools";
		return $html;
		}

	private function rescale() {
		global $db;
		$arg = $db->prepare("SELECT * FROM `image_db` ORDER BY `id` DESC;");
		$arg->execute();
		$i = 1; $text = "";
		// file must exist an has to be jpg, png or gif
		$mimes = ['image/jpeg', 'image/gif', 'image/png'];
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$file = "{$_SERVER['DOCUMENT_ROOT']}/pictures/{$data['filename']}";
			if (file_exists($file)) {
				$finfo = finfo_open(FILEINFO_MIME_TYPE);
				$mime = finfo_file($finfo, $file);
				if (in_array($mime, $mimes)) {
					if(param('_d')) {
						$dir = param('_d');
						if (!file_exists("{$_SERVER['DOCUMENT_ROOT']}/pictures/$dir/{$data['filename']}")) {scale_image($data['filename']);}
						}
					else {scale_image($data['filename']);}
					//$text .= "$mime, ";
					}
				$i++;
				}
			}
		$text .= " $i images were rescaled.";
		return $text;
		}

	private function read_n_scale($s, $d) {
		global $db;
		$files = scandir("{$_SERVER['DOCUMENT_ROOT']}/pictures/$d");
		$x = count($files);
		$i = 0; $text = "$x files found. "; $all = '';
		$scaled = 0;
		$mimes = ['image/jpeg', 'image/gif', 'image/png'];
		foreach ($files as $file) {
			$myfile = "{$_SERVER['DOCUMENT_ROOT']}/pictures/$d$file";
			if (!is_dir($myfile)) {
				$arg = $db->prepare("SELECT `filename` FROM `image_db` WHERE `filename` = ?;");
				$arg->execute([$file]);
				$c = $arg->rowCount();
				if ($c == 0) {
					$all .= "$file, ";
					if ($s == 'd') {
						if (file_exists($myfile)) {
							unlink($myfile);
							}
						}
					if ($s == 's') {
						if (file_exists($myfile)) {
							$finfo = finfo_open(FILEINFO_MIME_TYPE);
							$mime = finfo_file($finfo, $myfile);
							if (in_array($mime, $mimes)) {
								//if (!file_exists("{$_SERVER['DOCUMENT_ROOT']}/pictures/square/$file")) {scale_image($file); $scaled++;}
								scale_image($file);
								insert_image_db($file, 'import', '', 1);
								$scaled++;
								}
							}
						}
					$i++;
					}
				}
			}
		$all = htmltag('div', 'class="list" style="width: 700px; height: 400px;"', $all);
		$text .= "$s $i images not in db: $all";
		if ($scaled) {$text .= "scaled: $scaled";}
		return $text;
		}
	}
?>
