<?php

class ics {
	private $file;
	private $ics;
	private $lang = 'EN';
	private $df = 'Ymd\THis';
	private $data;
	private $prop = ['DTSTAMP', 'UID', 'DESCRIPTION', 'DTEND', 'DTSTART', 'LOCATION', 'SUMMARY', 'URI'];

	public function __construct(array$form){
		foreach($form as $k=>$v){$this->{$k}=$v;}
		foreach ($this->prop as $p) {
			if (!isset($this->data[$p])) {$this->data[$p] = NULL;}
			else {if (!is_array($this->data[$p])) {$this->data[$p] = trim(strip_tags($this->data[$p]));}}
			}
		$this->data['DTSTAMP'] = $this->format_timestamp('now');
		$this->lang = strtoupper($this->lang);
		}

	private function make_date() {
		for ($i=0; $i < count($this->data['DTSTART']) ; $i++) {
			$this->ics .= "BEGIN:VEVENT\r\n";
			foreach ($this->prop as $p) {
				if ($p == "DTSTART" || $p == "DTEND") {
					$d = $this->format_timestamp($this->data[$p][$i]);
					$this->ics .= "$p:$d\r\n";
					}
				elseif ($p == "UID") {
					$d = uniqid();
					$this->ics .= "$p:$d\r\n";
					}
				elseif ($this->data[$p]) {$this->ics .= "$p:{$this->data[$p]}\r\n";}
				}
			$this->ics .= "END:VEVENT\r\n";
			}
		}

	public function make() {
		$this->ics = "BEGIN:VCALENDAR\r\n";
		$this->ics .= "VERSION:2.0\r\n";
		$this->ics .= "METHOD:PUBLISH\r\n";
		$this->ics .= "PRODID:-//Consentio WebCMS//NONSGML Version 1//$this->lang\r\n";
		$this->ics .= "CALSCALE:VTIMEZONE\r\n";
		$this->ics .= "X-MS-OLK-FORCEINSPECTOROPEN:TRUE\r\n"; // do we hate ms?
		$this->make_date();
		$this->ics .= "END:VCALENDAR\r\n";
		return $this->ics;
		}

	public function export() {
		$this->make();
		if (!$this->file) {$this->file = trim($this->data['SUMMARY']);}
		$this->file = as_filename($this->file);
		header("Content-Type: text/calendar; charset=utf-8");
		header("Content-Disposition: attachment; filename=".$this->file.".ics");
		return $this->ics;
		}

	public function save($path) {
		global $con;
		$this->make();
		if (!$this->file) {$this->file = trim($this->data['SUMMARY']);}
		$this->file = as_filename($this->file).'.ics';
		$ICS = fopen("{$_SERVER['DOCUMENT_ROOT']}/documents/$path/{$this->file}", 'w');
		fwrite($ICS, $this->ics);
		fclose($ICS);
		return $this->file;
		}

	private function format_timestamp($timestamp) {
		$dt = new DateTime($timestamp);
		return $dt->format($this->df);
		}
  }

?>
