<?php

function plugin($html) {
	switch ($html['action']) {
		case ("help_groups"): $html = help_groups($html); break;
		default: $html = help_admin($html);
		}
	return $html;
	}
	
function help_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$parent = clean_var(param('parent'), "n");
	$do = $parent ? 1 : 0;
	$form = [
		"title"			=> i18n('settings')." &ndash; ".i18n('help_admin'),
		"table"			=> "help",
		"orderby"		=> "sort",
		"myconf"		=> "help_admin",
		"human"			=> "header",
		"html"			=> $html,
		"rid"			=> $rid,
		"search"		=> ["fulltext", "header", "body"],
		"filters"		=> ["parent"],
		"allow_box"		=> "both",
		"attr_to_set"	=> ["parent"],
		"table_fields"	=> ["header", "body", "tooltip", "parent", "sort"]
		];

	$inputs = [
		"header"	=> [
			"type"		=> "text",
			"duty"		=> 1
			],
		"tooltip"	=> [
			"type"		=> "text"
			],
		"body"			=> [
			"type"		=> "wysiwyg"
			],
		"parent"	=> [
			"caption"	=> i18n("chapter"),
			"type"		=> "lookup",
			"lval"		=> "graduated",
			"lord"		=> "parentsort",
			"ltable"	=> "help_folder",
			"duty"		=> 1,
			"default"	=> $parent
			],
		"sort" 		=> [
			"type"		=> "sort",
			"do"		=> $do
			]
		];

	$obj = new access($form);
	
	$obj->set_attribute($inputs);
	
	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], 0, 0);
		}
		
	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif (param('_set_att')) {
		$html = $obj->attr_form($inputs);
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;parent=$parent", "inactive", "add"],
			[i18n('chapter'), $html['myurl']."?sid={$html['sid']}&amp;_id=help_groups&amp;parent=$parent", "inactive", 0],
			[i18n($form['myconf']), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;parent=$parent", "active", 0]
			);
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		$html['content'] .= $obj->query;
		}

	$html['left'] = help_tree($parent, 'help_admin');
	return $html;
	}

function help_groups ($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$parent = clean_var(param('parent'), "n");
	$do = $parent ? true : false;
	$form = [
		"title"			=> i18n('settings')." &ndash; ".i18n('chapter'),
		"table"			=> "help_folder",
		"myconf"		=> "help_groups",
		"human"			=> "name",
		"orderby"		=> "sort",
		"filters"		=> ["parent"],
		"html"			=> $html,
		"rid"			=> $rid,
		"search"		=> array("name"),
		"table_fields"	=> array("name", "parent", "sort", "language"),
		"clause"		=> "`id` > 1"
		];

	$inputs = [
		"name"	=> [
			"type"		=> "text",
			"duty"		=> 1
			],
		"parent"	=> [
			"caption"	=> i18n("chapter"),
			"type"		=> "lookup",
			"lval"		=> "graduated",
			"lord"		=> "parentsort",
			"ltable"	=> "help_folder",
			"duty"		=> 1,
			"default"	=> $parent
			],
		"language"	=> [
			"type"		=> "text",
			"duty"		=> 1
			],
		"sort"		=> [
			"type"		=> "sort",
			"do"		=> $do
			]
		];

	$obj = new access($form);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], "parent", $parent);
		reconf_parent($form['table'], "name", "parent");
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			reconf_parent("help_folder", "name", "parent");
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$notin = intval($rid) ? check_dependencies("help_group", $rid, "parent") : "";
			$inputs['parent']['lclause'] = $notin;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;parent=$parent", "inactive", "add"],
			[i18n('chapter'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;parent=$parent", "active", 0],
			[i18n('help_admin'), $html['myurl']."?sid={$html['sid']}&amp;_id=help_admin&amp;parent=$parent", "inactive", 0]
			);		
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		$html['content'] .= $obj->query;
		}

	$html['left'] = help_tree($parent, 'help_groups');
	return $html;
	}
	
?>