<?php
# gs library manupulating pdfs
# @Author: Rainer Imb <imb>
# @Date:   2018-06-02 12:40:05
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2019-10-31 10:41:38
# @License: GPL 2.0

class gs {
	public $input = array();
	public $output = "output.pdf";
    private $dir = "../documents/";
    public $cmd = '';
	public $cmyk_icc = false;

	public function __construct(array$form){
		foreach($form as $k=>$v){$this->{$k}=$v;}
		}

    // merge pdfs
    public function merge() {
        $output = $this->dir.$this->output;
        $this->cmd = "gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=$output ";
        foreach($this->input as $file) {$this->cmd .= $this->dir.$file." ";}
        shell_exec($this->cmd);
        }

    // convert rgb to cmyk
    public function rgb2cmyk() {
		$icc = $this->cmyk_icc ? "-sDefaultCMYKProfile={$this->cmyk_icc}" : '';
        $output = $this->dir.$this->output;
        $file = $this->dir.$this->input[0];
        $this->cmd = "gs -q -dSAFER -dBATCH  -dNOPAUSE -dNOCACHE -sDEVICE=pdfwrite -sColorConversionStrategy=CMYK -dProcessColorModel=/DeviceCMYK -dDownsampleColorImages=false -dAutoFilterColorImages=false -dColorImageFilter=/FlateEncode $icc -sOutputFile=$output $file";
        shell_exec($this->cmd);
        }
	// convert rgb to grayscale
    public function rgb2gray() {
        $output = $this->dir.$this->output;
        $file = $this->dir.$this->input[0];
        $this->cmd = "gs -q -dSAFER -dBATCH  -dNOPAUSE -dNOCACHE -sDEVICE=pdfwrite -sColorConversionStrategy=Gray -dProcessColorModel=/DeviceGray -dDownsampleColorImages=false -dAutoFilterColorImages=false -dColorImageFilter=/FlateEncode -sOutputFile=$output $file";
		shell_exec($this->cmd);
        }
}

?>
