<?php
# @Author: consentio
# @Date:   2018-08-18T16:58:32+02:00
# @Last modified by:   consentio
# @Last modified time: 2023-08-30T18:31:36+02:00




function plugin($html) {
	$first = "";
	if ($html['user']['level'] <= 2) {$first = '/documents';}
	$html['basedir'] = $html['dir'].$first;
	switch ($html['action']) {
		case 'upload': $html = upload_form($html); break;
		case 'fsearch': $html = grep_form($html); break;
		default: $html = filemanager($html);
		}
	if (param('_store') == "silent") {
		$html['gui'] = 6;
		$html['content'] = $html['popup'] ? $html['popup'] : $html['feedback'];
		}
	return $html;
	}

function filemanager($html) {
	$basedir = $html['basedir'];
	$dir = clean_var(param('_d'), "l");
	$word = clean_var(param('_w'), "l");
	$pop = false;
	$files = false;
	$todo = false;
	clearstatcache();
	$uid = get_current_user();
	$gid = getmygid();

	if (param('_saf')) {
		$html['popup'] = save_file("$basedir/$dir");
		}

	if (param('_ndir')) {$html = make_dir($html, "$basedir/$dir");}

	if (param('_del') || param('_del_all')) {
		$files = param('rid');
		$file = clean_var(param('_del'), "w");
		if ($file) {$files = ["$file"];}
		if (is_array($files)) {$todo = 'ask';}
		else {$pop = i18n('no_selection');}
		}
	if (param('_set_att')) {
		$files = param('rid');
		if (is_array($files)) {$todo = 'move';}
		else {$pop = i18n('no_selection');}
		}

	if (param('todo') == 'new_dir') {
		$sub = tabs($dir);
		$sub = make_submenu(toggle_submen($sub, 2));
		$html = new_dir_dlg($html, $dir);
		}
	elseif (param('_f')) {$html = file_admin($html, $dir);}
	elseif (param('_get')) {$html = get_this_file($html, $dir);}
	elseif ($todo == 'ask') {$html = delete_dlg($html, $dir, $files);}
	elseif ($todo == 'move') {$html = move_dlg($html, $dir, $files);}
	else {
		if (param('_kif')) {$html['popup'] = delete_file("$basedir/$dir");}
		elseif (param('_move')) {$html['popup'] = move_file($basedir, $dir);}
		$dirs = explode("/", $dir);
		array_pop($dirs);
		$parent = end($dirs);
		$finfo = finfo_open(FILEINFO_MIME_TYPE);
		$files = scandir("$basedir/$dir");
		$dir_arr = array();
		$file_arr = array();
		$url = "{$html['myurl']}?_id=filemanager&amp;sid={$html['sid']}&amp;_d=";
		$count = 0;
		foreach ($files as $file) {
			$do = true; $count++;
			if($word) {if (!stristr($file, $word)) {$do = false;}} // very simple file search...
			if ($do) {
				$dfile = "$basedir/$dir/$file";
				if(is_readable($dfile)) {$info = file_info($dfile);}
				$open = get_icon("lock", i18n('no_permission'));
				$fopen = get_icon("no_edit", i18n('no_permission'));
				if(is_readable($dfile)) {
					$open = "<a href=\"$url$dir/$file\">".get_icon("folder-go", i18n('open'))."</a>";
					$href = "$dir/$file";
					if ($html['user']['level'] <= 2) {$first = '/documents';}
					else {$first = '';}
					$target = " target=\"_blank\"";
					if (preg_match('/php/', $info['mime'])) {$href = "$url$dir&amp;_get=$file"; $target = '';}
					$fopen = "<input type='checkbox' name='rid[$count]' id='rid[$count]' value='$file' data-app='check_all' /><label for='rid[$count]'>&nbsp;</label>";
					$fopen .= " <a href=\"$first$href\" $target>".get_icon("download", i18n('download'))."</a>&nbsp;";
					if (preg_match('/text\//', $info['mime'])) {$fopen .= "<a href=\"$url$dir&amp;_f=$file\">".get_icon("edit", i18n('edit'))."</a>&nbsp;";}
					$fopen .= "<a href=\"$url$dir&amp;_del=$file\">".get_icon("delete", i18n('delete'))."</a>";
					}
				if(is_dir($dfile)) {
					if (!in_array($file, ['.', '..'])) {
						$dir_arr[$file] = [
							'action'	=> $open,
							'mime'		=> $info['mime'],
							'name'		=> $file,
							'size'		=> $info['size'],
							'perms'		=> $info['perms'],
							'owner'		=> $info['owner'],
							'group'		=> $info['group'],
							'mtime'		=> $info['mtime']
							];
						}
					}
				else {
					$file_arr[$file] = [
						'action'	=> $fopen,
						'mime'		=> $info['mime'],
						'name'		=> $file,
						'size'		=> $info['size'],
						'perms'		=> $info['perms'],
						'owner'		=> $info['owner'],
						'group'		=> $info['group'],
						'mtime'		=> $info['mtime']
						];
					}
				}
			}

		$orderby = param('_ob') ? clean_var(param('_ob'), "l") : "name";
		$sortby = param('_sb') ? clean_var(param('_sb'), "n") : 0;

		usort($file_arr, sort_with($orderby));
		usort($dir_arr, sort_with($orderby));
		if ($sortby == 1) {
			$dir_arr = array_reverse($dir_arr);
			$file_arr = array_reverse($file_arr);
			}
		$all = array_merge($dir_arr, $file_arr);
		$data = array();

		if($dir) {
			$t = explode('/', $dir);
			array_pop($t);
			$ppath = implode('/', $t);
			array_unshift($data,['mime' => "<a href=\"$url$ppath\">".get_icon("parent", '')."</a>",	'name' => "..", 'size' => '', 'owner' => '', 'perms' => '', 'mtime' => ''] );
			}

		foreach ($all as $k=>$file) {
			if ($file['mime'] != 'directory') {$file['name'] = get_icon(mime_icon($file['mime']), $file['mime'])."&nbsp;".$file['name'];}
			$data[$k+1] = [
				'action'	=> $file['action'],
				'name'		=> $file['name'],
				'size'		=> sizeme($file['size']),
				'owner'		=> $file['owner'].".".$file['group'],
				'perms'		=> substr(decoct($file['perms']), -4),
				'mtime'		=> date("Y-m-d H:i:s", $file['mtime'])
				];
			}

		$sub = tabs($dir);
		$sub = toggle_submen($sub, 0);
		$dir = $dir ? $dir : "/";
		$search = searchform($word, $dir, $orderby, $sortby);

		$table = [
			"title"			=> i18n('filemanager'),
			"myconf"		=> "filemanager",
			"orderby"		=> $orderby,
			"defsort"		=> $sortby,
			"html"			=> $html,
			"before_table"	=> make_submenu($sub)."\n<h2>$dir</h2>".$search,
			"search"		=> ['name'],
			"filters"		=> ['_d'],
			"table_fields"	=> ["action", "name", "size", "owner", "perms", "mtime"],
			"allow_box"		=> 'both'
			];

		// data_table has no types, but a type that has no sort-mechanism makes sense
		$inputs = [
			'action' =>	['type' => 'radio'],
			'name' =>	['caption' => i18n('file'), 'css_td' => 'human'],
			'size' =>	[],
			'owner' =>	['type' => 'radio', 'caption' => i18n('owner')],
			'perms' =>	['type' => 'radio', 'caption' => i18n('permission')],
			'mtime' =>	['caption' => i18n('date')]
			];
		$obj = new access($table);
		$obj->push_data($data);
		$html = $obj->data_table($inputs);
		}
	if ($pop) {$html['popup'] = $pop;}
	$html['left'] = FTP_tree("filemanager", $basedir, $dir);
	return $html;
	}

function upload_form($html) {
	$basedir = $html['basedir'];
	$dir = clean_var(param('_d'), "l");
	$sub = tabs($dir);
	$sub = toggle_submen($sub, 1);
	if (param('_store')) {
		$html['popup'] = upload("$basedir/$dir", 'filename', '');
		}
	else {
		$table = [
				"title"			=> i18n('upload'),
				"myconf"		=> "filemanager",
				"html"			=> $html,
				"before_form"	=> make_submenu($sub)."\n<h2>/$dir</h2>",
				"no_cancel"		=> 1
				];

			$inputs = [
				'name' =>	[
					'caption'	=> i18n('file'),
					'type'		=> 'file',
					'extra'		=> 'upload',
					'row2'		=> true
					],
				'_d' =>	[
					'type'		=> 'hidden',
					'default'	=> $dir
					]
				];
		$obj = new access($table);
		$obj->add_input($inputs);
		$html = $obj->form();

		$html['left'] = FTP_tree("upload", $basedir, $dir);
		$html['scripts'] .= uploadscript('ifilename');
		$html['formtitle'] .= bubble('uploads');
		}
	return $html;
	}

function file_admin($html, $dir) {
	$file = param('_f');
	$file_full = $html['basedir']."/";
	if ($dir) {$file_full .= "$dir/";}
	$file_full .= $file;
	$info = file_info($file_full);
	$wrte = is_writable($file_full);
	$heading = "{$info['icon']} $dir/$file ({$info['psize']})";
	$mtime = date("Y-m-d H:i:s", $info['mtime']);
	$md5 = md5_file($file_full);
	$lines = htmlentities(file_get_contents($file_full));
	$sub = tabs($dir);
	$sub = make_submenu(toggle_submen($sub, 0));
	$form = [
		"title"			=> i18n('filemanager'),
		"myconf"		=> "filemanager",
		"html"			=> $html,
		"before_form"	=> "$sub\n<h2>$heading</h2><p class='small'>$mtime MD5: $md5</p>",
		"submit"		=> "_saf"
		];
	$inputs = [
			'code'		=> [
				"type"		=> "bigtext",
				"syntax"	=> get_syntax($info['mime']),
				"duty"		=> 1,
				"rows"		=> 30,
				"cols"		=> 100,
				'default'	=> $lines
				],
			'name'		=>	[
				'caption'	=> i18n('file'),
				'type'		=> 'text',
				'default'	=> $file
				],
			'_d'		=>	[
				'type'		=> 'hidden',
				'default'	=> $dir
			],
			'last_pos'		=>	[
				'type'		=> 'hidden',
				'default'	=> clean_var(param('last_pos'), 'n')
				]
			];
	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['scripts'] .= "<script>$(document).ready(function () {
		var doc = myCodeMirror.getDoc();
		if ($('#ilast_pos').val()) {doc.setCursor({line: $('#ilast_pos').val(), ch: 1});}
		});
</script>";
	return $html;
	}

function delete_dlg($html, $dir, $files) {
	$fixdir = str_replace($html['dir'], '', $html['basedir'].$dir);
	$text = implode(', ', $files)." in $fixdir";
	$text = preg_replace("/_-\(o\)-_/", "<br />$text<br />", i18n('realy_delete'));
	$text = "<p class=\"red\">$text</p>";
	$form = [
		"title"			=> i18n('filemanager'),
		"myconf"		=> "filemanager",
		"html"			=> $html,
		"before_form"	=> $text,
		"submit"		=> "_kif",
		"button_text"	=> i18n('delete'),
		"button_fa"		=> 'trash-alt'
		];

	$inputs = [
			'_d'		=>	[
				'type'		=> 'hidden',
				'default'	=> $dir
				]
			];
	foreach ($files as $k => $file) {
		$inputs["_fdel[$k]"] = ['type' => 'hidden', 'default' => $file];
		}

	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['content'] = say_mess($html['content'], i18n('question'), "question");
	return $html;
	}

function move_dlg($html, $dir, $files) {
	$fixdir = str_replace($html['dir'], '', $html['basedir'].$dir);
	$text = implode(', ', $files)." in $fixdir";
	$text = "<p class=\"red\">$text</p>";
	$dirs = dir_select($html['basedir']);
	$form = [
		"title"			=> i18n('ftp'),
		"myconf"		=> "filemanager",
		"html"			=> $html,
		"before_form"	=> $text,
		"submit"		=> "_move",
		"button_text"	=> i18n('ok'),
		"button_fa"		=> 'check'
		];
	$inputs = [
			'_d'		=>	[
				'type'		=> 'hidden',
				'default'	=> $dir
				],
			'_newd'		=>	[
				'caption'	=> i18n('move_to'),
				'row2'		=> true,
				'type'		=> 'array',
				'raw'		=> true,
				'extra' 	=> $dirs,
				'duty'		=> 1,
				'default'	=> "$fixdir"
				]
			];

	foreach ($files as $k => $file) {
		$inputs["_fmove[$k]"] = ['type' => 'hidden', 'default' => $file];
		}

	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['content'] = say_mess($html['content'], i18n('question'), "question");
	return $html;
	}

function get_this_file($html, $dir) {
	$file = clean_var(param('_get'), "w");
	$download = file_get_contents($html['basedir']."/$dir/$file");
	$html['content'] = $download;
	header("Content-type: text");
	header("Content-Disposition: attachment; filename=$file");
	$html['gui'] = 6;
	return $html;
	}

function new_dir_dlg($html, $dir) {
	$sub = tabs($dir);
	$sub = make_submenu(toggle_submen($sub, 2));
	$form = [
		"title"			=> i18n('new_folder'),
		"before_form"	=> "$sub\n<h2>/$dir</h2>",
		"submit"		=> "_ndir",
		"html"			=> $html
		];
	$inputs = [
		"_new_dir_name"	=> [
			"caption" => i18n('new_folder'),
			"type" => "text",
			"duty"	=> 1
			],
		'_d'		=>	[
			'type'		=> 'hidden',
			'default'	=> $dir
			]
		];
	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['formtitle'] .= bubble('filemanager.newdir');
	return $html;
	}

function make_dir($html, $dir) {
	$ndir = clean_var(param('_new_dir_name'), "w");
	$ndir =	preg_replace("/\s/", "-", $ndir);
	$ndir = ansitrans($ndir);
	# make sure we have an unique site name
	$i = 1;
	while (file_exists("$dir/$ndir")) {
		$ndir = preg_replace("/_\d+$/", "", $ndir);
		$ndir .= "_$i";	$i++;
		}
	if (mkdir("$dir/$ndir", 0774)) {$html['popup'] = "$ndir ".i18n('mess_stored');}
	else {$html['popup'] = i18n('error').": $ndir ";}
	return $html;
	}

function sort_with($key) {
    return function ($a, $b) use ($key) {return strnatcasecmp($a[$key], $b[$key]);};
	}

function save_file($dir) {
	$code = param('code');
	$file = param('name');
	$f = fopen("$dir/$file", "wb");
	$fw = fwrite($f, $code);
	fclose($f);
	if ($fw === false) {return i18n('error');}
	else {return i18n('OK');}
	}

function delete_file($dir) {
	$files = param('_fdel');
	$feedback = '';
	foreach ($files as $file) {
		$check = unlink("$dir/$file");
		if ($check === false) {$feedback .= i18n("error").'<br />';}
		else {$feedback .= "\"$file\" ".i18n("mess_deleted").'<br />';}// code...
		}
	return $feedback;
	}

function move_file($base, $dir) {
	global $html;
	$files = param('_fmove');
	$newdir = param('_newd');
	$feedback = '';
	if ($dir != $newdir) {
		foreach ($files as $file) {
			copy("$base/$dir/$file", "{$html['dir']}/$newdir/$file");
			unlink("$base/$dir/$file");
			$feedback .= "$dir/$file -> $newdir/$file<br>";
			}
		}
	else {$feedback = i18n('same_dir');}
	return $feedback;
	}

# make tree
function FTP_tree($me, $base, $path) {
	global $html;
	$dirs = explode("/", $base);
	$dir = end($dirs);
	$tree = "";
	$subtree = next_dir($me, $base, '');
	$item = [
		"caption"	=> $dir,
		"link"		=> "{$html['myurl']}?_id=$me&amp;sid={$html['sid']}",
		"state"		=> "open",
		"color"		=> "green",
		"sub"			=> "<ul>$subtree</ul>"
		];
	$tree .= list_item($item);
	$tree = parse_in('gui_tree', ['treelist' => $tree]);
	return ($tree);
	}

function tabs($parent) {
	global $html;
	$subs = [
		[i18n('filemanager'), $html['myurl']."?sid={$html['sid']}&amp;_id=filemanager&amp;_d=$parent", "inactive", "folder-green"],
		[i18n('upload'), $html['myurl']."?sid={$html['sid']}&amp;_id=upload&amp;_d=$parent", "inactive", "package_go"],
		[i18n('new_folder'), $html['myurl']."?sid={$html['sid']}&amp;_id=filemanager&amp;_d=$parent&amp;todo=new_dir", "inactive", "folder_add"]
		];
	if ($html['user']['level'] > 2)
	array_push($subs, [i18n('search'), $html['myurl']."?sid={$html['sid']}&amp;_id=fsearch&amp;_d=$parent", "inactive", "search"]);
	return $subs;
	}

function searchform($word, $dir, $orderby, $sortby){
	global $html;
	$search_input = "<p><input type='text' class='text' name='_w' id='i_w' size='30' value='$word' placeholder='".i18n('search')."' />";
	$search_input .= "<input type=\"hidden\" id=\"i_d\" name=\"_d\" value=\"$dir\"  />\n";

	$s_button = "<button type='submit' name='_thiswords' value='1'><i class='fas fa-search fa-lg'></i> ".i18n('search')."</button>&nbsp;";

	$searchform = "
	<form name='searchform' action='{$html['myurl']}' method='get' enctype='application/x-www-form-urlencoded'>
	<input type='hidden' name='sid' value='{$html['sid']}' />
	<input type='hidden' name='_id' value='filemanager' />
	<input type='hidden' name='_ob' value='$orderby' />
	<input type='hidden' name='_sb' value='$sortby' />
	<div class='clrfx tlform'>
	<div class='col w6 first'>
	$search_input
	</div>
	<div class='col w6 last'>
	<p>$s_button</p>
	</div>
	</div>
	</form>";
	return $searchform;
	}

function grep_form($html) {
	$basedir = $html['basedir'];
	$dir = clean_var(param('_d'), "l");
	$mydir = $basedir.$dir;
	$sw = clean_var(param('q'), 'w');
	$url = "{$html['myurl']}?_id=filemanager&amp;sid={$html['sid']}&amp;_d=";
	$result = '';
	if ($sw) {
		exec('grep -i -w -r -n "'.$sw.'" '.$mydir, $output);
		foreach ($output as $bulk) {
			if (substr($bulk, 0, 5) == substr($basedir, 0, 5)) {
				list($f, $l, $m) = explode(':', $bulk, 3);
				$p = pathinfo($f);
				$gdir = str_replace($basedir, '', $p['dirname']);
				$m = htmlentities(trim($m));
				$f = htmltag('a', "href=\"$url$gdir&amp;_f={$p['basename']}&amp;last_pos=$l\"" , $gdir.'/'.$p['basename']);
				$result .= htmltag('p', '', "<strong>$f Line $l</strong><br> $m");
				}
			}
		}
	$form = [
		"title"			=> i18n('files').' '.i18n('search'),
		"myconf"		=> "fsearch",
		"html"			=> $html,
		"button_text"	=> i18n('ok'),
		"no_cancel"		=> 1,
		"before_form"	=> "<h2>$dir</h2>",
		'after_form' => $result
		];
	$inputs = [
		"q"	=> ["type" => "text", 'caption' => i18n('search'), "value" => $sw],
		"_d"	=> ["type" => "hidden", "value" => $dir]
		];
	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['left'] = FTP_tree("fsearch", $basedir, $dir);
	return $html;
	}
?>
