<?php

class download_list_generator {
	public $allowed = ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'csv', 'xml'];

	public function generate() {
			// as there might be new documents in the folder selected we
			// regenerate all downloadlists each time
			$this->gen_all();
			}

	private function gen_all() {
		global $db;
		$q = "SELECT `content`.`id`, `description`, `doc_folder` FROM `content` LEFT JOIN `download_list` ON `content`.`id` = `download_list`.`pid` WHERE `type` = 'download_list' order by `id` ASC;";
		$arg = $db->prepare($q);
		$arg->execute();
		$rec = $arg->rowCount();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$this->generate_page($data);
			}
		}

	private function generate_page($data) {
		global $db, $html;
		$content = $data['description'] ? htmltag('p', 'class="lead"', nl2br($data['description'], true)) : '';
		$list = '';
		$files = scandir($html['dir'].$data['doc_folder']);
		foreach ($files as $file) {
			$dfile = $html['dir'].$data['doc_folder'].'/'.$file;
			if(is_readable($dfile)) {$info = file_info($dfile);}
			if (!is_dir($dfile)) {
				if (in_array($info['ext'], $this->allowed)) {
					$info['link'] = $data['doc_folder'].'/'.$file;
					$info['name'] = preg_replace('/---?/', ' - ', $info['name']);
					$list .= parse_in('cms_download_list_item', $info);
					}
				}
			}
		if ($list) {$content .= htmltag('ul', 'class="neutral"', $list);}
		$q = "UPDATE `content` SET `body` = ?, `generate` = 1, `show_title` = 'on' WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($content, $data['id']));
		}

	}
?>
