<?php
# @Author: Rainer Imb <consentio>
# @Date:   2021-04-21 01:09:45
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: download_list.php
# @Last modified by:   consentio
# @Last modified time: 2021-04-28 05:44:33
# @License: GPL 2.0

class download_list {

	public function plugin($html) {
		switch ($html['action']) {
			case ("xxx"): $html = $this->xxx_admin($html); break;
			default: $html = $this->list_admin($html);
			}
		return $html;
		}

	private function list_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$parent = clean_var(param('parent'), "n");
		$source = clean_var(param('make'), "n");
		list($mylang, $myparent, $ptype) = parents_def($parent);
		$form = form_by_type(1);
		$form['rid'] = $rid;
		$form['myconf'] = "download_list";
		$form['title'] .= " &ndash; ".i18n("download_list", true);
		$form['left'] = [['table' => 'download_list', 'foreign' => 'pid']];
		$or_inputs = inputs_by_type('plugin');
		$or_inputs['type'] =	['type' => 'hidden', 'default' => 'download_list'];
		$or_inputs['folder'] =	['type' => 'hidden', 'value' => 0];
		$or_inputs['parent']['default'] = $parent;
		$dirs = dir_select($html['dir'].'/documents');

		$inputs2 = [
			'doc_folder' => [
				'type'		=> 'array',
				'raw'		=> true,
				'extra' 	=> $dirs,
				'duty'		=> 1,
				'table'		=> 1
				],
			'description' =>	[
				'caption' => i18n('text'),
				'type' => 'bigtext',
				"rows"		=> 3
				],
			];

		$in1 = array_slice($or_inputs, 0, 4);
		$in2 = array_slice($or_inputs, 4);
		$inputs = array_merge($in1, $inputs2, $in2);

		$obj = new access($form);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				if ($obj->rid == "new") {
					$inputs['file']['value'] = "/".clean_filename($inputs['title']['value'].".html", $html['dir']);
					}
				$inputs['update']['value'] = date('Y-m-d H:i:s');
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				generate();
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$inputs['parent']['lclause'] .= " AND `lang` = '$mylang'";
				$inputs['lang']['default'] = $mylang;
				$obj->add_input($inputs);
				$html = $obj->form();
				$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"#ishort\").title2short();});</script>\n";
				}
			}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			if (param('_del')) {
				$records = $obj->get_multiple_values($inputs); // before we delete we need some values
				foreach ($records as $row) {
					unlink("{$html['dir']}{$row['file']}");
					}
				$obj->delete();
				generate();
				}
			$obj->myconf = 'pages'; // return to pages...
			$obj->title = i18n("pages");
			$inputs = inputs_by_type('view');
			$submen = pages_tabs($parent);
			$obj->before_table = make_submenu($submen);
			$html = $obj->table($inputs);
			$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"[data-app='preview']\").popLink({header: '".i18n('preview')."', 'top': '5%', 'left': '1%', 'width': '1024', 'height': '600'});});</script>\n";
			}
		$html['left'] = content_tree($parent, "pages");
		return $html;
		}

	}
?>
