<?php
# @Author: consentio
# @Date:   2018-08-18T16:58:32+02:00
# @Last modified by:   consentio
# @Last modified time: 2023-08-13T13:06:03+02:00



function plugin($html) {
  $html = css_admin($html);
  return $html;
  }

function css_admin($html) {
    global $website, $con;
  	$file = param('_f') ? clean_var(param('_f'), 'l') : $website['def_css'];
  	$dir = param('_d') ? clean_var(param('_d'), 'l') : '';
  	$path = file_exists($html['dir']."/css/themes/$dir/$file") ? "/css/themes" : "/css";
    $file_full = $html['dir']."$path/$dir/$file";
  	$info = file_info($file_full);
  	$write = is_writable($file_full) ? '' : htmltag('span', 'class="red"', get_icon('warning', '').' '.i18n('permission').': '.i18n('none'));
  	$ns = $write ? true : false;

    if (param('_store')) {
		$ff = $html['dir']."/css/themes/$dir/$file";
		$html['popup'] = save_css($ff);
		// execute sass
		if ($info['ext'] == "scss") {
			$scss_files = [];
			$scss_files = [$file];
			if (preg_match("/^_/", $file)) {$scss_files = get_all_scss();}
			foreach ($scss_files as $fl) {
				$fff = $html['dir']."/css/themes/$dir/$fl";
				$out = preg_replace("/\/scss\//", '/', $fff);
				$out = preg_replace("/\.scss$/", '.css', $out);
				$sass = array_key_exists('sass', $con) ? $con['sass'] : 'sassc -M';
				exec ("$sass $fff $out", $o, $r);
				if ($r) {$html['popup'] .= "<br /> SASS: $fl can't execute sass. $r $sass $fff $out";}
				}
			}

		}

    $heading = "{$info['icon']} $file ({$info['psize']})";
	$css = file_get_contents($file_full);

    $form = [
		"title"			=> i18n('css_admin'),
		"myconf"		=> "cssadmin",
		"html"			=> $html,
		"before_form"	=> "<h2>$heading</h2>",
		"no_submit"		=> $ns,
		'button_after'	=> $write
		];
	$inputs = [
			'code'		=> [
				"type"		=> "bigtext",
				"syntax"	=> 'css',
				"duty"		=> 1,
				"rows"		=> 30,
				"cols"		=> 100,
				'default'	=> $css
				],
			'_f'		=>	[
				'caption'	=> i18n('file'),
				'type'		=> 'text',
				'default'	=> $file
				],
			'_d'		=>	[
				'caption'	=> i18n('dir'),
				'type'		=> 'text',
				'default'	=> $dir
				],
			'last_pos'		=>	[
				'type'		=> 'hidden',
				'value' 	=> param('last_pos')
				]
			];

	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['left'] = css_tree($dir.$file);
  $html['left'] .= color_picker(extract_colors($css));
	$html['scripts'] .= parse_in('css_authoring', [0]);
	return $html;
	}

function save_css($file) {
	$code = param('code');
	$f = fopen($file, "wb");
	$fw = fwrite($f, $code);
	fclose($f);
	if ($fw === false) {return i18n('error');}
	else {return $file.' '.i18n('mess_stored');}
	}

function extract_colors($string) {
    preg_match_all( '/(?ims)([a-z0-9, \s\.\:#_\-@]+)[\{\:]([^\}]*)\}/', $string, $arr);
    $colors = array('#000000');
    foreach ($arr[0] as $i => $x) {
        $selector = trim($arr[1][$i]);
        $rules = explode(';', trim($arr[2][$i]));
        foreach ($rules as $strRule) {
            if (!empty($strRule)) {
                $rule = explode(":", $strRule);
                $val = isset($rule[1]) ? trim($rule[1]) : '';
                preg_match('/\#\w{3,6}/', $val, $c);
                if (isset($c[0])) {array_push($colors, strtoupper($c[0]));}
                }
            }
        }
    $colorss = sort($colors);
    return array_unique($colors);
    }

function color_picker($custom) {
    $colors = [
        '000000' => 'black',
        '000080' => 'navy',
        '00008B' => 'darkblue',
        '0000CD' => 'mediumblue',
        '0000FF' => 'blue',
        '006400' => 'darkgreen',
        '008000' => 'green',
        '008080' => 'teal',
        '008B8B' => 'darkcyan',
        '00BFFF' => 'deepskyblue',
        '00CED1' => 'darkturquoise',
        '00FA9A' => 'mediumspringgreen',
        '00FF00' => 'lime',
        '00FF7F' => 'springgreen',
        '00FFFF' => 'aqua',
        '00FFFF' => 'cyan',
        '191970' => 'midnightblue',
        '1E90FF' => 'dodgerblue',
        '20B2AA' => 'lightseagreen',
        '228B22' => 'forestgreen',
        '2E8B57' => 'seagreen',
        '2F4F4F' => 'darkslategray',
        '32CD32' => 'limegreen',
        '3CB371' => 'mediumseagreen',
        '40E0D0' => 'turquoise',
        '4169E1' => 'royalblue',
        '4682B4' => 'steelblue',
        '483D8B' => 'darkslateblue',
        '48D1CC' => 'mediumturquoise',
        '4B0082' => 'indigo',
        '556B2F' => 'darkolivegreen',
        '5F9EA0' => 'cadetblue',
        '6495ED' => 'cornflowerblue',
        '66CDAA' => 'mediumaquamarine',
        '696969' => 'dimgray',
        '6A5ACD' => 'slateblue',
        '6B8E23' => 'olivedrab',
        '708090' => 'slategray',
        '778899' => 'lightslategray',
        '7B68EE' => 'mediumslateblue',
        '7CFC00' => 'lawngreen',
        '7FFF00' => 'chartreuse',
        '7FFFD4' => 'aquamarine',
        '800000' => 'maroon',
        '800080' => 'purple',
        '808000' => 'olive',
        '808080' => 'gray',
        '87CEEB' => 'skyblue',
        '87CEFA' => 'lightskyblue',
        '8A2BE2' => 'blueviolet',
        '8B0000' => 'darkred',
        '8B008B' => 'darkmagenta',
        '8B4513' => 'saddlebrown',
        '8FBC8F' => 'darkseagreen',
        '90EE90' => 'lightgreen',
        '9370DB' => 'mediumpurple',
        '9400D3' => 'darkviolet',
        '98FB98' => 'palegreen',
        '9932CC' => 'darkorchid',
        '9ACD32' => 'yellowgreen',
        'A0522D' => 'sienna',
        'A52A2A' => 'brown',
        'A9A9A9' => 'darkgray',
        'ADD8E6' => 'lightblue',
        'ADFF2F' => 'greenyellow',
        'AFEEEE' => 'paleturquoise',
        'B0C4DE' => 'lightsteelblue',
        'B0E0E6' => 'powderblue',
        'B22222' => 'firebrick',
        'B8860B' => 'darkgoldenrod',
        'BA55D3' => 'mediumorchid',
        'BC8F8F' => 'rosybrown',
        'BdB76B' => 'darkkhaki',
        'C0C0C0' => 'silver',
        'C71585' => 'mediumvioletred',
        'CD5C5C' => 'indianred',
        'CD853F' => 'peru',
        'D2691E' => 'chocolate',
        'D2B48C' => 'tan',
        'D3D3D3' => 'lightgrey',
        'D8BFD8' => 'thistle',
        'DA70D6' => 'orchid',
        'DAA520' => 'goldenrod',
        'DB7093' => 'palevioletred',
        'DC143C' => 'crimson',
        'DCDCDC' => 'gainsboro',
        'DDA0DD' => 'plum',
        'DEB887' => 'burlywood',
        'E0FFFF' => 'lightcyan',
        'E6E6FA' => 'lavender',
        'E9967A' => 'darksalmon',
        'EE82EE' => 'violet',
        'EEE8AA' => 'palegoldenrod',
        'F08080' => 'lightcoral',
        'F0E68C' => 'khaki',
        'F0F8FF' => 'aliceblue',
        'F0FFF0' => 'honeydew',
        'F0FFFF' => 'azure',
        'F4A460' => 'sandybrown',
        'F5DEB3' => 'wheat',
        'F5F5DC' => 'beige',
        'F5F5F5' => 'whitesmoke',
        'F5FFFA' => 'mintcream',
        'F8F8FF' => 'ghostwhite',
        'FA8072' => 'salmon',
        'FAEBD7' => 'antiquewhite',
        'FAF0E6' => 'linen',
        'FAFAD2' => 'lightgoldenrodyellow',
        'FDF5E6' => 'oldlace',
        'FF0000' => 'red',
        'FF00FF' => 'fuchsia',
        'FF00FF' => 'magenta',
        'FF1493' => 'deeppink',
        'FF4500' => 'orangered',
        'FF6347' => 'tomato',
        'FF69B4' => 'hotpink',
        'FF7F50' => 'coral',
        'FF8C00' => 'darkorange',
        'FFA07A' => 'lightsalmon',
        'FFA500' => 'orange',
        'FFB6C1' => 'lightpink',
        'FFC0CB' => 'pink',
        'FFD700' => 'gold',
        'FFDAB9' => 'peachpuff',
        'FFDEAD' => 'navajowhite',
        'FFE4B5' => 'moccasin',
        'FFE4C4' => 'bisque',
        'FFE4E1' => 'mistyrose',
        'FFEBCD' => 'blanchedalmond',
        'FFEFD5' => 'papayawhip',
        'FFF0F5' => 'lavenderblush',
        'FFF5EE' => 'seashell',
        'FFF8DC' => 'cornsilk',
        'FFFACD' => 'lemonchiffon',
        'FFFAF0' => 'floralwhite',
        'FFFAFA' => 'snow',
        'FFFF00' => 'yellow',
        'FFFFE0' => 'lightyellow',
        'FFFFF0' => 'ivory',
        'FFFFFF' => 'white'
        ];


	#just helping counters
	$i = 0;
	$colortable = "<!-- Webcolorpicker -->
    <div id='colorpicker' class='clrfx'>
		<form name='showcolor'>
		<h2>".i18n('color')."</h2>
		<div class='col w1 first'><a id='fillcin'>".get_icon('sync', i18n('fill_color'))."</a></div>
		<div class='col w9' id='viewcolor'>
		<p><input type='text' name='chex' id='chex' size='8' class='text' value='#FFFFFF' /></p>
        <p><input type='text' name='crgb' id='crgb' size='16' class='text' value='rgb(255,255,255)' /></p>
        </div>
		<div class='col w1 last'>
		<p><a id='fillcout'>".get_icon('arrow-alt-circle-right ', i18n('fill_color'))."</a></p>
		<p><br /><a id='rgbfillcout'>".get_icon('arrow-alt-circle-right ', i18n('fill_color'))."</a></p>
		</div>
		<div class='clrfx'>";

	foreach ($colors as $hex => $color) {
		$colortable .= "<div class='pal' style='background:#$hex' title='$color' data-val='#$hex'>&nbsp;</div>";
		}

	$colortable .= "</div>";
	$colortable .= "<div class='clrfx'> <h3>".i18n('used_colors')."</h3>";

	foreach ($custom as $c) {$colortable .= "<div class='pal' title='$c' style='background:$c' data-val='$c'>&nbsp;</div>";}

	$colortable .= "</div>
        <div id='f_firstcolor' style='background:#FFFFFF;' class='fill'>
		<input type='text' name='firstcolor' id='firstcolor' value='#FFFFFF' size='8' class='text' />
		</div>
	<div class='clrfx'>";
	for ($i=1;$i<11;$i++) {
		$colortable .= "<div class='pal' id='p$i'>&nbsp;</div>";
		}
	$colortable .= "</div>
        <div id='f_secondcolor' style='background:#000000' class='fill'>
		<input type='text' name='secondcolor' id='secondcolor' value='#000000' size='8' class='text' />
		</div>";
	$colortable .= "
		</form>
    </div>
	<!-- Webcolorpicker end-->";

	return($colortable);
	}

function css_tree($open) {
	global $html;
	$tree = "";
	$subtree = "<ul>";
	$path = "/css/themes";
    $files = scandir($html['dir'].$path);
	foreach ($files as $file) {
		if (preg_match('/\.css$/', $file)) {
			$item = [
                "caption"	=> $file,
                "link"		=> "{$html['myurl']}?_id=cssadmin&amp;sid={$html['sid']}&amp;_f=$file",
                "state"		=> 'css'
                ];
            $subtree .= list_item($item);
			}
		}
	// scan scss dir
	$state = "closed";
	$scss = scandir($html['dir'].$path."/scss/");
	$sub = "<ul>";
	foreach ($scss as $sass) {
		if (preg_match('/\.scss$/', $sass)) {
			$state = "scss/$file" == $open ? "open" : "closed";
			$item = [
				"caption"	=> $sass,
				"link"		=> "{$html['myurl']}?_id=cssadmin&amp;sid={$html['sid']}&amp;_f=$sass&amp;_d=scss",
				"state"		=> 'css'
				];
			$sub .= list_item($item);
			}
		}
	$sub .= "</ul>";
	$item = [
		"caption"	=> "SCSS",
		"link"		=> "",
        "state"		=> $state,
		"sub"	 	=> $sub
		];
	$subtree .= list_item($item);
	$subtree .= "</ul>";
    $item = [
        "caption"	=> i18n('settings'),
        "link"		=> "{$html['myurl']}?_id=settings&amp;sid={$html['sid']}",
        "state"		=> 'parent'
        ];
    $tree .= list_item($item);
	$item = [
        "caption"	=> "CSS",
        "link"		=> "",
        "sub"		=> $subtree,
        "state"		=> 'open'
        ];
    $tree .= list_item($item);
	$tree = parse_in('gui_tree', ['treelist' => $tree]);
	return ($tree);
	}

function get_all_scss() {
	global $html, $website;
	$styles = [];
	foreach(glob("{$html['dir']}/css/themes/scss/*.scss") as $file) {
		if ($website['css_generation'] == 2 and preg_match("/^yo\-/", basename($file))) {array_push($styles, basename($file));}
		elseif ($website['css_generation'] == 1) {array_push($styles, basename($file));}
		}
	return $styles;
	}
?>
