<?php

function plugin($html) {	
	switch ($html['action']) {
		case ("cowa_settings"): $html = cowa_settings($html); break;
		default: $html = cowafeed($html);
		}
	return $html;
	}
	
function cowafeed($html) {
	require_once('plugins/cowac.php');
	$cowa = read_settings(['group' => 'cowa']);
	$oCowa = new cowa($cowa);
	$html['content'] = $oCowa->embed('all');
	$html['gui'] = 2;
	$html['scripts']  .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"[data-app='popup']\").popLink({header: 'Open Street Map', 'top': '5%', 'left': '10%', 'width': '500', 'height': '500'});});</script>\n";
	$html['scripts'] .= "<script src='/js/jQcharts.js' type='text/javascript'></script>";
	return $html;
	}
	
function cowa_settings($html) {
	global $con;
	$form = [
		"title"			=> i18n('cowa')." &ndash; ".i18n('settings'),
		"table"			=> "cms_settings",
		"myconf"		=> "cowa_settings",
		"human"			=> "name",
		"no_cancel" 	=> "1",
		"table_fields"	=> ["key", "value", "lang"],
		"html"			=> $html,
		];
	
	$inputs = [
		"group"			=> ['type' => "free", 'default' => "cowa"],
		"rule"			=> ['type' => "free", 'default' => $con['rule']],
		"lang"			=> ['type' => "free", 'default' => '*'],
		"token"		=> [
			'type'		=> "text",
			'duty' => 1
			],
		"url"		=> [
			'caption'	=> i18n('cowa_url'),
			'type'		=> "text",
			'duty' => 1
			],
		'cowa_script' =>	[
			'type'		=> 'bigtext',
			'cols'		=> 100,
			'rows'		=> 15,
			'duty' => 1
			]
		];
	
	$obj = new access($form);
	
	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {
			$obj->error = 0;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		else {
			$component = ['component' => "COWA", 'title' => i18n('cowa'), 'html' => $inputs['cowa_script']['value'], 'lang' => '*', 'active' => 'on'];
			write_component($component);
			$inputs['cowa_script']['value']	= '';	
			$obj->store_settings($inputs);
			$feedback = "<p>".$obj->feedback."</p><p><a href='{$html['myurl']}?_id=cowa_settings&amp;sid={$html['sid']}' class='as_button'>".i18n('ok')."</a></p>";
			$html['content'] = say_mess($feedback, i18n('info'), 'info');
			$html['formtitle'] =  i18n('cowa')." &ndash; ".i18n('settings');
			}
		}
	else {
		$inputs = $obj->get_settings_value($inputs);
		$inputs['cowa_script']['value'] = read_component(['component' => 'COWA', 'lang' => '*']);
		$obj->add_input($inputs);
		$html = $obj->form();
		}
	$html['left'] = get_tab_tree($html, "misc", "cowa_settings", '');
	return ($html);
	}	
?>