<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-04-23 15:51:59
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-08-16T11:49:22+02:00
# @License: GPL 2.0

class basic_crm {

	private $crm_form = [];
	private $crm_inputs = [];
	private $country = [];

	public function plugin($html) {
		switch ($html['action']) {
			case ("crm_settings"): $html = $this->crm_settings($html); break;
			case ("clients_groups"): $html = $this->clients_groups_admin($html); break;
			case ("crm_forms"): $html = $this->crm_forms($html); break;
			case ("crm_messages"): $html = $this->crm_messages($html); break;
			default: $html = $this->basic_crm_admin($html);
			}
		return $html;
		}

	private function basic_crm_admin($html) {
		global $website;
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$group = clean_var(param('level'), "n");
		$mcnf = read_settings(['group' => 'crm']);

		// modify form and inputs in crm.json to your needs
		$jsonfile = file_get_contents('plugins/crm.json');
		$jsonfile = preg_replace_callback("/i18n_(\w+)/", function($m) {return i18n($m[1]);}, $jsonfile);
		$jsonfile = str_replace("&&&&sid&&&&", $html['sid'], $jsonfile);
		$tid = is_array($rid) ? $rid[0] : $rid; // coming from delete-dialogue
		$jsonfile = str_replace("&&&&rid&&&&", $tid, $jsonfile);
		$json = json_decode($jsonfile, true);
		$form = $json['form'];
		$inputs = $json['inputs'];

		$form["title"] = i18n('clients')."/CRM";
		$form["html"] = $html;
		$form["rid"] = $rid;
		$form["attr_to_set"] = ['level'];
		$form["allow_box"] = "both";

		if (isset($inputs['salutation'])) {$inputs['salutation']['extra'] = [i18n('ms'), i18n('mr'), i18n('company')];}
		if (isset($inputs['promo'])) {$inputs['promo']['abbr'] = get_icon('envelope', i18n('promo'));}
		if (isset($inputs['company_line2'])) {	$inputs['company_line2']['caption'] = i18n('nd_line');}
		if (isset($inputs['country'])) {
			$inputs['country']['abbr'] = get_icon('world', i18n('country'));
			$inputs['country']['default'] = $website['country'];
			}
		if (isset($inputs['updated'])) {
			$inputs['updated']['caption'] = i18n('last_update');
			$inputs['updated']['default'] = date('Y-m-d H:i:s');
			}

		if (isset($inputs['editor'])) {
			$inputs['editor']['caption'] = i18n('author');
			}

		$obj = new access($form);
		$obj->set_attribute($inputs);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$inputs['updated']['value'] = date('Y-m-d H:i:s');
				$inputs['editor']['value'] = $html['user']['name'];
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				if ($obj->rid != 'new') {
					$icon = get_icon('far-address-card', i18n('vcard'))."&nbsp;".i18n('vcard');
					$obj->before_form = htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=basic_crm&amp;todo=edit&amp;rid=$rid&amp;vcard=1\" class=\"as_button\"", $icon);
					}
				$html = $obj->form();
				// export vcard if asked for
				if (param('vcard')) {
					unset($inputs['country']['abbr']);
					$html['content'] = $this->get_vcard($obj->parsable_data($inputs));
					$html['gui'] = 6;
					}
				}
			}
		elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = $this->clients_tabs($form['myconf'], $group);
			$submen = toggle_submen($submen, 1);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			// xlsxWriter
			if (@include_once("other/SimpleExcel/xlsxWriter.php")) {
				$obj->in_searchform = htmltag('p', '', '<input id="ixls" name="xls" type="checkbox" />&nbsp;<label for="ixls">'.i18n('export_xls').'</label>');
				}
			// FPDF
			if (@include_once("other/FPDF/fpdf.php")) {
				$obj->in_searchform .= htmltag('p', '', '<input id="ipdf" name="pdf" type="checkbox" />&nbsp;<label for="ipdf">'.i18n('PDF', true).'</label>');
				}
			$html = $obj->table($inputs);
			// export xls if asked for
			if (param('xls')) {
				$html['content'] = export_xlsx($obj->export_q, $obj->taint, i18n('clients'));
				$html['gui'] = 6;
				}
			// export pdf labels
			if (param('pdf')) {
				$html['content'] = $this->make_labels($obj->export_q, $obj->taint, i18n('clients'));
				$html['gui'] = 6;
				}
			}
		$html['left'] = get_tab_tree($html, "clients", $form['myconf'], $this->clients_tree($group, $form['myconf']));
		if (!isset($mcnf['smtp_pwd'])) {
			$html['left'] .= '<br />'.htmltag('p', 'class="red center"', get_big_icon('warning','')
			.'<br />'.i18n('no_SMTP'))
			.htmltag('p', 'class="center"', "<a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=crm_settings'>".i18n('ok')."</a>");}
		return $html;
		}

	private function clients_groups_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('clients_groups'),
			"table"			=> "clients_groups",
			"myconf"		=> "clients_groups",
			"orderby"		=> "id",
			"human"			=> "name",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['name', 'description'],
			"table_fields"	=> ['name', 'description'],
			"allow_del"		=> false,
			"allow_box"		=> false,
			"searchform"	=> false
			];

		$inputs = [
			'name'	=> [
				'type'	=> 'text',
				'duty'	=> 1,
				],
			'description'	=> [
				'type'	=> 'bigtext',
				],
			];


		$obj = new access($form);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = $this->clients_tabs($form['myconf'], $rid);
			$submen = toggle_submen($submen, 2);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		$html['left'] = get_tab_tree($html, "clients", $form['myconf'], "");
		return $html;
		}

	private function crm_settings($html) {
		global $con;
		$error = '';

		$form = [
			"title"			=> "CRM-".i18n('settings'),
			"table"			=> "cms_settings",
			"myconf"		=> "crm_settings",
			"human"			=> "name",
			"no_cancel" 	=> "1",
			"table_fields"	=> ["key", "value", "lang"],
			"html"			=> $html,
			];

		$inputs = [
			"group"			=> ['type' => "free", 'default' => "crm"],
			"rule"			=> ['type' => "free", 'default' => $con['rule']],
			"lang"			=> ['type' => "free", 'default' => '*'],
			"reply"			=> ['type' => "text", 'duty' => 1],
			"monitor"		=> ['caption' => i18n('admin_mail'), 'type' => "text", 'duty' => 1],
			"sender_name"		=> ['caption' => i18n('sender_name'), 'type' => "text", 'duty' => 1],
			"smtp"			=> [
				'caption' => "SMTP",
				'type' => "fieldset",
				"in_body" => '<p><button type="submit" name="_testmail" value="1">TEST</button></p>'

				],
			"smtp_host"	=> ['caption' => "SMTP Host",'type' => "text", 'duty' => 1],
			"smtp_sec"	=> [
				'caption' => "SMTP Secure",
				'type' => "array",
				'raw' => 1,
				'extra' => ['SSL', 'TLS']
				],
			"smtp_port"	=> ['caption' => "SMTP Port",'type' => "text", 'duty' => 1, 'default' => 587],
			"smtp_user"	=> ['caption' => "SMTP User",'type' => "text", 'duty' => 1],
			"smtp_pwd"	=> ['caption' => "SMTP Password",'type' => "text", 'duty' => 1]
			];

		$obj = new access($form);
		$submen = $this->clients_tabs('basic_crm', 0);
		$obj->before_form = make_submenu(toggle_submen($submen, 3));

		if (param('_store') || param('_testmail')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {
				$obj->error = 0;
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			else {
				$obj->store_settings($inputs);
				$error = '';
				if (param('_testmail')) {
					$m['text'] = "Testing Mail Account\n---\n\nIP: ".$_SERVER['REMOTE_ADDR'];
					$m['Subject'] = "Test Mail öüß jgdfj kjdskjf kjsdh fkjsdhkjfh dskjhfpüäö?\ßẞJDJHG JGKD z tuerz tuizreuizt iuerziu tre";
					$error = $this->test_mail($m);
					}
				$feedback = "<p>".$obj->feedback."<br />$error</p><p><a href='{$html['myurl']}?_id=crm_settings&amp;sid={$html['sid']}' class='as_button'>".i18n('ok')."</a></p>";
				$html['content'] = say_mess($feedback, i18n('info'), 'info');
				}
			}
		else {
			$inputs = $obj->get_settings_value($inputs);
			$obj->add_input($inputs);
			$html = $obj->form();
			}

		if ($error) {$html['feedback'] .= $error;}
		$html['left'] = get_tab_tree($html, "clients", $form['myconf'], "");
		return ($html);
		}

	private function crm_forms($html) {
		global $con;
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('forms'),
			"table"			=> "crm_forms",
			"myconf"		=> "crm_forms",
			"orderby"		=> "name",
			"human"			=> "name",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['name'],
			"searchform"	=> false,
			"allow_del"		=> false,
			"allow_box"		=> false,
			"table_fields"	=> ['name', 'active']
			];

		$inputs = [
			'name'	=> [
				'type'	=> 'text',
				'duty'	=> 1,
				],
			'active'	=> [
				'type'	=> 'flag',
				],
			'settings'	=> [
				'type'	=> 'bigtext',
				'duty'	=> 1,
				],
			'header'	=> [
				'type'	=> 'suggest',
				'ltable'	=> 'crm_messages',
				'lid'	=> 'id',
				'lval'	=> 'key',
				'lord'	=> 'key',
				'default' => 'inquiry_header'
				],
			'footer'	=> [
				'type'	=> 'suggest',
				'ltable'	=> 'crm_messages',
				'lid'	=> 'id',
				'lval'	=> 'key',
				'lord'	=> 'key',
				'default' => 'inquiry_privacy'
				],
			'confirmation'	=> [
				'type'	=> 'suggest',
				'ltable'	=> 'crm_messages',
				'lid'	=> 'id',
				'lval'	=> 'key',
				'lord'	=> 'key',
				'default' => 'inquiry_confirmation'
				]
			];

		$this->update_forms();

		$obj = new access($form);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			if (param('_del')) {$obj->delete();}
			$submen = $this->clients_tabs('crm_forms', 0);
			$obj->before_table = make_submenu(toggle_submen($submen, 3));
			$html = $obj->table($inputs);
			}

		$html['left'] = get_tab_tree($html, "clients", $form['myconf'], "");
		return ($html);
		}

	private function crm_messages($html) {
		global $con;
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('messages'),
			"table"			=> "crm_messages",
			"myconf"		=> "crm_messages",
			"orderby"		=> "key",
			"human"			=> "key",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['key', 'value'],
			"table_fields"	=> ['key', 'value', 'group', 'lang'],
			"clause"		=> "`group` = 'forms'",
			"button_after"	=> " <input name=\"_clone\" value=\"".i18n('duplicate')."\" class=\"button red yo-right\" type=\"submit\">"
			];

		$inputs = [
			'key'	=> [
				'type'	=> 'text',
				'duty'	=> 1,
				],
			'value'	=> [
				'type'	=> 'bigtext',
				'caption'	=> i18n('text'),
				'duty'	=> 1,
				],
			'group'	=> [
				'type'	=> 'readonly',
				'default' => 'forms'
				],
			'lang'	=> [
				'caption'	=> i18n('language'),
				'type'	=> 'array',
				'raw'	=> 1,
				'extra'		=> array_merge(['*'], array_keys($con['langs'])),
				'default' => $con['ln']
				],
			'rule'	=> [
				'type'	=> 'hidden',
				'default'	=> 1,
				],
			];


		$obj = new access($form);

		if (param('_clone')) {
			$inputs = $obj->get_value($inputs);
			$rid = 0;
			$inputs['key']['duty'] = 2;
			$obj->button_after = '';
			$obj->before_form = i18n('copy');
			$todo = 'edit';
			}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = $this->clients_tabs('crm_messages', 0);
			$obj->before_table = make_submenu(toggle_submen($submen, 3));
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		//$html['left'] = crm_settings_tree('mess');
		$html['left'] = get_tab_tree($html, "clients", $form['myconf'], "");
		return $html;
		}

	private function clients_tree($open, $action) {
		$roots = [
			"parent"	=> 0,
			"field"		=> "name",
			"pfield"	=> "level",
			"table"		=> "clients_groups",
			"sort"		=> "id",
			"open"		=> $open,
			"action"	=> $action
			];
		$tree = solo_tree($roots);
		$tree = parse_in('gui_tree', ['treelist' => $tree]);
		return $tree;
		}

	public function clients_tabs($me, $parent) {
		global $html;
		$subs = [
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id=$me&amp;todo=edit&amp;level=$parent", "inactive", "add"],
			[i18n('clients'), $html['myurl']."?sid={$html['sid']}&amp;_id=basic_crm&amp;level=$parent", "inactive", "far-address-card"],
			[i18n('clients_groups'), $html['myurl']."?sid={$html['sid']}&amp;_id=clients_groups", "inactive", "users"],
			["CRM &ndash; ".i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=crm_settings", "inactive", "wrench"]
			];
		if ($me == 'basic_crm') {$subs[0][3] = "far-address-card-add";}
		return $subs;
		}

	private function get_vcard($data) {
		global $conf;
		include_once('vcard.php');
		$vcard_data = [
			"first_name" => html_entity_decode($data['prename']),
			"last_name" => html_entity_decode($data['name']),
			"name_prefix" => html_entity_decode($data['salutation']),
			"title" => html_entity_decode($data['title']),
			"company" => isset($data['company']) ? html_entity_decode($data['company']) : '',
			"home_address" => html_entity_decode($data['street']),
			"home_city" => html_entity_decode($data['city']),
			"home_state" => html_entity_decode($data['province']),
			"home_postal_code" => $data['postal_code'],
			"home_country" => html_entity_decode($data['country']),
			"home_tel" => $data['phone'],
			"cell_tel" => $data['mobile'],
			"fax_tel" => $data['fax'],
			"email1" => $data['email']
			];
		$vcard = new vCard(['data' => $vcard_data, 'lang' => $conf['ln']]);
		return $vcard->export();
		}
	/*
	 * writes or deletes html-dummies for dynamic generation
	 */
	private function update_forms() {
		global $db, $con, $html;
		$arg = $db->prepare("SELECT `name`, `active` FROM `crm_forms`;");
		$arg->execute();
		while ($forms = $arg->fetch(PDO::FETCH_ASSOC)) {
			foreach (array_keys($con['langs']) as $lang) {
				$name = as_filename(sys_trans($forms['name'], $lang));
				if (!file_exists("{$html['dir']}/content/$name.html")) {
					//echo $forms['active'];
					if ($forms['active'] == 'on') {
						$data = ['id' => $forms['name'], 'defs' => "\$con['mylang'] = '$lang';\n\$con['formtype'] = '{$forms['name']}';"];
						$c = parse_in('cms_dynamic_html', $data);
						$f = fopen("{$html['dir']}/content/$name.html", 'w');
						fwrite($f, $c);
						fclose($f);
						}
					}
				else {
					if ($forms['active'] != 'on') {unlink("{$html['dir']}/content/$name.html");}
					}
				}
			}
		}

	private function make_labels($q, $t, $name) {
		global $db;
		$salut = ['', i18n('ms'), i18n('mr'), i18n('company')];
		$cols = [20, 115];
		$colw = $cols[1] - $cols[0] - 5;
		$rows = [20, 55, 90, 125, 160, 195, 230];
		$ln = 5;
		$col = 0; $row = 0;

		$pdf = new FPDF('P','mm','A4');
		ob_start(); // clean output
		$pdf->AddPage();
		$pdf->SetCreator('Consentio CMS');
		$pdf->SetFont('Arial','', 11);

		$arg = $db->prepare($q);
		$arg->execute($t);

		while ($d = $arg->fetch(PDO::FETCH_ASSOC)) {
			$content = '';
			if ($d['company']) {$content = $d['company']."\n";}
			if ($d['company_line2']) {$content .= $d['company_line2']."\n";}
			if ($d['name']) {
				if ($d['salutation'] < 3) {$content .= $salut[$d['salutation']]." ";}
				if ($d['title']) {$content .= $d['title']." ";}
				if ($d['prename']) {$content .= $d['prename']." ";}
				$content .= $d['name']."\n";
				}
			$content .= $d['street']."\n";
			$content .= $d['postal_code'].' '. $d['city']."\n";
			if ($d['province']) {$content .= $d['province']."\n";}
			if (array_key_exists($d['country'], $this->country)) {$cntry = $this->country[$d['country']];}
			else {
				$cntry = get_country_name($d['country']);
				$this->country[$d['country']] = $cntry;
				}
			$content .= $cntry;

			$pdf->SetXY($cols[$col], $rows[$row]);
			$pdf->MultiCell($colw, $ln, utf8_decode($content), 0, 'L');
			$col++;
			if ($col >= count($cols)) {$col = 0; $row++;}
			if ($row >= count($rows)) {
				$row = 0; $col = 0;
				$pdf->AddPage();
				}
			}
		$pdf->Output('I', $name.'.pdf', true);
		ob_end_flush();
		}

	private function test_mail($m) {
		require("other/PHPMailer/PHPMailerAutoload.php");
		$mcnf = read_settings(['group' => 'crm']);
		if (!array_key_exists('From', $m)) {$m['From'] = $mcnf['reply'];}
		if (!array_key_exists('Sender', $m)) {$m['Sender'] = $mcnf['sender_name'];}
		if (!array_key_exists('To', $m)) {$m['To'] = $mcnf['monitor'];}
		if (!array_key_exists('text', $m)) {$m['text'] = html2plain($m['html']);}
		if (!array_key_exists('html', $m)) {$m['html'] = nl2br($m['text']);}

		$mail = new PHPMailer;
		$mail->SMTPOptions = array(
		'ssl' => array(
			'verify_peer' => false,
			'verify_peer_name' => false,
			'allow_self_signed' => true
			)
		);
		$mail->CharSet = "utf-8";
		$mail->isSMTP();
		if (param('debug')) {$mail->SMTPDebug = SMTP::DEBUG_SERVER;}
		$mail->Host = $mcnf['smtp_host'];
		$mail->Port = $mcnf['smtp_port'];
		$mail->SMTPAuth = true;
		if ($mcnf['smtp_sec']) {$mail->SMTPSecure = strtolower($mcnf['smtp_sec']);} // tls, ssl
		else {$mail->SMTPAutoTLS = false;}
		$mail->Username = $mcnf['smtp_user'];
		$mail->Password = $mcnf['smtp_pwd'];
		$mail->setFrom($m['From'], $m['Sender']);
		$mail->addAddress($m['To']);
		$mail->Subject = $m['Subject'];
		$mail->msgHTML($m['html']);
		$mail->AltBody = $m['text'];
		$stat = 0;
		if (!$mail->send()) {$stat = $mail->ErrorInfo;}
		return $stat;
		}
	}
?>
