/**
 * @Author: consentio
 * @Date:   2021-10-26T14:04:48+02:00
 * @Project: Consentio CMS
 * @Filename: warehouse.sql
 * @Last modified by:   consentio
 * @Last modified time: 2022-01-25T11:17:54+01:00
 * @License: GPL 2.0
 * @Copyright: IMB Webdevelopment
 */



INSERT INTO `boxes` (`name`, `index`, `box`, `title`, `image`, `imagedir`) VALUES
('Webshop', 'WEBSHOP_BOX', 'cms_announces_box1', 'cms_announces_title1', 'cms_announces_img1', 'small');

INSERT INTO `content_types` (`type`, `name`, `icon`, `icon_add`, `new_in_type`, `generate`, `move`) VALUES
('goodsgroup', 'goodsgroup', 'sitemap-red', 'sitemap-add', 'root,goodsgroup', '0', '0'),
('products', 'products', 'cube-red', 'cube-add', 'goodsgroup', '0', '1');

INSERT INTO `components` ( `name`, `title`, `description`, `content`, `custom`, `active`, `lang`, `type`)
VALUES ('BASKET', 'Basket Dummy', '', '<span id="ajax-basket"><a href="/shop/?_o=2"><i class="fas fa-user fa-2x yo-btn"></i></a>\r\n<a href="/shop/?_o=1"><i class=\'fas fa-shopping-cart fa-2x yo-btn\'></i></a></span>', '', 'on', '*', '1');

INSERT INTO `i18n` (`index`, `group`, `en`, `de`) VALUES
('advices', 'webshop', 'Advices', 'Empfehlungen'),
('alwayssend', 'webshop', 'Send e-mail always', 'Immer benachrichtigen'),
('available', 'webshop', 'available', 'verfügbar'),
('currency', 'webshop', 'Currency', 'Währung'),
('declarations', 'common', 'Descriptions and Declarations', 'Texte und Erläuterungen'),
('default_tax', 'webshop', 'Default Tax', 'Standard Steuersatz'),
('emailto', 'webshop', 'E-Mail Notification to', 'E-Mail Benachrichtigung an'),
('freightno', 'webshop', 'Product No. of Freight', 'Artikelnummer Versandgebühr'),
('freighttax', 'webshop', 'Tax of Freight-Costs', 'Steuersatz bei Versandgebühren'),
('goodsgroup', 'common', 'Goods Group', 'Warengruppe'),
('mess_empty_basket', 'common', 'Your basket is empty.', 'Ihr Warenkorb ist leer.'),
('payment', 'common', 'Payment', 'Bezahlung'),
('product', 'common', 'Product', 'Produkt'),
('promotion', 'common', 'Promotion', 'Werbung'),
('tax', 'common', 'tax', 'Steuer'),
('shop', 'common', 'Warehouse', 'Warenwirtschaft'),
('webshop', 'common', 'Webshop', 'Webshop'),
('weight', 'webshop', 'Weight', 'Gewicht'),
('in_advance', 'common', 'Pay in Advance', 'Vorauskassa'),
('account_data', 'webshop', 'Account Data', 'Kontodaten'),
('order', 'common', 'Order', 'Bestellung'),
('address', 'webshop', 'Address', 'Adresse'),
('basket', 'webshop', 'Basket', 'Warenkorb'),
('total', 'common', 'Total', 'Gesamt'),
('without_freight', 'webshop', 'without freight', 'ohne Versandkosten'),
('invoice_address', 'webshop', 'Invoice Address', 'Rechnungsadresse'),
('delivery_address', 'webshop', 'Delivery Address', 'Lieferadresse'),
('read_GTC', 'webshop', 'I agee with the general terms and conditions.', 'Ich erkläre mich mit den AGB einverstanden.'),
('order_with_costs', 'webshop', 'Confirm Order Liable for Costs', 'Kostenpflichtig bestellen'),
('recalc', 'webshop', 'Recalculate', 'Neu berechnen'),
('provider', 'common', 'Provider', 'Hersteller'),
('new_client', 'common', 'New Client', 'Neue Kundin, neuer Kunde'),
('price', 'common', 'Price', 'Preis'),
('product_no', 'common', 'Product Number', 'Artikelnummer'),
('product_no_ext', 'webshop', 'External Product Number', 'Externe Artikelnummer'),
('unit', 'common', 'Unit', 'Einheit'),
('stock', 'webshop', 'Stock', 'Lager'),
('delivery', 'webshop', 'Delivery', 'Lieferung'),
('special_price', 'webshop', 'Special Price', 'Spezialpreis'),
('quantity_discount', 'common', 'Quantity Discount', 'Mengenrabatt'),
('quantity_for_discount', 'common', 'Quantity for Discount', 'Menge für Rabatt'),
('colour', 'webshop', 'Colour', 'Farbe'),
('whatever', 'webshop', 'Miscalanous', 'Sonstiges '),
('supplies', 'webshop', 'Supplies', 'Zubehör'),
('instead_of', 'webshop', 'instead of', 'anstatt'),
('reg_only', 'webshop', 'only for registered users', 'nur für registrierte Benutzer'),
('price_reg_only', 'webshop', 'Display price only for registered users', 'Preise nur für registrierte Benutzer anzeigen'),
('price_for_users', 'webshop', 'Price for Guests', 'Preis für Gäste'),
('price_for_reg', 'webshop', 'Price for registered Users', 'Preis für registrierte Benutzer'),
('incl_vat', 'common', 'incl. VAT', 'inkl. UST'),
('excl_vat', 'webshop', 'excl. VAT', 'exkl. UST'),
('ask_for_price', 'webshop', 'Prices on Application', 'Noch kein Verkauf möglich!'),
('pcs', 'common', 'pcs.', 'Stk.'),
('piece', 'webshop', 'piece', 'Stück'),
('pieces', 'webshop', 'pieces', 'Stück'),
('price_item', 'webshop', 'Unit Price', 'Einzelpreis'),
('order_form', 'webshop', 'Order Form', 'Bestellschein'),
('freight', 'webshop', 'Shipping Costs', 'Versandkosten'),
('open', 'webshop', 'open', 'offen'),
('partial', 'webshop', 'partial delivered', 'teilweise ausgeliefert'),
('delivered', 'webshop', 'delivered', 'ausgeliefert'),
('cancelled', 'webshop', 'cancelled', 'storniert'),
('deliver', 'webshop', 'Deliver', 'Ausliefern'),
('storno', 'webshop', 'Cancel Order', 'Stornieren'),
('order_confirmation', 'webshop', 'Order Confirmation', 'Auftragsbestätigung'),
('delivery_note', 'common', 'Delivery Note', 'Lieferschein'),
('invoice', 'common', 'Invoice', 'Rechnung'),
('will_be_delivered', 'webshop', 'will be delivered soon', 'wird demnächst ausgeliefert'),
('is_delivered', 'webshop', 'has already been delivered', 'wurde bereits ausgeliefert'),
('is_cancelled', 'webshop', 'is not available anymore', 'ist nicht mehr lieferbar'),
('got_order', 'webshop', 'You have got an order.', 'Sie haben eine Bestellung erhalten.'),
('miss_gtc', 'webshop', 'Please confirm our GTC.', 'Bitte stimmen Sie unseren AGB zu.'),
('mess_order_table', 'webshop', 'Overview of basket. Click Recalculate after alteration.', 'Warenkorb - Nach Änderungen auf Neu berechnen klicken.'),
('use_del', 'webshop', 'Deliver to this Address', 'An diese Adresse liefern'),
('your_basket', 'webshop', 'Your Basket', 'Ihr Warenkorb'),
('order_now', 'webshop', 'Order now', 'Jetzt bestellen'),
('price_input', 'webshop', 'Price Input', 'Preiseingabe'),
('confirmation_receipt', 'webshop', 'Confirmation Receipt', 'Empfangsbestätigung'),
('total_plus_tax', 'common', 'Total incl. VAT', 'Gesamt inkl. UST'),
('UIDof', 'webshop', 'VAT of benefit recipient', 'UID des Leistungsempfängers'),
('vat_no', 'webshop', 'VAT No.', 'UID'),
('add_to_basket', 'webshop', 'Add to Basket', 'In den Warenkorb'),
('i_am_user', 'webshop', 'I am already a customer', 'Ich bin schon Kunde'),
('become_user', 'webshop', 'I am new here', 'Ich bin neu hier'),
('sign_in', 'common', 'Sign in', 'Registrieren'),
('delivery_charges', 'common', 'Delivery Charges', 'Versandkosten'),
('invoice_total', 'common', 'Invoice Total', 'Endbetrag'),
('use_inv_addr', 'webshop', 'use invoice address', 'verwende Rechnungsadresse'),
('self_collect', 'webshop', 'Self collect', 'Selbst abholen'),
('reg_no', 'common', 'Commercial Register', 'Firmenbuch'),
('thank_you', 'webshop', 'Thank you very much for order', 'Vielen Dank für die Bestellung'),
('welcome', 'common', 'Welcome', 'Willkommen'),
('with_login', 'common', 'Easy access with username and password.', 'Mit Benutzername und Passwort in Zukunft leichter anmelden.'),
('low_stock', 'webshop', 'Only a few pieces left.', 'Nur noch wenige Stück verfügbar.'),
('out_of_stock', 'webshop', 'Temporarily out of stock', 'Zurzeit nicht mehr lagernd'),
('salut_m', 'common', 'Dear', 'Sehr geehrter'),
('error_payment', 'webshop', 'Please enter a method of payment.', 'Bitte geben Sie eine Bezahlmethode an.'),
('salut_f', 'common', 'Dear', 'Sehr geehrte'),
('turnover', 'webshop', 'Revenue', 'Umsatz'),
('new', 'common', 'new', 'neu'),
('coming_soon', 'webshop', 'coming soon', 'Demnächst verfügbar'),
('length', 'common', 'Length', 'Länge'),
('products', 'common', 'Products', 'Artikel'),
('only_products', 'common', 'Only Products', 'Nur Produktartikel'),
('val_of_goods', 'webshop', 'Value of Goods', 'Warenwert'),
('payed', 'common', 'payed', 'bezahlt'),
('ordered', 'webshop', 'ordered', 'bestellt'),
('waiting', 'common', 'pending', 'anhängig'),
('discount', 'webshop', 'Discount', 'Rabatt'),
('create', 'common', 'Create', 'Erstellen'),
('no_tax', 'webshop', 'Without Tax', 'Ohne Steuer'),
('max_order_quant', 'webshop', 'maximal order quantity', 'maximale Bestellmenge'),
('taxes', 'webshop', 'VATs', 'Steuersätze'),
('continue_shop', 'webshop', 'Continue shopping', 'Einkauf fortsetzen'),
('get_regular', 'webshop', 'Become a regular customer', 'Werden Sie Stammgast'),
('better_order', 'common', 'Easy ordering with username and password.', 'Einfacher bestellen mit Benutzername und Passwort.'),
('sign_paypal', 'webshop', 'Sign in and pay with PayPal', 'Mit PayPal anmelden und bezahlen'),
('guest', 'common', 'Guest', 'Gast'),
('sign_in_as', 'webshop', 'Sign in as...', 'Eintragen als...'),
('print_logo', 'webshop', 'Logo for print', 'Logo für Druck'),
('pattern', 'webshop', 'Pattern', 'Muster'),
('GTC', 'common', 'GTC', 'AGB'),
('pp_incomplete', 'webshop', 'Please finish your order with one of the payment-options.', 'Bitte versuchen Sie es erneut mit einer der Zahlungsoptionen.'),
('pp_error', 'common', 'An error occured. We will contact you.', 'Ein Fehler ist aufgetreten. Wir werden Sie kontaktieren.'),
('paypal', 'common', 'PayPal', 'PayPal'),
('reminder', 'common', 'Reminder', 'Zahlungserinnerung'),
('last_reminder', 'common', 'Final Notice', 'Mahnung'),
('pos', 'common', 'POS', 'POS'),
('orders', 'common', 'Orders', 'Bestellungen'),
('max_pieces', 'common', 'Maximal number of pieces achhieved', 'Maximale Stückzahl erreicht');
INSERT INTO `i18n` SET `index` = 'deliver_to', `group` = 'webshop', `de` = 'Versand nach', `en` = 'Deliver to';
INSERT INTO `i18n` SET `index` = 'modify', `group` = 'common', `de` = 'ändern', `en` = 'modify';
INSERT INTO `i18n` SET `index` = 'alter_destination', `group` = 'webshop', `de` = 'Zielland ändern', `en` = 'Modify Destination';
INSERT INTO `i18n` SET `index` = 'additional_vat', `group` = 'webshop', `de` = 'Es können zusätzliche Zoll- und Einfuhrabgaben anfallen.', `en` = 'Additional duty and taxes may occur.';
INSERT INTO `i18n` SET `index` = 'incl', `group` = 'webshop', `de` = 'inkl.', `en` = 'incl.';
INSERT INTO `i18n` SET `index` = 'eu_vat', `group` = 'webshop', `de` = 'Umsatzsteuer in EU', `en` = 'incl.';
INSERT INTO `i18n` SET `index` = 'inland', `group` = 'webshop', `de` = 'Inland', `en` = 'inland';
INSERT INTO `i18n` SET `index` = 'country_of_destination', `group` = 'webshop', `de` = 'Empfängerland', `en` = 'Country of Destination';
INSERT INTO `i18n` SET `index` = 'set_delivery', `group` = 'webshop', `de` = 'Alle als geliefert markieren', `en` = 'Set all as delivered.';
INSERT INTO `i18n` SET `index` = 'on_commission', `group` = 'webshop', `de` = 'Auf Kommission', `en` = 'On Commission';

INSERT INTO `html_groups` (`name`, `group`, `description`, `sort`, `parentsort`, `graduated`) VALUES
('WEBSHOP', '6', 'snippets of webshop', '10', '11', '——— WEBSHOP');

INSERT INTO `html_snippets` (`key`, `code`, `group`, `description`) VALUES
('cms_shop_dynamic', '<?php\r\nsession_start();\r\nrequire_once ("../inc.php");\r\nrequire_once ("../cms/plugins/shop.php");\r\n$bubbles = array();\r\n$db; $html; $website;\r\n$page = new shop([\'id\' => &&&&id&&&&, \'lang\' => \'&&&&lang&&&&\']);\r\necho $page->shop();\r\n?>', '99', 'dynamic dummy html-file for the shop'),
('cms_shop_item_in_list', '<li class="col w3 group_teaser"&&&&img_bg&&&&>\n<h3><a href="&&&&file&&&&">&&&&title&&&&</a></h3>\n</li>', '99', 'a product item in a list'),
('cms_shop_picture', '<div class="rel">\r\n\t&&&&resize&&&&<img alt="&&&&alt&&&&" src="&&&&src&&&&" height="&&&&height&&&&" width="&&&&width&&&&">&&&&eziser&&&&\r\n\t&&&&new&&&&\r\n</div>', '99', 'a medium sized picture in full product-display mostly with a resize mechanism'),
('cms_shop_full_product', '<h1>&&&&title&&&&</h1>\r\n\r\n<div class="row clrfx">\r\n\t&&&&picture&&&&\r\n\t<p>&&&&more_img&&&&</p>\r\n</div>\r\n<p><strong>&&&&i18n_product_no&&&&</strong>: &&&&product_no&&&&</p>\r\n<p class="lead">&&&&unit&&&&</p>\r\n&&&&provider&&&&\r\n&&&&colour&&&& &&&&size&&&& &&&&author&&&& &&&&length&&&& &&&&whatever&&&&\r\n&&&&specification&&&&\r\n\r\n', '15', 'template of the body of a product'),
('cms_shop_product', '<div class="col w8 first">\r\n\t&&&&body&&&&\r\n</div>\r\n<div class="col w4 last">\r\n\t&&&&order_pane&&&&\r\n</div>\r\n<script src=\'/js/jQspin.js\' type=\'text/javascript\'></script>\r\n<script type=\'text/javascript\'>\r\n$(document).ready(function(){$("[data-app=\'spin\']").spinme();});\r\n</script>\r\n<div class="col w12 stretch">\r\n\t&&&&supplies&&&&\r\n</div>', '99', 'combines full product with a dynamic generated order pane'),
('cms_shop_order_pane', '<div class="box" id="order-pane">\n<form id=\'basket_form&&&&id&&&&\' action=\'&&&&file&&&&\' method=\'post\' enctype=\'multipart/form-data\'>\n\t<input type=\'hidden\' name=\'sid\' value=\'&&&&sid&&&&\'>\n\t<input type=\'hidden\' name=\'_add\' value=\'&&&&id&&&&\'>\n\t<input type=\'hidden\' name=\'ln\' value=\'&&&&lang&&&&\'>\n\t<p class="price">&&&&price&&&&  &&&&currency&&&&</p>\n\t&&&&special&&&&\n\t<p class="small">&&&&price_info&&&&</p>\n\t<p class="small">&&&&i18n_deliver_to&&&&:<br /> &&&&destination&&&& <a href="?_cc=1" class="linkedtitle"><i class="far fa-pencil"></i> &&&&i18n_modify&&&&</a></p>\n\t&&&&versions&&&&\n\t<p class="grey">&&&&delivery_info&&&&</p>\n\t<p>\n\t\t<label for=\'amount&&&&id&&&&\'>&&&&i18n_pieces&&&& <span class=\'hidden\'>&&&&title&&&&:</span></label>&nbsp;<input type=\'text\' size=\'3\' maxlength=\'3\' value=\'1\' name=\'amount\' id=\'amount&&&&id&&&&\' class=\'text loose\' data-app="spin" data-max="&&&&max_order_quant&&&&" data-min="1" data-mess="warn&&&&id&&&&">\n\t\t<span id=\'warn&&&&id&&&&\' class=\'red\'>&nbsp;</span>\n\t</p>\n\t<p>\n\t\t&&&&button&&&&\n\t</p>\n</form>\n</div>', '99', 'order pane '),
('gui_webshop_turnovers', '&&&&overview&&&&\r\n<div id="chart" class="h2">&nbsp;</div>\r\n<div class="hidden">&&&&chart&&&&</div>\r\n<script type=\'text/javascript\'>\r\n\t$(document).ready($(function(){$(\'#chart\').table2chart({\'tableID\':\'tmonths\', \'type\':\'bars\', \'ratio\': \'x\', \'tooltip\': 1, \'strokeWidth\': 2, \'strokeColor\': [\'#009900\', \'#228B22\', \'#6495ED\']});}));\r\n</script>\r\n<hr />\r\n&&&&mtable&&&&<hr />\r\n&&&&table&&&&', '10', ''),
('cms_shop_total', '<div class="row shadeBox clrfx">\n<h2>&&&&i18n_invoice_total&&&&</h2>\n<p>&&&&i18n_total&&&&: &&&&subtotal&&&&<br />\n&&&&i18n_freight&&&&: &&&&freight&&&& (&&&&country&&&&)<br />\n&&&&i18n_invoice_total&&&&: <strong>&&&&total&&&&</strong></p>\n</div>', '99', NULL),
('cms_shop_group_picture', '<div class="rel">\r\n\t&&&&picture&&&&\r\n\t&&&&new&&&&\r\n</div>', '99', 'a small sized picture in group- and promo-box'),
('cms_shop_basket_info', '<div class="yo-mod yo-open yo-an-fade">\n<div id="overlay" class="yo-mod-content yo-cont alleft">\n<h2>&&&&i18n_your_basket&&&&\n<a class="yo-btn yo-tr" href=\'#\' onClick="$(\'.yo-mod\').fadeOut()"><i class="fas fa-times-circle fa-lg"></i></a>\n</h2>\n<div class="innerbox">\n&&&&INFO_TEXT&&&&\n<p class="center"><a class="as_button" href=\'#\' onClick="$(\'.yo-mod\').fadeOut()">&&&&i18n_continue_shop&&&&</a></p>\n<p class="center"><a class="as_button" href=\'/shop?_o=1\'>&&&&i18n_order_now&&&&</a></p>\n</div>\n</div>\n</div>\n', '99', 'Info Box after laying a product into basket'),
('cms_shop_provider', '<p>&&&&label&&&&<br />&&&&logo&&&&\r\n</p>', '99', ''),
('cms_shop_order_button', '<button type="submit" id="submit&&&&id&&&&"><i class="fas fa-cart-arrow-down fa-lg"></i>  &&&&txt&&&&</button>', '99', 'Button of webshop'),
('cms_shop_login', '<a href="/shop/?_o=2"><i class="fas fa-user fa-2x yo-btn" data-modal="login_box"></i></a>', '99', NULL),
('cms_shop_logged_in', '<i class="fas fa-user-check green fa-2x" title="&&&&name&&&&"></i>', '99', NULL),
('cms_shop_order_price', '<p class="alright">\n<span class="wSval">&&&&price&&&&</span> &&&&currency&&&&<br />\n&&&&price_info&&&&</p>\n', '99', ''),
('cms_shop_promo', '<h2>&&&&title&&&&</h2>\r\n<ul id="recommandations" class="neutral">\r\n&&&&content&&&&\r\n</ul>\r\n', '99', NULL),
('cms_shop_supplies_item', '<li class="t4 box" data-expand="1">\r\n\r\n<a href="&&&&file&&&&">&&&&picture&&&&</a>\r\n<p>&&&&title&&&&</p>\r\n<p class="price">&&&&price&&&&  &&&&currency&&&&</p>\r\n</li>', '99', NULL),
('cms_shop_big_promo_li', '<li class="t3 box" data-expand="1">\r\n&&&&picture&&&&\r\n<p class="clrfx"><a href="&&&&file&&&&" class="linkedtitle">&&&&title&&&&</a></p> \r\n<p class="price flex-bottom">Jetzt kaufen um &&&&price&&&& &&&&currency&&&&</p>\r\n</li>\r\n', '99', NULL),
('gui_webshop_delivery_mail', 'Sehr geehrter &&&&fullname&&&&\r\n\r\nIhr Paket ist unterwegs zu Lieferadresse\r\n\r\n&&&&delivery_addr&&&&\r\n\r\nSendungsnummer: 1000224008941000110100\r\nSendungsnachverfolgung: https://www.post.at/sendungsverfolgung.php?pnum1=1000224008941000110100\r\n\r\nBei etwaigen Problemen mit der Lieferung zögern Sie nicht, uns zu kontaktieren. \r\n\r\nBestellung &&&&order_id&&&&\r\n\r\n&&&&order&&&&\r\n\r\nDie Rechnung ist bezahlt.\r\n\r\nWir wünschen Ihnen viel Vergnügen und ein gutes Gelingen!\r\n\r\nliebe Grüße', '10', ''),
('cms_shop_addresses', '<div class="row shadeBox clrfx">\r\n<h2>&&&&i18n_address&&&&</h2>\r\n<div class="col w50p first">\r\n<h3>&&&&i18n_invoice_address&&&&</h3>\r\n&&&&full_invoice_addr&&&&\r\n<p><a href="/shop?_o=4&amp;_f=1" class="as_button">&&&&i18n_edit&&&&</a></p>\r\n</div>\r\n<div class="col w50p last">\r\n<h3>&&&&i18n_delivery_address&&&&</h3>\r\n&&&&full_delivery_addr&&&&\r\n</div>\r\n</div>', '99', ''),
('cms_shop_payment', '<div class="row shadeBox tlform clrfx">\n<form action="" method="post" enctype="multipart/form-data">\n<input type="hidden" name="sid" value="&&&&sid&&&&">\n<input type="hidden" name="ln" value="&&&&lang&&&&">\n<input type="hidden" name="_o" value="10">\n<h2>&&&&i18n_payment&&&&</h2>\n&&&&payment_options&&&&\n<hr />\n<p>Es gelten die <a href="/content/?_id=&&&&GTC&&&&&amp;_pr=1" title="AGB" data-app="popup">Allgemeinen Gesch&auml;ftsbedingungen</a>.</p>\n&&&&order_finish&&&&\n</form>\n</div>', '99', ''),
('cms_shop_product_col', '<li class="t3 box" data-expand="1">\r\n&&&&picture&&&&\r\n<h3><a class="linkedtitle" href="&&&&file&&&&">&&&&title&&&&</a></h3>\r\n<p>&&&&product_no&&&&<br />&&&&unit&&&&</p>\r\n<p class="price flex-bottom">Jetzt kaufen um &&&&price&&&& &&&&currency&&&&</p>\r\n</li>', '99', NULL),
('cms_shop_order_register', '<div class="row clrfx">\n<div class="col w50p first">\n<div class="box">\n<h2>&&&&i18n_i_am_user&&&&</h2>\n&&&&feedback&&&&\n<form action="/shop/" method="post" enctype="multipart/form-data">\n<input type="hidden" name="sid" value="&&&&sid&&&&">\n<input type="hidden" name="ln" value="&&&&lang&&&&">\n<input type="hidden" name="_o" value="2">\n<p><label for=\'iprename\'>&&&&i18n_user&&&&</label></p>\n<p><input type="text" class="text" id="i&&&&bn&&&&" name="&&&&bn&&&&" value="" size="20" /></p>\n<p><label for=\'iname\'>&&&&i18n_pwd&&&&</label></p>\n<p><input type="password" class="text " id="i&&&&pw&&&&" name="&&&&pw&&&&" value="" size="20" /></p>\n<p><input type="submit" value="&&&&i18n_login&&&&" class="button" /></p>\n</form>\n</div>\n</div>\n<div class="col w50p last">\n<div class="box">\n<h2>&&&&i18n_become_user&&&&</h2>\n<p>&&&&i18n_sign_in_as&&&&</p>\n<p><a href="/shop/?sid=&&&&sid&&&&&amp;ln=&&&&lang&&&&&amp;_o=3" class="as_button">&&&&i18n_guest&&&&</a> &&&&i18n_or&&&& <a href="/shop/?sid=&&&&sid&&&&&amp;ln=&&&&lang&&&&&amp;_o=4" class="as_button">&&&&i18n_client&&&&</a></p>\n</div>\n&&&&paypal&&&&\n</div>\n</div>', '99', ''),
('cms_shop_login_bkp', '<a href="/shop/?_o=2"><i class="fas fa-user fa-2x yo-btn" data-modal="login_box"></i></a>\r\n<div id="login_box" class="yo-mod &&&&open&&&& yo-an-fade">\r\n<div  id="overlay" class="yo-mod-content yo-cont">\r\n<h2>&&&&i18n_login&&&& <a class="yo-btn yo-tr" href=\'#\' onClick="$(\'.yo-mod\').fadeOut()"><i class="fas fa-times-circle fa-lg"></i></a></h2>\r\n<div class="innerbox">\r\n<form action="" method="post" enctype="multipart/form-data">\r\n<input type="hidden" name="sid" value="&&&&sid&&&&">\r\n<input type="hidden" name="ln" value="&&&&lang&&&&">\r\n&&&&feedback&&&&\r\n<p><label for=\'i&&&&bn&&&&\'>&&&&i18n_username&&&&</label><br />\r\n<input type="text" class="text" id="i&&&&bn&&&&" name="&&&&bn&&&&" value="" size="20" /></p>\r\n<p><label for=\'i&&&&pw&&&&\'>&&&&i18n_pwd&&&&</label><br />\r\n<input type="password" class="text " id="i&&&&pw&&&&" name="&&&&pw&&&&" value="" size="20" /></p>\r\n<p class="alright"><br /><input type="submit" value="&&&&i18n_login&&&&" class="button" /></p>\r\n</form>\r\n</div>\r\n</div>\r\n</div>\r\n\r\n', '99', NULL),
('cms_shop_group_col', '<li class="t3 box yo-con" data-expand="1">\r\n&&&&picture&&&&\r\n<h3 class="overlay yo-bl"><a class="linkedtitle" href="&&&&file&&&&">&&&&title&&&&</a></h3>\r\n</li>', '99', NULL),
('cms_shop_order_item', '&&&&picture&&&&\r\n<p>&&&&product_no&&&&\r\n<br />&&&&title&&&&</p>\r\n', '99', ''),
('cms_shop_order_list', '<form action="/shop/" method="post" enctype="multipart/form-data">\r\n<input type="hidden" name="sid" value="&&&&sid&&&&">\r\n<input type="hidden" name="ln" value="&&&&lang&&&&">\r\n<input type="hidden" name="_o" value="&&&&step&&&&">\r\n\r\n<table id="order_table" class="withBorder">\r\n&&&&table&&&&\r\n</table>\r\n<p class="alright">\r\n<input type="submit" name="order" id="iorder" value="&&&&i18n_next&&&&" class="button" />\r\n</p>\r\n</form>\r\n<script type=\'text/javascript\' src=\'/js/jQminiSheet.js\'></script>\r\n<script src=\'/js/jQspin.js\' type=\'text/javascript\'></script>\r\n<script type=\'text/javascript\'>\r\n$(document).ready(function () {$(\'#order_table\').miniSheet();});\r\n$(document).ready(function(){$("[data-app=\'spin\']").spinme();});\r\n</script>\r\n\t\t', '99', ''),
('cms_shop_basket_item', '<div class="clrfx">\n<p>&&&&picture&&&&&&&&amount&&&& &&&&items&&&& &&&&title&&&&</p>\n<p class="alright">&&&&price&&&& &&&&currency&&&&</p>\n</div>\n<hr />\n', '99', 'one item in the basket'),
('cms_shop_promo_item', '<li class="box" data-expand="1">\r\n&&&&picture&&&&\r\n<p><a class="linkedtitle" href="&&&&file&&&&">&&&&title&&&&</a><p>\r\n<p class="price alright">&&&&price&&&& &&&&currency&&&&</p>\r\n</li>', '99', NULL),
('cms_shop_basket', '<!-- start basket -->\n&&&&button_m&&&&\n<div id="basket" class="yo-dropdown-content yo-an-zoom">\n<div class="innerbox">\n&&&&list&&&&\n&&&&freight_txt&&&&\n<p class="alright">&&&&i18n_total&&&&: <strong>&&&&invoice_total&&&& &&&&currency&&&&</strong></p>\n</div>\n</div>\n<!-- end basket -->\n&&&&open_basket&&&&\n', '99', 'the basket of the webshop'),
('gui_webshop_turnovers', '&&&&overview&&&&\r\n<div id="chart" class="h2">&nbsp;</div>\r\n<div class="hidden">&&&&chart&&&&</div>\r\n<script type=\'text/javascript\'>\r\n\t$(document).ready($(function(){$(\'#chart\').table2chart({\'tableID\':\'tmonths\', \'type\':\'bars\', \'ratio\': \'x\', \'tooltip\': 1, \'strokeWidth\': 2, \'strokeColor\': [\'#009900\', \'#228B22\', \'#6495ED\']});}));\r\n</script>\r\n<hr />\r\n&&&&mtable&&&&<hr />\r\n&&&&table&&&&', '10', ''),
('cms_shop_paypal_item', '\t{\r\n  name: \'&&&&title&&&&\',\r\n  quantity: \'&&&&amount&&&&\',\r\n  price: \'&&&&s_price&&&&\',\r\n  currency: \'EUR\',\r\n  sku: \'&&&&product_no&&&&\'\r\n  },', '99', NULL),
('cms_shop_paypal', '<script src="https://www.paypalobjects.com/api/checkout.min.js"></script>\r\n<script>\r\n\tpaypal.Button.render({\r\n        env: \'sandbox\', // sandbox | production\r\n\t\tlocale: \'de_AT\',\r\n        style: {\r\n            label: \'paypal\',\r\n            size:  \'responsive\',\r\n            shape: \'rect\',\r\n            color: \'blue\',\r\n            tagline: false,\r\n\t\t\tfundingicons: true\r\n        \t},\r\n        client: {\r\n            sandbox:    \'\',\r\n            production: \'\'\r\n        \t},\r\n\r\n        payment: function(data, actions) {\r\n            return actions.payment.create({\r\n                payment: {\r\n                    transactions: [\r\n                        {\r\n                            amount: {\r\n\t\t\t\t\t\t\ttotal: \'&&&&invoice_total&&&&\', \r\n\t\t\t\t\t\t\tcurrency: \'EUR\', \r\n\t\t\t\t\t\t\tdetails: {\r\n\t\t\t\t\t\t\t\tsubtotal: \'&&&&total&&&&\',\r\n\t\t\t\t\t\t\t\tshipping: \'&&&&freight&&&&\'\r\n\t\t\t\t\t\t\t\t}\r\n\t\t\t\t\t\t\t},\r\n\t\t\t\t\t\tinvoice_number: \'&&&inv_no&&&\',\r\n\t\t\t\t\t\titem_list: {\r\n\t\t\t\t\t\t\titems: [\r\n\t\t\t\t\t\t\t  &&&&list&&&&\r\n\t\t\t\t\t\t\t],\r\n\t\tshipping_address: {\r\n\t\t\trecipient_name: \'&&&&prename&&&& &&&&name&&&&\',\r\n\t\t\tline1: \'&&&&street&&&&\',\r\n\t\t\tcity: \'&&&&city&&&&\',\r\n\t\t\tcountry_code: \'&&&&uc_country&&&&\',\r\n\t\t\tpostal_code: \'&&&&postal_code&&&&\'\r\n        \t}\r\n\t\t}\t\t\t\t\t\t\t\r\n                        }\r\n                    ],\r\n\t\t\tredirect_urls: {return_url: \'&&&&url&&&&/shop/?_o=11\'}},\r\n\t\t\texperience: {input_fields: {no_shipping: 1}}\r\n            });\r\n        },\r\n        onAuthorize: function(data, actions) {return actions.payment.execute().then(function() {actions.redirect();});},\r\n\t\tonCancel: function(data, actions) {$(\'#paypal-button-container\').append(\'<p class="red">&&&&i18n_pp_incomplete&&&&</p>\');},\r\n\t\tonError: function (err) {$(\'#paypal-button-container\').append(\'<p class="red">&&&&i18n_pp_error&&&&</p>\');}\r\n\r\n    }, \'#paypal-button-container\');\r\n\r\n</script>', '99', 'paypal button with credicard'),
('cms_shop_register_paypal', '<div class="box">\r\n<h2>&&&&i18n_paypal&&&&</h2>\r\n<span id=\'lippButton\'></span>\r\n<script src=\'https://www.paypalobjects.com/js/external/api.js\'></script>\r\n<script>\r\npaypal.use( [\'login\'], function (login) {\r\n  login.render ({\r\n    "appid":"",\r\n    "authend":"sandbox",\r\n    "scopes":"openid profile address",\r\n    "containerid":"lippButton",\r\n    "locale":"de-de",\r\n    "returnurl":"http://www.tee.web-application.at/shop/?_o=1"\r\n  });\r\n});\r\n</script>\r\n</div>', '99', NULL),
('cms_webshop_body', '<body>\n&&&&BASKET_INFO&&&&\n<div id="site" class="clrfx">\n\t&&&&HEADER&&&&\n\n<!--content area -->\n<div id="content_area" class="grid clrfx">\n<!--first col-->\n<aside id="left" class="col w3">\t\n\t&&&&SUBNAV&&&&\n\t&&&&LOGIN_BOX&&&&\n\t&&&&WEBSHOP_BOX&&&&\n\t&&&&ADVICE_BOX&&&&\n</aside> <!-- /left -->\n\n<!--main col-->\n<main id="content" class="col w9">\n\t&&&&BREADCRUMB&&&&\n\t&&&&PROCEEDING&&&&\n\t&&&&MYCONTENT&&&&\n</main> <!-- /content -->\n</div> <!-- /content_area -->\n\t&&&&FOOTER&&&&\n</div> <!-- /site -->\n</body>\n<!-- &&&&TIMESTAMP&&&& -->\n</html>', '5', NULL),
( 'gui_webshop_delivery_mail', 'Sehr geehrter &&&&fullname&&&&\r\n\r\nIhr Paket ist unterwegs zu Lieferadresse\r\n\r\n&&&&delivery_addr&&&&\r\n\r\nSendungsnummer: 1000224008941000110100\r\nSendungsnachverfolgung: https://www.post.at/sendungsverfolgung.php?pnum1=1000224008941000110100\r\n\r\nBei etwaigen Problemen mit der Lieferung zögern Sie nicht, uns zu kontaktieren. \r\n\r\nBestellung &&&&order_id&&&&\r\n\r\n&&&&order&&&&\r\n\r\nDie Rechnung ist bezahlt.\r\n\r\nWir wünschen Ihnen viel Vergnügen und ein gutes Gelingen!\r\n\r\nliebe Grüße', '10', ''),
('cms_shop_versions_item', '<li class="clrfx" data-expand="1">\r\n<a href="&&&&file&&&&">&&&&picture&&&&</a>\r\n&&&&diff&&&&\r\n</li>', '15', NULL),
('cms_shop_versions_first', '<li class="clrfx leg">\r\n&&&&picture&&&&\r\n&&&&diff&&&&\r\n</li>', '15', NULL);


UPDATE `html_snippets` SET `group` = (SELECT `id` FROM `html_groups` WHERE `name` = 'WEBSHOP') WHERE `group` = 99;

INSERT INTO `html_presets` (`generation`, `main`, `key`, `code`) VALUES
('2', '1', 'cms_webshop_body', '<body id="l-inside">\r\n&&&&BASKET_INFO&&&&\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n<!--content area -->\r\n<div id="content_area" class="col w12 stretch clrfx">\r\n<!--first col-->\r\n<aside id="left" class="col w3">\t\r\n\t&&&&SUBNAV&&&&\r\n\t&&&&LOGIN_BOX&&&&\r\n\t&&&&ADVICE_BOX&&&&\r\n\t&&&&WEBSHOP_BOX&&&&\r\n</aside> <!-- /left -->\r\n\r\n<!--main col-->\r\n<main id="content" class="col w9">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&PROCEEDING&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('2', '2', 'cms_webshop_body', '<body id="l-outside">\r\n&&&&BASKET_INFO&&&&\r\n<div id="site" class="clrfx">\r\n\t&&&&HEADER&&&&\r\n<!--content area -->\r\n<div id="content_area" class="grid clrfx">\r\n<!--first col-->\r\n<aside id="left" class="col w3 first">\t\r\n\t&&&&SUBNAV&&&&\r\n\t&&&&LOGIN_BOX&&&&\r\n\t&&&&ADVICE_BOX&&&&\r\n\t&&&&WEBSHOP_BOX&&&&\r\n</aside> <!-- /left -->\r\n\r\n<!--main col-->\r\n<main id="content" class="col w9 first">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&PROCEEDING&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>');

INSERT INTO `register_groups` (`name`, `sort`) VALUES ('webshop', '60');

INSERT INTO `register` (`name`, `call`, `plugin`, `tab`, `params`, `gui`, `top`, `start`, `group`, `icon`, `image`, `level`, `sort`, `frontend`) VALUES
('webshop', 'webshop', '', '99', '', '1', 'on', 'on', 'on', 'shopping-cart', '0', '1', '120', ''),
('webshop_groups', 'goodsgroup', 'webshop', '99', '&parent=9', '1', '', '', '', 'boxes', '0', '1', '260', ''),
('products', 'products', 'webshop', '99', '&c_filter=products', '1', '', 'on', 'on', 'cube-red', '0', '1', '130', ''),
('shop_media', 'shop_media', 'webshop', '99', '', '5', '', '', '', 'file-image-add', '0', '1', '250', ''),
('basket', 'order_items', 'order_processing', '99', '', '5', '', '', '', 'default', '1', '2', '240', ''),
('messages', 'shop_messages', 'webshop', '99', '', '1', '', '', '', 'comments', '0', '2', '230', ''),
('settings', 'shop_settings', 'webshop', '99', '', '1', '', 'on', 'on', 'wrench', '0', '2', '200', ''),
('freight', 'webshop_freight', 'webshop', '99', '', '0', '', '', 'on', 'truck', '0', '2', '160', ''),
('order', 'order_processing', NULL, '99', '', '0', '', 'on', 'on', 'clipboard', '0', '2', '140', ''),
('stock', 'webshop_stock', 'webshop', '99', '', '1', '', '', 'on', 'cubes', '0', '2', '150', ''),
('get_invoice', 'get_invoice', 'webshop', '99', '', '6', '', '', '', 'default', '1', '2', '280', ''),
('delivery_address', 'order_delivery', 'webshop', '9', '', '1', '', '', '', 'dolly', '0', '2', '180', ''),
('provider', 'manufacturer', 'webshop', '99', '', '1', '', '', 'on', 'industry', '0', '2', '170', NULL),
('get_product', 'get_product', 'order_processing', '99', '', '6', '', '', '', 'default', '1', '1', '270', ''),
('taxes', 'shop_taxes', 'webshop', '99', '', '1', '', '', '', 'coins', '0', '2', '210', ''),
('promotion', 'promotion', 'webshop', '99', '', '1', '', '', 'on', 'bullhorn', '0', '1', '190', '');


UPDATE `register` SET `tab` = (SELECT `id` FROM `register_groups` WHERE `name` = 'webshop') WHERE `tab` = 99;

INSERT INTO `crm_messages` (`key`, `value`, `group`, `lang`, `rule`) VALUES
('payment_invoice', 'Ich erhalte die Rechnung mit der Lieferung und zahle innerhalb von 14 Tagen nach Erhalt der Bestellung.\r\n**Nur für Stammkunden**', 'shop', 'de', '1'),
('payment_in_advance', 'Ich erhalte die Bestellung, sobald ich den Betrag auf das Bankkonto von artbeeren e.U. überwiesen habe.', 'shop', 'de', '1'),
('payment_paypal', '<p class="grey"><i class="fab fa-paypal fa-2x" title="PayPal"></i> <i class="fab fa-cc-visa fa-2x" title="Visa"></i> <i class="fab fa-cc-mastercard fa-2x" title="Mastercard"></i> <i class="fab fa-cc-amex fa-2x" title="American Express"></i></p>\r\n<p>Ich bezahle die Rechnung mit meinem PayPal-Konto oder mit Kreditkarte (Master, Visa, Amex).<br />Letztere können auch <b>ohne Paypal-Konto</b> benutzt werden.</p>\r\n\r\n', 'shop', 'de', '1'),
('payment_self_collect', 'Ich hole meine Bestellung am \r\n&&&&address&&&&\r\nnach **Terminvereinbarung** selbst ab und zahle vor Ort.', 'shop', 'de', '1'),
('order_mail', 'Sie erhalten in Kürze eine E-Mail auf die Adresse &&&&email&&&&. Bitte überprüfen Sie gegebenenfalls auch Ihren Spam-Ordner.', 'shop', 'de', '1'),
('order_invoice', 'Die Lieferung erfolgt in Kürze.\r\nBitte begleichen Sie die Rechnung für die Bestellung binnen 14 Tage nach Erhalt der Ware.', 'shop', 'de', '1'),
('order_in_advance', 'Bitte überweisen Sie den Betrag von &&&&total&&&& auf das Konto:\r\n\r\n&&&&account&&&&\r\n\r\nIhre Bestellung wird fünf Tage lang zurückgestellt. Die Lieferung erfolgt, sobald der Betrag auf unserem Konto eingelangt ist.', 'shop', 'de', '1'),
('order_self_collect', 'Ihre Bestellung ist ab &&&&tomorrow&&&& abholbereit: \r\n&&&&address&&&&\r\n', 'shop', 'de', '1'),
('order_paypal', 'Klicken Sie bitte auf den Button der gewünschten Zahlungsmethode.', 'shop', 'de', '1'),
('basket_info', 'Das Produkt wurde in den Warenkorb gelegt. Mit dem Einkaufswagen-Symbol auf der rechten oberen Ecke können Sie den Warenkorb jederzeit einsehen, bearbeiten oder den Bestellvorgang abschließen.', 'shop', 'de', '1');

INSERT INTO `crm_forms` (`name`, `active`, `settings`, `header`, `footer`, `confirmation`)
VALUES ('delivery', 'on', '{\r\n    "salutation2": {\r\n        "type": "array",\r\n        "default": 1,\r\n        "duty": 1\r\n    },\r\n    "title2": {\r\n        "type": "text"\r\n    },\r\n    "prename2": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "name2": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "company2": {\r\n        "type": "text"\r\n    },\r\n    "company2_line2": {\r\n        "type": "text"\r\n    },\r\n    "street2": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "city2": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "postal_code2": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "country2": {\r\n        "type": "country",\r\n        "default": "at",\r\n        "duty": 1\r\n    },\r\n    "use_del": {\r\n        "type": "flag",\r\n        "default": "on"\r\n    }\r\n}', 'inquiry_header', 'inquiry_privacy', 'inquiry_confirmation'),
('guest', 'on', '{\r\n    "salutation": {\r\n        "type": "array",\r\n        "default": 1,\r\n        "duty": 1\r\n    },\r\n    "title": {\r\n        "type": "text",\r\n        "size": "10"\r\n    },\r\n    "prename": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "name": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n     "email": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "street": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "city": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "postal_code": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "country": {\r\n        "type": "country",\r\n        "default": "at",\r\n        "duty": 1\r\n    },\r\n    "level": {\r\n        "type": "hidden",\r\n        "default": 1\r\n    }\r\n}', 'registry_header', 'inquiry_privacy', 'registry_confirmation');


CREATE TABLE `goodsgroups` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '0',
  `picture` varchar(128) DEFAULT NULL,
  `parent` bigint(20) NOT NULL DEFAULT '0',
  `sort` bigint(20) NOT NULL DEFAULT '10',
  `control` int(10) DEFAULT NULL,
  `parentsort` bigint(20) DEFAULT NULL,
  `graduated` varchar(128) DEFAULT NULL,
  KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `order_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sid` varchar(20) NOT NULL DEFAULT '0',
  `product` bigint(20) NOT NULL DEFAULT '0',
  `amount` int(100) NOT NULL DEFAULT '1',
  `order_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `copy_product_no` varchar(255) DEFAULT NULL,
  `copy_name` varchar(255) DEFAULT NULL,
  `copy_tax` tinyint(4) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `discount` smallint(5) unsigned NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) unsigned DEFAULT NULL,
  `specification` text CHARACTER SET utf8,
  `product_no` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `product_no_ext` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `stock` bigint(20) NOT NULL,
  `free` bigint(20) NOT NULL DEFAULT '0',
  `unit` varchar(127) CHARACTER SET utf8 DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tax` tinyint(4) NOT NULL,
  `weight` int(10) DEFAULT NULL,
  `new` varchar(2) CHARACTER SET utf8 DEFAULT NULL,
  `special_price` decimal(10,2) DEFAULT NULL,
  `delivery` tinyint(32) NOT NULL DEFAULT '1',
  `provider` bigint(20) DEFAULT NULL,
  `picture` varchar(128) CHARACTER SET utf8 DEFAULT NULL,
  `colour` varchar(127) CHARACTER SET utf8 DEFAULT NULL,
  `size` varchar(127) CHARACTER SET utf8 DEFAULT NULL,
  `whatever` varchar(127) CHARACTER SET utf8 DEFAULT NULL,
  `author` varchar(128) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `length` varchar(128) CHARACTER SET utf8 DEFAULT NULL,
  `promotion` char(2) CHARACTER SET utf8 DEFAULT NULL,
  `group_promotion` char(2) CHARACTER SET utf8 DEFAULT NULL,
  `advices` varchar(128) CHARACTER SET utf8 DEFAULT NULL,
  `supplies` varchar(128) CHARACTER SET utf8 DEFAULT NULL,
  `versions` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `max_order_quant` int(11) NOT NULL DEFAULT '99',
  `low_stock` tinyint(3) unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `shop_manufacturer` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL,
  `logo` varchar(126) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `webshop_freight` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL,
  `area` varchar(255) DEFAULT NULL,
  `max_weight` bigint(20) NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `webshop_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `client` bigint(20) NOT NULL DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `freight` decimal(10,2) NOT NULL DEFAULT '0.00',
  `weight` int(10) NOT NULL DEFAULT '0',
  `payment` varchar(24) NOT NULL DEFAULT '0',
  `payed` varchar(2) DEFAULT NULL,
  `note` text,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `lang` varchar(2) NOT NULL DEFAULT 'de',
  `payed_date` date DEFAULT NULL,
  `by_hand` TINYINT(3)  NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `webshop_taxes` (
  `id` float NOT NULL AUTO_INCREMENT,
  `tax` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `webshop_taxes` ( `id`, `tax`)
VALUES ( '1', '10'),
( '2', '20');

CREATE TABLE `clients_delivery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cid` bigint(20) DEFAULT NULL,
  `salutation` tinyint(4) NOT NULL DEFAULT '1',
  `title` varchar(12) DEFAULT NULL,
  `name` varchar(128) NOT NULL DEFAULT '',
  `prename` varchar(128) NOT NULL DEFAULT '',
  `company` varchar(255) DEFAULT NULL,
  `company_line2` varchar(126) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `province` varchar(128) DEFAULT NULL,
  `postal_code` varchar(28) DEFAULT NULL,
  `country` varchar(128) DEFAULT NULL,
  `use_del` varchar(2) DEFAULT NULL,
  `phone` varchar(128) DEFAULT NULL,
  `fax` varchar(128) DEFAULT NULL,
  `mobile` varchar(128) DEFAULT NULL,
  `email` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `name` (`name`,`prename`,`company`,`company_line2`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `media` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `foreign` bigint(20) NOT NULL,
  `group` varchar(3) NOT NULL,
  `sort` bigint(20) unsigned NOT NULL DEFAULT '10',
  `title` varchar(127) NOT NULL DEFAULT '',
  `media` varchar(127) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `foreign` (`foreign`,`group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `stock_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `stock` bigint(20) unsigned DEFAULT NULL,
  `delta` int(10) DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pid` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `webshop_freight` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL,
  `area` text,
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `price2` decimal(10,2) unsigned DEFAULT NULL,
  `price3` decimal(10,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `webshop_freight` ( `id`, `name`, `area`, `price`, `price2`, `price3`)
VALUES ( '1', 'Inland', 'at', '4.30', '6.30', '8.30'),
( '2', 'EU 1', 'de,sk,si,cz,hu', '11.30', '16.60', '19.60'),
( '3', 'EU 2', 'be,dk,fr,it,hr,lu,mc,nl,pl,se', '15.60', '20.60', '25.60'),
( '4', 'EU 3', 'ax,bg,ee,fi,gr,ie,lv,lt,pt,ro,es', '27.60', '34.50', '41.60'),
( '5', 'Europa 1', 'al,ad,am,az,ba,ge,gi,gb,is,im,kz,li,mt,mk,md,me,no,ru,ch,rs,cs,tr,ua,va,by,cy', '19.90', '26.00', '41.00'),
( '6', 'Welt 1', 'eg,dz,bh,iq,ir,il,ye,jo,ca,qa,kw,lb,ly,ma,mx,om,sa,sy,tn,us', '32.00', '50.00', '72.00'),
( '7', 'Welt 2', 'af,as,vi,ao,ai,aq,ag,gq,ar,aw,et,au,bs,bd,bb,bj,bm,bt,bo,bw,bv,br,vg,io,bn,bf,bi,cl,cn,ck,cr,ci,cd,kp,la,dm,do,dj,ec,sv,fk,fo,fj,fm,gf,pf,tf,ga,gm,gh,gd,gl,gp,gu,gt,gy,gn,gw,ht,hm,hn,hk,in,id,jm,jp,ky,kh,cm,cv,ke,kg,ki,cc,co,km,cg,kr,cu,ls,lr,mo,mg,mw,my,mv,ml,mh,mq,mr,mu,yt,mn,ms,mz,na,nr,np,nc,nz,ni,ne,ng,nu,mp,nf,tl,pk,pw,pa,pg,py,pe,ph,pn,pr,re,rw,bl,pm,sb,zm,ws,sm,st,sn,sc,sl,sg,so,lk,sh,kn,lc,vc,ps,za,sd,gs,sr,sj,sz,tj,tw,tz,th,tg,tk,to,tt,td,tm,tv,ug,uy,uz,vu,ve,ae,vn,wf,cx,eh,cf,zw', '39.00', '67.00', '145.00');

CREATE TABLE `webshop_freight_junction_countries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_webshop_freight` bigint(20) unsigned NOT NULL,
  `id_countries` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_webshop_freight` (`id_webshop_freight`),
  KEY `id_countries` (`id_countries`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `webshop_freight_junction_countries` (`id_webshop_freight`, `id_countries`) VALUES ('1', 'at'), ('3', 'hr'), ('3', 'it'), ('3', 'fr'), ('3', 'dk'), ('3', 'be'), ('7', 'cf'), ('7', 'eh'),
('7', 'cx'), ('7', 'wf'), ('4', 'es'), ('4', 'ro'), ('4', 'pt'), ('4', 'lt'), ('4', 'lv'), ('4', 'ie'), ('4', 'gr'), ('4', 'fi'), ('4', 'ee'), ('4', 'ax'), ('4', 'bg'), ('5', 'cy'), ('5', 'by'), ('5',
'va'), ('5', 'ua'), ('5', 'tr'), ('5', 'cs'), ('5', 'rs'), ('5', 'ch'), ('5', 'ru'), ('5', 'no'), ('5', 'me'), ('5', 'md'), ('5', 'mk'), ('5', 'mt'), ('5', 'li'), ('5', 'kz'), ('5', 'im'), ('5',
'is'), ('5', 'gb'), ('5', 'gi'), ('5', 'ge'), ('5', 'ba'), ('7', 'vn'), ('7', 'ae'), ('7', 've'), ('7', 'vu'), ('7', 'uz'), ('7', 'uy'), ('7', 'ug'), ('7', 'tv'), ('7', 'tm'), ('7', 'td'), ('7',
'tt'), ('7', 'to'), ('7', 'tk'), ('7', 'tg'), ('7', 'th'), ('7', 'tz'), ('7', 'tw'), ('7', 'tj'), ('7', 'sz'), ('7', 'sj'), ('7', 'sr'), ('7', 'gs'), ('7', 'sd'), ('7', 'za'), ('7', 'ps'), ('7',
'vc'), ('7', 'lc'), ('7', 'kn'), ('7', 'sh'), ('7', 'lk'), ('7', 'so'), ('7', 'sg'), ('7', 'sl'), ('7', 'sc'), ('7', 'sn'), ('7', 'st'), ('7', 'sm'), ('7', 'ws'), ('7', 'zm'), ('7', 'sb'), ('7',
'pm'), ('7', 'bl'), ('7', 'rw'), ('7', 're'), ('7', 'pr'), ('7', 'pn'), ('7', 'ph'), ('7', 'pe'), ('7', 'py'), ('7', 'pg'), ('7', 'pa'), ('7', 'pw'), ('7', 'pk'), ('7', 'tl'), ('7', 'nf'), ('7',
'mp'), ('7', 'nu'), ('7', 'ng'), ('7', 'ne'), ('7', 'ni'), ('7', 'nz'), ('7', 'nc'), ('7', 'np'), ('7', 'nr'), ('7', 'na'), ('7', 'mz'), ('7', 'ms'), ('7', 'mn'), ('7', 'yt'), ('7', 'mu'), ('7',
'mr'), ('7', 'mq'), ('7', 'mh'), ('7', 'ml'), ('7', 'mv'), ('7', 'my'), ('7', 'mw'), ('7', 'mg'), ('7', 'mo'), ('7', 'lr'), ('7', 'ls'), ('7', 'cu'), ('7', 'kr'), ('7', 'cg'), ('7', 'km'), ('7',
'co'), ('7', 'cc'), ('7', 'ki'), ('7', 'kg'), ('7', 'ke'), ('7', 'cv'), ('7', 'cm'), ('7', 'kh'), ('7', 'ky'), ('7', 'jp'), ('7', 'jm'), ('7', 'id'), ('7', 'in'), ('7', 'hk'), ('7', 'hn'), ('7',
'hm'), ('7', 'ht'), ('7', 'gw'), ('7', 'gn'), ('7', 'gy'), ('7', 'gt'), ('7', 'gu'), ('7', 'gp'), ('7', 'gl'), ('7', 'gd'), ('7', 'gh'), ('7', 'gm'), ('7', 'ga'), ('7', 'tf'), ('7', 'pf'), ('7',
'gf'), ('7', 'fm'), ('7', 'fj'), ('7', 'fo'), ('7', 'fk'), ('7', 'sv'), ('7', 'ec'), ('7', 'dj'), ('7', 'do'), ('7', 'dm'), ('7', 'la'), ('7', 'kp'), ('7', 'cd'), ('7', 'ci'), ('7', 'cr'), ('7',
'ck'), ('7', 'cn'), ('7', 'cl'), ('7', 'bi'), ('7', 'bf'), ('7', 'bn'), ('7', 'io'), ('7', 'vg'), ('7', 'br'), ('7', 'bv'), ('7', 'bw'), ('7', 'bo'), ('7', 'bt'), ('7', 'bm'), ('7', 'bj'), ('7',
'bb'), ('7', 'bd'), ('7', 'bs'), ('7', 'au'), ('7', 'et'), ('7', 'aw'), ('7', 'ar'), ('7', 'gq'), ('7', 'ag'), ('7', 'aq'), ('7', 'ai'), ('7', 'ao'), ('7', 'vi'), ('7', 'as'), ('7', 'af'), ('2',
'de'), ('6', 'eg'), ('6', 'dz'), ('6', 'bh'), ('6', 'iq'), ('6', 'ir'), ('6', 'il'), ('6', 'ye'), ('6', 'jo'), ('6', 'ca'), ('6', 'qa'), ('6', 'kw'), ('6', 'lb'), ('6', 'ly'), ('6', 'ma'), ('6',
'mx'), ('6', 'om'), ('6', 'sa'), ('6', 'sy'), ('6', 'tn'), ('6', 'us'), ('5', 'az'), ('5', 'am'), ('5', 'ad'), ('5', 'al'), ('2', 'sk'), ('2', 'si'), ('2', 'cz'), ('2', 'hu'), ('3', 'lu'), ('3',
'mc'), ('3', 'nl'), ('3', 'pl'), ('3', 'se'), ('7', 'zw');

CREATE TABLE `eu_vat` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `﻿iso` varchar(2) NOT NULL DEFAULT '',
  `tax1` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `tax2` decimal(10,2) unsigned DEFAULT NULL,
  `tax3` decimal(10,2) unsigned DEFAULT NULL,
  `tax_name` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `eu_vat` ( `id`, `﻿iso`, `tax1`, `tax2`, `tax3`, `tax_name`)
VALUES ( '1', 'AT', '20.00', '10.00', '13.00', 'USt'),
( '2', 'BE', '21.00', '6.00', '12.00', 'TVA'),
( '3', 'BG', '20.00', '9.00', NULL, 'ДДС'),
( '4', 'CY', '19.00', '5.00', '9.00', 'ΦΠΑ'),
( '5', 'CZ', '21.00', '10.00', '15.00', 'DPH'),
( '6', 'DE', '19.00', '7.00', NULL, 'MwSt'),
( '7', 'DK', '25.00', NULL, NULL, 'Moms'),
( '8', 'EE', '20.00', '9.00', NULL, 'km'),
( '9', 'EL', '24.00', '6.00', '13.00', 'ΦΠΑ'),
( '10', 'ES', '21.00', '10.00', NULL, 'IVA'),
( '11', 'FI', '24.00', '10.00', '14.00', 'ALV'),
( '12', 'FR', '20.00', '5.50', '10.00', 'TVA'),
( '13', 'GB', '20.00', '5.00', NULL, 'VAT'),
( '14', 'HR', '25.00', '5.00', '13.00', 'PDV'),
( '15', 'HU', '27.00', '5.00', '18.00', 'ÁFA'),
( '16', 'IE', '23.00', '9.00', '13.50', 'VAT'),
( '17', 'IT', '22.00', '5.00', '10.00', 'IVA'),
( '18', 'LV', '21.00', '12.00', NULL, 'PVN'),
( '19', 'LT', '21.00', '5.00', '9.00', 'PVM'),
( '20', 'LU', '17.00', '8.00', NULL, 'TVA'),
( '21', 'MT', '18.00', '5.00', '7.00', 'VAT'),
( '22', 'NL', '21.00', '6.00', NULL, 'BTW'),
( '23', 'PL', '23.00', '5.00', '8.00', 'PTU'),
( '24', 'PT', '23.00', '6.00', '13.00', 'IVA'),
( '25', 'RO', '19.00', '5.00', '9.00', 'TVA'),
( '26', 'SE', '25.00', '6.00', '12.00', 'Moms'),
( '27', 'SI', '22.00', '9.50', NULL, 'DDV'),
( '28', 'SK', '20.00', '10.00', NULL, 'DPH');

INSERT INTO `help` (`parent`, `header`, `body`, `sort`, `tooltip`, `language`) VALUES
('9923', 'Titel ', '<p>Geben Sie hier einen Namen des Produktes an, welches sie im Webshop anlegen möchten.</p>', '90', 'products.title', 'de'),
('9923', 'Artikelnummer', '<p>Geben Sie hier die interne Produktkennzeichnung an. <span class="haupttext">Es handelt sich um eine Kurzbezeichnung des Artikels <span style="text-decoration: underline;"></span>bestehend aus Buchstaben und/oder Ziffern.<span style="text-decoration: underline;"></span></span></p>', '110', 'products.product_no', 'de'),
('9923', 'externe Artikelnummer', '<p>Geben Sie hier - falls vorhanden - eine abweichende externe Produktkennzeichnung an. (zB Lieferanten- und Händler-Artikelnummer)</p>', '120', 'products.product_no_ext', 'de'),
('9923', 'Beschreibung', '<p>Geben Sie hier eine möglichst genaue Beschreibung des Produktes ein.</p>', '220', 'products.specification', 'de'),
('9923', 'Warengruppe', 'Legen Sie hier die Warengruppe fest, zu welcher das Produkt hinzugefügt werden soll.\r\nUnter einer Warengruppe versteht man im Handel die Zusammenfassung einzelner Artikel anhand eines gemeinsamen Merkmals zu einer Gruppe.</p><p>Hinweis: Wenn sich in ihrem Webshop mehr als 100 Warengruppen befinden, erfolgt die Auswahl mittels "Type Ahead Find". Es reicht zunächst einen Buchstaben einzugeben, daraufhin werden jene Warengruppen durchsucht, die diesen Buchstaben enthalten. Geben Sie einen weiteren Buchstaben ein, werden die Gruppen nach der Zeichenkombination durchsucht. So lässt sich auch nach kompletten Wörtern suchen. Wählen Sie unter den Vorschlägen die gewünschte Warengruppe aus.</p>', '150', 'products.parent', 'de'),
('9923', 'Steuersatz', '<p>Legen Sie hier den zu geltenden Steuersatztarif - zum Beispiel 20 Prozent Umsatzsteuer - fest.</p>', '200', 'products.tax', 'de'),
('9923', 'Preis', '<p>Legen Sie hier den Preis des Produktes fest. In der Konfiguration kann bestimmt werden, ob die hier eingegebenen Preise Brutto- oder Nettoangaben sind.<br></p>', '180', 'products.price', 'de'),
('9922', 'Titel', '<p>Legen Sie hier einen Titel der Warengruppe fest, welche Sie im Webshop anlegen möchten.<br></p><p> Unter einer Warengruppe oder Category versteht man im Handel die Zusammenfassung einzelner Artikel anhand eines gemeinsamen Merkmals zu einer Gruppe. Als verbindende Merkmale kommen zB Herkunft, Verwendungszweck oder Herstellungsmaterial zum Tragen.</p>', '20', 'goodsgroup.title', 'de'),
('9922', 'Bild', '<p>Sie haben die Möglichkeit, dem Artikel ein Bild der Bildformate "jpg", "png", oder "gif" beizufügen. Mit dem Button neben dem Feld "Bild hochladen" suchen Sie mit der von Ihrem Betriebssystem vertrauten Dateimaske nach der gewünschten Bilddatei und wählen diese aus. Beim Speichern wird das Bild nun auf den Server hochgeladen, skaliert, und mit dem Artikel verknüpft. <br></p> <p>Um ein bereits vorhandenes Bild (Das heißt: ein Bild, das schon zuvor etwa in der Bilddatenbank hochgeladen worden ist.) auszuwählen, klicken Sie auf den auf das Ordnersymbol. Wählen Sie nun im Bild-Assistenten das gewünschte Bild aus. Die in Kategorien und Seiten eingeteilte Baumstruktur hilft Ihnen beim Suchen. Aktuelle Bilder sind in den vorderen Seiten zu finden.</p>', '40', 'goodsgroup.picture', 'de'),
('9923', 'Lagerstands-Warnung', '<p>Legen Sie hier fest ab welcher Stückzahl eine Lagerstands-Warnung&nbsp; angezeigt werden soll. Im Webshop wird das Produkt dann mit "nur noch wenige Stück verfügbar" angezeigt. Im CMS wird das Produkt dann ebenfalls in der Lagerstands-Warnung aufgelistet. Auf diese Weise erhalten Sie einen Überblick über den Lagerstand und können rechtzeitig darauf reagieren.<br></p>', '310', 'products.low_stock', 'de'),
('9923', 'Hersteller', '<p>Hier können Sie einen bestimmten Hersteller ihres Produktes auswählen.  Die Auswahl muss nicht zwingend erfolgen, sondern ist optional. Um diese jedoch auswählen zu können, müssen diese in der Warenwirtschaft unter dem Punkt "Hersteller" erst angelegt werden.</p>', '210', 'products.provider', 'de'),
('9923', 'Einheit', '<p> Unter diesem Punkt kann eine Maßeinheit festgelegt werden, zu welcher das Produkt verkauft wird. </p> <p>Beispiele dafür sind:</p> <ul> <li>Stückanzahl<br></li> <li>Gewichtsmaße (Kilogramm, Gramm...)</li> <li>Längenmaße (Meter, Centimeter...) <br></li> </ul>', '100', 'products.unit', 'de'),
('9923', 'Lagerstand', '<p>Hier können sie die Anzahl der Einheiten angeben, die Sie bei Neuanlage des Produktes auf Lager haben. Bei Auslieferung einer eingelangten Bestellung wird der Lagerbestand automatisch aktualisiert, sodass dieser hier immer aktuell einsehbar ist.</p>', '170', 'products.stock', 'de'),
('9923', 'Sortieren', '<p> Um die Position des Erscheinens des aktuellen Produkts unter einem Menüpunkt zu definieren gibt es das Sortierfeld:</p> <p>Sollte z.B. das Produkt Platz 2 einnehmen und das erste Produkt hat die Sortierreihenfolge 10 und das zweite Produkt hat die Sortierreihenfolge 20, dann tragen Sie in der Eingabemaske des neuen Produkts unter "Sortieren" einen Wert zwischen 10 und 20, z.B. 15 ein. Das Produkt rutscht dann automatisch auf die gewollte Position.</p> <p><strong>Alternative - Nachträgliches Sortieren:</strong> In der Listenansicht lassen sich die Produkte durch komplette Umnummerierung der Sortierreihenfolge beliebig ordnen. Man kann auch ohne weiteres ohne Zehnerschritte mit 1,2,3 etc die gewünschte Reihenfolge herbeiführen, oder auch einzelne Produkte mit dazwischen schieben. Ist die gewünschte Reihenfolge festgelegt, auf den Button "Sortieren" klicken.<br> </p>', '160', 'products.sort', 'de'),
('9923', 'veröffentlicht', 'Die Auswahl ermöglicht es Ihnen, Produkte im Webshop zu aktivieren bzw. zu deaktivieren. Damit können Produkte für Kunden unsichtbar gemacht werden, ohne den Artikel löschen zu müssen.', '140', 'products.published', 'de'),
('9923', 'Spezialpreis', '<p>Um Preisaktionen für einzelne Produkte durchführen zu können, ist es unter diesem Punkt möglich, einen vergünstigten Spezialpreis einzugeben. Dieser wird dann im Webshop anstatt des Normalpreises angezeigt und bei jeder Bestellung berücksichtigt.</p>', '190', 'products.special_price', 'de'),
('9921', 'Webshop - Warenwirtschaft', '<p>Finden Sie hier alle Funktionen für Ihren Webshop etwa, um Waren für den Verkauf anzulegen, zu beschreiben und anschließend die Bestellungen abzuwickeln. </p>', '10', 'common.webshop', 'de'),
('9923', 'Bild', '<p>Sie haben die Möglichkeit, der Produktbeschreibung ein Bild der Bildformate "bmp", "jpg", "png", "tif" oder "gif" beizufügen. Mit dem Button neben dem Feld "Bild hochladen" suchen Sie mit der von Ihrem Betriebssystem vertrauten Dateimaske nach der gewünschten Bilddatei und wählen diese aus. Beim Speichern wird das Bild nun auf den Server hochgeladen, skaliert, und mit dem Produkt verknüpft. <br></p> <p>Um ein bereits vorhandenes Bild (Das heißt: ein Bild, das schon zuvor etwa in der Bilddatenbank hochgeladen worden ist.) auszuwählen, klicken Sie auf auf das Ordnersymbol. Wählen Sie nun im Bild-Assistenten das gewünschte Bild aus. Die in Kategorien und Seiten eingeteilte Baumstruktur hilft Ihnen beim Suchen. Aktuelle Bilder sind in den vorderen Seiten zu finden.</p>', '130', 'products.picture', 'de'),
('9923', 'Farbe', '<p>Hier können Sie die Farbe des Produktes festlegen.</p><p>Dieses Feld dient der besseren Unterscheidung gleicher Produkte in unterschiedlichen Farben.</p>', '270', 'products.colour', 'de'),
('9923', 'Größe', '<p>Hier können Sie die Größe des Produktes festlegen.</p><p>Dieses Feld dient der besseren Unterscheidung gleicher Produkte in verschiedenen Größen. <br></p><p>Beispiel: S, M, L, XL<br></p>', '250', 'products.size', 'de'),
('9923', 'Gewicht', '<p>Hier können Sie das Gewicht des Produktes in Gramm festlegen.</p><p>Damit wird das Gesamtgewicht für den Versand berechnet, was gegebenenfalls zu einem höheren Porto führt.<br></p>', '260', 'products.weight', 'de'),
('9923', 'Länge', '<p>Hier können Sie die Länge des Produktes festlegen.</p><p>Dieses Feld dient der besseren Unterscheidung gleicher Produkte in unterschiedlichen Längenmaßen.</p><p>Beispiel: 1 Meter, 5 Meter, 10 Meter<br></p>', '240', 'products.length', 'de'),
('9923', 'Autor', '<p>Hier können Sie den Autor festlegen.</p><p>Dieses Feld dient der besseren Unterscheidung gleicher Produkte von unterschiedlichen Autoren.</p><p>Beispiel: Buchautoren<br></p>', '230', 'products.author', 'de'),
('9923', 'Sonstiges', '<p>Hierbei handelt es sich um ein freies Textfeld für die weitere Beschreibung des Produktes.</p>', '290', 'products.whatever', 'de'),
('9923', 'Zubehör', '<p> Um beispielsweise Komplementärprodukte (Güter, die gemeinsam nachgefragt werden) miteinander verbinden zu können, ist es hier möglich "Zubehör" aus ihrer Produktpalette auszuwählen. Bei Anzeige des aktuellen Produktes im Webshop, wird darunter auch immer das definierte Zubehörprodukt erscheinen, um eine gemeinsame Bestellung zu vereinfachen.</p><p>Tippen Sie einfach die ersten Buchstaben des gewünschten Produktes ein. Sobald es in der Auswahlliste erscheint, kann es ausgewählt werden. Das ausgewählte Produkt erscheint nun als Etikett. Sie können beliebig viel Artikel auswählen. Mit einem Klick auf das kleine "x" kann die Zuordnung wieder entfernt werden.<br></p>', '340', 'products.supplies', 'de'),
('9923', 'Empfehlung', '<p> Hier können Sie für jedes Produkt Empfehlungen aus ihrere Produktpalette auswählen, welche dann automatisch bei Aufruf des Produktes an bestimmter Position eingeblendet werden.  </p> <p>Um mehere Produkte als Empfehlung auszuwählen, halten Sie die Strg Taste gedrückt und wählen mit der Maus die einzelnen Punkte aus. Möchten Sie eine oder mehrere Empfehlungen wieder abwählen, kann die Markierung ebenfalls mit gedrückter Strg Taste und Klick auf die entsprechende Kategorie wieder entfernt werden.</p><p>Hinweis: Wenn sich in ihrem Webshop mehr als 100 Produkte befinden, erfolgt die Auswahl mittels "Type Ahead Find". Es reicht zunächst einen Buchstaben einzugeben, daraufhin werden jene Produkte durchsucht, die diesen Buchstaben enthalten. Geben Sie einen weiteren Buchstaben ein, werden die Produkte nach der Zeichenkombination durchsucht. So lässt sich auch nach kompletten Wörtern suchen. Wählen Sie unter den Vorschlägen das gewünschte Produkt aus.</p>', '330', 'products.keyword', 'de'),
('9923', 'Maximale Bestellmenge', '<p>Unter diesem Punkt kann die Menge definiert werden, welche höchstens pro Bestellung in den Warenkorb gelegt werden kann. Übersteigt bei einer Bestellung die gewünschte Anzahl die definierte Maximalmenge, erhält der Kunde eine Warnung, dass die maximale Bestellmenge überschritten ist.</p>', '320', 'products.max_order_quant', 'de'),
('9922', 'Gruppe', '<p> Hier können Sie nach und nach die Struktur ihrer Warengruppen aufbauen, welche im Webshop-Menü angezeigt wird. </p> <p>Möchten Sie die aktuelle Warengruppe einer anderen Gruppe zuordnen, wählen Sie diese im Dropdown-Menü entsprechend aus. In der Hierarchie wird diese der gewählten Gruppe untergeordnet angezeigt.<br></p> <p>Handelt es sich um einen Menüpunkt der ersten Ebene, wählen Sie WEBSHOP aus.<br></p>', '50', 'goodsgroup.parent', 'de'),
('9922', 'Sortieren', '<p>Um die Position des Erscheinens der Menüpunkte der Webshopinhalte zu definieren, gibt es das Sortierfeld:</p><p>Sollte z.B. der Menüpunkt Platz 2 einnehmen und der erste Menüpunkt hat die Sortierreihenfolge 10 und der zweite Menüpunkt hat die Sortierreihenfolge 20, dann tragen Sie in der Eingabemaske des neuen Menüpunkts unter "Sortieren" einen Wert zwischen 10 und 20, z.B. 15 ein. Der Menüpunkt rutscht dann automatisch zwischen die zwei anderen Menüpunkte.</p><p><strong>Alternative - Nachträgliches Sortieren:</strong> In der Listenansicht lassen sich die Menüpunkte durch komplette Umnummerierung der Sortierreihenfolge beliebig ordnen. Man kann auch ohne weiteres ohne Zehnerschritte mit 1,2,3 etc die gewünschte Reihenfolge herbeiführen, oder auch einzelne Menüpunkte dazwischen schieben. Ist die gewünschte Reihenfolge festgelegt, auf den Button "Sortieren" klicken.</p>', '60', 'goodsgroup.sort', 'de'),
('9924', 'Texte und Erläuterungen', '<p>Hier können Texte und Erläuterungen abgeändert oder ergänzt werden.<br></p>', '800', 'shop_messages', 'de'),
('9924', 'Währung', '<p>Geben Sie hier die Geldwährung (zum Beispiel "Euro") an, die in ihrem Webshop gilt.</p>', '280', 'shop_settings.currency', 'de'),
('9924', 'Kontodaten', '<p>Geben Sie hier ihre Geschäfts-Kontodaten an. Diese werden dem Kunden nach Einkauf mit Auswahl "Bezahlung per Vorauskassa" automatisch angezeigt.</p>', '660', 'shop_settings.account', 'de'),
('9924', 'Steuersatz bei Versandgebühren', '<p>Hier können Sie den Steuersatz der Versandgebühren wählen.</p>', '500', 'shop_settings.tax_vat', 'de'),
('9921', 'Webshop - Bestellung', '<p>Unter "Bestellung" sind alle offenen, teilweise ausgelieferten und fertig abgeschlossene Bestellungen zu finden. Um die einzelnen Bestellungen betrachten zu können, ist es möglich diese über den "Bearbeiten"-Button zu öffnen. </p> <p style="font-weight: bold;">Folgende Schritte sind notwendig um eingegangene Bestellungen zu bearbeiten:</p><p>1.) Um Bestellungen auszuliefern, muss die Checkbox der einzelnen Posten angehakt werden. Alternativ können per Klick auf das grüne Häkchen neben der Überschrift "Lieferung", alle Posten gleichzeitig ausgewählt werden.</p><p>2.) Anschließend können die Versandkosten eingegeben werden und die Gesamtsumme per Klick auf "neu berechnen" aktualisiert werden.<br></p><p>3.) Um den Prozess abzuschließen, genügt ein Klick auf "ausliefern" und man gelangt auf die nächste Seite.</p><p>4.) Hier können Sie bei Bedarf die Bestell-Email editieren, welche per Klick auf "OK" an den Kunden gesandt wird. Am unteren Seitenende finden Sie den Bestellschein, die Auftragsbestätigung, den Lieferschein und die Rechnung.</p><p style="font-weight: bold;">Um Bestellungen vor ihrer Auslieferung zu stornieren, gehen Sie folgendermaßen vor:</p><p>1.) Um Bestellungen zu stornieren, muss die Checkbox der gewünschten Posten angehakt werden. Alternativ können per Klick auf das grüne Häkchen neben der Überschrift "Stornieren", alle Posten gleichzeitig ausgewählt werden.</p><p>2.) Um den Prozess abzuschließen, genügt ein Klick auf "ausliefern" und man gelangt auf die nächste Seite.</p><p>3.) Hier können Sie bei Bedarf die Email editieren, welche per Klick auf "OK" an den Kunden gesandt wird. Auch hier finden sie am unteren Seitenende die entsprechenden Dokumente, jedoch nun passend zur Stornierung.<br></p>', '30', 'order_processing', 'de'),
('9921', 'Webshop - Werbung', '<p>Im Bereich "Werbung" können jene Produkte ausgewählt werden, welche auf der Startseite in der Promotion-Box oder als neues Produkt beworben werden sollen.</p><p>Es sollten mindestens drei Produkte für die Werbung aktiviert sein. Die maximale Anzahl der angezeigten Produkte ist in den Webshop-Eigenschaften festgehalten.<br></p><p>Setzen Sie die Eigenschaften entweder einzeln durch Anklicken des Häkchens oder pauschal mit den Checkboxen links und dem Button "Setze Eigenschaften".</p><p>Damit die Änderungen aktualisiert werden, klicken Sie auf "Website neu generieren".<br></p>', '630', 'promotion', 'de'),
('9921', 'Webshop - Hersteller', '<p>Unter "Hersteller" können Sie - bezogen auf ihre angebotenen Produkte im Webshop - die Marken, Lieferanten bzw. Unternehmen der angebotenen Waren anlegen.</p> <p>Anschließend können die angelegten "Hersteller" in der Warenwirtschaft (unter "Allgemein") ausgewählt werden, um diese bei der Produktbeschreibung auf der Webseite mitanzuzeigen.</p><p>Auf der Webseite hat der Kunde die Möglichkeit, nach den hier eingegebenen Herstellern zu suchen.<br></p>', '70', 'manufacturer', 'de'),
('9924', ' Pfad', '<p>Dieses Feld zeigt den Dateipfad, wo alle Rechnungen der Webshopbestellungen abgelegt werden. Dieser Ordner muss außerhalb des des Web-Bereiches sein, jedoch vom User des Webservers schreibbar sein. <br></p>', '750', 'shop_settings.pdf_dir', 'de'),
('9924', 'Allgemeine Geschäftsbedingungen', '<p>\r\nWählen Sie hier die Seite mit den AGB aus. Diese Seite kann dann im Bestellvorgang als Popup geöffnet werden. Die bestätigte Kenntnisnahme der AGB sind im Rahmen der E-Commerce Richtlinien festgeschrieben. Ein Zuwiderhandeln kann rechtliche Folgen haben.<br></p>', '580', 'shop_settings.GTC', 'de'),
('9923', 'Versionen eines Produktes', '<p>Falls es von diesem Produkt mehrere Versionen gibt, etwa unterschiedliche Größen oder Farben. Können hier diese Produkte gesucht und mit dem aktuellen Produkt verknüpft werden. Die Verbindung ist automatisch auch in die andere Richtung hergestellt.</p><p>Beginnen Sie einfach den Namen des Artikel einzutippen und wählen Sie ihn aus, sobald er aufscheint.<br></p><p><span style="font-weight: bold;">Tipp</span>: Unterschiedliche Versionen eines Produktes werden am einfachsten eingetragen, wenn das Ausgangsprodukt mittels "Duplizieren" vervielfältigt und bearbeitet wird.<br></p>', '300', 'products.versions', 'de'),
('9923', 'Dateiname', '<p>Hier wird der Name der Datei angezeigt, der bei erster Speicherung aus dem Titel gebildet wird. Soll der Dateiname neu erstellt werden, klicken Sie auf "Jetzt aktualisieren". Beachten Sie jedoch in diesem Zusammenhang, dass sämtliche Links sowohl auf der eigenen Seite als auch auf fremden Seiten sowie in Suchmaschinen aufgrund eines geänderten Dateinamens nicht mehr funktionieren werden.</p><p>Diese Funktion ist vor allem im Rahmen des Erstellungsprozesses gedacht, falls der Titel fehlerhaft war oder aus anderen Gründen geändert wurde.</p>', '350', 'products.file', 'de'),
('9923', 'Zeitsteuerung', '<p>Die Verfügbarkeit eines Produktes kann auch zeitgesteuert erfolgen. Das Start-Datum setzt aktiviert das Produkt, das End-Datum setzt es offline.<br></p><p>Klappen Sie den Bereich bei Bedarf aus.</p>', '360', 'products.cron', 'de'),
('9921', 'Lagerverwaltung', '<p>Die Lagerverwaltung ist eine alternative Sicht auf Ihre Produkte, die darauf ausgerichtet ist, den Lagerstand der Waren bequem zu verwalten. Aktualisieren Sie den Lagerstand am einfachsten durch Eingabe innerhalb der tabellarischen Auflistung. <br></p><p>Wenn Sie ein Produkt aufrufen, lassen sich auch andere Parameter hinsichtlich Lager- oder Buchhaltungskriterien bearbeiten. Darüber hinaus finden Sie eine Auflistung sämtlicher Lagerstandsbewegungen.<br></p>', '840', 'webshop_stock', 'de'),
('9921', 'Versandkosten', '<p>Legen Sie hier die Versandkosten der einzelnen Länderzonen und Paketgrößen an.</p><p>Die Tarife können in der tabellarischen Übersicht einfach eingetragen werden.</p><p>Für die Verteilung der einzelnen Staaten klicken Sie auf das Editiersymbol der jeweiligen Zone. Im anschließenden Formular können nun die einzelnen Länder mit STRG-Klick&nbsp; ausgewählt oder entfernt werden.</p><p>Die Übersicht gibt auch Auskunft über vergessene oder mehrfach gewählte Länder, was vermieden werden sollte.<br></p>', '820', 'webshop_freight', 'de'),
('9924', 'Preiseingabe', '<p>Legen Sie hier fest, ob der Preis in der Admin mit oder ohne Umsatzsteuer eingegeben werden soll. Dies muss unbedingt <span style="font-weight: bold;">vor Inbetriebnahme </span>des Webshops festgelegt werden und sollte dann auch <span style="font-weight: bold;">nicht geändert </span>werden.<br></p>', '370', 'shop_settings.input_price', 'de'),
('9924', 'Umsatzsteuerberechnung innerhalb der EU', '<p>Je nach Umsatz Ihres Auslandsgeschäftes kann die Umsatzsteuer innerhalb der Europäischen Union wahlweise mit dem Inlands-Steuersattz oder dem Steuersatz des Empfängerlandes verrechnet werden. Wählen Sie hier die auf Ihr Unternehmen zutreffende Variante aus. Die Einstellung kann gegebenenfalls geändert werden und wirkt sich unmittelbar auf alle folgenden Preisangaben und Bestellungen aus.<br></p>', '410', 'shop_settings.eu_vat', 'de'),
('9924', 'Bezahl-Optionen', '<p>Wählen Sie hier die verfügbaren Zahlungsmethoden aus. Für die Option Paypal brauchen Sie ein Konto bei diese Zahlungsanbieter sowie den sogenannten API-Code.<br></p>', '550', 'shop_settings.payment_options', 'de'),
('9924', 'Limit der Promotionen', '<p>Geben Sie hier ein sinnvolles Limit der Promotionen für die Startseite an. Welche Produkte hier auf der Startseite aufscheinen sollen legen Sie im Bereich "Werbung" fest.<br></p>', '610', 'shop_settings.promobox_limit', 'de'),
('9924', 'Daten zur Rechnungslegung', '<p>Geben Sie hier alle Angaben zur Rechnungslegung ein: Zahlenmuster der Rechnungsnummer, Firmenlogo sowie sämtliche Angaben zu Ihrer Firma.<br></p>', '640', 'shop_settings.invoice', 'de'),
('9924', 'Umsatzsteuersätze', '<p>Hier sind die Umsatzsteuersätze angeführt, die in den einzelnen Ländern der EU gelten und für die korrekte Preisberechnung verwendet werden. Sollten sich Steuersätze ändern, kann das hier bewerkstelligt werden. Allfällige Änderungen können auch durch Updates erfolgen.<br></p>', '790', 'shop_taxes', 'de');

INSERT INTO `help_folder` ( `name`, `short`, `parent`, `sort`, `language`, `parentsort`, `graduated`) VALUES
('Webshop', 'Webshop', '17', '30', 'de', '18', '—— Webshop'),
('Warengruppen', '', '999', '20', 'de', '20', '——— Warengruppen'),
('Produkte', '', '999', '10', 'de', '19', '——— Produkte'),
('Webshop-Einstellungen', '', '999', '30', 'de', '21', '——— Webshop-Einstellungen');

UPDATE `help` SET `parent` = (SELECT `id` FROM `help_folder` WHERE `name` = 'Webshop') WHERE `parent` = '9921';

UPDATE `help` SET `parent` = (SELECT `id` FROM `help_folder` WHERE `name` = 'Warengruppen') WHERE `parent` = '9922';
UPDATE `help` SET `parent` = (SELECT `id` FROM `help_folder` WHERE `name` = 'Produkte') WHERE `parent` = '9923';
UPDATE `help` SET `parent` = (SELECT `id` FROM `help_folder` WHERE `name` = 'Webshop-Einstellungen') WHERE `parent` = '9924';
UPDATE `help_folder` SET `parent` = (SELECT `parent` FROM `help` WHERE `header` = 'Webshop - Warenwirtschaft') WHERE `parent` = '999';


CREATE VIEW `turnover` AS select `order_items`.`product` AS `product`,`order_items`.`amount` AS `amount`,(`order_items`.`price` * ((100 - `order_items`.`discount`) / 100)) AS `price`,`webshop_order`.`id` AS `oid`,`webshop_order`.`payed_date` AS `date` from (`order_items` join `webshop_order`) where ((`webshop_order`.`id` = `order_items`.`order_id`) and (`webshop_order`.`payed` = 'on'));

CREATE VIEW `products_view` AS (select `products`.`id` AS `id`,`products`.`pid` AS `pid`,`products`.`product_no` AS `product_no`,
	`products`.`product_no_ext` AS `product_no_ext`,`products`.`stock` AS `stock`,`products`.`free` AS `free`,`products`.`price` AS `price`,`products`.`tax` AS `tax`,`products`.`weight` AS `weight`,
	`products`.`special_price` AS `special_price`,`products`.`max_order_quant` AS `max_order_quant`,`products`.`low_stock` AS `low_stock`,
	`products`.`promotion` AS `promotion`,`products`.`new` AS `new`,`content`.`title` AS `title`,`content`.`parent` AS `parent`,
	`content`.`picture` AS `picture`,`content`.`published` AS `published`,`content`.`file` AS `file`
	from (`products` left join `content` on((`products`.`pid` = `content`.`id`))) where (`content`.`type` = 'products'));

CREATE  VIEW `webshop_order_view` AS (SELECT `webshop_order`.`id`, CONCAT (`clients`.`name`, ' ', `clients`.`prename`) AS `client`,
`webshop_order`.`date`, `webshop_order`.`total`, `webshop_order`.`freight`, `webshop_order`.`weight`, `webshop_order`.`payment`,
`webshop_order`.`payed`, `webshop_order`.`note`, `webshop_order`.`status`, `webshop_order`.`lang`, `webshop_order`.`payed_date`
FROM `webshop_order`, `clients` WHERE `webshop_order`.`client` = `clients`.`id`);
