CREATE TABLE `block_content` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(128) DEFAULT NULL,
  `content` text,
  `type` varchar(16) DEFAULT NULL,
  `sort` bigint(20) NOT NULL DEFAULT '10',
  `template` varchar(64) NOT NULL DEFAULT '',
  `parent` bigint(20) DEFAULT NULL,
  `active` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `block_galleries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL,
  `gallery` bigint(20) unsigned NOT NULL DEFAULT '0',
  `portfolio` bigint(20) unsigned DEFAULT NULL,
  `active` varchar(2) DEFAULT NULL,
  `sort` bigint(20) unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`id`),
  KEY `gallery` (`gallery`,`portfolio`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `block_gal_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `picture` varchar(128) NOT NULL DEFAULT '',
  `caption` varchar(128) DEFAULT NULL,
  `copyright` varchar(64) DEFAULT NULL,
  `gal_group` bigint(20) unsigned NOT NULL DEFAULT '0',
  `sort` bigint(20) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `content_types` (`type`, `name`, `icon`, `icon_add`, `new_in_type`, `generate`, `move`)
VALUES ('serial_page', 'serial_page', 'serial_page', 'serial_page', 'root,folder,node', '1', '1');

INSERT INTO `register` (`name`, `call`, `plugin`, `tab`, `params`, `gui`, `top`, `start`, `group`, `icon`, `image`, `level`, `sort`, `frontend`) VALUES
('serial_page', 'serial_page', 'serial_page', '6', '', '1', '', 'on', '', 'pages', '', '1', '300', ''),
('block_content', 'block_content', 'serial_page', '7', '', '1', '', '', '', 'default', '', '1', '0', ''),
('block_gal', 'block_gal', 'serial_page', '7', '', '1', '', '', '', 'default', '', '1', '0', ''),
('block_gal_images', 'block_gal_images', 'serial_page', '7', '', '5', '', '', '', 'default', '', '1', '0', '');

INSERT INTO `html_snippets` (`key`, `code`, `group`, `description`) VALUES 
('cms_serial_page_block1', '<div id="block_1" class="box clrfx">\r\n<h2>&&&&title&&&&</h2>\r\n&&&&content&&&&\r\n</div>', '14', ''),
('cms_serial_galleries', '<div class="col w3 clrfx">\r\n&&&&list&&&&\r\n<p>&&&&title&&&&</p>\r\n</div>', '14', ''),
('cms_serial_gal_img', '<a href="/pictures/normal/&&&&picture&&&&" data-app="lightbox" class="hidden"><img src="/pictures/square/&&&&picture&&&&" width="57" height="57" alt=" " /></a>', '14', ''),
('cms_serial_gal_first_img', '<a href="/pictures/normal/&&&&picture&&&&" data-app="lightbox"><img src="/pictures/small/&&&&picture&&&&" width="&&&&width&&&&" height="&&&&height&&&&" alt=" " /></a>', '14', ''),
('cms_pages_body_serial', '<body>\r\n&&&&WAI_BOX&&&&\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n\r\n<!--content area -->\r\n<div id="content_area" class="col w12 clrfx">\r\n\r\n<!--main col-->\r\n<main id="content" class="col w9 first">\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n&&&&PIWIK&&&&\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>', '5', '');

INSERT INTO `i18n` (`index`, `group`, `en`, `de`) VALUES 
('serial_page', 'common', 'Serial Page', 'Serielle Seite');


