CREATE TABLE `articles` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) UNSIGNED NOT NULL,
  `subtitle` varchar(200) DEFAULT NULL,
  `lead` text DEFAULT NULL,
  `articlebody` text NOT NULL,
  `authorshort` char(3)  DEFAULT NULL,
  `content` char(2) DEFAULT NULL,
  `top` char(2) DEFAULT NULL,
  `news_template` tinyint(4) NOT NULL DEFAULT '1',
  `picturetext` varchar(255) DEFAULT NULL,
  `copyright` varchar(32) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `rubrics` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `art_limit` tinyint(10) NOT NULL,
  `top` varchar(2) DEFAULT NULL,
  `rss` varchar(2) DEFAULT NULL,
  `container` varchar(64) NOT NULL,
  `container_small` varchar(64) NOT NULL,
  `teaser` varchar(64) NOT NULL,
  `teaser_small` varchar(64) NOT NULL,
  `teaser_picture` varchar(64) NOT NULL,
  `refer_to` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `articles_keywords` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `keyword` varchar(126) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `content_types` (`type`, `name`, `icon`, `icon_add`, `new_in_type`, `generate`, `move`)
VALUES ('article', 'article', 'newspaper-blue', 'newspaper-blue-add', 'rubric', 0, 1),
('rubric', 'rubric', 'sitemap-blue', 'sitemap-blue-add', 'root,rubric', 1, 0);

INSERT INTO `cms_settings` (`key`, `value`, `group`, `lang`, `rule`)
VALUES ('top_news_limit', '2', 'news', '*', '1'),
('news_template', '2', 'news', '*', '1');

INSERT INTO `i18n` (`index`, `group`, `en`, `de`) VALUES
('articles', 'common', 'News', 'Nachrichten'),
('new_article', 'common', 'Add News', 'Neue Nachricht'),
('authorshort', 'news', 'Author Abbreviation', 'Autorenkürzel'),
('subtitle', 'news', 'Subtitle', 'Untertitel'),
('lead', 'news', 'Lead', 'Vorspann'),
('add_tags', 'common', 'Add Tag', 'Tag hinzufügen'),
('picturetext', 'common', 'Caption', 'Bildunterschrift'),
('topnews', 'news', 'Top News', 'Top Nachrichten'),
('only_article', 'common', 'News only', 'Nur Nachrichten'),
('article', 'common', 'News Article', 'Nachricht'),
('rubric', 'common', 'Rubric', 'Rubrik'),
('art_limit', 'news', 'Number of articles in teaser of the rubric', 'Anzahl der Artikel im Teaser der Rubrik'),
('r_container', 'news', 'Container of rubric teaser', 'Container des Rubrik-Teasers'),
('r_teaser', 'news', 'News in teaser', 'Nachricht im Teaser'),
('r_container_small', 'news', 'Container of short rubric teaser', 'Container des kurzen Rubrik-Teasers'),
('r_teaser_small', 'news', 'News in short teaser', 'Nachricht im kurzen Teaser'),
('top_news_limit', 'news', 'Limit of topnews', 'Limit der Topnachrichten'),
('short_message', 'news', 'Short Message', 'Kurznachricht'),
('related_news', 'common', 'Related News', 'Mehr zum Thema'),
('news_settings', 'common', 'News Settings', 'Nachrichten Einstellungen'),
('refer_to', 'common', 'refers to...', 'bezieht sich auf...');

INSERT INTO `i18n` SET `index` = 'insert_news', `group` = 'common', `de` = 'Nachricht einfügen', `en` = 'Insert News';
INSERT INTO `i18n` SET `index` = 'insert_content', `group` = 'common', `de` = 'Inhaltsverzeichnis einfügen', `en` = 'Insert Content';


INSERT INTO `help` (`parent`, `header`, `body`, `sort`, `tooltip`, `language`) VALUES
('199999999', 'Titel', '<p>Geben Sie hier einen aussagekräftigen Titel ein.<br></p>', '110', 'article.title', 'de'),
('199999999', 'Sprache', '<p>Die Sprache ergibt sich aus der Auswahl des Sprachbereichs, aus der heraus der Nachrichtenartikel angelegt wurde. Wollen Sie eine andere Sprache verwenden, wählen Sie im linken Baum  eine andere Rubrik des gewünschten Sprachbereichs aus und gehen dann auf  "Neuer Eintrag" und "Nachricht".<br></p>', '880', 'article.lang', 'de'),
('199999999', 'Rubrik', '<p>Wählen Sie hier die Rubrik, in der die Nachricht aufscheinen soll. Rubriken sind themenbezogene Zusammenfassungen von Nachrichten. Eine Nachricht kann nur in einer Rubrik stehen.<br></p>', '990', 'article.parent', 'de'),
('199999999', 'Vorlage', '<p>Wählen Sie hier eine passende Vorlage für die Gestaltung des Artikels aus. Sie unterscheiden sich geringfügig, wobei Kurznachricht für das Erscheinungsbild einer kurzen Nachricht optimiert ist.<br></p>', '1060', 'article.news_template', 'de'),
('199999999', 'Sortieren', '<p>Die Nachrichten erscheinen in den&nbsp; \r\nInhaltsverzeichnissen der Rubriken in der Reihenfolge ihrer Eingabe. Das heißt: die \r\nzuletzt erstellte Nachricht ist als erste zu sehen. Um die Reihenfolge \r\nbeliebig zu manipulieren, gibt es das Sortierfeld.</p><p>Sortierungen können bequemer in der Tabellenübersicht vorgenommen werden.<br></p>', '1080', 'article.sort', 'de'),
('199999999', 'Zeitsteuerung', '<p>Die Veröffentlichung kann auch zeitgesteuert erfolgen. Das Start-Datum setzt die Nachricht in den Modus "veröffentlicht", das Ende-Datum setzt sie offline.</p><p>Sollte auch die Option Top Nachrichten aktiviert sein, erfolgt die Veröffentlichung im Top-Bereich, andernfalls in der ausgewählten Rubrik.<br></p><p>Klappen Sie den Bereich bei Bedarf aus.<br></p>', '1150', 'article.cron', 'de'),
('199999999', 'Bild hinzufügen', '<p>Sie können Ihren Nachrichten auf zwei Arten ein Bild hinzufügen:</p><ol><li>Das Bild befindet sich in Form einer digitalen Bilddatei (JPG, GIF, PNG) auf Ihrem Rechner.<br>In diesem Fall gehen Sie unter "<strong>Bild hochladen</strong>"\r\n auf "Durchsuchen". Es öffnet sich ein Fenster, mit dessen Hilfe Sie \r\neine Bilddatei von der Festplatte Ihres Computers auswählen können. <br></li><li>Das Bild wurde bereits hochgeladen und befindet sich in der Bilddatenbank.<br>Klicken Sie unter "<strong>vorhandenes Bild</strong>"\r\n auf das Ordnersymbol. Es öffnet sich ein Fenster, mit dessen Hilfe Sie \r\neine Bilddatei aus der Bilddatenbank auswählen können. Der Dateiname \r\nsowie die Kleindarstellung des Bildes werden angezeigt.</li></ol><p>Das Bild ist der Nachricht für diverse Inhaltsverzeichnisse zugeordnet. Weitere Bilder lassen sich bei Bedarf im Textkörper integrieren.<br></p>', '1500', 'article.picture', 'de'),
('199999999', 'Urheberrecht', '<p>Geben Sie hier den Inhaber der Urheberrechte an. Diese Angabe wird angezeigt und kann Ihnen möglicherweise unangenehme "Anwälte" vom Leib halten.<br></p>', '1540', 'article.copyright', 'de'),
('199999999', 'Bildunterschrift', '<p>Geben Sie hier bei Bedarf die Bildunterschrift des Bildes ein.<br></p>', '1550', 'article.picturetext', 'de'),
('199999999', 'Untertitel', '<p>Der\r\nUntertitel hilft in Kombination mit dem Titel den Inhalt des Artikels\r\nzu präzisieren und den Leser noch neugieriger zu machen. Je nach Konfiguration erscheint der Untertitel\r\nauch im Inhaltsverzeichnis. Seine Eingabe ist jedoch optional, das Feld\r\nmuss daher nicht unbedingt ausgefüllt werden. \r\n</p>', '490', 'article.subtitle', 'de'),
('199999999', 'Vorspann', '<p>Hier\r\nsollte in maximal zwei Sätzen der Inhalt des Artikels umrissen\r\nwerden.\r\nDer Vorspann ist optisch hervorgehoben und erscheint je nach Konfiguration im Inhaltsverzeichnis. Die\r\nEingabe ist optional.\r\n</p>', '680', 'article.lead', 'de'),
('199999999', 'Veröffentlichen', '<p>Hier wird der Status der Veröffentlichung angegeben. Eine Nachricht kann offline, also für Besucher uneinsichtig sein, was eine gute Wahl ist, solange die Nachricht noch nicht fertiggestellt ist.</p><p>Eine veröffentlichte Nachricht ist im Inhaltsverzeichnis der gewählten Rubrik und in der Suche auffindbar.</p>', '940', 'article.published', 'de'),
('199999999', 'Einen Tag hinzufügen', '<p>Nachrichten lassen sich durch Begriffe assoziativ miteinander verbinden. Diese Auszeichnungen oder Tags erzeugen dadurch eine Auflistung sinnverwandter Nachrichten. Mit Hilfe des Type-Ahead-Felds lassen sich vorhandene Tags suchen, respektive neue hinzufügen. Mit einem vorhandenen Begriff werden die zeitlich naheliegendsten Nachrichten mit dem selben Tag angezeigt. Mit einem neuen Begriff, können künftige Artikel mit dem aktuellen verbunden werden.</p><p>In der Regel wird es sinnvoll sein, ein bis drei Tags hinzuzufügen.<br></p>', '1030', 'article.keywords', 'de'),
('199999999', 'Nachrichten', '<p>Das Nachrichten-Modul erlaubt die Verwaltung von Nachrichtenartikel. Diese bieten eine aktuelle Information für einen <span style="font-weight: bold;">kürzeren</span>\r\n Zeitraum. Die einzelnen Artikel erzeugen pro Rubrik \r\nInhaltsverzeichnisse, die wie Seiten verfügbar gemacht werden.</p><p>Neue \r\nNachrichten ersetzen automatisch die älteren, sobald ein definierbares \r\nLimit überschritten ist.<br></p><p>Ob ein Mini-Blog oder ein weitverzweigtes Online Magazin – richten Sie so viele Rubriken und \r\nUnterrubriken ein, wie Sie brauchen.<br></p>', '20', 'article', 'de'),
('199999999', 'Nachrichten', '<p>Erstellen von Nachrichtenartikel<br></p>', '10', 'common.article', 'de'),
('199999999', 'Top Nachrichten', '<p>Wichtige und aktuelle Nachrichten können für den Top-Bereich aktiviert werden, wodurch Nachrichten prominent und auffällig platziert werden. In den Nachrichten-Einstellungen legen Sie die Anzahl der Top Nachrichten fest.</p><p>Nachrichten, die durch aktuellere (oder vorgereihte) Top Nachrichten verdrängt werden, sind danach wieder in ihrer Rubrik zu finden.<br></p>', '960', 'article.top', 'de'),
('199999999', 'Titel der Rubrik', '<p>Geben Sie hier den Titel der Rubrik ein.<br></p>', '1560', 'rubric.title', 'de'),
('199999999', 'Sprache', '<p>Die Sprache ergibt sich aus der Auswahl des Sprachbereiches, aus der heraus die Rubrik angelegt wurde. Wollen Sie eine andere Sprache verwenden, wählen Sie im linken Baum einen anderen Sprachbereich oder Ordner dieses Bereiches aus und gehen dann auf  "Neuer Eintrag" und "Rubrik".<br></p>', '1590', 'rubric.lang', 'de'),
('199999999', 'Ordner der Rubrik', '<p>Der Ordner zeigt an, wo die Rubrik in der Menüstruktur aufscheint. Rubriken können ausschließlich im Wurzelverzeichnis "Home" oder in einer Rubrik als Unterrubrik angelegt werden.<br></p>', '1600', 'rubric.parent', 'de'),
('199999999', 'Sortieren', '<p>Die Reihenfolge der Rubriken lässt sich hier in gewohnter Weise festlegen.<br></p><p>Sortierungen können bequemer in der Tabellenübersicht vorgenommen werden.<br></p>', '1620', 'rubric.sort', 'de'),
('199999999', 'Vorlagen für Rubrik-Teaser', '<p>Sie finden hier eine Auswahl von vorgefertigten oder selbst erstellten HTML-Vorlagen für die jeweiligen Bereiche.</p>\r\n\r\n<p>Die Auswahl ergibt sich aus der Namenskonvention der HTML-Vorlagen. Nicht jede Auswahl macht Sinn. Dafür bleibt das System für selbst erstellte Vorlagen flexibel.</p>\r\n\r\n<p>Neben den Standard-Vorgaben machen folgende Kombinationen Sinn:</p>\r\n\r\n<p><span style="font-weight: bold;">Zweispaltige Vorlage:</span></p>\r\n\r\n<ul>\r\n\t<li>Container des Rubrik-Teasers: cms_articles_rubric_cols</li>\r\n\t<li>Nachricht im Teaser: cms_articles_teaser_2col</li>\r\n</ul>\r\n\r\n<p><span style="font-weight: bold;">Dreispaltige Vorlage:</span></p>\r\n\r\n<ul>\r\n\t<li>Container des Rubrik-Teasers: cms_articles_rubric_cols</li>\r\n\t<li>Nachricht im Teaser: cms_articles_teaser_3col</li>\r\n</ul>\r\n\r\n<p>Für die kleinen Teaser gibt es keine vorgefertigten Alternativvarianten.</p>\r\n', '1630', 'rubric.templates', 'de'),
('199999999', 'Veröffentlichen der Rubrik', '<p>Hier wird der Status der Veröffentlichung angegeben. Eine Rubrik kann offline also für Besucher uneinsichtig sein.<br></p><p>Eine veröffentlichte Rubrik wird angezeigt sobald sich darin Nachrichten befinden.<br></p><p>Eine Rubrik kann wie eine Seite oder ein Ordner auch in der Menüleiste integriert werden, in diesem Fall wird der dritte Punkt ausgewählt.<br></p>', '1610', 'rubric.published', 'de'),
('199999999', 'Anzahl der Artikel im Teaser der Rubrik', '<p>Die Teaser-Boxen der Rubriken zeigen eine begrenzte Anzahl von aktuellen (oder vorgereihten) Nachrichten an. Geben Sie hier ein, wie viele das für diese Rubrik sein sollen.</p><p>Die Anzahl der Nachrichten kann bei Teasern mit Spalten-Vorlagen abweichen, da eine Reihe von Spalten aus Layout-technischen Gründen komplett sein muss.<br></p>', '1580', 'rubric.art_limit', 'de'),
('199999999', 'Vorlagen', '<p>Sollten mehrere Vorlagen für das Seiten-Layout vorliegen, kann hier die entsprechende Vorlage gewählt werden.</p><p> \r\n  Die Vorlagen können von Benutzern mit Status Administrator verwaltet werden.</p>', '980', 'pages.template', 'de'),
('199999999', 'Kurztitel', '<p>Der Kurztitel wird für den Menü-Eintrag verwendet, er sollte mit dem Titel nachvollziehbar zusammenhängen, muss jedoch entscheidend kurz sein.<br></p>', '1570', 'rubric.short', 'de'),
('199999999', 'Limit der Topnachrichten', '<p>Geben Sie hier an, wie viele Nachrichten im Top-Bereich maximal angezeigt werden sollen.<br></p>', '1640', 'news_settings.top_news_limit', 'de'),
('199999999', 'Seiten-Layout-Vorlage', '<p>Wählen Sie hier das Seiten-Layout für die Nachrichten aus.<br></p>', '1650', 'news_settings.news_template', 'de'),
('199999999', 'Newsletter', '<p>Soll diese Rubrik im Newsletter aufscheinen?</p><p>Das Newsletter-Modul lässt in Verbindung mit dem Nachrichten-Modul das Einfügen von Nachrichten-Inhaltsverzeichnissen zu. Für ein selektives Vorgehen können die einzelnen Rubriken hier für den Newsletter aktiviert oder deaktiviert werden.<br></p>', '1530', 'rubric.top', 'de'),
('199999999', 'Dateiname', '<p>Hier wird der Name der Datei angezeigt, der bei erster Speicherung aus dem Titel gebildet wird. Soll der Dateiname neu erstellt werden, klicken Sie auf "Jetzt aktualisieren". Beachten Sie jedoch in diesem Zusammenhang, dass <span style="font-weight: bold;">sämtliche Links</span> sowohl auf der eigenen Seite als auch auf fremden Seiten sowie in Suchmaschinen aufgrund eines geänderten Dateinamens <span style="font-weight: bold;">nicht mehr funktionieren werden</span>.</p><p>Diese Funktion ist vor allem im Rahmen des Erstellungsprozesses gedacht, falls der Titel fehlerhaft war oder aus anderen Gründen geändert wurde.<br></p>', '930', 'article.file', 'de');

INSERT INTO `help_folder` ( `name`, `short`, `parent`, `sort`, `language`)
VALUES ('Nachrichten-Modul', '', '17', '20', 'de');

UPDATE `help` SET `parent` = (SELECT `id` FROM `help_folder` WHERE `name` = 'Nachrichten-Modul') WHERE `parent` = '199999999';

INSERT INTO `html_snippets` (`key`, `code`, `group`, `description`) VALUES
('cms_articles_rubric', '&&&&title&&&&\r\n<div id="news_rubric_&&&&id&&&&" class="rubric_box row clrfx">\r\n\t<ul class="listing">\r\n\t&&&&content&&&&\r\n\t</ul>\r\n</div>', '8', 'box of a rubric'),
('cms_articles_teaser', '<li id="news_teaser_&&&&id&&&&" class="clrfx">\r\n<div class="col w4 first clrfx">&&&&picture&&&&</div>\r\n<div class="col w8 last clrfx">\r\n<div class=\'dateofarticle\'>&&&&wdate&&&&</div>\r\n<h3><a href=\'&&&&file&&&&\'>&&&&title&&&&</a></h3>\r\n<p class=\'content\'>&&&&subtitle&&&&<br />&&&&lead&&&&</p>\r\n&&&&more&&&& \r\n<!-- A=article ID=&&&&id&&&& -->\r\n</div>\r\n</li>\r\n', '8', 'standard news-teaser'),
('cms_articles_teaser_small', '<li><a href=\'&&&&file&&&&\'>&&&&title&&&&</a></li>', '8', 'standard news listing'),
('cms_articles_body1', '<article>\r\n\t<div class=\'dateofarticle\'>&&&&wdate&&&& &&&&utime&&&&</div>\r\n\t<h1>&&&&title&&&&</h1>\r\n\t&&&&subtitle&&&&\r\n\t&&&&lead&&&&\r\n\t&&&&author&&&&\r\n\t<div class="col w6 m6 first">&&&&share_buttons&&&&</div>\r\n\t<div class="col w6 m6 right">&&&&print&&&&</div>\r\n\t&&&&picture&&&&\r\n\t&&&&articlebody&&&&\r\n\t&&&&related_news&&&&\r\n</article>', '8', 'Default template for articles'),
('cms_articles_picture_big', '<div class="imageBlock">\r\n<img alt="&&&&alt&&&&" src="&&&&src&&&&" height="&&&&height&&&&" width="&&&&width&&&&" />\r\n&&&&copyright&&&&\r\n&&&&picturetext&&&&\r\n</div>\r\n', '8', 'big picture for articles'),
('cms_articles_picture', '<div class="rightfloat">\r\n\t&&&&resize&&&&<img alt="&&&&alt&&&&" src="&&&&src&&&&" height="&&&&height&&&&" width="&&&&width&&&&">&&&&eziser&&&&\r\n\t&&&&picturetext&&&&\r\n\t&&&&copyright&&&&\r\n</div>', '8', 'full picture with text and copyright'),
('cms_articles_body2', '<article>\r\n\t<div class=\'dateofarticle\'>&&&&wdate&&&& &&&&utime&&&&</div>\r\n\t<h1>&&&&title&&&&</h1>\r\n\t&&&&subtitle&&&&\r\n\t&&&&picture&&&&\r\n\t&&&&lead&&&&\r\n\t&&&&share_buttons&&&&\r\n\t&&&&articlebody&&&&\r\n\t&&&&authorshort&&&&\t\r\n\t&&&&print&&&&\r\n\t&&&&related_news&&&&\r\n</article>', '8', 'Short Message Template'),
('cms_articles_teaser_picture_small', '<div style="max-width:&&&&width&&&&px" class="clrfx">\r\n<a href="&&&&file&&&&"><img src="/pictures/small/&&&&psrc&&&&" alt="&&&&alt&&&&" width="&&&&width&&&&" height="&&&&height&&&&" /></a>\r\n&&&&copyright&&&&\r\n</div>', '8', 'a small image for a teaser, uses dimension small'),
('cms_articles_rubric_small', '<div class=\'announcebox\'>\r\n\t&&&&title&&&&\r\n\t<div class=\'innerbox\'>\r\n\t<ul>\r\n\t\t&&&&content&&&&\r\n\t</ul>\r\n\t</div>\r\n</div>', '8', 'box for a small rubric'),
('cms_articles_teaser_3col', '<li id="news_teaser_&&&&id&&&&" class="t3 box">\r\n\t&&&&picture&&&&\r\n\t<h3><a href=\'&&&&file&&&&\'>&&&&title&&&&</a></h3>\r\n\t<div class=\'dateofarticle\'>&&&&wdate&&&&</div>\r\n<!-- A=article ID=&&&&id&&&& -->\r\n\t<p class=\'content\'>&&&&subtitle&&&& &&&&lead&&&&</p> &&&&more&&&&\r\n</li>', '8', NULL),
('cms_articles_teaser_2col', '<li id="news_teaser_&&&&id&&&&" class="t2 box">\r\n\t&&&&picture&&&&\r\n\t<div class=\'dateofarticle\'>&&&&wdate&&&&</div>\r\n\t<h3><a href=\'&&&&file&&&&\'>&&&&title&&&&</a></h3>\r\n<!-- A=article ID=&&&&id&&&& -->\r\n\t<p class=\'content\'>&&&&subtitle&&&& &&&&lead&&&&</p> &&&&more&&&&\r\n</li>', '8', NULL),
('cms_articles_rubric_cols', '&&&&title&&&&\r\n<div id="news_rubric_&&&&id&&&&" class="rubric_box row clrfx">\r\n<ul class="yo-tiles">\r\n\t&&&&content&&&&\r\n</ul>\r\n</div>', '8', 'The box of a rubric which has columns'),
('cms_articles_teaser_picture_cinemascope', '<div style="max-width:&&&&width&&&&px" class="clrfx">\r\n<a href="&&&&file&&&&"><img src="/pictures/cinemascope/&&&&psrc&&&&" alt="&&&&alt&&&&" width="&&&&width&&&&" height="&&&&height&&&&" /></a>\r\n&&&&copyright&&&&\r\n</div>', '8', 'a small image for a teaser, uses dimension cinemascope'),
('cms_articles_teaser_picture_thumbs', '<a href="&&&&file&&&&"><img src="/pictures/small/&&&&psrc&&&&" alt="&&&&crtitle&&&&"  title="&&&&crtitle&&&&" width="&&&&width&&&&" height="&&&&height&&&&" class="left" /></a>\r\n\r\n', '8', 'a small image for a teaser, uses dimension thumbs'),
('cms_articles_teaser_more', '<p class="alright"><a href="&&&&file&&&&" class="more">&&&&more&&&& <span class="hidden">&&&&title&&&&</span></a></p>', '8', 'the "more"-link for article teaser'),
('cms_articles_print', '<p class="alright"><a href="&&&&file&&&&?_pr=1" target="_blank" class="print"><i class="fas fa-print"></i> &&&&print&&&& <span class="hidden">&&&&title&&&&</span></a></p>', '8', 'link to print version'),
('cms_articles_top_news', '<div class="top_news row clrfx">\r\n&&&&picture&&&&\r\n<div class="innerbox">\r\n<div class=\'dateofarticle\'>&&&&wdate&&&&</div>\r\n&&&&title&&&&\r\n&&&&subtitle&&&&\r\n<p>&&&&lead&&&&</p> &&&&more&&&&\r\n</div>\r\n</div>', '8', NULL),
('cms_articles_top_picture', '<div class="blaster">\r\n<img src="/pictures/&&&&picture&&&&" width="&&&&width&&&&" height="&&&&height&&&&"  alt="&&&&alt&&&&" />\r\n<div class="top_gradient">&nbsp;</div>\r\n<h2><a href="&&&&file&&&&">&&&&title&&&&</a></h2>\r\n</div>\r\n&&&&copyright&&&&', '8', NULL),
('cms_articles_teaser_related_news', '<li id="relate_article_&&&&id&&&&" class="t3 box">\r\n\t&&&&picture&&&&\r\n\t<h3><a href=\'&&&&file&&&&\'>&&&&title&&&&</a></h3>\r\n\t<div class=\'dateofarticle\'>&&&&wdate&&&&</div>\r\n<!-- A=article ID=&&&&id&&&& -->\r\n\t<p class=\'content\'>&&&&subtitle&&&& &&&&lead&&&& &&&&more&&&&</p>\r\n</li>\r\n', '8', 'an item of related articles, must be <li>'),
('cms_articles_teaser_picture_square', '<a href="&&&&file&&&&"><img src="/pictures/square/&&&&picture&&&&" alt="&&&&crtitle&&&&"  title="&&&&crtitle&&&&" width="&&&&width&&&&" height="&&&&height&&&&" class="left" /></a>', '8', 'a small image for a teaser, uses dimension square'),
('cms_articles_related_news', '&&&&title&&&&\r\n<div id="news_rubric_&&&&id&&&&" class="rubric_box row clrfx">\r\n<ul class="yo-tiles">\r\n\t&&&&content&&&&\r\n</ul>\r\n</div>', '8', 'box of related news'),
('cms_newsletter', '<!DOCTYPE html>\n<html>\n<head>\n<title>&&&&Subject&&&&</title>\n<style type="text/css">\n\nbody {\n  font-family: Tahoma, Verdana, Arial, sans-serif;\n  font-size: 100%;\n  color: #666666;\n  background-color: #FEFEFE;\n }\n\ndiv#site {\n  max-width: 55em;\n }\n \n#site img {\n max-width: 100%;\n height: auto;\n }\n\n#site p.lead, #site .subtitle {\n  font-weight: bold;\n  text-indent: 0px;\n }\n\n#site p.picturetext, #site p.copyright {\n font-size: 0.8em;\n }\n \n#site p.copyright, #site .dateofarticle {\n color: #C0C0C0;\n text-align: right;\n }\n\n#site h1 {\n  font-size: 1.2em;\n  font-weight: bold;\n  color: #74cdad;\n  padding: 3px;\n }\n\n#site h2 {\n  color: #444444;\n  font-size: 1.1em;\n  font-weight: bold;\n }\n\n#site h3 {\n  color: #444444;\n  font-size: 1.1em;\n  font-weight: normal;\n }\n \n#site .rubric_title {\n color: #FFFFFF;\n padding: 8px;\n background-color: #74cdad;\n }\n\n#site a {\n  font-weight: bold;\n  text-decoration: none;\n  color: #74cdad;\n }\n \n#site .alright {\n\ttext-align: right;\n}\n\n#site .hidden {\n\tdisplay: none;\n}\n\n#site .right {\n  float: right;\n  margin: 0px 0px 0px 12px;\n }\n\n#site .left {\n  float: left;\n  margin: 0px 12px 0px 0px;\n  }\n  \n#site .rightfloat {\n\tmargin-left: 1.5em;\n\tmargin-bottom: 1em;\n\tfloat: right;\n}\n\n#site .leftfloat {\n\tmargin-right: 1.5em;\n\tmargin-bottom: 1em;\n\tfloat: left;\n}\n\n#site hr {\n color: #74cdad;\n border: 0px;\n background-color: #74cdad;\n height: 1px;\n width: 66%;\n margin: 1.5em auto;\n }\n\n.clrfx:before, .clrfx:after {\n  content: "\0020";\n  clear: both;\n  display: table;\n }\n\n.clrfx:after {\n  clear: both;\n }\n\n</style>\n</head>\n<body>\n<div id="site">\n&&&&html&&&&\n</div>\n</body>\n</html>', '4', 'complete html frame for newsletter including a small css'),
('cms_newsletter_teaser', '<div class="clrfx">\r\n<div class="left"><img src="/pictures/small/&&&&psrc&&&&" /></div>\r\n<h3><a href=\'&&&&file&&&&\'>&&&&title&&&&</a></h3>\r\n<p>&&&&subtitle&&&&<br />&&&&lead&&&&</p>\r\n</div>\r\n<hr>\r\n', '8', 'newsletter teaser');

INSERT INTO `register` (`name`, `call`, `plugin`, `tab`, `params`, `gui`, `top`, `start`, `group`, `icon`, `image`, `level`, `sort`, `frontend`) VALUES
('articles', 'article', 'news', '6', '&c_filter=article', '1', '', 'on', '', 'newspaper-blue', '0', '1', '100', ''),
('rubric', 'rubric', 'news', '6', '', '1', '', '', '', 'sitemap-blue', '0', '1', '150', ''),
('new_article', 'article', 'news', '6', '&todo=edit', '0', '', 'on', '', 'newspaper-blue-add', '0', '1', '110', ''),
('news_settings', 'news_settings', 'news', '6', '', '1', '', 'on', 'on', 'wrench-blue', '0', '2', '120', '');
