/**
 * @Author: consentio
 * @Date:   2018-08-18T16:59:48+02:00
 * @Last modified by:   consentio
 * @Last modified time: 2023-08-15T15:52:34+02:00
 */



INSERT INTO `i18n` (`index`, `group`, `en`, `de`) VALUES
('img_source', 'gallery', 'Import Images', 'Bilder importieren'),
('add_by_hand', 'gallery', 'Add by Hand', 'Händisch hinzufügen'),
('gal_template', 'gallery', 'Template of Gallery', 'Galerien Vorlage'),
('gal_3_col', 'gallery', 'three columns', 'dreispaltig'),
('gal_4_col', 'gallery', 'four columns', 'vierspaltig'),
('gal_5_col', 'gallery', 'five columns', 'fünf spaltig'),
('pic_dim', 'gallery', 'Dimension of Preview Image', 'Größe des Vorschaubildes'),
('small', 'common', 'Small Image', 'kleines Bild'),
('thumbs', 'common', 'Thumbnail', 'Daumennagel'),
('cinemascope', 'common', '16:9', '16:9'),
('square', 'common', 'Small Square', 'Miniquadrat'),
('gal_images', 'gallery', 'Pictures of the Gallery', 'Bilder der Galerie'),
('only_gallery', 'common', 'Only Galleries', 'Nur Galerien'),
('new_gallery', 'common', 'New Gallery', 'Neue Galerie'),
('img_portfolio', 'gallery', 'from a portfolio of the image database', 'aus einer Mappe der Bilddatenbank'),
('import_text', 'gallery', 'take over the text', 'Text übernehmen'),
('img_lightdesk', 'gallery', 'from lightdesk', 'aus Leuchtpult');

INSERT INTO `register` ( `name`, `call`, `plugin`, `tab`, `params`, `gui`, `top`, `start`, `group`, `icon`, `image`, `level`, `sort`, `frontend`) VALUES
('gal_images', 'gal_images', 'gallery', '3', '', '5', '', '', '', 'default', '0', '1', '240', ''),
('new_gallery', 'gallery', 'gallery', '3', '&todo=edit', '1', '', 'on', '', 'file-image-add', '0', '1', '210', '');

INSERT INTO `content_types` (`type`, `name`, `icon`, `icon_add`, `new_in_type`, `generate`, `move`) VALUES
('gallery', 'gallery', 'file-image', 'file-image-add', 'root,folder,node', 0, 1);

INSERT INTO `html_snippets` (`key`, `code`, `group`, `description`) VALUES
('cms_gallery_items3', '<li class="t3 box">\r\n<div class="center">\r\n<a href="/pictures/normal/&&&&picture&&&&" data-app="lightbox" title="&&&&alt&&&&"><img alt="&&&&alt&&&&" src="/pictures/&&&&path&&&&/&&&&picture&&&&" width="&&&&width&&&&" height="&&&&height&&&&" &&&&class&&&&></a>\r\n</div>\r\n&&&&copyright&&&&\r\n&&&&caption&&&&\r\n&&&&text&&&&\r\n</li>', '14', 'first image of a row of 3, has always to be an unordered list.'),
('cms_gallery', '&&&&preface&&&&\r\n<div id="gallery" class="row clrfx">\r\n<ul class="yo-tiles">\r\n&&&&list&&&&\r\n</ul>\r\n</div>', '14', 'a gallery box'),
('cms_gallery_items4', '<li class="t4 box">\r\n<div class="center">\r\n<a href="/pictures/normal/&&&&picture&&&&" data-app="lightbox" title="&&&&alt&&&&"><img alt="&&&&alt&&&&" src="/pictures/&&&&path&&&&/&&&&picture&&&&" width="&&&&width&&&&" height="&&&&height&&&&" &&&&class&&&&></a>\r\n</div>\r\n&&&&copyright&&&&\r\n&&&&caption&&&&\r\n&&&&text&&&&\r\n</li>\r\n', '14', 'gallery with 4 columns'),
('cms_gallery_items5', '<li class="t5 center">\r\n<a href="/pictures/normal/&&&&picture&&&&" data-app="lightbox" title="&&&&alt&&&&"><img alt="&&&&alt&&&&" src="/pictures/&&&&path&&&&/&&&&picture&&&&" width="&&&&width&&&&" height="&&&&height&&&&" &&&&class&&&&></a>\r\n</li>', '14', 'gallery first image of 5 in a row, no text');

CREATE TABLE `gallery` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) NOT NULL,
  `preface` text,
  `gal_template` tinyint(4) NOT NULL DEFAULT '1',
  `pic_dim` tinyint(4) NOT NULL DEFAULT '3',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `gal_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `picture` varchar(128) NOT NULL DEFAULT '0',
  `caption` varchar(128) DEFAULT NULL,
  `copyright` varchar(64) DEFAULT NULL,
  `text` text,
  `gallery` bigint(20) unsigned NOT NULL DEFAULT '0',
  `sort` bigint(20) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `help` (`parent`, `header`, `body`, `sort`, `tooltip`, `language`) VALUES
('199999999', 'Galerie', '<p>Mit dem Galerien-Plugin werden spezielle Seiten erstellt, die für die Präsentation einer größeren Anzahl von Bildern ausgerichtet sind. Die Bilder \r\nder Galerie werden entweder neu hochgeladen oder aus der Bilddatenbank \r\nentnommen. Die Bilder können bei Bedarf auch beschriftet werden.</p><p>Je nach Anzahl der Bilder oder Zielsetzung der Galerie stehen durch die Auswahl von Galerien-Vorlage und Bildgröße mehrere Möglichkeiten der Darstellung bereit.<br></p>', '10', 'gallery', 'de'),
('199999999', 'Galerie', '<p>Erstellt eine Seite als Bildgalerie<br></p>', '20', 'common.gallery', 'de'),
('199999999', 'Titel', '<p>Der Titel der Galerie bildet wie bei allen Seiten zugleich die Überschrift und wird für die Namensgebung der HTML-Datei verwendet. Geben Sie Ihrer Galerie einen aussagekräftigen Titel.<br></p>', '770', 'gallery.title', 'de'),
('199999999', 'Kurztitel', '<p>Der Kurztitel wird für den Menü-Eintrag verwendet, er sollte mit dem Titel nachvollziehbar zusammenhängen, muss jedoch entscheidend kürzer sein.<br></p>', '790', 'gallery.short', 'de'),
('199999999', 'Sprache', '<p>Die Sprache ergibt sich aus der Auswahl des Sprachbereiches, aus der heraus die Galerie angelegt wurde. Wollen Sie eine andere Sprache verwenden, wählen Sie im linken Baum einen anderen Sprachbereich oder Ordner dieses Bereiches aus und gehen dann auf  "Neuer Eintrag" und "Galerie".<br></p>', '810', 'gallery.lang', 'de'),
('199999999', 'Ordner der Galerie', '<p>Der Ordner zeigt an, wo die Galerie in der Menüstruktur und im Inhaltsverzeichnis aufscheint. Unterste Ebene ist der Ordner <strong>"Home"</strong>. Sämtliche Ordner und Seiten (und somit auch Galerien), die sich in HOME befinden, werden in der Hauptnavigation angezeigt.</p><p>Jeder\r\n Ordner kann wiederum weitere Ordner und Seiten beinhalten.</p>', '890', 'gallery.parent', 'de'),
('199999999', 'Vorlagen', '<p>Im Gegensatz zur Galerien-Vorlage, die nur den eigentlichen Bereich der Bildgalerie betrifft, wird hier die Seiten-Layout-Vorlage&nbsp;– wie für alle Seiten üblich&nbsp;– ausgewählt.<br></p>', '920', 'gallery.template', 'de'),
('199999999', 'Sortieren', '<p>Die Seiten (und somit auch Galerien) erscheinen in den Menüpunkten und in den \r\nInhaltsverzeichnissen in der Reihenfolge ihrer Eingabe. Das heißt: die \r\nzuletzt erstellte Seite ist als erste zu sehen. Um die Reihenfolge \r\nbeliebig zu manipulieren, gibt es das Sortierfeld.</p><p>Sortierungen können bequemer in der Tabellenübersicht vorgenommen werden.<br></p>', '940', 'gallery.sort', 'de'),
('199999999', 'Zeitsteuerung', '<p>Die Veröffentlichung (im Menü) kann auch zeitgesteuert erfolgen. Das Start-Datum setzt die Seite in den Modus "Menü &amp; veröffentlicht", das Ende-Datum setzt sie offline.</p><p>Klappen Sie den Bereich bei Bedarf aus.<br></p>', '1000', 'gallery.cron', 'de'),
('199999999', 'Galerien Vorlage', '<p>Wählen Sie hier eine Vorlage für die Galerie aus, die zu Bilderanzahl, Art und Zielsetzung Ihrer Galerie passt.<br></p>', '960', 'gallery.gal_template', 'de'),
('199999999', 'Größe der Vorschaubilder', '<p>Wählen Sie hier die passende Dimensionierung der Vorschaubilder aus. Das Miniquadrat und das 16:9-Format sind fixe Zuschnitte der Bilder, die ein gleichmäßiges Layout bewirken. Sollen die Bilder unverfälscht dargestellt werden, wählt man lieber Kleinbild oder Daumennagel.</p><p>Hier gilt: Probieren geht über Studieren.<br></p>', '970', 'gallery.pic_dim', 'de'),
('199999999', 'Bilder der Galerie', '<p>Hier werden die einzelnen Bilder der Galerie hochgeladen, ausgewählt oder bearbeitet.</p><p>Um ein neues Bild hinzuzufügen, klicken Sie auf "Neuer Eintrag". Um ein Bild zu bearbeiten, klicken Sie auf das Bearbeitungssymbol des jeweiligen Bildes, um es zu löschen auf das Löschsymbol.</p><p>Die Reihenfolge der Bilder wird durch das Ziehen der Tabellenzeilen in die gewünschten Positionen und mit einem Klick auf "Sortieren" festgelegt.<br></p>', '980', 'gal_images', 'de'),
('199999999', 'Vorwort', '<p>Geben Sie hier je nach Belieben einen Begleittext für die Galerie ein.<br></p>', '910', 'gallery.preface', 'de'),
('199999999', 'Bild hinzufügen', '<p>Sie können Ihren Galerien auf zwei Arten ein Bild hinzufügen:</p><ol><li>Das Bild befindet sich in Form einer digitalen Bilddatei (JPG, GIF, PNG) auf Ihrem Rechner.<br>In diesem Fall gehen Sie unter "<strong>Bild hochladen</strong>"\r\n auf "Durchsuchen". Es öffnet sich ein Fenster, mit dessen Hilfe Sie \r\neine Bilddatei von der Festplatte Ihres Computers auswählen können. <br></li><li>Das Bild wurde bereits hochgeladen und befindet sich in der Bilddatenbank.<br>Klicken Sie unter "<strong>vorhandenes Bild</strong>"\r\n auf das Ordnersymbol. Es öffnet sich ein Fenster, mit dessen Hilfe Sie \r\neine Bilddatei aus der Bilddatenbank auswählen können. Der Dateiname \r\nsowie die Kleindarstellung des Bildes werden angezeigt.</li></ol>', '1340', 'gal_images.picture', 'de'),
('199999999', 'Urheberrecht', '<p>Geben Sie hier den Inhaber der Urheberrechte an. Diese Angabe wird angezeigt und kann Ihnen möglicherweise unangenehme "Anwälte" vom Leib halten.<br></p>', '1360', 'gal_images.copyright', 'de'),
('199999999', 'Bildtitel', '<p>Geben Sie hier bei Bedarf den Titel des Bildes ein.<br></p>', '1370', 'gal_images.caption', 'de'),
('199999999', 'Bildtext', '<p>Geben Sie hier bei Bedarf einen Erklärungstext für das Bild ein.</p>', '1380', 'gal_images.text', 'de'),
('199999999', 'Bilder importieren', '<p>Neben der händischen Eingabe der Galeriebilder können die Bilder auch aus der Bilddatenbank übernommen werden.</p><p>Wenn Sie bereits die Bilder in der Bilddatenbank hochgeladen haben, wählen Sie die entsprechende Mappe aus, um diese zu importieren. Sie können darüber hinaus eintscheiden, ob etwaige Texte (Titel und Beschreibungstext) für die Galerie übernommen werden sollen oder nicht.<br></p>', '900', 'gallery.make', 'de');

INSERT INTO `help_folder` ( `name`, `short`, `parent`, `sort`, `language`)
VALUES ('Galerie', '', '17', '30', 'de');

UPDATE `help` SET `parent` = (SELECT `id` FROM `help_folder` WHERE `name` = 'Galerie') WHERE `parent` = '199999999';
