/**
 * @Author: consentio
 * @Date:   2018-08-18T16:59:47+02:00
 * @Last modified by:   consentio
 * @Last modified time: 2023-08-15T15:50:29+02:00
 */



CREATE TABLE `countries` (
  `iso3166` varchar(2) NOT NULL,
  `en` varchar(128) NOT NULL,
  `de` varchar(128) NOT NULL,
  PRIMARY KEY (`iso3166`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `countries` (`iso3166`, `en`, `de`) VALUES
('ad', 'Andorra', 'Andorra'),
('ae', 'United Arab Emirates', 'Vereinigte Arabische Emirate'),
('af', 'Afghanistan', 'Afghanistan'),
('al', 'Albania', 'Albanien'),
('am', 'Armenia', 'Armenien'),
('ao', 'Angola', 'Angola'),
('aq', 'Antarctica', 'Antarktis'),
('ar', 'Argentina', 'Argentinien'),
('at', 'Austria', 'Österreich'),
('au', 'Australia', 'Australien'),
('az', 'Azerbaijan', 'Aserbaidschan'),
('ba', 'Bosnia and Herzegovina', 'Bosnien-Herzegowina'),
('bd', 'Bangladesh', 'Bangladesch'),
('be', 'Belgium', 'Belgien'),
('bf', 'Burkina Faso', 'Burkina Faso'),
('bg', 'Bulgaria', 'Bulgarien'),
('bh', 'Bahrain', 'Bahrain'),
('bi', 'Burundi', 'Burundi'),
('bj', 'Benin', 'Benin'),
('bm', 'Bermuda', 'Bermuda'),
('bn', 'Brunei Darussalam', 'Brunei '),
('bo', 'Bolivia', 'Bolivien'),
('br', 'Brazil', 'Brasilien'),
('bs', 'Bahamas', 'Bahamas'),
('bt', 'Bhutan', 'Bhutan'),
('bw', 'Botswana', 'Botswana'),
('by', 'Belarus', 'Weißrußland'),
('ca', 'Canada', 'Kanada'),
('cd', 'Congo', 'Demokratische Republik Kongo'),
('cf', 'Central African Republic', 'Zentralafrikanische Republik'),
('cg', 'Congo', 'Kongo'),
('ch', 'Switzerland', 'Schweiz'),
('ci', 'Côte d''Ivoire', 'Côte d''Ivoire'),
('cl', 'Chile', 'Chile'),
('cm', 'Cameroon', 'Kamerun'),
('cn', 'China', 'China'),
('co', 'Colombia', 'Kolumbien'),
('cr', 'Costa Rica', 'Costa Rica'),
('cs', 'Serbia and Montenegro', 'Serbien und Montenegro'),
('cz', 'Czech Republic', 'Tschechische Republik'),
('cu', 'Cuba', 'Kuba'),
('cv', 'Cape Verde', 'Kap Verde'),
('cy', 'Cyprus', 'Zypern'),
('de', 'Germany', 'Deutschland'),
('dj', 'Djibouti', 'Dschibuti'),
('dk', 'Denmark', 'Dänemark'),
('do', 'Dominican Republic', 'Dominikanische Republik'),
('dz', 'Algeria', 'Algerien'),
('ec', 'Ecuador', 'Ecuador'),
('ee', 'Estonia', 'Estland'),
('eg', 'Egypt', 'Ägypten'),
('es', 'Spain', 'Spanien'),
('et', 'Ethiopia', 'Äthiopien'),
('fi', 'Finland', 'Finnland'),
('fo', 'Faroe Islands', 'Färöer Inseln'),
('fr', 'France', 'Frankreich'),
('ga', 'Gabon', 'Gabun'),
('gb', 'United Kingdom', 'Großbritannien'),
('ge', 'Georgia', 'Georgien'),
('gf', 'French Guiana', 'Französisch Guyana'),
('gh', 'Ghana', 'Ghana'),
('gi', 'Gibraltar', 'Gibraltar'),
('gl', 'Greenland', 'Grönland'),
('gm', 'Gambia', 'Gambia'),
('gn', 'Guinea', 'Guinea'),
('gp', 'Guadeloupe', 'Guadeloupe'),
('gq', 'Equatorial Guinea', 'Äquatorial-Guinea'),
('gr', 'Greece', 'Griechenland'),
('gt', 'Guatemala', 'Guatemala'),
('gw', 'Guinea-Bissau', 'Guinea-Bissau'),
('gy', 'Guyana', 'Guayana'),
('hk', 'Hong Kong', 'Hongkong'),
('hn', 'Honduras', 'Honduras'),
('hr', 'Croatia', 'Kroatien'),
('ht', 'Haiti', 'Haiti'),
('hu', 'Hungary', 'Ungarn'),
('id', 'Indonesia', 'Indonesien'),
('ie', 'Ireland', 'Irland'),
('il', 'Israel', 'Israel'),
('in', 'India', 'Indien'),
('iq', 'Iraq', 'Irak'),
('ir', 'Iran', 'Iran'),
('is', 'Iceland', 'Island'),
('it', 'Italy', 'Italien'),
('jm', 'Jamaica', 'Jamaika'),
('jo', 'Jordan', 'Jordanien'),
('jp', 'Japan', 'Japan'),
('ke', 'Kenya', 'Kenia'),
('kh', 'Cambodia', 'Kambodscha'),
('km', 'Comoros', 'Komoren'),
('kp', 'Democratic People''s Republic of Korea', 'Demokratische Republik Korea'),
('kr', 'Republic of Korea', 'Koreanische Republik'),
('kw', 'Kuwait', 'Kuwait'),
('kz', 'Kazakhstan', 'Kasachstan'),
('la', 'Lao People''s Democratic Republic', 'Demokratische Volksrepublik Laos'),
('lb', 'Lebanon', 'Libanon'),
('li', 'Liechtenstein', 'Liechtenstein'),
('lk', 'Sri Lanka', 'Sri Lanka'),
('lr', 'Liberia', 'Liberia'),
('ls', 'Lesotho', 'Lesotho'),
('lt', 'Lithuania', 'Litauen'),
('lu', 'Luxembourg', 'Luxemburg'),
('lv', 'Latvia', 'Lettland'),
('ma', 'Morocco', 'Marokko'),
('mc', 'Monaco', 'Monaco'),
('md', 'Moldova', 'Moldawien'),
('mg', 'Madagascar', 'Madagaskar'),
('mk', 'Macedonia', 'Mazedonien'),
('ml', 'Mali', 'Mali'),
('mn', 'Mongolia', 'Mongolei'),
('mo', 'Macao', 'Macao'),
('mq', 'Martinique', 'Martinique'),
('mr', 'Mauritania', 'Mauretanien'),
('mt', 'Malta', 'Malta'),
('mu', 'Mauritius', 'Mauritius'),
('mv', 'Maldives', 'Malediven'),
('mw', 'Malawi', 'Malawi'),
('mx', 'Mexico', 'Mexiko'),
('my', 'Malaysia', 'Malaysia'),
('mz', 'Mozambique', 'Mosambik'),
('no', 'Norway', 'Norwegen'),
('na', 'Namibia', 'Namibien'),
('nc', 'New Caledonia', 'Neu-Kaledonien'),
('ne', 'Niger', 'Niger'),
('ng', 'Nigeria', 'Nigeria'),
('ni', 'Nicaragua', 'Nicaragua'),
('nl', 'Netherlands', 'Niederlande'),
('np', 'Nepal', 'Nepal'),
('nz', 'New Zealand', 'Neuseeland'),
('pa', 'Panama', 'Panama'),
('pe', 'Peru', 'Peru'),
('pf', 'French Polynesia', 'Französisch Polynesien'),
('pg', 'Papua New Guinea', 'Papua-Neuguinea'),
('ph', 'Philippines', 'Philippinen'),
('pk', 'Pakistan', 'Pakistan'),
('pl', 'Poland', 'Polen'),
('pr', 'Puerto Rico', 'Puerto Rico'),
('pt', 'Portugal', 'Portugal'),
('py', 'Paraguay', 'Paraguay'),
('ro', 'Romania', 'Rumänien'),
('ru', 'Russian Federation', 'Russische Föderation'),
('rw', 'Rwanda', 'Ruanda'),
('sa', 'Saudi Arabia', 'Saudiarabien'),
('sb', 'Solomon Islands', 'Salomonen'),
('sc', 'Seychelles', 'Seychellen'),
('sd', 'Sudan', 'Sudan'),
('se', 'Sweden', 'Schweden'),
('sg', 'Singapore', 'Singapur'),
('si', 'Slovenia', 'Slowenien'),
('sk', 'Slovakia', 'Slowakei'),
('sl', 'Sierra Leone', 'Sierra Leone'),
('sm', 'San Marino', 'San Marino'),
('sn', 'Senegal', 'Senegal'),
('so', 'Somalia', 'Somalia'),
('sr', 'Suriname', 'Surinam'),
('sv', 'El Salvador', 'El Salvador'),
('sy', 'Syrian Arab Republic', 'Syrien'),
('sz', 'Swaziland', 'Swasiland'),
('tw', 'Taiwan', 'Taiwan'),
('td', 'Chad', 'Tschad'),
('tg', 'Togo', 'Togo'),
('th', 'Thailand', 'Thailand'),
('tn', 'Tunisia', 'Tunesien'),
('tr', 'Turkey', 'Türkei'),
('tt', 'Trinidad and Tobago', 'Trinidad und Tobago'),
('tz', 'Tanzania', 'Tansania'),
('ua', 'Ukraine', 'Ukraine'),
('ug', 'Uganda', 'Uganda'),
('us', 'United States of America', 'Vereinigte Staaten'),
('uy', 'Uruguay', 'Uruguay'),
('uz', 'Uzbekistan', 'Usbekistan'),
('va', 'Vatican City State', 'Vatikanstadt'),
('ve', 'Venezuela', 'Venezuela'),
('vn', 'Viet Nam', 'Vietnam'),
('ye', 'Yemen', 'Jemen'),
('za', 'South Africa', 'Südafrika'),
('zm', 'Zambia', 'Sambia'),
('zw', 'Zimbabwe', 'Zimbabwe'),
('ag', 'Antigua and Barbuda', 'Antigua und Barbuda'),
('ai', 'Anguilla', 'Anguilla'),
('as', 'American Samoa', 'Amerikanisch-Samoa'),
('aw', 'Aruba', 'Aruba'),
('ax', 'Åland Islands', 'Åland'),
('bb', 'Barbados', 'Barbados'),
('bl', 'Saint Barthélemy', 'Saint-Barthélemy'),
('bv', 'Bouvet Island', 'Bouvetinsel'),
('cc', 'Cocos Islands', 'Kokosinseln'),
('ck', 'Cook Islands', 'Cookinseln'),
('cx', 'Christmas Island', 'Weihnachtsinsel'),
('dm', 'Dominica', 'Dominica'),
('eh', 'Western Sahara', 'Westsahara'),
('fj', 'Fiji', 'Fidschi'),
('fk', 'Falkland Islands', 'Falklandinseln'),
('fm', 'Federated States of Micronesia', 'Föderierte Staaten von Mikronesien'),
('gd', 'Grenada', 'Grenada'),
('gs', 'South Georgia and the South Sandwich Islands', 'Südgeorgien und die Südlichen Sandwichinseln'),
('gu', 'Guam', 'Guam'),
('hm', 'Heard Island and McDonald Islands', 'Heard und McDonaldinseln'),
('im', 'Isle of Man', 'Isle of Man'),
('io', 'British Indian Ocean Territory', 'Britisches Territorium im Indischen Ozean'),
('kg', 'Kyrgyzstan', 'Kirgisistan'),
('ki', 'Kiribati', 'Kiribati'),
('kn', 'Saint Kitts and Nevis', 'St. Kitts und Nevis'),
('ky', 'Cayman Islands', 'Kaimaninseln'),
('lc', 'Saint Lucia', 'St. Lucia'),
('ly', 'Libya', 'Libyen'),
('me', 'Montenegro', 'Montenegro'),
('mh', 'Marshall Islands', 'Marshallinseln'),
('mp', 'Northern Mariana Islands', 'Nördliche Marianen'),
('ms', 'Montserrat', 'Montserrat'),
('nf', 'Norfolk Island', 'Norfolkinsel'),
('nr', 'Nauru', 'Nauru'),
('nu', 'Niue', 'Niue'),
('om', 'Oman', 'Oman'),
('pm', 'Saint Pierre and Miquelon', 'Saint-Pierre und Miquelon'),
('pn', 'Pitcairn Islands', 'Pitcairninseln'),
('ps', 'State of Palestine', 'Staat Palästina'),
('pw', 'Palau', 'Palau'),
('qa', 'Qatar', 'Katar'),
('re', 'Réunion', 'Réunion'),
('rs', 'Serbia', 'Serbien'),
('sh', 'Saint Helena, Ascension and Tristan da Cunha', 'St. Helena, Ascension und Tristan da Cunha'),
('sj', 'Svalbard and Jan Mayen', 'Svalbard und Jan Mayen'),
('st', 'São Tomé and Príncipe', 'São Tomé und Príncipe'),
('tf', 'French Southern and Antarctic Lands', 'Französische Süd- und Antarktisgebiete'),
('tj', 'Tajikistan', 'Tadschikistan'),
('tk', 'Tokelau', 'Tokelau'),
('tl', 'East Timor', 'Osttimor'),
('tm', 'Turkmenistan', 'Turkmenistan'),
('to', 'Tonga', 'Tonga'),
('tv', 'Tuvalu', 'Tuvalu'),
('vc', 'Saint Vincent and the Grenadines', 'St. Vincent und die Grenadinen'),
('vg', 'British Virgin Islands', 'Britische Jungferninseln'),
('vi', 'United States Virgin Islands', 'Amerikanische Jungferninseln'),
('vu', 'Vanuatu', 'Vanuatu'),
('wf', 'Wallis and Futuna', 'Wallis und Futuna'),
('ws', 'Samoa', 'Samoa'),
('yt', 'Mayotte', 'Mayotte'),
( 'bz', 'Belize', 'Belize');

CREATE TABLE `help_folder` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short` varchar(32) NOT NULL,
  `parent` bigint(20) NOT NULL DEFAULT 0,
  `sort` bigint(20) DEFAULT NULL,
  `language` varchar(2) NOT NULL DEFAULT 'de',
  `parentsort` bigint(20) DEFAULT NULL,
  `graduated` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `help_folder` ( `id`, `name`, `short`, `parent`, `sort`, `language`, `parentsort`, `graduated`)
VALUES ( '1', 'Hilfe', '', '0', '40', 'de', '1', ' Hilfe'),
( '2', 'Seitenverwaltung', '', '1', '20', 'de', '3', '— Seitenverwaltung'),
( '3', 'Teaser und Container', '', '1', '30', 'de', '5', '— Teaser und Container'),
( '4', 'Dateimanager', '', '1', '50', 'de', '9', '— Dateimanager'),
( '5', 'Einstellungen', '', '1', '60', 'de', '10', '— Einstellungen'),
( '6', 'Bilddatenbank', '', '1', '40', 'de', '6', '— Bilddatenbank'),
( '7', 'CMS Einstellungen', '', '2', '0', 'de', '4', '—— CMS Einstellungen'),
( '8', 'Bildmanipulationen', '', '6', '20', 'de', '8', '—— Bildmanipulationen'),
( '9', 'Allgemeines', '', '1', '10', 'de', '2', '— Allgemeines'),
( '10', 'Bildermappe', '', '6', '10', 'de', '7', '—— Bildermappe'),
( '11', 'Benutzerverwaltung', '', '5', '10', 'de', '11', '—— Benutzerverwaltung'),
( '12', 'Menü-Register', '', '5', '20', 'de', '12', '—— Menü-Register'),
( '13', 'CSS Manager', '', '5', '30', 'de', '13', '—— CSS Manager'),
( '14', 'HTML-Vorlagen', '', '5', '40', 'de', '14', '—— HTML-Vorlagen'),
( '15', 'Sprachen Internationalisierung', '', '5', '50', 'de', '15', '—— Sprachen Internationalisierung'),
( '16', 'Datenbank', '', '5', '60', 'de', '16', '—— Datenbank'),
( '17', 'Plugins', '', '1', '70', 'de', '17', '— Plugins'),
( '18', 'Lizenz', '', '1', '80', '*', '18', '— Lizenz');

CREATE TABLE `help` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parent` bigint(20) NOT NULL,
  `header` varchar(200) DEFAULT NULL,
  `body` text NOT NULL,
  `sort` bigint(20) DEFAULT NULL,
  `tooltip` varchar(64) NOT NULL,
  `language` varchar(2) NOT NULL DEFAULT 'de',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `header` (`header`,`body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `help` ( `id`, `parent`, `header`, `body`, `sort`, `tooltip`, `language`)
VALUES ( '1', '3', 'Teaser', '<p>Teaser und Container heben Inhalte hervor oder fassen sie zusammen.</p>', '410', 'common.announces', 'de'),
( '2', '3', 'Titel', '<p>Der Titel eines Teasers oder Ankündigungkastens<br></p>', '870', 'announces.title', 'de'),
( '4', '2', 'Seiten', '<p>Erstellen und Verwalten von Inhaltsseiten</p>', '460', 'common.pages', 'de'),
( '5', '2', 'Ordner', '<p>Ordner zur Verzweigung und Gruppierung von Seiten oder weiteren Ordnern</p>', '630', 'common.folder', 'de'),
( '6', '2', 'Verknüpfung', 'Stellt im Menü eine Verknüpfung zu diversen Inhalten her.', '640', 'common.link', 'de'),
( '7', '6', 'Bilder', '<p>Übersicht über alle verfügbaren Bilder mit Suchfunktion und Beschlagwortung.</p>', '270', 'common.images', 'de'),
( '8', '5', 'Einstellungen', '<p>Einstellungen, Konfigurationen, Werkzeuge...</p>', '860', 'common.settings', 'de'),
( '9', '7', 'CMS-Einstellungen', '<p>CMS-spezifische Einstellungen und Konfigurationen</p>', '650', 'web_settings', 'de'),
( '10', '1', 'Übersicht', '<p>Die Übersicht bietet Zugang zu allen verfügbaren Funktionen.<br></p>', '620', 'common.intro', 'de'),
( '11', '4', 'Dateimanager', '<p>Dateien wie PDFs hochladen, verwalten und veröffentlichen<br></p>', '220', 'common.filemanager', 'de'),
( '12', '1', 'Consentio CMS und Framework', '<p>Consentio kombiniert ein Framework zur Datenerfassung und -ausgabe mit einem Redaktionssystem für Websites. Dieses ist für die Erstellung von Websites mit umfangreichen und weitverzweigten Inhalten ausgerichtet.</p><p>Prinzipiell trennt ein Content Management System (CMS) den Inhalt \r\n(Content) von der Darstellung (Design). Dadurch kann sich der Benutzer \r\nauf das konzentrieren, worum es eigentlich geht, nämlich auf den Inhalt, der vorrangig durch das Seitenmanagement bewerkstelligt wird. <br></p>', '430', 'common.preface', 'de'),
( '28', '7', 'Website-Titel', '<p>Der Titel der Website ist die Top-Inhaltsbeschreibung der Website und \r\nsomit ein wesentliches Kriterium für Suchmaschinen. Der Titel wird auch \r\nim Fenstertitel des Browsers angezeigt.</p><p>Geben Sie der Website einen kurzen, prägnanten Titel.<br></p>', '670', 'web_settings.website_title', 'de'),
( '13', '2', 'Inhaltseiten', '<p>Eine Seite oder Inhaltsseite bildet einen eigenständigen Bereich innerhalb der Website, der über die Navigationsleiste, einem Link oder anderen Navigationselementen aufgerufen werden kann.</p><p>Um eine neue Seite zu erstellen, klicken Sie auf den Karteireiter "Neuer Eintrag" und danach auf "Seite". Um eine vorhandene Seite zu bearbeiten, klicken Sie in der Tabellenübersicht auf das Bearbeiten-Icon der gewünschten Seite.</p><p>Klicken Sie auf "Speichern", wenn Änderungen gespeichert werden sollen.</p><p>Um eine Seite zu löschen, klicken Sie auf den Lösch-Icon der gewünschten Seite. Um mehrere Seiten gleichzeitig zu löschen, klicken Sie die Auswahl-Box der gewünschten Seiten an und danach auf "Löschen" am Tabellenbeginn.<br></p>', '470', 'pages', 'de'),
( '14', '2', 'Titel', '<p>Der Titel der Seite bildet zugleich die Überschrift und wird für die Namensgebung der HTML-Datei verwendet. Geben Sie Ihrer Seite einen aussagekräftigen Titel.<br></p>', '480', 'pages.title', 'de'),
( '15', '2', 'Kurztitel', '<p>Der Kurztitel wird für den Menü-Eintrag verwendet, er sollte mit dem Titel nachvollziehbar zusammenhängen, muss jedoch entscheidend kurz sein.<br></p>', '490', 'pages.short', 'de'),
( '16', '2', 'Autor', '<p>Das Autoren-Feld gibt Auskunft über den Urheber der Seite für interne \r\nZwecke. Der Name des angemeldeten Benutzers wird hier automatisch \r\neingetragen. Das Feld kann aber gegebenenfalls überschrieben werden. Der\r\n Autor scheint auf der veröffentlichten Website <strong>nicht</strong> auf.\r\n</p>', '500', 'pages.author', 'de'),
( '17', '2', 'Sprache', '<p>Die Sprache ergibt sich aus der Auswahl des Sprachbereiches, aus der heraus die Seite angelegt wurde. Wollen Sie eine andere Sprache verwenden, wählen Sie im linken Baum einen anderen Sprachbereich oder Ordner dieses Bereiches aus und gehen dann auf  "Neue Seite".<br></p>', '510', 'pages.lang', 'de'),
( '18', '2', 'Textkörper', '<p>Der Textkörper ist der eigentliche Inhalt der Seite. Der Text lässt sich mit Hilfe des\r\n Editors vielseitig formatieren, wodurch vom einfachen Fließtext bis zum\r\n raffiniert gestalteten Design alles möglich ist. Die\r\n Bedeutung der einzelnen Schaltfläche gehen weitgehend mit denen \r\nherkömmlicher Programme konform.</p><p>Für eine vollständige Erläuterung zum Editor bitte auf den Infopunkt klicken.<br></p>', '520', 'pages.body', 'de'),
( '19', '2', 'Der Editor', '<p>Die Textkörper von Seiten oder diverser Plugins erlauben die Formatierung des Textes und das Einfügen von Tabellen, Links und Bildern. Damit wird technisch gesehen aus reinem Text HTML-formatierter Code. Für den Benutzer bietet der Editor JQwys den Komfort, nicht im Code arbeiten zu müssen, sondern direkt in einer dem Endergebnis ähnlichen Darstellung. Dass diese nicht 1:1 dem Design auf der Website entspricht, hat freilich mit der Individualität der Designs zu tun. Darüber hinaus verfolgt der Editor das Prinzip What you see is what you mean (WYSIWYM). Das bedeutet, dass die Textstruktur optisch unterstützt wird. Man sieht praktisch auf einem Blick, ob Absätze, Überschriften oder Auflistungen richtig gesetzt sind.</p><h4>Die Funktionen von JQWys im Überblick</h4><h5><img src="/js/images/code.png" alt=""> HTML anzeigen/verstecken</h5><p>Mit diesem Button wechseln wir von der <abbr title="Hypertext Metalanguage" lang="en">HTML</abbr>-Ansicht zur Design-Ansicht. Damit haben Profis die volle Kontrolle über den HTML-Quellcode.<br></p><h5><img src="/js/images/paragraph.png" alt=""> Absatz</h5><p>Dieser Button ist identisch mit der Auswahl "Absatz" im nächstfolgenden Auswahlfeld und zeichnet den aktuellen Block, in dem der Text-Cursor steht, als Absatz aus. Ein Block ist ein durch "Return" beendeter Textabschnitt. Um innerhalb eines Absatzes einen so genannten "weichen" Zeilenumbruch zu erwirken, drückt man Shift und Return gleichzeitig.</p><h5>Textformat auswählen</h5><p>In diesem Auswahlfeld wird dem aktuellen Block, in dem der Text-Cursor steht, die jeweils erforderliche Textstruktur zugeordnet, die da sind:</p><ul><li>Einfacher Absatz und Absätze mit spezieller Gestaltung wie: Vorspann, Bildunterschrift und Copyright.</li><li>Überschrift 1 (Titel), welcher nur in Ausnahmefällen zum Einsatz kommt, da diese Überschriften-Ebene bereits für den Titel der Seite benutzt wird.</li><li>Überschrift 2 (Zwischentitel) unterteilt den Inhalt einer Seite in Abschnitte.</li><li>Überschrift 3 unterteilt den Inhalt innerhalb eines durch Überschrift 2 geteilten Abschnitts in weitere inhaltlich untergeordnete Abschnitte.</li><li>Überschrift 4 unterteilt den Inhalt innerhalb eines durch Überschrift 3 geteilten Abschnitts in weitere inhaltlich untergeordnete Abschnitte.</li><li>und so weiter...<br></li></ul><h5><img src="/js/images/left.png" alt=""> Linksbündig</h5><p>...setzt den aktuellen Block linksbündig, was dem Standard entspricht.<br></p><h5><img src="/js/images/center.png" alt=""> Zentriert</h5><p>...zentriert den aktuellen Block. Beispiel:</p><p>Ein wenig zentrierter Text, um sich abzuheben.<br>Zentrierter Text hat keine Funktion als Überschrift.<br></p><h5><img src="/js/images/right.png" alt=""> Rechtbündig</h5><p>...setzt den aktuellen Block rechtsbündig. Beispiel:</p><p>Zitat Eduard Schmidt<br></p><h5><img src="/js/images/justify.png" alt=""> Blocksatz</h5><p>...richten den aktuellen Block als Blocksatz aus. Das heißt, die Wörter einer Zeile werden so ausgerichtet, dass sie links und rechts bündig abschließen. Da es bei HTML keinen Standard zur Silbentrennung gibt, kommt es rasch zu einem uneinheitlichen auseinandergerissen Schriftbild. Prinzipiell ist Blocksatz daher nur für kurze Passagen und zur Hervorhebung von Textteilen empfehlenswert – wie in diesem Fall.<br></p><h5><img src="/js/images/ol.png" alt=""> Geordnete Liste einfügen</h5><p>Mit einem Klick auf diesen Button wird mit einer durchnummerierten Auflistung begonnen, oder markierte Absätze in eine Auflistung umgewandelt. Beispiel:</p><ol><li>Brot</li><li>Milch</li><li>Butter<br></li></ol><h5><img src="/js/images/ul.png" alt=""> Ungeordnete Liste einfügen</h5><p>...ist ähnlich wie die geordnete Liste jedoch ohne Nummerierung. Beispiel:</p><ul><li>Brot</li><li>Milch</li><li>Butter</li></ul><p>Um eine Auflistung zu beenden, drücken wir zweimal Return und wechseln mit dem Absatz-Button (siehe oben) wieder in den Absatz-Modus. Um innerhalb eines Listenpunktes einen Zeilenumbruch zu erwirken, drücken wir Shift und Return gleichzeitig.<br></p><h5><img src="/js/images/indent.png" alt=""> Einzug erhöhen</h5><p>Mit dieser Funktion lassen sich verschachtelte Listen erstellen. Es lassen sich jedoch auch einfache Absätze einrücken.<br></p><h5><img src="/js/images/outdent.png" alt=""> Einzug vermindern</h5><p>...macht den Einzug wieder rückgängig.<br></p><h5><img src="/js/images/bold.png" alt=""> Fett</h5><p>Mit einem Klick auf diesen Button wird der aktuell markierte Text fett dargestellt.<br></p><h5><img src="/js/images/italic.png" alt=""> Kursiv</h5><p>Mit einem Klick auf diesen Button wird der aktuell markierte Text kursiv dargestellt.</p><h5><img src="/js/images/underline.png" alt=""> Unterstrichen</h5><p>Mit einem Klick auf diesen Button wird der aktuell markierte Text unterstrichen dargestellt.<br></p><h5><img src="/js/images/strike.png" alt=""> Durchgestrichen</h5><p>Mit einem Klick auf diesen Button wird der aktuell markierte Text durchgestrichen dargestellt.<br></p><h5><img src="/js/images/sup.png" alt=""> Text hochstellen</h5><p>Damit können etwa Hochkommastellen dargestellt werden: 10<sup>3</sup> oder m<sup>2</sup>. Das Hoch- oder Tiefstellen sollte keinesfalls zur Verkleinerung der Schrift verwendet werden.<br></p><h5><img src="/js/images/sub.png" alt=""> Text tiefstellen</h5><p>Damit lassen sich Indizes, Suffixe und dergleichen darstellen wie etwa bei chemischen Formeln: CO<sub>2</sub>.<br></p><h5><img src="/js/images/undo.png" alt=""> Befehle rückgängig machen</h5><p>Damit können Eingaben und Befehle wieder rückgängig gemacht werden. Funktioniert nicht im Internet Explorer!<br></p><h5><img src="/js/images/redo.png" alt=""> Befehle wiederherstellen</h5><p>Damit können rückgängig gemachte Eingaben und Befehle wiederhergestellt werden. Funktioniert nicht im Internet Explorer!</p><h5><img src="/js/images/link.png" alt=""> Link einfügen</h5><p>Dieser Button öffnet den Dialog, um Verknüpfungen (Links) herzustellen. Zuerst wählen wir die Textpassage aus, mit der wir verlinken wollen. Nach dem Öffnen des Dialog können wir unter <acronym title="Uniform Resource Locator" lang="en">URL</acronym> eine mit http:// beginnende Internetadresse eingeben. Verlinkungen auf eigene Angebote lassen sich am einfachsten über den Linkassistenten (Klick auf das Ordner-Symbol) bewerkstelligen.</p><p>Unter "Titel" kann ein zusätzlicher Text zur Beschreibung des Links eingegeben werden, was vor allem dann notwendig ist, wenn der verlinkte Text über den Link nichts aussagt, wie etwa "hier", "weiter" oder "mehr". Unter "Ziel" haben wir die Möglichkeit, einen Link in einem neuen Fenster öffnen zu lassen. In diesem Fall kann im Titel auch mit "Öffnet in neuem Fenster" darauf hingewiesen werden.</p><p>Der Link wird nach einem Klick auf "OK" gesetzt.<br></p><h5><img src="/js/images/unlink.png" alt=""> Link entfernen</h5><p>Entfernt einen zuvor markierten Link.<br></p><h5><img src="/js/images/specialchar.png" alt=""> Sonderzeichen einfügen</h5><p>Dieser Button öffnet den Dialog zur Auswahl von Sonderzeichen. Das gewünschte Sonderzeichen wird einfach angeklickt, um es an der aktuellen Cursorposition einzufügen. Damit lassen sich vor allem gängige typographische Zeichen verwenden, die auf der Tastatur nicht vertreten sind, wie etwa der Gedankenstrich (–), der lange Gedankenstrich (—) oder das Copyright-Zeichen (&copy;), um nur einige zu nennen.<br></p><h5><img src="/js/images/image.png" alt=""> Bild einfügen</h5><p>Öffnet den Dialog zum Einfügen eines Bildes oder eines Bildobjektes aus der Bilddatenbank. Dazu geben wir unter URL den absoluten Pfad einer Bilddatei ein oder wählen mit Hilfe des Bildassistenten ein Bild aus der Bilddatenbank aus. Bei letzterer Methode sind wir auf der sicheren Seite.</p><p>Unter Alternativtext geben wir in einem kurzen Satz über den Inhalt des Bildes Bescheid, zum Beispiel: "Eingestürztes Haus in Köln". Der Alternativtext kann bei rein dekorativen Grafiken entfallen.</p><p>Unter "Größe" kann zwischen den vorskalierten Bildgrößen aus der Bilddatenbank ausgewählt werden. Ein Haken bei "vergrößern" erlaubt die Vergrößerung des Bildes mit einem so genannten Lightbox-Effekt.</p><p>Der Umfluss kontrolliert die Lage des Bildes etwa links oder rechts vom Text. Beides lässt sich freilich nur dann bewerkstelligen, wenn die Größe des Bildes es sinnvollerweise zulässt. Andernfalls ist es besser, keinen Umfluss einzustellen (Standard).</p><p>Im Allgemeinen orientiert sich die Positionierung des Bildes am Text-Cursor, allerdings sollte man diese im besten Fall zu Beginn eines Absatzes wählen und nicht irgendwo mitten in einem Textfluss, da dieser sonst unterbrochen wird. Man braucht also den Cursor nicht rechts platzieren, um ein Bild rechts vom Absatz zu haben.</p><p>Mit Bildunterschrift und Copyright lassen sich die entsprechenden Texte eingeben. Ein Ausfüllen dieser Texte bewirkt in Zusammenhang das Einfügen eines HTML-Konstruktes.<br></p><h5><img src="/js/images/wai_tool.png" alt=""> Werkzeuge zur Zugänglichkeit</h5><p>Mit diesem Werkzeug lassen sich einige Auszeichnungen realisieren, die für barrierefreie Texte notwendig sind: Auszeichnung von Sprachwechsel, von Abkürzungen und Akronymen. Zuerst den Text markieren. Unter "Auszeichnung" zwischen "Sprache", "Abkürzung" und "Akronym" wählen. Bei Sprachwechsel unter "Sprache" die von der Standardsprache abweichende Sprache auswählen, etwa "English" wie in diesem Beispiel: some english text. Die Auszeichnung hat in der Regel keine optische Auswirkung auf der Website, wird jedoch im Editor grau unterstrichen und mit dem ISO-Code der Sprache versehen (etwa "EN" für Englisch). Mit dem Einsatz von Sprachwechsel können Screenreader die abweichenden Texte wieder korrekt vorlesen und Suchmaschinen die Texte besser indizieren.</p><p>Abkürzungen wie z.B. sollten generell vermieden werden, da sie weder hübsch aussehen noch das Textverständnis fördern. Mit "Abkürzung" lässt sich der markierte Text, die Abkürzung, mit der Langversion ergänzen: <abbr title="zum Beispiel">z.B.</abbr> Das macht freilich nur Sinn bei aus irgendwelchen Gründen unvermeidbaren Abkürzungen, etwa in juristischen Texten.</p><p>Das Gleiche gilt für Akronym. Akronyme sind Abkürzungen eines Begriffes, die aber wie ein Wort ausgesprochen werden, wie etwa <acronym title="National Aeronautics and Space Administration" lang="en">NASA</acronym>. In diesem Fall ist das Akronym auch in einer abweichenden Sprache, was hier in der selben Auszeichnung mit dem Sprachattribut ausgewählt werden kann.</p><p>Abkürzungen und Akronyme haben je nach Design eine graue Unterlinie oder werden gar nicht gesondert angezeigt. In jedem Fall wird ein so genanntes Tooltip mit der ausgeschriebenen Version ausgegeben, sobald der Mauszeiger darüber geht. Hauptsächlich dient das Werkzeug für Screenreader und für die semantische Korrektheit des Textes.<br></p><h5><img src="/js/images/table.png" alt=""> Tabelle einfügen</h5><p>Mit diesem Dialog wird das Einfügen einer Datentabelle ermöglicht, die im Design vordefiniert ist und bei nicht missbräuchlicher Verwendung barrierefrei ist. Dazu notwendig sind die Angaben einer Tabellenüberschrift sowie das Hinzufügen von Spalten- und Zeilenköpfe.</p><h5><img src="/js/images/pastetext.png"> Reinen Text einfügen</h5><p>Ein Klick auf diesen Icon öffnet ein Eingabefeld, das es ermöglicht, kopierte Passagen als reinen Text einzufügen. In der Regel ist das die sicherste Variante, Texte aus anderen Programmen sauber auf die Website zu bringen. Der Text kann im Nachhinein mit den entsprechenden Absatz- und Überschriftenformaten strukturiert werden.<br></p><h5><img src="/js/images/removeformat.png" alt=""> Formatierungen entfernen</h5><p>Beim Kopieren eines Textes von einer Textverarbeitung oder aus einem anderen Medium kommen in der Regel unerwünschte und zumeist einfach falsche und irritierende Formatierungen mit. Mit einem Klick auf diesen Button werden sämtliche Formatierungen entfernt.<br></p><h5><img src="/js/images/striptags.png" alt=""> HTML säubern (nach Kopieren)</h5><p>Ähnlich wie Formatierung entfernen ist dieses Werkzeug, wobei jedoch Textstrukturen wie Absätze und Überschriften sowie Bilder erhalten bleiben.</p>', '530', '', 'de'),
( '20', '2', 'Suchbegriffe', '<p>Geben Sie hier mit Komma getrennt Schlüsselwörter ein, die speziell zu \r\ndieser Seite passen und noch nicht in den allgemeinen Schlüsselwörtern \r\n(CMS-Einstellungen) enthalten sind.</p><p>Dies dient zur Suchmaschinen-Optimierung der Website.<br></p>', '540', 'pages.keywords', 'de'),
( '21', '2', 'Beschreibung', '<p>Geben Sie hier in ein, zwei Sätzen eine kurze Beschreibung des \r\nSeiteninhaltes an. Dieser ersetzt die allgemeine Beschreibung aus den CMS-Einstellungen und wird auch in Übersichtsseiten herangezogen.<br></p>', '550', 'pages.description', 'de'),
( '22', '2', 'Veröffentlichen', '<p>Hier wird der Status der Veröffentlichung angegeben. Eine Seite kann offline also für Besucher uneinsichtig sein, was eine gute Wahl ist, solange die Seite noch nicht fertiggestellt ist.</p><p>Eine veröffentlichte Seite ist in der Suche auffindbar und kann über andere Navigationselemente zugänglich gemacht werden, wie das gerne für Impressum, AGB, Datenschutzerklärung und dergleichen gemacht wird.</p><p>In der Regel wird eine Seite auch in der Menüleiste und der Subnaviagtion aufscheinen, in diesem Fall wird der dritte Punkt ausgewählt.<br></p>', '560', 'pages.published', 'de'),
( '23', '2', 'Ordner der Seite', '<p>Der Ordner zeigt an, wo die Seite in der Menüstruktur und im Inhaltsverzeichnis aufscheint. Unterste Ebene ist der Ordner <strong>"Home"</strong>. Sämtliche Seiten und Ordner, die sich in HOME befinden, werden in der Hauptnavigation angezeigt.</p><p>Jeder\r\n Ordner kann wiederum weitere Ordner und Seiten beinhalten.</p>', '570', 'pages.parent', 'de'),
( '24', '2', 'Vorlagen', '<p>Sollten mehrere Vorlagen für das Seiten-Layout vorliegen, kann hier die entsprechende Vorlage gewählt werden.</p><p> \r\n  Die Vorlagen können von Benutzern mit Status Administrator verwaltet werden.</p>', '580', 'pages.template', 'de'),
( '25', '2', 'Sortieren', '<p>Die Seiten erscheinen in den Menüpunkten und in den \r\nInhaltsverzeichnissen in der Reihenfolge ihrer Eingabe. Das heißt: die \r\nzuletzt erstellte Seite ist als erste zu sehen. Um die Reihenfolge \r\nbeliebig zu manipulieren, gibt es das Sortierfeld.</p><p>Sortierungen können bequemer in der Tabellenübersicht vorgenommen werden.<br></p>', '590', 'pages.sort', 'de'),
( '26', '2', 'Titel anzeigen', '<p>Das Häkchen entscheidet, ob der Titel innerhalb der Seite angezeigt \r\nwerden soll, oder nicht. Sollte der Titel nicht angezeigt werden, \r\nempfiehlt es sich, diesen mit dem Format "Überschrift 1" im Textkörper der \r\nSeite einzufügen. Bei dieser Variante kann der Titel im Design der Seite\r\n integriert werden, etwa mit einem rechts- oder linksbündigen Bild.</p>', '600', 'pages.show_title', 'de'),
( '27', '2', 'Zeitsteuerung', '<p>Die Veröffentlichung (im Menü) kann auch zeitgesteuert erfolgen. Das Start-Datum setzt die Seite in den Modus "Menü & veröffentlicht", das Ende-Datum setzt sie offline.</p><p>Klappen Sie den Bereich bei Bedarf aus.<br></p>', '610', 'pages.cron', 'de'),
( '29', '7', 'Website URL', '<p>Die Internetadresse der Website inklusive http://www.<br></p>', '680', 'web_settings.website_url', 'de'),
( '30', '7', 'Das Logo der Website', '<p>Das Logo der Website dient zur unverwechselbaren Identifikation. Laden Sie hier die Bilddatei hoch oder wählen Sie eine bereits vorhandene aus. Beachten Sie, dass die Abmessungen des Bildes im Rahmen der wiedergegebenen Größe sein sollen.<br></p>', '690', 'web_settings.website_logo', 'de'),
( '31', '7', 'Schlüsselwörter', '<p>Geben Sie hier zehn bis <strong>maximal zwanzig</strong> wesentliche Schlüsselwörter ein,\r\n die den Inhalt der Website klassifizieren. Dadurch können Suchmaschinen\r\n die Website bestimmten Suchkriterien besser zuordnen. Diese Angaben werden mit den individuellen Suchbegriffen einzelner Seiten kombiniert.<br></p>', '700', 'web_settings.website_keywords', 'de'),
( '32', '7', 'Autor', '<p>Tragen Sie hier den Namen des Autors oder des Betreibers ein. Die Angabe scheint in den Meta-Daten auf.<br></p>', '720', 'web_settings.website_author', 'de'),
( '33', '7', 'Meta-Beschreibung', '<p>Umreißen Sie in ein, zwei Sätzen den Inhalt der Website. Diese Beschreibung kann durch die individuelle Beschreibung einer Seite überschrieben werden. Auch diese Angabe dient der Suchmaschinenoptimierung.</p>', '710', 'web_settings.website_description', 'de'),
( '34', '7', 'Design-tragendes Stylesheet', '<p>Wählen Sie hier eines der verfügbaren Stylesheets aus. Bereits ausgewählte Stylesheets können in weiterer Folge unter Einstellungen - CSS Manager bearbeitet und somit zu einem individuellen Design adaptiert werden.<br></p>', '730', 'web_settings.def_css', 'de'),
( '35', '7', '"Home" nicht anzeigen', '<p>Der Menüpunkt "Home" in der Navigationsleiste kann hier optional ausgeschaltet werden. Sie gewinnen dadurch Platz.<br></p>', '740', 'web_settings.skip_home', 'de'),
( '36', '7', 'Breadcrumb anzeigen', '<p>Hier kann die Breadcrumb global aktiviert oder deaktiviert werden. Die Brotkrumen-Navigation zeigt die vertikale Position einer Seite an und dient somit der Orientierung. Bei Websites mit geringem Inhaltsvolumen kann diese ausgeschaltet werden.<br></p>', '750', 'web_settings.breadcrumb', 'de'),
( '37', '7', 'Subnavigation anzeigen', '<p>Hier kann die Sub-Navigation global aktiviert oder deaktiviert werden. Sie zeigt parallel positionierte Inhalte an und dient der Übersichtlichkeit. Bei Websites mit geringem Inhaltsvolumen kann diese ausgeschaltet werden.</p>', '760', 'web_settings.sub_nav', 'de'),
( '38', '7', 'Internationalisierung', '<p>Sollte die Website mehrere Sprachversionen unterstützen, sollten auch die Metadaten übersetzt werden. Im linken Übersichtsbaum kann die jeweilige Sprache abweichend zur Standardsprach ausgewählt werden.<br></p>', '660', '', 'de'),
( '39', '3', 'Teaser und Container', '<p>\r\nMithilfe der <span style="font-weight: bold;" class="langatt" lang="en">Teaser</span> lenken Sie die Aufmerksamkeit Ihrer Besucher auf spezielle Inhalte. Ein Teaser oder Ankündigungskasten kann aus Titel, Text und/oder Bild sowie einem Link bestehen<br></p><p>Ein <span class="langatt" lang="en"><span style="font-weight: bold;">Container</span></span> sieht ähnlich aus wie ein <span class="langatt" lang="en">Teaser</span>, kann jedoch mehrere\r\nVerweise auf andere Inhalte aufnehmen. Mit Container lassen sich also\r\nje nach Bedarf weitere Navigationselemente erstellen.</p><p>Für Teaser und Container sind Bereiche vorgesehen, die vom Administrator bei Bedarf ergänzt oder modifiziert werden können.<br></p>', '420', 'announces', 'de'),
( '40', '3', 'Link', '<p>Tragen Sie hier die URL des Links ein zu dem der Kasteninhalt oder ein Container-Punkt führen soll.</p><p>Wollen Sie zum Beispiel, dass der Eintrag zur Nachrichtenseite "Der Standard" führt, schreiben Sie hier <a href="http://www.derstandard.at">"http://www.derstandard.at".</a>  Um einen Link auf die eigene Seite einzufügen, benutzen Sie den <em>Linkassistenten</em> indem Sie auf das Ordnersymbol klicken. Es geht dann ein neues Fenster auf, in dem  die betreffende Seite bequem ausgewählt werden kann.</p>', '890', 'announces.link', 'de'),
( '41', '3', 'Text des Teasers', '<p>Geben Sie hier beliebigen Text \r\nein. Beachten Sie jedoch, dass zuviel Text die Übersichtlichkeit Ihrer \r\nWebseite beeinträchtigen kann.</p>', '900', 'announces.text', 'de'),
( '42', '3', 'Bereich', '<p>Hier können sie wählen, in welchem Bereich der Teaser aufscheinen soll.<br></p>', '910', 'announces.active', 'de'),
( '43', '3', 'Sortieren', '<p>Die Teaser erscheinen in der Reihenfolge ihrer Eingabe. Das heißt: der \r\nzuletzt erstellte Kasten ist als erster zu sehen. Um die Reihenfolge \r\nbeliebig zu manipulieren, gibt es das Sortierfeld.</p><p>Sortierungen können bequemer in der Tabellenübersicht vorgenommen werden.</p>', '920', 'announces.sort', 'de'),
( '44', '3', 'Sprachauswahl', '<p>Bei Mehrsprachigkeit kann hier ausgewählt werden, zu welcher Sprachvariante der Teaser gehört.<br></p>', '930', 'announces.lang', 'de'),
( '45', '3', 'Bild hinzufügen', '<p>Sie können Ihrem Kasten ein kleines Bild hinzufügen. Dazu sind zwei Methoden möglich.</p><ol><li>Das Bild befindet sich in Form einer digitalen Bilddatei (JPG, GIF, PNG) auf Ihrem Rechner.<br>In diesem Fall gehen Sie unter "<strong>Bild hochladen</strong>"\r\n auf "Durchsuchen". Es öffnet sich ein Fenster, mit dessen Hilfe Sie \r\neine Bilddatei von der Festplatte Ihres Computers auswählen können. <br></li><li>Das Bild wurde bereits hochgeladen und befindet sich in der Bilddatenbank.<br>Klicken Sie unter "<strong>vorhandenes Bild</strong>"\r\n auf das Ordnersymbol. Es öffnet sich ein Fenster, mit dessen Hilfe Sie \r\neine Bilddatei aus der Bilddatenbank auswählen können. Der Dateiname \r\nsowie die Kleindarstellung des Bildes werden angezeigt.</li></ol>', '940', 'announces.picture', 'de'),
( '46', '3', 'Alternativtext', '<p>Beschreiben Sie hier in aller Kürze, was auf dem Bild zu sehen \r\nist. Der Alternativtext kann entfallen, wenn ein Bild ausschließlich als\r\n Dekoration dient.</p>', '950', 'announces.alternative', 'de'),
( '47', '3', 'Zeitsteuerung', '<p>Das Erscheinen des Teasers kann auch zeitgesteuert erfolgen. Das \r\nStart-Datum aktiviert den Eintrag im angegebenen Bereich, \r\ndas Ende-Datum setzt ihn inaktiv.</p><p>Klappen Sie den Bereich bei Bedarf aus.</p>', '960', 'announces.cron', 'de'),
( '48', '3', 'Container-Titel', '<p>Geben Sie hier eine kurzen Bezeichnungstext für den Container-Eintrag ein. </p>', '980', 'container.text', 'de'),
( '49', '3', 'Container-Einträge', '<p>Um einen neuen \r\nEintrag für einen Container zu erstellen, klicken Sie auf "Neuer \r\nEintrag". Bestehende Einträge werden mit einem Klick auf das \r\nEditiersymbol zur Bearbeitung geöffnet.</p><p>Einzelne Einträge werden mit einem Klick auf das Löschsymbo gelöscht.</p><p>Um die Einträge zu sortieren, ziehen Sie die Tabellenzeilen in die gewünschte Reihenfolge. Danach klicken Sie auf "Sortieren".</p>', '970', 'container', 'de'),
( '50', '3', 'Link eines Container-Eintrages', '<p>Geben Sie hier einen Link ein \r\noder suchen Sie mit Hilfe des Linkassistenten nach einer Seite oder \r\neinem Dokument Ihrer eigenen Website. Zum Öffnen des Linkassistenten \r\nklicken Sie auf das Ordnersymbol neben dem Eingabefeld.\r\n</p>', '990', 'container.link', 'de'),
( '51', '6', 'Bildarchiv', '<p>Das Bildarchiv bietet eine Übersicht über \r\nalle vorhandenen Bilder, die in Ihrer Website verwendet werden können, \r\noder bereits verwendet worden sind. <br></p><p>Die Bilder lassen sich \r\nhier auf den Webserver hochladen, beschriften, katalogisieren und \r\ngegebenenfalls nachbearbeiten (drehen, spiegeln, zurechtschneiden).</p>', '280', 'images', 'de'),
( '52', '6', 'Bild hochladen', '<p>Mit einem Klick auf die\r\n Schaltfläche "Durchsuchen" öffnet sich der Datei-Manager Ihres \r\nWebbrowsers. Hier suchen Sie das gewünschte Bild aus. Beachten Sie, dass\r\n im Web ausschließlich die Bildformate <strong>PNG,</strong> <strong>GIF,</strong> <strong>JPG</strong> verwendbar sind.</p>\r\n  <p>Um mehrere Bilder gleichzeitig hochzuladen, können Sie Bilddateien aus einem Dateibrowser direkt in das vorgesehene Feld ziehen.<br></p>', '310', 'images.filename', 'de'),
( '53', '6', 'Titel', '<p>Ein aussagekräftiger Titel hilft \r\nIhnen, Bilder später wieder mit Hilfe von Suchbegriffen zu finden. Dies \r\nist vor allem beim Aufbau größerer Bildarchive von Vorteil.\r\n</p>', '290', 'images.title', 'de'),
( '54', '6', 'Beschreibung', '<p>Vor allem beim Aufbau großer Bildarchive leistet das Beschreibungsfeld nützlich Dienste.</p>', '300', 'images.description', 'de'),
( '55', '6', 'Mappe', '<p>Wählen Sie hier jene Mappe \r\n(Bildordner) aus, in der Sie das Bild ablegen wollen. Die Mappen selbst \r\nkönnen Sie unter "Neue Mappe" anlegen.</p>', '330', 'images.parent', 'de'),
( '56', '6', 'Urheberrecht', '<p>Geben Sie hier zur internen Klärung den Inhaber der Urheberrechte an.<br></p>', '320', 'images.copyright', 'de'),
( '57', '8', 'Beschneiden', '<p>Hier lassen sich Bilder, die bereits in der Bilddatenbank sind und somit am Server, nachträglich beschneiden.</p><p>Positionieren\r\n sie den Rahmen an die gewünschte Stelle des Bildes, indem Sie mit \r\ngedrückter linker Maustaste den Ausschnitt bewegen.<br></p><p>Die \r\ngewünschte Ausschnittsgröße erhalten Sie, indem Sie die Anfasser des \r\nRahmens mit gedrückter Maustaste in die gewünschte Länge oder Breite \r\nziehen.</p><p>Sobald der Rahmen dem neuen Ausschnitt entspricht, kann das Bild mit einem Klick auf "Beschneiden" zugeschnitten werden.</p><p>Ferner haben Sie die Wahl entweder das Originalbild zu überschreiben oder den Namen für eine neue Bild-Datei anzugeben.</p><p>Es können auch fixe Seitenverhältnisse wie 4:3, 3:4 oder 16:9 ausgewählt werden. <br></p>', '340', 'images.crop', 'de'),
( '58', '8', 'Spiegeln', '<p>Das Bild kann bei Bedarf horizontal oder vertikal gespiegelt werden. Wählen Sie dazu das gewünschte Resultat aus<br></p><p>Ferner haben Sie die Wahl entweder das Originalbild zu überschreiben oder den Namen für eine neue Bild-Datei anzugeben.</p>', '350', 'images.mirror', 'de'),
( '59', '8', 'Rotieren', '<p>Wählen Sie die gewünschte Rotation aus. <br></p><p>Ferner haben Sie die Wahl entweder das Originalbild zu überschreiben oder den Namen für eine neue Bild-Datei anzugeben.</p>', '360', 'images.rotate', 'de'),
( '60', '6', 'Bildvorschau', '<p>Hier sehen Sie alle verfügbaren vorskalierten Bildgrößen.<br></p>', '370', 'images.preview', 'de'),
( '61', '8', 'Bildname', '<p>Geben Sie hier einen neuen Dateinamen des Bildes ein, falls das bestehende nicht überschrieben werden soll. Das ist vor allem für Bilder ratsam, die auf der Website bereits im Einsatz sind.<br></p>', '400', 'images.newfile', 'de'),
( '62', '9', 'Die Benutzeroberfläche', '<p>Die Benutzeroberfläche teilt sich in folgende Areale auf:</p><ul><li>Statusleiste</li><ul><li>Name und Link zur Website</li><li>Anzeige von Meldungen<br>Ein gelbes Dreieck weist auf etwaige Meldungen hin, die bereits ausgeblendet worden sind und mit einem Klick auf das Symbol wieder eingeblendet werden können.<br></li><li>Link zur Hilfe</li><li>Benutzer<br>Der Icon gibt Auskunft über den Benutzerstatus.</li><li>Link zur Abmedlung<br></li></ul><li>Karteireiter mit Hauptmenü<br>sie beinhaltet alle wesentlichen Funktionen von Consentio.</li><li>Hierarchische Darstellung von Daten<br>Auf\r\n der linken Seite wird in Form von verschachtelten Ordnern die \r\nhierarchische Struktur der jeweils angezeigten Daten sichtbar. Wobei \r\noffene Aktenordner den momentanen Ort anzeigen.</li><li>Datenanzeige oder Eingabemaske<br>Auf\r\n der rechten Seite im Hauptfenster sind schließlich die Daten des \r\ngewünschten Menüs oder Ordners sichtbar. Das ist in der Regel eine Liste\r\n der vorhandenen Daten mit Suchfunktion oder eine Eingabemaske, um Daten zu bearbeiten \r\noder neu zu kreieren.</li></ul>', '380', '', 'de'),
( '63', '9', 'Sortieren in Listenansicht', '<p>In vielen Fällen kann eine beliebige Reihenfolge der diversen Einträge (zum Beispiel beim Seitenmanagement) durch das Sortieren hergestellt werden.<br></p><p>Das Sortieren der\r\n Reihenfolge in der Listenansicht wird entweder durch ein Ziehen des \r\nbetreffenden Eintrages (Tabellenzeile) an die gewünschte Stelle \r\nbewerkstelligt oder durch Manipulation des Sortierschlüssels. Sollte \r\netwa ein Eintrag zwischen zwei anderen Einträgen rutschen, deren \r\nSortierschlüssel 20 und 30 betragen, geben Sie einfach eine Zahl \r\nzwischen 20 und 30 ein.</p><p>Ist die gewünschte Reihenfolge hergestellt, klicken Sie auf "Sortieren" am Listenende.</p><p>In\r\n vielen Fällen ist eine Sortierung nur innerhalb eines bestimmten \r\nBereiches möglich. Im Seiten-Management zum Beispiel erfolgt die \r\nÄnderung der Reihenfolge nur innerhalb eines Ordners, der links im Baum \r\nausgewählt werden kann.</p>', '390', 'common.sort', 'de'),
( '64', '10', 'Bildermappe', '<p>Unter <strong>"Mappe"</strong> lassen \r\nsich beliebig viele ineinander verschachtelte Mappen anlegen, in die Sie\r\n Ihre Bilder ablegen oder weiter Mappen erstellen. Damit lässt sich bei \r\nnachvollziehbarer Logik auch bei einem großen Bildarchiv Übersicht \r\nbewahren.</p>', '260', 'img_folder', 'de'),
( '65', '10', 'Titel der Mappe', '<p>Geben Sie hier einen aussagekräftigen Begriff ein, der den Themenschwerpunkt der darin enthaltenen Bilder angibt, z.B. "<em>Politiker</em>", <em>"Katzen"</em> oder dergleichen.\r\n</p>', '250', 'img_folder.name', 'de'),
( '66', '10', 'Mappe der Mappe', '<p>Wählen Sie hier die Mappe aus, in der diese Mappe enthalten sein soll, z.B. könnte "<em>Politiker</em>" in der Mappe "<em>Menschen</em>" angelegt werden. Die unterste Ebene ist "<em>Bilddatenbank</em>".</p>', '240', 'img_folder.parent', 'de'),
( '67', '4', 'Dateien hochladen', '<p>Dateien, die den Besuchern zum Herunterladen angeboten werden, werden im "Dateimanager" hochgeladen. Sämtliche hochgeladenen Dateien lassen sich mit dem Link-Assistenten unter dem Punkt <em>"Dokumente"</em> als Link verknüpfen.</p><p>Im Verzeichnis "<em>documents</em>" können auch beliebig viele Unterverzeichnisse anlegt werden.</p><p>In der linken Spalte finden Sie dieVerzeichnis -Übersicht. Rechts werden die Verzeichnisse und Dateien des gewählten Verzeichnisses \r\nangezeigt. Diese können je nach Dateityp heruntergeladen oder besichtigt\r\n sowie gelöscht werden.</p><p>Benutzer mit Wartungsstatus haben hier darüber hinaus Zugriff auf systemrelevante Dateien und Verzeichnisse, etwa um Grafiken hochzuladen oder Skriptdateien zu editieren.<br></p>', '230', 'filemanager', 'de'),
( '68', '4', 'Hochladen', '<p>Unter "Hochladen" wählen Sie mit "Durchsuchen" eine Datei von Ihrem \r\nPC aus. Mit einem Klick auf  OK, laden Sie die Datei in das aktuelle \r\nVerzeichnis des Webservers. Um in einen anderen Ordner zu gelangen, \r\nwählen Sie links den gewünschten Ordner aus.</p>\r\n<h3>Mehr Komfort mit HTML5</h3><p>Browser, die Funktionen von HTML5 \r\nunterstützen, bieten ferner die Möglichkeit, mehrere Dateien \r\ngleichzeitig hochzuladen. Mit gedrückter STRG-Taste lassen sich im mit\r\n "Durchsuchen" geöffnetem Fenster mehrere Dateien auswählen. Man kann \r\naber auch von einem beliebigen Dateimanager Dateien in das dafür \r\nvorgesehene Feld ziehen.</p>\r\n<p>Das Hochladen erfolgt unmittelbar und wird mit einem \r\nFortschrittsbalken angezeigt. Sobald alle Dateien eine Rückmeldung \r\nerhalten haben, sind diese verfügbar.</p>', '440', 'uploads', 'de'),
( '69', '4', 'Neuer Ordner', '<p>Geben Sie hier den Namen des \r\nneuen Ordners an. Mit einem Klick auf "OK" wird der Ordner im aktuellen \r\nVerzeichnis angelegt. <br></p>', '450', 'filemanager.newdir', 'de'),
( '70', '7', 'Sprachen festlegen', '<p>Wenn die Website in mehreren Sprachen verfügbar sein soll, können hier die Sprachvarianten aktiviert und deaktiviert werden.</p>', '770', 'lang_settings', 'de'),
( '71', '7', 'Komponenten', '<p>Komponenten sind HTML-Teile der Website, die entweder generiert werden oder frei zu erstellen und zu bearbeiten sind. Je nach Bedarf kann für die einzelne Komponente ein WYSIWYG-Editor oder ein Skripteditor verwendet werden. Letzteres empfiehlt sich für eingebettete Javascripts.</p><p>Komponenten werden in den HTML-Vorlagen als Platzhalter eingefügt.<br></p>', '780', 'components', 'de'),
( '72', '7', 'Name der Komponente', '<p>Ein Name wie zum Beispiel MY_OWN_PRIVATE_ONE kann in den HTML-Vorlagen als Platzhalter &&&&MY_OWN_PRIVATE_ONE&&&& eingefügt werden.<br></p><p>Der Name der Komponente wird in Großbuchstaben geschrieben und darf keine Leerzeichen enthalten. </p>', '790', 'components.name', 'de'),
( '73', '7', 'Titel der Komponente', '<p>Ein aussagekräftiger, für Menschen verständlicher Titel für die Komponente.<br></p>', '800', 'components.title', 'de'),
( '74', '7', 'Bechreibung', '<p>Eine Beschreibung hilft vor allem bei Javascript-Komponenten den Sinn und Verwendungszweck einer Komponente festzuhalten.<br></p>', '810', 'components.description', 'de'),
( '75', '7', 'Aktivierung', '<p>Komponenten können hier auch vorübergehend deaktiviert werden, ohne dass man den Platzhalter aus der oder den Vorlagen löscht.<br></p>', '820', 'components.active', 'de'),
( '76', '7', 'Sprachgültigkeit', '<p>Die Gültigkeit einer Komponente kann für bestimmte Sprachen oder sprachübergreifend (mit *) angegeben werden.<br></p>', '830', 'components.lang', 'de'),
( '77', '7', 'Typ', '<p>Hier kann der Typ zwischen Skript und WYSIWYG geändert werden. Nach der Speicherung wird die Komponente mit dem passenden Editor geöffnet. Beachten Sie, dass Javascript im WYSIWYG-Editor beeinträchtigt werden kann.<br></p>', '840', 'components.type', 'de'),
( '78', '7', 'Vorlagen Manager', '<p>Hier werden die Seitenvorlagen erstellt oder bearbeitet. Wählen Sie für die jeweiligen Bereich der Seitenvorlage eine passende HTML-Vorlage aus.</p><p>Neue HTML-Vorlagen werden unter HTML-Vorlagen angelegt oder modifiziert.</p><p>Unter "Lade Vorlage für Basis-Layout" können alternative HTML-Vorlagen geladen werden. Achten Sie darauf, dass diese etwaige modifizierte Vorlagen überschreiben.<br></p>', '850', 'templates', 'de'),
( '79', '7', 'Name der Seitenvorlage', '<p>Geben Sie hier den Namen der Vorlage an, so wie er im Auswahlfeld der Seitenverwaltung aufscheinen soll.<br></p>', '880', 'templates.name', 'de'),
( '80', '11', 'Benutzer', '<p>In der Benutzerverwaltung wird festgelegt, wer auf die Verwaltung der \r\nWebsite zugreifen darf, und welche Befugnisse der Benutzer dabei hat.</p>', '210', 'user', 'de'),
( '81', '11', 'Benutzername', '<p>Geben Sie hier den Namen des Benutzers an, mit dem sich der Benutzer anmelden soll. <em>Für das Nachrichten-Modul</em><span style="font-style: italic;"> </span>empfiehlt es sich, den vollständigen Namen anzugeben, da dieser als Autor redaktioneller Artikel aufscheint.\r\n</p>', '200', 'user.name', 'de'),
( '82', '11', 'Kürzel', '<p>Das Kürzel dient zur Identifikation des Benutzers und wird beim Nachrichten-Modul als Autorenkürzel angezeigt.\r\n</p>', '190', 'user.short', 'de'),
( '83', '11', 'Benutzerstatus', '<p>\r\nWählen Sie hier aus welchen Benutzerstatus der Benutzer haben soll.</p><ul><li><strong>Benutzer:</strong></li><ul><li>Seiten anlegen und editieren</li><li>Teaser anlegen und editieren</li><li>Bilder hochladen<br></li></ul><li><strong>Administrator</strong>:</li><ul><li>alles, was Benutzer können<br></li></ul><ul><li>Benutzer anlegen</li><li>Dateien verwalten</li><li>diverse Einstellungen vornehmen</li></ul><li><strong>Wartung</strong><br>hat darüber hinaus uneingeschränkten Zugang auf systemrelevante Einstellungen und Funktionen. (Dieser Status kann nur von Benutzern mit Wartungslevel vergeben werden.)<br></li></ul>', '180', 'user.level', 'de'),
( '84', '11', 'Farbschema', '<p>Wählen Sie ein Farbschema aus.<br></p>', '170', 'user.scheme', 'de'),
( '85', '11', 'Optionen', '<p>Hier kann der Benutzer sein Passwort ändern, Sprache und Farbschema der Benutzeroberfläche auswählen sowie die Hilfepunkte aktivieren oder deaktivieren.<br></p>', '160', 'options', 'de'),
( '86', '12', 'Menü-Register', '<p>Verwaltung der registrierten Funktionen und ihr Aufscheinen in den diversen Menüs.<br></p>', '20', 'register', 'de'),
( '87', '12', 'Name', '<p>Der Name ist der i18n-Schlüssel, der unter Sprachen einzutragen und zu übersetzen ist. Nicht übersetzte Namen werden mit eckigen Klammern versehen.<br></p>', '30', 'register.name', 'de'),
( '88', '12', 'Funktionsaufruf', '<p>Der Name, mit dem die Funktion aufgerufen wird (identisch mit dem Parameter _id und der Vorgabe $forms[\'myconf\']).<br></p>', '50', 'register.call', 'de'),
( '89', '12', 'Plugin', '<p>Der Name des Plugins, in dem sich die Funktion befindet.</p><p>Beispiele: Die Funktion "foo" befindet sich in bar.php, so wird hier "bar" eingegeben. Die Funktion "bar" ist in "bar.php", so braucht hier nichts eingetragen werden.<br></p>', '40', 'register.plugin', 'de'),
( '90', '12', 'zusätzliche Parameter', '<p>Allfällige zusätzliche Parameter für den Funktionsaufruf, wie etwa "&todo=edit", um in die Eingabemaske eines neuen Datensatzes zu gelangen.<br></p>', '60', 'register.params', 'de'),
( '91', '12', 'Vorlage für GUI', '<p>Auswahl der Vorlage von der Benutzeroberfläche.<br></p>', '70', 'register.gui', 'de'),
( '92', '12', 'Benutzer-Status', '<p>Ab welchem Benutzer-Status kann diese Funktion aufgerufen werden.<br></p>', '80', 'register.level', 'de'),
( '93', '12', 'Icon', '<p>Auswahl des Icons, der die Funktion darstellt. Neue Icons können in die Verzeichnisse co_icons (16*16px) und co_icons/48 (48*48px) hochgeladen werden.<br></p>', '90', 'register.icon', 'de'),
( '94', '12', 'Gruppe', '<p>Auswahl der Gruppe, in der die Funktion enthalten ist.<br></p>', '100', 'register.tab', 'de'),
( '95', '12', 'In der Übersicht', '<p>Die Funktion in der Übersicht aktivieren.<br></p>', '120', 'register.start', 'de'),
( '96', '12', 'Im Karteireiter', '<p>Die Funktion als Karteireiter anzeigen.<br></p>', '130', 'register.top', 'de'),
( '97', '12', 'In der Gruppen-Ansicht', '<p>Die Funktion in einer Gruppenansicht anzeigen.<br></p>', '140', 'register.group', 'de'),
( '98', '12', 'Im Frontend zulassen', '<p>Die Funktion darf auch aus dem Frontend, also ohne Login aufgerufen werden (bei Einhaltung aller Vorsichtsmaßnahmen).<br></p>', '150', 'register.frontend', 'de'),
( '99', '12', 'CSS Manager', '<p>In der CSS Verwaltung können die Stylesheets in einem Code-Editor berabeitet werden. Wählen Sie links die CSS-Datei aus, die bearbeitet werden soll.</p><p>Die Farbpalette hilft, Farben zu mischen und Farbcodes in die Datei einzufügen.</p><p>Markieren Sie einen hexadezimalen Code im Stylesheet und laden diesen mit dem Icon mit den zwei Pfeilen in die Palette. Ein Klick auf den Icon mit dem Pfeil nach rechts fügt den Farbcode in die aktuelle Position oder Markierung im Editor ein.</p><p>Mit einem Klick auf eine beliebige Farbfläche wird die aktuelle Farbe neu geladen. Die aktuelle Farbe kann mit einem Klick auf die obere oder untere Farbfläche auf das Mischpult übertragen werden. Es werden zwischen den beiden Farbflächen nun 10 Schattierungen der beiden Farben generiert, die wiederum als aktuelle Farbe gewählt werden kann.<br></p>', '10', 'cssadmin', 'de'),
( '100', '12', 'Menü-Gruppen', '<p>Gruppen für Menüeinträge erstellen und verwalten<br></p>', '110', 'rgroups', 'de'),
( '101', '14', 'HTML-Vorlagen', '<p>Sämtliche HTML-Vorlagen und -Schnippsel sowohl für die Benutzeroberfläche (Gruppe GUI)  als auch für die Vorlagen des CMS (Gruppe CMS) werden hier zentral verwaltet.</p><br>', '0', 'snippets', 'de'),
( '102', '14', 'Schlüssel', '<p>Der Schlüssel ist eine möglichst aussagekräftige Bezeichnung ohne Leerzeichen, mit deren Hilfe dieser Schnippsel oder diese Vorlage mit der Parserfunktion aufgerufen werden kann.</p><p>Beispiel:</p><p>Der Schlüssel lautet "cms_foo_title", Die Parserfunktion kann nun mit parse_in(\'cms_foo_title\', $data) aufgerufen werden.<br></p>', '0', 'snippets.key', 'de'),
( '103', '14', 'Beschreibung der HTML-Vorlagen', '<p>HTML-Vorlagen können das Seitenlayout bestimmen oder auch nur einen winzigen Teil einer Daten-View. Um die Übersicht in der Administration zu bewahren hilft der Beschreibungstext.<br></p>', '0', 'snippets.description', 'de'),
( '104', '14', 'Der Code', '<p>Hier ist der HTML-Code zu erstellen und zu bearbeiten. Um Daten in die jeweilige Vorlage einzufügen, werden Platzhalter verwendet, die mit je vier buchhalterischen Und umschlossen sind.</p><p>In der Regel sind die Platzhalter Namen von Komponenten oder von Daten. Die Komponente mit Namen MY_OWN_ONE wird mit &&&&MY_OWN_ONE&&&& in die Vorlage gebracht.</p><p>Bei eigenen Parsern würde der Platzhalter &&&&title&&&& den Wert von $data[\'tile\'] einfügen.<br></p><p>Beispiel:</p><p>Name: cms_foo_title</p><p>HTML-Code:</p><pre><h1>&&&&title&&&&</h1><br></pre><p>bei parse_in(\'cms_foo_title\', $data) mit $data[\'title\'] = "Foo Titel" ist das Ergebnis:</p><pre><h1>Foo Titel</h1><br></pre>', '0', 'snippets.code', 'de'),
( '105', '14', 'Gruppe', '<p>Wählen Sie hier die Gruppe, in der sich die HTML-Vorlage befindet. Die verschachtelte Gruppierung dient zur Übersichtlichkeit der HTML-Vorlagen.<br></p>', '0', 'snippets.group', 'de'),
( '106', '14', 'Gruppen der HTML-Vorlagen', '<p>Die verschachtelte Gruppierung dient zur besseren Übersichtlichkeit der HTML-Vorlagen. Benutzen Sie die vorgegeben Logik soweit wie möglich.</p><p>HTML-Vorlagen für Daten-Views des Frontends zum Beispiel werden am besten in einer eigenen neuen Gruppe in CMS -> SECTION angelegt, etwaige zusätzliche Javascript-Schnippsel für Erweiterungen der Benutzeroberfläche in GUI -> SCRIPTS.<br></p>', '0', 'html_group', 'de'),
( '107', '15', 'Internationalisierung', '<p>Die Internationalisierung beruht auf dem Prinzip, dass ein i18n-Schlüssel verwendet wird, der in jede beliebige Sprache übersetzt wird. So lautet der Schlüssel für "Benutzer" "user", dieser wird, sofern die englische Sprache gefragt ist, zu "User".</p><p>Im Code wird die Ausgabe der jeweils aktuellen Sprache in diesem Fall mit i18n(\'user\') aufgerufen.</p><p>Werden im CMS weitere Sprachen aktiviert, wird der Sprachtabelle eine weitere Spalte für Übersetzungen in diese Sprache hinzugefügt. Da einige wenige Begriffe auch im Frontend verwendet werden, ist hier gegebenenfalls eine Übersetzung dieser Begriff notwendig.</p><p>Schlüssel, die nicht übersetzt sind, werden in eckiger Klammer angezeigt. Diese Schlüssel können nun in der Sprachtabelle hinzugefügt werden.</p><p>i18n steht für <em>Internationalisation</em>, ein \'i\' 18 weitere Buchstaben und ein \'n\'.<br></p>', '0', 'languages', 'de'),
( '108', '15', 'i18n Schlüssel', '<p>Das Schlüsselwort, das anstelle des übersetzten Begriffs verwendet wird.<br></p>', '0', 'languages.index', 'de'),
( '109', '15', 'Gruppe der Begriffe', '<p>Mit dem Namen des Plugins bei Gruppe werden Begriffe, die ausschließlich in einem bestimmten Plugin verwendet werden, auch nur innerhalb des angegebenen Plugins geladen. Im Zweifelsfall und für Begriffe des Frontends "common" verwenden.<br></p>', '0', 'languages.group', 'de'),
( '110', '15', 'Spracheintrag', '<p>Es folgen die Übersetzungen in die jeweilige Sprache, wobei der zweistellige ISO-Code für die jeweilige Sprache steht.<br></p>', '0', 'languages.de', 'de'),
( '111', '16', 'Datenbank', '<p>Das Datenbank-Werkzeug erlaubt tiefgreifende Zugriffe auf die Datenbank und ihrer Tabellen:</p><ul><li>Zugriff auf Daten der Tabellen<br></li><li>Neue Tabellen erstellen</li><li>Tabellen verändern:</li><ul><li>Tabellen leeren, löschen<br></li><li>Datenfelder bearbeiten, löschen, hinzufügen</li><li>Indizes löschen, hinzufügen<br></li></ul></ul><p>Mit dem SQL-Fenster werden SQL-Statements jeder Art ausgeführt oder angezeigt.<br></p>', '0', 'tables', 'de'),
( '112', '16', 'Tabellen-Dump', '<p>Es wird ein SQL-Dump der Tabelle oder der View in einem Textfeld ausgegeben. Der Dump kann so wie er ist andernorts eingelesen werden.<br></p>', '0', 'tables.dump', 'de'),
( '113','18', 'License and Attribution', '<p>Copyright (C) 1999-2015 by IMB Webdevelopment</p><p>Foundation,\r\n Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA. This\r\n program is free software; you can redistribute it and/or modify it \r\nunder the terms of the GNU General Public License as published by the \r\nFree Software Foundation; either version 2 of the License, or (at your \r\noption) any later version. <br></p><p>This program is distributed in the\r\n hope that it will be useful, but WITHOUT ANY WARRANTY; without even the\r\n implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR \r\nPURPOSE. See the <a target="_blank" href="http://www.gnu.org/licenses/gpl.txt">GNU General Public License</a> for more details. <br></p><p>You\r\n should have received a copy of the GNU General Public License along \r\nwith this program; if not, write to the Free Software Foundation, Inc., \r\n51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.<br></p><h2>Attribution<br></h2><h3>jQuery</h3><p>Copyright (c) 2007 John Resig (<a target="_blank" href="http://jquery.com">jquery.com</a>)<br>Dual licensed under the MIT and GPL licenses.</p><h3>Treeview <br></h3><p>jQuery plugin to hide and show branches of a tree<br></p><p>Copyright (c) 2007 Jörn Zaefferer (<a target="_blank" href="http://bassistance.de/jquery-plugins/jquery-plugin-treeview/">bassistance.de/jquery-plugins/jquery-plugin-treeview/</a>)<br>Dual licensed under the MIT and GPL licenses</p><h3>jQuery Autocompleter</h3><p>Copyright 2011, Dylan Verheul (<a href="http://code.google.com/p/jquery-autocomplete/">code.google.com/p/jquery-autocomplete/</a>)<br>Licensed under the MIT license</p><h3>jQuery Spin</h3><p>Copyright (c) 2009 Naohiko MORI<br>Dual licensed under the MIT and GPL licenses.</p><h3>TableDnD</h3><p>plug-in for JQuery, allows you to drag and drop table rows<br>Copyright (c) Denis Howlett <br>Dual licensed under the MIT and GPL licenses.</p><h3>Socicon</h3><p>Social Media Icons Font (<a target="_blank" href="http://www.socicon.com">www.socicon.com</a>)<br><a target="_blank" href="http://scripts.sil.org/OFL">SIL Open Font License 1.1</a></p><h3> The Pastel SVG icon set <br></h3><p>Copyright (c) Michael Buckley (<a target="_blank" href="http://codefisher.org/pastel-svg/">codefisher.org/pastel-svg/</a>)<br>is licensed under the <a target="_blank" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Creative Commons Attribution NonCommercial Share Alike 4.0</a></p><h3>FamFamFam Silk Icons and Flag Icons<br></h3><p>Copyright (c) Mark James&nbsp;\r\n(<a target="_blank" href="http://www.famfamfam.com/lab/icons/silk/">www.famfamfam.com/lab/icons/silk/</a>\r\n)<br>is licensed under a&nbsp;\r\n<a target="_blank" href="http://creativecommons.org/licenses/by/2.5/">Creative Commons Attribution 2.5 License</a>.\r\n<br></p>', '10', '', 'de'),
( '114','2', 'Ansicht des Ordners', '<p>Der Ordner kann entweder eine Übersicht über die in ihm enthaltenen Seiten und Ordner anzeigen, oder auf die erste Seite des Ordners springen. Letzteres ist obsolet, wenn keine Seiten in diesem Ordner sind.<br></p>', '760', 'pages.type', 'de'),
( '115','16', 'Neue Tabelle', '<p>Definieren Sie die Datenfelder Ihrer Tabelle gemäß den MySQL-Vorgaben. Zu Beginn haben Sie die Definition für einen typischen Primary-Key, der den Zugriff auf einzelne Datensätze erleichtert, sowie ein einfaches Textfeld.</p><p>Sie können beliebig viele Datenfelder hinzufügen.</p><p>Mit "Tabelle erstellen" erhalten Sie das SQL-Statement für die Erstellung der Tabelle, das bei Bedarf ergänzt oder korrigiert werden kann. Nach Ausführung des Statements ist die Tabelle erstellt.<br></p>', '0', 'tables.new_table', 'de'),
('116','2', 'Dateiname', '<p>Hier wird der Name der Datei angezeigt, der bei erster Speicherung aus dem Titel gebildet wird. Soll der Dateiname neu erstellt werden, klicken Sie auf "Jetzt aktualisieren". Beachten Sie jedoch in diesem Zusammenhang, dass <span style="font-weight: bold;">sämtliche Links</span> sowohl auf der eigenen Seite als auch auf fremden Seiten sowie in Suchmaschinen aufgrund eines geänderten Dateinamens <span style="font-weight: bold;">nicht mehr funktionieren werden</span>.</p><p>Diese Funktion ist vor allem im Rahmen des Erstellungsprozesses gedacht, falls der Titel fehlerhaft war oder aus anderen Gründen geändert wurde.<br></p>', '930', 'pages.file', 'de'),
('117', '9', 'Content Filter', '<p>Mit dem Content Filter wird die Liste nach Content-Typen gefiltert. Dadurch ergeben sich Anpassungen in der Darstellung als auch im Funktionsumfang von "Setze Eigenschaften". Dies betrifft allem voran das Verschieben der ausgewählten Seiten in andere Ordner. Analog dazu das Verschieben von Artikel in andere Rubriken oder von Produkten in andere Warengruppen.<br></p>', '720', 'pages.c_filter', 'de');


CREATE TABLE `html_groups` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `group` bigint(20) NOT NULL DEFAULT '1',
  `description` text,
  `sort` bigint(20) NOT NULL DEFAULT '10',
  `parentsort` bigint(20) DEFAULT NULL,
  `graduated` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `html_groups` ( `id`, `name`, `group`, `description`, `sort`, `parentsort`, `graduated`)
VALUES ( '1', 'ROOT', '0', '', '10', '1', ' ROOT'),
( '2', 'GUI', '1', 'GUI related templates and snippets', '10', '2', '— GUI'),
( '3', 'CMS', '1', 'CMS related templates and snippets', '10', '6', '— CMS'),
( '4', 'HEAD', '3', 'HEAD Section of  HTML templates', '10', '8', '—— HEAD'),
( '5', 'BODY', '3', 'BODY section of HTML templates', '30', '13', '—— BODY'),
( '6', 'SECTION', '3', 'snippets', '20', '9', '—— SECTION'),
( '7', 'PAGES', '6', 'snippets for pages', '10', '10', '——— PAGES'),
( '8', 'ARTICLES', '6', 'snippets for articles', '20', '11', '——— ARTICLES'),
( '9', 'HEAD', '2', 'head of GUI', '10', '3', '—— HEAD'),
( '10', 'SECTION', '2', 'Parts of GUI', '20', '4', '—— SECTION'),
( '11', 'ANNOUNCES', '6', 'Templates for Announces', '30', '12', '——— ANNOUNCES'),
( '12', 'SCRIPTS', '3', 'Script-section in HEAD', '0', '7', '—— SCRIPTS'),
( '13', 'SCRIPTS', '2', 'Scripts of GUI', '30', '5', '—— SCRIPTS'),
( '14', 'PLUGINS', '6', 'All templates of plugins', '40', '13', '——— PLUGINS');

CREATE TABLE `html_presets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `generation` tinyint(3) DEFAULT NULL,
  `main` tinyint(3) DEFAULT NULL,
  `key` varchar(64) NOT NULL,
  `code` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `html_presets` (`generation`, `main`, `key`, `code`)
VALUES ( '1', '2', 'cms_pages_body2', '<body>\r\n<div id="site" class="clrfx">\r\n\t&&&&HEADER&&&&\r\n\t\r\n<!--content area -->\r\n<div id="content_area" class="grid clrfx">\r\n<!--main col-->\r\n<main id="content" class="col w12 clrfx">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div>\r\n<!-- /content_area -->\r\n\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('1', '1', 'cms_pages_body1', '<body>\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n\r\n<!--content area -->\r\n<div id="content_area" class="col w12 stretch clrfx">\r\n<!--first col-->\r\n<aside id="left" class="col w3">\t\r\n\t&&&&SUBNAV&&&&\r\n\t&&&&ANNOUNCE_BOX&&&&\r\n</aside> <!-- /left -->\r\n\r\n<!--main col-->\r\n<main id="content" class="col w9">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('1', '1', 'cms_pages_body_start', '<body>\r\n\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n\r\n<!--content area -->\r\n<div id="content_area" class="col w12 stretch clrfx">\r\n\r\n<!--first col-->\r\n<aside id="left" class="col  w3">\t\r\n\t&&&&ALT_ANNOUNCE_BOX&&&&\r\n</aside> <!-- /first col -->\r\n\r\n<!--main col-->\r\n<main id="content" class="col   w9">\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('1', '1', 'cms_pages_body2', '<body>\r\n\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n\t\r\n<!--content area -->\r\n<div id="content_area" class="col w12 clrfx">\r\n<!--main col-->\r\n<main id="content">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('1', '1', 'cms_pages_header_line', '<!--header-->\r\n<header class="col w12 stretch clrfx">\r\n\t<div id="logo" class="col w3 m9">&&&&LOGO&&&&</div> <!-- logo -->\r\n\t<div id="top" class="col w9 alright m3 clrfx">\r\n\t\t&&&&LANG_SWITCH&&&&\r\n\t\t&&&&SEARCHBOX&&&&\r\n\t</div>\r\n<div class="col w9 stretch clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\r\n</header> <!-- /header -->\r\n'),
('1', '1', 'cms_pages_footer_big', '<!-- footer -->\r\n<footer class="col w12 clrfx">\r\n<div class="row">\r\n\t<div class="col w6">&&&&FOOTER_NAV&&&&</div>\r\n\t<div class="col w3 mcenter">&&&&SHARE_BUTTONS&&&&</div>\r\n\t<div class="col w3 mcenter">&&&&GENERATOR&&&&</div>\r\n</div>\r\n\t<div id="copyright" class="row col w12 clrfx">&copy; &&&&YEAR&&&& &&&&AUTHOR&&&&</div>\r\n</footer>\r\n<!-- /footer -->\r\n<!-- move to the top -->\r\n<div id="gototop" data-scroll="toggle:withHeader">\r\n<a href="#site" title="&&&&totop&&&&" data-smroll="700"><i class="fas fa-angle-up fa-3x" title="&&&&totop&&&&"></i></a>\r\n</div>\r\n'),
('1', '1', 'cms_pages_header_stack', '<!--header-->\r\n<header class="col stretch w12 clrfx">\r\n\t<div id="logo" class="col first w3 m9">&&&&LOGO&&&&</div> <!-- logo -->\r\n\t<div id="top" class="col alright w9 m3">\r\n\t\t&&&&LANG_SWITCH&&&&\r\n\t\t&&&&SEARCHBOX&&&&\r\n\t</div>\r\n<div class="col w12 stretch clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\t\r\n</header> <!-- /header -->\r\n'),
('1', '2', 'cms_pages_body1', '<body>\r\n<div id="site" class="clrfx">\r\n\t&&&&HEADER&&&&\r\n\r\n<!--content area -->\r\n<div id="content_area" class="grid clrfx">\r\n<!--first col-->\r\n<aside id="left" class="col w3">\t\r\n\t&&&&SUBNAV&&&&\r\n\t&&&&ANNOUNCE_BOX&&&&\r\n</aside> <!-- /left -->\r\n\r\n<!--main col-->\r\n<main id="content" class="col w9">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('1', '2', 'cms_pages_body_start', '<body>\r\n<div id="site" class="clrfx">\r\n\t&&&&HEADER&&&&\r\n\r\n<!--content area -->\r\n<div id="content_area" class="grid clrfx">\r\n\r\n<aside id="left" class="col w3 clrfx">\r\n\t&&&&ALT_ANNOUNCE_BOX&&&&\r\n</aside>\r\n\r\n<!--main col-->\r\n<main id="content" class="col w9 clrfx">\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n\r\n</div>\r\n<!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('1', '2', 'cms_pages_body2', '<body>\r\n<div id="site" class="clrfx">\r\n\t&&&&HEADER&&&&\r\n\t\r\n<!--content area -->\r\n<div id="content_area" class="grid clrfx">\r\n<!--main col-->\r\n<main id="content" class="col w12 clrfx">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div>\r\n<!-- /content_area -->\r\n\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('1', '2', 'cms_pages_header_line', '<!--header-->\r\n<header class="clrfx">\r\n<div class="grid clrfx">\r\n\t<div id="logo" class="col first w3 m9">\r\n\t&&&&LOGO&&&&\r\n\t</div> <!-- logo -->\r\n\t<div id="top" class="col last alright w9 m3">\r\n\t\t&&&&LANG_SWITCH&&&&\r\n\t\t&&&&SEARCHBOX&&&&\r\n\t</div>\r\n<div class="col w9 stretch clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\r\n</header> <!-- /header -->\r\n'),
('2', '1', 'cms_pages_body1', '<body id="l-inside">\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n<!--content area -->\r\n<div id="content_area" class="col w12 stretch clrfx">\r\n<!--first col-->\r\n<aside id="left" class="col w3">\t\r\n\t&&&&SUBNAV&&&&\r\n\t&&&&ANNOUNCE_BOX&&&&\r\n</aside> <!-- /left -->\r\n\r\n<!--main col-->\r\n<main id="content" class="col w9">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('2', '1', 'cms_pages_body2', '<body id="l-inside">\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n\t\r\n<!--content area -->\r\n<div id="content_area" class="col w12 stretch clrfx">\r\n<!--main col-->\r\n<main id="content" class="col w12 clrfx">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div>\r\n<!-- /content_area -->\r\n\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('2', '1', 'cms_pages_body_start', '<body id="l-inside">\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n\t\r\n<!--content area -->\r\n<div id="content_area" class="col w12 stretch clrfx">\r\n<!--main-->\r\n<main id="content" class="col w12 clrfx">\r\n\t&&&&CAROUSEL&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div>\r\n<!-- /content_area -->\r\n\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('2', '1', 'cms_pages_header_stack', '<!--header-->\r\n<header class="col w12 stretch clrfx">\r\n\t<div id="logo" class="col w3 m6">&&&&LOGO&&&&</div> <!-- logo -->\r\n\t<div id="top" class="col alright w9 m6">\r\n\t\t&&&&LANG_SWITCH&&&&\r\n\t\t&&&&SEARCHBOX&&&&\r\n\t\t&&&&BASKET&&&&\t\r\n\t\t<a id="burger" href="#" class="show-mobile-in yo-btn"><i class="fas fa-bars fa-2x"></i></a>\r\n\t</div>\r\n<div class="col w12 stretch clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\t\r\n</header> <!-- /header -->\r\n'),
('2', '1', 'cms_pages_footer_big', '<!-- footer -->\r\n<footer class="col w12 clrfx">\r\n<div class="row">\r\n\t<div class="col w3">&&&&FOOTER_NAV&&&&</div>\r\n\t<div class="col w3">&&&&FOOTER_INFO&&&&</div>\r\n\t<div class="col w3 mcenter">&&&&SHARE_BUTTONS&&&&</div>\r\n\t<div class="col w3 mcenter">&&&&GENERATOR&&&&</div>\r\n</div>\r\n\t<div id="copyright" class="row col w12 clrfx">&copy; &&&&YEAR&&&& &&&&AUTHOR&&&&</div>\r\n</footer>\r\n<!-- /footer -->\r\n<!-- move to the top -->\r\n<div id="gototop" data-scroll="toggle:withHeader">\r\n<a href="#site" title="&&&&totop&&&&" data-smroll="700"><i class="fas fa-angle-up fa-3x"></i></a>\r\n</div>\r\n&&&&COWA&&&&\r\n<!-- footer -->'),
('2', '2', 'cms_pages_footer_big', '<!-- footer -->\r\n<footer class="clrfx">\r\n<div class="grid">\r\n<div class="col w12 stretch row">\r\n\t<div class="col w3">&&&&FOOTER_NAV&&&&</div>\r\n\t<div class="col w3">&&&&FOOTER_INFO&&&&</div>\r\n\t<div class="col w3 mcenter">&&&&SHARE_BUTTONS&&&&</div>\r\n\t<div class="col w3 mcenter">&&&&GENERATOR&&&&</div>\r\n</div>\r\n\t<div id="copyright" class="row col w12 clrfx">&copy; &&&&YEAR&&&& &&&&AUTHOR&&&&</div>\r\n</div>\r\n</footer>\r\n<!-- /footer -->\r\n<!-- move to the top -->\r\n<div id="gototop" data-scroll="toggle:withHeader">\r\n<a href="#site" title="&&&&totop&&&&" data-smroll="700"><i class="fas fa-angle-up fa-3x"></i></a>\r\n</div>\r\n&&&&COWA&&&&\r\n'),
('2', '2', 'cms_pages_header_line', '<!--header-->\r\n<header class="clrfx">\r\n<div class="grid clrfx">\r\n\t<div id="logo" class="col first w3 m6">&&&&LOGO&&&&</div> <!-- logo -->\r\n\t<div id="top" class="col alright w9 m6">\r\n\t\t&&&&LANG_SWITCH&&&&\r\n\t\t&&&&SEARCHBOX&&&&\r\n\t\t&&&&BASKET&&&&\r\n\t\t<a id="burger" href="#" class="show-mobile-in yo-btn"><i class="fas fa-bars fa-2x"></i></a>\r\n\t</div>\r\n<div class="col w9 clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\r\n</div>\r\n</header> <!-- /header -->'),
('2', '2', 'cms_pages_body2', '<body id="l-outside">\r\n<div id="site" class="clrfx">\r\n\t&&&&HEADER&&&&\r\n\t\r\n<!--content area -->\r\n<div id="content_area" class="grid clrfx">\r\n<!--main col-->\r\n<main id="content" class="col w12 clrfx">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div>\r\n<!-- /content_area -->\r\n\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('2', '2', 'cms_pages_body1', '<body id="l-outside">\r\n<div id="site" class="clrfx">\r\n\t&&&&HEADER&&&&\r\n\r\n<!--content area -->\r\n<div id="content_area" class="grid clrfx">\r\n<!--first col-->\r\n<aside id="left" class="col w3 first">\t\r\n\t&&&&SUBNAV&&&&\r\n\t&&&&ANNOUNCE_BOX&&&&\r\n</aside> <!-- /left -->\r\n\r\n<!--main col-->\r\n<main id="content" class="col w9 first">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('2', '2', 'cms_pages_body_start', '<body id="l-outside">\r\n<div id="site" class="clrfx">\r\n\t&&&&HEADER&&&&\r\n\t&&&&CAROUSEL&&&&\r\n<!--content area -->\r\n<div id="content_area" class="grid clrfx">\r\n<!--main col-->\r\n<main id="content" class="col w12 stretch clrfx">\r\n\t&&&&MYCONTENT&&&&\r\n\t&&&&WEBSHOP_PROMOTION&&&&\r\n</main> <!-- /content -->\r\n\r\n</div>\r\n<!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>'),
('2', '1', 'cms_pages_footer_small', '<!-- footer -->\r\n<footer class="col w12 clrfx">\r\n\t<div class="col w4">&copy; &&&&YEAR&&&& &&&&AUTHOR&&&&</div>\r\n\t<div class="col w4 mcenter">&&&&SHARE_BUTTONS&&&&</div>\r\n\t<div class="col w4 mcenter">&&&&SMALL_GENERATOR&&&&</div>\r\n</footer>\r\n<!-- /footer -->\r\n<!-- move to the top -->\r\n<div id="gototop" data-scroll="toggle:withHeader">\r\n<a href="#site" title="&&&&totop&&&&" data-smroll="700"><i class="fas fa-angle-up fa-3x"></i></a>\r\n</div>\r\n&&&&COWA&&&&\r\n<!-- footer -->'),
('2', NULL, 'cms_pages_searchbox', '<div id="searcharea" class="hide-mobile">\r\n<form action="/content/" method="get" enctype="application/x-www-form-urlencoded">\r\n\t<input type="hidden" name="lang" value="de" />\r\n\t<input type="hidden" name="_id" value="search" />\r\n\t<input type="hidden" name="_s" value="fulltext" />\t\r\n\t<label for="sf" class="hidden">Suche</label>\r\n\t<input id="sf" type="text" name="_w" size="17" maxlength="25" value="" class="search" placeholder="Suche" /><i class="fas fa-search fa-lg" data-app="yo-submit"></i>\r\n</form>\r\n</div>\r\n<span id="msearch" class="show-mobile-in"><a href="/content/?_id=search"><i class="fas fa-search fa-2x"></i></a></span>\t\t\r\n\t\t'),
('1', '2', 'cms_pages_header_stack', '<!--header-->\r\n<header class="clrfx">\r\n<div class="grid clrfx">\r\n\t<div id="logo" class="col first w3 m9">\r\n\t&&&&LOGO&&&&\r\n\t</div> <!-- logo -->\r\n\t<div id="top" class="col last alright w9 m3">\r\n\t\t&&&&LANG_SWITCH&&&&\r\n\t\t&&&&SEARCHBOX&&&&\r\n\t</div>\r\n<div class="col w12 stretch clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\r\n</header> <!-- /header -->\r\n'),
('2', '2', 'cms_pages_footer_small', '<footer class="clrfx">\r\n<div class="grid">\r\n<div class="col w12 stretch row">\r\n\t<div class="col w4">&copy; &&&&YEAR&&&& &&&&AUTHOR&&&&</div>\r\n\t<div class="col w4 mcenter">&&&&SHARE_BUTTONS&&&&</div>\r\n\t<div class="col w4 mcenter">&&&&SMALL_GENERATOR&&&&</div>\r\n</div>\r\n</div>\r\n</footer>\r\n<!-- /footer -->\r\n<!-- move to the top -->\r\n<div id="gototop" data-scroll="toggle:withHeader">\r\n<a href="#site" title="&&&&totop&&&&" data-smroll="700"><i class="fas fa-angle-up fa-3x"></i></a>\r\n</div>\r\n&&&&COWA&&&&'),
('2', NULL, 'cms_navbar', '<!-- start NAVBAR -->\n\t<h2 class="hidden">&&&&hidden_name&&&&</h2>\n\t<ul id="menue" class="yo-bar hide-mobile">\n&&&&content&&&&\n\t</ul>\n<!-- end NAVBAR -->'),
('2', NULL, 'cms_navbar_item', '\t<li class="nav&&&&id&&&& yo-bar-item"><a href="&&&&file&&&&" class="yo-dropdown-item" id="li&&&&count&&&&">&&&&short&&&&</a>&&&&sub&&&&</li>\n'),
('2', NULL, 'cms_navbar2', '\t\t<ul id="drop&&&&count&&&&" class="yo-dropdown-content yo-an-fade">\n&&&&sub&&&&\n\t\t</ul>\n'),
('2', NULL, 'cms_head', '<!DOCTYPE html>\r\n<html lang="&&&&LANG&&&&">\r\n<head>\r\n\t<meta charset="&&&&CHARSET&&&&" />\r\n\t<meta name="Generator" content="Consentio &&&&VERSION&&&& https://www.consentio.at" />\r\n\t<meta name="Description" content="&&&&DESCRIPTION&&&&" />\r\n\t<meta name="Keywords" content="&&&&KEYWORDS&&&&" />\r\n\t<meta name= "Author" content="&&&&AUTHOR&&&&" />\r\n\t<meta property="og:title" content="&&&&TITLE&&&&" />\r\n\t<meta property="og:url" content="&&&&URL&&&&" />\r\n\t<meta property="og:type" content="website" />\r\n\t<meta property="og:description" content="&&&&DESCRIPTION&&&&" />\r\n\t<meta property="og:image" content="&&&&ogIMAGE&&&&" />\r\n\t<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=4" />\r\n\t<link rel="stylesheet" type="text/css" href="/css/yolololo.min.css" />\r\n\t<link rel="stylesheet" type="text/css" href="/css/themes/&&&&CSS&&&&" />\r\n\t<link href="/css/forkawesome-all.min.css" rel="stylesheet">\r\n\t<link href="/favicon.png" rel="shortcut icon" />\r\n\t<link href="/touch.png" rel="apple-touch-icon" />\r\n\t<title>&&&&TITLE&&&&</title>\r\n&&&&SCRIPT&&&&\r\n</head>\r\n'),
('2', NULL, 'cms_pages_lightbox', '<script>$(document).ready(function(){$("[data-app=\'lightbox\']").yoBox({previous:\'&&&&p&&&&\',next:\'&&&&n&&&&\',close:\'&&&&c&&&&\'})});</script>\n'),
('2', NULL, 'cms_scripts', '<script src=\'/js/jQuery.js\'></script>\n<script src="/js/frontend.min.js"></script>\n<script src="/js/shared.min.js"></script>\n<script>$(document).ready(function(){$(\'body\').easyAdmin({\'script\': \'&&&&ajax&&&&\'})});</script>\n&&&&scripts&&&&'),
('2', NULL, 'cms_navbar_item2', '\t\t<li><a href="&&&&file&&&&">&&&&short&&&&</a></li>\n\t\t'),
('2', '2', 'cms_pages_header_stack', '<!--header-->\r\n<header class="clrfx">\r\n<div class="grid clrfx">\r\n\t<div id="logo" class="col first w3 m7">&&&&LOGO&&&&</div> <!-- logo -->\r\n\t<div id="top" class="col alright w9 m5">\r\n\t\t&&&&LANG_SWITCH&&&&\r\n\t\t&&&&SEARCHBOX&&&&\r\n\t\t&&&&BASKET&&&&\t\r\n\t\t<a id="burger" href="#" class="show-mobile-in yo-btn"><i class="fas fa-bars fa-2x"></i></a>\r\n\t</div>\r\n<div class="col w12 stretch clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\r\n</div>\r\n</header> <!-- /header -->'),
('2', '1', 'cms_pages_header_slim', '<!--header-->\r\n<header class="clrfx">\r\n<div class="grid clrfx">\r\n\t<div id="logo" class="col w2 m7">&&&&LOGO&&&&</div> <!-- logo -->\r\n\t<div id="top" class="col alright w10 m5">\r\n\t\t&&&&LANG_SWITCH&&&&\t\t\r\n\t\t&&&&BASKET&&&&\r\n\t\t<a href="/content/?_id=search" id="msearch" class="show-mobile-in yo-btn"><i class="fas fa-search fa-2x"></i></a>\r\n\t\t<a id="burger" href="#" class="show-mobile-in yo-btn"><i class="fas fa-bars fa-2x"></i></a>\r\n\t</div>\r\n<div class="col w9 clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\r\n<div class="col w1 clrfx">\r\n<a href="/content/?_id=search" id="msearch" class="hide-mobile yo-btn yo-right"><i class="fas fa-search fa-2x"></i></a>\r\n</div>\r\n</div>\r\n</header> <!-- /header -->'),
('2', '1', 'cms_pages_header_line', '<!--header-->\r\n<header class="clrfx">\r\n<div class="grid clrfx">\r\n\t<div id="logo" class="col w3 m6">&&&&LOGO&&&&</div> <!-- logo -->\r\n\t<div id="top" class="col alright w9 m6">\r\n\t\t&&&&LANG_SWITCH&&&&\r\n\t\t&&&&SEARCHBOX&&&&\r\n\t\t&&&&BASKET&&&&\t\r\n\t\t<a id="burger" href="#" class="show-mobile-in yo-btn"><i class="fas fa-bars fa-2x"></i></a>\r\n\t</div>\r\n<div class="col w9 clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\r\n</div>\r\n</header> <!-- /header -->'),
('2', '2', 'cms_pages_header_slim', '<!--header-->\r\n<header class="clrfx">\r\n<div class="grid clrfx">\r\n\t<div id="logo" class="col first w2 m7">&&&&LOGO&&&&</div> <!-- logo -->\r\n\t<div id="top" class="col alright w10 m5">\r\n\t\t&&&&LANG_SWITCH&&&&\t\t\r\n\t\t&&&&BASKET&&&&\r\n\t\t<a href="/content/?_id=search" id="msearch" class="show-mobile-in yo-btn"><i class="fas fa-search fa-2x"></i></a>\r\n\t\t<a id="burger" href="#" class="show-mobile-in yo-btn"><i class="fas fa-bars fa-2x"></i></a>\r\n\t</div>\r\n<div class="col w9 clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\r\n<div class="col w1 clrfx">\r\n<a href="/content/?_id=search" id="msearch" class="hide-mobile yo-btn yo-right"><i class="fas fa-search fa-2x"></i></a>\r\n</div>\r\n</div>\r\n</header> <!-- /header -->');


CREATE TABLE `html_snippets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `key` varchar(64) NOT NULL,
  `code` text NOT NULL,
  `group` int(11) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `html_snippets` (`key`, `code`, `group`, `description`) VALUES
('gui_main_1', '<body>\n<div id="site" class="grid clrfx">\n&&&&header&&&&\n<div id="content" class="clrfx">\n<aside class="col w3">\n\t&&&&formtitle&&&&\n\t&&&&left&&&&\n</aside>\n<main class="col w9 rel">\n\t<div id="togleft" class="hide-mobile"><i class="fa fa-chevron-left fa-fw grey yo-btn" title="&&&&i18n_toggle&&&&" data-app="toggleLeft"></i></div>\n\t&&&&content&&&&\n</main>\n</div>\n<footer class="col w12 clrfx">\n<div class="foot">\n&&&&footer&&&&\n</div>\n&&&&bubbles&&&&\n</footer>\n</div> <!-- site -->\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\n</body>\n</html>', '2', 'GUI template with header, aside and footer'),
('gui_header_1', '<header class="grid clrfx">\n<div id="logo" class="col w2 m6 first">\n\t<h1><img src="/graphics/consentio.svg" width="155" height="35" title="&&&&title&&&&" /></h1>\n</div>\n\n<div class="col w10 m6 last">\n\t<div id="top_bar" class="clrfx">\n\t\t<div class="col w6 m4">\n\t\t\t&&&&homepage_info&&&&\n\t\t</div>\n\t\t<div class="col w3 m4">\n\t\t\t&&&&mess_icon&&&&\n\t\t\t&&&&help_icon&&&&\n\t\t</div>\n\t\t<div class="col w3 m4 right">\n\t\t\t&&&&user_display&&&&\n\t\t\t&&&&logout&&&&\n\t\t</div>\n\t</div>\n</div>\n<nav class="cols w12 clrfx">&&&&navigation&&&&</nav>\n</header>', '10', 'GUI header'),
('gui_main_2', '<body>\r\n<div id="site" class="grid clrfx">\r\n&&&&header&&&&\r\n<div id="content" class="clrfx">\r\n<main class="col w12">\r\n\t&&&&formtitle&&&&\r\n\t&&&&content&&&&\r\n</main>\r\n</div>\r\n<footer class="col w12 clrfx">\r\n<div class="foot">\r\n&&&&footer&&&&\r\n</div>\r\n&&&&bubbles&&&&\r\n</footer>\r\n</div> <!-- site -->\r\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\r\n</body>\r\n</html>', '2', 'GUI Template with header without aside'),
('cms_pages_body1', '<body id="l-inside">\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n<!--content area -->\r\n<div id="content_area" class="col w12 stretch clrfx">\r\n<!--first col-->\r\n<aside id="left" class="col w3">\t\r\n\t&&&&SUBNAV&&&&\r\n\t&&&&ANNOUNCE_BOX&&&&\r\n</aside> <!-- /left -->\r\n\r\n<!--main col-->\r\n<main id="content" class="col w9">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div> <!-- /content_area -->\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>', '5', 'Body for default template'),
('gui_main_3', '<body id="single">\n<div id="site" class="grid clrfx">\n<main>\n\t&&&&formtitle&&&&\n\t&&&&content&&&&\n\t&&&&bubbles&&&&\n</main>\n</div> <!-- site -->\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\n</body>\n</html>', '2', 'GUI template for popup and iframe'),
('cms_container_item', '<li><a href="&&&&link&&&&">&&&&text&&&&</a></li>', '11', 'A list item of containers'),
('gui_formtitle', '<h2 class=\'formtitle\'>&&&&formtitle&&&&</h2>', '10', 'the title tag of form (content-part)'),
('gui_formtitle2', '<h2>&&&&formtitle&&&&</h2>', '10', 'the title tag of form (content-part gui 2)'),
('gui_main_4', '<body id="single">\r\n<div id="site" class="grid clrfx">\r\n\r\n<aside class="col w3">\r\n\t&&&&formtitle&&&&\r\n\t&&&&left&&&&\r\n</aside>\r\n<main class="col w9">\r\n\t&&&&content&&&&\r\n\t&&&&bubbles&&&&\r\n</main>\r\n</div> <!-- site -->\r\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\r\n</body>\r\n</html>', '2', 'GUI with ASIDE without HEADER'),
('gui_head', '<!DOCTYPE html>\n<html lang="&&&&lang&&&&">\n<head>\n<title>&&&&headtitle&&&&</title>\n<meta http-equiv="content-type" content="text/html; charset=utf-8" />\n<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=4">\n<link rel="icon" href="/graphics/favicon.svg">\n<link rel="apple-touch-icon-precomposed" href="/graphics/touch.png">\n<link rel="stylesheet" href="/css/yolololo.min.css" type="text/css" />\n<link rel="stylesheet" href="/css/gui/&&&&CSS&&&&.css" type="text/css" />\n<link href="/css/forkawesome-all.min.css" rel="stylesheet">\n<script src=\'/js/jQuery.js\'></script>\n<script src=\'/js/backend.js\'></script>\n<script src=\'/js/shared.js\'></script>\n&&&&scripts&&&&\n</head>\n', '9', 'the head section'),
('cms_container_list', '<ul>&&&&content&&&&</ul>\r\n', '11', 'Unordered List of containers'),
('cms_announces_box1', '<div class=\'announcebox\' id=\'&&&&id&&&&\'>\r\n&&&&title&&&&\r\n<div class=\'innerbox\'>\r\n&&&&content&&&&\r\n<!-- A=announces ID=&&&&id&&&& -->\r\n</div>\r\n</div>\r\n\r\n', '11', 'Default Announcebox'),
('cms_announces_title1', '<h2>&&&&title&&&&</h2>', '11', 'Default Announces Title'),
('cms_announces_img1', '<div class=\'center\'>\r\n<img src=\'&&&&src&&&&\' width=\'&&&&width&&&&\' height=\'&&&&height&&&&\' alt=\'&&&&alternative&&&&\' />\r\n</div>', '11', 'Default Announces Image'),
('cms_pages_title', '<h1>&&&&title&&&&</h1>\r\n', '7', 'H1 of page'),
('cms_scripts', '<script src=\'/js/jQuery.js\'></script>\n<script src="/js/frontend.min.js"></script>\n<script src="/js/shared.min.js"></script>\n<script>$(document).ready(function(){$(\'body\').easyAdmin({\'script\': \'&&&&ajax&&&&\'})});</script>\n&&&&scripts&&&&', '12', 'Standard Scripts in HEAD'),
('cms_head', '<!DOCTYPE html>\r\n<html lang="&&&&LANG&&&&">\r\n<head>\r\n\t<meta charset="&&&&CHARSET&&&&" />\r\n\t<meta name="Generator" content="Consentio &&&&VERSION&&&& https://www.consentio.at" />\r\n\t<meta name="Description" content="&&&&DESCRIPTION&&&&" />\r\n\t<meta name="Keywords" content="&&&&KEYWORDS&&&&" />\r\n\t<meta name= "Author" content="&&&&AUTHOR&&&&" />\r\n\t<meta property="og:title" content="&&&&TITLE&&&&" />\r\n\t<meta property="og:url" content="&&&&URL&&&&" />\r\n\t<meta property="og:type" content="website" />\r\n\t<meta property="og:description" content="&&&&DESCRIPTION&&&&" />\r\n\t<meta property="og:image" content="&&&&ogIMAGE&&&&" />\r\n\t<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=4" />\r\n\t<link rel="stylesheet" type="text/css" href="/css/yolololo.min.css" />\r\n\t<link rel="stylesheet" type="text/css" href="/css/themes/&&&&CSS&&&&" />\r\n\t<link href="/css/forkawesome-all.min.css" rel="stylesheet">\r\n\t<link href="/favicon.png" rel="shortcut icon" />\r\n\t<link href="/touch.png" rel="apple-touch-icon" />\r\n\t<title>&&&&TITLE&&&&</title>\r\n&&&&SCRIPT&&&&\r\n</head>\r\n', '7', 'Header of templates'),
( 'cms_pages_header', '<!--header-->\r\n<header class="clrfx">\r\n<div class="grid clrfx">\r\n\t<div id="logo" class="col w3 m6">&&&&LOGO&&&&</div> <!-- logo -->\r\n\t<div id="top" class="col alright w9 m6">\r\n\t\t&&&&LANG_SWITCH&&&&\r\n\t\t&&&&SEARCHBOX&&&&\r\n\t\t&&&&BASKET&&&&\t\r\n\t\t<a id="burger" href="#" class="show-mobile-in yo-btn"><i class="fas fa-bars fa-2x"></i></a>\r\n\t</div>\r\n<div class="col w9 clrfx">\r\n<nav class="clrfx">\r\n\t&&&&NAVBAR&&&&\r\n</nav> <!-- /navbar -->\r\n</div>\r\n</div>\r\n</header> <!-- /header -->', '7', 'Header of templates'),
('cms_pages_footer', '<!-- footer -->\r\n<footer class="col w12 clrfx">\r\n<div class="row">\r\n\t<div class="col w3">&&&&FOOTER_NAV&&&&</div>\r\n\t<div class="col w3">&&&&FOOTER_INFO&&&&</div>\r\n\t<div class="col w3 mcenter">&&&&SHARE_BUTTONS&&&&</div>\r\n\t<div class="col w3 mcenter">&&&&GENERATOR&&&&</div>\r\n</div>\r\n\t<div id="copyright" class="row col w12 clrfx">&copy; &&&&YEAR&&&& &&&&AUTHOR&&&&</div>\r\n</footer>\r\n<!-- /footer -->\r\n<!-- move to the top -->\r\n<div id="gototop" data-scroll="toggle:withHeader">\r\n<a href="#site" title="&&&&totop&&&&" data-smroll="700"><i class="fas fa-angle-up fa-3x"></i></a>\r\n</div>\r\n&&&&COWA&&&&\r\n<!-- footer -->', '7', 'Footer of templates'),
('cms_breadcrumb', '<!-- BREADCRUMB -->\r\n<div id=\'breadcrumb\'>&&&&prolog&&&& &&&&content&&&&</div>\r\n<!-- /BREADCRUMB -->\r\n', '7', 'breadcrumb navigation'),
('cms_navbar_item', '\t<li class="nav&&&&id&&&& yo-bar-item"><a href="&&&&file&&&&" class="yo-dropdown-item" id="li&&&&count&&&&">&&&&short&&&&</a>&&&&sub&&&&</li>\n', '7', 'List item of navbar'),
('cms_navbar', '<!-- start NAVBAR -->\n\t<h2 class="hidden">&&&&hidden_name&&&&</h2>\n\t<ul id="menue" class="yo-bar hide-mobile">\n&&&&content&&&&\n\t</ul>\n<!-- end NAVBAR -->', '7', 'the navbar as list'),
('cms_navbar2', '\t\t<ul id="drop&&&&count&&&&" class="yo-dropdown-content yo-an-fade">\n&&&&sub&&&&\n\t\t</ul>\n', '7', 'sublist of navbar'),
('cms_navbar_item2', '\t\t<li><a href="&&&&file&&&&">&&&&short&&&&</a></li>\n\t\t', '7', 'list item of navbar sub'),
('cms_breadcrumb_item', ' <a href="&&&&file&&&&">&&&&short&&&&</a> &rarr;', '7', 'one item of breadcrumb'),
('cms_subnav', '<div class=\'announcebox\' id=\'&&&&id&&&&\'>\r\n\t<h2>&&&&title&&&&</h2>\r\n\t<div class=\'innerbox\'>\r\n&&&&content&&&&\r\n\t</div>\r\n</div>', '7', 'Box of sub navigation'),
('cms_folder_listitem', '<li>\r\n<h2><a href="&&&&file&&&&">&&&&title&&&&</a></h2>\r\n&&&&content&&&&\r\n</li>\r\n', '7', 'list item of the folder listing'),
('cms_more', '&nbsp;<a href="&&&&file&&&&" class="more">&&&&more&&&& <span class="hidden">&&&&short&&&&</span></a>', '7', 'link for more content'),
('cms_announces_more', '<p class="alright"><a href="&&&&link&&&&" class="more">&&&&more&&&&</a></p>', '11', 'more-link of announces'),
('codemirror_script', '<script src="&&&&path&&&&/lib/codemirror.js"></script>\r\n<link rel="stylesheet" href="&&&&path&&&&/lib/codemirror.css">\r\n<script src="&&&&path&&&&/addon/searchcursor.js"></script>\r\n<script src="&&&&path&&&&/addon/search.js"></script>\r\n<script src="&&&&path&&&&/addon/matchbrackets.js"></script>\r\n', '13', 'scripts of codemirror'),
('codemirror_inlinescript', '<script language=\'javascript\' type=\'text/javascript\'>\r\n\tvar myCodeMirror = CodeMirror.fromTextArea(document.getElementById(\'&&&&id&&&&\'), {\r\n\t\tlineNumbers: true,\r\n\t\tviewportMargin: Infinity,\r\n\t\tmode: \'&&&&syntax&&&&\',\r\n\t\tmatchBrackets: true,\r\n\t\tindentWithTabs: true,\r\n\t\tsmartIndent: false\r\n\t\t});\r\n</script>\r\n', '13', ''),
('codemirror_mode_javascript', '<script src="&&&&path&&&&/mode/javascript.js"></script>\r\n', '13', ''),
('codemirror_mode_perl', '<script src="&&&&path&&&&/mode/perl.js"></script>\r\n', '13', ''),
('codemirror_mode_css', '<script src="&&&&path&&&&/mode/css.js"></script>\r\n', '13', ''),
('codemirror_mode_sql', '<script src="&&&&path&&&&/mode/sql.js"></script>', '13', ''),
('codemirror_mode_php', '<script src="&&&&path&&&&/mode/php.js"></script>\r\n<script src="&&&&path&&&&/mode/clike.js"></script>\r\n', '13', ''),
('codemirror_mode_text/html', '<script src="&&&&path&&&&/mode/xml.js"></script>\r\n<script src="&&&&path&&&&/mode/javascript.js"></script>\r\n<script src="&&&&path&&&&/mode/css.js"></script>\r\n<script src="&&&&path&&&&/mode/htmlmixed.js"></script>\r\n', '13', ''),
('cms_pages_body_start', '<body id="l-inside">\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n\t\r\n<!--content area -->\r\n<div id="content_area" class="col w12 stretch clrfx">\r\n<!--main-->\r\n<main id="content" class="col w12 clrfx">\r\n\t&&&&CAROUSEL&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div>\r\n<!-- /content_area -->\r\n\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>', '5', 'Body template for Homepage'),
('cms_share_buttons', '<!-- Social Media Share Buttons -->\r\n<div class="innerbox clrfx">\r\n<a href="http://www.facebook.com/sharer/sharer.php?u=&&&&decURL&&&&" class="sb facebook" title="Facebook" target="_blank"><i class="fab fa-facebook-f"></i></a>\r\n<a href="http://twitter.com/home?status=&&&&decURL&&&&" class="sb twitter" title="Twitter" target="_blank"><i class="fab fa-twitter"></i></a>\r\n<a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=&&&&decURL&&&&" class="sb linkedin" title="LinkedIn" target="_blank"><i class="fab fa-linkedin"></i></a>\r\n<a href="http://www.xing.com/app/user?op=share;url=&&&&decURL&&&&" class="sb xing" title="Xing" target="_blank"><i class="fab fa-xing"></i></a>\r\n</div>\r\n<!-- /Social Media Share Buttons -->\r\n', '7', 'Simple Social Media Share Buttons'),
('cms_search_item', '<div class="&&&&class&&&&">\n\t<div class="rightfloat">&&&&score&&&&</div>\n\t<h3><a href="&&&&link&&&&" class="linkedtitle">&&&&title&&&&</a></h3>\n\t<p>&&&&body&&&&</p>\n\t<p class="small alright">&&&&update&&&&</p>\n</div>\n', '7', 'one row in public search'),
('cms_dynamic_html', '<?php\r\nrequire_once ("../inc.php");\r\n$bubbles = array();\r\n$db; $html; $website;\r\n&&&&defs&&&&\r\necho dynamic(\'&&&&id&&&&\');\r\n?>', '5', 'fake html for dynamic output'),
('cms_logo', '<h1><a href="&&&&homeref&&&&"><img src="/pictures/&&&&website_logo&&&&" width="&&&&width&&&&" height="&&&&height&&&&" alt="&&&&website_title&&&&" /></a></h1>', '7', 'logo of the website'),
('cms_pages_body2', '<body id="l-inside">\r\n<div id="site" class="grid clrfx">\r\n\t&&&&HEADER&&&&\r\n\t\r\n<!--content area -->\r\n<div id="content_area" class="col w12 stretch clrfx">\r\n<!--main col-->\r\n<main id="content" class="col w12 clrfx">\r\n\t&&&&BREADCRUMB&&&&\r\n\t&&&&MYCONTENT&&&&\r\n</main> <!-- /content -->\r\n</div>\r\n<!-- /content_area -->\r\n\r\n\t&&&&FOOTER&&&&\r\n</div> <!-- /site -->\r\n</body>\r\n<!-- &&&&TIMESTAMP&&&& -->\r\n</html>', '5', 'Second Default Body Template'),
('cms_pages_lead', '<p class="lead">&&&&description&&&&</p>\r\n', '7', 'lead of a folder'),
('cms_pages_searchbox', '<form action="/content/" method="get" enctype="application/x-www-form-urlencoded" class="hide-mobile">\r\n\t<input type="hidden" name="lang" value="de" />\r\n\t<input type="hidden" name="_id" value="search" />\r\n\t<input type="hidden" name="_s" value="fulltext" />\r\n\t<div id="searcharea">\r\n\t<label for="sf" class="hidden">&&&&label&&&&</label>\r\n\t<input id="sf" type="text" name="_w" size="17" value="" class="search" placeholder="&&&&label&&&&" /><i class="fas fa-search" data-app="yo-submit"></i>\r\n\t</div>\r\n</form>\r\n<span id="msearch" class="show-mobile-in"><a href="/content/?_id=search"><i class="fas fa-search fa-2x" title="&&&&label&&&&"></i></a></span>', '7', 'Template of Search Box'),
('css_authoring', '<script src=\'/js/jQcssAuth.js\' type=\'text/javascript\'></script>\r\n<script type=\'text/javascript\'>\r\n$(document).ready(function(){$(".cpicker").colorpicker()});\r\n</script>', '13', ''),
('gui_main_5', '<body>\r\n<div id="site" class="grid clrfx">\r\n&&&&header&&&&\r\n<div id="content" class="clrfx">\r\n<aside class="col w4">\r\n\t&&&&formtitle&&&&\r\n\t&&&&left&&&&\r\n</aside>\r\n<main class="col w8">\r\n\t&&&&content&&&&\r\n</main>\r\n</div>\r\n<footer class="col w12 clrfx">\r\n<div class="foot">\r\n&&&&footer&&&&\r\n</div>\r\n&&&&bubbles&&&&\r\n</footer>\r\n</div> <!-- site -->\r\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\r\n</body>\r\n</html>', '2', 'Overview with a bigger aside'),
('cms_pages_lightbox', '<script>$(document).ready(function(){$("[data-app=\'lightbox\']").yoBox({previous:\'&&&&p&&&&\',next:\'&&&&n&&&&\',close:\'&&&&c&&&&\'})});</script>\n', '12', 'Lightbox, Colorbox in this case'),
('cms_pages_lang_sel', '<div id="lswitch">&&&&content&&&&</div>', '7', 'Language Selection'),
('gui_footer_1', '<a href="http://www.consentio.at" target="_blank">Consentio</a> &&&&ver&&&& &copy; 1999 &ndash; &&&&year&&&& by IMB Webdevelopment (GPL 2.0)', '10', ''),
('gui_tree', '<ul id=\'tree\'>\n&&&&treelist&&&&\n</ul>', '13', ''),
('gui_info', '<div class=\'clrfx\'>\r\n<h3>&&&&title&&&&</h3>\r\n&&&&content&&&&\r\n</div>', '10', 'Info Area'),
('cms_head_print', '<!DOCTYPE html>\r\n<html lang="&&&&LANG&&&&">\r\n<head>\r\n\t<meta charset="&&&&CHARSET&&&&" />\r\n\t<meta name="Generator" content="Consentio &&&&VERSION&&&& http://www.consentio.at" />\r\n\t<meta name="Description" content="&&&&DESCRIPTION&&&&" />\r\n\t<meta name="Keywords" content="&&&&KEYWORDS&&&&" />\r\n\t<meta name= "Author" content="&&&&AUTHOR&&&&" />\r\n\t<link rel="stylesheet" type="text/css" href="/css/print.css" />\r\n\t<link href="/favicon.png" rel="shortcut icon" />\r\n\t<link href="/touch.png" rel="apple-touch-icon" />\r\n\t<title>&&&&TITLE&&&&</title>\r\n&&&&SCRIPT&&&&\r\n</head>', '4', 'Head of print version'),
('codemirror_fill', '<script type=\'text/javascript\'>\r\n(function($){\r\n\t$.fn.cmpicker = function(opt){\r\n\t\tvar defaults = { \r\n\t\t\tc: \'#FFFFFF\'\r\n\t\t};\r\n\t\topt = $.extend(defaults, opt);\r\n\t\tvar doc = myCodeMirror.getDoc();\r\n\t\tvar obj = $(this);\r\n\t\t$(\'li\', obj).each(function(){\r\n\t\t\tvar li = $(this);\r\n\t\t\tli.css(\'cursor\', \'pointer\');\r\n\t\t\tli.bind("click",function(){\r\n\t\t\t  var start = doc.getCursor(\'start\');\r\n\t\t\t  var end = doc.getCursor(\'end\');\r\n\t\t\t  var ins = "&&&&"+li.attr(\'data-val\')+"&&&&";\r\n\t\t\t  doc.replaceRange(ins, start, end);\r\n\t\t\t  });\r\n\t\t\t});\r\n\t\t}\r\n\t})(jQuery);\r\n$(document).ready(function(){$(\'#components_catalogue\').cmpicker();});\r\n</script>', '13', ''),
('cms_pages_body_empty', '<body>\r\n&&&&MYCONTENT&&&&\r\n</body>', '5', 'empty body (e. g. print-version)'),
('gui_sync_new_table_inputs', '<script>\r\n\t$(document).ready(function (){\r\n\t\t$("[data-app=\'switch_char_num\']").each(function(){\r\n\t\t\tswitch_inputs($(this));\r\n\t\t\t$(this).bind(\'change\', function(){switch_inputs($(this));});\r\n\t\t\t});\r\n\t\t});\r\n\t\t\r\n\t$(document).ready(function (){\r\n\t\t$("[data-app=\'switch_index\']").each(function(){\r\n\t\t\tswitch_ai($(this));\r\n\t\t\t$(this).bind(\'change\', function(){switch_ai($(this));});\r\n\t\t\t});\r\n\t\t});\r\n\t\t\r\n\tfunction switch_inputs(oInput) {\r\n\t\tvar oFieldset = oInput.closest(\'fieldset\');\r\n\t\tif ($.inArray(oInput.val(), ["CHAR", "VARCHAR", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT"]) != -1) {\r\n\t\t\t$("[data-enable=\'num\']", oFieldset).attr(\'disabled\', \'disabled\');\r\n\t\t\t$("[data-enable=\'char\']", oFieldset).removeAttr(\'disabled\');\r\n\t\t\t}\r\n\t\telse if ($.inArray(oInput.val(), ["TINYINT", "SMALLINT", "MEDIUMINT", "INT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL", "BIT"]) != -1) {\r\n\t\t\t$("[data-enable=\'char\']", oFieldset).attr(\'disabled\', \'disabled\');\r\n\t\t\t$("[data-enable=\'num\']", oFieldset).removeAttr(\'disabled\');\r\n\t\t\t}\r\n\t\telse {\r\n\t\t\t$("[data-enable=\'char\']", oFieldset).attr(\'disabled\', \'disabled\');\r\n\t\t\t$("[data-enable=\'num\']", oFieldset).attr(\'disabled\', \'disabled\');\r\n\t\t\t}\r\n\t\t}\r\n\t\r\n\tfunction switch_ai(oInput) {\r\n\t\tvar oFieldset = oInput.closest(\'fieldset\');\r\n\t\t$("[data-enable=\'index\']", oFieldset).removeAttr(\'disabled\');\r\n\t\tif ($.inArray(oInput.val(), [\'PRIMARY\',\'UNIQUE\',\'INDEX\', \'FULLTEXT\']) == -1) {\r\n\t\t\t$("[data-enable=\'index\']", oFieldset).attr(\'disabled\', \'disabled\');\r\n\t\t\t}\r\n\t\t}\r\n</script>', '13', 'Enables and disables input fields according to selections'),
('gui_add_tags', '<script>\n\t$(document).ready(function (){\n\t\t$("#i&&&&me&&&&").autocomplete(&&&&params&&&&)\n\t\t$(".tag", \'#collector_&&&&me&&&&\').each(function(){\n\t\t\tvar tag = $(this);\n\t\t\tvar del = $(\'<a>\').attr(\'href\', \'#&&&&me&&&&\');\n\t\t\tdel.click(function(){$(this).parent(\'.tag\').remove();});\n\t\t\tdel.append($(\'<i>\').attr({\'class\': \'fas fa-times-circle\', \'title\': \'del\', \'alt\': \'del\'}).css({\'margin-left\': \'8px\', \'cursor\': \'pointer\'}));\n\t\t\ttag.append(del);\n\t\t\tvar c =$(\'input\', $(\'#collector_&&&&me&&&&\')).length;\n\t\t\tvar id = tag.attr(\'data-id\');\n\t\t\tvar hidden = $(\'<input>\').attr({\'name\': \'real_&&&&me&&&&[\'+c+\']\', \'value\': id, \'type\': \'hidden\'});\n\t\t\ttag.append(hidden);\n\t\t\t});\n\t\t});\n\t\n\tfunction collectTags_&&&&me&&&&(li){\n\t\tvar val = $(\'#i&&&&me&&&&\').val();\n\t\tsetTag_&&&&me&&&&(val, li.data[0]);\n\t\t}\n\tfunction newTag_&&&&me&&&&(){\n\t\tvar val = $(\'#i&&&&me&&&&\').val();\n\t\tvar eKey = function(e) {\n\t\t\tif (e.keyCode == 9 || e.keyCode == 13) {\n\t\t\t\tvar val = $(\'#i&&&&me&&&&\').val();\n\t\t\t\tsetTag_&&&&me&&&&(val, val);\n\t\t\t\te.preventDefault();\n\t\t\t\treturn false;\n\t\t\t\t}\t\t\t\t\n\t\t\t};\n\t\tif ($(\'#add_&&&&me&&&&\').attr(\'id\') == undefined && val) {\n\t\t\tvar oImg = $(\'<i>\').attr({\'id\': \'add_&&&&me&&&&\', \'class\': \'fas fa-plus-circle fa-lg green\', \'title\': \'add\', \'alt\': \'add\'}).css({\'margin\': \'0px 10px\', \'cursor\': \'pointer\'});\n\t\t\toImg.click(function(){\n\t\t\t\tvar val = $(\'#i&&&&me&&&&\').val();\n\t\t\t\tsetTag_&&&&me&&&&(val, val);\n\t\t\t\t});\t\t\t\t\t\n\t\t\t$(\'#i&&&&me&&&&\').after(oImg);\n\t\t\t$(\'#i&&&&me&&&&\').one(\'keydown\', eKey);\n\t\t\t}\n\t\t}\n\tfunction setTag_&&&&me&&&&(str, id){\n\t\tvar tag = $(\'<span>\').addClass(\'tag\').append(str);\n\t\tif (str == id){tag.addClass(\'newTag\')}\n\t\tvar del = $(\'<a>\').attr(\'href\', \'#&&&&me&&&&\');\n\t\tdel.click(function(){$(this).parent(\'.tag\').remove();});\n\t\tdel.append($(\'<i>\').attr({\'class\': \'fas fa-times-circle\', \'title\': \'del\', \'alt\': \'del\'}).css({\'margin-left\': \'8px\', \'cursor\': \'pointer\'}));\n\t\ttag.append(del);\n\t\tvar c =$(\'input\', $(\'#collector_&&&&me&&&&\')).length;\n\t\tvar hidden = $(\'<input>\').attr({\'name\': \'real_&&&&me&&&&[\'+c+\']\', \'value\': id, \'type\': \'hidden\'});\n\t\ttag.append(hidden);\n\t\t$("#collector_&&&&me&&&&").append(tag);\n\t\t$(\'#i&&&&me&&&&\').val(\'\');\n\t\t$(\'#add_&&&&me&&&&\').remove();\n\t\t}\n</script>', '13', 'Script for adding tags in association with autocomplete'),
('gui_sort_script', '<div id="sort_message">&&&&move_info&&&&</div>\r\n&&&&table&&&&\r\n<script src="/js/jQtablednd.js"></script>\r\n<script>\r\n$("#sortnew").css({\'cursor\':\'pointer\'}).click(function(){\r\n\tvar val = 10;\r\n\t$(".sort").each(function(){$(this).val(val); val+=10;})\r\n\t$(\'#sort_message\').html(\'&&&&moved&&&&\');\r\n\t});\r\n$(".sort").change(function(){$(\'#btnSort\').addClass(\'red\'); $(\'#sort_message\').html(\'&&&&moved&&&&\');});\r\n$(".table").tableDnD({\r\nonDrop: function(table, row) {\r\n\tvar rows = table.tBodies[0].rows;\r\n\tvar count = 1;\r\n\tfor (var i=0; i<rows.length; i++) {\r\n\t\tif (rows[i].id === row.id) {\r\n\t\t\tvar next = parseInt($(".sort", rows[parseInt(i+1)]).val());\r\n\t\t\tif (parseInt(i+1) == rows.length) {next = parseInt(count + 10);}\r\n\t\t\tvar avg = parseInt(parseInt(next + count)/2);\r\n\t\t\t$(".sort", row).val(avg)\r\n\t\t\t};\r\n\t\tcount = parseInt($(".sort", rows[i]).val()) || count;\r\n\t\t}\r\n\t$(\'#sort_message\').html(\'&&&&moved&&&&\');\r\n\t$(\'#btnSort\').addClass(\'red\');\r\n},\r\nonDragStart: function(table, row) {$(\'#sort_message\').html(\'&&&&move&&&&\');}\r\n});\r\n</script>', '13', 'sort records in a table'),
('gui_pwd_check', '<script src=\'/js/jQpwdCheck.js\'></script>\r\n<script type=\'text/javascript\'>$(document).ready(function () {$(\'#itable\').pwdCheck({\'minchars\': 8, \'digits\': 0, \'field\': \'&&&&me&&&&\', \'cmp\' : \'&&&&cmp&&&&\'});});</script>', '13', NULL);

CREATE TABLE `i18n` (
  `lid` bigint(20) NOT NULL AUTO_INCREMENT,
  `index` varchar(28) NOT NULL DEFAULT '',
  `group` varchar(16) NOT NULL DEFAULT 'common',
  `en` varchar(64) NOT NULL DEFAULT '',
  `de` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`lid`),
  UNIQUE KEY `index` (`index`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


INSERT INTO `i18n` (`index`, `group`, `en`, `de`)
VALUES ('user', 'common', 'User', 'Benutzer'),
('pwd', 'common', 'Password', 'Passwort'),
('login', 'common', 'Login', 'Anmelden'),
('logout', 'common', 'Logout', 'Abmelden'),
('bye', 'common', 'Good Bye', 'Auf Wiedersehen'),
('again', 'common', 'Back to Login', 'Wiedereinstieg'),
('mess_login', 'common', 'Please login', 'Bitte anmelden'),
('all', 'common', 'all', 'alle'),
('none', 'common', 'none', 'keine'),
('search', 'common', 'Search', 'Suche'),
('upload', 'common', 'Upload', 'Hochladen'),
('settings', 'common', 'Settings', 'Einstellungen'),
('hits', 'common', 'Hits', 'Treffer'),
('and', 'common', 'and', 'und'),
('or', 'common', 'or', 'oder'),
('sort', 'common', 'Sort', 'Sortieren'),
('edit', 'common', 'Edit', 'Bearbeiten'),
('delete', 'common', 'Delete', 'L&ouml;schen'),
('realy_delete', 'common', 'Do you realy want to delete _-(o)-_', 'Wollen Sie _-(o)-_ wirklich löschen'),
('upload_img', 'common', 'Upload Image', 'Bild hochladen'),
('img_exists', 'common', 'Existing Image', 'vorhandenes Bild'),
('mess_stored', 'common', 'is stored', 'ist gespeichert'),
('mess_updated', 'common', 'is updated', 'ist aktualisiert'),
('error', 'common', 'ERROR', 'FEHLER'),
('mess_deleted', 'common', 'is deleted for all times', 'ist für alle Zeiten unwiederbringlich gelöscht'),
('written', 'common', 'written', 'erstellt'),
('updated', 'common', 'updated', 'aktualisiert'),
('author', 'common', 'Author', 'Autor'),
('fulltext', 'common', 'Fulltext', 'Volltext'),
('copyright', 'common', 'Copyright', 'Urheberrecht'),
('cancel', 'common', 'cancel', 'Abbrechen'),
('ok', 'common', 'OK', 'OK'),
('mess_complete', 'common', 'Please fill in', 'Bitte ausfüllen'),
('link', 'common', 'HREF', 'Link'),
('picture', 'common', 'Picture', 'Bild'),
('new_entry', 'common', 'New Entry', 'Neuer Eintrag'),
('options', 'common', 'Options', 'Optionen'),
('language', 'common', 'Language', 'Sprache'),
('languages', 'common', 'Languages', 'Sprachen'),
('mess_no_entry', 'common', '- no entrys -', '- keine Daten -'),
('skin', 'settings', 'Skin', 'Farbschema'),
('helpme', 'common', 'Help', 'Hilfepunkte'),
('email', 'common', 'E-Mail', 'E-Mail'),
('name', 'common', 'Name', 'Name'),
('ulevel', 'common', 'User-Level', 'Benutzer-Status'),
('file', 'common', 'Filename', 'Dateiname'),
('group', 'common', 'Group', 'Gruppe'),
('new_user', 'common', 'New User', 'Neuer Benutzer'),
('all_users', 'common', 'All Users', 'Alle Benutzer'),
('admin', 'common', 'Administrator', 'Administrator'),
('maintainer', 'common', 'Maintainer', 'Wartung'),
('permission', 'common', 'Permission', 'Berechtigung'),
('size', 'common', 'Size', 'Größe'),
('new_category', 'common', 'New Category', 'Neue Mappe'),
('data', 'common', 'Data', 'Daten'),
('docs', 'common', 'Documents', 'Dokumente'),
('failed', 'common', 'Action has failed', 'Aktion fehlgeschlagen'),
('menue', 'common', 'Menue', 'Menü'),
('misc', 'common', 'Miscellanous', 'Verschiedenes'),
('plugins', 'common', 'Plug-Ins', 'Plug-Ins'),
('active', 'common', 'activated', 'aktiviert'),
('help', 'common', 'Help', 'Hilfe'),
('config', 'common', 'Configuration', 'Konfiguration'),
('no_plugin', 'common', 'No plugin available', 'Kein Plugin vorhanden'),
('part', 'common', 'part of a word', 'Wortteil'),
('whole', 'common', 'whole word', 'ganzes Wort'),
('type', 'common', 'Type', 'Typ'),
('next', 'common', 'next', 'weiter'),
('inactive', 'common', 'inactive', 'inaktiv'),
('question', 'common', 'Question', 'Frage'),
('activate', 'common', 'Activate', 'Aktivieren'),
('save', 'common', 'Save', 'Speichern'),
('deactivate', 'common', 'Deactivate', 'Deaktivieren'),
('year', 'common', 'Year', 'Jahr'),
('day', 'common', 'Day', 'Tag'),
('month', 'common', 'Month', 'Monat'),
('date', 'common', 'Date', 'Datum'),
('owner', 'common', 'Owner', 'Eigentümer'),
('preface', 'common', 'Preface', 'Vorwort'),
('awstats', 'common', 'Statistics', 'Statistik'),
('entry', 'common', 'entry', 'Eintrag'),
('entries', 'common', 'entries', 'Einträge'),
('new_window', 'common', 'open new window', 'Neues Fenster öffnen'),
('yes', 'common', 'Yes', 'Ja'),
('no', 'common', 'No', 'Nein'),
('rows', 'common', 'Rows', 'Datensätze'),
('updates', 'common', 'Updates', 'Aktualisierungen'),
('inserts', 'common', 'Inserts', 'Einfügungen'),
('deleted', 'common', 'deleted', 'entfernt'),
('table', 'common', 'Table', 'Tabelle'),
('records', 'common', 'Records', 'Datensätze'),
('info', 'common', 'Information', 'Info'),
('set_att', 'common', 'Set Attribute', 'Setze Eigenschaft'),
('no_selection', 'common', 'Please make a selection', 'Bitte treffen Sie eine Auswahl'),
('move_to', 'common', 'move to...', 'verschieben nach...'),
('hits_page', 'common', 'Hits per Page', 'Treffer pro Seite'),
('hours', 'common', 'Hours', 'Stunden'),
('months', 'common', 'Months', 'Monate'),
('tlds', 'common', 'Top-Level-Domains', 'Top-Level-Domains'),
('resolved', 'common', 'Resolved IP', 'Aufgelöste IP'),
('mess_check', 'common', 'Please check your entries and retry sending.', 'Bitte überprüfen Sie Ihre Eingaben und senden sie erneut.'),
('incorrect_data', 'common', 'Incorrect Data', 'Fehlerhafte Eingabe'),
('close', 'common', 'Close Window', 'Fenster schließen'),
('link_ass', 'common', 'Reference-Assistant', 'Linkassistent'),
('you_are_here', 'common', 'You are here', 'Sie befinden sich hier'),
('action', 'common', 'Action', 'Aktion'),
('deflang', 'languages', 'Default Language', 'Standardsprache'),
('pwd_twice', 'common', 'Please fill in twice', 'Bitte zweimal eingeben'),
('previous', 'common', 'previous', 'zurück'),
('false_login', 'common', 'False Login', 'Falsche Anmeldung'),
('rtfm', 'common', 'Please pay attention to the manual!', 'Bitte Handbuch beachten!'),
('default', 'common', 'Default', 'Standard'),
('skip', 'common', 'skip', 'überspringen'),
('next_id', 'common', 'next ID', 'nächste ID'),
('license', 'common', 'License', 'Lizenz'),
('properties', 'common', 'Properties', 'Eigenschaften'),
('more', 'common', 'more', 'mehr'),
('mess_duty', 'common', 'Please fill in the mandatory fields.', 'Bitte füllen Sie die Pflichtfelder aus.'),
('submit_data', 'common', 'Submit Data.', 'Übertrage Daten.'),
('pwd_too_short', 'common', 'The Password is too short.', 'Das Passwort ist zu kurz.'),
('min_chars', 'common', 'Minimum number of characters:', 'Mindestanzahl an Zeichen:'),
('filemanager', 'common', 'Filemanager', 'Dateimanager'),
('too_big', 'common', 'The file is too big.', 'Die Datei ist zu groß.'),
('no_html5', 'common', 'Your browser is not HTML5-compliant', 'Ihr Browser unterstützt nicht HTML5.'),
('no_multiple', 'common', 'A multiple upload is not available.', 'Ein mehrfaches Hochladen ist nicht möglich.'),
('dragndrop', 'common', 'Drag and drop files here.', 'Dateien in dieses Feld ziehen'),
('ready', 'common', 'Ready', 'Fertig'),
('queue', 'common', 'Queue', 'Warteschlange'),
('last_edit', 'common', 'last edited', 'zuletzt bearbeitet'),
('download', 'common', 'Download', 'Herunterladen'),
('save_as', 'common', 'Save as', 'Speichern unter'),
('toggle_selection', 'common', 'Toggle Selection', 'Auswahl umkehren'),
('click2toggle', 'common', 'Activate/Deactivate', 'Aktivieren/Deaktivieren'),
('change_status', 'common', 'Do you wish to change this property?', 'Wollen Sie diese Eigenschaft ändern?'),
('op_not_pos', 'common', 'This operation is not allowed.', 'Diese Operation ist nicht erlaubt.'),
('move', 'common', 'Drag the entry to the desired position.', 'Ziehen Sie den Eintrag an die gewünschte Stelle.'),
('moved', 'common', 'You may now click the Sort-Button.', 'Sie können nun auf den Sortieren-Knopf klicken.'),
('mobile_css', 'common', 'Stylesheet for mobile devices', 'Stylesheet für mobile Geräte'),
('mess_sort', 'common', 'Sorting is accomplished.', 'Sortierung ist erfolgt.'),
('move_info', 'common', 'You may sort the entries here.', 'Die Reihenfolge der Einträge kann hier sortiert werden.'),
('pictures', 'common', 'Pictures', 'Bilder'),
('portfolio', 'common', 'Portfolio', 'Mappe'),
('preview', 'common', 'Preview', 'Voransicht'),
('new_portfolio', 'common', 'New Portfolio', 'Neue Mappe'),
('new_image', 'common', 'New Image', 'Neues Bild'),
('crop', 'images', 'Crop', 'Beschneiden'),
('upload_date', 'images', 'Date of Upload', 'Upload-Datum'),
('axis', 'common', 'Axis', 'Achse'),
('degrees', 'common', 'Degrees', 'Grad'),
('mirror', 'images', 'Mirror', 'Spiegeln'),
('brightness', 'images', 'Brightness', 'Helligkeit'),
('rotate', 'images', 'Rotate', 'Rotieren'),
('announces', 'common', 'Teaser', 'Teaser'),
('area', 'announces', 'Area', 'Bereich'),
('alternative', 'common', 'Alternative Text', 'Alternativtext'),
('totop', 'common', 'to top', 'nach oben'),
('mainnav', 'common', 'Menu', 'Menü'),
('overview', 'common', 'Overview', 'Übersicht'),
('content', 'common', 'Content', 'Content'),
('pages', 'common', 'Pages', 'Seiten'),
('folders', 'common', 'Folders', 'Ordner'),
('folder', 'common', 'Folder', 'Ordner'),
('new_folder', 'common', 'New Folder', 'Neuer Ordner'),
('new_page', 'common', 'New Page', 'Neue Seite'),
('new_teaser', 'common', 'New Teaser', 'Neuer Teaser'),
('new_container', 'common', 'New Container', 'Neuer Container'),
('homepage', 'common', 'Frontpage', 'Startseite'),
('meta', 'common', 'Meta Tags', 'Meta-Information'),
('web_settings', 'common', 'CMS Settings', 'CMS Einstellungen'),
('lang_settings', 'common', 'Language Settings', 'Sprachen Einstellungen'),
('website_logo', 'common', 'Logo', 'Logo'),
('website_url', 'common', 'Website URL', 'Website URL'),
('gallery', 'common', 'Gallery', 'Galerie'),
('short_title', 'common', 'Short Title', 'Kurztitel'),
('short', 'common', 'Short Name', 'Kürzel'),
('website_title', 'pages', 'Website Title', 'Titel der Website'),
('website_keywords', 'pages', 'Website Keywords', 'Schlüsselwörter'),
('website_description', 'pages', 'Description (a few words)', 'Beschreibung (zwei kurze Sätze)'),
('website_author', 'pages', 'Author', 'Autor'),
('def_css', 'pages', 'Stylesheet', 'Stylesheet'),
('print_css', 'pages', 'Stylesheet for Printing Version', 'Stylesheet für Druckversion'),
('templates', 'common', 'Templates', 'Vorlagen'),
('template', 'common', 'Template', 'Vorlage'),
('database', 'common', 'Database', 'Datenbank'),
('container', 'common', 'Container', 'Container'),
('container_entries', 'common', 'Container-Entries', 'Container-Einträge'),
('css', 'common', 'CSS Stylesheet', 'CSS Stylesheet'),
('css_admin', 'common', 'CSS Manager', 'CSS Manager'),
('help_admin', 'common', 'Help Manager', 'Hilfe Manager'),
('HTML-Snippets', 'common', 'HTML Templates', 'HTML Vorlagen'),
('resize', 'common', 'Enlarge', 'Vergrößern'),
('sitemap', 'common', 'Sitemap', 'Sitemap'),
('components', 'common', 'Components', 'Komponenten'),
('layout', 'common', 'Pages Template Layout', 'Seiten Vorlagen Layout'),
('scheme1', 'common', 'Of Mice and Men', 'Von Mäusen und Menschen'),
('scheme2', 'common', 'Blue in the Face', 'Blue in the Face'),
('scheme3', 'common', 'Twinni', 'Twinni'),
('scheme4', 'common', 'Greenhorn', 'Grünschnabel'),
('print_version', 'common', 'Printing Version', 'Druckversion'),
('new_link', 'common', 'New Link', 'Neue Verknüpfung'),
('publish', 'common', 'Publish', 'Publizieren'),
('keywords', 'common', 'Searchwords', 'Suchbegriffe'),
('no_frame', 'common', 'Your browser does not support frames.', 'Ihr Browser kann keine Frames darstellen.'),
('img_single', 'images', 'Upload a single picture', 'Einzelnes Bild hochladen'),
('img_multi', 'images', 'Upload several pictures', 'Mehrere Bilder hochladen'),
('view_of_folder', 'common', 'View of Folder', 'Ansicht des Ordners'),
('auto_overview', 'common', 'Folder shows automatic overview', 'Ordner zeigt automatische Übersicht'),
('first_page', 'common', 'Folder shows first page', 'Ordner zeigt erste Seite'),
('country', 'common', 'Country', 'Staat'),
('title', 'common', 'Title', 'Titel'),
('text', 'common', 'Text', 'Text'),
('key', 'common', 'Key', 'Schlüssel'),
('description', 'common', 'Description', 'Beschreibung'),
('published', 'common', 'published', 'veröffentlicht'),
('last_update', 'common', 'last update', 'zuletzt aktualisiert'),
('images', 'common', 'Image Database', 'Bilddatenbank'),
('cron', 'common', 'Timing', 'Zeitsteuerung'),
('pending', 'common', 'will be executed', 'wird vollzogen werden'),
('not_pending', 'common', 'will not be executed (anymore)', 'wird nicht (mehr) vollzogen'),
('print', 'common', 'Print', 'Drucken'),
('update', 'common', 'Software Update', 'Programm Aktualisierung'),
('skip_home', 'pages', 'Skip "Home"', '"Home" nicht anzeigen'),
('breadcrumb', 'pages', 'Show breadcrumb', 'Breadcrumb anzeigen'),
('head', 'pages', 'HEAD Area', 'HEAD Bereich'),
('offline', 'common', 'offline', 'offline'),
('start', 'common', 'Begin', 'Anfang'),
('end', 'common', 'End', 'Ende'),
('default_lang', 'common', 'Default Language', 'Standardsprache'),
('used_langs', 'common', 'Used Languages', 'Benutzte Sprachen'),
('set', 'common', 'Set', 'Setzen'),
('custom', 'common', 'Custom', 'Benutzerdefiniert'),
('header', 'common', 'Header', 'Kopfbereich'),
('footer', 'common', 'Footer', 'Fußbereich'),
('show_title', 'pages', 'Display Title', 'Titel anzeigen'),
('not_connected', 'common', 'There is no connection.', 'Keine Verbindung'),
('no_updates', 'update', 'Consentio is up to date.', 'Consentio ist am aktuellen Stand.'),
('available_plugins', 'update', 'Available Plug-Ins', 'Verfügbare Plugins'),
('is_installed', 'update', '... is installed.', '... ist installiert.'),
('install', 'update', 'Install', 'Installieren'),
('update_now', 'common', 'Update now', 'Jetzt aktualisieren'),
('sub_nav', 'pages', 'Show sub navigation', 'Subnavigation anzeigen'),
('page', 'pages', 'Page', 'Seite'),
('files', 'common', 'Files', 'Dateien'),
('warning', 'common', 'Advice', 'Hinweis'),
('top', 'settings', 'Tab', 'Karteireiter'),
('groups', 'common', 'Groups', 'Gruppen'),
('register', 'settings', 'Menu Register', 'Menü-Register'),
('frontend', 'settings', 'Frontend', 'Frontend'),
('color', 'common', 'Color', 'Farbe'),
('used_colors', 'cssadmin', 'Used Colors', 'Benutzte Farben'),
('code', 'common', 'Code', 'Code'),
('page_templates', 'pages', 'Template Management', 'Vorlagen-Verwaltung'),
('dump_table', 'tables', 'Dump of Table', 'Tabellen-Dump'),
('execute', 'tables', 'Execute', 'Ausführen'),
('index', 'languages', 'i18n Keyword', 'i18n-Schlüssel'),
('chapter', 'common', 'Chapter', 'Kapitel'),
('add_template', 'pages', 'Add a new template', 'Neue Vorlage hinzufügen'),
('regenerate', 'common', 'Regenerate Website', 'Website neu generieren'),
('layout_changed', 'pages', 'New Layout has been loaded.', 'Neue Vorlage ist geladen worden.'),
('mess_lang_settings', 'pages', 'The versions of languages have been updated.', 'Die Sprachversionen sind aktualisiert.'),
('mess_overwrite_html', 'pages', 'Avoid changes of the design during operation.', 'Vermeiden Sie Änderungen des Designs im laufenden Betrieb.'),
('load_layout', 'pages', 'Load Template for Basic Layout', 'Lade Vorlage für Basis-Layout'),
('c_filter', 'common', 'Content Filter', 'Content Filter'),
('only_pages', 'common', 'Pages Only', 'Nur Seiten'),
('export_xml', 'common', 'Export XML File', 'Export XML-Datei'),
('postit', 'common', 'Post It', 'Post It'),
('new_table', 'common', 'New Data Table', 'Neue Tabelle'),
('char_set', 'tables', 'Character Set', 'Zeichenkodierung'),
('datafield', 'tables', 'Column', 'Datenfeld'),
('fieldname', 'tables', 'Name of Column', 'Feldname'),
('fieldtype', 'tables', 'Type of Column', 'Datentyp'),
('fieldlength', 'tables', 'Length', 'Feldlänge'),
('attribute', 'common', 'Attribute', 'Attribut'),
('add_field', 'tables', 'Add Column', 'Datenfeld hinzufügen'),
('create_table', 'tables', 'Create Table', 'Tabelle erstellen'),
('indexes', 'tables', 'Indexes', 'Indizes'),
('really_execute', 'common', 'Do you really want to execute this command?', 'Wollen Sie diesen Befehl wirklich ausführen?'),
('results', 'common', 'Results', 'Ergebnisse'),
('mess_executed', 'tables', 'The command has been executed. Take a look at the results.', 'Die Befehle wurden ausgeführt. Beachten Sie die Ergebnisse.'),
('add_after', 'tables', 'Add after column...', 'Einfügen nach Feld...'),
('skipped', 'common', 'This file has not been uploaded.', 'Diese Datei wurde nicht hochgeladen.'),
('mess_pwd', 'common', 'Minimum 8 characters, one capital letter', 'Mindestens 8 Buchstaben, ein Großbuchstabe'),
('alter_def_user', 'common', 'Please alter name and password of your user.', 'Ändern Sie bitte Name und Passwort ihres Benutzers.'),
('make_settings', 'common', 'Please carry out the CMS-Settings.', 'Nehmen Sie bitte die CMS-Einstellungen vor.'),
('new_updates', 'common', 'New update available!', 'Ein neues Update ist verfügbar!'),
('by', 'common', 'by', 'von'),
('website_lead_img', 'common', 'Lead Image', 'Leitbild'),
('php_info', 'common', 'PHP Info', 'PHP Info'),
('most_relevant', 'common', 'most relevant', 'zutreffendste'),
('recent', 'common', 'recent', 'jüngste'),
('duplicate', 'common', 'Duplicate', 'Duplizieren'),
('copy', 'common', 'Copy', 'Kopie'),
('designer', 'pages', 'Designer', 'Designer'),
('operations', 'common', 'Operations', 'Transaktionen'),
('too_much', 'common', 'You can upload _-\'\'-_ files maximum.', 'Sie können gleichzeitig bis zu _-\'\'-_ Dateien hochladen.'),
('reduce_img', 'common', 'Please reduce the number of images.', 'Bitte reduzieren Sie die Anzahl der Dateien.'),
('toggle', 'common', 'toggle', 'ein/ausklappen'),
('no_abbr', 'common', '№', 'Nr.');;

CREATE TABLE `image_db` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filename` varchar(128) NOT NULL DEFAULT '',
  `title` varchar(128) DEFAULT NULL,
  `description` text,
  `parent` bigint(20) NOT NULL DEFAULT '1',
  `copyright` varchar(128) DEFAULT NULL,
  `upload_date` datetime DEFAULT NULL,
  `lightbox` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `filename` (`filename`,`title`,`description`,`copyright`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `image_db` (`id`, `filename`, `title`, `description`, `parent`, `copyright`, `upload_date`, `lightbox`) VALUES
(1, 'IMG_2780.JPG', 'Santa Maria del Fiore', '', 1, 'Rainer Imb', '2015-10-08 14:17:58', NULL),
(2, 'mccurdy.png', 'website_logo', '[cms_settings]', 1, NULL, '2015-10-09 11:32:15', NULL);

CREATE TABLE `image_folder` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL DEFAULT '',
  `parent` bigint(20) NOT NULL DEFAULT '0',
  `sort` bigint(20) NOT NULL,
  `parentsort` bigint(20) DEFAULT NULL,
  `graduated` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `image_folder` (`id`, `name`, `parent`, `sort`, `parentsort`, `graduated`) VALUES
(1, 'Bilddatenbank', 0, 0, 1, ' Bilddatenbank');

CREATE TABLE `languages` (
  `language` varchar(34) NOT NULL DEFAULT '',
  `iso639` char(2) NOT NULL DEFAULT '',
  `iso639_2` char(3) NOT NULL DEFAULT '',
  `used` char(2) NOT NULL DEFAULT '',
  `multilingual` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`iso639`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `languages` (`language`, `iso639`, `iso639_2`, `used`, `multilingual`) VALUES
('Abchasisch', 'ab', 'abk', '', NULL),
('Afar', 'aa', 'aar', '', NULL),
('Afrikaans', 'af', 'afr', '', NULL),
('Akan', 'ak', 'aka', '', NULL),
('Albanisch', 'sq', 'alb', '', NULL),
('Altkirchenslawisch', 'cu', 'chu', '', NULL),
('Amharisch', 'am', 'amh', '', NULL),
('Anishinabe', 'oj', 'oji', '', NULL),
('Arabisch', 'ar', 'ara', '', NULL),
('Aragonesisch', 'an', 'arg', '', NULL),
('Armenisch', 'hy', 'hye', '', NULL),
('Assamesisch/Assami', 'as', 'asm', '', NULL),
('Aserbaidschanisch', 'az', 'aze', '', NULL),
('Avestisch', 'ae', 'ave', '', NULL),
('(Neu-)Awarisch', 'av', 'ava', '', NULL),
('Aymara', 'ay', 'aym', '', NULL),
('Bambara', 'bm', 'bam', '', NULL),
('Banyumasan', 'by', 'bdf', '', NULL),
('Baschkirisch', 'ba', 'bak', '', NULL),
('Baskisch', 'eu', 'eus', '', NULL),
('Bengali', 'bn', 'ben', '', NULL),
('Bihari', 'bh', 'bih', '', NULL),
('Bislama', 'bi', 'bis', '', NULL),
('Bosnisch', 'bs', 'bos', '', NULL),
('Bretonisch', 'br', 'bre', '', NULL),
('Bulgarisch', 'bg', 'bul', '', NULL),
('Birmanisch', 'my', 'mya', '', NULL),
('Chamorro', 'ch', 'cha', '', NULL),
('Chichewa', 'ny', 'nya', '', NULL),
('Chinesisch', 'zh', 'zho', '', NULL),
('Cree', 'cr', 'cre', '', NULL),
('Dänisch', 'da', 'dan', '', NULL),
('Deutsch', 'de', 'deu', 'on', 'on'),
('Dhivehi', 'dv', 'div', '', NULL),
('Dzongkha', 'dz', 'dzo', '', NULL),
('Englisch', 'en', 'eng', 'on', ''),
('Esperanto', 'eo', 'epo', '', NULL),
('Estnisch', 'et', 'est', '', NULL),
('Ewe', 'ee', 'ewe', '', NULL),
('Färöisch', 'fo', 'fao', '', NULL),
('Fidschi', 'fj', 'fij', '', NULL),
('Finnisch', 'fi', 'fin', '', NULL),
('Französisch', 'fr', 'fra', '', NULL),
('Friesisch', 'fy', 'fry', '', NULL),
('Fula', 'ff', 'ful', '', NULL),
('Galicisch', 'gl', 'glg', '', NULL),
('(Schottisch-)Gälisch', 'gd', 'gla', '', NULL),
('Ganda', 'lg', 'lug', '', NULL),
('Georgisch', 'ka', 'kat', '', NULL),
('(Neu-)Griechisch', 'el', 'ell', '', NULL),
('Guaraní', 'gn', 'grn', '', NULL),
('Gujarati', 'gu', 'guj', '', NULL),
('Haitianisch', 'ht', 'hat', '', NULL),
('Hausa', 'ha', 'hau', '', NULL),
('Hebräisch', 'he', 'heb', '', NULL),
('Herero', 'hz', 'her', '', NULL),
('Hindi', 'hi', 'hin', '', NULL),
('Hiri Motu', 'ho', 'hmo', '', NULL),
('Ibo', 'ig', 'ibo', '', NULL),
('Ido', 'io', 'ido', '', NULL),
('Indonesisch', 'id', 'ind', '', NULL),
('Interlingua', 'ia', 'ina', '', NULL),
('Interlingue', 'ie', 'ile', '', NULL),
('Inuktitut', 'iu', 'iku', '', NULL),
('Inupiaq', 'ik', 'ipk', '', NULL),
('Irisch', 'ga', 'gle', '', NULL),
('IsiXhosa', 'xh', 'xho', '', NULL),
('IsiZulu', 'zu', 'zul', '', NULL),
('Isländisch', 'is', 'isl', '', NULL),
('Italienisch', 'it', 'ita', '', NULL),
('Japanisch', 'ja', 'jpn', '', NULL),
('Javanisch', 'jv', 'jav', '', NULL),
('Jiddisch', 'yi', 'yid', '', NULL),
('Kalaallisut; Grönländisch', 'kl', 'kal', '', NULL),
('Kannada; Kanaresisch', 'kn', 'kan', '', NULL),
('Kanuri', 'kr', 'kau', '', NULL),
('Kasachisch', 'kk', 'kaz', '', NULL),
('Kaschmiri', 'ks', 'kas', '', NULL),
('Katalanisch', 'ca', 'cat', '', NULL),
('Khmer', 'km', 'khm', '', NULL),
('Kikuyu', 'ki', 'kik', '', NULL),
('Kinyarwanda', 'rw', 'kin', '', NULL),
('Kirgisisch', 'ky', 'kir', '', NULL),
('Kirundi', 'rn', 'run', '', NULL),
('Kongo; Kikongo', 'kg', 'kon', '', NULL),
('Komi', 'kv', 'kom', '', NULL),
('Koreanisch', 'ko', 'kor', '', NULL),
('Kornisch', 'kw', 'cor', '', NULL),
('Korsisch', 'co', 'cos', '', NULL),
('Kroatisch', 'hr', 'hrv', '', NULL),
('Kuanyama', 'kj', 'kua', '', NULL),
('Kurdisch', 'ku', 'kur', '', NULL),
('Lao', 'lo', 'lao', '', NULL),
('Lateinisch', 'la', 'lat', '', NULL),
('Lettisch', 'lv', 'lav', '', NULL),
('Limburgisch', 'li', 'lim', '', NULL),
('Lingala', 'ln', 'lin', '', NULL),
('Litauisch', 'lt', 'lit', '', NULL),
('Luba-Katanga', 'lu', 'lub', '', NULL),
('Luxemburgisch', 'lb', 'ltz', '', NULL),
('Madagassisch', 'mg', 'mlg', '', NULL),
('Malaiisch', 'ms', 'msa', '', NULL),
('Malayalam', 'ml', 'mal', '', NULL),
('Maltesisch', 'mt', 'mlt', '', NULL),
('Manx', 'gv', 'glv', '', NULL),
('Maori', 'mi', 'mri', '', NULL),
('Marathi', 'mr', 'mar', '', NULL),
('Marshallisch', 'mh', 'mah', '', NULL),
('Mazedonisch', 'mk', 'mkd', '', NULL),
('Moldawisch', 'mo', 'mol', '', NULL),
('Mongolisch', 'mn', 'mon', '', NULL),
('Nauruisch', 'na', 'nau', '', NULL),
('Navajo', 'nv', 'nav', '', NULL),
('Nördliches Ndebele', 'nd', 'nde', '', NULL),
('Südliches Ndebele', 'nr', 'nbl', '', NULL),
('Ndonga', 'ng', 'ndo', '', NULL),
('Nepalesisch', 'ne', 'nep', '', NULL),
('Niederländisch', 'nl', 'nld', '', NULL),
('Norwegisch', 'no', 'nor', '', NULL),
('Bokmål-Norwegisch', 'nb', 'nob', '', NULL),
('Nynorsk-Norwegisch', 'nn', 'nno', '', NULL),
('Oriya', 'or', 'ori', '', NULL),
('Oromo', 'om', 'orm', '', NULL),
('Ossetisch', 'os', 'oss', '', NULL),
('Pali', 'pi', 'pli', '', NULL),
('Paschtunisch', 'ps', 'pus', '', NULL),
('Persisch', 'fa', 'fas', '', NULL),
('Polnisch', 'pl', 'pol', '', NULL),
('Portugiesisch', 'pt', 'por', '', NULL),
('Provenzalisch', 'oc', 'oci', '', NULL),
('Punjabi', 'pa', 'pan', '', NULL),
('Quechua', 'qu', 'que', '', NULL),
('Rätoromanische Sprache', 'rm', 'roh', '', NULL),
('Rumänisch', 'ro', 'ron', '', NULL),
('Russisch', 'ru', 'rus', '', NULL),
('Samisch', 'se', 'sme', '', NULL),
('Samoanisch', 'sm', 'smo', '', NULL),
('Sango', 'sg', 'sag', '', NULL),
('Sanskrit', 'sa', 'san', '', NULL),
('Sardisch', 'sc', 'srd', '', NULL),
('Schwedisch', 'sv', 'swe', '', NULL),
('Serbisch', 'sr', 'srp', '', NULL),
('Sesotho', 'st', 'sot', '', NULL),
('Setswana', 'tn', 'tsn', '', NULL),
('Shona', 'sn', 'sna', '', NULL),
('Sichuanhua', 'ii', 'iii', '', NULL),
('Sindhi', 'sd', 'snd', '', NULL),
('Singhalesisch', 'si', 'sin', '', NULL),
('Siswati', 'ss', 'ssw', '', NULL),
('Slowakisch', 'sk', 'slk', '', NULL),
('Slowenisch', 'sl', 'slv', '', NULL),
('Somali', 'so', 'som', '', NULL),
('Spanisch', 'es', 'spa', '', NULL),
('Sundanesisch', 'su', 'sun', '', NULL),
('Swahili', 'sw', 'swa', '', NULL),
('Tadschikisch', 'tg', 'tgk', '', NULL),
('Tagalog', 'tl', 'tgl', '', NULL),
('Tahitianisch', 'ty', 'tah', '', NULL),
('Tamilisch', 'ta', 'tam', '', NULL),
('Tatarisch', 'tt', 'tat', '', NULL),
('Telugu', 'te', 'tel', '', NULL),
('Thailändisch', 'th', 'tha', '', NULL),
('Tibetisch', 'bo', 'bod', '', NULL),
('Tigrinya', 'ti', 'tir', '', NULL),
('Tongaisch', 'to', 'tom', '', NULL),
('Tschechisch', 'cs', 'ces', '', NULL),
('Tschetschenisch', 'ce', 'che', '', NULL),
('Tschuwaschisch', 'cv', 'chv', '', NULL),
('Tsonga', 'ts', 'tso', '', NULL),
('Türkisch', 'tr', 'tur', '', NULL),
('Turkmenisch', 'tk', 'tuk', '', NULL),
('Twi', 'tw', 'twi', '', NULL),
('Uigurisch', 'ug', 'uig', '', NULL),
('Ukrainisch', 'uk', 'ukr', '', NULL),
('Ungarisch', 'hu', 'hun', '', NULL),
('Urdu', 'ur', 'urd', '', NULL),
('Usbekisch', 'uz', 'uzb', '', NULL),
('Venda', 've', 'ven', '', NULL),
('Vietnamesisch', 'vi', 'vie', '', NULL),
('Volapük', 'vo', 'vol', '', NULL),
('Walisisch', 'cy', 'cym', '', NULL),
('Wallonisch', 'wa', 'wln', '', NULL),
('Weißrussisch', 'be', 'bel', '', NULL),
('Wolof', 'wo', 'wol', '', NULL),
('Yoruba', 'yo', 'yor', '', NULL),
('Zhuang', 'za', 'zha', '', NULL);

CREATE TABLE `register_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `sort` BIGINT(20) UNSIGNED NOT NULL DEFAULT '10',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `register_groups` (`id`, `name`, `sort`) VALUES
(1, 'filemanager', 50),
(2, 'settings', 60),
(3, 'pages', 10),
(4, 'images', 40),
(5, 'announces', 20),
(6, 'articles', 30),
(7, 'plugins', 70),
(8, 'misc', 80);

CREATE TABLE `register` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `call` varchar(32) NOT NULL,
  `plugin` varchar(32) DEFAULT NULL,
  `tab` varchar(32) DEFAULT NULL,
  `params` varchar(64) NOT NULL,
  `gui` tinyint(4) NOT NULL DEFAULT '0',
  `top` varchar(2) NOT NULL,
  `start` varchar(2) NOT NULL,
  `group` varchar(2) NOT NULL,
  `icon` varchar(64) DEFAULT NULL,
  `image` TINYINT(3)  DEFAULT NULL,
  `level` int(11) NOT NULL DEFAULT '1',
  `sort` bigint(20) NOT NULL DEFAULT '10',
  `frontend` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `register` (`name`, `call`, `plugin`, `tab`, `params`, `gui`, `top`, `start`, `group`, `icon`, `image`, `level`, `sort`, `frontend`) VALUES
('languages', 'languages', 'settings', '2', '', 1, '', '', 'on', 'comments', 0, 2, 530, ''),
('menue', 'register', 'settings', '2', '', 0, '', '', 'on', 'table', 0, 2, 390, ''),
('HTML-Snippets', 'snippets', 'settings', '2', '', 0, '', '', 'on', 'code', 0, 2, 510, ''),
('html_group', 'html_group', 'settings', '2', '', 0, '', '', '', 'folder', 0, 2, 520, ''),
('settings', 'settings', NULL, '2', '', 1, 'on', 'on', 'on', 'wrench', 0, 2, 360, ''),
('overview', 'start', NULL, '0', '', 0, 'on', '', '', 'bars', 0, 1, 110, ''),
('user', 'user', 'settings', '2', '', 0, '', 'on', 'on', 'users', 0, 2, 370, ''),
('options', 'options', 'settings', '2', '', 1, '', '', '', 'wrench', 0, 1, 380, ''),
('database', 'tables', '', '2', '', 0, '', '', 'on', 'database', 0, 3, 560, ''),
('pictures', 'images', '', '4', '', 0, 'on', 'on', '', 'images', 0, 1, 310, ''),
('portfolio', 'folder-img', 'images', '4', '', 0, '', 'on', 'on', 'folder-img', 0, 1, 320, ''),
('help_groups', 'help_groups', 'help_admin', '2', '', 0, '', '', '', 'folder', 0, 3, 550, ''),
('new_image', 'images', '', '4', '&todo=edit', 0, '', 'on', 'on', 'image-add', 0, 1, 330, ''),
('filemanager', 'filemanager', NULL, '1', '', 0, 'on', 'on', 'on', 'upload', 0, 2, 340, ''),
('upload', 'upload', 'filemanager', '1', '', 0, '', 'on', 'on', 'upload', 0, 2, 350, ''),
('groups', 'rgroups', 'settings', '2', '', 0, '', '', '', 'folder-red', 0, 2, 400, ''),
('css_admin', 'cssadmin', NULL, '2', '', 0, '', '', 'on', 'css3', 0, 2, 410, ''),
('help_admin', 'help_admin', '', '2', '', 0, '', '', 'on', 'info-circle', 0, 3, 540, ''),
('monitor', 'monitor', NULL, '2', '', '1', '', '', 'on', 'server', '0', '3', '450', ''),
('update', 'update', NULL, '2', '', '1', '', '', 'on', 'sync-green', '0', '3', '320', ''),
('php_info', 'php_info', 'settings', '2', '', '1', '', '', 'on', 'php', NULL, '3', '520', '');

CREATE TABLE `user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT 'user',
  `short` char(3) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `scheme` tinyint(4) NOT NULL DEFAULT '1',
  `helpme` char(2) DEFAULT 'on',
  `level` tinyint(4) NOT NULL DEFAULT '1',
  `pwd` varchar(255) NOT NULL DEFAULT '0',
  `sid` varchar(20)  DEFAULT NULL,
  `language` varchar(16) NOT NULL DEFAULT 'de',
  `picture` VARCHAR(127) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `user` (`id`, `name`, `short`, `email`, `scheme`, `helpme`, `level`, `pwd`, `sid`, `language`) VALUES
(1, 'Startuser', 'su', '', 1, 'on', 3, '', '', 'de');
