<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-04-11 11:50:22
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-07-26T18:22:07+02:00
# @License: GPL 2.0


/**
 * a class to generate the gui
 * @package consentio mvc
 */
class gui {
	private $sid = 0;
	private $gui = 0;
	private $plugin = "start";
	private $scripts = "";
	private $formtitle = "";
	private $title_suffix = "";
	private $timestamp = "";
	private $mess_icon = "";
	private $help_icon = "&nbsp;";
	private $homepage_info = "&nbsp;";
	private $gui_header = "gui_header_1";
	private $templates = array();
	public $feedback_level = "ok";

	public function __construct(array$form){
		global $website;
		foreach($form as $k=>$v){
            $this->{$k}=$v;
			}
		$this->ver = $this->con['version'];
    $this->timestamp = date('Y/m/d H:i:s');
    $this->year = date('Y');
		$this->lang = $this->user['language'];
		$lft = $this->user['level']-1;
		$lft = $lft < 0 ? 0 : $lft;
		if (array_key_exists('name', $this->user)) {$this->user_display = "<a href='$this->myurl?sid=$this->sid&amp;_id=options'>".get_icon('user-'.$this->user['level'], i18n($this->con['levels'][($lft)]))." <span class='hide-mobile'>{$this->user['name']}</span></a>";}
		if ($website) {$this->homepage_info = "<a href='{$website['website_url']}' target='_blank'>".get_icon('homepage', i18n('homepage'))." <strong class='hide-mobile'>{$website['website_title']}</strong></a>";}
		}

	public function tabs() {
		global $db;
		$pac = 0; $tac = 0;
		$arg = $db->prepare("SELECT * FROM `register` WHERE `top` = 'on' AND `level` <= ? ORDER BY `sort`");
		$arg->execute(array($this->user['level']));
		$tabs = [];
		if ($arg->rowCount()) {
			while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
				$img = $data['icon'] ? $data['icon'] : "todo";
				$caption = get_icon($img, i18n($data['name']))."&nbsp;".i18n($data['name'], true);
				if ($data['tab'] == $this->tab && !$tac) {$tac = $data['call'];} // active tab for group
				if ($data['call'] == $this->plugin && !$pac) {$pac = $data['call'];} // active tab for action call
				$tabs[$data['call']]  = ['caption' => $caption, 'href' => "{$this->myurl}?_id={$data['call']}&amp;sid={$this->sid}"];
				}
			$active = $pac ? $pac : $tac; // action before group for active tab
			$li = '';
			foreach ($tabs as $k=>$v) {
				$class = $k === $active ? ' class="active"' : ''; // active tab
				$a = htmltag('a', "href=\"{$v['href']}\"$class", $v['caption']);
				$li .= htmltag('li', '', $a);
				}
			$this->navigation = htmltag('ul', 'id="primary" class="submen clrfx"', $li);
			}
		}

	public function get_header() {
		if ($this->popup) {
			$css = $this->feedback_level == 'ok' ? 'green' : 'red';
			$img = $this->feedback_level == 'ok' ? 'check-circle-green' : 'exclamation-triangle-red';
			$timeout = $this->feedback_level == 'ok' ? 2 : 10;
			$icon = get_awesome(['icon' => $img, 'alt' => '']);
			$popup = "<div class='dlgtext'><div class='col w3 m3 first mess-icon'>$icon</div><div class='col w9 m9 last'><p class='$css'>$this->popup</p></div></div>";
			$popup = preg_replace('/\"/', '\'', $popup);
			$popup = preg_replace('/[\n\r]/', '', $popup);
			$header = i18n('info');
			$this->mess_icon = "<a href='#' id='mess_icon'>".get_icon("warning-$css", i18n('warning'))."</a>";
			$this->scripts .= <<<EOL
		<script type="text/javascript">
		\$(document).ready(function () {
			\$('#site').popUp({'header': '$header','body': "$popup", 'top': '25%', 'left': '40%', 'timeout': $timeout})
			\$('#mess_icon').click(function () {\$('#site').popUp({'header': '$header','body': "$popup", 'top': '10%', 'left': '40%', 'timeout': 10})});
			});
		</script>
EOL;
			}
		$this->logout = "|&nbsp;<a href='{$this->myurl}?_id=logout&amp;sid={$this->sid}'>".get_icon("exit", i18n('logout'))."</a>";
		$this->help_icon = "<a href='{$this->myurl}?_id=help&amp;sid={$this->sid}'>".get_icon("info", i18n('help'))."&nbsp;<span class='hide-mobile'>".i18n('help')."</span></a>";
		$this->header = $this->parse_in($this->gui_header);
		}


	public function generate(){
		if ($this->sid and $this->gui <= 3) {
			$this->tabs();
			$this->get_header();
			$this->footer = $this->parse_in("gui_footer_1");
			}
		$this->headtitle = 	$this->title_suffix ? $this->title." &ndash; ".$this->title_suffix : $this->title;
		$css_prefix = isset($this->con['css_prefix']) ? $this->con['css_prefix'] : "style";
		$this->CSS = isset($this->user['scheme']) ? $css_prefix.$this->user['scheme'] : $css_prefix.'1';
		$out = $this->parse_in("gui_head");
		switch ($this->gui) {
			case 7: # without grid
				$out .= $this->parse_in("gui_main_6");
				break;
			case 6: # ajax
				$out = $this->content;
				break;
			case 5: # popup iframe
				if ($this->formtitle) {$this->formtitle = $this->parse_in("gui_formtitle2");}
				$out .= $this->parse_in("gui_main_3");
				break;
			case 4: # no header, aside
				if ($this->formtitle) {$this->formtitle = $this->parse_in("gui_formtitle");}
				$out .= $this->parse_in("gui_main_4");
				break;
			case 3: # dashboard
				if ($this->formtitle) {$this->formtitle = $this->parse_in("gui_formtitle");}
				$out .= $this->parse_in("gui_main_5");
				break;
			case 2: # header, no aside
				if ($this->formtitle) {$this->formtitle = $this->parse_in("gui_formtitle2");}
				$out .= $this->parse_in("gui_main_2");
				break;
			default: # header, aside
				if ($this->formtitle) {$this->formtitle = $this->parse_in("gui_formtitle");}
				$out .= $this->parse_in("gui_main_1");
				break;
			}
		return $out;
		}

	# parses $data in a template with $key
	# from table html_snippets
	public function parse_in($key) {
		global $db;
		$out = "";
		if (!array_key_exists($key, $this->templates)) {
			$arg = $db->prepare("SELECT `code` FROM `html_snippets` where `key` = ? limit 1;");
			$arg->execute(array($key));
			$template = $arg->fetch(PDO::FETCH_ASSOC);
			$out = $template['code'];
			# echo $key;
			}
		else {$out = $this->templates[$key];}
		if ($out) {
			$out = preg_replace_callback("/&&&&i18n_(\w+)&&&&/", function($m) {return i18n($m[1]);}, $out);
			$out = preg_replace_callback("/&&&&(\w+)&&&&/", function($m){return $this->{$m[1]};}, $out);
			}
		else {$out = "Template $key has not been found!";}
		return $out;
		}
	}

?>
