<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-05-28 18:57:20
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-04-14T14:01:58+02:00
# @License: GPL 2.0


/** just create a page
 * as file as well as dynamic output
 * coco is the consentio 3 content management core class
 */
class coco {
	public $page;
	public $deflang;
	public $all_components = array();
	public $components = array();
	public $templates = array();
	private $website = array();
	private $id;
	private $file;
	private $navbar;
	private $chains = array();
	private $content = array();
	private $temp_set = array();
	private $navbar_ids = array();


	public function __construct(array$form){
		foreach($form as $k=>$v){
			$this->{$k}=$v;
			}
		$this->get_components();
		$this->navbar();
		$this->all_templates();
		}

	public function build_page($data) {
		// choose the right language of prebuilt components and settings
		if ($data['lang'] != $this->deflang) {
			$this->website = my_language($this->defaults, $data['lang']);
			$this->components = my_language($this->all_components, $data['lang']);
			}
		else {$this->website = $this->defaults; $this->components = $this->all_components;}

		if ($this->website['breadcrumb']) {
			$title = $data['short'] ? $data['short'] : cut_text($data['title'], 30);
			$this->breadcrumb($data['parent'], $title, $data['lang']);
			}
		if ($this->website['sub_nav']) {
			switch ($data['type']) {
				case 'folder': $this->components['SUBNAV'] = ""; break;
				default: $this->subnav($data['parent']);
				}
			}
		if (in_array($data['type'], ['folder', 'root'])) {
			$data['body'] = $this->mycontent($data);
			}
		if (in_array($data['type'], ['node', 'link'])) {
			$data['body'] = sys_trans('no_preview', $data['lang'])." <a href=\"{$data['file']}\">{$data['short']}</a>";
			}
		$c = '';
		$tt = $data['type'] == 'serial_page' ? 'cms_pages_title_serial' : $this->temp_set[$data['template']]['title'];
		if ($data['show_title'] == 'on') {$c = $this->parse_in($tt, $data);}
		$t = "pages";
		if (in_array($data['type'], array_keys($this->website['content_types']))) {$t = $data['type'];}
		if ($data['id']) {$c .= "<!-- A=$t ID={$data['id']} -->\n";}
		$c .= $data['body'];
		$this->components['MYCONTENT'] = $c;
		$this->file = $data['file'];
		$root = $data['id'];
		if ($data['parent'] > 0) {
			$ch = array_key_exists($data['parent'], $this->chains) ? $this->chains[$data['parent']] : $this->chain($data['parent']);
			$root = in_array($root, $this->navbar_ids[$data['lang']]) ? $root : $ch[0]['id'];
			}
		$this->components['NAVBAR'] = preg_replace("/nav$root/", "selected", $this->navbar[$data['lang']]);
		$this->scripts = $this->parse_in('cms_scripts', $data);
		$this->add_lightbox($data['lang']);
		$this->components['TIMESTAMP'] = date('Y-m-d H:i:s');
		$this->components['YEAR'] = date('Y');
		$this->components['DATE'] = date('Y-m-d');
		$this->components['VERSION'] = $this->version;
		$this->components['LANG'] = $data['lang'];
		$this->components['DESCRIPTION'] = $data['description'] ? $data['description'] : $this->website['website_description'];
		$this->components['KEYWORDS'] = $data['keywords'] ? $this->merge_keywords($data['keywords']) : $this->website['website_keywords'];
		$this->components['AUTHOR'] = $this->website['website_author'];
		$this->components['CSS'] = $this->website['def_css'];
		$this->components['TITLE'] = $this->website['website_title']." - ".$data['title'];
		$ogi = isset($this->website['website_lead_img']) ? $this->website['website_lead_img'] : $this->website['website_logo'];
		$ogi = $data['picture'] ? $data['picture'] : $ogi;
		$this->components['ogIMAGE'] = $this->website['website_url']."/pictures/normal/$ogi";
		$this->components['SCRIPT'] = $this->scripts;
		if (array_key_exists('head', $data)) {$this->components['SCRIPT'] .= $data['head'];}
		$this->components['CHARSET'] = $this->charset;
		$this->components['totop'] = sys_trans('totop', $data['lang']);
		$this->components['URL'] = $this->website['website_url'].$data['file'];
		$this->components['decURL'] = urlencode($this->components['URL']);
		$this->components['SHARE_BUTTONS'] = $this->parse_in('cms_share_buttons', $this->components);
		$this->components['HEADER'] = $this->parse_in($this->temp_set[$data['template']]['header'], $this->components);
		$this->components['FOOTER'] = $this->parse_in($this->temp_set[$data['template']]['footer'], $this->components);
		$bt = $data['type'] == 'serial_page' ? 'cms_pages_body_serial' : $this->temp_set[$data['template']]['body'];
		$this->page = $this->parse_in($this->temp_set[$data['template']]['head'], $this->components);
		$this->page .= $this->parse_in($bt, $this->components);
		}

	public function save() {
		$html = fopen("$this->cms_dir/$this->file", 'w');
		fwrite($html, $this->page);
		fclose($html);
		}

	public function breadcrumb($rid, $short, $lang) {
		$path['content'] = "";
		$chain = array_key_exists($rid, $this->chains) ? $this->chains[$rid] : $this->chain($rid);
		foreach ($chain as $folder) {
			if ($folder['parent'] == 0) {$folder['file'] = preg_replace('/Sitemap/', 'index', $folder['file']);}
			$path['content'] = $this->parse_in('cms_breadcrumb_item', $folder).$path['content'];
			}
		$path['prolog'] = sys_trans('you_are_here', $lang).":";
		$path['content'] .= " $short";
		$this->components['BREADCRUMB'] = $this->parse_in('cms_breadcrumb', $path);
		}

	public function subnav($rid) {
		$stepdown = array_key_exists($rid, $this->chains) ? $this->chains[$rid] : $this->chain($rid);
		array_pop($stepdown);
		$uls = array();
		$last = 0;
		$sub['content'] = "";
		$sub['id'] = "subnav";
		foreach ($stepdown as $f) {
			$rid = $f['id'];
			$ul  = array_key_exists($rid, $this->content) ? $this->content[$rid] : $this->contents($rid);
			$sub['title'] = $rid;
			$lis = "";
			$ul = array_slice($ul,0,25); // limit!
			foreach ($ul as $item) {
				$subul = $item['id'] == $last ? $uls[$last] : "";
				$lis .= htmltag("li", "", "<a href=\"{$item['file']}\">{$item['title']}</a>$subul");
				}
			if ($lis) {$uls[$rid] = htmltag('ul', '', $lis);}
			$last = $rid;
			$sub['content'] = $uls[$rid];
			$sub['title'] = $f['short'];
			};
		if ($sub['content']) {$this->components['SUBNAV'] = $this->parse_in('cms_subnav', $sub);}
		}

	public function mycontent($data) {
		$rid = $data['id'];
		$content = '';
		if ($data['description']) {$content = $this->parse_in('cms_pages_lead', $data);}
		$ul  = array_key_exists($rid, $this->content) ? $this->content[$rid] : $this->contents($rid);
		$lis = "";
		foreach ($ul as $item) {
			// step down (only) once more, whole map appears to be confusing
			$item['sub'] = "";
			if (in_array($item['type'], ['folder', 'node'])) {
				$ul2  = array_key_exists($item['id'], $this->content) ? $this->content[$item['id']] : $this->contents($item['id']);
				foreach ($ul2 as $item2) {
					$item['sub'] .= htmltag("li", "", "<a href=\"{$item2['file']}\">{$item2['title']}</a>");
					}
				if ($item['sub']) {$item['sub'] = htmltag('ul', '', $item['sub']);}
				$item['content'] = "<p>{$item['description']}</p>{$item['sub']}";
				}
			elseif ($item['type'] == "link") {
				$item['more'] = sys_trans('more', $data['lang']);
				$file_text = '';
				$no = false;
				if (!preg_match('/html?$/', $item['file'])) {$no = true;}
				if (!preg_match("/^https?:\/\//", $item['file'])) {$no = true;}
				if (!$no) {
					$info = file_info($this->cms_dir.$item['file']);
					$file_text = "{$info['icon']} {$info['name']} ({$info['psize']})<br />";
					$item['more'] = sys_trans('download', $data['lang']);
					}
				$more = $this->parse_in('cms_more', $item);
				$item['content'] = "<p>$file_text{$item['description']} $more</p>{$item['sub']}";
				}
			elseif ($item['type'] == "homepage") {unset($item);}
			else {
				$item['more'] = sys_trans('more', $data['lang']);
				$more = $this->parse_in('cms_more', $item);
				$item['content'] = "<p>{$item['description']} $more</p>";
				}
			if (isset($item)) {$lis .= $this->parse_in('cms_folder_listitem', $item);}
			}
		$ulstr = $lis ?  htmltag('ul', 'class="listing"', $lis) : '';
		if ($ulstr) {$content .= $ulstr;}
		return $content;
		}

	public function zero_template($id) {
		$this->temp_set[$id] = [
				'head' => 'cms_head_print',
				'body' => 'cms_pages_body_empty',
				'title' => 'cms_pages_title',
				'header' => '',
				'footer' => ''
				];
		}

	public function alter_template($id, $template) {
		foreach ($template as $k=>$v) {$this->temp_set[$id][$k] = $v;}
		}

	/**
	 * write Sitemap.xml and robots.txt
	 */
	public function sitemap() {
		global $db;
		$sitemap = "<?xml version='1.0' encoding='UTF-8'?>\n<urlset xmlns='http://www.sitemaps.org/schemas/sitemap/0.9'>";
		$q = "SELECT `file`,  `update` FROM `content` WHERE `folder` = 0 AND `published` > 1 order by `parentsort`;";
		$arg = $db->prepare($q);
		$arg->execute();
		while ($item = $arg->fetch(PDO::FETCH_ASSOC)) {
			$url = $this->website['website_url'].$item['file'];
			$sitemap .= "\n\t<url>\n\t\t<loc>$url</loc>\n\t\t<lastmod>{$item['update']}</lastmod>\n\t</url>\n";
			}
		$sitemap .= "\n</urlset>";
		$xml = fopen("$this->cms_dir/Sitemap.xml", 'w');
		fwrite($xml, $sitemap);
		fclose($xml);
		// write robots.txt
		if (!file_exists("$this->cms_dir/robots.txt")) {
			$rob = "User-agent: *\nDisallow: $this->codir/\nSitemap: {$this->website['website_url']}/Sitemap.xml";
			$txt = fopen("$this->cms_dir/robots.txt", 'w');
			fwrite($txt, $rob);
			fclose($txt);
			}
		}

	private function chain($rid) {
		global $db;
		$o = $rid;
		$this->chains[$rid] = array();
		while ($rid) {
			$arg = $db->prepare("SELECT `id`, `short`, `parent`, `file` FROM `folder_view` WHERE `id` = ?;");
			$arg->execute(array($rid));
			$folder = $arg->fetch(PDO::FETCH_ASSOC);
			array_push($this->chains[$o], $folder);
			if ($folder) {$rid = $folder['parent'];}
			else {$rid = false;}
			}
		return $this->chains[$o];
		}

	private function contents($rid) {
		global $db;
		$this->content[$rid] = array();
		$arg = $db->prepare("SELECT * FROM `content` WHERE `parent` = ?  AND `published` > 1 ORDER BY `sort`;");
		$arg->execute(array($rid));
		while ($folder = $arg->fetch(PDO::FETCH_ASSOC)) {
			$desc = $folder['description'];
			$desc = $desc ? $desc : cut_text(co_strip_tags($folder['body']), 280);
			$folder['description'] = $desc;
			array_push($this->content[$rid], $folder);
			}
		return $this->content[$rid];
		}

	private function get_components() {
		global $db;
		$arg = $db->prepare("SELECT `id`, `name`, `content`, `lang`, `custom` FROM `components` WHERE `active` = 'on';");
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($data['custom'] == 'on') {$data['content'] .= "\n<!-- A=components ID={$data['id']} -->";}
			if ($data['lang'] == $this->deflang OR $data['lang'] == '*') {
				$this->all_components[$data['name']] = $data['content'];
				}
			else {
				$k = $data['name']."_".$data['lang'];
				$this->all_components[$k] = $data['content'];
				}
			}
		}

	private function all_templates() {
		global $db;
		$arg = $db->prepare("SELECT `id`, `head`, `body`, `title`, `header`, `footer` FROM `templates`;");
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$this->temp_set[$data['id']] = [
				'head' => $data['head'],
				'body' => $data['body'],
				'title' => $data['title'],
				'header' => $data['header'],
				'footer' => $data['footer']
				];
			}
		}

	private function navbar() {
		global $db, $con;
		$arg = $db->prepare("SELECT `id`, `lang` FROM `content` WHERE `type` = 'root';");
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$nav = $this->get_nav_array($data['id'], $data['lang']);
			$c['hidden_name'] = sys_trans('mainnav', $data['lang']);
			$c['content'] = '';
			$count = 1;
			$this->navbar_ids[$data['lang']] = array();
			foreach ($nav as $k=>$item) {
				array_push($this->navbar_ids[$data['lang']], $item['id']);
				$item['count'] = $count;
				$item['sub'] = '';
				if ($item['folder'] == 1) {
					$sub = $this->get_nav_array($item['id'], $data['lang']);
					foreach ($sub as $k=>$item2) {
						$item['sub'] .= $this->parse_in('cms_navbar_item2', $item2);
						}
					if ($sub) {$item['sub'] = $this->parse_in('cms_navbar2', $item);}
					}
				$c['content'] .= $this->parse_in('cms_navbar_item', $item);
				$count++;
				}
			$this->navbar[$data['lang']] = $this->parse_in('cms_navbar', $c);
			}
		}

	private function get_nav_array($id, $l) {
		global $db, $html;
		$query = "SELECT `id`, `short`, `file`, `folder`, `type`, `generate` FROM `content` WHERE `published` = 3 AND  `lang` = ? AND `parent` = ? ORDER BY `sort`;";
		$content = array();
		$arg = $db->prepare($query);
		$arg->execute(array($l, $id));
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			//$data['target'] = $data['type'] == 'link' ? ' target="_blank"' : '';
			$data['target'] = preg_match("/^https?:\/\//", $data['file']) ? ' target="_blank"' : '';
			if ($data['type'] == 'homepage' && $this->defaults['skip_home'] == 'on') {}
			elseif ($data['generate'] == 0 && !in_array($data['type'], ['link', 'node', 'webshop', 'goodsgroup'])){}
			else {array_push($content, $data);}
			}
		return $content;
		}

	private function merge_keywords($w) {
		$common = explode(",", $this->website['website_keywords']);
		$special = explode(",", $w);
		$merged = array_merge($special, $common);
		$merged = array_slice($merged, 0, 19);
		$merged = array_map('trim', $merged);
		$merged =  implode(", ", $merged);
		return $merged;
		}

	private function add_lightbox($lang) {
		if (preg_match('/lightbox/', $this->components['MYCONTENT'])) {
			// ok this is not precise science, but it won't hurt to be embedded the lightbox without any real lightbox-element
			$data = ['p' => sys_trans('previous', $lang), 'n' => sys_trans('next', $lang), 'c' => sys_trans('close', $lang), 'i' => sys_trans('picture', $lang)];
			$this->scripts .= $this->parse_in('cms_pages_lightbox', $data);
			}
		}

	# parses $data in a template with $key
	# from table html_snippets
	private function parse_in($key, $data) {
		global $db;
		$out = "";
		if (!array_key_exists($key, $this->templates)) {
			$arg = $db->prepare("SELECT `code` FROM `html_snippets` where `key` = ? limit 1;");
			$arg->execute(array($key));
			$template = $arg->fetch(PDO::FETCH_ASSOC);
			if ($template) {
				$out = $template['code'];
				$this->templates[$key] = $out;
				}
			}
		else {$out = $this->templates[$key];}
		if ($out) {
			$out = preg_replace_callback("/&&&&(\w+)&&&&/",
			function($m) use ($data) {
				$a = '';
				if (array_key_exists($m[1], $data)) {$a = $data[$m[1]];}
				return $a;
				}, $out);}
		else {$out = "&mdash; Template $key has not been found! &mdash;";}
		return $out;
		}
	}

?>
